<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Site\Helper\Dashboard;

use Joomla\CMS\Factory;
use Balbooa\Component\Gridbox\Site\Interface\DashboardInterface;
use Balbooa\Component\Gridbox\Site\Interface\DashboardItemsInterface;

class CommentsHelper implements DashboardInterface, DashboardItemsInterface
{
    public static function make() :static
    {
        return new static();
    }
    
    public function getItems() :array
    {
        $db = Factory::getDbo();
        $query = $db->getQuery(true)
            ->select('c.*, p.title, u.email AS user_email')
            ->from('#__gridbox_comments AS c')
            ->leftJoin('#__users AS u ON u.id = c.user_id')
            ->leftJoin('`#__gridbox_pages` AS p ON p.id = c.page_id')
            ->order('id desc');
        $db->setQuery($query, 0, 10);
        $items = $db->loadObjectList();
        
        return $items;
    }
}