<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Site\Helper\Dashboard;

use Joomla\CMS\Factory;
use Balbooa\Component\Gridbox\Site\Interface\DashboardInterface;
use Balbooa\Component\Gridbox\Site\Interface\DashboardItemsInterface;

class PagesHelper implements DashboardInterface, DashboardItemsInterface
{
    public static function make() :static
    {
        return new static();
    }
    
    public function getItems($sorting = 'saved_time') :array
    {
        $db = Factory::getDbo();
        $query = $db->getQuery(true);
        $query->select('p.id, p.title, p.hits, p.page_category, p.intro_image, a.type')
            ->from('#__gridbox_pages AS p')
            ->where('p.page_category <> '.$db->quote('trashed'))
            ->leftJoin('#__gridbox_app AS a ON p.app_id = a.id')
            ->order('p.' . $sorting . ' DESC');
        $db->setQuery($query, 0, 10);
        $items = $db->loadObjectList();
        
        return $items;
    }
}