<?php
/**
 * @package   Gridbox
 * @author    Balbooa http://www.balbooa.com/
 * @copyright Copyright @ Balbooa
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace Balbooa\Component\Gridbox\Site\Helper;

use DateTime;
use DateTimeZone;
use Joomla\CMS\Factory;

class DateHelper
{
    protected static ?DateTimeZone $defaultTimeZone = null;

    public static function make(string $date = 'now'): DateTime
    {
        $timezone = self::prepareTimezone();
        $date = is_numeric($date) ? date('c', $date) : $date;

        return new DateTime($date, $timezone);
    }

    protected static function prepareTimezone(): DateTimeZone
    {
        if (! self::$defaultTimeZone) {
            $config = Factory::getConfig();
            self::$defaultTimeZone = new DateTimeZone($config->get('offset'));
        }

        return self::$defaultTimeZone;
    }
}