<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Site\Helper;

abstract class FileHelper
{
    public static array $imageTypes = ['jpg', 'png', 'gif', 'svg', 'jpeg', 'ico', 'webp'];

    public static function getImagePath():string
    {
        return GridboxHelper::$website->image_path;
    }

    public static function imageSave(string $type):string
    {
        switch ($type) {
            case 'png':
                $imageSave = 'imagepng';
                break;
            case 'gif':
                $imageSave = 'imagegif';
                break;
            case 'webp':
                $imageSave = 'imagewebp';
                break;
            default:
                $imageSave = 'imagejpeg';
        }

        return $imageSave;
    }

    public static function imageCreate(string $type):string
    {
        switch ($type) {
            case 'png':
                $imageCreate = 'imagecreatefrompng';
                break;
            case 'gif':
                $imageCreate = 'imagecreatefromgif';
                break;
            case 'webp':
                $imageCreate = 'imagecreatefromwebp';
                break;
            default:
                $imageCreate = 'imagecreatefromjpeg';
        }

        return $imageCreate;
    }

    public static function readFile(string $path): string
    {
        if (!is_file($path)) {
            return '';
        }
        $handle = fopen($path, "r");
        $size = filesize($path);
        $content = '';
        if (!empty($size) && $handle) {
            $content = fread($handle, $size);
            fclose($handle);
        }

        return $content;
    }

    public static function getTypes():array
    {
        $array = explode(',', GridboxHelper::$website->file_types);
        foreach ($array as $key => $value) {
            $array[$key] = strtolower(trim($value));
        }

        return $array;
    }

    public static function getFileSize(int $size):string
    {
        $size = floor($size / 1024);
        if ($size >= 1024) {
            $size = floor($size / 1024);
            $filesize = (string)$size .' MB';
        } else {
            $filesize = (string)$size .' KB';
        }

        return $filesize;
    }
}