<?php
/**
 * @package   Gridbox
 * @author    Balbooa http://www.balbooa.com/
 * @copyright Copyright @ Balbooa
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace Balbooa\Component\Gridbox\Site\Helper\HtmlPlugins;

use Balbooa\Component\Gridbox\Site\Helper\GridboxHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;

class MainMenu
{
    public static function checkMainMenu(string $body): string
    {
        $regex = '/\[main_menu=+(.*?)]/i';
        $app = Factory::getApplication();
        $view = $app->input->getCmd('view', '');
        preg_match_all($regex, $body, $matches, PREG_SET_ORDER);
        if (!$matches) {
            return $body;
        }
        foreach ($matches as $index => $match) {
            $module = $match[1];
            if (!isset($module)) {
                continue;
            }
            $db = Factory::getDBO();
            $query = $db->getQuery(true)
                ->select('*')
                ->from('#__modules')
                ->where('client_id = 0')
                ->where('published = 1')
                ->where('module = '.$db->quote('mod_menu'))
                ->where('id = ' . $db->quote($module));
            $query->order('ordering');
            $db->setQuery($query);
            $module = $db->loadObject();
            $access = GridboxHelper::checkModuleAccess($module);
            if ($access) {
                $document = Factory::getDocument();
                $document->_type = 'html';
                $renderer = $document->loadRenderer('module');
                $html = $renderer->render($module);
                $html .= '<div class="ba-edit-item"><span class="ba-edit-wrapper edit-settings">';
                $html .= '<i class="zmdi zmdi-settings"></i><span class="ba-tooltip tooltip-delay">';
                $html .= Text::_('ITEM').'</span></span><div class="ba-buttons-wrapper">';
                $html .= '<span class="ba-edit-wrapper"><i class="zmdi zmdi-edit edit-mobile-menu-item"></i>';
                $html .= '<span class="ba-tooltip tooltip-delay settings-tooltip">'.Text::_('EDIT').'</span></span></div></div>';
            } else {
                $html = '';
            }
            if (!empty($html) || $view != 'gridbox') {
                $body = @preg_replace("|\[main_menu=".$match[1]."]|", $html, $body, 1);
            }
        }

        return $body;
    }

    protected static function getMenuItemAlias(int $id): ?string
    {
        $db = Factory::getDBO();
        $query = $db->getQuery(true)
            ->select('alias')
            ->from('#__menu')
            ->where('id = '. $id);
        $db->setQuery($query);
        $alias = $db->loadResult();

        return $alias;
    }

    protected static function prepareUrlItems($value): void
    {
        foreach (pq($value)->find('li') as $li) {
            $className = pq($li)->attr('class');
            preg_match('/item-\d+/', $className, $matches);
            if (empty($matches)) {
                continue;
            }
            $a = pq($li)->find('a');
            $href = pq($a)->attr('href');
            if (!strpos($href, '#') || !str_contains($href, 'option=com_gridbox')) {
                continue;
            }
            list($href, $hash) = explode('#', $href, 2);
            $href = GridboxHelper::prepareGridboxLinks($href);
            if (!str_contains($href, 'index.php')) {
                $href = 'index.php?' . $href;
            }

            preg_match('/\d+/', $matches[0], $itemId);
            $menuId = (int) $itemId[0];
            $alias = self::getMenuItemAlias($menuId);
            $href .= '#' . $alias;
            pq($a)->attr('href', $href);
            pq($a)->attr('data-anchor', $hash);
            pq($a)->attr('data-alias', $alias);
        }
    }

    protected static function prepareMenuItems($value, $obj, $menuId):void
    {
        if (!isset($obj->{$menuId}->items)) {
            return;
        }
        foreach ($obj->{$menuId}->items as $key => $item) {
            $li = pq($value)->find('li.item-'.$key.':first');
            if (!empty($item->icon)) {
                pq($li)->find(' > a, > span')
                    ->prepend('<i class="ba-menu-item-icon '.$item->icon.'"></i>');
            }
            if (!$item->megamenu) {
                continue;
            }
            pq($li)->addClass('megamenu-item');
            pq($li)->addClass('deeper');
            pq($li)->addClass('parent');
            pq($li)->append(pq('#'.$menuId.' .ba-wrapper[data-megamenu="item-'.$key.'"]'));
        }
    }

    protected static function prepareMenuClasses($value, $obj, $menuId): void
    {
        $i = '<i class="ba-icons ba-icon-caret-right"></i>';
        pq($value)->find('li.deeper.parent')->find('> a, > span')
            ->find('> i.ba-icon-caret-right')->remove();
        pq($value)->find('li.deeper.parent')->find('> a, > span')->append($i);
        $wrapper = pq($value)->find(' > .ba-menu-wrapper');
        pq($wrapper)->removeClass('ba-menu-position-left');
        pq($wrapper)->removeClass('ba-hamburger-menu');
        pq($wrapper)->removeClass('ba-menu-position-center');
        pq($wrapper)->removeClass('ba-collapse-submenu');
        if ($obj->{$menuId}->hamburger->enable) {
            pq($wrapper)->addClass('ba-hamburger-menu');
        }
        if (isset($obj->{$menuId}->hamburger->collapse) && $obj->{$menuId}->hamburger->collapse) {
            pq($wrapper)->addClass('ba-collapse-submenu');
        }
        pq($wrapper)->addClass($obj->{$menuId}->hamburger->position);
    }

    public static function render(object $obj): void
    {
        foreach (pq('.ba-item-main-menu') as $value) {
            $menuId = pq($value)->attr('id');
            pq($value)->find('> .ba-menu-backdrop')->remove();
            pq($value)->append('<div class="ba-menu-backdrop"></div>');
            if (!isset($obj->{$menuId}->desktop->dropdown)) {
                $effect = 'fadeInUp';
            } else {
                $effect = $obj->{$menuId}->desktop->dropdown->animation->effect;
            }
            pq($value)->find('li.deeper.parent > ul')->addClass($effect);
            self::fixMenuItems($value);
            self::prepareUrlItems($value);
            self::prepareMenuItems($value, $obj, $menuId);
            self::prepareMenuClasses($value, $obj, $menuId);
        }
    }

    static function fixMenuItems($item): void
    {
        foreach (pq($item)->find('li') as $li) {
            $button = pq($li)->find('> button');
            if (!$button) {
                continue;
            }
            $span = pq($button)->find('span.separator, span.nav-header');
            if ($span) {
                $button->before($span);
            }
            $button->remove();
        }
    }
}