<?php
/**
 * @package   Gridbox
 * @author    Balbooa http://www.balbooa.com/
 * @copyright Copyright @ Balbooa
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace Balbooa\Component\Gridbox\Site\Helper\HtmlPlugins;

use Balbooa\Component\Gridbox\Site\Helper\GridboxHelper;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;

class PostNavigation
{
    protected static string $rendered;
    protected static array $digital;

    public static function render(object $obj): void
    {
        foreach (pq('.ba-item-post-navigation') as $item) {
            $itemId = pq($item)->attr('id');
            GridboxHelper::$editItem = $obj->{$itemId};
            $maximum = GridboxHelper::$editItem->maximum;
            $str = self::getPostNavigation($maximum);
            pq($item)->find('.ba-blog-posts-wrapper')->html($str);
            pq($item)->find('.ba-blog-posts-wrapper > i')->remove();
            pq($item)
                ->find('.post-navigation-previous')
                ->find('.ba-post-navigation-info a')->text(Text::_('PREVIOUS'));
            pq($item)
                ->find('.post-navigation-next')
                ->find('.ba-post-navigation-info a')->text(Text::_('NEXT'));

        }
    }

    protected static function getPost(int $id, object $obj, string $where, $orderDir = 'desc'): ?object
    {
        $db = Factory::getDbo();
        $nullDate = $db->quote($db->getNullDate());
        if (!empty(static::$digital)) {
            $digital = static::$digital;
        } else {
            $digital = GridboxHelper::getSubscriptionProducts();
            static::$digital = $digital;
        }
        $user = Factory::getUser();
        $levels = $user->getAuthorisedViewLevels();
        $groups = implode(',', $levels);
        $date = date("Y-m-d H:i:s");
        $query = $db->getQuery(true)
            ->select('p.id, p.title, p.intro_text, p.created, p.intro_image, p.page_category, p.app_id,
                c.title as category, a.type, p.hits')
            ->from('#__gridbox_pages AS p')
            ->where('p.id <> '.$id)
            ->where('p.app_id = '.$obj->app_id)
            ->where('p.page_category <> '.$db->quote('trashed'))
            ->where('p.published = 1')
            ->where($where)
            ->where('p.created <= '.$db->quote($date))
            ->where('(p.end_publishing = '.$nullDate.' OR p.end_publishing >= '.$db->quote($date).')')
            ->where('p.language in ('.$db->quote(Factory::getLanguage()->getTag()).','.$db->quote('*').')')
            ->where('p.page_access in ('.$groups.')')
            ->order('p.created ' . $orderDir)
            ->leftJoin('`#__gridbox_categories` AS c ON p.page_category = c.id')
            ->leftJoin('`#__gridbox_app` AS a ON p.app_id = a.id')
            ->where('c.published = 1')
            ->where('c.language in ('.$db->quote(Factory::getLanguage()->getTag()).','.$db->quote('*').')')
            ->where('c.access in ('.$groups.')');
        if (!empty($digital)) {
            $str = implode(', ', $digital);
            $query->where('p.id NOT IN ('.$str.')');
        }
        $db->setQuery($query);
        $prev = $db->loadObject();

        return $prev;
    }

    public static function getPostNavigation(int $max, ?int $id = null): string
    {
        if (!$id) {
            $app = Factory::getApplication();
            $id = $app->input->get('id', 0, 'int');
            $option = $app->input->getCmd('option', '');
            $view = $app->input->getCmd('view', '');
            if ($option != 'com_gridbox' || $view == 'blog') {
                return '';
            }
        }
        if (!empty(static::$rendered)) {
            return static::$rendered;
        }
        $db = Factory::getDbo();
        $input = Factory::getApplication()->input;
        $edit_type = $input->get('edit_type', '', 'string');
        if ($edit_type == 'post-layout') {
            $page = GridboxHelper::getPostLayoutPage($id);
            if ($page) {
                $id = $page->id;
            } else {
                $id = 0;
            }
        }
        $query = $db->getQuery(true)
            ->select('created, app_id')
            ->from('#__gridbox_pages')
            ->where('id = ' . $id);
        $db->setQuery($query);
        $obj = $db->loadObject();
        if (empty($obj->app_id)) {
            return GridboxHelper::getEmptyList();
        }

        $prev = static::getPost($id, $obj, 'p.created >= ' . $db->quote($obj->created), 'asc');
        $next = static::getPost($id, $obj, 'p.created <= ' . $db->quote($obj->created));

        $html = '';
        include JPATH_ROOT.'/components/com_gridbox/tmpl/layout/blog-posts.php';
        /** @var string $out */
        if ($prev) {
            $html .= GridboxHelper::getRecentPostsHTML($prev, $out, $max, 'post-navigation-previous');
        }
        if ($next) {
            $html .= GridboxHelper::getRecentPostsHTML($next, $out, $max, 'post-navigation-next');
        }
        if (empty($html)) {
            $html = GridboxHelper::getEmptyList();
        }
        static::$rendered = $html;

        return $html;
    }
}