<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Site\Model;

use Balbooa\Component\Gridbox\Site\Helper\GridboxHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Model\ItemModel;

defined('_JEXEC') or die;

class BaformsModel extends ItemModel
{
    public function getTable($type = 'Pages', $prefix = 'Site', $config = []) 
    {
        return parent::getTable($type, $prefix, $config);
    }

    public function getItem($pk = null)
    {
        
    }

    public function getItems()
    {
        $id = GridboxHelper::getComBa('com_baforms');
        if (!$id) {
            return [];
        }
        $db = Factory::getDbo();
        $input = Factory::getApplication()->input;
        $baforms_search = $input->cookie->get('baforms_search', '', 'string');
        $query = $db->getQuery(true)
            ->select('id, title')
            ->from('`#__baforms_forms`')
            ->where('`published` = 1');
        if (!empty($baforms_search)) {
            $query->where('title LIKE '.$db->quote('%'.$db->escape($baforms_search, true).'%'));
        }
        $orderCol = $input->cookie->get('baforms_ordering', 'id', 'string');
        $orderDirn = $input->cookie->get('baforms_direction', 'desc', 'string');
        $query->order($db->escape($orderCol . ' ' . $orderDirn));
        $db->setQuery($query);
        $items = $db->loadObjectList();
        
        return $items;
    }
}