<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Site\Model;

use Balbooa\Component\Gridbox\Site\Helper\GridboxHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Model\ItemModel;

defined('_JEXEC') or die;

class BagalleryModel extends ItemModel
{
    public function getTable($type = 'pages', $prefix = 'gridboxTable', $config = []) 
    {
        return parent::getTable($type, $prefix, $config);
    }

    public function getItem($pk = null)
    {
        
    }

    protected function setModelFilters()
    {
        $app = Factory::getApplication();
        $cookie = $app->getInput()->cookie;
        $search = $cookie->get('bagallery_search', '', 'string');
        $order = $cookie->get('bagallery_ordering', 'id', 'string');
        $dir = $cookie->get('bagallery_direction', 'desc', 'string');
        $this->setGalleryContextState($app, $search, $order, $dir);
        $this->setGalleryContextState($app, $search, $order, $dir, 'com_bagallery');
    }

    protected function setGalleryContextState($app, $search, $order, $dir, $context = 'com_gallery')
    {
        $app->setUserState($context . '.galleries.filter.search', $search);
        $app->setUserState($context . '.galleries.filter.published', 1);
        $app->setUserState($context . '.galleries.list.ordering', $order);
        $app->setUserState($context . '.galleries.list.direction', $dir);
    }

    public function getItems()
    {
        if (!class_exists('Balbooa\Component\Gallery\Site\Model\GalleriesModel')) {
            return [];
        }
        $model = new \Balbooa\Component\Gallery\Site\Model\GalleriesModel();
        $this->setModelFilters();

        return $model->getItems();
    }
}