<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Site\Model;

defined('_JEXEC') or die;

use Balbooa\Component\Forms\Site\Helper\BaformsHelper;
use Balbooa\Component\Gallery\Site\Helper\GalleryHelper;
use Balbooa\Component\Gridbox\Administrator\Helper\Filesystem\File;
use Balbooa\Component\Gridbox\Administrator\Helper\Filesystem\Folder;
use Balbooa\Component\Gridbox\Site\Enums\Finder\FinderEvents;
use Balbooa\Component\Gridbox\Site\Helper\FileHelper;
use Balbooa\Component\Gridbox\Site\Helper\GridboxHelper;
use Balbooa\Component\Gridbox\Site\Helper\GridboxHtmlHelper;
use Balbooa\Component\Gridbox\Site\Helper\SeoHelper;
use Balbooa\Component\Gridbox\Site\Service\EventDispatcher;
use Joomla\CMS\Cache\Cache;
use Joomla\CMS\Factory;
use Joomla\CMS\Form\Form;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Model\ItemModel;
use Joomla\CMS\Uri\Uri;

class EditorModel extends ItemModel
{
    public function submitNewItem($data)
    {
        $id = $data['id'];
        $app_id = $data['app_id'];
        $page_id = $data['page_id'];
        $title = $data['title'];
        $category = $data['category'];
        $image = $description = '';
        $user = Factory::getUser();
        $form = GridboxHelper::getSystemParams($id);
        $options = json_decode($form->page_options);
        $groups = $user->getAuthorisedViewLevels();
        if (!in_array($options->access, $groups)) {
            return;
        }
        unset($data['id']);
        unset($data['app_id']);
        unset($data['page_id']);
        unset($data['title']);
        unset($data['category']);
        if (isset($data['image'])) {
            $image = $data['image'];
        }
        if (isset($data['description'])) {
            $description = $data['description'];
            unset($data['description']);
        }
        $db = Factory::getDbo();
        $query = $db->getQuery(true)
            ->select('theme')
            ->from('#__gridbox_app')
            ->where('id = '.$app_id);
        $db->setQuery($query);
        $theme = $db->loadResult();
        $title = strip_tags($title['value']);
        $alias = GridboxHelper::getAlias($title, '#__gridbox_pages', 'page_alias', $page_id);
        $category = intval($category['value']);
        if (!empty($image)) {
            $obj = json_decode($image['value']);
            $image = $obj->src;
        }
        if (!empty($description)) {
            $description = strip_tags($description['value']);
        }
        $nowDate = date("Y-m-d H:i:s");
        $page = new \stdClass();
        $page->style = '{}';
        $page->params = '';
        $page->title = $title;
        $page->page_alias = $alias;
        $page->page_category = $category;
        $page->app_id = $app_id;
        $page->theme = $theme;
        $page->created = $nowDate;
        $page->intro_image = $image;
        $page->intro_text = $description;
        $page->user_id = $user->id;
        if (!empty($page_id)) {
            $page->id = $page_id;
            $db->updateObject('#__gridbox_pages', $page, 'id');
        } else {
            $page->published = $options->premoderation ? 0 : 1;
            $db->insertObject('#__gridbox_pages', $page);
            $page->id = $db->insertid();
        }
        $fields = [];
        $tags = [];
        $hasTags = false;
        foreach ($data as $field) {
            if ($field['type'] == 'tag') {
                $hasTags = true;
                $tags = json_decode($field['value']);
                continue;
            }
            if ($field['type'] == 'image-field') {
                $obj = json_decode($field['value']);
                if (is_numeric($obj->src)) {
                    $this->setDesktopFiles($obj->src, $page->id);
                }
            } else if ($field['type'] == 'field-simple-gallery' || $field['type'] == 'field-slideshow') {
                $images = json_decode($field['value']);
                foreach ($images as $object) {
                    if (is_numeric($object->img)) {
                        $this->setDesktopFiles($object->img, $page->id);
                    }
                }
            } else if ($field['type'] == 'field-video') {
                $obj = json_decode($field['value']);
                if (!empty($obj) && is_numeric($obj->file)) {
                    $this->setDesktopFiles($obj->file, $page->id);
                }
            } else if ($field['type'] == 'file' && is_numeric($field['value'])) {
                $this->setDesktopFiles($field['value'], $page->id);
            }
            if ($field['type'] == 'checkbox' || $field['type'] == 'url' || $field['type'] == 'field-button' || $field['type'] == 'image-field') {
                $field['value'] = json_decode($field['value']);
            }
            $fields[] = (object)$field;
        }
        GridboxHelper::savePageFields($fields, $page->id);
        if ($hasTags) {
            GridboxHelper::saveMetaTags($tags, $page->id);
        }
        if ($options->author) {
            $this->setAuthor($user, $page->id);
        }
        if (empty($page_id)) {
            $obj = new \stdClass();
            $obj->page_id = $page->id;
            $obj->submission_form = $id;
            $obj->sended_published = $options->premoderation ? 0 : 1;
            $db->insertObject('#__gridbox_submitted_items', $obj);
        }
        if (empty($page_id) && $options->emails && $options->submited_email) {
            $this->sendModeratorEmail($user->username, $page->title);
        }
        print_r($fields);exit;
    }

    public function setAuthor($user, $page_id)
    {
        $db = Factory::getDbo();
        $query = $db->getQuery(true)
            ->select('*')
            ->from('#__gridbox_authors')
            ->where('user_id = '.$user->id);
        $db->setQuery($query);
        $author = $db->loadObject();
        if (!$author) {
            $author = new \stdClass();
            $author->id = 0;
            $author->title = $user->name;
            $author->user_id = $user->id;
            $author->author_social = '{}';
            $author->alias = $user->username;
            $author->alias = GridboxHelper::getAlias($author->alias, '#__gridbox_authors', 'alias');
            $db->insertObject('#__gridbox_authors', $author);
            $author->id = $db->insertid();
        }
        $query = $db->getQuery(true)
            ->select('COUNT(id)')
            ->from('#__gridbox_authors_map')
            ->where('page_id = '.$page_id)
            ->where('author_id = '.$author->id);
        $db->setQuery($query);
        $count = $db->loadResult();
        if ($count == 0) {
            $obj = new \stdClass();
            $obj->page_id = $page_id;
            $obj->author_id = $author->id;
            $db->insertObject('#__gridbox_authors_map', $obj);
        }
    }

    public function sendModeratorEmail($username, $title)
    {
        try {
            $mailer = Factory::getMailer();
            $config = Factory::getConfig();
            $sitename = $config->get('sitename');
            $subject = Text::_('THE_NEW_ITEM_SUBMITTED_ON').' '.$sitename;
            $sender = [$config->get('mailfrom'), $config->get('fromname')];
            $recipient = $config->get('mailfrom');
            $message = Text::_('THE_NEW_ITEM_SUBMITTED_BY_USER');
            $message = str_replace('{USERNAME}', $username, $message);
            $mailer->isHTML(true);
            $mailer->Encoding = 'base64';
            include(JPATH_ROOT.'/components/com_gridbox/tmpl/layout/patterns/submission-form/moderator-email-pattern.php');
            $mailer->setSender($sender);
            $mailer->setSubject($subject);
            $mailer->addRecipient($recipient);
            $mailer->setBody($out);
            $mailer->Send();
        } catch (\Exception $e) {
            
        }
    }


    public function setDesktopFiles($id, $page_id)
    {
        $db = Factory::getDbo();
        $query = $db->getQuery(true)
            ->update('#__gridbox_fields_desktop_files')
            ->where('id = '.$id)
            ->set('page_id = '.$page_id);
        $db->setQuery($query)
            ->execute();
    }

    public function getTable($type = 'Pages', $prefix = 'Site', $config = []) 
    {
        return parent::getTable($type, $prefix, $config);
    }

    public function renameVersionsHistory($id, $title)
    {
        $db = Factory::getDbo();
        $query = $db->getQuery(true)
            ->update('#__gridbox_pages_versions')
            ->set('title = '.$db->quote($title))
            ->where('id = '.$id);
        $db->setQuery($query)
            ->execute();
    }

    public function deleteVersionsHistory($id)
    {
        $db = Factory::getDbo();
        $query = $db->getQuery(true)
            ->delete('#__gridbox_pages_versions')
            ->where('id = '.$id);
        $db->setQuery($query)
            ->execute();
    }

    public function getVersionsHistory($id)
    {
        $db = Factory::getDbo();
        $query = $db->getQuery(true)
            ->select('*')
            ->from('#__gridbox_pages_versions')
            ->where('page_id = '.$id)
            ->order('id DESC');
        $db->setQuery($query);
        $items = $db->loadObjectList();

        return $items;
    }

    public function cleanupVersionsHistory()
    {
        $db = Factory::getDbo();
        $query = $db->getQuery(true)
            ->delete('#__gridbox_pages_versions')
            ->where('1');
        $db->setQuery($query)
            ->execute();
    }

    public function getPageFields()
    {
        $app = Factory::getApplication();
        $db = Factory::getDbo();
        $id = $app->input->get('id', '');
        $query = $db->getQuery(true)
            ->select('f.*')
            ->from('#__gridbox_fields AS f')
            ->leftJoin('#__gridbox_pages AS p ON p.app_id = f.app_id')
            ->where('p.id = '.$id)
            ->order('f.order_list DESC')
            ->where('f.field_type <> '.$db->quote('field-simple-gallery'))
            ->where('f.field_type <> '.$db->quote('field-slideshow'))
            ->where('f.field_type <> '.$db->quote('product-gallery'))
            ->where('f.field_type <> '.$db->quote('product-slideshow'))
            ->where('f.field_type <> '.$db->quote('field-google-maps'))
            ->where('f.field_type <> '.$db->quote('field-video'))
            ->where('f.field_type <> '.$db->quote('image-field'))
            ->where('f.field_type <> '.$db->quote('tag'))
            ->where('f.field_type <> '.$db->quote('field-button'));
        $db->setQuery($query);
        $fields = $db->loadObjectList();
        $data = new \stdClass();
        foreach ($fields as $field) {
            $params = json_decode($field->options);
            $field->params = $params;
            $field->title = !empty($field->label) ? $field->label : $params->label;
            $data->{$field->field_key} = $field;
        }

        return $data;
    }

    public function getDefaultsSeo($id, $type)
    {
        $db = Factory::getDbo();
        $item = new \stdClass();
        $item->app_id = $id;
        if ($type == 'page') {
            $query = $db->getQuery(true)
                ->select('type')
                ->from('#__gridbox_app')
                ->where('id = '.$id);
            $db->setQuery($query);
            $item->app_type = $db->loadResult();
        }
        $seo = new SeoHelper($item, $type);
        $global = $seo->getGlobal();

        return $global;
    }

    public function setDefaultsSeo($seo)
    {
        $db = Factory::getDbo();
        if (empty($seo->id)) {
            $db->insertObject('#__gridbox_seo_defaults', $seo);
        } else {
            $db->updateObject('#__gridbox_seo_defaults', $seo, 'id');
        }
    }

    public function getHTMLHelper($dir = '')
    {
        $html = new GridboxHtmlHelper($dir);

        return $html;
    }

    public function getIntegrations()
    {
        $db = Factory::getDbo();
        $query = $db->getQuery(true)
            ->select('*')
            ->from('#__gridbox_api')
            ->where('type = '.$db->quote('integration'));
        $db->setQuery($query);
        $array = $db->loadObjectList();
        $integrations = new \stdClass();
        foreach ($array as $obj) {
            $integrations->{$obj->service} = $obj;
        }

        return $integrations;
    }

    public function checkAppFields($id)
    {
        $db = Factory::getDbo();
        $query = $db->getQuery(true)
            ->select('type')
            ->from('#__gridbox_app')
            ->where('id = '.$id);
        $db->setQuery($query);
        $type = $db->loadResult();

        return $type ? $type : '';
    }

    public function getProductData()
    {
        $input = Factory::getApplication()->input;
        $id = $input->get('id', 0, 'int');
        $product = GridboxHelper::$storeHelper->getPreparedProductData($id);
        
        return $product;
    }

    public function getProductOptions()
    {
        $db = Factory::getDbo();
        $query = $db->getQuery(true)
            ->select('*')
            ->from('#__gridbox_store_products_fields');
        $db->setQuery($query);
        $array = $db->loadObjectList();

        return $array;
    }

    public function getPageAppId($id)
    {
        $db = Factory::getDbo();
        $query = $db->getQuery(true)
            ->select('app_id')
            ->from('#__gridbox_pages')
            ->where('id = '.$id);
        $db->setQuery($query);
        $app_id = $db->loadResult();

        return $app_id;
    }

    public function uploadFile($file, $app_id, $id)
    {
        $ext = strtolower(File::getExt($file['name']));
        $dir = JPATH_ROOT.'/components/com_gridbox/assets/uploads/app-'.$app_id.'/';
        if (!Folder::exists($dir)) {
            Folder::create($dir);
        }
        $name = str_replace('.'.$ext, '', $file['name']);
        $filename = GridboxHelper::replace($name);
        $filename = File::makeSafe($filename);
        $name = str_replace('-', '', $filename);
        $name = str_replace('.', '', $name);
        if ($name == '') {
            $filename = date("Y-m-d-H-i-s").'.'.$ext;
        }
        $i = 2;
        $name = $filename;
        while (File::exists($dir.$name.'.'.$ext)) {
            $name = $filename.'-'.($i++);
        }
        $filename = $name.'.'.$ext;
        File::upload($file['tmp_name'], $dir.$filename);
        $obj = $this->addDesktopFieldFile($file['name'], $filename, $id, $app_id);
        $obj->path = 'components/com_gridbox/assets/uploads/app-'.$app_id.'/'.$filename;

        return $obj;
    }

    public function uploadSubmissionFile($file, $app_id)
    {
        $obj = new \stdClass();
        $id = 0;
        if (isset($file['error']) && $file['error'] == 0) {
            $obj = $this->uploadFile($file, $app_id, $id);
        } else {
            $obj->error = 'ba-alert';
            $obj->msg = Text::_('NOT_ALLOWED_FILE_SIZE');
        }

        return $obj;
    }

    public function uploadDesktopFieldFile($file, $id)
    {
        $obj = new \stdClass();
        if (isset($file['error']) && $file['error'] == 0) {
            $app_id = $this->getPageAppId($id);
            $obj = $this->uploadFile($file, $app_id, $id);
        } else {
            $obj->error = 'ba-alert';
            $obj->msg = Text::_('NOT_ALLOWED_FILE_SIZE');
        }

        return $obj;
    }

    public function addDesktopFieldFile($name, $filename, $id, $app_id)
    {
        $db = Factory::getDbo();
        $obj = new \stdClass();
        $obj->page_id = $id;
        $obj->app_id = $app_id;
        $obj->name = $name;
        $obj->filename = $filename;
        $obj->date = date("Y-m-d-H-i-s");
        $db->insertObject('#__gridbox_fields_desktop_files', $obj);
        $obj->id = $db->insertid();
        if ($id == 0) {
            $obj->alt = File::stripExt($name);
        }

        return $obj;
    }

    public function removeDesktopFieldFile($id)
    {
        $db = Factory::getDbo();
        $query = $db->getQuery(true)
            ->select('*')
            ->from('#__gridbox_fields_desktop_files')
            ->where('id = '.$id);
        $db->setQuery($query);
        $obj = $db->loadObject();
        if ($obj) {
            $dir = JPATH_ROOT.'/components/com_gridbox/assets/uploads/app-'.$obj->app_id.'/'.$obj->filename;
            File::delete($dir);
            $query = $db->getQuery(true)
                ->delete('#__gridbox_fields_desktop_files')
                ->where('id = '.$id);
            $db->setQuery($query)
                ->execute();
        }
    }

    public function setYandexMapsKey()
    {
        $input = Factory::getApplication()->input;
        $key = $input->get('yandex_maps', '', 'string');
        $db = Factory::getDbo();
        $query = $db->getQuery(true);
        $query->update('`#__gridbox_api`')
            ->set('`key` = '.$db->quote($key))
            ->where('`service` = '.$db->quote('yandex_maps'));
        $db->setQuery($query)
            ->execute();
    }

    public function setOpenWeatherMapKey()
    {
        $input = Factory::getApplication()->input;
        $key = $input->get('openweathermap', '', 'string');
        $db = Factory::getDbo();
        $query = $db->getQuery(true);
        $query->update('`#__gridbox_api`')
            ->set('`key` = '.$db->quote($key))
            ->where('`service` = '.$db->quote('openweathermap'));
        $db->setQuery($query)
            ->execute();
    }

    public function setLibraryImage()
    {
        $input = Factory::getApplication()->input;
        $str = $input->get('object', '', 'string');
        $obj = json_decode($str);
        $db = Factory::getDbo();
        $db->updateObject('#__gridbox_library', $obj, 'id');
    }

    public function setStarRatings()
    {
        $input = Factory::getApplication()->input;
        $id = $input->get('id', '', 'string');
        $rating = $input->get('rating', 0, 'int');
        $str = $input->get('page', '', 'string');
        $page = json_decode($str);
        if ($page->option == 'com_gridbox' && $page->view == 'gridbox') {
            $page->view = 'page';
        }
        $ip = $_SERVER['REMOTE_ADDR'];
        $db = Factory::getDbo();
        $query = $db->getQuery(true)
            ->select('id')
            ->from('#__gridbox_star_ratings_users')
            ->where('`ip` = '.$db->quote($ip))
            ->where('`plugin_id` = '.$db->quote($id))
            ->where('`option` = '.$db->quote($page->option))
            ->where('`view` = '.$db->quote($page->view))
            ->where('`page_id` = '.$db->quote($page->id));
        $db->setQuery($query);
        $flag = $db->loadResult();
        $object = new \stdClass();
        if (empty($flag)) {
            $query = $db->getQuery(true)
                ->select('*')
                ->from('#__gridbox_star_ratings')
                ->where('`plugin_id` = '.$db->quote($id))
                ->where('`option` = '.$db->quote($page->option))
                ->where('`view` = '.$db->quote($page->view))
                ->where('`page_id` = '.$db->quote($page->id));
            $db->setQuery($query);
            $obj = $db->loadObject();
            if (!isset($obj->id)) {
                $obj = new \stdClass();
                $obj->plugin_id = $id;
                $obj->rating = $rating;
                $obj->count = 1;
                $obj->option = $page->option;
                $obj->view = $page->view;
                $obj->page_id = $page->id;
                $db->insertObject('#__gridbox_star_ratings', $obj);
                $obj->id = $db->insertid();
            } else {
                $total = ($obj->rating * $obj->count + $rating) / ($obj->count + 1);
                $obj->rating = number_format($total, 2);
                $obj->count++;
                $db->updateObject('#__gridbox_star_ratings', $obj, 'id');
            }
            $user = new \stdClass();
            $user->plugin_id = $obj->plugin_id;
            $user->option = $page->option;
            $user->view = $page->view;
            $user->page_id = $page->id;
            $user->ip = $ip;
            $db->insertObject('#__gridbox_star_ratings_users', $user);
            $object->result = '<span>'.Text::_('THANK_YOU_FOR_VOTE').'</span>';
        } else {
            $object->result = '<span>'.Text::_('ALREADY_VOTED').'</span>';
        }
        list($object->str, $object->rating) = GridboxHelper::getStarRatings($id, $page);

        return $object;
    }

    public function getPageTags()
    {
        $db = Factory::getDbo();
        $input = Factory::getApplication()->input;
        $id = $input->get('id', 0, 'int');
        $query = $db->getQuery(true);
        $query->select('t.id, t.title')
            ->from('#__gridbox_tags_map AS m')
            ->leftJoin('#__gridbox_tags AS t ON t.id = m.tag_id')
            ->where('m.page_id = '.$id);
        $db->setQuery($query);
        $tags = $db->loadObjectList();
        
        return $tags;
    }

    public function getTagsFolders()
    {
        $data = new \stdClass();
        $db = Factory::getDbo();
        $query = $db->getQuery(true)
            ->select('*')
            ->from('#__gridbox_tags_folders')
            ->order('order_list ASC');
        $db->setQuery($query);
        $folders = $db->loadObjectList();
        $data->folders = new \stdClass();
        foreach ($folders as $folder) {
            $folder->tags = [];
            $data->folders->{$folder->id} = $folder;
        }
        $data->tags = $this->getTags();
        foreach ($data->tags as $tag) {
            $query = $db->getQuery(true)
                ->select('folder_id')
                ->from('#__gridbox_tags_folders_map')
                ->where('tag_id = '.$tag->id);
            $db->setQuery($query);
            $id = $db->loadResult();
            if (!$id) {
                $id = 1;
            }
            $tag->folder_id = $id;
        }

        return $data;
    }

    public function getTags()
    {
        $db = Factory::getDbo();
        $query = $db->getQuery(true);
        $query->select('*')
            ->from('#__gridbox_tags');
        $db->setQuery($query);
        $tags = $db->loadObjectList();

        return $tags;
    }

    public function checkProductTour()
    {
        $db = Factory::getDbo();
        $query = $db->getQuery(true);
        $query->select('`key`, `id`')
            ->from('`#__gridbox_api`')
            ->where('`service` = '.$db->quote('editor_tour'));
        $db->setQuery($query);
        $result = $db->loadObject();
        if (!isset($result->key)) {
            $result = new \stdClass();
            $result->key = 'true';
            $obj = new \stdClass();
            $obj->service = 'editor_tour';
            $obj->key = 'false';
            $db->insertObject('#__gridbox_api', $obj);
        }
        echo $result->key;
        exit;
    }

    public function setEditorView()
    {
        $app = Factory::getApplication();
        $app->input->set('view', 'gridbox');
    }

    public function getLibrary()
    {
        $db = Factory::getDbo();
        $input = Factory::getApplication()->input;
        $type = $input->get('type', '', 'string');
        if ($type != 'blocks') {
            $id = $input->get('id', 0, 'int');
            $table = '#__gridbox_library';
            $where = 'id = ';
        } else {
            $id = $input->get('id', '', 'string');
            $table = '#__gridbox_page_blocks';
            $where = 'title = ';
        }
        if ($id != $_POST['id']) {
            $id = $_POST['id'];
        }
        $where .= $db->quote($id);
        $query = $db->getQuery(true)
            ->select('item')
            ->from($table)
            ->where($where);
        $db->setQuery($query);
        $string = $db->loadResult();
        $item = json_decode($string);
        $this->setEditorView();
        $item->html = GridboxHelper::checkModules($item->html, $item->items);
        $this->getGalleryContent($item->html);
        $this->getFormsContent($item->html);
        $item->html = GridboxHelper::checkMainMenu($item->html);
        $item = json_encode($item);

        echo $item;
        exit;
    }

    protected function getGalleryContent(string $html):string
    {
        if (!class_exists('Balbooa\Component\Gallery\Site\Helper\GalleryHelper')) {
            return $html;
        }
        $html = GalleryHelper::renderGalleryHTML($html);

        return $html;
    }

    protected function getFormsContent(string $html):string
    {
        if (!class_exists('Balbooa\Component\Forms\Site\Helper\BaformsHelper')) {
            return $html;
        }
        $html = BaformsHelper::renderFormHTML($html);

        return $html;
    }

    public function removeLibrary()
    {
        $input = Factory::getApplication()->input;
        $id = $input->get('id', 0, 'int');
        $db = Factory::getDbo();
        $query = $db->getQuery(true)
            ->delete('#__gridbox_library')
            ->where('`id` = '.$db->quote($id));
        $db->setQuery($query)
            ->execute();
        exit;
    }

    public function insertToLibrary($str)
    {
        $obj = json_decode($str);
        $db = Factory::getDbo();
        if (!empty($obj->global_item)) {
            $query = $db->getQuery(true)
                ->select('id')
                ->from('#__gridbox_library')
                ->where('`global_item` = '.$db->quote($obj->global_item));
            $db->setQuery($query);
            $id = $db->loadResult();
            if (!empty($id)) {
                $msg = new \stdClass();
                $msg->text = Text::_('ALREADY_GLOBAL');
                $msg->type = 'ba-alert';
                $msg = json_encode($msg);
                echo($msg);
                exit;
            }
        }
        $obj->item = json_encode($obj->item);
        $db->insertObject('#__gridbox_library', $obj);
        $msg = new \stdClass();
        $msg->text = Text::_('SAVED_TO_LIBRARY');
        $msg->type = '';
        $msg = json_encode($msg);
        echo $msg;
        exit;
    }

    public function requestAddLibrary()
    {
        $data = file_get_contents('php://input');
        $this->insertToLibrary($data);
    }

    public function addLibrary()
    {
        $input = Factory::getApplication()->input;
        $data = $input->get('object', '', 'raw');
        $json = json_decode($data);
        if (empty($data) || !$json) {
            print_r('empty_data');exit;
        }
        $this->insertToLibrary($data);
    }

    public function savePostFieldsGroups($data, $id)
    {
        $db = Factory::getDbo();
        $query = $db->getQuery(true)
            ->select('app_id')
            ->from('#__gridbox_pages')
            ->where('id = '.$id);
        $db->setQuery($query);
        $app_id = $db->loadResult();
        if (!empty($app_id)) {
            $obj = new \stdClass();
            $obj->id = $app_id * 1;
            $obj->fields_groups = json_encode($data);
            $db->updateObject('#__gridbox_app', $obj, 'id');
        }
    }

    public function saveProductData($product, $id)
    {
        $db = Factory::getDbo();
        $product->data->variations = json_encode($product->variations);
        $product->data->extra_options = json_encode($product->extra_options);
        $product->data->dimensions = json_encode($product->dimensions);
        $product->data->booking = json_encode($product->booking);
        if ($product->data->id != 0) {
            $db->updateObject('#__gridbox_store_product_data', $product->data, 'id');
        } else {
            $db->insertObject('#__gridbox_store_product_data', $product->data);
        }
        $digital = !empty($product->data->digital_file) ? json_decode($product->data->digital_file) : new \stdClass();
        if (isset($digital->file)) {
            $dir = GridboxHelper::$storeHelper->getDigitalFolder($id);
            if (Folder::exists($dir)) {
                $files = Folder::files($dir);
                foreach ($files as $file) {
                    if ($file != $digital->file->filename) {
                        File::delete($dir.$file);
                    }
                }
                $files = Folder::files($dir);
                if (empty($files)) {
                    GridboxHelper::deleteFolder($dir);
                }
            }
        }
        $pks = [];
        foreach ($product->variations_map as $obj) {
            if ($obj->id != 0) {
                $db->updateObject('#__gridbox_store_product_variations_map', $obj, 'id');
            } else {
                $db->insertObject('#__gridbox_store_product_variations_map', $obj);
                $obj->id = $db->insertid();
            }
            $pks[] = $obj->id;
        }
        $query = $db->getQuery(true)
            ->delete('#__gridbox_store_product_variations_map')
            ->where('product_id = '.$id);
        if (!empty($pks)) {
            $str = implode(', ', $pks);
            $query->where('id NOT IN ('.$str.')');
        }
        $db->setQuery($query)
            ->execute();
        $query = $db->getQuery(true)
            ->select('*')
            ->from('#__gridbox_store_badges_map')
            ->where('product_id = '.$id);
        $db->setQuery($query);
        $badges = $db->loadObjectList();
        $pks = [];
        foreach ($badges as $badge) {
            if (!isset($product->badges->{$badge->badge_id})) {
                $pks[] = $badge->id;
            } else {
                $product->badges->{$badge->badge_id}->obj = $badge;
            }
        }
        if (!empty($pks)) {
            $str = implode(', ', $pks);
            $query = $db->getQuery(true)
                ->delete('#__gridbox_store_badges_map')
                ->where('id IN ('.$str.')');
            $db->setQuery($query)
                ->execute();
        }
        foreach ($product->badges as $badge_id => $badge) {
            if (isset($badge->obj)) {
                $badge->obj->order_list = $badge->i;
                $db->updateObject('#__gridbox_store_badges_map', $badge->obj, 'id');
            } else {
                $badge->obj = new \stdClass();
                $badge->obj->order_list = $badge->i;
                $badge->obj->badge_id = $badge_id;
                $badge->obj->product_id = $id;
                $db->insertObject('#__gridbox_store_badges_map', $badge->obj);
            }
        }
        $query = $db->getQuery(true)
            ->select('*')
            ->from('#__gridbox_store_related_products')
            ->where('product_id = '.$id);
        $db->setQuery($query);
        $items = $db->loadObjectList();
        $pks = [];
        foreach ($items as $item) {
            if (!isset($product->related->{$item->related_id})) {
                $pks[] = $item->id;
            } else {
                $product->related->{$item->related_id}->id = $item->id;
            }
        }
        if (!empty($pks)) {
            $str = implode(', ', $pks);
            $query = $db->getQuery(true)
                ->delete('#__gridbox_store_related_products')
                ->where('id IN ('.$str.')');
            $db->setQuery($query)
                ->execute();
        }
        foreach ($product->related as $related) {
            if (isset($related->id)) {
                $db->updateObject('#__gridbox_store_related_products', $related, 'id');
            } else {
                $db->insertObject('#__gridbox_store_related_products', $related);
            }
        }
    }

    public function duplicate($id)
    {
        $db = Factory::getDbo();
        $now = time();
        $query = $db->getQuery(true)
            ->select('*')
            ->from('#__gridbox_pages')
            ->where('id = '.$id);
        $db->setQuery($query);
        $page = $db->loadObject();
        unset($page->id);
        $page->hits = 0;
        $page->order_list = 0;
        $page->title = GridboxHelper::increment($page->title);
        $page->title = $this->getNewTitle($page->title);
        $page->page_alias = GridboxHelper::getAlias($page->page_alias, '#__gridbox_pages');
        $page->published = 0;
        $page->order_list = 0;
        $page->root_order_list = 0;
        $page->created = date("Y-m-d H:i:s", $now++);
        $db->insertObject('#__gridbox_pages', $page);
        $pk = $db->insertid();
        $this->duplicatePageFields($id, $pk);
        $this->duplicateProductData($id, $pk);
        $query = $db->getQuery(true)
            ->select('tag_id')
            ->from('`#__gridbox_tags_map`')
            ->where('`page_id` = '.$id);
        $db->setQuery($query);
        $tags = $db->loadObjectList();
        foreach ($tags as $tag) {
            $tag->page_id = $pk;
            $db->insertObject('#__gridbox_tags_map', $tag);
        }
        $query = $db->getQuery(true)
            ->select('*')
            ->from('#__gridbox_authors_map')
            ->where('page_id = '.$id);
        $db->setQuery($query);
        $authors = $db->loadObjectList();
        foreach ($authors as $author) {
            $author->page_id = $pk;
            unset($author->id);
            $db->insertObject('#__gridbox_authors_map', $author);
        }

        return $pk;
    }

    public function duplicateProductData($pk, $id)
    {
        $db = Factory::getDbo();
        $query = $db->getQuery(true)
            ->select('*')
            ->from('#__gridbox_store_product_variations_map')
            ->where('product_id = '.$pk);
        $db->setQuery($query);
        $variations = $db->loadObjectList();
        foreach ($variations as $variation) {
            unset($variation->id);
            $variation->product_id = $id;
            $db->insertObject('#__gridbox_store_product_variations_map', $variation);
        }
        $query = $db->getQuery(true)
            ->select('*')
            ->from('#__gridbox_store_product_data')
            ->where('product_id = '.$pk);
        $db->setQuery($query);
        $data = $db->loadObjectList();
        foreach ($data as $value) {
            unset($value->id);
            $value->product_id = $id;
            if (!empty($value->digital_file)) {
                $digital = json_decode($value->digital_file);
                $digital->file->name = $digital->file->filename = '';
                $value->digital_file = json_encode($digital);
            }
            $db->insertObject('#__gridbox_store_product_data', $value);
        }
    }

    public function duplicatePageFields($pk, $id)
    {
        $db = Factory::getDbo();
        $query = $db->getQuery(true)
            ->select('*')
            ->from('#__gridbox_page_fields')
            ->where('page_id = '.$pk);
        $db->setQuery($query);
        $fields = $db->loadObjectList();
        foreach ($fields as $field) {
            $field->id = 0;
            $field->page_id = $id;
            $db->insertObject('#__gridbox_page_fields', $field);
        }
    }

    public function getNewTitle($title, $table = '#__gridbox_pages')
    {
        $db = Factory::getDbo();
        $query = $db->getQuery(true)
            ->select('id')
            ->from($table)
            ->where('title = '.$db->quote($title));
        $db->setQuery($query);
        $result = $db->loadResult();
        if ($result) {
            $title = GridboxHelper::increment($title);
            $title = $this->getNewTitle($title);
        }

        return $title;
    }

    public function saveVersion($obj)
    {
        $db = Factory::getDbo();
        $obj->title = date("Y-m-d H:i:s");
        $obj->items = json_encode($obj->items);
        $db->insertObject('#__gridbox_pages_versions', $obj);
        if (GridboxHelper::$website->versions_auto_save == 1 && !empty(GridboxHelper::$website->max_versions)) {
            $this->checkMaxVersions($db, $obj->page_id);
        }
    }

    public function checkMaxVersions($db, $page_id)
    {
        $max = GridboxHelper::$website->max_versions * 1;
        $query = $db->getQuery(true)
            ->select('id')
            ->from('#__gridbox_pages_versions')
            ->where('page_id = '.$page_id);
        $db->setQuery($query);
        $items = $db->loadObjectList();
        $n = count($items);
        if ($max > $n) {
            return;
        }
        $delta = $n - $max;
        $sliced = array_slice($items, 0, $delta);
        $array = [];
        foreach ($sliced as $obj) {
            $array[] = $obj->id;
        }
        $str = implode(', ', $array);
        $query = $db->getQuery(true)
            ->delete('#__gridbox_pages_versions')
            ->where('id IN ('.$str.')');
        $db->setQuery($query)
            ->execute();
    }

    public function gridboxSave($obj)
    {
        if (GridboxHelper::$website->compress_images != $obj->website->compress_images ||
            GridboxHelper::$website->images_max_size != $obj->website->images_max_size ||
            GridboxHelper::$website->images_quality != $obj->website->images_quality ||
            GridboxHelper::$website->adaptive_images != $obj->website->adaptive_images ||
            GridboxHelper::$website->adaptive_quality != $obj->website->adaptive_quality) {
            GridboxHelper::deleteFolder(JPATH_ROOT.'/'. FileHelper::getImagePath() .'/compressed');
        }
        $favicon = JPATH_ROOT.'/templates/gridbox/favicon.png';
        if (GridboxHelper::$website->favicon != $obj->website->favicon && File::exists($favicon)) {
            File::delete($favicon);
        }
        GridboxHelper::$website = $obj->website;
        GridboxHelper::siteRules($obj->breakpoints);
        GridboxHelper::saveTheme($obj->theme, $obj->page->theme);
        if (!isset($obj->edit_type)) {
            if (GridboxHelper::$website->versions_auto_save == 1) {
                $object = new \stdClass();
                $object->page_id = $obj->page->id;
                $object->items = $obj->page->style;
                $object->html = $obj->page->params;
                $this->saveVersion($object);
            }
            if (is_numeric($obj->page->intro_image)) {
                $field = new \stdClass();
                $field->field_id = 'image';
                $field->type = 'image-field';
                $field->value = new \stdClass();
                $field->value->src = $obj->page->intro_image;
                $obj->fields->image = $field;
            }
            GridboxHelper::savePage($obj->page, $obj->page->id);
            GridboxHelper::savePageFields($obj->fields, $obj->page->id);
            if (isset($obj->product)) {
                $this->saveProductData($obj->product, $obj->page->id);
            }
            $this->savePostFieldsGroups($obj->fieldsGroups, $obj->page->id);
            EventDispatcher::getInstance()
                ->dispatch(FinderEvents::Save, $obj->page->id, 'finder');
        } else if ($obj->edit_type == 'blog') {
            GridboxHelper::saveAppLayout($obj->page, $obj->page->id);
        } else if ($obj->edit_type == 'system') {
            GridboxHelper::saveSystemPage($obj->page, $obj->page->id);
        } else if ($obj->edit_type == 'post-layout') {
            GridboxHelper::savePostLayout($obj->page, $obj->page->id);
        }
        GridboxHelper::saveCodeEditor($obj->code, $obj->page->theme);
        GridboxHelper::saveWebsite($obj->website);
        GridboxHelper::saveGlobalItems($obj->global);
        $performance = GridboxHelper::getPerformance();
        $options = [
            'defaultgroup' => 'gridbox',
            'browsercache' => $performance->browser_cache,
            'caching'  => false,
        ];
        $cache = Cache::getInstance('page', $options);
        $cacheFolders = Folder::folders(JPATH_CACHE);
        foreach ($cacheFolders as $group) {
            $cache->clean($group);
        }
        echo Text::_('GRIDBOX_SAVED');
        exit;
    }

    public function checkMainMenu()
    {
        $input = Factory::getApplication()->input;
        $menu = $input->get('main_menu', 0, 'int');
        $data = $input->get('items', '', 'raw');
        $id = $input->get('id', 0, 'int');
        $items = new \stdClass();
        $items->{$id} = json_decode($data);
        $html = '<div class="ba-item-main-menu ba-item" id="'.$id.'">[main_menu='.$menu.']</div>';
        $html = GridboxHelper::checkMainMenu($html);
        $html = GridboxHelper::checkDOM($html, $items);
        error_reporting(E_ALL & ~E_NOTICE & ~E_DEPRECATED & ~E_WARNING);
        include_once JPATH_ROOT.'/components/com_gridbox/libraries/php/phpQuery/phpQuery.php';
        $dom = \phpQuery::newDocument($html);
        $html = pq('.ba-item-main-menu')->html();
        echo $html;
        exit;
    }

    public function setMapsKey()
    {
        $input = Factory::getApplication()->input;
        $key = $input->get('google_maps_key', '', 'string');
        $db = Factory::getDbo();
        $query = $db->getQuery(true);
        $query->update('`#__gridbox_api`')
            ->set('`key` = '.$db->quote($key))
            ->where('`service` = '.$db->quote('google_maps'));
        $db->setQuery($query)
            ->execute();
    }

    public function getBlocksLicense($data)
    {
        $this->installBlocks($data);
        echo Text::_('BLOCKS_INSTALLED');
        exit;
    }

    public function getPluginLicense()
    {
        $input = Factory::getApplication()->input;
        $str = $input->get('data', '', 'string');
        $data = json_decode($str);
        $this->installPlugin($data);
        echo Text::_('PLUGIN_INSTALLED');
        exit;
    }

    public function loadLayout()
    {
        $input = Factory::getApplication()->input;
        $layout = $input->get('layout', '', 'raw');
        $count = $input->get('count', '', 'raw');
        $span = explode('+', $count);
        $count = count($span);
        $obj = new \stdClass();
        $obj->items = new \stdClass();
        $now = $input->get('time', strtotime(date('Y-m-d G:i:s')), 'raw');
        include JPATH_ROOT.'/components/com_gridbox/tmpl/layout/'.$layout.'.php';
        $obj->html = $html = GridboxHelper::replaceBootstrap($out);
        echo json_encode($obj);
        exit;
    }

    public function reloadModules($id, $type)
    {
        $this->setEditorView();
        $out = '['.$type.' ID='.$id.']';
        if ($type == 'modules') {
            $out = GridboxHelper::checkModules($out, '{}');
            $str = $this->returnStyle();
            $out = $str.$out;
        } else if ($type == 'gallery') {
            $out = $this->getGalleryContent($out);
        } else if ($type == 'forms') {
            $out = $this->getFormsContent($out);
        }

        return $out;
    }

    public function contentSliderAdd()
    {
        $input = Factory::getApplication()->input;
        $data = $input->get('data', [], 'array');
        $ind = $input->get('ind', 1, 'int');
        $title = $input->get('title', 1, 'int');
        $now = strtotime(date('Y-m-d G:i:s')) * 10;
        $obj = new \stdClass();
        $obj->items = new \stdClass();
        include JPATH_ROOT.'/components/com_gridbox/tmpl/layout/content-slider-li.php';
        $obj->slides = $slides;
        $obj->html = $out;
        $str = json_encode($obj);

        return $str;
    }

    public function loadPlugin()
    {
        $input = Factory::getApplication()->input;
        $layout = $input->get('plugin', '', 'string');
        $id = $input->get('id', 0, 'int');
        $edit_type = $input->get('edit_type', 'edit_type', 'string');
        if (!GridboxHelper::checkPlugin($layout)) {
            echo '';
            exit;
        }
        if ($layout == 'content-slider') {
            $data = $input->get('data', [], 'array');
        } else {
            $data = $input->get('data', '', 'string');
        }
        $domPlugins = [
            'post-intro', 'breadcrumbs', 'comments-box', 'add-to-cart',
            'reviews', 'related-posts-slider', 'recently-viewed-products',
            'currency-switcher', 'language-switcher', 'login', 'social',
            'recent-posts-slider', 'recent-posts', 'related-posts',
            'recent-reviews', 'recent-comments', 'author', 'tags',
            'post-navigation', 'menu', 'post-tags', 'categories'
        ];
        $obj = new \stdClass();
        $obj->items = new \stdClass();
        $now = $input->get('time', strtotime(date('Y-m-d G:i:s')), 'raw');
        $this->setEditorView();
        include JPATH_ROOT.'/components/com_gridbox/tmpl/layout/'.$layout.'.php';
        if ($layout == 'modules') {
            $out = GridboxHelper::checkModules($out, $obj->items);
            $str = $this->returnStyle();
            $out = str_replace('<input type="hidden" class="modules-styles">', $str, $out);
        } else if ($layout == 'bagallery') {
            $str = $this->getGalleryContent('[gallery ID='.$data.']');
            $out = str_replace('[gallery ID='.$data.']', $str, $out);
        } else if ($layout == 'baforms') {
            $str = $this->getFormsContent('[forms ID='.$data.']');
            $out = str_replace('[forms ID='.$data.']', $str, $out);
        } else if ($layout == 'menu') {
            $out = GridboxHelper::checkMainMenu($out);
        } else if ($layout == 'recent-posts-slider' || $layout == 'recent-posts'
            || $layout == 'categories' || $layout == 'tags') {
            $obj->items->{'item-'.$now}->app = $edit_type == 'blog' ?
                $id : GridboxHelper::getAppId($id);
            if (empty($obj->items->{'item-'.$now}->app)) {
                $obj->items->{'item-'.$now}->app = 0;
            }
        } else if ($layout == 'related-posts') {
            $obj->items->{'item-'.$now}->app = $edit_type == 'post-layout' ?
                $id : GridboxHelper::getAppId($id);
        }
        if (in_array($layout, $domPlugins)) {
            $out = GridboxHelper::checkDOM($out, $obj->items);
        }
        $obj->html = GridboxHelper::replaceBootstrap($out);
        echo json_encode($obj);
        exit;
    }

    public function returnStyle()
    {
        $str = '';
        $doc = Factory::getDocument();
        foreach ($doc->_scripts as $key => $script) {
            $str .= '<script src="'.$key.'"';
            if (isset($script['defer']) && !empty($script['defer'])) {
                $str .= ' defer';
            }
            if (isset($script['async']) && !empty($script['async'])) {
                $str .= ' async';
            }
            $str .= '></script>';
        }
        foreach ($doc->_script as $key => $script) {
            $str .= '<script type="'.$key.'">'.$script.'</script>';
        }
        foreach ($doc->_styleSheets as $key => $link) {
            $str .= '<link href="'.$key.'" type="text/css"';
            if (isset($script['media']) && !empty($link['media'])) {
                $str .= ' media="'.$link['media'].'"';
            }
            $str .= ' rel="stylesheet">';
        }
        foreach ($doc->_style as $key => $style) {
            $str .= '<style>'.$style.'</style>';
        }

        return $str;
    }

    public function getWebsite()
    {
        $db = $this->getDbo();
        $query = $db->getQuery(true);
        $query->select('*')
            ->from('`#__gridbox_website`')
            ->where('`id` = 1');
        $db->setQuery($query);
        $result = $db->loadObject();

        return $result;
    }

    public function getLibraryItems()
    {
        $obj = new \stdClass();
        $db = $this->getDbo();
        $query = $db->getQuery(true);
        $query->select('title, global_item, id, image')
            ->from('`#__gridbox_library`')
            ->where('`type` = ' .$db->quote('section'));
        $db->setQuery($query);
        $obj->sections = $db->loadObjectList();
        $query = $db->getQuery(true);
        $query->select('title, global_item, id, image')
            ->from('`#__gridbox_library`')
            ->where('`type` = ' .$db->quote('plugin'));
        $db->setQuery($query);
        $obj->plugins = $db->loadObjectList();

        return $obj;
    }

    private function getUsername($name, $pwd)
    {
        $db = Factory::getDbo();
        $query = $db->getQuery(true)
            ->select('username')
            ->from('#__users')
            ->where('username = '.$db->quote($name))
            ->where('password = '.$db->quote($pwd));
        $db->setQuery($query);
        $username = $db->loadResult();

        return $username;
    }

    public function getItem($id = null)
    {
        $input = Factory::getApplication()->input;
        $name = $input->get('name', '', 'raw');
        $pwd = $input->get('pwd', '', 'raw');
        $username = $this->getUsername($name, $pwd);
        if (!Factory::getUser()->authorise('core.edit', 'com_gridbox') && !empty($username)) {
            GridboxHelper::userLogin($username);
        }
        if (!empty($name) || !empty($pwd)) {
            $get = $input->get->getArray([]);
            $id = $get['id'];
            unset($get['name']);
            unset($get['pwd']);
            unset($get['id']);
            unset($get['Itemid']);
            $get['id'] = $id;
            $url = http_build_query($get);
            header('Location: '.Uri::current().'?'.$url);
            exit;
        }
        $db = $this->getDbo();
        $edit_type = $input->get('edit_type', '', 'string');
        $id = $input->get('id', 0, 'int');
        if ($id != 0) {
            /**
             * @var Joomla\Database\Mysqli\MysqliQuery
             */
            $query = $db->getQuery(true);
            if ($edit_type == 'blog' || $edit_type == 'post-layout') {
                $query->select('b.*')
                    ->from('`#__gridbox_app` AS b')
                    ->where('b.type <> '.$db->quote('system_apps'))
                    ->where('b.id = ' .$id)
                    ->select('t.title as ThemeTitle')
                    ->leftJoin('`#__template_styles` AS t ON b.theme = t.id');
            } else if (empty($edit_type)) {
                $query->select('b.*')
                    ->from('`#__gridbox_pages` AS b')
                    ->where('b.id = ' .$id)
                    ->select('t.title as ThemeTitle')
                    ->leftJoin('`#__template_styles` AS t ON b.theme = t.id')
                    ->select('a.type as app_type')
                    ->leftJoin('`#__gridbox_app` AS a ON b.app_id = a.id');
            } else if ($edit_type == 'system') {
                $query->select('*')
                    ->from('#__gridbox_system_pages')
                    ->where('id = '.$id);
            }
            $db->setQuery($query);
            $item = $db->loadObject();
            if (isset($item->app_type) && $item->app_type != 'single') {
                /**
                 * @var Joomla\Database\Mysqli\MysqliQuery
                 */
                $query = $db->getQuery(true);
                $query->select('a.id, a.avatar, a.title')
                    ->from('#__gridbox_authors_map AS m')
                    ->where('m.page_id = '.$item->id)
                    ->leftJoin('#__gridbox_authors AS a ON a.id = m.author_id')
                    ->order('m.id ASC');
                $db->setQuery($query);
                $item->authors = $db->loadObjectList();
                $query = $db->getQuery(true)
                    ->select('*')
                    ->from('#__gridbox_category_page_map')
                    ->where('page_id = '.$item->id);
                $db->setQuery($query);
                $item->categories = $db->loadObjectList();
            } else {
                $item->authors = [];
            }
        } else {
            $item = new \stdClass();
        }
        
        return $item;
    }

    public function getPageLayout()
    {
        $input = Factory::getApplication()->input;
        $id = $input->get('id', 0, 'int');
        $db = Factory::getDbo();
        $query = $db->getQuery(true)
            ->select('a.page_layout, a.type')
            ->from('#__gridbox_app AS a')
            ->leftJoin('#__gridbox_pages AS p ON a.id = p.app_id')
            ->where('p.id = '.$id);
        $db->setQuery($query);
        $item = $db->loadObject();
        if (empty($item->page_layout)) {
            $item->page_layout = FileHelper::readFile(JPATH_ROOT.'/components/com_gridbox/tmpl/layout/apps/'.$item->type.'/default.html');
        }
        
        return $item->page_layout;
    }

    public function getAuthors()
    {
        $db = Factory::getDbo();
        $query = $db->getQuery(true)
            ->select('a.title, a.id, a.avatar, u.username')
            ->from('`#__gridbox_authors` AS a')
            ->leftJoin('`#__users` AS u ON '.$db->quoteName('u.id').' = '.$db->quoteName('a.user_id'));
        $db->setQuery($query);
        $authors = $db->loadObjectList();

        return $authors;
    }

    public function getThemes()
    {
        $db = $this->getDbo();
        $query = $db->getQuery(true);
        $query->select('id, title, home')
            ->from('#__template_styles')
            ->where('`template`=' .$db->quote('gridbox'))
            ->order('home desc');
        $db->setQuery($query);
        $themes = new \stdClass();
        $themes->list = $db->loadObjectList();
        $themes->default = $themes->list[0];
        $app_id = Factory::getApplication()->input->get('app_id', 0, 'int');
        if (!empty($app_id)) {
            $query = $db->getQuery(true)
                ->select('theme')
                ->from('#__gridbox_app')
                ->where('id = '.$app_id);
            $db->setQuery($query);
            $theme = $db->loadResult();
            foreach ($themes->list as $value) {
                if ($value->id == $theme) {
                    $themes->default = $value;
                    break;
                }
            }
        }
        
        return $themes;
    }

    public function installBlocks($item)
    {
        $db = Factory::getDbo();
        $obj = new \stdClass();
        $obj->type = $item->type;
        $obj->title = $item->title;
        $obj->image = $item->image;
        $object = json_decode($item->data);
        $object->items = json_decode($object->items);
        $obj->item = json_encode($object);
        $db->insertObject('#__gridbox_page_blocks', $obj);
        $array = explode(',', $item->imageData);
        $method = $item->method;
        $content = $method($array[1]);
        File::write(JPATH_COMPONENT.'/assets/images/page-blocks/'.$obj->image, $content);
    }

    public function installPlugin($data)
    {
        $db = Factory::getDbo();
        foreach ($data as $group) {
            foreach ($group as $plugin) {
                $db->insertObject('#__gridbox_plugins', $plugin);
            }
        }
    }

    public function checkBlocks($block) {
        $db = Factory::getDbo();
        $query = $db->getQuery(true);
        $query->select('id')
            ->from('#__gridbox_page_blocks')
            ->where('`title` = ' .$db->quote($block));
        $db->setQuery($query);
        $id = $db->loadResult();
        
        return $id;
    }

    public function checkPlugin($plugin) {
        $db = Factory::getDbo();
        $query = $db->getQuery(true);
        $query->select('id')
            ->from('#__gridbox_plugins')
            ->where('`title` = ' .$db->quote($plugin));
        $db->setQuery($query);
        $id = $db->loadResult();
        
        return $id;
    }

    public function returnObj($id, $plugin)
    {
        $obj = new \stdClass();
        $obj->id = $id;
        $obj->title = trim((string)$plugin->title);
        $obj->image = trim((string)$plugin->image);
        $obj->type = trim((string)$plugin->type);
        $obj->joomla_constant = trim((string)$plugin->joomla_constant);

        return $obj;
    }

    public function getBlocks()
    {
        $blocks = [
            'cover' => [], 'about-us' => [], 'services' => [], 
            'description' => [], 'steps' => [], 'schedule' => [], 'features' => [],
            'pricing-table' => [], 'pricing-list' => [], 'testimonials' => [], 'team' => [],
            'counters' => [], 'faq' => [], 'call-to-action' => []
        ];
        $db = $this->getDbo();
        $query = $db->getQuery(true);
        $query->select('type, title, image, id')
            ->from('#__gridbox_page_blocks')
            ->order('id asc');
        $db->setQuery($query);
        $items = $db->loadObjectList();
        foreach ($items as $item) {
            if (isset($blocks[$item->type])) {
                $blocks[$item->type][$item->title] = $item;
            }
        }

        return $blocks;
    }

    public function getPlugins()
    {
        $input = Factory::getApplication()->input;
        $edit_type = $input->get('edit_type', '', 'string');
        $db = $this->getDbo();
        $query = $db->getQuery(true);
        $query->select('*')
            ->from('#__gridbox_plugins')
            ->order('joomla_constant asc');
        $db->setQuery($query);
        $items = $db->loadObjectList();
        $plugins = [
            'content' => [], 'info' => [], 'navigation' => [],
            'social' => [], 'blog' => [], 'store' => [], 'fields' => [], '3rd-party-plugins' => []
        ];
        $blog = GridboxHelper::checkInstalledBlog();
        if ($blog) {
            $plugins['blog'] = $this->getBlogPlugins();
        } else {
            unset($plugins['blog']);
        }
        if (GridboxHelper::checkInstalledBlog('products') || GridboxHelper::checkInstalledBlog('booking')) {
            $plugins['store'] = $this->getStorePlugins();
        } else {
            unset($plugins['store']);
        }
        foreach ($items as $item) {
            if ($item->title == 'ba-instagram') {
                continue;
            }
            $plugins[$item->type][$item->title] = $item;
        }
        if (isset(GridboxHelper::$systemApps->comments) && $edit_type != 'blog') {
            $comments = new \stdClass();
            $comments->title = 'ba-comments-box';
            $comments->image = 'plugins-comments-box';
            $comments->type = 'social';
            $comments->joomla_constant = 'COMMENTS_BOX';
            $plugins['social'][] = $comments;
        }
        if (isset(GridboxHelper::$systemApps->comments)) {
            $comments = new \stdClass();
            $comments->title = 'ba-recent-comments';
            $comments->image = 'plugins-recent-comments';
            $comments->type = 'social';
            $comments->joomla_constant = 'RECENT_COMMENTS';
            $plugins['social'][] = $comments;
        }
        if (isset(GridboxHelper::$systemApps->reviews) && $edit_type != 'blog') {
            $reviews = new \stdClass();
            $reviews->title = 'ba-reviews';
            $reviews->image = 'plugins-reviews';
            $reviews->type = 'social';
            $reviews->joomla_constant = 'REVIEWS';
            $plugins['social'][] = $reviews;
        }
        if (isset(GridboxHelper::$systemApps->reviews)) {
            $reviews = new \stdClass();
            $reviews->title = 'ba-recent-reviews';
            $reviews->image = 'plugins-recent-reviews';
            $reviews->type = 'social';
            $reviews->joomla_constant = 'RECENT_REVIEWS';
            $plugins['social'][] = $reviews;
        }
        if (isset(GridboxHelper::$systemApps->comments) || isset(GridboxHelper::$systemApps->reviews)) {
            usort($plugins['social'], function($a, $b){
                if ($a->joomla_constant == $b->joomla_constant) {
                    return 0;
                }
                return ($a->joomla_constant < $b->joomla_constant) ? -1 : 1;
            });
        }

        return $plugins;
    }

    public function getStorePlugins()
    {
        $plugins = [
            'cart' => 'plugins-cart',
            'add-to-cart' => 'plugins-add-to-cart',
            'product-slideshow' => 'plugins-slideshow',
            'product-gallery' => 'flaticon-photo-camera-1',
            'wishlist' => 'flaticon-like-2',
            'store-search' => 'flaticon-search',
            'recently-viewed-products' => 'flaticon-television',
            'currency-switcher' => 'plugins-currency-switcher'
        ];
        $store = [];
        foreach ($plugins as $plugin => $image) {
            $obj = new \stdClass();
            $obj->title = 'ba-'.$plugin;
            $obj->image = $image;
            $obj->type = 'store';
            $obj->joomla_constant = strtoupper(str_replace('-', '_', $plugin));
            $store[$obj->title] = $obj;
        }

        return $store;
    }

    public function getBlogPlugins()
    {
        $plugins = ['tags', 'categories', 'recent-posts', 'search', 'recent-posts-slider', 'event-calendar',
            'fields-filter', 'google-maps-places'];
        $icons = ['flaticon-bookmark', 'flaticon-folder-13', 'flaticon-calendar-6', 'flaticon-search',
            'flaticon-tabs', 'flaticon-calendar-1', 'flaticon-checked', 'plugins-google-maps'];
        $blog = [];
        while ($plugin = array_pop($plugins)) {
            $obj = new \stdClass();
            $obj->title = 'ba-'.$plugin;
            $obj->image = array_pop($icons);
            $obj->type = 'blog';
            $obj->joomla_constant = strtoupper(str_replace('-', '_', $plugin));
            if ($plugin == 'recent-posts-slider') {
                $obj->joomla_constant = 'POST_SLIDER';
            } else if ($plugin == 'fields-filter') {
                $obj->joomla_constant = 'CONTENT_FILTERS';
            }
            $blog[$obj->title] = $obj;
        }

        return $blog;
    }

    public function getMenus()
    {
        $db = $this->getDbo();
        $query = $db->getQuery(true);
        $query->select('menutype, title')
            ->from('#__menu_types');
        $db->setQuery($query);
        $menus = $db->loadObjectList();
        
        return $menus;
    }

    public function getAllApps()
    {
        $db = Factory::getDbo();
        $query = $db->getQuery(true)
            ->select('title, id, type')
            ->from('#__gridbox_app')
            ->where('type <> '.$db->quote('system_apps'));
        $db->setQuery($query);
        $items = $db->loadObjectList();
        $obj = new \stdClass();
        $obj->title = Text::_('PAGES');
        $obj->id = 0;
        $obj->type = 'single';
        $array = [$obj];
        $array = array_merge($array, $items);

        return $array;
    }

    public function getApps()
    {
        $db = Factory::getDbo();
        $query = $db->getQuery(true)
            ->select('title, id, type')
            ->from('#__gridbox_app')
            ->where('type <> '.$db->quote('system_apps'))
            ->where('type <> '.$db->quote('single'));
        $db->setQuery($query);
        $items = $db->loadObjectList();

        return $items;
    }

    public function getCategories()
    {
        $db = Factory::getDbo();
        $query = $db->getQuery(true)
            ->select('title, id, app_id')
            ->from('#__gridbox_categories')
            ->order('order_list ASC');
        $db->setQuery($query);
        $items = $db->loadObjectList();

        return $items;
    }
    
    public function getForm()
    {
        $form = Form::getInstance('gridbox', JPATH_COMPONENT.'/forms/gridbox.xml');
        
        return $form;
    }

    public function getJce()
    {
        $db = Factory::getDbo();
        $query = $db->getQuery(true)
            ->select('enabled')
            ->from('`#__extensions`')
            ->where('`element` = '.$db->quote('jce'))
            ->where('`folder` = '.$db->quote('editors'));
        $db->setQuery($query);
        $id = $db->loadResult();

        return $id;
    }
}