<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Site\Model;

use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Model\ItemModel;

defined('_JEXEC') or die;

class MenuModel extends ItemModel
{
    public function getTable($type = 'Pages', $prefix = 'Site', $config = []) 
    {
        return parent::getTable($type, $prefix, $config);
    }

    public function getItem($pk = null)
    {
        
    }

    public function getItems()
    {
        $db = Factory::getDbo();
        $query = $db->getQuery(true);
        $query->select('id, title, position, module')
            ->from('`#__modules`')
            ->where('`published` = 1')
            ->where('`client_id` = 0')
            ->where('module = '.$db->quote('mod_menu'));
        $input = Factory::getApplication()->input;
        $search = $input->cookie->get('menu_search', '', 'string');
        if (!empty($search)) {
            $query->where('title LIKE '.$db->quote('%'.$db->escape($search, true).'%'));
        }
        $orderCol = $input->cookie->get('menu_ordering', 'id', 'string');
        $orderDirn = $input->cookie->get('menu_direction', 'desc', 'string');
        $query->order($db->escape($orderCol . ' ' . $orderDirn));
        $db->setQuery($query);
        $items = $db->loadObjectList();
        
        return $items;
    }
}