<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Site\Model;

use Balbooa\Component\Gridbox\Site\Helper\FileHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Model\ItemModel;

defined('_JEXEC') or die;

class PageModel extends ItemModel
{
    public function getTable($type = 'Pages', $prefix = 'Site', $config = []) 
    {
        return parent::getTable($type, $prefix, $config);
    }

    public function getHits()
    {
        $input = Factory::getApplication()->input;
        $table = $this->getTable();
        $id = $input->get('id', 0, 'int');
        $table->load($id);
        $table->hit($id);
    }

    public function getPageLayout()
    {
        $input = Factory::getApplication()->input;
        $id = $input->get('id', 0, 'int');
        $db = Factory::getDbo();
        $query = $db->getQuery(true)
            ->select('b.id')
            ->from('`#__gridbox_pages` AS b')
            ->where('b.id = ' .$id)
            ->select('a.page_layout, a.type')
            ->leftJoin('`#__gridbox_app` AS a'
                . ' ON '
                . $db->quoteName('b.app_id')
                . ' = ' 
                . $db->quoteName('a.id')
            );
        $db->setQuery($query);
        $item = $db->loadObject();
        if (empty($item->page_layout)) {
        $item->page_layout = FileHelper::readFile(JPATH_ROOT.'/components/com_gridbox/tmpl/layout/apps/'.$item->type.'/default.html');
        }
        
        return $item->page_layout;
    }

    public function getPageItems()
    {
        
        $input = Factory::getApplication()->input;
        $id = $input->get('id', 0, 'int');
        $db = Factory::getDbo();
        $query = $db->getQuery(true)
            ->select('b.id')
            ->from('`#__gridbox_pages` AS b')
            ->where('b.id = ' .$id)
            ->select('a.page_items, a.type')
            ->leftJoin('`#__gridbox_app` AS a'
                . ' ON '
                . $db->quoteName('b.app_id')
                . ' = ' 
                . $db->quoteName('a.id')
            );
        $db->setQuery($query);
        $item = $db->loadObject();
        if (empty($item->page_items)) {
            $item->page_items = FileHelper::readFile(JPATH_ROOT.'/components/com_gridbox/tmpl/layout/apps/'.$item->type.'/default.json');
        }
        
        return $item->page_items;
    }
    
    public function getItem($pk = null)
    {
        $input = Factory::getApplication()->input;
        $db = $this->getDbo();
        $id = $input->get('id', 0, 'int');
        $query = $db->getQuery(true);
        $date = $db->quote(date("Y-m-d H:i:s"));
        $query->select('p.*')
            ->from('`#__gridbox_pages` as p')
            ->where('p.id = ' .$id)
            ->where('p.published = 1')
            ->where('p.language in (' . $db->quote(Factory::getLanguage()->getTag()) . ',' . $db->quote('*') . ')')
            ->where('p.created <= '.$date)
            ->select('a.type as app_type')
            ->leftJoin('`#__gridbox_app` AS a ON p.app_id = a.id')
            ->select('c.title AS category_title')
            ->leftJoin('`#__gridbox_categories` AS c ON p.page_category = c.id');
        $db->setQuery($query);
        $item = $db->loadObject();
        if (!empty($item->app_type) && $item->app_type != 'single') {
            $query = $db->getQuery(true);
            $query->select('au.title, au.avatar, au.id')
                ->from('`#__gridbox_authors_map` AS au_m')
                ->where('au_m.page_id = '.$id)
                ->leftJoin('`#__gridbox_authors` AS au ON au.id = au_m.author_id')
                ->where('au.published = 1')
                ->order('au_m.id ASC');
            $db->setQuery($query);
            $item->authors = $db->loadObjectList();
        }
        
        return $item;
    }

    public function getGlobalItems()
    {
        $db = $this->getDbo();
        $query = $db->getQuery(true);
        $query->select('item')
            ->from('`#__gridbox_library`')
            ->where('`global_item` <> ' .$db->quote(''));
        $db->setQuery($query);
        $items = $db->loadObjectList();

        return $items;
    }
}
