<?php

namespace Balbooa\Component\Gridbox\Site\Requests;

use Joomla\CMS\Factory;
use Joomla\Input\Input;

abstract class Request
{
    protected Input $input;
    protected array $rules;

    public function __construct()
    {
        $this->input = Factory::getApplication()->input;
        $this->setRules();
    }

    abstract public function setRules(): void;

    protected function validate(string $method): object
    {
        $data = new \stdClass;
        $rules = $this->rules[$method] ?? [];
        foreach ($rules as $key => $rule) {
            $data->$key = $this->input->get($key, $rule[0] ?? '', $rule[0] ?? '');;
        }

        return $data;
    }


    public function get(string $key): object
    {
        $validated = $this->validate($key);

        return $validated;
    }
}