<?php
/**
 * @package   Gridbox
 * @author    Balbooa http://www.balbooa.com/
 * @copyright Copyright @ Balbooa
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace Balbooa\Component\Gridbox\Site\Service;

use Balbooa\Component\Gridbox\Site\Interface\Enums\EventsInterface;
use Balbooa\Component\Gridbox\Site\Trait\SingletonTrait;
use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\Event\DispatcherInterface;

defined('_JEXEC') or die;

class EventDispatcher
{
    use SingletonTrait;

    private DispatcherInterface $dispatcher;

    private function __construct()
    {
        $this->dispatcher = Factory::getApplication()->getDispatcher();
    }

    public function dispatch(EventsInterface $event, mixed $data, ?string $plugin = null): void
    {
        if ($plugin) {
            PluginHelper::importPlugin($plugin);
        }
        $this->dispatcher->dispatch($event->getName(), $event->make([
            'data' => $data
        ]));
    }
}