<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Site\Trait;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;

trait LanguageTrait
{
    public static function getLanguages():array
    {
        $db = Factory::getDbo();
        $query = $db->getQuery(true);
        $query->select('lang_code, title')
            ->from('#__languages')
            ->where('published >= 0')
            ->order('title');
        $db->setQuery($query);
        $items = $db->loadObjectList();
        $languages = [];
        $languages['*'] = Text::_('JALL');
        foreach ($items as $value) {
            $languages[$value->lang_code] = $value->title;
        }

        return $languages;
    }
}