<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Site\View\Fonts;

use Balbooa\Component\Gridbox\Site\Helper\GridboxHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\View\HtmlView as BaseView;
use Joomla\CMS\Uri\Uri;

defined('_JEXEC') or die;

class HtmlView extends BaseView
{
    protected $item;
    protected $customStr;
    
    public function display($tpl = null)
    {
        if (!Factory::getUser()->authorise('core.edit', 'com_gridbox')) {
            GridboxHelper::raiseError(403, Text::_('JERROR_ALERTNOAUTHOR'));
            return;
        }
        $doc = Factory::getDocument();
        $doc->setTitle('Gridbox Editor');
        $doc->addStyleSheet(Uri::root() . 'components/com_gridbox/assets/css/ba-style-editor.css');
        $this->item = $this->get('Item');
        $fonts = new \stdClass();
        if (!empty($this->item)) {
            $link = 'https://fonts.googleapis.com/css?family=';
            $sublink = '';
            $this->customStr = '';
            foreach ($this->item as $key => $item) {
                $customFlag = false;
                if (empty($item->font)) {
                    continue;
                }
                if ($item->custom_src == 'web-safe-fonts') {
                    $customFlag = true;
                } else if (!empty($item->custom_src)) {
                	$str = "@font-face {font-family: '".str_replace('+', ' ', $item->font)."'; ";
	               	$str .= "font-weight: ".$item->styles."; ";
	                $str .= "src: url(".Uri::root()."templates/gridbox/library/fonts/".$item->custom_src.");}";
	                $this->customStr .= $str;
                    $customFlag = true;
                }
                if (!isset($fonts->{$item->font})) {
                    if (!empty($sublink) && !$customFlag) {
                        $sublink .= '%7C';
                    }
                    $fonts->{$item->font} = [];
                    if (!$customFlag) {
                        $sublink .= $item->font.':'.$item->styles;
                    }
                } else {
                    if (!$customFlag) {
                        $sublink .= ','.$item->styles;
                    }
                }
                $fonts->{$item->font}[] = $item;
            }
            if (!empty($sublink)) {
                $link .= $sublink.'&subset=latin,cyrillic,greek,latin-ext,greek-ext,vietnamese,cyrillic-ext';
                $doc->addStyleSheet($link);
            }
        }
        $this->item = $fonts;
        foreach ($this->item as $key => $value) {
            usort($value, function($a, $b){
                if ($a->styles == $b->styles) {
                    return 0;
                }

                return ($a->styles < $b->styles) ? -1 : 1;
            });
            $this->item->{$key} = $value;
        }
        
        parent::display($tpl);
    }
}