<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Site\View\Icons;

use Balbooa\Component\Gridbox\Site\Helper\GridboxHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\View\HtmlView as BaseView;
use Joomla\CMS\Uri\Uri;

defined('_JEXEC') or die;

class HtmlView extends BaseView
{
    public $items;

    public function display($tpl = null)
    {
        if (!Factory::getUser()->authorise('core.edit', 'com_gridbox')) {
            GridboxHelper::raiseError(403, Text::_('JERROR_ALERTNOAUTHOR'));
            return;
        }
        $this->items = $this->get('Item');
        $doc = Factory::getDocument();
        $doc->setTitle('Gridbox Editor');
        $doc->addScript(Uri::root().'/media/vendor/jquery/js/jquery.min.js');
        $doc->addScript(Uri::root().'/components/com_gridbox/libraries/bootstrap/bootstrap.js');
        $doc->addScript(Uri::root() . 'components/com_gridbox/assets/js/ba-icons.js');
        $doc->addStyleSheet(Uri::root() . 'components/com_gridbox/assets/css/ba-style-editor.css');
        
        parent::display($tpl);
    }
}