<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Site\View\Modules;

use Balbooa\Component\Gridbox\Site\Helper\GridboxHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\View\HtmlView as BaseView;
use Joomla\CMS\Uri\Uri;

defined('_JEXEC') or die;

class HtmlView extends BaseView
{
    public $items;
    public $positions;
    public $types;

    public function display ($tpl = null)
    {
        if (!Factory::getUser()->authorise('core.edit', 'com_gridbox')) {
            GridboxHelper::raiseError(403, Text::_('JERROR_ALERTNOAUTHOR'));
            return;
        }
        if (count($errors = $this->get('Errors'))) {
            GridboxHelper::raiseError(500, implode('<br />', $errors));
            return false;
        }
        $this->items = $this->get('Items');
        $this->positions = [];
        $this->types = [];
        $this->positions[''] = Text::_('SELECT_POSITION');
        $this->types[''] = Text::_('SELECT_TYPE');
        $filters = $this->get('Filters');
        foreach ($filters as $item) {
            if (!empty($item->position) && !in_array($item->position, $this->positions)) {
                $this->positions[$item->position] = $item->position;
            }
            $module = str_replace('mod_custom', 'Custom HTML', $item->module);
            if (!in_array($module, $this->types)) {
                $this->types[$item->module] = $module;
            }
        }
        $doc = Factory::getDocument();
        $doc->addStyleSheet('//fonts.googleapis.com/css?family=Roboto:300,400,500,700');
        $doc->setTitle('Gridbox Editor');
        $doc->addScript(Uri::root() . 'components/com_gridbox/assets/js/ba-modules.js');
        parent::display($tpl);
    }
}