<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Site\View\Uploader;

use Balbooa\Component\Gridbox\Site\Helper\GridboxHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\View\HtmlView as BaseView;
use Joomla\CMS\Uri\Uri;

defined('_JEXEC') or die;

class HtmlView extends BaseView
{
    protected $_limit;
    protected $about;
    protected $version;
    protected $uploader;
    
    public function display($tpl = null)
    {
        if (count($errors = $this->get('Errors'))) {
            GridboxHelper::raiseError(500, implode('<br />', $errors));
            return false;
        }
        $this->uploader = $this->get('Uploader');
        $this->about = GridboxHelper::aboutUs();
        $this->version = $this->about->version;
        $this->_limit = $this->uploader->limit;
        $doc = Factory::getDocument();
        $doc->addStyleSheet('//fonts.googleapis.com/css?family=Roboto:300,400,500,700');
        $doc->addScript(Uri::root().'/media/vendor/jquery/js/jquery.min.js');
        if ($doc->getDirection() == 'rtl') {
            $doc->addStyleSheet(Uri::root().'components/com_gridbox/assets/css/rtl-ba-style.css?'.$this->version);
        }
        $doc->setTitle('Gridbox Editor');
        
        parent::display($tpl);
    }
}