<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

use Balbooa\Component\Gridbox\Site\Helper\GridboxHelper;
use Balbooa\Component\Gridbox\Site\Helper\UploaderHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;

defined('_JEXEC') or die;

$currency = GridboxHelper::$store->currency;
$thousand = $currency->thousand;
$separator = $currency->separator;
$decimals = $currency->decimals;
$position = $currency->position;
$symbol = $currency->symbol;
$wishlist = $this->wishlist;
$lang = Factory::getLanguage();
$lang->load('com_users');
$hasSubmitted = false;
?>
<script>
    let statuses = <?php echo json_encode($this->statuses); ?>,
        currency = <?php echo json_encode($currency); ?>,
        customer = <?php echo json_encode($this->customer); ?>;
</script>
<div class="ba-account-wrapper">
    <ul class="nav nav-tabs">
<?php
    $i = 0;
    foreach ($this->submitted as $app) {
        $hasSubmitted = true;
?>
        <li class="<?php echo $i == 0 ? 'active' : '' ?>">
            <a href="#ba-submitted-app-<?php echo $app->id; ?>" data-toggle="tab">
                <span>
                    <span class="tabs-title"><?php echo $app->title; ?></span>
                    <i class="zmdi zmdi-file"></i>
                </span>
            </a>
        </li>
<?php
        $i++;
    }
?>
        <li class="<?php echo !$hasSubmitted ? 'active' : '' ?>">
            <a href="#ba-my-account-orders" data-toggle="tab">
                <span>
                    <span class="tabs-title"><?php echo Text::_('MY_ORDERS'); ?></span>
                    <i class="ba-icons ba-icon-shopping-basket"></i>
                </span>
            </a>
        </li>
<?php
    if (!empty($this->subscriptions->items)) {
?>
        <li>
            <a href="#ba-my-account-subscriptions" data-toggle="tab">
                <span>
                    <span class="tabs-title"><?php echo Text::_('MY_SUBSCRIPTIONS'); ?></span>
                    <i class="zmdi zmdi-time-restore"></i>
                </span>
            </a>
        </li>
<?php
    }
    if (!empty($this->digital->products)) {
?>
        <li>
            <a href="#ba-my-account-downloads" data-toggle="tab">
                <span>
                    <span class="tabs-title"><?php echo Text::_('MY_DOWNLOADS'); ?></span>
                    <i class="zmdi zmdi-cloud-download"></i>
                </span>
            </a>
        </li>
<?php
    }
    if (GridboxHelper::$store->wishlist->login) {
?>
        <li>
            <a href="#ba-my-account-wishlist" data-toggle="tab">
                <span>
                    <span class="tabs-title"><?php echo Text::_('MY_WISHLIST'); ?></span>
                    <i class="ba-icons ba-icon-heart"></i>
                </span>
            </a>
        </li>
<?php
    }
?>
        <li>
            <a href="#ba-my-account-billing-details" data-toggle="tab">
                <span>
                    <span class="tabs-title"><?php echo Text::_('MY_ADDRESS'); ?></span>
                    <i class="ba-icons ba-icon-truck"></i>
                </span>
            </a>
        </li>
        <li>
            <a href="#ba-my-account-profile" data-toggle="tab">
                <span>
                    <span class="tabs-title"><?php echo Text::_('MY_ACCOUNT'); ?></span>
                    <i class="ba-icons ba-icon-settings"></i>
                </span>
            </a>
        </li>
        <li>
            <a href="<?php echo Uri::root().'index.php?option=com_gridbox&view=editor&task=store.logout'; ?>">
                <span>
                    <span class="tabs-title"><?php echo Text::_('LOG_OUT'); ?></span>
                    <i class="ba-icons ba-icon-power"></i>
                </span>
            </a>
        </li>
    </ul>
    <div class="tab-content">
<?php
    $i = 0;
    foreach ($this->submitted as $app) {
?>
        <div class="tab-pane <?php echo $i == 0 ? 'active' : '' ?>" id="ba-submitted-app-<?php echo $app->id; ?>">
            <div class="ba-account-title-wrapper">
                <span class="ba-account-title"><?php echo $app->title; ?></span>
            </div>
            <div class="ba-account-table">
                <div class="ba-account-tbody submitted-items-list">
<?php
                foreach ($app->items as $item) {
                    
                    $view = GridboxHelper::getGridboxPageLinks($item->id, 'zero', $app->id, $item->page_category);
                    $image = GridboxHelper::prepareIntroImage($item->intro_image);
                    $date = explode(' ', $item->created);
                    if (!empty($image) && !GridboxHelper::isExternal($image)) {
                        $image = Uri::root().$image;
                    }
?>
                    <div class="ba-account-tr" data-id="<?php echo $item->id; ?>">
                        <div class="ba-account-td">
<?php
                        if (!empty($image)) {
?>
                            <span class="post-intro-image" style="background-image: url(<?php echo $image; ?>);"></span>
<?php
                        }
?>
                            <a href="<?php echo Route::_($view); ?>" target="_blank"><?php echo $item->title; ?></a>
                        </div>
                        <div class="ba-account-td">
                            <span><?php echo $item->category_title; ?></span>
                        </div>
                        <div class="ba-account-td">
                            <span><?php echo $date[0]; ?></span>
                        </div>
                        <div class="ba-account-td">
                            <span class="sumitted-item-icons">
<?php
                            if (isset($item->submission_form)) {
                                $link = GridboxHelper::getGridboxSystemLinks($item->submission_form).'&page_id='.$item->id;
?>
                                <span>
                                    <a class="zmdi zmdi-edit" href="<?php echo Route::_($link); ?>"
                                       target="_blank" aria-label="<?php echo Text::_('EDIT') . $item->title; ?>"></a>
                                    <span class="ba-tooltip ba-bottom"><?php echo Text::_('EDIT'); ?></span>
                                </span>
<?php
                            }
?>
                                <span>
                                    <i class="zmdi zmdi-delete delete-item" tabindex="0"
                                       aria-label="<?php echo Text::_('DELETE'); ?>"></i>
                                    <span class="ba-tooltip ba-bottom"><?php echo Text::_('DELETE'); ?></span>
                                </span>
                            </span>
                        </div>
                    </div>
<?php
                }
?>
                </div>
            </div>
        </div>
<?php
        $i++;
    }
?>
        <div class="tab-pane <?php echo !$hasSubmitted ? 'active' : '' ?>" id="ba-my-account-orders">
            <div class="ba-account-title-wrapper">
                <span class="ba-account-title"><?php echo Text::_('MY_ORDERS'); ?></span>
            </div>
            <div class="ba-account-table">
                <div class="ba-account-tbody">
<?php
                if (count($this->orders) == 0) {
?>
                    <div class="ba-empty-cart-products">
                        <span class="ba-empty-cart-products-message"><?php echo Text::_('NO_ORDERS_HAVE_BEEN_FOUND'); ?></span>
                    </div>
<?php
                }
                foreach ($this->orders as $order) {
                    $date = HTMLHelper::date($order->date, GridboxHelper::$dateFormat);
                    $price = GridboxHelper::$storeHelper->preparePrice($order->total, $thousand, $separator, $decimals);
                    $status = isset($this->statuses->{$order->status}) ? $this->statuses->{$order->status} : $this->statuses->undefined;
?>
                    <div class="ba-account-tr" data-id="<?php echo $order->id; ?>" tabindex="0">
                        <div class="ba-account-td">
                            <span><?php echo $date; ?></span>
                        </div>
                        <div class="ba-account-td">
                            <span><?php echo $order->order_number; ?></span>
                        </div>
                        <div class="ba-account-td">
                            <span style="--status-color: <?php echo $status->color; ?>"><?php echo $status->title; ?></span>
                        </div>
                        <div class="ba-account-td">
                            <span class="ba-account-price-wrapper <?php echo $order->currency_position; ?>">
                                <span class="ba-account-price-currency"><?php echo $order->currency_symbol; ?></span>
                                <span class="ba-account-price-value"><?php echo $price; ?></span>
                            </span>
                        </div>
                    </div>
<?php
                }
?>
                </div>
            </div>
        </div>
<?php
    if (!empty($this->subscriptions->items)) {
        $checkout = GridboxHelper::getStoreSystemUrl('checkout');
?>
        <div class="tab-pane" id="ba-my-account-subscriptions" data-checkout="<?php echo $checkout; ?>">
            <div class="ba-account-title-wrapper">
                <span class="ba-account-title"><?php echo Text::_('MY_SUBSCRIPTIONS'); ?></span>
            </div>
            <div class="ba-account-table">
                <div class="ba-account-thead">
                    <div class="ba-account-tr">
                        <div class="ba-account-td">
                            <span><?php echo Text::_('SUBSCRIPTION'); ?></span>
                        </div>
                        <div class="ba-account-td">
                            <span><?php echo Text::_('STATUS'); ?></span>
                        </div>
<?php
                    if ($this->subscriptions->expires) {
?>
                        <div class="ba-account-td ba-expire-td">
                            <span><?php echo Text::_('EXPIRES'); ?></span>
                        </div>
<?php
                    }
                    if ($this->subscriptions->renew) {
?>
                        <div class="ba-account-td"></div>
<?php
                    }
                    if ($this->subscriptions->upgrade) {
?>
                        <div class="ba-account-td"></div>
<?php
                    }
?>
                    </div>
                </div>
                <div class="ba-account-tbody">
<?php
                $now = date('Y-m-d H:i:s');
                foreach ($this->subscriptions->items as $item) {
                    if ($item->refunded) {
                        continue;
                    }
                    $status = empty($item->expires) || $now < $item->expires ? 'ACTIVE' : 'EXPIRED';
?>
                    <div class="ba-account-tr">
                        <div class="ba-account-td">
                            <span><?php echo $item->title; ?></span>
                        </div>
                        <div class="ba-account-td">
                            <span data-status="<?php echo strtolower($status); ?>"><?php echo Text::_($status); ?></span>
                        </div>
<?php
                    if ($this->subscriptions->expires) {
                        $expire = !empty($item->expires) ? GridboxHelper::formatDate($item->expires) : '';
?>
                        <div class="ba-account-td ba-expire-td">
                            <span><?php echo $expire; ?></span>
                        </div>
<?php
                    }
                    if ($this->subscriptions->renew) {
?>
                        <div class="ba-account-td ba-renew-td">
<?php
                        if (!empty($item->plans)) {
?>
                            <span class="ba-account-btn ba-renew-subscription"
                                  tabindex="0" data-product="<?php echo $item->product_id; ?>"
                                  data-id="<?php echo $item->id ?>">
                                <?php echo Text::_('RENEW'); ?>
                            </span>
                            <template><?php echo json_encode($item->plans); ?></template>
<?php
                        }
?>
                        </div>
<?php
                    }
                    if ($this->subscriptions->upgrade) {
?>
                        <div class="ba-account-td">
<?php
                        if (!empty($item->upgrade_plans)) {
?>
                            <span class="ba-upgrade-subscription"
                                  tabindex="0" data-id="<?php echo $item->id ?>">
                                <?php echo Text::_('CHANGE_PLAN'); ?>
                            </span>
                            <template><?php echo json_encode($item->upgrade_plans); ?></template>
<?php
                        }
?>
                        </div>
<?php
                    }
?>
                    </div>
<?php
                }
?>
                </div>
            </div>
        </div>
<?php
    }
    if (!empty($this->digital->products)) {
?>
        <div class="tab-pane" id="ba-my-account-downloads">
            <div class="ba-account-title-wrapper">
                <span class="ba-account-title"><?php echo Text::_('MY_DOWNLOADS'); ?></span>
            </div>
            <div class="ba-account-table">
                <div class="ba-account-thead">
                    <div class="ba-account-tr">
                        <div class="ba-account-td">
                            <span><?php echo Text::_('PRODUCT'); ?></span>
                        </div>
<?php
                    if (!empty($this->digital->expires)) {
?>
                        <div class="ba-account-td ba-expire-td">
                            <span><?php echo Text::_('EXPIRES'); ?></span>
                        </div>
<?php
                    }
                    if (!empty($this->digital->limit)) {
?>
                        <div class="ba-account-td">
                            <span><?php echo Text::_('REMAINING'); ?></span>
                        </div>
<?php
                    }
?>
                        <div class="ba-account-td"></div>
                    </div>
                </div>
                <div class="ba-account-tbody">
<?php
                foreach ($this->digital->products as $product) {
                    if (!empty($product->license->expires)) {
                        $expire = GridboxHelper::formatDate($product->license->expires);
                    } else  {
                        $expire = '-';
                    }
                    $remaining = !empty($product->license->limit) ? $product->license->downloads.' / '.$product->license->limit : '-';
?>
                    <div class="ba-account-tr">
                        <div class="ba-account-td">
<?php
                        if (!empty($product->image)) {
                            $image = (!GridboxHelper::isExternal($product->image) ? Uri::root() : '').$product->image;
?>
                            <span class="ba-account-product-image">
                                <img src="<?php echo $image; ?>">
                            </span>
<?php
                        }
?>
                            <span><?php echo $product->title; ?></span>
                        </div>
<?php
                    if (!empty($this->digital->expires)) {
?>
                        <div class="ba-account-td ba-expire-td">
                            <span><?php echo $expire; ?></span>
                        </div>
<?php
                    }
                    if (!empty($this->digital->limit)) {
?>
                        <div class="ba-account-td">
                            <span><?php echo $remaining; ?></span>
                        </div>
<?php
                    }
?>
                        <div class="ba-account-td">
                            <a class="ba-account-btn" href="<?php echo $product->link; ?>">
                                <?php echo Text::_('DOWNLOAD'); ?>
                            </a>
                        </div>
                    </div>
<?php
                }
?>
                </div>
            </div>
        </div>
<?php
    }
    if (GridboxHelper::$store->wishlist->login) {
?>
        <div class="tab-pane" id="ba-my-account-wishlist">
            <div class="ba-account-title-wrapper">
                <span class="ba-account-title"><?php echo Text::_('MY_WISHLIST'); ?></span>
            </div>
            <div class="ba-my-account-wishlist">
<?php
            $uploader = new UploaderHelper();
            include JPATH_ROOT.'/components/com_gridbox/tmpl/layout/patterns/store/wishlist-products-list.php';
?>
            </div>
        </div>
<?php
    }
?>
        <div class="tab-pane" id="ba-my-account-billing-details">
            <div class="ba-account-title-wrapper">
                <span class="ba-account-title"><?php echo Text::_('MY_ADDRESS'); ?></span>
                <span class="ba-account-btn save-user-customer-info" tabindex="0"><?php echo Text::_('SAVE'); ?></span>
            </div>
            <div class="ba-my-account-billing-details">
<?php
                $out = GridboxHelper::getCustomerInfoHTML(0, null, true);
                echo $out;
?>
            </div>
        </div>
        <div class="tab-pane" id="ba-my-account-profile">
            <div class="ba-account-title-wrapper">
                <span class="ba-account-title"><?php echo Text::_('MY_ACCOUNT'); ?></span>
                <span class="ba-account-btn save-user-profile-data" tabindex="0"><?php echo Text::_('SAVE'); ?></span>
            </div>
            <div class="ba-my-account-profile">
                <div class="ba-account-profile-fields" style="--ba-checkout-field-width:50%;">
                    <div class="ba-account-profile-title-wrapper">
                        <span class="ba-account-profile-title"><?php echo Text::_('NAME'); ?></span>
                        <span class="ba-account-profile-required-star">*</span>
                    </div>
                    <div class="ba-account-profile-field-wrapper">
                        <input aria-label="<?php echo Text::_('ENTER_NAME'); ?>" type="text" name="name" value="<?php echo $this->user->name; ?>">
                    </div>
                </div>
                <div class="ba-account-profile-fields" style="--ba-checkout-field-width:50%;">
                    <div class="ba-account-profile-title-wrapper">
                        <span class="ba-account-profile-title"><?php echo Text::_('COM_USERS_PROFILE_USERNAME_LABEL'); ?></span>
                    </div>
                    <div class="ba-account-profile-field-wrapper">
                        <input aria-label="<?php echo Text::_('ENTER_USERNAME'); ?>" type="text" name="username" value="<?php echo $this->user->username; ?>" readonly>
                    </div>
                </div>
                <div class="ba-account-profile-fields" style="--ba-checkout-field-width:50%;">
                    <div class="ba-account-profile-title-wrapper">
                        <span class="ba-account-profile-title">
                            <?php echo Text::_('COM_USERS_PROFILE_PASSWORD1_LABEL'); ?>
                        </span>
                    </div>
                    <div class="ba-account-profile-field-wrapper">
                        <input aria-label="<?php echo Text::_('ENTER_PASSWORD'); ?>" type="password" name="password1" autocomplete="new-password">
                    </div>
                </div>
                <div class="ba-account-profile-fields" style="--ba-checkout-field-width:50%;">
                    <div class="ba-account-profile-title-wrapper">
                        <span class="ba-account-profile-title">
                            <?php echo Text::_('COM_USERS_PROFILE_PASSWORD2_LABEL'); ?>
                        </span>
                    </div>
                    <div class="ba-account-profile-field-wrapper">
                        <input aria-label="<?php echo Text::_('COM_USERS_PROFILE_PASSWORD2_LABEL'); ?>" type="password" name="password2" autocomplete="new-password">
                    </div>
                </div>
                <div class="ba-account-profile-fields" style="--ba-checkout-field-width:100%;">
                    <div class="ba-account-profile-title-wrapper">
                        <span class="ba-account-profile-title"><?php echo Text::_('COM_USERS_PROFILE_EMAIL1_LABEL'); ?></span>
                        <span class="ba-account-profile-required-star">*</span>
                    </div>
                    <div class="ba-account-profile-field-wrapper">
                        <input aria-label="<?php echo Text::_('ENTER_EMAIL'); ?>" type="text" name="email1" value="<?php echo $this->user->email; ?>">
                    </div>
                </div>
            </div>
<?php
        if ($this->author) {
            $img = '';
            if (!empty($this->author->avatar)) {
                $img = 'background-image: url('.Uri::root().$this->author->avatar.');';
            }
?>
            <div class="ba-account-title-wrapper">
                <span class="ba-account-title"><?php echo Text::_('AUTHOR_INFO'); ?></span>
            </div>
            <div class="ba-author-info">
                <div class="ba-account-profile-fields" style="--ba-checkout-field-width:100%;">
                    <div class="ba-account-profile-title-wrapper">
                        <span class="ba-account-profile-title"><?php echo Text::_('NAME'); ?></span>
                    </div>
                    <div class="ba-account-profile-field-wrapper">
                        <input aria-label="<?php echo Text::_('ENTER_NAME'); ?>" type="text" name="title" value="<?php echo $this->author->title; ?>">
                    </div>
                </div>
                <div class="ba-account-profile-fields" style="--ba-checkout-field-width:100%;">
                    <div class="ba-account-profile-title-wrapper">
                        <span class="ba-account-profile-title"><?php echo Text::_('PROFILE_PICTURE'); ?></span>
                    </div>
                    <div class="ba-account-profile-field-wrapper">
                        <div class="image-profile-wrapper">
                            <input type="text" name="image" placeholder="<?php echo Text::_('SELECT'); ?>" readonly
                                   aria-label="<?php echo Text::_('SELECT_PROFILE_PICTURE'); ?>"
                                   class="select-image-profile"
                                   data-value="<?php echo $this->author->avatar; ?>"
                                   value="<?php echo !empty($this->author->avatar) ? basename($this->author->avatar) : ''; ?>">
                            <i class="zmdi zmdi-camera"></i>
                            <div class="image-field-tooltip" style="<?php echo $img; ?>"></div>
                            <div class="reset-image-profile" tabindex="0">
                                <i class="zmdi zmdi-close"></i>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="ba-account-profile-fields" style="--ba-checkout-field-width:100%;">
                    <div class="ba-account-profile-title-wrapper">
                        <span class="ba-account-profile-title"><?php echo Text::_('DESCRIPTION'); ?></span>
                    </div>
                    <div class="ba-account-profile-field-wrapper">
                        <textarea aria-label="<?php echo Text::_('SELECT_PROFILE_PICTURE'); ?>" name="description"><?php echo $this->author->description; ?></textarea>
                    </div>
                </div>
            </div>
<?php
        }
?>
        </div>
    </div>
</div>
<div class="ba-account-order-details-backdrop ba-hidden-order-details">
    <div class="ba-account-order-details-wrapper">
        <div class="ba-account-order-details">
            <div class="ba-account-order-header-wrapper">
                <div class="ba-account-order-header">
                    <span class="ba-account-order-number"></span>
                    <span class="ba-account-order-status"></span>
                </div>
                <div class="ba-account-order-header">
                    <span class="ba-account-order-date"></span>
                    <span class="ba-account-order-icons-wrapper">
                        <span class="ba-account-order-icon-wrapper">
                            <i class="ba-icons ba-icon-download ba-btn-transition"
                               tabindex="0" aria-label="<?php echo Text::_('DOWNLOAD') ?>"
                               data-layout="pdf"></i>
                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('DOWNLOAD') ?></span>
                        </span>
                        <span class="ba-account-order-icon-wrapper">
                            <i class="ba-icons ba-icon-print ba-btn-transition"
                               tabindex="0" aria-label="<?php echo Text::_('PRINT') ?>"
                               data-layout="print"></i>
                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('PRINT') ?></span>
                        </span>
                    </span>
                    <i class="ba-icons ba-icon-close ba-btn-transition ba-account-close-order-details"
                       tabindex="0" aria-label="<?php echo Text::_('CLOSE') ?>"></i>
                </div>
            </div>
            <div class="ba-account-order-customer-info">
                <div class="ba-account-order-body">
                    
                </div>
            </div>
            <div class="ba-account-order-info">
                <div class="ba-account-order-body">

                </div>
            </div>
        </div>
    </div>
</div>
<div class="ba-account-modal-backdrop ba-hidden-account-modal" data-type="renewal">
    <div class="ba-account-md-modal-wrapper">
        <div class="ba-account-modal">
            <div class="ba-account-modal-header">
                <span class="ba-account-modal-title"><?php echo Text::_('RENEWAL') ?></span>
                <i class="ba-icons ba-icon-close ba-btn-transition ba-account-modal-close" tabindex="0"></i>
            </div>
            <div class="ba-account-modal-body">
                
            </div>
            <div class="ba-account-modal-footer">
                <span class="ba-account-modal-footer-btn ba-subscription-renewal-btn" tabindex="0"><?php echo Text::_('RENEW') ?></span>
            </div>
        </div>
    </div>
</div>
<div class="ba-account-modal-backdrop ba-hidden-account-modal" data-type="upgrade">
    <div class="ba-account-md-modal-wrapper">
        <div class="ba-account-modal">
            <div class="ba-account-modal-header">
                <span class="ba-account-modal-title"><?php echo Text::_('CHANGE_PLAN') ?></span>
                <i class="ba-icons ba-icon-close ba-btn-transition ba-account-modal-close" tabindex="0"></i>
            </div>
            <div class="ba-account-modal-body">
                
            </div>
            <div class="ba-account-modal-footer">
                <span class="ba-account-modal-footer-btn ba-subscription-upgrade-btn" tabindex="0"><?php echo Text::_('CONTINUE') ?></span>
            </div>
        </div>
    </div>
</div>
<div id="delete-dialog" class="ba-modal-sm modal hide" style="display:none">
    <div class="modal-body">
        <h3 class="ba-modal-title"><?php echo Text::_('DELETE_ITEM'); ?></h3>
        <p class="modal-text"><?php echo Text::_('MODAL_DELETE') ?></p>
    </div>
    <div class="modal-footer">
        <a href="#" class="ba-btn" data-dismiss="modal">
            <?php echo Text::_('CANCEL') ?>
        </a>
        <a href="#" class="ba-btn-primary red-btn" id="apply-delete">
            <?php echo Text::_('DELETE') ?>
        </a>
    </div>
</div>
<template data-key="product-row">
    <div class="ba-account-order-product-row row-fluid" data-extra-count="8">
        <div class="ba-account-order-product-image-cell">
            <img src="">
        </div>
        <div class="ba-account-order-product-content-cell">
            <div class="ba-account-order-product-content-inner-cell">
                <div class="ba-account-order-product-title-cell">
                    <span class="ba-account-order-product-title"></span>
                    <span class="ba-account-order-product-booking">
                        <span class="ba-account-order-product-booking-date"></span>
                        <span class="ba-account-order-product-booking-time"></span>
                        <span class="ba-account-order-product-booking-guests"></span>
                    </span>
                    <span class="ba-account-order-product-info"></span>
                </div>
                <div class="ba-account-order-product-quantity-cell"></div>
                <div class="ba-account-order-product-price-cell">
                    <span class="ba-account-order-price-wrapper">
                        <span class="ba-account-order-price-currency"></span>
                        <span class="ba-cart-price-value"></span>
                    </span>
                </div>
            </div>
        </div>
    </div>
</template>
<template data-key="product-attachment">
    <div class="ba-product-attachment">
        <span class="attachment-image"></span>
        <i class="ba-icons ba-icon-attachment"></i>
        <span class="attachment-title"></span>
    </div>
</template>
<template data-key="extra-options">
    <div class="ba-account-order-product-extra-options">
        <span class="ba-account-order-product-extra-options-title"></span>
        <div class="ba-account-order-product-extra-options-content">
            
        </div>
    </div>
</template>
<template data-key="extra-option">
    <div class="ba-account-order-product-extra-option">
        <span class="ba-account-order-product-extra-option-value"></span>
        <span class="ba-account-order-product-extra-option-price">
            <span class="ba-account-order-price-currency"></span>
            <span class="ba-cart-price-value"></span>
        </span>
    </div>
</template>
<template data-key="order-methods">
    <div class="ba-account-order-methods-wrapper">
        <div class="ba-account-order-shipping-method">
            <span class="ba-account-order-row-title"><?php echo Text::_('SHIPPING'); ?></span>
            <span class="ba-account-order-row-value"></span>
        </div>
        <div class="ba-account-order-payment-method">
            <span class="ba-account-order-row-title"><?php echo Text::_('PAYMENT'); ?></span>
            <span class="ba-account-order-row-value"></span>
        </div>
        <div class="ba-account-booking-payment-method">
            <div class="ba-account-booking-payment-row">
                <span class="ba-account-order-row-title"><?php echo Text::_('PAYMENT'); ?></span>
            </div>
            <div class="ba-account-booking-payment-row" data-type="paid">
                <label class="ba-account-order-row-title"><?php echo Text::_('ALREADY_PAID'); ?></label>
                <div class="ba-account-order-product-price-cell">
                    <span class="ba-account-order-price-wrapper">
                        <span class="ba-account-order-price-currency"></span>
                        <span class="ba-cart-price-value"></span>
                    </span>
                </div>
            </div>
            <div class="ba-account-booking-payment-row" data-type="left">
                <label class="ba-account-order-row-title"><?php echo Text::_('LEFT_TO_PAY'); ?></label>
                <div class="ba-account-order-product-price-cell">
                    <span class="ba-account-order-price-wrapper">
                        <span class="ba-account-order-price-currency"></span>
                        <span class="ba-cart-price-value"></span>
                    </span>
                </div>
            </div>
        </div>
        <div class="ba-account-order-coupon-code">
            <span class="ba-account-order-row-title"><?php echo Text::_('COUPON_CODE'); ?></span>
            <span class="ba-account-order-row-value"></span>
        </div>
    </div>
</template>
<template data-key="subtotal">
    <div class="ba-account-order-subtotal-wrapper">
        <div class="ba-account-order-subtotal">
            <span class="ba-account-order-row-title"><?php echo Text::_('SUBTOTAL'); ?></span>
            <div class="ba-account-order-product-price-cell">
                <span class="ba-account-order-price-wrapper">
                    <span class="ba-account-order-price-currency"></span>
                    <span class="ba-cart-price-value"></span>
                </span>
            </div>
        </div>
        <div class="ba-account-order-discount">
            <span class="ba-account-order-row-title"><?php echo Text::_('DISCOUNT'); ?></span>
            <div class="ba-account-order-product-price-cell">
                <span class="ba-account-order-price-wrapper">
                    <span class="ba-cart-price-minus">-</span>
                    <span class="ba-account-order-price-currency"></span>
                    <span class="ba-cart-price-value"></span>
                </span>
            </div>
        </div>
        <div class="ba-account-order-shipping">
            <span class="ba-account-order-row-title"><?php echo Text::_('SHIPPING'); ?></span>
            <div class="ba-account-order-product-price-cell">
                <span class="ba-account-order-price-wrapper">
                    <span class="ba-account-order-price-currency"></span>
                    <span class="ba-cart-price-value"></span>
                </span>
            </div>
        </div>
        <div class="ba-account-order-shipping-tax" data-tax="excl">
            <span class="ba-account-order-row-title"><?php echo Text::_('TAX_ON_SHIPPING'); ?></span>
            <div class="ba-account-order-product-price-cell">
                <span class="ba-account-order-price-wrapper">
                    <span class="ba-account-order-price-currency"></span>
                    <span class="ba-cart-price-value"></span>
                </span>
            </div>
        </div>
        <div class="ba-account-order-shipping-tax" data-tax="incl">
            <span class="ba-account-order-row-title">
                <span class="ba-account-tax-title"></span>
                <span class="ba-account-order-price-wrapper">
                    <span class="ba-account-order-price-currency"></span>
                    <span class="ba-cart-price-value"></span>
                </span>
            </span>
        </div>
        <div class="ba-account-order-tax" data-tax="excl">
            <span class="ba-account-order-row-title"></span>
            <div class="ba-account-order-product-price-cell">
                <span class="ba-account-order-price-wrapper">
                    <span class="ba-account-order-price-currency"></span>
                    <span class="ba-cart-price-value"></span>
                </span>
            </div>
        </div>
    </div>
</template>
<template data-key="total">
    <div class="ba-account-order-total">
        <span class="ba-account-order-row-title"><?php echo Text::_('TOTAL'); ?></span>
        <div class="ba-account-order-product-price-cell">
            <span class="ba-account-order-price-wrapper">
                <span class="ba-account-order-price-currency"></span>
                <span class="ba-cart-price-value"></span>
            </span>
        </div>
    </div>
    <div class="ba-account-order-tax" data-tax="incl">
        <span class="ba-account-order-row-title">
            <span class="ba-account-tax-title"></span>
            <span class="ba-account-order-price-wrapper">
                <span class="ba-account-order-price-currency"></span>
                <span class="ba-cart-price-value"></span>
            </span>
        </span>
    </div>
</template>
<template data-key="info-title">
    <div class="ba-account-order-customer-info-title">
        Contact Information
    </div>
</template>
<template data-key="info-row">
    <div class="ba-account-order-customer-info-row">
        First Name: Vladimir
    </div>
</template>
<template data-key="account-modal-row">
    <div class="ba-account-modal-row">
        <div class="ba-checkbox-wrapper">
            <span class="ba-account-order-price-wrapper">
                <span class="ba-account-order-price-currency"></span>
                <span class="ba-cart-price-value"></span>
            </span>
            <span class="ba-account-modal-row-title"><span class="ba-account-modal-row-title-value"></span></span>
            <label class="ba-radio">
                <input type="radio" name="account-radio">
                <span></span>
            </label>
        </div>
    </div>
</template>