<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

defined('_JEXEC') or die;

use Joomla\CMS\Language\Associations;
use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Language\Text;
use Balbooa\Component\Gridbox\Site\Helper\GridboxHelper;
use Balbooa\Component\Gridbox\Site\Helper\FieldsHelper;


$url = 'index.php?option=com_gridbox&view=gridbox&app_id='.$this->app;
if (Associations::isEnabled() && isset($this->item->language) && $this->item->language != '*') {
    $url .= '&lang='.$this->item->language;
}
$blogFlag = false;
$systemType = isset($this->item->type) ? 'system-type-'.$this->item->type : '';
if ($this->edit_type != '') {
    $url .= '&edit_type='.$this->edit_type;
    $blogFlag = true;
}
$input = Factory::getApplication()->input;
$id = $input->get('id', 0, 'int');
$url .= '&category='.$this->category.'&id='.$id;
if (Associations::isEnabled() && isset($this->item->language) && $this->item->language != '*') {
    $url = Route::_($url);
} else {
    $url = Uri::root().$url;
}
$newPage = Uri::root().'index.php?option=com_gridbox&view=editor&tmpl=component';
if ($this->app != 0) {
    $newPage .= '&app_id='.$this->app;
}
if (!empty($this->category)) {
    $newPage .= '&category='.$this->category;
}
if ($this->edit_type == 'system') {
    $newPage = Uri::root().'index.php?option=com_gridbox&view=editor&tmpl=component&edit_type=system';
}
$newPage .= '&id=';
$app = Factory::getApplication();
$gridboxId = $app->input->get('id');
$user = Factory::getUser();
$datesFormats = [
    "j F Y" => "11 April 2016", "F jS, Y" => "April 11th, 2016",
    "F j, Y g:i a" => "April 11, 2016 11:36 am", "M d, Y" => "Apr 11, 2016",
    "d M, Y" => "11 Apr, 2016"
];
$dateFormatValue = isset($datesFormats[GridboxHelper::$dateFormat]) ? GridboxHelper::$dateFormat : '';
$htmlPath = JPATH_COMPONENT.'/tmpl/editor/html/';
$flags = Uri::root().'components/com_gridbox/assets/images/flags/';
if ($this->edit_type == '') {
    $multicategory = (object)[
        'title' => [!empty($this->category) ? $this->categoryList[$this->category]->title : ''],
        'categories' => []
    ];
    if (isset($this->item->categories)) {
        foreach ($this->item->categories as $category) {
            $multicategory->categories[] = $category->category_id;
            $multicategory->title[] = $this->categoryList[$category->category_id]->title;
        }
    }
}

?>
<script src="<?php echo Uri::root(); ?>components/com_gridbox/assets/js/ba-editor.js"></script>
<script src="<?php echo Uri::root(); ?>index.php?option=com_gridbox&task=editor.loadModule&module=gridboxLanguage"></script>
<?php
if ($this->edit_type == '') {
    $robotsArray = ['index, follow' => 'index, follow', 'noindex, follow' => 'noindex, follow',
            'index, nofollow' => 'index, nofollow', 'noindex, nofollow' => 'noindex, nofollow'];
    $robots = !empty($this->item->robots) ? $robotsArray[$this->item->robots] : Text::_('JGLOBAL_USE_GLOBAL');
}
$blogStyle = empty($this->item->app_type) || $this->item->app_type == 'single' ? ' style="display:none;"' : '';
$pageDataTags = empty($this->item->app_type) || $this->item->app_type == 'single' ? 'page-data-tags-template' : 'post-data-tags-template';
if ($this->edit_type == '' && $this->item->app_type != 'single' && $this->item->app_type != '') {
    $intro_image = GridboxHelper::prepareIntroImage($this->item->intro_image);
    $introImageClassName = empty($intro_image) ? ' empty-intro-image' : '';
    $intro_image = !empty($intro_image) ? $intro_image : 'components/com_gridbox/assets/images/default-theme.png';
    if ($this->item->app_type == 'blog') {
?>
<script>
    if (localStorage.getItem('advanced-blog-editor') == 'true') {
        document.body.classList.add('advanced-blog-editor');
    }
</script>
<?php
    }
?>
<div class="blog-post-editor-right-panel">
    <ul class="nav nav-tabs uploader-nav">
        <li class="active">
            <a href="#blog-post-editor-general-options" data-toggle="tab">
                <i class="zmdi zmdi-settings"></i>
                <span class="ba-tooltip ba-bottom"><?php echo Text::_('GENERAL'); ?></span>
            </a>
        </li>
        <li>
            <a href="#blog-post-editor-publishing-options" data-toggle="tab">
                <i class="zmdi zmdi-calendar-note"></i>
                <span class="ba-tooltip ba-bottom"><?php echo Text::_('PUBLISHING'); ?></span>
            </a>
        </li>
        <li>
            <a href="#blog-post-editor-seo-options" data-toggle="tab">
                <i class="zmdi zmdi-globe"></i>
                <span class="ba-tooltip ba-bottom">SEO</span>
            </a>
        </li>
        <li>
            <a href="#blog-post-editor-sharing-options" data-toggle="tab">
                <i class="zmdi zmdi-share"></i>
                <span class="ba-tooltip ba-bottom"><?php echo Text::_('SHARING'); ?></span>
            </a>
        </li>
    </ul>
    <div class="tab-content">
        <div class="tab-pane active" id="blog-post-editor-general-options">
<?php
            $intro_image = str_replace(' ', '%20', $intro_image);
            $tooltipImage = !GridboxHelper::isExternal($intro_image) ? Uri::root().$intro_image : $intro_image;
?>
            <div class="blog-post-editor-img-thumbnail<?php echo $introImageClassName; ?>"
                <?php echo empty($introImageClassName) ? 'style="background-image: url('.$tooltipImage.');"' : ''; ?>>
                <div class="intro-image-delete-icon-wrapper">
                    <i class="zmdi zmdi-delete"></i>
                </div>
                <div class="empty-intro-icon-wrapper">
                    <i class="zmdi zmdi-wallpaper"></i>
                </div>
                <div class="camera-container">
                    <i class="zmdi zmdi-camera"></i>
                </div>
            </div>
            <div class="blog-post-editor-options-group">
                <div class="blog-post-editor-group-element">
                    <label>
                        <?php echo Text::_('JGLOBAL_TITLE'); ?><span class="required-fields-star">*</span>
                    </label>
                    <input type="text" class="page-title page-settings-input-trigger"
                        value="<?php echo htmlentities($this->item->title, ENT_COMPAT, 'utf-8'); ?>" name="page_title">
                </div>
            </div>
            <div class="blog-post-editor-options-group">
                <div class="blog-post-editor-group-element">
                    <label>
                        <?php echo Text::_('JFIELD_ALIAS_LABEL'); ?>
                    </label>
                    <input type="text" class="page-alias page-settings-input-trigger"
                        value="<?php echo $this->item->page_alias; ?>" name="page_alias">
                </div>
            </div>
            <div class="blog-post-editor-options-group">
                <div class="blog-post-editor-group-element">
                    <label>
                        <?php echo Text::_('INTRO_TEXT'); ?>
                    </label>
                    <textarea class="intro-text page-settings-input-trigger"
                        name="intro_text"><?php echo $this->item->intro_text; ?></textarea>
                </div>
            </div>
            <div class="blog-post-editor-options-group">
                <div class="blog-post-editor-group-element">
                    <label>
                        <?php echo Text::_('CATEGORY'); ?>
                    </label>
                    <div class="page-multicategory-select">
                        <input readonly onfocus="this.blur()" type="text" value="<?php echo implode(', ', $multicategory->title); ?>">
                        <input type="hidden" name="page_category" class="page-category" value="<?php echo $this->item->page_category; ?>">
                        <input type="hidden" name="page_categories" value="<?php echo implode(', ', $multicategory->categories); ?>">
                        <i class="zmdi zmdi-caret-down"></i>
                    </div>
                </div>
            </div>
            <div class="blog-post-editor-options-group">
                <div class="blog-post-editor-group-element">
                    <div class="ba-tags">
                        <label>
                            <?php echo Text::_('TAGS'); ?>
                        </label>
                        <div class="meta-tags visible-select-top">
                            <select style="display: none;" name="meta_tags[]" class="meta_tags" multiple>
<?php
                            foreach ($this->pageTags as $tag) {
                                $str = '<option value="'.$tag->id.'" selected>'.$tag->title.'</option>';
                                echo $str;
                            }
?>
                            </select>
                            <ul class="picked-tags">
<?php
                            foreach ($this->pageTags as $tag) {
                                $str = '<li class="tags-chosen"><span>';
                                $str .= $tag->title.'</span><i class="zmdi zmdi-close" data-remove="'.$tag->id.'"></i></li>';
                                echo $str;
                            }
?>
                                <li class="search-tag">
                                    <input type="text" placeholder="<?php echo Text::_('TAGS'); ?>">
                                </li>
                            </ul>
                            <div class="select-post-tags input-action-icon">
                                <i class="zmdi zmdi-playlist-plus"></i>
                                <span class="ba-tooltip ba-top"><?php echo Text::_('TAGS'); ?></span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="blog-post-editor-options-group">
                <div class="blog-post-editor-group-element">
                    <label>
                        <?php echo Text::_('CLASS_SUFFIX'); ?>
                    </label>
                    <input type="text" class="page-class-suffix"
                        value="<?php echo htmlentities($this->item->class_suffix, ENT_COMPAT, 'utf-8'); ?>"
                        data-value="<?php echo htmlentities($this->item->class_suffix, ENT_COMPAT, 'utf-8'); ?>" name="class_suffix">
                </div>
            </div>
        </div>
        <div class="tab-pane" id="blog-post-editor-publishing-options">
            <div class="blog-post-editor-options-group">
                <div class="blog-post-editor-group-element">
                    <label>
                        <?php echo Text::_('STATUS'); ?>
                    </label>
                    <div class="ba-custom-select page-settings-custom-select-trigger">
                        <input readonly onfocus="this.blur()" type="text"
                            value="<?php echo $this->item->published ? Text::_('PUBLISHED') : Text::_('UNPUBLISHED'); ?>">
                        <input type="hidden" name="published" value="<?php echo $this->item->published; ?>">
                        <i class="zmdi zmdi-caret-down"></i>
                        <ul>
                            <li data-value="1"><?php echo Text::_('PUBLISHED'); ?></li>
                            <li data-value="0"><?php echo Text::_('UNPUBLISHED'); ?></li>
                        </ul>
                    </div>
                </div>
                <div class="blog-post-editor-group-element">
                    <label>
                        <?php echo Text::_('JFIELD_ACCESS_LABEL'); ?>
                    </label>
                    <div class="ba-custom-select access-select page-settings-custom-select-trigger">
                        <input readonly onfocus="this.blur()" type="text"
                            value="<?php echo $this->access[$this->item->page_access]; ?>">
                        <input type="hidden" name="access" value="<?php echo $this->item->page_access; ?>">
                        <i class="zmdi zmdi-caret-down"></i>
                        <ul>
<?php
                            foreach ($this->access as $key => $access) {
                                $str = '<li data-value="'.$key.'">';
                                $str .= $access.'</li>';
                                echo $str;
                            }
?>
                        </ul>
                    </div>
                </div>
                <div class="blog-post-editor-group-element">
                    <label>
                        <?php echo Text::_('START_PUBLISHING'); ?>
                    </label>
                    <div class="container-icon">
                        <input type="text" name="published_on"
                            class="published_on page-settings-input-trigger open-calendar-dialog"
                            value="<?php echo $this->item->created; ?>">
                        <div class="icons-cell">
                            <i class="zmdi zmdi-calendar-alt"></i>
                        </div>
                    </div>
                </div>
                <div class="blog-post-editor-group-element">
                    <label>
                        <?php echo Text::_('END_PUBLISHING'); ?>
                    </label>
                    <div class="container-icon">
<?php
                        $end = $this->item->end_publishing == '0000-00-00 00:00:00' ? '' : $this->item->end_publishing;
?>
                        <input type="text" name="published_down"
                            class="published_down page-settings-input-trigger open-calendar-dialog"
                            value="<?php echo $end; ?>">
                        <div class="icons-cell">
                            <i class="zmdi zmdi-calendar-alt"></i>
                        </div>
                    </div>
                </div>
                <div class="blog-post-editor-group-element ba-author-element-wrapper"
                    <?php echo count($this->authors) == 0 ? ' style="display: none;"' : ''; ?>>
                    <label>
                        <?php echo Text::_('AUTHOR'); ?>
                    </label>
                    <div class="ba-custom-author-select-wrapper">
<?php
                        $authors = [];
                        foreach ($this->item->authors as $author) {
                            if (empty($author->avatar)) {
                                $author->avatar = 'components/com_gridbox/assets/images/thumb-square.png';
                            }
                            $str = '<span class="selected-author" data-id="'.$author->id;
                            $str .= '"><span class="ba-author-avatar" style="background-image: url(';
                            $str .= Uri::root().$author->avatar.')"></span><span class="ba-author-name">'.$author->title.'</span>';
                            $str .= '<i class="zmdi zmdi-close remove-selected-author"></i></span>';
                            echo $str;
                            $authors[] = $author->id;
                        }
                        $authorId = implode(',', $authors);
?>
                        <div class="ba-custom-author-select select-post-author"
                            <?php echo count($authors) == count($this->authors) ? ' style="display: none;"' : ''; ?>>
                            <input readonly type="text" placeholder="<?php echo Text::_('AUTHOR'); ?>">
                            <input type="hidden" name="author" value="<?php echo $authorId; ?>">
                            <ul>
                                <?php
                                foreach ($this->authors as $author) {
                                    if (empty($author->avatar)) {
                                        $author->avatar = 'components/com_gridbox/assets/images/thumb-square.png';
                                    }
                                    $str = '<li data-value="'.$author->id.'" data-image="'.Uri::root().$author->avatar;
                                    $str .= '"'.(in_array($author->id, $authors) ? ' style="display: none;"' : '');
                                    $str .= '><span class="ba-author-avatar" ';
                                    $str .= 'style="background-image: url('.Uri::root().$author->avatar.')"></span>';
                                    $str .= $author->title.'</li>';
                                    echo $str;
                                }
                                ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            <div class="blog-post-editor-options-group">
                <div class="blog-post-editor-group-element">
                    <label>
                        <?php echo Text::_('JFIELD_LANGUAGE_LABEL'); ?>
                    </label>
<?php
            $style = $this->item->language == '*' ? '' : ' style="--flag-img: url('.$flags.$this->item->language.'.png)"';
?>
                    <div class="ba-custom-select language-select visible-select-top page-settings-custom-select-trigger"
                        <?php echo $style; ?>>
                        <input readonly onfocus="this.blur()" type="text"
                            value="<?php echo $this->languages[$this->item->language]; ?>">
                        <input type="hidden" name="language" value="<?php echo $this->item->language; ?>">
                        <ul>
<?php
                        foreach ($this->languages as $key => $language) {
                            $style = $key == '*' ? '' : ' style="--flag-img: url('.$flags.$key.'.png)"';
?>
                            <li data-value="<?php echo $key; ?>"<?php echo $style; ?>>
                                <?php echo $language; ?>
                            </li>
<?php
                        }
?>
                        </ul>
                        <i class="zmdi zmdi-caret-down"></i>
                    </div>
                </div>
            </div>
<?php
        if (Associations::isEnabled()) {
?>
            <div class="blog-post-editor-options-group language-associations-group">
<?php
            foreach ($this->languages as $key => $language) {
                if ($key == '*') {
                    continue;
                }
?>
                <div class="blog-post-editor-group-element" data-lang="<?php echo $key; ?>">
                    <label>
                        <?php echo Text::_('ASSOCIATIONS'); ?>
                    </label>
                    <div class="association-wrapper">
                        <span class="ba-language-flag"
                            style="background-image: url(<?php echo $flags.$key; ?>.png);">
                            <span class="ba-tooltip ba-top ba-hide-element">
                                <?php echo $language; ?>
                            </span>
                        </span>
                        <input type="text" class="association-page" data-lang="<?php echo $key; ?>"
                            placeholder="<?php echo Text::_('SELECT'); ?>" readonly="" onfocus="this.blur()">
                        <div class="reset disabled-reset reset-association">
                            <i class="zmdi zmdi-close"></i>
                        </div>
                    </div>
                </div>
<?php
            }
?>
            </div>
<?php
        }
?>
        </div>
        <div class="tab-pane" id="blog-post-editor-seo-options">
            <div class="blog-post-editor-options-group">
                <div class="blog-post-editor-group-element">
                    <label>
                        <?php echo Text::_('BROWSER_PAGE_TITLE'); ?>
                    </label>
                    <input type="text" name="page_meta_title" class="page-meta-title page-settings-input-trigger"
                        value="<?php echo htmlentities($this->item->meta_title, ENT_COMPAT, 'utf-8'); ?>">
                </div>
            </div>
            <div class="blog-post-editor-options-group">
                <div class="blog-post-editor-group-element">
                    <label>
                        <?php echo Text::_('JFIELD_META_DESCRIPTION_LABEL'); ?>
                    </label>
                    <textarea name="page_meta_description" class="page-meta-description page-settings-input-trigger"
                        ><?php echo $this->item->meta_description; ?></textarea>
                </div>
            </div>
            <div class="blog-post-editor-options-group">
                <div class="blog-post-editor-group-element">
                    <label>
                        <?php echo Text::_('META_KEYWORDS'); ?>
                    </label>
                    <textarea name="page_meta_keywords" class="page-meta-keywords page-settings-input-trigger"
                        ><?php echo $this->item->meta_keywords; ?></textarea>
                </div>
            </div>
            <div class="blog-post-editor-options-group">
                <div class="blog-post-editor-group-element">
                    <label>
                        <?php echo Text::_('ROBOTS'); ?>
                    </label>
                    <div class="ba-custom-select robots-select visible-select-top page-settings-custom-select-trigger">
                        <input readonly onfocus="this.blur()" value="<?php echo $robots; ?>" type="text">
                        <input type="hidden" name="robots" value="<?php echo $this->item->robots; ?>">
                        <ul>
                            <li data-value=""><?php echo Text::_('JGLOBAL_USE_GLOBAL'); ?></li>
                            <li data-value="index, follow">index, follow</li>
                            <li data-value="noindex, follow">noindex, follow</li>
                            <li data-value="index, nofollow">index, nofollow</li>
                            <li data-value="noindex, nofollow">noindex, nofollow</li>
                        </ul>
                        <i class="zmdi zmdi-caret-down"></i>
                    </div>
                </div>
            </div>
        </div>
        <div id="blog-post-editor-sharing-options" class="row-fluid tab-pane">
            <div class="blog-post-editor-options-group">
                <div class="blog-post-editor-group-element">
                    <label>
                        <?php echo Text::_('IMAGE'); ?>
                    </label>
                    <div class="share-image-wrapper">
<?php
                        if ($this->item->share_image == 'share_image') {
                            $this->item->share_image = $this->item->intro_image;
                        }
                        if (!GridboxHelper::isExternal($this->item->share_image)) {
                            $tooltipImage = Uri::root().$this->item->share_image;
                        } else {
                            $tooltipImage = $this->item->share_image;
                        }
                        $imageTooltip = !empty($this->item->share_image) ? $tooltipImage : '';
?>
                        <div class="image-field-tooltip"
                            <?php echo !empty($imageTooltip) ? 'style="background-image: url('.$imageTooltip.')"' : ''; ?>>
                        </div>
                        <input type="text" class="share-image page-settings-input-trigger" name="share_image"
                            value="<?php echo $this->item->share_image; ?>"
                            placeholder="<?php echo Text::_('IMAGE'); ?>" readonly="" onfocus="this.blur()">
                        <i class="zmdi zmdi-camera"></i>
                        <div class="reset disabled-reset reset-share-image">
                            <i class="zmdi zmdi-close"></i>
                        </div>
                    </div>
                </div>
            </div>
            <div class="blog-post-editor-options-group">
                <div class="blog-post-editor-group-element">
                    <label>
                        <?php echo Text::_('JGLOBAL_TITLE'); ?>
                    </label>
                    <input type="text" name="share_title" class="share-title page-settings-input-trigger"
                        value="<?php echo $this->item->share_title; ?>"
                        placeholder="<?php echo Text::_('JGLOBAL_TITLE'); ?>">
                </div>
            </div>
            <div class="blog-post-editor-options-group">
                <div class="blog-post-editor-group-element">
                    <label>
                        <?php echo Text::_('DESCRIPTION'); ?>
                    </label>
                    <textarea name="share_description" class="share-description page-settings-input-trigger"
                        placeholder="<?php echo Text::_('DESCRIPTION'); ?>"
                        ><?php echo $this->item->share_description; ?></textarea>
                </div>
            </div>
        </div>
    </div>
</div>
<?php
}
if (empty($this->jce) || $this->jce * 1 !== 1) {
?>
<link rel="stylesheet" type="text/css" href="<?php echo Uri::root(); ?>components/com_gridbox/libraries/ckeditor/css/ckeditor.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/ckeditor/4.5.0/ckeditor.js"></script>
<script src="<?php echo Uri::root(); ?>components/com_gridbox/libraries/ckeditor/js/code.js"></script>
<script src="<?php echo Uri::root(); ?>components/com_gridbox/libraries/ckeditor/js/link.js"></script>
<script src="<?php echo Uri::root(); ?>components/com_gridbox/libraries/ckeditor/js/unlink.js"></script>
<script src="<?php echo Uri::root(); ?>components/com_gridbox/libraries/ckeditor/js/textColor.js"></script>
<script src="<?php echo Uri::root(); ?>components/com_gridbox/libraries/ckeditor/js/image.js"></script>
<script src="<?php echo Uri::root(); ?>components/com_gridbox/libraries/ckeditor/js/anchor.js"></script>
<script src="<?php echo Uri::root(); ?>components/com_gridbox/libraries/ckeditor/js/justifyLeft.js"></script>
<script>
    if ($g('html').attr('dir') == 'rtl') {
        CKEDITOR.config.contentsLangDirection = 'rtl';
    }
    CKEDITOR.config.forcePasteAsPlainText = true;
    CKEDITOR.dtd.$removeEmpty.span = 0;
    CKEDITOR.dtd.$removeEmpty.i = 0;
    CKEDITOR.config.removePlugins = 'image,link';
    CKEDITOR.config.uiColor = '#fafafa';
    CKEDITOR.config.allowedContent = true;
    CKEDITOR.config.toolbar_Basic = [
        {name: 'document', items: ['Source']},
        {name: 'styles', items: ['Styles','Format']},
        {name: 'clipboard', items: ['Undo','Redo']},
        {name: 'basicstyles', items: ['Bold','Italic','Underline']},
        {name: 'paragraph', items: ['NumberedList', 'BulletedList', 'Outdent',
            'Indent', 'Blockquote', 'myJustifyLeft', 'JustifyCenter','JustifyRight', 'JustifyBlock']},
        {name: 'links', items: ['myLink', 'myUnlink','myAnchor']},
        {name: 'insert', items: ['myImage','Table','HorizontalRule', 'code']},
        {name: 'colors', items: ['myTextColor']}
    ];
    CKEDITOR.config.toolbar = 'Basic';
</script>
<?php
}
?>
<div id="ba-notification">
    <i class="zmdi zmdi-close"></i>
    <h4><?php echo Text::_('ERROR'); ?></h4>
    <p></p>
</div>
<div class="gridbox-scroll-div"></div>
<div class="end-point-cover"></div>
<div class="library-item-handle" id="library-item-handle" style="display: none;">
    <i class="zmdi zmdi-apps"></i>
</div>
<div id="lightbox-panels"></div>
<div class="tour-parent">
    <div class="product-tour editor-tour step-1">
        <div>
            <i class="zmdi zmdi-close"></i>
            <p class="ba-group-title"><?php echo Text::_('PAGE_BLOCKS'); ?></p>
            <p><?php echo Text::_('BUILDING_PAGES_QUICKLY'); ?></p>
            <a class="ba-btn next"><?php echo Text::_('NEXT'); ?></a>
        </div>
    </div>
    <div class="product-tour editor-tour step-2">
        <div>
            <i class="zmdi zmdi-close"></i>
            <p class="ba-group-title"><?php echo Text::_('NEW_SECTION'); ?></p>
            <p><?php echo Text::_('BUILDING_YOUR_CONTENT_BLOCKS'); ?></p>
            <a class="ba-btn next"><?php echo Text::_('NEXT'); ?></a>
        </div>
    </div>
    <div class="product-tour editor-tour step-3">
        <div>
            <i class="zmdi zmdi-close"></i>
            <p class="ba-group-title"><?php echo Text::_('MOBILE_EDITOR'); ?></p>
            <p><?php echo Text::_('CONFIGURE_YOUR_PAGE_FOR_MOBILE'); ?></p>
            <a class="ba-btn close"><?php echo Text::_('CLOSE'); ?></a>
        </div>
    </div>
</div>
<div class="product-tour-add-section">
    <div><i class="zmdi zmdi-plus"></i></div>
</div>
<div id="shortcuts-modal" class="ba-modal-cp modal hide" style="display: none;">
    <div class="modal-body">
        <div class="ba-modal-header">
            <i class="zmdi zmdi-keyboard"></i>
        </div>
        <div class="shortcuts-container">
            <div class="ba-shortcut-row-wrapper">
                <div class="shortcut-row">
                    <p><?php echo Text::_('SAVE_PAGE'); ?></p>
                    <span class="sc-btn-wrapper">
                        <span class="sc-btn">Ctrl</span>
                        <span class="sc-btn-active">S</span>
                    </span>
                </div>
                <div class="shortcut-row">
                    <p><?php echo Text::_('UNDO'); ?></p>
                    <span class="sc-btn-wrapper">
                        <span class="sc-btn">Ctrl</span>
                        <span class="sc-btn-active">Z</span>
                    </span>
                </div>
                <div class="shortcut-row">
                    <p><?php echo Text::_('REDO'); ?></p>
                    <span class="sc-btn-wrapper">
                        <span class="sc-btn">Ctrl</span>
                        <span class="sc-btn">Shift</span>
                        <span class="sc-btn-active">Z</span>
                    </span>
                </div>
                <div class="shortcut-row">
                    <p><?php echo Text::_('CLOSE_MODAL'); ?></p>
                    <span class="sc-btn-wrapper">
                        <span class="sc-btn">Alt</span>
                        <span class="sc-btn-active">X</span>
                    </span>
                </div>
                <div class="shortcut-row">
                    <p><?php echo Text::_('SWITCH_DEVICE'); ?></p>
                    <span class="sc-btn-wrapper">
                        <span class="sc-btn">Shift</span>
                        <span class="sc-btn-active">Tab</span>
                    </span>
                </div>
            </div>
            <div class="ba-shortcut-row-wrapper">
                <div class="shortcut-row">
                    <p><?php echo Text::_('CUT'); ?></p>
                    <span class="sc-btn-wrapper">
                        <span class="sc-btn">Ctrl</span>
                        <span class="sc-btn-active">X</span>
                    </span>
                </div>
                <div class="shortcut-row">
                    <p><?php echo Text::_('COPY'); ?></p>
                    <span class="sc-btn-wrapper">
                        <span class="sc-btn">Ctrl</span>
                        <span class="sc-btn-active">C</span>
                    </span>
                </div>
                <div class="shortcut-row">
                    <p><?php echo Text::_('COPY_STYLE'); ?></p>
                    <span class="sc-btn-wrapper">
                        <span class="sc-btn">Ctrl</span>
                        <span class="sc-btn">Shift</span>
                        <span class="sc-btn-active">C</span>
                    </span>
                </div>
                <div class="shortcut-row">
                    <p><?php echo Text::_('PASTE'); ?></p>
                    <span class="sc-btn-wrapper">
                        <span class="sc-btn">Ctrl</span>
                        <span class="sc-btn-active">V</span>
                    </span>
                </div>
                <div class="shortcut-row">
                    <p><?php echo Text::_('DELETE'); ?></p>
                    <span class="sc-btn-wrapper">
                        <span class="sc-btn-active">Del</span>
                    </span>
                </div>
            </div>
            <div class="ba-shortcut-row-wrapper">
                <div class="shortcut-row">
                    <p><?php echo Text::_('PAGE_SETTINGS'); ?></p>
                    <span class="sc-btn-wrapper">
                        <span class="sc-btn">Alt</span>
                        <span class="sc-btn-active">S</span>
                    </span>
                </div>
                <div class="shortcut-row">
                    <p><?php echo Text::_('THEME_SETTINGS'); ?></p>
                    <span class="sc-btn-wrapper">
                        <span class="sc-btn">Alt</span>
                        <span class="sc-btn-active">T</span>
                    </span>
                </div>
                <div class="shortcut-row">
                    <p><?php echo Text::_('WEBSITE_SETTINGS'); ?></p>
                    <span class="sc-btn-wrapper">
                        <span class="sc-btn">Alt</span>
                        <span class="sc-btn-active">W</span>
                    </span>
                </div>
            </div>
            <div class="ba-shortcut-row-wrapper">
                <div class="shortcut-row">
                    <p><?php echo Text::_('CODE_EDITOR'); ?></p>
                    <span class="sc-btn-wrapper">
                        <span class="sc-btn">Alt</span>
                        <span class="sc-btn-active">E</span>
                    </span>
                </div>
                <div class="shortcut-row">
                    <p><?php echo Text::_('MEDIA_MANAGER'); ?></p>
                    <span class="sc-btn-wrapper">
                        <span class="sc-btn">Alt</span>
                        <span class="sc-btn-active">M</span>
                    </span>
                </div>
                <div class="shortcut-row">
                    <p><?php echo Text::_('FONT_LIBRARY'); ?></p>
                    <span class="sc-btn-wrapper">
                        <span class="sc-btn">Alt</span>
                        <span class="sc-btn-active">F</span>
                    </span>
                </div>
            </div>
        </div>
    </div>
</div>
<div id="text-anchor-picker-dialog" class="modal hide ba-modal-picker" style="display: none;">
    <div class="modal-header">
        <span>
            <i class="zmdi zmdi-pin"></i>
        </span>
    </div>
    <div class="modal-body">
        <div class="text-anchors-wrapper">
            
        </div>
    </div>
</div>
<div id="text-anchor-dialog" class="ba-modal-sm modal hide">
    <div class="modal-body">
        <h3 class="ba-modal-title">
            <?php echo Text::_('NEW_ANCHOR') ?>
        </h3>
        <div class="ba-input-lg">
        <input type="text" class="text-anchor-name" placeholder="<?php echo Text::_('NAME'); ?>">
            <span class="focus-underline"></span>
        </div>
    </div>
    <div class="modal-footer">
        <a href="#" class="ba-btn" data-dismiss="modal">
            <?php echo Text::_('CANCEL'); ?>
        </a>
        <a href="#" class="ba-btn-primary disable-button" id="text-anchor-apply">
            <?php echo Text::_('SAVE'); ?>
        </a>
    </div>
</div>
<div id="edit-post-link-dialog" class="ba-modal-sm modal hide">
    <div class="modal-body">
        <h3 class="ba-modal-title">
            <?php echo Text::_('LINK') ?>
        </h3>
        <div class="ba-input-lg link-picker-container">
            <div class="post-link-input-wrapper">
                <input type="text" class="reset-input-margin post-link-input" placeholder="<?php echo Text::_('LINK'); ?>">
                <span class="focus-underline"></span>
            </div>
            <div class="select-anchor">
                <i class="zmdi zmdi-pin"></i>
                <span class="ba-tooltip"><?php echo Text::_('LINK_TO_ANCHOR'); ?></span>
            </div>
            <div class="select-link">
                <i class="zmdi zmdi-attachment-alt"></i>
                <span class="ba-tooltip"><?php echo Text::_('LINK_PICKER'); ?></span>
            </div>
            <div class="select-file">
                <i class="zmdi zmdi-file"></i>
                <span class="ba-tooltip"><?php echo Text::_('FILE_PICKER'); ?></span>
            </div>
        </div>
        <div class="ba-custom-select cke-link-target-select">
            <input readonly="" onfocus="this.blur()" type="text" class="reset-input-margin">
            <input type="hidden" data-property="target">
            <i class="zmdi zmdi-caret-down"></i>
            <ul>
                <li data-value="_blank"><?php echo Text::_('NEW_WINDOW'); ?></li>
                <li data-value="_self"><?php echo Text::_('SAME_WINDOW'); ?></li>
            </ul>
        </div>
        <div class="ba-custom-select post-link-type-select">
            <input readonly onfocus="this.blur()" value="" type="text">
            <input type="hidden">
            <i class="zmdi zmdi-caret-down"></i>
            <ul>
                <li data-value=""><?php echo Text::_('DEFAULT'); ?></li>
                <li data-value="download"><?php echo Text::_('DOWNLOAD'); ?></li>
            </ul>
        </div>
    </div>
    <div class="modal-footer">
        <a href="#" class="ba-btn" data-dismiss="modal">
            <?php echo Text::_('CANCEL'); ?>
        </a>
        <a href="#" class="ba-btn-primary disable-button" id="post-link-apply">
            <?php echo Text::_('SAVE'); ?>
        </a>
    </div>
</div>
<div id="add-to-library-dialog" class="ba-modal-sm modal hide">
    <div class="modal-body">
        <h3 class="ba-modal-title">
            <?php echo Text::_('SAVE_TO_LIBRARY'); ?>
        </h3>
        <div class="ba-input-lg">
            <input type="text" class="library-item-title reset-input-margin" placeholder="<?php echo Text::_('TITLE'); ?>">
            <span class="focus-underline"></span>
        </div>
        <div class="ba-input-lg">
            <input type="text" class="library-item-image reset-input-margin" readonly onfocus="this.blur()"
                placeholder="<?php echo Text::_('UPLOAD_IMAGE'); ?>">
            <i class="zmdi zmdi-attachment-alt"></i>
        </div>
        <div class="ba-checkbox-parent">
            <label class="ba-checkbox ba-hide-checkbox">
                <input type="checkbox" class="save-as-global">
                <span></span>
            </label>
            <label><?php echo Text::_('GLOBAL_ITEM'); ?></label>
            <label class="ba-help-icon">
                <i class="zmdi zmdi-help"></i>
                <span class="ba-tooltip ba-help">
                   <?php echo Text::_('GLOBAL_ITEM_TOOLTIP'); ?> 
                </span>
            </label>
        </div>
    </div>
    <div class="modal-footer">
        <a href="#" class="ba-btn" data-dismiss="modal">
            <?php echo Text::_('CANCEL'); ?>
        </a>
        <a href="#" class="ba-btn-primary disable-button" id="library-apply">
            <?php echo Text::_('SAVE'); ?>
        </a>
    </div>
</div>
<div id="save-copy-dialog" class="ba-modal-sm modal hide">
    <div class="modal-body">
        <h3 class="ba-modal-title">
            <?php echo Text::_('SAVE_COPY'); ?>
        </h3>
        <div class="ba-input-lg">
            <input type="text" class="photo-editor-file-title reset-input-margin"
                placeholder="<?php echo Text::_('ENTER_FILE_NAME'); ?>">
            <span class="focus-underline"></span>
        </div>
        <div class="ba-checkbox-parent">
            <label class="ba-checkbox ba-hide-checkbox">
                <input type="checkbox" class="save-as-webp">
                <span></span>
            </label>
            <label><?php echo Text::_('SAVE_AS_WEBP') ?></label>
        </div>
    </div>
    <div class="modal-footer">
        <a href="#" class="ba-btn" data-dismiss="modal">
            <?php echo Text::_('CANCEL'); ?>
        </a>
        <a href="#" class="ba-btn-primary disable-button" id="apply-save-copy">
            <?php echo Text::_('SAVE'); ?>
        </a>
    </div>
</div>
<div id="save-copy-notice-dialog" class="ba-modal-sm modal hide">
    <div class="modal-body">
        <h3 class="ba-modal-title">
            <?php echo Text::_('SAVE_COPY'); ?>
        </h3>
        <p class="modal-text"><?php echo Text::_('SAVE_COPY_NOTICE'); ?></p>
    </div>
    <div class="modal-footer">
        <a href="#" class="ba-btn" data-dismiss="modal">
            <?php echo Text::_('CANCEL'); ?>
        </a>
        <a href="#" class="ba-btn-primary red-btn" id="apply-overwrite-copy">
            <?php echo Text::_('SAVE'); ?>
        </a>
    </div>
</div>
<div id="create-preset-dialog" class="ba-modal-sm modal hide">
    <div class="modal-body">
        <h3 class="ba-modal-title">
            <?php echo Text::_('SAVE_PRESET'); ?>
        </h3>
        <div class="ba-input-lg">
            <input type="text" class="preset-title reset-input-margin" placeholder="<?php echo Text::_('ENTER_PRESET_NAME'); ?>">
            <span class="focus-underline"></span>
        </div>
        <div class="ba-checkbox-parent">
            <label class="ba-checkbox ba-hide-checkbox">
                <input type="checkbox" class="save-as-default-preset">
                <span></span>
            </label>
            <label><?php echo Text::_('DEFAULT'); ?></label>
            <label class="ba-help-icon">
                <i class="zmdi zmdi-help"></i>
                <span class="ba-tooltip ba-help">
                   <?php echo Text::_('DEFAULT_PRESET_TOOLTIP'); ?> 
                </span>
            </label>
        </div>
    </div>
    <div class="modal-footer">
        <a href="#" class="ba-btn" data-dismiss="modal">
            <?php echo Text::_('CANCEL'); ?>
        </a>
        <a href="#" class="ba-btn-primary disable-button" id="save-preset">
            <?php echo Text::_('SAVE'); ?>
        </a>
    </div>
</div>
<div id="edit-social-icon-dialog" class="ba-modal-sm modal hide">
    <div class="modal-body">
        <h3 class="ba-modal-title">
            <?php echo Text::_('ITEM') ?>
        </h3>
        <div class="ba-input-lg">
            <input type="text" class="reset-input-margin" readonly onfocus="this.blur()" data-property="icon"
                placeholder="<?php echo Text::_('ICON'); ?>">
            <i class="zmdi zmdi-attachment-alt"></i>
        </div>
        <div class="ba-input-lg">
            <input type="text" class="reset-input-margin" placeholder="<?php echo Text::_('LINK'); ?>" data-property="link">
            <span class="focus-underline"></span>
        </div>
        <div class="ba-input-lg">
            <input type="text" class="reset-input-margin"
                   placeholder="<?php echo Text::_('ARIA_LABEL'); ?>" data-property="ariaLabel">
            <span class="focus-underline"></span>
        </div>
        <div class="ba-custom-select">
            <input readonly="" onfocus="this.blur()" type="text">
            <input type="hidden" data-property="target">
            <i class="zmdi zmdi-caret-down"></i>
            <ul>
                <li data-value="_blank"><?php echo Text::_('NEW_WINDOW'); ?></li>
                <li data-value="_self"><?php echo Text::_('SAME_WINDOW'); ?></li>
            </ul>
        </div>
    </div>
    <div class="modal-footer">
        <a href="#" class="ba-btn" data-dismiss="modal">
            <?php echo Text::_('CANCEL'); ?>
        </a>
        <a href="#" class="ba-btn-primary disable-button" id="social-icon-apply">
            <?php echo Text::_('SAVE'); ?>
        </a>
    </div>
</div>
<div id="map-item-dialog" class="ba-modal-lg modal hide">
    <div class="modal-header">
        <div class="modal-header-icon">
            <i class="zmdi zmdi-check disable-button" id="apply-marker-info"></i>
            <i class="zmdi zmdi-close" data-dismiss="modal"></i>
        </div>
    </div>
    <div class="modal-body">
        <div class="general-tabs">
            <ul class="nav nav-tabs uploader-nav">
                <li class="active">
                    <a onclick="return false;" data-toggle="tab">
                        <i class="zmdi zmdi-settings"></i>
                        <?php echo Text::_('ITEM'); ?>
                    </a>
                </li>
            </ul>
        </div>
        <div class="tab-content">
            <div class="row-fluid tab-pane active">
                <p class="ba-group-title"><?php echo Text::_('MARKER_AND_INFOBOX'); ?></p>
                <div class="ba-options-group">
                    <div class="ba-group-element">
                        <label><?php echo Text::_('UPLOAD_MARKER'); ?></label>
                        <input type="text" class="select-input" readonly onfocus="this.blur()" data-option="icon"
                            placeholder="<?php echo Text::_('SELECT'); ?>">
                        <i class="zmdi zmdi-attachment-alt"></i>
                        <div class="reset disabled-reset">
                            <i class="zmdi zmdi-close" data-option="icon"></i>
                            <span class="ba-tooltip">
                                <?php echo Text::_('RESET'); ?>
                            </span>
                        </div>
                    </div>
                    <div class="ba-group-element">
                        <label><?php echo Text::_('DISPLAY_INFOBOX'); ?></label>
                        <label class="ba-checkbox">
                            <input type="checkbox" data-option="infobox">
                            <span></span>
                        </label>
                    </div>
                    <div class="ba-group-element">
                        <label><?php echo Text::_('DESCRIPTION'); ?></label>
                        <textarea data-option="description" placeholder="<?php echo Text::_('DESCRIPTION'); ?>"></textarea>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div id="openstreetmap-item-dialog" class="ba-modal-lg modal hide">
    <div class="modal-header">
        <div class="modal-header-icon">
            <i class="zmdi zmdi-check" id="apply-openstreetmap-marker"></i>
            <i class="zmdi zmdi-close" data-dismiss="modal"></i>
        </div>
    </div>
    <div class="modal-body">
        <div class="general-tabs">
            <ul class="nav nav-tabs uploader-nav">
                <li class="active">
                    <a onclick="return false;" data-toggle="tab">
                        <i class="zmdi zmdi-settings"></i>
                        <?php echo Text::_('ITEM'); ?>
                    </a>
                </li>
            </ul>
        </div>
        <div class="tab-content">
            <div class="row-fluid tab-pane active">
                <p class="ba-group-title"><?php echo Text::_('MARKER_AND_INFOBOX'); ?></p>
                <div class="ba-options-group">
                    <div class="ba-group-element">
                        <label><?php echo Text::_('DISPLAY_INFOBOX'); ?></label>
                        <label class="ba-checkbox">
                            <input type="checkbox" data-option="infobox">
                            <span></span>
                        </label>
                    </div>
                    <div class="ba-group-element">
                        <label><?php echo Text::_('DESCRIPTION'); ?></label>
                        <textarea data-option="description" placeholder="<?php echo Text::_('DESCRIPTION'); ?>"></textarea>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div id="yandex-maps-item-dialog" class="ba-modal-lg modal hide">
    <div class="modal-header">
        <div class="modal-header-icon">
            <i class="zmdi zmdi-check" id="apply-yandex-marker"></i>
            <i class="zmdi zmdi-close" data-dismiss="modal"></i>
        </div>
    </div>
    <div class="modal-body">
        <div class="general-tabs">
            <ul class="nav nav-tabs uploader-nav">
                <li class="active">
                    <a onclick="return false;" data-toggle="tab">
                        <i class="zmdi zmdi-settings"></i>
                        <?php echo Text::_('ITEM'); ?>
                    </a>
                </li>
            </ul>
        </div>
        <div class="tab-content">
            <div class="row-fluid tab-pane active">
                <p class="ba-group-title"><?php echo Text::_('MARKER_AND_INFOBOX'); ?></p>
                <div class="ba-options-group">
                    <div class="ba-group-element">
                        <label>
                            <?php echo Text::_('COLOR'); ?>
                        </label>
                        <input type="text" data-type="color" data-option="color" data-callback="emptyCallback">
                        <span class="minicolors-opacity-wrapper">
                            <input type="number" class="minicolors-opacity" data-callback="emptyCallback"
                            min="0" max="1" step="0.01">
                            <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                        </span>
                    </div>
                    <div class="ba-group-element">
                        <label><?php echo Text::_('TITLE'); ?></label>
                        <input data-option="title" placeholder="<?php echo Text::_('TITLE'); ?>">
                    </div>
                    <div class="ba-group-element">
                        <label><?php echo Text::_('DESCRIPTION'); ?></label>
                        <textarea data-option="description"
                            placeholder="<?php echo Text::_('DESCRIPTION'); ?>"></textarea>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div id="megamenu-library-dialog" class="ba-modal-lg modal hide">
    <div class="modal-header">
        <span class="ba-dialog-title"><?php echo Text::_('LIBRARY'); ?></span>
        <div class="modal-header-icon">
            <i class="zmdi zmdi-close" data-dismiss="modal"></i>
        </div>
    </div>
    <div class="modal-body">
        <div class="general-tabs">
            <ul class="nav nav-tabs uploader-nav">
                <li class="active">
                    <input type="text" value="" placeholder="<?php echo Text::_('SEARCH'); ?>" class="megamenu-library-search">
                    <i class="zmdi zmdi-search"></i>
                </li>
            </ul>
            <div class="tab-content">
                <div class="row-fluid tab-pane active">
                    <div class="ba-group-wrapper">
                        <p class="ba-group-title">
                            <span class="title"><?php echo Text::_('TITLE'); ?></span>
                            <span class="id">ID</span>
                        </p>
                    </div>
                    <div class="empty-list">
                        <i class="zmdi zmdi-alert-polygon"></i>
                        <p><?php echo Text::_('NO_ITEMS_HERE'); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div id="group-field-item-dialog" class="ba-modal-lg modal hide">
    <div class="modal-header">
        <div class="modal-header-icon">
            <i class="zmdi zmdi-check disable-button" id="apply-group-field-item-settings"></i>
            <i class="zmdi zmdi-close" data-dismiss="modal"></i>
        </div>
    </div>
    <div class="modal-body">
        <div class="general-tabs">
            <ul class="nav nav-tabs uploader-nav">
                <li class="active">
                    <a href="#group-field-edit-item" data-toggle="tab">
                        <i class="zmdi zmdi-settings"></i>
                        <?php echo Text::_('ITEM'); ?>
                    </a>
                </li>
            </ul>
        </div>
        <div class="tab-content">
            <div id="group-field-edit-item">
                <div class="ba-options-group">
                    <div class="ba-group-element">
                        <label>
                            <?php echo Text::_('TYPE'); ?>
                        </label>
                        <div class="ba-custom-select field-type-select">
                            <input readonly onfocus="this.blur()" type="text" value="">
                            <input type="hidden" value="">
                            <i class="zmdi zmdi-caret-down"></i>
                            <ul>
                                <li data-value="text"><?php echo Text::_('TEXT'); ?></li>
                                <li data-value="textarea"><?php echo Text::_('TEXTAREA'); ?></li>
                                <li data-value="select"><?php echo Text::_('DROPDOWN'); ?></li>
                                <li data-value="checkbox"><?php echo Text::_('CHECKBOX'); ?></li>
                                <li data-value="radio"><?php echo Text::_('RADIO'); ?></li>
                                <li data-value="url"><?php echo Text::_('URL'); ?></li>
                                <li data-value="price"><?php echo Text::_('PRICE'); ?></li>
                                <li data-value="number"><?php echo Text::_('NUMBER'); ?></li>
                                <li data-value="date"><?php echo Text::_('DATE'); ?></li>
                                <li data-value="event-date"><?php echo Text::_('EVENT_DATE'); ?></li>
                                <li data-value="time"><?php echo Text::_('TIME'); ?></li>
                                <li data-value="range"><?php echo Text::_('SLIDER'); ?></li>
                                <li data-value="file"><?php echo Text::_('ATTACHMENT_FILE'); ?></li>
                                <li data-value="tag"><?php echo Text::_('TAG'); ?></li>
                            </ul>
                        </div>
                    </div>
                    <div class="field-textarea-type-options">
                        <div class="ba-group-element">
                            <label>
                                <?php echo Text::_('ENABLE_TEXT_EDITOR'); ?>
                            </label>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-element="texteditor">
                                <span></span>
                            </label>
                        </div>
                    </div>
                    <div class="items-list field-radio-type-options field-select-type-options field-checkbox-type-options">
                        <div class="sorting-container"></div>
                        <div class="add-new-item">
                            <span>
                                <i class="zmdi zmdi-plus-circle"></i>
                                <span class="ba-tooltip ba-right"><?php echo Text::_('ADD_NEW_ITEM'); ?></span>
                            </span>
                        </div>
                    </div>
                    <div class="field-price-type-options">
                        <div class="ba-group-element">
                            <label>
                                <?php echo Text::_('SYMBOL'); ?>
                            </label>
                            <input type="text" data-element="symbol" placeholder="$">
                        </div>
                        <div class="ba-group-element">
                            <label>
                                <?php echo Text::_('CURRENCY_POSITION'); ?>
                            </label>
                            <div class="ba-custom-select price-currency-position-select">
                                <input readonly onfocus="this.blur()" type="text" value="">
                                <input type="hidden" value="" data-element="position">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value=""><?php echo Text::_('LEFT'); ?></li>
                                    <li data-value="right-currency-position"><?php echo Text::_('RIGHT'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-group-element">
                            <label>
                                <?php echo Text::_('THOUSAND_SEPARATOR'); ?>
                            </label>
                            <div class="ba-custom-select price-thousand-separator-select">
                                <input readonly onfocus="this.blur()" type="text" value="">
                                <input type="hidden" value="" data-element="thousand">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value=","><?php echo Text::_('COMMA'); ?></li>
                                    <li data-value="."><?php echo Text::_('DOT'); ?></li>
                                    <li data-value=" "><?php echo Text::_('SPACE'); ?></li>
                                    <li data-value=""><?php echo Text::_('NO_NE'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-group-element">
                            <label>
                                <?php echo Text::_('DECIMAL_SEPARATOR'); ?>
                            </label>
                            <div class="ba-custom-select price-decimal-separator-select">
                                <input readonly onfocus="this.blur()" type="text" value="">
                                <input type="hidden" value="" data-element="separator">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value=","><?php echo Text::_('COMMA'); ?></li>
                                    <li data-value="."><?php echo Text::_('DOT'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-group-element">
                            <label>
                                <?php echo Text::_('NUMBER_OF_DECIMALS'); ?>
                            </label>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="10">
                                <input type="number" data-element="decimals" data-callback="emptyCallback">
                            </div>
                        </div>
                    </div>
                    <div class="field-file-type-options">
                        <div class="ba-group-element">
                            <label><?php echo Text::_('TITLE'); ?></label>
                            <input type="text" placeholder="<?php echo Text::_('TITLE'); ?>" data-element="title">
                        </div>
                        <div class="ba-group-element">
                            <label>
                                <?php echo Text::_('SOURCE'); ?>
                            </label>
                            <div class="ba-custom-select">
                                <input readonly onfocus="this.blur()" type="text" value="">
                                <input type="hidden" value="" data-element="source">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value=""><?php echo Text::_('MEDIA_MANAGER'); ?></li>
                                    <li data-value="desktop"><?php echo Text::_('DESKTOP'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-group-element">
                            <label><?php echo Text::_('MAX_UPLOAD_FILE_SIZE'); ?></label>
                            <input type="text" placeholder="<?php echo Text::_('MAX_UPLOAD_FILE_SIZE'); ?>" data-element="size">
                        </div>
                        <div class="ba-group-element">
                            <label><?php echo Text::_('ALLOWED_FILE_TYPES'); ?></label>
                            <input type="text" placeholder="<?php echo Text::_('ALLOWED_FILE_TYPES'); ?>" data-element="types">
                        </div>
                    </div>
                    <div class="field-range-type-options">
                        <div class="ba-settings-toolbar">
                            <div>
                                <span><?php echo Text::_('MIN'); ?></span>
                                <input type="number" data-element="min" data-callback="emptyCallback">
                            </div>
                            <div>
                                <span><?php echo Text::_('MAX'); ?></span>
                                <input type="number" data-element="max" data-callback="emptyCallback">
                            </div>
                        </div>
                    </div>
                    <div class="field-url-type-options">
                        <div class="ba-group-element">
                            <label><?php echo Text::_('TARGET'); ?></label>
                            <div class="ba-custom-select visible-select-top">
                                <input readonly="" onfocus="this.blur()" value="" type="text">
                                <input type="hidden" data-element="target">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="_blank"><?php echo Text::_('NEW_WINDOW'); ?></li>
                                    <li data-value="_self"><?php echo Text::_('SAME_WINDOW'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-group-element">
                            <label><?php echo Text::_('TYPE'); ?></label>
                            <div class="ba-custom-select visible-select-top">
                                <input readonly="" onfocus="this.blur()" value="" type="text">
                                <input type="hidden" data-element="download">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value=""><?php echo Text::_('DEFAULT'); ?></li>
                                    <li data-value="download"><?php echo Text::_('DOWNLOAD'); ?></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="ba-options-group">
                    <div class="ba-group-element">
                        <label><?php echo Text::_('LABEL'); ?></label>
                        <input type="text" placeholder="<?php echo Text::_('LABEL'); ?>" class="field-label">
                    </div>
                    <div class="ba-group-element input-resize">
                        <label><?php echo Text::_('DESCRIPTION'); ?></label>
                        <textarea placeholder="<?php echo Text::_('DESCRIPTION'); ?>" class="field-description"></textarea>
                    </div>
                    <div class="ba-group-element">
                        <label>
                            <?php echo Text::_('ICON'); ?>
                        </label>
                        <input class="select-input select-item-icon" type="text" readonly onfocus="this.blur()"
                            placeholder="<?php echo Text::_('ICON'); ?>">
                        <i class="zmdi zmdi-attachment-alt"></i>
                        <div class="reset disabled-reset reset-element-icon">
                            <i class="zmdi zmdi-close"></i>
                            <span class="ba-tooltip">
                                <?php echo Text::_('RESET'); ?>
                            </span>
                        </div>
                    </div>
                    <div class="ba-group-element">
                        <label><?php echo Text::_('ADMIN_LABEL'); ?></label>
                        <input type="text" placeholder="<?php echo Text::_('ADMIN_LABEL'); ?>" class="field-admin-label">
                    </div>
                    <div class="ba-group-element input-resize">
                        <label><?php echo Text::_('ADMIN_DESCRIPTION'); ?></label>
                        <textarea placeholder="<?php echo Text::_('ADMIN_DESCRIPTION'); ?>" class="field-admin-description"></textarea>
                    </div>
                    <div class="ba-group-element">
                        <label><?php echo Text::_('REQUIRED'); ?></label>
                        <label class="ba-checkbox">
                            <input type="checkbox" class="field-required">
                            <span></span>
                        </label>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div id="slideshow-item-dialog" class="ba-modal-lg modal hide">
    <div class="modal-header">
        <div class="modal-header-icon">
            <i class="zmdi zmdi-check disable-button" id="apply-new-slide" data-edit="new"></i>
            <i class="zmdi zmdi-close" data-dismiss="modal"></i>
        </div>
    </div>
    <div class="modal-body">
        <div class="general-tabs">
            <ul class="nav nav-tabs uploader-nav">
                <li class="active">
                    <a href="#slideshow-add-item" data-toggle="tab">
                        <i class="zmdi zmdi-settings"></i>
                        <?php echo Text::_('ITEM'); ?>
                    </a>
                </li>
            </ul>
        </div>
        <div class="tab-content">
            <div id="slideshow-add-item">
                <div class="ba-options-group">
                    <div class="ba-group-element slideshow-slide-select">
                        <label>
                            <?php echo Text::_('TYPE'); ?>
                        </label>
                        <div class="ba-custom-select slide-type-select">
                            <input readonly onfocus="this.blur()" value="" type="text">
                            <input type="hidden" value="">
                            <i class="zmdi zmdi-caret-down"></i>
                            <ul>
                                <li data-value="image"><?php echo Text::_('IMAGE'); ?></li>
                                <li class="desktop-only" data-value="video"><?php echo Text::_('VIDEO'); ?></li>
                            </ul>
                        </div>
                    </div>
                    <div class="image-options" style="display: none;">
                        <div class="ba-group-element">
                            <label>
                                <?php echo Text::_('SELECT'); ?>
                            </label>
                            <input type="text" class="select-input slide-image" readonly onfocus="this.blur()"
                                placeholder="<?php echo Text::_('SELECT'); ?>">
                            <i class="zmdi zmdi-attachment-alt"></i>
                        </div>
                    </div>
                    <div class="video-options" style="display: none;">
                        <div class="ba-group-element">
                            <label>
                                <?php echo Text::_('VIDEO_SOURCE'); ?>
                            </label>
                            <div class="ba-custom-select video-select">
                                <input readonly onfocus="this.blur()" value="Youtube" type="text">
                                <input type="hidden" value="youtube" data-option="video-type" data-group="background">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="youtube">Youtube</li>
                                    <li data-value="vimeo">Vimeo</li>
                                    <li data-value="source"><?php echo Text::_('SOURCE_FILE'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-group-element video-id">
                            <label>
                                <?php echo Text::_('VIDEO_ID'); ?>
                            </label>
                            <input type="text" class="slide-video-id" placeholder="<?php echo Text::_('VIDEO_ID'); ?>">
                        </div>
                        <div class="ba-group-element video-source-select">
                            <label>
                                <?php echo Text::_('SOURCE_FILE'); ?>
                            </label>
                            <input type="text" class="select-input" readonly onfocus="this.blur()"
                                placeholder="<?php echo Text::_('SELECT'); ?>">
                            <i class="zmdi zmdi-attachment-alt"></i>
                            <label class="ba-help-icon">
                                <i class="zmdi zmdi-help"></i>
                                <span class="ba-tooltip ba-help">
                                    <?php echo Text::_('SOURCE_FILE_TOOLTIP'); ?>
                                </span>
                            </label>
                        </div>
                        <div class="ba-group-element">
                            <label>
                                <?php echo Text::_('START'); ?>
                            </label>
                            <input type="text" class="slide-video-start" placeholder="<?php echo Text::_('START'); ?>">
                        </div>
                    </div>
                </div>
                <p class="ba-group-title desktop-only"><?php echo Text::_('CAPTION'); ?></p>
                <div class="ba-options-group desktop-only">
                    <div class="ba-group-element">
                        <label>
                            <?php echo Text::_('TITLE'); ?>
                        </label>
                        <input type="text" class="slide-title" placeholder="<?php echo Text::_('TITLE'); ?>">
                    </div>
                    <div class="ba-group-element">
                        <label>
                            <?php echo Text::_('DESCRIPTION'); ?>
                        </label>
                        <textarea class="slide-description" placeholder="<?php echo Text::_('DESCRIPTION'); ?>"></textarea>
                    </div>
                </div>
                <p class="ba-group-title desktop-only"><?php echo Text::_('LINK'); ?></p>
                <div class="ba-options-group desktop-only">
                    <div class="ba-group-element">
                        <label>
                            <?php echo Text::_('VIEW'); ?>
                        </label>
                        <div class="ba-custom-select slide-button-type-select">
                            <input readonly onfocus="this.blur()" value="" type="text">
                            <input type="hidden" value="">
                            <i class="zmdi zmdi-caret-down"></i>
                            <ul>
                                <li data-value="button"><?php echo Text::_('BUTTON'); ?></li>
                                <li data-value="link"><?php echo Text::_('LINK'); ?></li>
                            </ul>
                        </div>
                    </div>
                    <div class="ba-group-element slideshow-button-label">
                        <label>
                            <?php echo Text::_('LABEL'); ?>
                        </label>
                        <input type="text" class="slide-button-label" placeholder="<?php echo Text::_('LABEL'); ?>">
                    </div>
                    <div class="ba-group-element link-picker-container">
                        <label>
                            <?php echo Text::_('LINK'); ?>
                        </label>
                        <input type="text" class="slide-button-link" placeholder="<?php echo Text::_('LINK'); ?>">
                        <div class="select-link">
                            <i class="zmdi zmdi-attachment-alt"></i>
                            <span class="ba-tooltip"><?php echo Text::_('LINK_PICKER') ?></span>
                        </div>
                        <div class="select-file">
                            <i class="zmdi zmdi-file"></i>
                            <span class="ba-tooltip"><?php echo Text::_('FILE_PICKER') ?></span>
                        </div>
                    </div>
                    <div class="ba-group-element">
                        <label>
                            <?php echo Text::_('ARIA_LABEL'); ?>
                        </label>
                        <input type="text" class="slide-button-aria-label"
                               placeholder="<?php echo Text::_('ARIA_LABEL'); ?>">
                    </div>
                    <div class="ba-group-element">
                        <label>
                            <?php echo Text::_('TARGET'); ?>
                        </label>
                        <div class="ba-custom-select slide-button-target-select visible-select-top">
                            <input readonly onfocus="this.blur()" value="" type="text">
                            <input type="hidden" value="">
                            <i class="zmdi zmdi-caret-down"></i>
                            <ul>
                                <li data-value="_blank"><?php echo Text::_('NEW_WINDOW'); ?></li>
                                <li data-value="_self"><?php echo Text::_('SAME_WINDOW'); ?></li>
                            </ul>
                        </div>
                    </div>
                    <div class="ba-group-element">
                        <label>
                            <?php echo Text::_('TYPE'); ?>
                        </label>
                        <div class="ba-custom-select slide-button-attribute-select visible-select-top">
                            <input readonly onfocus="this.blur()" value="" type="text">
                            <input type="hidden" value="">
                            <i class="zmdi zmdi-caret-down"></i>
                            <ul>
                                <li data-value=""><?php echo Text::_('DEFAULT'); ?></li>
                                <li data-value="download"><?php echo Text::_('DOWNLOAD'); ?></li>
                            </ul>
                        </div>
                    </div>
                    <div class="ba-group-element">
                        <label>
                            <?php echo Text::_('EMBED_CODE'); ?>
                        </label>
                        <input type="text" class="slide-button-embed-code" placeholder="<?php echo Text::_('EMBED_CODE'); ?>">
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div id="add-section-dialog" class="ba-modal-cp modal hide">
    <div class="modal-header">
        <div class="modal-header-icon">
            <i class="zmdi zmdi-close" data-dismiss="modal"></i>
        </div>
    </div>
    <div class="modal-body">
        <div class="general-tabs">
            <ul class="nav nav-tabs">
                <li class="active">
                    <a href="#columns" data-toggle="tab">
                        <?php echo Text::_('COLUMNS'); ?>
                    </a>
                </li>
            </ul>
            <div class="tabs-underline"></div>
            <div class="tab-content">
                <div id="columns" class="row-fluid tab-pane active">
                    <div class="ba-settings-group">
                        <div class="settings-group-title">
                            <span><?php echo Text::_('NUMBER_OF_COLUMNS'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <div class="columns-wrapper">
                                <div class="ba-column" data-count="12"></div>
                                <div class="ba-column" data-count="6+6"></div>
                                <div class="ba-column" data-count="4+4+4"></div>
                                <div class="ba-column" data-count="3+3+3+3"></div>
                            </div>
                            <div>
                                <span><?php echo Text::_("ONE"); ?></span>
                                <span><?php echo Text::_("TWO"); ?></span>
                                <span><?php echo Text::_("THREE"); ?></span>
                                <span><?php echo Text::_("FOUR"); ?></span>
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-settings"></i>
                            <span><?php echo Text::_('ADVANCED'); ?></span>
                            <label class="ba-help-icon">
                                <i class="zmdi zmdi-help"></i>
                                <span class="ba-tooltip ba-help">
                                    <?php echo Text::_('CUSTOM_ROW_LAYOUT_TOOLTIP'); ?>
                                </span>
                            </label>
                        </div>
                        <div class="ba-settings-item">
                            <input type="text" class="advanced-column" placeholder="3+3+3+3">
                            <a href="#" class="ba-btn-primary disable-button" id="apply-column">
                                <?php echo Text::_('SAVE'); ?>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div id="map-editor-dialog" class="ba-modal-lg modal hide">
    <div class="modal-header">
        <span class="ba-dialog-title"><?php echo Text::_('GOOGLE_MAP'); ?></span>
        <div class="modal-header-icon">
            <i class="zmdi zmdi-check apply-text" data-dismiss="modal"></i>
            <i class="zmdi zmdi-close" data-dismiss="modal"></i>
        </div>
    </div>
    <div class="modal-body">
        <div class="general-tabs">
            <ul class="nav nav-tabs">
                <li class="active">
                    <a href="#">
                        <i class="zmdi zmdi-settings"></i>
                        <?php echo Text::_('GENERAL'); ?>
                    </a>
                </li>
            </ul>
            <div class="tabs-underline"></div>
            <div class="tab-content show-general-cell">
                <div class="row-fluid tab-pane active">
                    <div id="map-location"></div>
                </div>
                <div class="text-editor-general-cell">
                    <div class="ba-settings-group">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-tune"></i>
                            <span><?php echo Text::_('SETTINGS'); ?></span>
                        </div>
                        <div class="ba-settings-item field-google-maps-options">
                            <span><?php echo Text::_('ADMIN_LABEL'); ?></span>
                            <input type="text" data-option="label" placeholder="<?php echo Text::_('ADMIN_LABEL'); ?>"
                                class="set-value-css">
                        </div>
                        <div class="ba-settings-item field-google-maps-options input-resize">
                            <span><?php echo Text::_('ADMIN_DESCRIPTION'); ?></span>
                            <input type="text" data-option="description" data-group="options" class="field-admin-description" 
                                placeholder="<?php echo Text::_('ADMIN_DESCRIPTION'); ?>"
                                class="set-value-css">
                        </div>
                        <div class="ba-settings-item google-maps-places-options">
                            <span>
                                <?php echo Text::_('APP'); ?>
                            </span>
                            <div class="ba-custom-select google-maps-places-app-select">
                                <input readonly="" onfocus="this.blur()" value="" type="text">
                                <input type="hidden" value="1" data-option="app">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
<?php
                                foreach ($this->apps as $value) {
                                    if ($value->type != 'blog') {
                                        echo '<li data-value="'.$value->id.'">'.$value->title.'</li>';
                                    }
                                }
?>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('GOOGLE_MAPS_API_KEY'); ?>
                            </span>
<?php
                            echo $this->html->load('integrations', $this->integrations->google_maps);
?>
                        </div>
                    </div>
                    <div class="settings-group-title">
                        <i class="zmdi zmdi-pin"></i>
                        <span><?php echo Text::_('LOCATIONS'); ?></span>
                    </div>
                    <div class="ba-settings-group google-maps-location-options">
                        <div class="sorting-container">
                            <div class="sorting-item" data-marker="0">
                                <input type="text" id="choose-location" data-marker="0" class="choose-location-input"
                                    placeholder="<?php echo Text::_('ENTER_LOCATION'); ?>">
                                <span class="focus-underline"></span>
                                <div class="sorting-icons">
                                    <span>
                                        <i class="zmdi zmdi-edit"></i>
                                    </span>
                                    <span>
                                        <i class="zmdi zmdi-close"></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="add-new-item">
                            <span>
                                <i class="zmdi zmdi-plus-circle"></i>
                                <span class="ba-tooltip ba-right">
                                    <?php echo Text::_('ADD_NEW_ITEM'); ?>
                                </span>
                            </span>
                        </div>
                    </div>
                    <div class="ba-settings-group google-maps-places-options">
                        <div class="settings-group-title">
                            <span><?php echo Text::_('INFOBOX'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('LAYOUT'); ?>
                            </span>
                            <div class="ba-custom-select event-calendar-layout-select">
                                <input readonly onfocus="this.blur()" type="text" value="">
                                <input type="hidden" value="">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="card"><?php echo Text::_('CARD'); ?></li>
                                    <li data-value="list"><?php echo Text::_('LIST'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('IMAGE'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-group="view" data-option="image" class="set-value-css">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('TITLE'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-group="view" data-option="title" class="set-value-css">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item not-author-options">
                            <span>
                                <?php echo Text::_('INFO'); ?>
                            </span>
                            <span class="category-list-fields-wrapper">
                                <i class="zmdi zmdi-playlist-plus open-category-list-fields" data-target="info"></i>
                            </span>
                        </div>
                        <div class="ba-settings-item not-author-options">
                            <span>
                                <?php echo Text::_('REVIEWS'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-option="reviews" data-group="view" class="set-value-css">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item category-list-fields-view-options">
                            <span>
                                <?php echo Text::_('FIELDS'); ?>
                            </span>
                            <span class="category-list-fields-wrapper">
                                <i class="zmdi zmdi-playlist-plus open-category-list-fields" data-target="fields"></i>
                            </span>
                        </div>
                        <div class="ba-settings-item not-author-options">
                            <span>
                                <?php echo Text::_('BUTTON'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-group="view" data-option="button" class="set-value-css">
                                <span></span>
                            </label>
                        </div>
                    </div>
                    <div class="ba-settings-group">
                        <div class="settings-group-title">
                            <span><?php echo Text::_('VIEW'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('HEIGHT'); ?>
                            </span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="2500">
                                <input type="text" data-option="height" data-callback="sectionRules">
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('THEME'); ?>
                            </span>
                            <div class="ba-custom-select map-theme-select">
                                <input readonly onfocus="this.blur()" type="text" value="">
                                <input type="hidden" value="">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="standart">Standard</li>
                                    <li data-value="silver">Silver</li>
                                    <li data-value="retro">Retro</li>
                                    <li data-value="dark">Dark</li>
                                    <li data-value="night">Night</li>
                                    <li data-value="aubergine">Aubergine</li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('CONTROLS'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-option="controls">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SCROLL_ZOOMING'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-option="scrollwheel">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('DRAGGABLE_MAP'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-option="draggable">
                                <span></span>
                            </label>
                        </div>
                    </div>
<?php
                    $options = ['states' => true];
                    echo $this->html->load('shadow', $options);
                    echo $this->html->loadPassive('positioning');
                    echo $this->html->load('margin');
                    echo $this->html->loadPassive('disable');
                    echo $this->html->loadPassive('item-animation');
                    echo $this->html->loadPassive('advanced', $this->access);
?>
                </div>
            </div>
        </div>
    </div>
</div>
<div id="yandex-maps-editor-dialog" class="ba-modal-lg modal hide">
    <div class="modal-header">
        <span class="ba-dialog-title"><?php echo Text::_('YANDEX_MAPS'); ?></span>
        <div class="modal-header-icon">
            <i class="zmdi zmdi-check" data-dismiss="modal"></i>
            <i class="zmdi zmdi-close" data-dismiss="modal"></i>
        </div>
    </div>
    <div class="modal-body">
        <div class="general-tabs">
            <ul class="nav nav-tabs">
                <li class="active">
                    <a href="#">
                        <i class="zmdi zmdi-settings"></i>
                        <?php echo Text::_('GENERAL'); ?>
                    </a>
                </li>
            </ul>
            <div class="tabs-underline"></div>
            <div class="tab-content show-general-cell">
                <div class="row-fluid tab-pane active">
                    <div id="yandex-map-location"></div>
                </div>
                <div class="text-editor-general-cell">
                    <div class="ba-settings-group">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-tune"></i>
                            <span><?php echo Text::_('SETTINGS'); ?></span>
                        </div>
                        <div class="ba-settings-item input-resize">
                            <span>
                                <?php echo Text::_('ENTER_API_KEY'); ?>
                            </span>
<?php
                            echo $this->html->load('integrations', $this->integrations->yandex_maps);
?>
                        </div>
                    </div>
                    <div class="settings-group-title">
                            <i class="zmdi zmdi-pin"></i>
                            <span><?php echo Text::_('LOCATIONS'); ?></span>
                        </div>
                    <div class="ba-settings-group">
                        <div class="sorting-container">
                            <div class="sorting-item" data-marker="0">
                                <input type="text" id="yandex-choose-location" data-marker="0"
                                    class="yandex-choose-location-input" placeholder="<?php echo Text::_('ENTER_LOCATION'); ?>">
                                <span class="focus-underline"></span>
                                <div class="sorting-icons">
                                    <span>
                                        <i class="zmdi zmdi-edit"></i>
                                    </span>
                                    <span>
                                        <i class="zmdi zmdi-close"></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="add-new-item">
                            <span>
                                <i class="zmdi zmdi-plus-circle"></i>
                                <span class="ba-tooltip ba-right">
                                    <?php echo Text::_('ADD_NEW_ITEM'); ?>
                                </span>
                            </span>
                        </div>
                    </div>
                    <div class="ba-settings-group">
                        <div class="settings-group-title">
                            <span><?php echo Text::_('VIEW'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('HEIGHT'); ?>
                            </span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="2500">
                                <input type="text" data-option="height" data-callback="sectionRules">
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('CONTROLS'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-option="controls" data-group="map" class="set-value-css">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SCROLL_ZOOMING'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-option="scrollwheel" data-group="map" class="set-value-css">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('DRAGGABLE_MAP'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-option="draggable" data-group="map" class="set-value-css">
                                <span></span>
                            </label>
                        </div>
                    </div>
<?php
                    $options = ['states' => true];
                    echo $this->html->load('shadow', $options);
                    echo $this->html->loadPassive('positioning');
                    echo $this->html->load('margin');
                    echo $this->html->loadPassive('disable');
                    echo $this->html->loadPassive('item-animation');
                    echo $this->html->loadPassive('advanced', $this->access);
?>
                </div>
            </div>
        </div>
    </div>
</div>
<div id="openstreetmap-editor-dialog" class="ba-modal-lg modal hide">
    <div class="modal-header">
        <span class="ba-dialog-title"><?php echo Text::_('OPENSTREETMAP'); ?></span>
        <div class="modal-header-icon">
            <i class="zmdi zmdi-check" data-dismiss="modal"></i>
            <i class="zmdi zmdi-close" data-dismiss="modal"></i>
        </div>
    </div>
    <div class="modal-body">
        <div class="general-tabs">
            <ul class="nav nav-tabs">
                <li class="active">
                    <a href="#">
                        <i class="zmdi zmdi-settings"></i>
                        <?php echo Text::_('GENERAL'); ?>
                    </a>
                </li>
            </ul>
            <div class="tabs-underline"></div>
            <div class="tab-content show-general-cell">
                <div class="row-fluid tab-pane active">
                    <div id="openstreetmap-location"></div>
                </div>
                <div class="text-editor-general-cell">
                    <div class="settings-group-title">
                            <i class="zmdi zmdi-pin"></i>
                            <span><?php echo Text::_('LOCATIONS'); ?></span>
                        </div>
                    <div class="ba-settings-group">
                        <div class="sorting-container">
                            <div class="sorting-item" data-marker="0">
                                <input type="text" id="openstreetmap-choose-location" data-marker="0"
                                    class="openstreetmap-choose-location-input" placeholder="<?php echo Text::_('ENTER_COORDINATES'); ?>">
                                <span class="focus-underline"></span>
                                <div class="sorting-icons">
                                    <span>
                                        <i class="zmdi zmdi-edit"></i>
                                    </span>
                                    <span>
                                        <i class="zmdi zmdi-close"></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="add-new-item">
                            <span>
                                <i class="zmdi zmdi-plus-circle"></i>
                                <span class="ba-tooltip ba-right">
                                    <?php echo Text::_('ADD_NEW_ITEM'); ?>
                                </span>
                            </span>
                        </div>
                    </div>
                    <div class="ba-settings-group">
                        <div class="settings-group-title">
                            <span><?php echo Text::_('VIEW'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('HEIGHT'); ?>
                            </span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="2500">
                                <input type="text" data-option="height" data-callback="sectionRules">
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('THEME'); ?>
                            </span>
                            <div class="ba-custom-select openstreetmap-theme-select">
                                <input readonly onfocus="this.blur()" type="text" value="">
                                <input type="hidden" value="">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="https://{s}.tile.openstreetmap.de/tiles/osmde/{z}/{x}/{y}.png">
                                        OpenStreetMap DE
                                    </li>
                                    <li data-value="https://{s}.tile.openstreetmap.fr/hot/{z}/{x}/{y}.png">
                                        Hot
                                    </li>
                                    <li data-value="https://server.arcgisonline.com/ArcGIS/rest/services/Canvas/World_Light_Gray_Base/MapServer/tile/{z}/{y}/{x}">
                                        Esri World Gray
                                    </li>
                                    <li data-value="https://{s}.basemaps.cartocdn.com/dark_all/{z}/{x}/{y}{r}.png">
                                        CartoDB Dark Matter
                                    </li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('CONTROLS'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-option="controls" data-group="map" class="set-value-css">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SCROLL_ZOOMING'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-option="scrollwheel" data-group="map" class="set-value-css">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('DRAGGABLE_MAP'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-option="draggable" data-group="map" class="set-value-css">
                                <span></span>
                            </label>
                        </div>
                    </div>
<?php
                    echo $this->html->load('shadow');
                    echo $this->html->loadPassive('positioning');
                    echo $this->html->load('margin');
                    echo $this->html->loadPassive('disable');
                    echo $this->html->loadPassive('item-animation');
                    echo $this->html->loadPassive('advanced', $this->access);
?>
                </div>
            </div>
        </div>
    </div>
</div>
<div id="cke-image-modal" class="ba-modal-sm modal hide" style="display:none">
    <div class="modal-body">
        <h3 class="ba-modal-title"><?php echo Text::_('ADD_IMAGE'); ?></h3>
        <div>
            <input type="text" class="cke-upload-image" readonly onfocus="this.blur()"
                placeholder="<?php echo Text::_('SELECT'); ?>">
            <span class="focus-underline"></span>
            <i class="zmdi zmdi-attachment-alt"></i>
        </div>
        <input type="text" class="cke-image-alt" placeholder="<?php echo Text::_('IMAGE_ALT'); ?>">
        <span class="focus-underline"></span>
        <div>
            <input type="text" class="cke-image-width" placeholder="<?php echo Text::_('WIDTH'); ?>">
            <span class="focus-underline"></span>
            <input type="text" class="cke-image-height" placeholder="<?php echo Text::_('HEIGHT'); ?>">
            <span class="focus-underline"></span>
        </div>
        <div class="ba-custom-select visible-select-top cke-image-select">
            <input type="text" class="cke-image-align" readonly onfocus="this.blur()"
                placeholder="<?php echo Text::_('ALIGNMENT'); ?>">
            <input type="hidden" id="cke-image-align">
            <ul class="select-no-scroll">
                <li data-value=""><?php echo Text::_('NO_NE'); ?></li>
                <li data-value="left"><?php echo Text::_('LEFT'); ?></li>
                <li data-value="right"><?php echo Text::_('RIGHT'); ?></li>
            </ul>
            <i class="zmdi zmdi-caret-down"></i>
        </div>
    </div>
    <div class="modal-footer">
        <a href="#" class="ba-btn" data-dismiss="modal">
            <?php echo Text::_('CANCEL') ?>
        </a>
        <a href="#" class="ba-btn-primary" id="add-cke-image">
            <?php echo Text::_('SAVE') ?>
        </a>
    </div>
</div>
<div id="delete-dialog" class="ba-modal-sm modal hide" style="display:none">
    <div class="modal-body">
        <h3 class="ba-modal-title"><?php echo Text::_('DELETE_ITEM'); ?></h3>
        <p class="modal-text"><?php echo Text::_('MODAL_DELETE') ?></p>
    </div>
    <div class="modal-footer">
        <a href="#" class="ba-btn" data-dismiss="modal">
            <?php echo Text::_('CANCEL') ?>
        </a>
        <a href="#" class="ba-btn-primary red-btn" id="apply-delete">
            <?php echo Text::_('DELETE') ?>
        </a>
    </div>
</div>
<div id="add-to-menu-modal" class="ba-modal-sm modal hide" style="display: none;" aria-hidden="false">
    <div class="modal-body">
        <h3 class="ba-modal-title"><?php echo Text::_('ADD_TO_MENU'); ?></h3>
        <div class="ba-input-lg">
            <input type="text" class="menu-item-title reset-input-margin" placeholder="<?php echo Text::_('MENU_TITLE'); ?>">
            <span class="focus-underline"></span>    
        </div>
        <div class="ba-custom-select menu-type-select">
            <input readonly onfocus="this.blur()" type="text" value="" class="reset-input-margin">
            <input type="hidden" value="">
            <i class="zmdi zmdi-caret-down"></i>
            <ul>
                <?php
                foreach ($this->menutypes as $menu) {
                    $str = '<li data-value="'.$menu->menutype.'">';
                    $str .= $menu->title.'</li>';
                    echo $str;
                }
                ?>
            </ul>
        </div>
        <div class="ba-custom-select menu-items-select visible-select-top">
            <input readonly onfocus="this.blur()" type="text" value="">
            <input type="hidden" value="">
            <i class="zmdi zmdi-caret-down"></i>
            <ul>
                <li data-value="1" class="item-root"><?php echo Text::_('MENU_ITEM_ROOT'); ?></li>
            </ul>
        </div>
    </div>
    <div class="modal-footer">
        <a href="#" class="ba-btn" data-dismiss="modal">
            <?php echo Text::_('CANCEL'); ?>
        </a>
        <a href="#" class="ba-btn-primary disable-button" id="add-to-menu">
            <?php echo Text::_('SAVE'); ?>
        </a>
    </div>
</div>
<div id="add-new-element-modal" class="ba-modal-sm modal hide" style="display: none;" aria-hidden="false">
    <div class="modal-body">
        <h3 class="ba-modal-title"><?php echo Text::_('ITEM'); ?></h3>
        <div class="ba-input-lg">
            <input type="text" class="element-title reset-input-margin" placeholder="<?php echo Text::_('TITLE'); ?>">
            <span class="focus-underline"></span>
        </div>
        <div>
            <input class="select-input select-item-icon" type="text" readonly onfocus="this.blur()"
                placeholder="<?php echo Text::_('ICON'); ?>">
            <i class="zmdi zmdi-attachment-alt"></i>
            <div class="reset-element-icon">
                <i class="zmdi zmdi-close"></i>
                <span class="ba-tooltip">
                    <?php echo Text::_('RESET'); ?>
                </span>
            </div>
        </div>
    </div>
    <div class="modal-footer">
        <a href="#" class="ba-btn" data-dismiss="modal">
            <?php echo Text::_('CANCEL'); ?>
        </a>
        <a href="#" class="ba-btn-primary disable-button" id="apply-new-element">
            <?php echo Text::_('SAVE'); ?>
        </a>
    </div>
</div>
<div id="add-new-field-element-modal" class="ba-modal-sm modal hide" style="display: none;" aria-hidden="false">
    <div class="modal-body">
        <h3 class="ba-modal-title"><?php echo Text::_('FIELD'); ?></h3>
        <div class="ba-input-lg">
            <input type="text" class="field-element-title reset-input-margin" placeholder="<?php echo Text::_('LABEL'); ?>">
            <span class="focus-underline"></span>
        </div>
        <div class="ba-custom-select field-element-type-select visible-select-top">
            <input readonly onfocus="this.blur()" type="text" value="">
            <input type="hidden" value="">
            <i class="zmdi zmdi-caret-down"></i>
            <ul>
                <li data-value="text"><?php echo Text::_('TEXT'); ?></li>
                <li data-value="textarea"><?php echo Text::_('TEXTAREA'); ?></li>
                <li data-value="select"><?php echo Text::_('DROPDOWN'); ?></li>
                <li data-value="checkbox"><?php echo Text::_('CHECKBOX'); ?></li>
                <li data-value="radio"><?php echo Text::_('RADIO'); ?></li>
                <li data-value="url"><?php echo Text::_('URL'); ?></li>
                <li data-value="price"><?php echo Text::_('PRICE'); ?></li>
                <li data-value="number"><?php echo Text::_('NUMBER'); ?></li>
                <li data-value="date"><?php echo Text::_('DATE'); ?></li>
                <li data-value="event-date"><?php echo Text::_('EVENT_DATE'); ?></li>
                <li data-value="time"><?php echo Text::_('TIME'); ?></li>
                <li data-value="range"><?php echo Text::_('SLIDER'); ?></li>
                <li data-value="file"><?php echo Text::_('ATTACHMENT_FILE'); ?></li>
                <li data-value="tag"><?php echo Text::_('TAG'); ?></li>
            </ul>
        </div>
    </div>
    <div class="modal-footer">
        <a href="#" class="ba-btn" data-dismiss="modal">
            <?php echo Text::_('CANCEL'); ?>
        </a>
        <a href="#" class="ba-btn-primary disable-button" id="apply-new-field-element">
            <?php echo Text::_('SAVE'); ?>
        </a>
    </div>
</div>
<div id="edit-radio-field-element-modal" class="ba-modal-sm modal hide" style="display: none;" aria-hidden="false">
    <div class="modal-body">
        <h3 class="ba-modal-title"><?php echo Text::_('ITEM'); ?></h3>
        <div class="ba-input-lg">
            <input type="text" class="radio-field-value" placeholder="<?php echo Text::_('TITLE'); ?>">
            <span class="focus-underline"></span>
        </div>
    </div>
    <div class="modal-footer">
        <a href="#" class="ba-btn" data-dismiss="modal">
            <?php echo Text::_('CANCEL'); ?>
        </a>
        <a href="#" class="ba-btn-primary disable-button" id="apply-new-radio-value">
            <?php echo Text::_('SAVE'); ?>
        </a>
    </div>
</div>
<div id="edit-content-slider-item-modal" class="ba-modal-lg modal hide">
    <div class="modal-header">
        <div class="modal-header-icon">
            <i class="zmdi zmdi-check" id="apply-content-slider-item"></i>
            <i class="zmdi zmdi-close" data-dismiss="modal"></i>
        </div>
    </div>
    <div class="modal-body">
        <div class="general-tabs">
            <ul class="nav nav-tabs uploader-nav">
                <li class="active">
                    <a href="#content-slider-add-item" data-toggle="tab">
                        <i class="zmdi zmdi-settings"></i>
                        <?php echo Text::_('ITEM'); ?>
                    </a>
                </li>
            </ul>
        </div>
        <div class="tab-content">
            <div id="content-slider-add-item">
                <div class="ba-options-group">
                    <div class="ba-group-element">
                        <label>
                            <?php echo Text::_('TYPE'); ?>
                        </label>
                        <div class="ba-custom-select content-slider-background-select" data-callback="emptyCallback">
                            <input readonly onfocus="this.blur()" type="text">
                            <input type="hidden">
                            <i class="zmdi zmdi-caret-down"></i>
                            <ul>
                                <li data-value="color"><?php echo Text::_('COLOR'); ?></li>
                                <li data-value="gradient"><?php echo Text::_('GRADIENT'); ?></li>
                                <li data-value="image"><?php echo Text::_('IMAGE'); ?></li>
                                <li data-value="video"><?php echo Text::_('VIDEO'); ?></li>
                                <li data-value="none"><?php echo Text::_('NO_NE'); ?></li>
                            </ul>
                        </div>
                    </div>
                    <div class="background-options">
                        <div class="color-options">
                            <div class="ba-group-element">
                                <label>
                                    <?php echo Text::_('COLOR'); ?>
                                </label>
                                <input type="text" data-type="color" data-option="color" data-group="background"
                                    data-callback="emptyCallback">
                                <span class="minicolors-opacity-wrapper">
                                    <input type="number" class="minicolors-opacity" data-callback="emptyCallback"
                                    min="0" max="1" step="0.01">
                                    <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                                </span>
                            </div>
                        </div>
                        <div class="image-options" style="display: none;">
                            <div class="ba-group-element">
                                <label>
                                    <?php echo Text::_('UPLOAD_BG_IMAGE'); ?>
                                </label>
                                <input type="text" class="select-input" readonly onfocus="this.blur()"
                                    data-option="image" data-group="image" placeholder="<?php echo Text::_('SELECT'); ?>">
                                <i class="zmdi zmdi-attachment-alt"></i>
                            </div>
                            <div class="ba-group-element">
                                <label>
                                    <?php echo Text::_('ATTACHMENT'); ?>
                                </label>
                                <div class="ba-custom-select attachment">
                                    <input readonly onfocus="this.blur()" value="fixed" type="text">
                                    <input type="hidden" value="fixed" data-option="attachment" data-group="image">
                                    <i class="zmdi zmdi-caret-down"></i>
                                    <ul>
                                        <li data-value="fixed">Fixed</li>
                                        <li data-value="scroll">Scroll</li>
                                    </ul>
                                </div>
                            </div>
                            <div class="ba-group-element">
                                <label>
                                    <?php echo Text::_('SIZE'); ?>
                                </label>
                                <div class="ba-custom-select backround-size">
                                    <input readonly onfocus="this.blur()" value="cover" type="text">
                                    <input type="hidden" value="cover" data-option="size" data-group="image"
                                        data-action="emptyCallback">
                                    <i class="zmdi zmdi-caret-down"></i>
                                    <ul>
                                        <li data-value="cover">Cover</li>
                                        <li data-value="contain">Contain</li>
                                        <li data-value="initial">Auto</li>
                                    </ul>
                                </div>
                            </div>
                            <div class="contain-size-options" style="display: none;">
                                <div class="ba-group-element">
                                    <label>
                                        <?php echo Text::_('POSITION'); ?>
                                    </label>
                                    <div class="ba-custom-select backround-position">
                                        <input readonly onfocus="this.blur()" value="center center" type="text">
                                        <input type="hidden" value="center center" data-option="position" data-group="image"
                                            data-action="emptyCallback">
                                        <i class="zmdi zmdi-caret-down"></i>
                                        <ul>
                                            <li data-value="left top">Left Top</li>
                                            <li data-value="left center">Left Center</li>
                                            <li data-value="left bottom">Left Bottom</li>
                                            <li data-value="right top">Right Top</li>
                                            <li data-value="right center">Right Center</li>
                                            <li data-value="right bottom">Right Bottom</li>
                                            <li data-value="center top">Center Top</li>
                                            <li data-value="center center">Center Center</li>
                                            <li data-value="center bottom">Center Bottom</li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="ba-group-element">
                                    <label>
                                        <?php echo Text::_('REPEAT'); ?>
                                    </label>
                                    <div class="ba-custom-select backround-repeat">
                                        <input readonly onfocus="this.blur()" value="no-repeat" type="text">
                                        <input type="hidden" value="no-repeat" data-option="repeat" data-group="image"
                                            data-action="emptyCallback">
                                        <i class="zmdi zmdi-caret-down"></i>
                                        <ul>
                                            <li data-value="repeat">Repeat</li>
                                            <li data-value="repeat-x">Repeat-x</li>
                                            <li data-value="repeat-y">Repeat-y</li>
                                            <li data-value="no-repeat">No-repeat</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="gradient-options" style="display: none;">
                            <div class="ba-group-element">
                                <label>
                                    <?php echo Text::_('EFFECT'); ?>
                                </label>
                                <div class="ba-custom-select content-slider-gradient-effect-select">
                                    <input readonly onfocus="this.blur()" value="" type="text">
                                    <input type="hidden" value="" data-property="background">
                                    <i class="zmdi zmdi-caret-down"></i>
                                    <ul>
                                        <li data-value="linear">Linear</li>
                                        <li data-value="radial">Radial</li>
                                    </ul>
                                </div>
                            </div>
                            <div class="ba-group-element background-linear-gradient">
                                <label>
                                    <?php echo Text::_('ANGLE'); ?>
                                </label>
                                <div class="ba-range-wrapper">
                                    <span class="ba-range-liner"></span>
                                    <input type="range" class="ba-range" min="0" max="360" step="1">
                                    <input type="number" data-option="angle" data-group="background" data-subgroup="gradient"
                                        step="1" data-callback="emptyCallback">
                                </div>
                            </div>
                            <div class="ba-group-element">
                                <label>
                                    <?php echo Text::_('START_COLOR'); ?>
                                </label>
                                <input type="text" data-type="color" data-option="color1" data-group="background"
                                    data-subgroup="gradient" data-callback="emptyCallback">
                                <span class="minicolors-opacity-wrapper">
                                    <input type="number" class="minicolors-opacity" data-callback="emptyCallback"
                                    min="0" max="1" step="0.01">
                                    <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                                </span>
                            </div>
                            <div class="ba-group-element">
                                <label>
                                    <?php echo Text::_('POSITION'); ?>
                                </label>
                                <div class="ba-range-wrapper">
                                    <span class="ba-range-liner"></span>
                                    <input type="range" class="ba-range" min="0" max="100" step="1">
                                    <input type="number" data-option="position1" data-group="background" data-subgroup="gradient"
                                        step="1" data-callback="emptyCallback">
                                </div>
                            </div>
                            <div class="ba-group-element">
                                <label>
                                    <?php echo Text::_('END_COLOR'); ?>
                                </label>
                                <input type="text" data-type="color" data-option="color2" data-group="background"
                                    data-subgroup="gradient" data-callback="emptyCallback">
                                <span class="minicolors-opacity-wrapper">
                                    <input type="number" class="minicolors-opacity" data-callback="emptyCallback"
                                    min="0" max="1" step="0.01">
                                    <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                                </span>
                            </div>
                            <div class="ba-group-element">
                                <label>
                                    <?php echo Text::_('POSITION'); ?>
                                </label>
                                <div class="ba-range-wrapper">
                                    <span class="ba-range-liner"></span>
                                    <input type="range" class="ba-range" min="0" max="100" step="1">
                                    <input type="number" data-option="position2" data-group="background" data-subgroup="gradient"
                                        step="1" data-callback="emptyCallback">
                                </div>
                            </div>
                        </div>
                        <div class="video-options desktop-only" style="display: none;">
                            <div class="ba-group-element">
                                <label>
                                    <?php echo Text::_('VIDEO_SOURCE'); ?>
                                </label>
                                <div class="ba-custom-select video-select">
                                    <input readonly onfocus="this.blur()" value="Youtube" type="text">
                                    <input type="hidden" value="youtube" data-option="video-type" data-group="background">
                                    <i class="zmdi zmdi-caret-down"></i>
                                    <ul>
                                        <li data-value="youtube">Youtube</li>
                                        <li data-value="vimeo">Vimeo</li>
                                        <li data-value="source"><?php echo Text::_('SOURCE_FILE'); ?></li>
                                    </ul>
                                </div>
                            </div>
                            <div class="ba-group-element video-id">
                                <label>
                                    <?php echo Text::_('VIDEO_ID'); ?>
                                </label>
                                <input type="text" data-option="id" data-group="background"
                                    placeholder="<?php echo Text::_('VIDEO_ID'); ?>" data-callback="emptyCallback">
                            </div>
                            <div class="ba-group-element video-source-select">
                                <label>
                                    <?php echo Text::_('SOURCE_FILE'); ?>
                                </label>
                                <input type="text" class="select-input" readonly onfocus="this.blur()" data-option="source"
                                    placeholder="<?php echo Text::_('SELECT'); ?>" data-callback="emptyCallback">
                                <i class="zmdi zmdi-attachment-alt"></i>
                                <label class="ba-help-icon">
                                    <i class="zmdi zmdi-help"></i>
                                    <span class="ba-tooltip ba-help">
                                        <?php echo Text::_('SOURCE_FILE_TOOLTIP'); ?>
                                    </span>
                                </label>
                            </div>
                            <div class="ba-group-element">
                                <label>
                                    <?php echo Text::_('START'); ?>
                                </label>
                                <input type="text" data-option="start" data-group="background"
                                    placeholder="<?php echo Text::_('START'); ?>" data-callback="emptyCallback">
                            </div>
                        </div>
                    </div>
                </div>
                <p class="ba-group-title"><?php echo Text::_('OVERLAY'); ?></p>
                <div class="ba-options-group">
                    <div class="ba-group-element">
                        <label>
                            <?php echo Text::_('TYPE'); ?>
                        </label>
                        <div class="ba-custom-select content-slider-background-overlay-select">
                            <input readonly onfocus="this.blur()" type="text">
                            <input type="hidden" data-property="overlay">
                            <i class="zmdi zmdi-caret-down"></i>
                            <ul>
                                <li data-value="color"><?php echo Text::_('COLOR'); ?></li>
                                <li data-value="gradient"><?php echo Text::_('GRADIENT'); ?></li>
                                <li data-value="none"><?php echo Text::_('NO_NE'); ?></li>
                            </ul>
                        </div>
                    </div>
                    <div class="overlay-color-options">
                        <div class="ba-group-element">
                            <label>
                                <?php echo Text::_('COLOR'); ?>
                            </label>
                            <input type="text" data-type="color" data-option="color" data-group="overlay" data-callback="emptyCallback">
                            <span class="minicolors-opacity-wrapper">
                                <input type="number" class="minicolors-opacity" data-callback="emptyCallback"
                                min="0" max="1" step="0.01">
                                <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                            </span>
                        </div>
                    </div>
                    <div class="overlay-gradient-options">
                        <div class="ba-group-element">
                            <label>
                                <?php echo Text::_('EFFECT'); ?>
                            </label>
                            <div class="ba-custom-select content-slider-gradient-effect-select">
                                <input readonly onfocus="this.blur()" value="" type="text">
                                <input type="hidden" value="" data-property="overlay">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="linear">Linear</li>
                                    <li data-value="radial">Radial</li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-group-element overlay-linear-gradient">
                            <label>
                                <?php echo Text::_('ANGLE'); ?>
                            </label>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="360" step="1">
                                <input type="number" data-option="angle" data-group="overlay" data-subgroup="gradient"
                                    step="1" data-callback="emptyCallback">
                            </div>
                        </div>
                        <div class="ba-group-element">
                            <label>
                                <?php echo Text::_('START_COLOR'); ?>
                            </label>
                            <input type="text" data-type="color" data-option="color1" data-group="overlay"
                                data-subgroup="gradient" data-callback="emptyCallback">
                            <span class="minicolors-opacity-wrapper">
                                <input type="number" class="minicolors-opacity" data-callback="emptyCallback"
                                min="0" max="1" step="0.01">
                                <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                            </span>
                        </div>
                        <div class="ba-group-element">
                            <label>
                                <?php echo Text::_('POSITION'); ?>
                            </label>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="100" step="1">
                                <input type="number" data-option="position1" data-group="overlay" data-subgroup="gradient"
                                    step="1" data-callback="emptyCallback">
                            </div>
                        </div>
                        <div class="ba-group-element">
                            <label>
                                <?php echo Text::_('END_COLOR'); ?>
                            </label>
                            <input type="text" data-type="color" data-option="color2" data-group="overlay"
                                data-subgroup="gradient" data-callback="emptyCallback">
                            <span class="minicolors-opacity-wrapper">
                                <input type="number" class="minicolors-opacity" data-callback="emptyCallback"
                                min="0" max="1" step="0.01">
                                <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                            </span>
                        </div>
                        <div class="ba-group-element">
                            <label>
                                <?php echo Text::_('POSITION'); ?>
                            </label>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="100" step="1">
                                <input type="number" data-option="position2" data-group="overlay" data-subgroup="gradient"
                                    step="1" data-callback="emptyCallback">
                            </div>
                        </div>
                    </div>
                </div>
                <p class="ba-group-title desktop-only"><?php echo Text::_('LINK'); ?></p>
                <div class="ba-options-group desktop-only">
                    <div class="ba-group-element link-picker-container">
                        <label>
                            <?php echo Text::_('LINK'); ?>
                        </label>
                        <input type="text" class="slide-button-link" placeholder="<?php echo Text::_('LINK'); ?>">
                        <div class="select-link">
                            <i class="zmdi zmdi-attachment-alt"></i>
                            <span class="ba-tooltip"><?php echo Text::_('LINK_PICKER') ?></span>
                        </div>
                        <div class="select-file">
                            <i class="zmdi zmdi-file"></i>
                            <span class="ba-tooltip"><?php echo Text::_('FILE_PICKER') ?></span>
                        </div>
                    </div>
                    <div class="ba-group-element">
                        <label>
                            <?php echo Text::_('ARIA_LABEL'); ?>
                        </label>
                        <input type="text" class="slide-button-aria-label"
                               placeholder="<?php echo Text::_('ARIA_LABEL'); ?>">
                    </div>
                    <div class="ba-group-element">
                        <label>
                            <?php echo Text::_('TARGET'); ?>
                        </label>
                        <div class="ba-custom-select slide-button-target-select visible-select-top">
                            <input readonly onfocus="this.blur()" value="" type="text">
                            <input type="hidden" value="">
                            <i class="zmdi zmdi-caret-down"></i>
                            <ul>
                                <li data-value="_blank"><?php echo Text::_('NEW_WINDOW'); ?></li>
                                <li data-value="_self"><?php echo Text::_('SAME_WINDOW'); ?></li>
                            </ul>
                        </div>
                    </div>
                    <div class="ba-group-element">
                        <label>
                            <?php echo Text::_('TYPE'); ?>
                        </label>
                        <div class="ba-custom-select slide-button-attribute-select visible-select-top">
                            <input readonly onfocus="this.blur()" value="" type="text">
                            <input type="hidden" value="">
                            <i class="zmdi zmdi-caret-down"></i>
                            <ul>
                                <li data-value=""><?php echo Text::_('DEFAULT'); ?></li>
                                <li data-value="download"><?php echo Text::_('DOWNLOAD'); ?></li>
                            </ul>
                        </div>
                    </div>
                    <div class="ba-group-element">
                        <label>
                            <?php echo Text::_('EMBED_CODE'); ?>
                        </label>
                        <input type="text" class="slide-button-embed-code" placeholder="<?php echo Text::_('EMBED_CODE'); ?>">
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div id="one-page-item-modal" class="ba-modal-sm modal hide" style="display: none;" aria-hidden="false">
    <div class="modal-body">
        <h3 class="ba-modal-title"><?php echo Text::_('ITEM'); ?></h3>
        <div class="ba-input-lg">
            <input type="text" class="element-title reset-input-margin" placeholder="<?php echo Text::_('TITLE'); ?>">
            <span class="focus-underline"></span>
        </div>
        <div class="ba-input-lg">
            <input type="text" class="element-alias reset-input-margin" placeholder="<?php echo Text::_('ALIAS'); ?>">
            <span class="focus-underline"></span>
        </div>
        <div class="ba-input-lg">
            <input type="text" readonly onfocus="this.blur()" class="select-end-point select-input reset-input-margin"
                placeholder="<?php echo Text::_('SELECT_END_POINT'); ?>">
            <i class="zmdi zmdi-attachment-alt"></i>
        </div>
        <div class="ba-input-lg">
            <input class="select-item-icon" type="text" readonly onfocus="this.blur()"
                placeholder="<?php echo Text::_('ICON'); ?>">
            <i class="zmdi zmdi-attachment-alt"></i>
            <div class="reset-element-icon">
                <i class="zmdi zmdi-close"></i>
                <span class="ba-tooltip">
                    <?php echo Text::_('RESET'); ?>
                </span>
            </div>
        </div>
    </div>
    <div class="modal-footer">
        <a href="#" class="ba-btn" data-dismiss="modal">
            <?php echo Text::_('CANCEL'); ?>
        </a>
        <a href="#" class="ba-btn-primary disable-button" id="apply-one-page-item">
            <?php echo Text::_('SAVE'); ?>
        </a>
    </div>
</div>
<div id="icons-list-item-modal" class="ba-modal-sm modal hide" style="display: none;" aria-hidden="false">
    <div class="modal-body">
        <h3 class="ba-modal-title"><?php echo Text::_('ITEM'); ?></h3>
        <div class="ba-input-lg">
            <input type="text" class="element-title reset-input-margin" placeholder="<?php echo Text::_('TITLE'); ?>">
            <span class="focus-underline"></span>
        </div>
        <div class="ba-input-lg">
            <input class="select-item-icon reset-input-margin" type="text" readonly onfocus="this.blur()"
                placeholder="<?php echo Text::_('ICON'); ?>">
            <i class="zmdi zmdi-attachment-alt"></i>
            <div class="reset-element-icon">
                <i class="zmdi zmdi-close"></i>
                <span class="ba-tooltip">
                    <?php echo Text::_('RESET'); ?>
                </span>
            </div>
        </div>
        <div class="ba-input-lg">
            <input type="text" class="reset-input-margin element-link" placeholder="<?php echo Text::_('LINK') ?>">
            <span class="focus-underline"></span>
            <div class="select-link">
                <i class="zmdi zmdi-attachment-alt"></i>
                <span class="ba-tooltip"><?php echo Text::_('LINK_PICKER'); ?></span>
            </div>
        </div>
        <div class="ba-custom-select element-target-select">
            <input readonly="" onfocus="this.blur()" type="text">
            <input type="hidden">
            <i class="zmdi zmdi-caret-down"></i>
            <ul>
                <li data-value="_blank"><?php echo Text::_('NEW_WINDOW'); ?></li>
                <li data-value="_self"><?php echo Text::_('SAME_WINDOW'); ?></li>
            </ul>
        </div>
    </div>
    <div class="modal-footer">
        <a href="#" class="ba-btn" data-dismiss="modal">
            <?php echo Text::_('CANCEL'); ?>
        </a>
        <a href="#" class="ba-btn-primary disable-button" id="apply-icons-list-item">
            <?php echo Text::_('SAVE'); ?>
        </a>
    </div>
</div>
<div id="menu-item-add-modal" class="ba-modal-sm modal hide" style="display: none;" aria-hidden="false">
    <div class="modal-body">
        <h3 class="ba-modal-title"><?php echo Text::_('ITEM'); ?></h3>
        <div class="ba-custom-select menu-item-type-select">
            <input readonly="" onfocus="this.blur()" type="text" class="reset-input-margin">
            <input type="hidden" data-property="type">
            <i class="zmdi zmdi-caret-down"></i>
            <ul>
                <li data-value="component"><?php echo Text::_('MULTI_PAGE'); ?></li>
                <li data-value="url"><?php echo Text::_('ONE_PAGE'); ?></li>
            </ul>
        </div>
        <div class="ba-input-lg">
            <input type="text" class="reset-input-margin" data-property="title" placeholder="<?php echo Text::_('TITLE'); ?>">
            <span class="focus-underline"></span>
        </div>
        <div class="component-settings">
            <div class="ba-input-lg">
                <input type="text" readonly="" onfocus="this.blur()" data-property="link" class="reset-input-margin select-link"
                       placeholder="<?php echo Text::_('PAGE'); ?>">
                <i class="zmdi zmdi-attachment-alt"></i>
            </div>
        </div>
        <div class="url-settings">
            <div class="ba-input-lg">
                <input type="text" readonly onfocus="this.blur()" data-property="anchor" class="select-end-point select-input reset-input-margin"
                       placeholder="<?php echo Text::_('SELECT_END_POINT'); ?>">
                <i class="zmdi zmdi-attachment-alt"></i>
            </div>
        </div>
        <div class="ba-custom-select menu-items-select-parent visible-select-top">
            <input readonly="" onfocus="this.blur()" type="text">
            <input type="hidden" data-property="parent">
            <i class="zmdi zmdi-caret-down"></i>
            <ul>
                <li data-value="1" class="item-root"><?php echo Text::_('MENU_ITEM_ROOT'); ?></li>
            </ul>
        </div>
    </div>
    <div class="modal-footer">
        <a href="#" class="ba-btn" data-dismiss="modal">
            <?php echo Text::_('CANCEL'); ?>
        </a>
        <a href="#" class="ba-btn-primary disable-button" id="apply-new-menu-item">
            <?php echo Text::_('SAVE'); ?>
        </a>
    </div>
</div>
<div id="simple-gallery-item-edit-modal" class="ba-modal-lg modal hide">
    <div class="modal-header">
        <div class="modal-header-icon">
            <i class="zmdi zmdi-check" id="apply-simple-gallery-item"></i>
            <i class="zmdi zmdi-close" data-dismiss="modal"></i>
        </div>
    </div>
    <div class="modal-body">
        <div class="general-tabs">
            <ul class="nav nav-tabs uploader-nav">
                <li class="active">
                    <a href="#simple-gallery-edit-item" data-toggle="tab">
                        <i class="zmdi zmdi-settings"></i>
                        <?php echo Text::_('ITEM'); ?>
                    </a>
                </li>
            </ul>
        </div>
        <div class="tab-content">
            <div id="simple-gallery-edit-item">
                <div class="ba-options-group">
                    <div class="ba-group-element">
                        <label>
                            <?php echo Text::_('SELECT'); ?>
                        </label>
                        <input type="text" class="select-input simple-gallery-upload-image" readonly onfocus="this.blur()"
                            placeholder="<?php echo Text::_('SELECT'); ?>">
                        <i class="zmdi zmdi-attachment-alt"></i>
                    </div>
                    <div class="ba-group-element">
                        <label>
                            <?php echo Text::_('IMAGE_ALT'); ?>
                        </label>
                        <input type="text" class="simple-gallery-alt" placeholder="<?php echo Text::_('IMAGE_ALT'); ?>">
                    </div>
                </div>
                <p class="ba-group-title"><?php echo Text::_('CAPTION'); ?></p>
                <div class="ba-options-group">
                    <div class="ba-group-element">
                        <label>
                            <?php echo Text::_('TITLE'); ?>
                        </label>
                        <input type="text" class="simple-gallery-title" placeholder="<?php echo Text::_('TITLE'); ?>">
                    </div>
                    <div class="ba-group-element">
                        <label>
                            <?php echo Text::_('DESCRIPTION'); ?>
                        </label>
                        <textarea class="simple-gallery-description" placeholder="<?php echo Text::_('DESCRIPTION'); ?>"></textarea>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div id="field-sorting-item-edit-modal" class="ba-modal-lg modal hide">
    <div class="modal-header">
        <div class="modal-header-icon">
            <i class="zmdi zmdi-check" id="apply-field-sorting-item"></i>
            <i class="zmdi zmdi-close" data-dismiss="modal"></i>
        </div>
    </div>
    <div class="modal-body">
        <div class="general-tabs">
            <ul class="nav nav-tabs uploader-nav">
                <li class="active">
                    <a href="#field-sorting-edit-item" data-toggle="tab">
                        <i class="zmdi zmdi-settings"></i>
                        <?php echo Text::_('ITEM'); ?>
                    </a>
                </li>
            </ul>
        </div>
        <div class="tab-content">
            <div id="field-sorting-edit-item">
                <div class="ba-options-group">
                    <div class="ba-group-element">
                        <label>
                            <?php echo Text::_('SELECT'); ?>
                        </label>
                        <input type="text" class="select-input field-sorting-upload-image" readonly onfocus="this.blur()"
                            placeholder="<?php echo Text::_('SELECT'); ?>">
                        <i class="zmdi zmdi-attachment-alt"></i>
                    </div>
                    <div class="ba-group-element">
                        <label>
                            <?php echo Text::_('IMAGE_ALT'); ?>
                        </label>
                        <input type="text" class="field-simple-gallery-alt" placeholder="<?php echo Text::_('IMAGE_ALT'); ?>">
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div id="image-item-edit-modal" class="ba-modal-lg modal hide">
    <div class="modal-header">
        <div class="modal-header-icon">
            <i class="zmdi zmdi-check" id="apply-image-item"></i>
            <i class="zmdi zmdi-close" data-dismiss="modal"></i>
        </div>
    </div>
    <div class="modal-body">
        <div class="general-tabs">
            <ul class="nav nav-tabs uploader-nav">
                <li class="active">
                    <a href="#image-edit-item" data-toggle="tab">
                        <i class="zmdi zmdi-settings"></i>
                        <?php echo Text::_('ITEM'); ?>
                    </a>
                </li>
            </ul>
        </div>
        <div class="tab-content">
            <div id="image-edit-item">
                <div class="ba-options-group">
                    <div class="ba-group-element">
                        <label>
                            <?php echo Text::_('SELECT'); ?>
                        </label>
                        <input type="text" class="select-input image-item-upload-image" readonly onfocus="this.blur()"
                            placeholder="<?php echo Text::_('SELECT'); ?>">
                        <i class="zmdi zmdi-attachment-alt"></i>
                    </div>
                    <div class="ba-group-element">
                        <label>
                            <?php echo Text::_('IMAGE_ALT'); ?>
                        </label>
                        <input type="text" class="image-item-alt" placeholder="<?php echo Text::_('IMAGE_ALT'); ?>">
                    </div>
                </div>
                <p class="ba-group-title"><?php echo Text::_('CAPTION'); ?></p>
                <div class="ba-options-group">
                    <div class="ba-group-element">
                        <label>
                            <?php echo Text::_('TITLE'); ?>
                        </label>
                        <input type="text" class="image-item-title" placeholder="<?php echo Text::_('TITLE'); ?>">
                    </div>
                    <div class="ba-group-element">
                        <label>
                            <?php echo Text::_('DESCRIPTION'); ?>
                        </label>
                        <textarea class="image-item-description" placeholder="<?php echo Text::_('DESCRIPTION'); ?>"></textarea>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div id="before-after-item-edit-modal" class="ba-modal-lg modal hide">
    <div class="modal-header">
        <div class="modal-header-icon">
            <i class="zmdi zmdi-check" id="apply-before-after-item"></i>
            <i class="zmdi zmdi-close" data-dismiss="modal"></i>
        </div>
    </div>
    <div class="modal-body">
        <div class="general-tabs">
            <ul class="nav nav-tabs uploader-nav">
                <li class="active">
                    <a href="#before-after-edit-item" data-toggle="tab">
                        <i class="zmdi zmdi-settings"></i>
                        <?php echo Text::_('ITEM'); ?>
                    </a>
                </li>
            </ul>
        </div>
        <div class="tab-content">
            <div id="before-after-edit-item">
                <div class="ba-options-group">
                    <div class="ba-group-element">
                        <label>
                            <?php echo Text::_('SELECT'); ?>
                        </label>
                        <input type="text" class="select-input image-item-upload-image" readonly onfocus="this.blur()"
                            placeholder="<?php echo Text::_('SELECT'); ?>">
                        <i class="zmdi zmdi-attachment-alt"></i>
                    </div>
                    <div class="ba-group-element">
                        <label>
                            <?php echo Text::_('IMAGE_ALT'); ?>
                        </label>
                        <input type="text" class="image-item-alt" placeholder="<?php echo Text::_('IMAGE_ALT'); ?>">
                    </div>
                </div>
                <div class="ba-options-group">
                    <div class="ba-group-element">
                        <label>
                            <?php echo Text::_('LABEL'); ?>
                        </label>
                        <input type="text" class="image-item-label" placeholder="<?php echo Text::_('LABEL'); ?>">
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div id="testimonial-item-edit-modal" class="ba-modal-lg modal hide">
    <div class="modal-header">
        <div class="modal-header-icon">
            <i class="zmdi zmdi-check" id="apply-testimonial-item"></i>
            <i class="zmdi zmdi-close" data-dismiss="modal"></i>
        </div>
    </div>
    <div class="modal-body">
        <div class="general-tabs">
            <ul class="nav nav-tabs uploader-nav">
                <li class="active">
                    <a href="#testimonial-edit-item" data-toggle="tab">
                        <i class="zmdi zmdi-settings"></i>
                        <?php echo Text::_('ITEM'); ?>
                    </a>
                </li>
            </ul>
        </div>
        <div class="tab-content">
            <div id="testimonial-edit-item">
                <div class="ba-options-group">
                    <div class="ba-group-element">
                        <label>
                            <?php echo Text::_('TESTIMONIAL'); ?>
                        </label>
                        <textarea class="image-item-testimonial" placeholder="<?php echo Text::_('TESTIMONIAL'); ?>"></textarea>
                    </div>
                </div>
                <p class="ba-group-title"><?php echo Text::_('AUTHOR'); ?></p>
                <div class="ba-options-group">
                    <div class="ba-group-element">
                        <label>
                            <?php echo Text::_('IMAGE'); ?>
                        </label>
                        <input type="text" class="select-input image-item-upload-image" readonly onfocus="this.blur()"
                            placeholder="<?php echo Text::_('IMAGE'); ?>">
                        <i class="zmdi zmdi-attachment-alt"></i>
                        <div class="reset disabled-reset reset-item-edit-image">
                            <i class="zmdi zmdi-close"></i>
                            <span class="ba-tooltip"><?php echo Text::_("RESET"); ?></span>
                        </div>
                    </div>
                    <div class="ba-group-element">
                        <label>
                            <?php echo Text::_('NAME'); ?>
                        </label>
                        <input type="text" class="image-item-name" placeholder="<?php echo Text::_('NAME'); ?>">
                    </div>
                    <div class="ba-group-element">
                        <label>
                            <?php echo Text::_('CAPTION'); ?>
                        </label>
                        <input type="text" class="image-item-caption" placeholder="<?php echo Text::_('CAPTION'); ?>">
                    </div>
                    <div class="ba-group-element">
                        <label>
                            <?php echo Text::_('LINK'); ?>
                        </label>
                        <input type="text" class="image-item-link" placeholder="<?php echo Text::_('LINK'); ?>">
                    </div>
                    <div class="ba-group-element">
                        <label>
                            <?php echo Text::_('ARIA_LABEL'); ?>
                        </label>
                        <input type="text" class="image-item-aria-label"
                               placeholder="<?php echo Text::_('ARIA_LABEL'); ?>">
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div id="feature-box-item-modal" class="ba-modal-lg modal hide">
    <div class="modal-header">
        <div class="modal-header-icon">
            <i class="zmdi zmdi-check" id="apply-feature-box-item"></i>
            <i class="zmdi zmdi-close" data-dismiss="modal"></i>
        </div>
    </div>
    <div class="modal-body">
        <div class="general-tabs">
            <ul class="nav nav-tabs uploader-nav">
                <li class="active">
                    <a href="#feature-box-edit-item" data-toggle="tab">
                        <i class="zmdi zmdi-settings"></i>
                        <?php echo Text::_('ITEM'); ?>
                    </a>
                </li>
            </ul>
        </div>
        <div class="tab-content">
            <div id="feature-box-edit-item">
                <div class="ba-options-group">
                    <div class="ba-group-element">
                        <label><?php echo Text::_('TYPE'); ?></label>
                        <div class="ba-custom-select feature-box-type-select">
                            <input readonly="" onfocus="this.blur()" value="" type="text">
                            <input type="hidden" value="image">
                            <i class="zmdi zmdi-caret-down"></i>
                            <ul>
                                <li data-value="icon"><?php echo Text::_('ICON'); ?></li>
                                <li data-value="image"><?php echo Text::_('IMAGE'); ?></li>
                            </ul>
                        </div>
                    </div>
                    <div class="ba-group-element feature-box-type-option" data-type="icon">
                        <label>
                            <?php echo Text::_('SELECT'); ?>
                        </label>
                        <input type="text" class="select-input select-item-icon" readonly onfocus="this.blur()"
                            placeholder="<?php echo Text::_('SELECT'); ?>">
                        <i class="zmdi zmdi-attachment-alt"></i>
                        <div class="reset disabled-reset reset-item-edit-image">
                            <i class="zmdi zmdi-close"></i>
                            <span class="ba-tooltip"><?php echo Text::_("RESET"); ?></span>
                        </div>
                    </div>
                    <div class="ba-group-element feature-box-type-option" data-type="image">
                        <label>
                            <?php echo Text::_('SELECT'); ?>
                        </label>
                        <input type="text" class="select-input image-item-upload-image" readonly onfocus="this.blur()"
                            placeholder="<?php echo Text::_('SELECT'); ?>">
                        <i class="zmdi zmdi-attachment-alt"></i>
                        <div class="reset disabled-reset reset-item-edit-image">
                            <i class="zmdi zmdi-close"></i>
                            <span class="ba-tooltip"><?php echo Text::_("RESET"); ?></span>
                        </div>
                    </div>
                </div>
                <p class="ba-group-title"><?php echo Text::_('CAPTION'); ?></p>
                <div class="ba-options-group">
                    <div class="ba-group-element">
                        <label>
                            <?php echo Text::_('TITLE'); ?>
                        </label>
                        <input type="text" class="slide-title" placeholder="<?php echo Text::_('TITLE'); ?>">
                    </div>
                    <div class="ba-group-element">
                        <label>
                            <?php echo Text::_('DESCRIPTION'); ?>
                        </label>
                        <textarea class="slide-description" placeholder="<?php echo Text::_('DESCRIPTION'); ?>"></textarea>
                    </div>
                </div>
                <p class="ba-group-title desktop-only"><?php echo Text::_('LINK'); ?></p>
                <div class="ba-options-group desktop-only">
                    <div class="ba-group-element">
                        <label>
                            <?php echo Text::_('VIEW'); ?>
                        </label>
                        <div class="ba-custom-select slide-button-type-select">
                            <input readonly onfocus="this.blur()" value="" type="text">
                            <input type="hidden" value="">
                            <i class="zmdi zmdi-caret-down"></i>
                            <ul>
                                <li data-value="button"><?php echo Text::_('BUTTON'); ?></li>
                                <li data-value="link"><?php echo Text::_('LINK'); ?></li>
                            </ul>
                        </div>
                    </div>
                    <div class="ba-group-element slideshow-button-label">
                        <label>
                            <?php echo Text::_('LABEL'); ?>
                        </label>
                        <input type="text" class="slide-button-label" placeholder="<?php echo Text::_('LABEL'); ?>">
                    </div>
                    <div class="ba-group-element link-picker-container">
                        <label>
                            <?php echo Text::_('LINK'); ?>
                        </label>
                        <input type="text" class="slide-button-link" placeholder="<?php echo Text::_('LINK'); ?>">
                        <div class="select-link">
                            <i class="zmdi zmdi-attachment-alt"></i>
                            <span class="ba-tooltip"><?php echo Text::_('LINK_PICKER') ?></span>
                        </div>
                        <div class="select-file">
                            <i class="zmdi zmdi-file"></i>
                            <span class="ba-tooltip"><?php echo Text::_('FILE_PICKER') ?></span>
                        </div>
                    </div>
                    <div class="ba-group-element">
                        <label>
                            <?php echo Text::_('ARIA_LABEL'); ?>
                        </label>
                        <input type="text" class="slide-button-aria-label"
                               placeholder="<?php echo Text::_('ARIA_LABEL'); ?>">
                    </div>
                    <div class="ba-group-element">
                        <label>
                            <?php echo Text::_('TARGET'); ?>
                        </label>
                        <div class="ba-custom-select slide-button-target-select visible-select-top">
                            <input readonly onfocus="this.blur()" value="" type="text">
                            <input type="hidden" value="">
                            <i class="zmdi zmdi-caret-down"></i>
                            <ul>
                                <li data-value="_blank"><?php echo Text::_('NEW_WINDOW'); ?></li>
                                <li data-value="_self"><?php echo Text::_('SAME_WINDOW'); ?></li>
                            </ul>
                        </div>
                    </div>
                    <div class="ba-group-element">
                        <label>
                            <?php echo Text::_('TYPE'); ?>
                        </label>
                        <div class="ba-custom-select slide-button-attribute-select visible-select-top">
                            <input readonly onfocus="this.blur()" value="" type="text">
                            <input type="hidden" value="">
                            <i class="zmdi zmdi-caret-down"></i>
                            <ul>
                                <li data-value=""><?php echo Text::_('DEFAULT'); ?></li>
                                <li data-value="download"><?php echo Text::_('DOWNLOAD'); ?></li>
                            </ul>
                        </div>
                    </div>
                    <div class="ba-group-element">
                        <label>
                            <?php echo Text::_('EMBED_CODE'); ?>
                        </label>
                        <input type="text" class="slide-button-embed-code" placeholder="<?php echo Text::_('EMBED_CODE'); ?>">
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div id="menu-item-edit-modal" class="ba-modal-sm modal hide" style="display: none;" aria-hidden="false">
    <div class="modal-body">
        <h3 class="ba-modal-title"><?php echo Text::_('ITEM'); ?></h3>
        <div class="ba-input-lg">
            <input type="text" data-property="title" class="reset-input-margin" placeholder="<?php echo Text::_('TITLE'); ?>">
            <span class="focus-underline"></span>
        </div>
        <div class="ba-input-lg">
            <input type="text" readonly onfocus="this.blur()" data-property="icon" class="reset-input-margin select-item-icon"
                placeholder="<?php echo Text::_('ICON'); ?>">
            <i class="zmdi zmdi-attachment-alt"></i>
            <div class="reset-element-icon">
                <i class="zmdi zmdi-close"></i>
                <span class="ba-tooltip">
                    <?php echo Text::_('RESET'); ?>
                </span>
            </div>
        </div>
        <div class="url-settings">
            <div class="ba-input-lg">
                <input type="text"
                       readonly onfocus="this.blur()"
                       data-property="anchor" class="select-end-point select-input reset-input-margin"
                       placeholder="<?php echo Text::_('SELECT_END_POINT'); ?>">
                <i class="zmdi zmdi-attachment-alt"></i>
            </div>
        </div>
        <div class="component-settings">
            <div class="ba-checkbox-parent">
                <label class="ba-checkbox ba-hide-checkbox">
                    <input type="checkbox" data-property="megamenu">
                    <span></span>
                </label>
                <label><?php echo Text::_('MEGAMENU'); ?></label>
            </div>
        </div>
    </div>
    <div class="modal-footer">
        <a href="#" class="ba-btn" data-dismiss="modal">
            <?php echo Text::_('CANCEL'); ?>
        </a>
        <a href="#" class="ba-btn-primary disable-button" id="apply-menu-item">
            <?php echo Text::_('SAVE'); ?>
        </a>
    </div>
</div>
<div class="ba-toolbar">
    <div class="ba-toolbar-group">
        <div class="ba-toolbar-element gridbox-save">
            <i class="zmdi zmdi-check"></i>
            <span class="ba-toolbar-label">
                <?php echo Text::_('SAVE'); ?>
            </span>
        </div>
        <i class="zmdi zmdi-caret-down" data-context="save-as-context-menu"></i>
    </div>
    <div class="ba-toolbar-group">
        <div class="ba-toolbar-element ba-action-undo" data-module="actionUndo">
            <i class="zmdi zmdi-arrow-left"></i>
            <span class="ba-tooltip ba-bottom">
                <?php echo Text::_('UNDO'); ?>
            </span>
        </div>
        <div class="ba-toolbar-element ba-action-redo" data-module="actionRedo">
            <i class="zmdi zmdi-arrow-right"></i>
            <span class="ba-tooltip ba-bottom">
                <?php echo Text::_('REDO'); ?>
            </span>
        </div>
    </div>
    <div class="ba-toolbar-group">
<?php
    if (!empty($this->associations) && $this->item->language != '*') {
?>
        <div class="ba-toolbar-element" data-context="associations-context-menu">
            <img src="<?php echo $flags.$this->item->language; ?>.png">
            <span class="ba-toolbar-label">
                <?php echo $this->languages[$this->item->language]; ?>
            </span>
            <i class="zmdi zmdi-caret-down"></i>
        </div>
<?php
    }
?>
        <div class="ba-toolbar-element<?php echo $this->website->disable_responsive == 1 ? ' disable-button' : ''; ?>"
            data-context="responsive-context-menu">
            <i class="zmdi zmdi-desktop-windows"></i>
            <span class="ba-toolbar-label">
                <?php echo Text::_('DESKTOP'); ?>
            </span>
            <i class="zmdi zmdi-caret-down"></i>
        </div>
    </div>
<?php
if ($user->authorise('core.tools', 'com_gridbox')) {
?>
    <div class="ba-toolbar-group">
        <div class="ba-toolbar-element" data-context="tools-context-menu">
            <i class="zmdi zmdi-wrench"></i>
            <span class="ba-toolbar-label">
                <?php echo Text::_('TOOLS'); ?>
            </span>
            <i class="zmdi zmdi-caret-down"></i>
        </div>
    </div>
<?php
}
?>
    <div class="ba-toolbar-group">
        <div class="ba-toolbar-element" data-context="page-context-menu">
            <i class="zmdi zmdi-settings"></i>
            <span class="ba-toolbar-label">
                <?php echo Text::_('PAGE'); ?>
            </span>
            <i class="zmdi zmdi-caret-down"></i>
        </div>
<?php
if ($user->authorise('core.tools', 'com_gridbox')) {
?>
        <div class="ba-toolbar-element ba-theme-editor">
            <i class="zmdi zmdi-format-color-fill"></i>
            <span class="ba-toolbar-label">
                <?php echo Text::_('THEME'); ?>
            </span>
        </div>
        <div class="ba-toolbar-element ba-site-settings">
            <i class="zmdi zmdi-globe"></i>
            <span class="ba-toolbar-label">
                <?php echo Text::_('SITE'); ?>
            </span>
        </div>
<?php
}
?>
    </div>
</div>
<div class="ba-sidebar<?php echo !empty($this->link) ? ' has-page-link' : ''; ?>">
    <div class="top-icons">
<?php
if ($user->authorise('core.tools', 'com_gridbox')) {
?>
        <span class="show-page-structure <?php echo $systemType; ?>" data-context="page-structure">
            <a href="#">
                <span class="zmdi zmdi-view-subtitles"></span>
            </a>
            <span class="ba-tooltip ba-right">
                <?php echo Text::_('PAGE_STRUCTURE'); ?>
            </span>
        </span>
        <span class="add-page-block <?php echo $systemType; ?>" data-context="section-page-blocks-list">
            <a href="#">
                <span class="zmdi zmdi-collection-plus"></span>
            </a>
            <span class="ba-tooltip ba-right">
                <?php echo Text::_('PAGE_BLOCKS'); ?>
            </span>
        </span>
<?php
}
?>
		<span class="add-library-block <?php echo $systemType; ?>" data-context="section-library-list">
            <a href="#">
                <span class="zmdi zmdi-collection-text"></span>
            </a>
            <span class="ba-tooltip ba-right">
                <?php echo Text::_('LIBRARY'); ?>
            </span>
        </span>
        <span class="hide-hidden-elements" style="display: none;">
            <a href="#">
                <span class="zmdi zmdi-eye"></span>
            </a>
            <span class="ba-tooltip ba-right">
                <?php echo Text::_('SHOW_HIDDEN'); ?>
            </span>
        </span>
        <span class="show-hidden-elements">
            <a href="#">
                <span class="zmdi zmdi-eye-off"></span>
            </a>
            <span class="ba-tooltip ba-right">
                <?php echo Text::_('HIDE_HIDDEN'); ?>
            </span>
        </span>
    </div>
    <div class="bottom-icons">
        <span class="shortcuts-gridbox">
            <a href="#">
                <span class="zmdi zmdi-keyboard"></span>
            </a>
            <span class="ba-tooltip ba-right"><?php echo Text::_('SHORTCUTS'); ?></span>
        </span>
<?php
    if (!empty($this->link)) {
?>
        <span class="page-link">
            <a href="<?php echo $this->link; ?>" class="default-action" target="_blank">
                <span class="zmdi zmdi-globe-alt"></span>
            </a>
            <span class="ba-tooltip ba-right"><?php echo Text::_('VIEW_PAGE'); ?></span>
        </span>
<?php
    }
    if ($user->authorise('core.manage', 'com_gridbox')) {
?>
        <span class="joomla-admin">
            <a href="<?php echo Uri::root().'administrator/index.php?option=com_gridbox'; ?>" class="default-action" target="_blank">
                <span class="zmdi zmdi-home"></span>
            </a>
            <span class="ba-tooltip ba-right"><?php echo Text::_('DASHBOARD'); ?></span>
        </span>
<?php
    }
    
?>
    </div>
</div>
<div id="code-editor-dialog" class="ba-modal-lg modal hide" style="display: none;">
    <div class="modal-header">
        <h3 class="ba-modal-title"><?php echo Text::_('CODE_EDITOR'); ?></h3>
        <div class="modal-header-icon">
            <i class="zmdi zmdi-close" data-dismiss="modal"></i>
        </div>
    </div>
    <div class="modal-body">
        <div class="general-tabs">
            <ul class="nav nav-tabs code-nav">
                <li class="active">
                    <a href="#code-edit-css" data-toggle="tab">
                        css
                    </a>
                </li>
                <li>
                    <a href="#code-edit-javascript" data-toggle="tab">
                        javascript
                    </a>
                </li>
            </ul>
            <div class="tabs-underline"></div>
            <div class="tab-content">
                <div id="code-edit-css" class="row-fluid tab-pane active">
                    <textarea id="code-editor-css"></textarea>
                    <span></span>
                </div>
                <div id="code-edit-javascript" class="row-fluid tab-pane">
                    <textarea id="code-editor-javascript"></textarea>
                    <span></span>
                </div>
            </div>
        </div>
    </div>
    <i class="zmdi zmdi-format-valign-center resizable-handle-right"></i>
</div>
<div id="ckeditor-code-editor-dialog" class="ba-modal-lg modal hide" style="display: none;">
    <div class="modal-header">
        <h3 class="ba-modal-title"><?php echo Text::_('CODE_EDITOR'); ?></h3>
        <div class="modal-header-icon">
            <i class="zmdi zmdi-close" data-dismiss="modal"></i>
        </div>
    </div>
    <div class="modal-body">
        <textarea id="ckeditor-code-editor"></textarea>
    </div>
    <i class="zmdi zmdi-format-valign-center resizable-handle-right"></i>
</div>
<div id="states-transition-modal" class="modal hide ba-modal-picker" style="display:none">
    <div class="modal-body">
        <div class="general-tabs">
            <ul class="nav nav-tabs code-nav">
                <li class="active">
                    <a href="#states-transition-presets-tab" data-toggle="tab">
                        <i class="zmdi zmdi-settings"></i>
                    </a>
                </li>
                <li>
                    <a href="#states-transition-settings-tab" data-toggle="tab">
                        <i class="zmdi zmdi-tune"></i>
                    </a>
                </li>
            </ul>
            <div class="tabs-underline"></div>
            <div class="tab-content">
                <div id="states-transition-presets-tab" class="row-fluid tab-pane active">
                    <div class="states-transition-wrapper">
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('DURATION'); ?></span>
                            <input type="number" data-option="duration" step="0.01"
                                data-group="shadow" data-subgroup="transition" data-callback="sectionRules">
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" step="0.01" min="0" max="1">
                            </div>
                        </div>
                    </div>
                    <div class="cubic-bezier-presets-wrapper">
                        <div class="cubic-bezier-preset" data-values="0.45, 0.05, 0.55, 0.95">
                            <svg width="72" height="72" xmlns="http://www.w3.org/2000/svg">
                                <path d="M 24 48 C 34.68 49.2, 37.2 25.2, 48 24"></path>
                            </svg>
                            <span class="ba-tooltip ba-top">easeInOutSine</span>
                        </div>
                        <div class="cubic-bezier-preset" data-values="0.46, 0.03, 0.52, 0.96">
                            <svg width="72" height="72" xmlns="http://www.w3.org/2000/svg">
                                <path d="M 24 48 C 34.92 46.8, 37.2 25.2, 48 24"></path>
                            </svg>
                            <span class="ba-tooltip ba-top">easeInOutQuad</span>
                        </div>
                        <div class="cubic-bezier-preset" data-values="0.65, 0.05, 0.36, 1">
                            <svg width="72" height="72" xmlns="http://www.w3.org/2000/svg">
                                <path d="M 24 48 C 39.48 46.92, 32.52 24, 48 24"></path>
                            </svg>
                            <span class="ba-tooltip ba-top">easeInOutCubic</span>
                        </div>
                        <div class="cubic-bezier-preset" data-values="0.77, 0, 0.18, 1">
                            <svg width="72" height="72" xmlns="http://www.w3.org/2000/svg">
                                <path d="M 24 48 C 42.48 48, 28.2 24, 48 24"></path>
                            </svg>
                            <span class="ba-tooltip ba-top">easeInOutQuart</span>
                        </div>
                        <div class="cubic-bezier-preset" data-values="0.79, 0.14, 0.15, 0.86">
                            <svg width="72" height="72" xmlns="http://www.w3.org/2000/svg">
                                <path d="M 24 48 C 42.84 44.76, 27.6 27.36, 48 24"></path>
                            </svg>
                            <span class="ba-tooltip ba-top">easeInOutCirc</span>
                        </div>
                        <div class="cubic-bezier-preset" data-values="0.86, 0, 0.07, 1">
                            <svg width="72" height="72" xmlns="http://www.w3.org/2000/svg">
                                <path d="M 24 48 C 44.64 48, 25.68 24, 48 24"></path>
                            </svg>
                            <span class="ba-tooltip ba-top">easeInOutQuint</span>
                        </div>
                        <div class="cubic-bezier-preset" data-values="1, 0, 0, 1">
                            <svg width="72" height="72" xmlns="http://www.w3.org/2000/svg">
                                <path d="M 24 48 C 48 48, 24 24, 48 24"></path>
                            </svg>
                            <span class="ba-tooltip ba-top">easeInOutExpo</span>
                        </div>
                        <div class="cubic-bezier-preset" data-values="0.68, -0.55, 0.27, 1.5">
                            <svg width="72" height="72" xmlns="http://www.w3.org/2000/svg">
                                <path d="M 24 48 C 40.32 61.2, 30.36 10.8, 48 24"></path>
                            </svg>
                            <span class="ba-tooltip ba-top">easeInOutBack</span>
                        </div>
                        <div class="cubic-bezier-preset" data-values="0.47, 0, 0.75, 0.72">
                            <svg width="72" height="72" xmlns="http://www.w3.org/2000/svg">
                                <path d="M 24 48 C 35.28 48.0, 41.88 30.84, 48 24"></path>
                            </svg>
                            <span class="ba-tooltip ba-top">easeInSine</span>
                        </div>
                        <div class="cubic-bezier-preset" data-values="0.55, 0.08, 0.68, 0.53">
                            <svg width="72" height="72" xmlns="http://www.w3.org/2000/svg">
                                <path d="M 24 48 C 37.2 45.96, 40.32 35.28, 48 24"></path>
                            </svg>
                            <span class="ba-tooltip ba-top">easeInQuad</span>
                        </div>
                        <div class="cubic-bezier-preset" data-values="0.55, 0.06, 0.68, 0.19">
                            <svg width="72" height="72" xmlns="http://www.w3.org/2000/svg">
                                <path d="M 24 48 C 37.2 46.68, 40.2 43.44, 48 24"></path>
                            </svg>
                            <span class="ba-tooltip ba-top">easeInCubic</span>
                        </div>
                        <div class="cubic-bezier-preset" data-values="0.9, 0.03, 0.69, 0.22">
                            <svg width="72" height="72" xmlns="http://www.w3.org/2000/svg">
                                <path d="M 24 48 C 45.48 47.28, 40.44 42.72, 48 24"></path>
                            </svg>
                            <span class="ba-tooltip ba-top">easeInQuart</span>
                        </div>
                        <div class="cubic-bezier-preset" data-values="0.76, 0.05, 0.86, 0.06">
                            <svg width="72" height="72" xmlns="http://www.w3.org/2000/svg">
                                <path d="M 24 48 C 42.12 46.8, 44.52 46.56, 48 24"></path>
                            </svg>
                            <span class="ba-tooltip ba-top">easeInQuint</span>
                        </div>
                        <div class="cubic-bezier-preset" data-values="0.95, 0.05, 0.8, 0.04">
                            <svg width="72" height="72" xmlns="http://www.w3.org/2000/svg">
                                <path d="M 24 48 C 46.8 46.8, 43.08 47.16, 48 24"></path>
                            </svg>
                            <span class="ba-tooltip ba-top">easeInExpo</span>
                        </div>
                        <div class="cubic-bezier-preset" data-values="0.6, 0.04, 0.98, 0.34">
                            <svg width="72" height="72" xmlns="http://www.w3.org/2000/svg">
                                <path d="M 24 48 C 38.4 47.04, 47.52 39.96, 48 24"></path>
                            </svg>
                            <span class="ba-tooltip ba-top">easeInCirc</span>
                        </div>
                        <div class="cubic-bezier-preset" data-values="0.6, -0.28, 0.74, 0.05">
                            <svg width="72" height="72" xmlns="http://www.w3.org/2000/svg">
                                <path d="M 24 48 C 38.4 54.72, 41.64 46.92, 48 24"></path>
                            </svg>
                            <span class="ba-tooltip ba-top">easeInBack</span>
                        </div>
                        <div class="cubic-bezier-preset" data-values="0.39, 0.57, 0.56, 1">
                            <svg width="72" height="72" xmlns="http://www.w3.org/2000/svg">
                                <path d="M 24 48 C 33.36 34.2, 37.56 24, 48 24"></path>
                            </svg>
                            <span class="ba-tooltip ba-top">easeOutSine</span>
                        </div>
                        <div class="cubic-bezier-preset" data-values="0.25, 0.46, 0.45, 0.94">
                            <svg width="72" height="72" xmlns="http://www.w3.org/2000/svg">
                                <path d="M 24 48 C 30 36.6, 34.8 25.44, 48 24"></path>
                            </svg>
                            <span class="ba-tooltip ba-top">easeOutQuad</span>
                        </div>
                        <div class="cubic-bezier-preset" data-values="0.22, 0.61, 0.36, 1">
                            <svg width="72" height="72" xmlns="http://www.w3.org/2000/svg">
                                <path d="M 24 48 C 29.16 33.36, 32.52 24, 48 24"></path>
                            </svg>
                            <span class="ba-tooltip ba-top">easeOutCubic</span>
                        </div>
                        <div class="cubic-bezier-preset" data-values="0.17, 0.84, 0.44, 1">
                            <svg width="72" height="72" xmlns="http://www.w3.org/2000/svg">
                                <path d="M 24 48 C 27.96 27.84, 34.56 24, 48 24"></path>
                            </svg>
                            <span class="ba-tooltip ba-top">easeOutQuart</span>
                        </div>
                        <div class="cubic-bezier-preset" data-values="0.23, 1, 0.32, 1">
                            <svg width="72" height="72" xmlns="http://www.w3.org/2000/svg">
                                <path d="M 24 48 C 29.52 24, 31.68 24, 48 24"></path>
                            </svg>
                            <span class="ba-tooltip ba-top">easeOutQuint</span>
                        </div>
                        <div class="cubic-bezier-preset" data-values="0.19, 1, 0.22, 1">
                            <svg width="72" height="72" xmlns="http://www.w3.org/2000/svg">
                                <path d="M 24 48 C 28.56 24, 29.28 24, 48 24"></path>
                            </svg>
                            <span class="ba-tooltip ba-top">easeOutExpo</span>
                        </div>
                        <div class="cubic-bezier-preset" data-values="0.08, 0.82, 0.17, 1">
                            <svg width="72" height="72" xmlns="http://www.w3.org/2000/svg">
                                <path d="M 24 48 C 25.8 28.32, 27.96 24, 48 24"></path>
                            </svg>
                            <span class="ba-tooltip ba-top">easeOutCirc</span>
                        </div>
                        <div class="cubic-bezier-preset" data-values="0.18, 0.89, 0.32, 1.27">
                            <svg width="72" height="72" xmlns="http://www.w3.org/2000/svg">
                                <path d="M 24 48 C 28.2 26.76, 31.68 17.4, 48 24"></path>
                            </svg>
                            <span class="ba-tooltip ba-top">easeOutBack</span>
                        </div>
                    </div>
                </div>
                <div id="states-transition-settings-tab" class="row-fluid tab-pane">
                    <div class="cubic-bezier-settings-wrapper">
                        <div class="ba-settings-item">
                            <span>x1</span>
                            <input type="number" data-option="x1" step="0.01"
                                data-group="shadow" data-subgroup="transition" data-callback="sectionRules">
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner letter-spacing"></span>
                                <input type="range" class="ba-range" step="0.01" min="-1.5" max="1.5">
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>y1</span>
                            <input type="number" data-option="y1" step="0.01"
                                data-group="shadow" data-subgroup="transition" data-callback="sectionRules">
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner letter-spacing"></span>
                                <input type="range" class="ba-range" step="0.01" min="-1.5" max="1.5">
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>x2</span>
                            <input type="number" data-option="x2" step="0.01"
                                data-group="shadow" data-subgroup="transition" data-callback="sectionRules">
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner letter-spacing"></span>
                                <input type="range" class="ba-range" step="0.01" min="-1.5" max="1.5">
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>y2</span>
                            <input type="number" data-option="y2" step="0.01"
                                data-group="shadow" data-subgroup="transition" data-callback="sectionRules">
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner letter-spacing"></span>
                                <input type="range" class="ba-range" step="0.01" min="-1.5" max="1.5">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div id="on-scroll-animations-modal" class="modal hide ba-modal-picker" style="display:none">
    <div class="modal-body">
        <div class="general-tabs">
            <ul class="nav nav-tabs code-nav">
                <li class="active">
                    <a href="#on-scroll-animations-settings-tab" data-toggle="tab">
                        <i class="zmdi zmdi-tune"></i>
                    </a>
                </li>
            </ul>
            <div class="tabs-underline"></div>
            <div class="tab-content">
                <div id="on-scroll-animations-settings-tab" class="row-fluid tab-pane active">
                    <div class="ba-settings-group">
                        <div class="ba-settings-item enable-on-scroll-animation">
                            <span>
                                <?php echo Text::_('ENABLE_ANIMATION'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-group="" data-option="enable">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item viewport-on-scroll-animation">
                            <span>
                                <?php echo Text::_('VIEWPORT'); ?>
                            </span>
                            <span class="ba-slider-text-wrapper">
                                <?php echo Text::_('BOTTOM').' <span data-index="0">0</span>% - <span data-index="1">100</span>% '.Text::_('TOP'); ?>
                            </span>
                            <div class="ba-slider-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" min="0" max="100" step="1" value="0" data-index="0">
                                <input type="range" min="0" max="100" step="1" value="100" data-index="1">
                                <input type="hidden" data-group="" data-option="viewport" data-callback="onScrollAnimationCallback">
                            </div>
                        </div>
                        <div class="ba-settings-item rotate-animation-options">
                            <span>
                                <?php echo Text::_('DEGREES'); ?>
                            </span>
                            <input type="number" step="1" data-group="" data-option="end"
                                data-subgroup="property" data-callback="onScrollAnimationCallback">
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="3600" step="1">
                            </div>
                        </div>
                        <div class="ba-settings-item opacity-animation-options">
                            <span>
                                <?php echo Text::_('TRANSPARENCY'); ?>
                            </span>
                            <input type="number" step="1" data-group="" data-option="end"
                                data-subgroup="property" data-callback="onScrollAnimationCallback">
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="100" step="1">
                            </div>
                        </div>
                        <div class="ba-settings-item blur-animation-options">
                            <span>
                                <?php echo Text::_('BLUR'); ?>
                            </span>
                            <input type="number" step="1" data-group="" data-option="end"
                                data-subgroup="property" data-callback="onScrollAnimationCallback">
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="20" step="1">
                            </div>
                        </div>
                        <div class="ba-settings-item scale-animation-options">
                            <span>
                                <?php echo Text::_('SCALE'); ?>
                            </span>
                            <input type="number" step="0.1" data-group="" data-option="end"
                                data-subgroup="property" data-callback="onScrollAnimationCallback">
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="10" step="0.1">
                            </div>
                        </div>
                        <div class="ba-settings-item translateY-animation-options translateX-animation-options">
                            <span>
                                <?php echo Text::_('ANIMATION_SPEED'); ?>
                            </span>
                            <input type="number" step="0.1" data-group="" data-option="speed" data-callback="onScrollAnimationCallback">
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="5" step="0.1">
                            </div>
                        </div>
                        <div class="ba-settings-item translateX-animation-options">
                            <span>
                                <?php echo Text::_('SCROLL_DIRECTION'); ?>
                            </span>
                            <div class="ba-custom-select dark-custom-select set-on-scroll-direction">
                                <input readonly onfocus="this.blur()" type="text" value="<?php echo Text::_('TOP'); ?>">
                                <input type="hidden" data-group="">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="-2"><?php echo Text::_('LEFT_IN'); ?></li>
                                    <li data-value="-1"><?php echo Text::_('LEFT_OUT'); ?></li>
                                    <li data-value="2"><?php echo Text::_('RIGHT_IN'); ?></li>
                                    <li data-value="1"><?php echo Text::_('RIGHT_OUT'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item rotate-animation-options">
                            <span>
                                <?php echo Text::_('DIRECTION'); ?>
                            </span>
                            <div class="ba-custom-select dark-custom-select set-on-scroll-direction">
                                <input readonly onfocus="this.blur()" type="text">
                                <input type="hidden" data-group="">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="-1"><?php echo Text::_('LEFT'); ?></li>
                                    <li data-value="1"><?php echo Text::_('RIGHT'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item opacity-animation-options">
                            <span>
                                <?php echo Text::_('DIRECTION'); ?>
                            </span>
                            <div class="ba-custom-select dark-custom-select set-on-scroll-direction">
                                <input readonly onfocus="this.blur()" type="text">
                                <input type="hidden" data-group="">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="-1"><?php echo Text::_('FADE_IN'); ?></li>
                                    <li data-value="1"><?php echo Text::_('FADE_OUT'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item blur-animation-options">
                            <span>
                                <?php echo Text::_('DIRECTION'); ?>
                            </span>
                            <div class="ba-custom-select dark-custom-select set-on-scroll-direction">
                                <input readonly onfocus="this.blur()" type="text">
                                <input type="hidden" data-group="">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="-1"><?php echo Text::_('BLUR_IN'); ?></li>
                                    <li data-value="1"><?php echo Text::_('BLUR_OUT'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item scale-animation-options">
                            <span>
                                <?php echo Text::_('DIRECTION'); ?>
                            </span>
                            <div class="ba-custom-select dark-custom-select set-on-scroll-direction">
                                <input readonly onfocus="this.blur()" type="text">
                                <input type="hidden" data-group="">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="-1"><?php echo Text::_('SCALE_IN'); ?></li>
                                    <li data-value="1"><?php echo Text::_('SCALE_OUT'); ?></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div id="section-animations-modal" class="modal hide ba-modal-picker" style="display:none">
    <div class="modal-body">
        <div class="general-tabs">
            <ul class="nav nav-tabs code-nav">
                <li class="active">
                    <a href="#section-animations-settings-tab" data-toggle="tab">
                        <i class="zmdi zmdi-tune"></i>
                    </a>
                </li>
            </ul>
            <div class="tabs-underline"></div>
            <div class="tab-content">
                <div id="section-animations-settings-tab" class="row-fluid tab-pane active">
                    <div class="ba-settings-group">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('EFFECT'); ?>
                            </span>
                            <div class="ba-custom-select effect-select dark-custom-select">
                                <input readonly onfocus="this.blur()" type="text" value="<?php echo Text::_('NO_NE'); ?>">
                                <input type="hidden" value="" data-option="effect" data-group="animation">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value=""><?php echo Text::_('NO_NE'); ?></li>
                                    <li data-value="bounceIn">Bounce In</li>
                                    <li data-value="bounceInLeft">Bounce In Left</li>
                                    <li data-value="bounceInRight">Bounce In Right</li>
                                    <li data-value="bounceInUp">Bounce In Up</li>
                                    <li data-value="bounceInBottom">Bounce In Bottom</li>
                                    <li data-value="fadeIn">Fade In</li>
                                    <li data-value="fadeInLeft">Fade In Left</li>
                                    <li data-value="fadeInRight">Fade In Right</li>
                                    <li data-value="fadeInUp">Fade In Up</li>
                                    <li data-value="fadeInBottom">Fade In Bottom</li>
                                    <li data-value="zoomIn">Zoom In</li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('DURATION'); ?>
                            </span>
                            <input type="number" data-option="duration" data-group="animation" step="0.1" data-callback="sectionRules">
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="2" step="0.1">
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('DELAY'); ?>
                            </span>
                            <input type="number" data-option="delay" data-group="animation" step="0.1" data-callback="sectionRules">
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="5" step="0.1">
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('REPEAT_ANIMATION'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" class="repeat-animation" data-option="repeat" data-group="animation">
                                <span></span>
                            </label>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div id="shape-dividers-modal" class="modal hide ba-modal-picker" style="display:none">
    <div class="modal-body">
        <div class="general-tabs">
            <ul class="nav nav-tabs code-nav">
                <li class="active">
                    <a href="#shape-dividers-presets-tab" data-toggle="tab">
                        <i class="zmdi zmdi-settings"></i>
                    </a>
                </li>
                <li>
                    <a href="#shape-dividers-settings-tab" data-toggle="tab">
                        <i class="zmdi zmdi-tune"></i>
                    </a>
                </li>
            </ul>
            <div class="tabs-underline"></div>
            <div class="tab-content">
                <div id="shape-dividers-presets-tab" class="row-fluid tab-pane active">
                    <div class="shape-dividers-presets-wrapper" data-position="">
                        <div class="shape-dividers-preset" data-value="">
                            <i class="zmdi zmdi-eye-off"></i>
                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('NO_NE'); ?></span>
                        </div>
                        <div class="shape-dividers-preset" data-value="arrow">
                            <span class="ba-tooltip ba-top">Arrow</span>
                        </div>
                        <div class="shape-dividers-preset" data-value="blot">
                            <span class="ba-tooltip ba-top">Blot</span>
                        </div>
                        <div class="shape-dividers-preset" data-value="blot-2">
                            <span class="ba-tooltip ba-top">Blot 2</span>
                        </div>
                        <div class="shape-dividers-preset" data-value="camber">
                            <span class="ba-tooltip ba-top">Сamber</span>
                        </div>
                        <div class="shape-dividers-preset" data-value="circle">
                            <span class="ba-tooltip ba-top">Circle</span>
                        </div>
                        <div class="shape-dividers-preset" data-value="circles">
                            <span class="ba-tooltip ba-top">Circles</span>
                        </div>
                        <div class="shape-dividers-preset" data-value="clouds">
                            <span class="ba-tooltip ba-top">Clouds</span>
                        </div>
                        <div class="shape-dividers-preset" data-value="curve-left">
                            <span class="ba-tooltip ba-top">Сurve Left</span>
                        </div>
                        <div class="shape-dividers-preset" data-value="curve-right">
                            <span class="ba-tooltip ba-top">Сurve Right</span>
                        </div>
                        <div class="shape-dividers-preset" data-value="delta">
                            <span class="ba-tooltip ba-top">Delta</span>
                        </div>
                        <div class="shape-dividers-preset" data-value="grunge">
                            <span class="ba-tooltip ba-top">Grunge</span>
                        </div>
                        <div class="shape-dividers-preset" data-value="hexagons">
                            <span class="ba-tooltip ba-top">Hexagons</span>
                        </div>
                        <div class="shape-dividers-preset" data-value="hexas">
                            <span class="ba-tooltip ba-top">Hexas</span>
                        </div>
                        <div class="shape-dividers-preset" data-value="spectre-left">
                            <span class="ba-tooltip ba-top">Spectre Left</span>
                        </div>
                        <div class="shape-dividers-preset" data-value="spectre-right">
                            <span class="ba-tooltip ba-top">Spectre Right</span>
                        </div>
                        <div class="shape-dividers-preset" data-value="stoner">
                            <span class="ba-tooltip ba-top">Stoner</span>
                        </div>
                        <div class="shape-dividers-preset" data-value="torsion">
                            <span class="ba-tooltip ba-top">Torsion</span>
                        </div>
                        <div class="shape-dividers-preset" data-value="triangle">
                            <span class="ba-tooltip ba-top">Triangle</span>
                        </div>
                        <div class="shape-dividers-preset" data-value="triangle-left">
                            <span class="ba-tooltip ba-top">Triangle Left</span>
                        </div>
                        <div class="shape-dividers-preset" data-value="triangle-right">
                            <span class="ba-tooltip ba-top">Triangle Right</span>
                        </div>
                        <div class="shape-dividers-preset" data-value="triangles">
                            <span class="ba-tooltip ba-top">Triangles</span>
                        </div>
                        <div class="shape-dividers-preset" data-value="vertex">
                            <span class="ba-tooltip ba-top">Vertex</span>
                        </div>
                        <div class="shape-dividers-preset" data-value="wave">
                            <span class="ba-tooltip ba-top">Wave</span>
                        </div>
                        <div class="shape-dividers-preset" data-value="wave-2">
                            <span class="ba-tooltip ba-top">Wave 2</span>
                        </div>
                        <div class="shape-dividers-preset" data-value="wave-3">
                            <span class="ba-tooltip ba-top">Wave 3</span>
                        </div>
                        <div class="shape-dividers-preset" data-value="wave-4">
                            <span class="ba-tooltip ba-top">Wave 4</span>
                        </div>
                        <div class="shape-dividers-preset" data-value="waves">
                            <span class="ba-tooltip ba-top">Waves</span>
                        </div>
                        <div class="shape-dividers-preset" data-value="zigzag">
                            <span class="ba-tooltip ba-top">Zigzag</span>
                        </div>
                    </div>
                </div>
                <div id="shape-dividers-settings-tab" class="row-fluid tab-pane">
                    <div class="ba-settings-group">
                        <div class="ba-settings-item shape-dividers-color-setting">
                            <span>
                                <?php echo Text::_('COLOR'); ?>
                            </span>
                            <input type="text" data-type="color" data-option="color" data-group="shape" data-subgroup="bottom">
                            <span class="minicolors-opacity-wrapper">
                                <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                min="0" max="1" step="0.01">
                                <span class="ba-tooltip ba-bottom"><?php echo Text::_('OPACITY') ?></span>
                            </span>
                        </div>
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('INFO_WIDTH'); ?></span>
                            <input type="number" data-option="width" step="1"
                                data-group="shape" data-subgroup="bottom" data-callback="sectionRules">
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" step="1" min="100" max="1000">
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('INFO_HEIGHT'); ?></span>
                            <input type="number" data-option="height" step="1"
                                data-group="shape" data-subgroup="bottom" data-callback="sectionRules">
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" step="1" min="0" max="1000">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div id="color-variables-dialog" class="modal hide ba-modal-picker" style="display: none;">
    <div class="modal-body">
        <div class="general-tabs">
            <ul class="nav nav-tabs code-nav">
                <li class="active">
                    <a href="#color-picker-cell" data-toggle="tab">
                        <i class="zmdi zmdi-eyedropper"></i>
                    </a>
                </li>
                <li>
                    <a href="#color-variables-cell" data-toggle="tab">
                        <i class="zmdi zmdi-format-color-fill "></i>
                    </a>
                </li>
            </ul>
            <div class="tabs-underline"></div>
            <div class="tab-content">
                <div id="color-picker-cell" class="row-fluid tab-pane active">
                    <i class="zmdi zmdi-eyedropper ba-eyedropper-icon"></i>
                    <input type="text" class="variables-color-picker">
                    <span class="minicolors-opacity-wrapper">
                        <input type="number" class="minicolors-opacity" min="0" max="1" step="0.01">
                        <span class="ba-tooltip"><?php echo Text::_('OPACITY'); ?></span>
                    </span>
                </div>
                <div id="color-variables-cell" class="row-fluid tab-pane">
                    <div class="color-variables-group">
                        <div class="color-variables-group-title">
                            <span><?php echo Text::_('BRAND'); ?></span>
                        </div>
                        <div class="color-variables-item" data-variable="@primary">
                            <span class="color-varibles-color-swatch"></span>
                            <span class="ba-tooltip"><?php echo Text::_('PRIMARY'); ?></span>
                        </div>
                        <div class="color-variables-item" data-variable="@secondary">
                            <span class="color-varibles-color-swatch"></span>
                            <span class="ba-tooltip"><?php echo Text::_('SECONDARY'); ?></span>
                        </div>
                        <div class="color-variables-item" data-variable="@accent">
                            <span class="color-varibles-color-swatch"></span>
                            <span class="ba-tooltip"><?php echo Text::_('ACCENT'); ?></span>
                        </div>
                    </div>
                    <div class="color-variables-group">
                        <div class="color-variables-group-title">
                            <span><?php echo Text::_('TYPOGRAPHY'); ?></span>
                        </div>
                        <div class="color-variables-item" data-variable="@title">
                            <span class="color-varibles-color-swatch"></span>
                            <span class="ba-tooltip"><?php echo Text::_('TITLE'); ?></span>
                        </div>
                        <div class="color-variables-item" data-variable="@subtitle">
                            <span class="color-varibles-color-swatch"></span>
                            <span class="ba-tooltip"><?php echo Text::_('SUBTITLE'); ?></span>
                        </div>
                        <div class="color-variables-item" data-variable="@text">
                            <span class="color-varibles-color-swatch"></span>
                            <span class="ba-tooltip"><?php echo Text::_('TEXT'); ?></span>
                        </div>
                        <div class="color-variables-item" data-variable="@icon">
                            <span class="color-varibles-color-swatch"></span>
                            <span class="ba-tooltip"><?php echo Text::_('ICON'); ?></span>
                        </div>
                        <div class="color-variables-item" data-variable="@title-inverse">
                            <span class="color-varibles-color-swatch"></span>
                            <span class="ba-tooltip"><?php echo Text::_('TITLE_INVERSE'); ?></span>
                        </div>
                        <div class="color-variables-item" data-variable="@text-inverse">
                            <span class="color-varibles-color-swatch"></span>
                            <span class="ba-tooltip"><?php echo Text::_('TEXT_INVERSE'); ?></span>
                        </div>
                    </div>
                    <div class="color-variables-group">
                        <div class="color-variables-group-title">
                            <span><?php echo Text::_('BACKGROUND'); ?></span>
                        </div>
                        <div class="color-variables-item" data-variable="@bg-primary">
                            <span class="color-varibles-color-swatch"></span>
                            <span class="ba-tooltip"><?php echo Text::_('PRIMARY'); ?></span>
                        </div>
                        <div class="color-variables-item" data-variable="@bg-secondary">
                            <span class="color-varibles-color-swatch"></span>
                            <span class="ba-tooltip"><?php echo Text::_('SECONDARY'); ?></span>
                        </div>
                        <div class="color-variables-item" data-variable="@bg-dark">
                            <span class="color-varibles-color-swatch"></span>
                            <span class="ba-tooltip"><?php echo Text::_('DARK'); ?></span>
                        </div>
                        <div class="color-variables-item" data-variable="@bg-dark-accent">
                            <span class="color-varibles-color-swatch"></span>
                            <span class="ba-tooltip"><?php echo Text::_('DARK_ACCENT'); ?></span>
                        </div>
                    </div>
                    <div class="color-variables-group">
                        <div class="color-variables-group-title">
                            <span><?php echo Text::_('OTHER'); ?></span>
                        </div>
                        <div class="color-variables-item" data-variable="@border">
                            <span class="color-varibles-color-swatch"></span>
                            <span class="ba-tooltip"><?php echo Text::_('BORDER'); ?></span>
                        </div>
                        <div class="color-variables-item" data-variable="@shadow">
                            <span class="color-varibles-color-swatch"></span>
                            <span class="ba-tooltip"><?php echo Text::_('SHADOW'); ?></span>
                        </div>
                        <div class="color-variables-item" data-variable="@overlay">
                            <span class="color-varibles-color-swatch"></span>
                            <span class="ba-tooltip"><?php echo Text::_('OVERLAY'); ?></span>
                        </div>
                        <div class="color-variables-item" data-variable="@hover">
                            <span class="color-varibles-color-swatch"></span>
                            <span class="ba-tooltip"><?php echo Text::_('HOVER'); ?></span>
                        </div>
                    </div>
                    <div class="color-variables-group">
                        <div class="color-variables-group-title">
                            <span><?php echo Text::_('CUSTOM_COLORS') ?></span>
                        </div>
                        <div class="color-variables-item" data-variable="@color-1">
                            <span class="color-varibles-color-swatch"></span>
                            <span class="ba-tooltip"><?php echo Text::_('COLOR'); ?> 1</span>
                        </div>
                        <div class="color-variables-item" data-variable="@color-2">
                            <span class="color-varibles-color-swatch"></span>
                            <span class="ba-tooltip"><?php echo Text::_('COLOR'); ?> 2</span>
                        </div>
                        <div class="color-variables-item" data-variable="@color-3">
                            <span class="color-varibles-color-swatch"></span>
                            <span class="ba-tooltip"><?php echo Text::_('COLOR'); ?> 3</span>
                        </div>
                        <div class="color-variables-item" data-variable="@color-4">
                            <span class="color-varibles-color-swatch"></span>
                            <span class="ba-tooltip"><?php echo Text::_('COLOR'); ?> 4</span>
                        </div>
                        <div class="color-variables-item" data-variable="@color-5">
                            <span class="color-varibles-color-swatch"></span>
                            <span class="ba-tooltip"><?php echo Text::_('COLOR'); ?> 5</span>
                        </div>
                        <div class="color-variables-item" data-variable="@color-6">
                            <span class="color-varibles-color-swatch"></span>
                            <span class="ba-tooltip"><?php echo Text::_('COLOR'); ?> 6</span>
                        </div>
                        <div class="color-variables-item" data-variable="@color-7">
                            <span class="color-varibles-color-swatch"></span>
                            <span class="ba-tooltip"><?php echo Text::_('COLOR'); ?> 7</span>
                        </div>
                        <div class="color-variables-item" data-variable="@color-8">
                            <span class="color-varibles-color-swatch"></span>
                            <span class="ba-tooltip"><?php echo Text::_('COLOR'); ?> 8</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php
if (empty($this->edit_type) && ($this->item->app_type == 'products' || $this->item->app_type == 'booking')) {
?>
<div id="product-badges-dialog" class="modal hide ba-modal-product-picker picker-modal-arrow ba-modal-list-picker"
    style="display: none;" data-position="right">
    <div class="modal-body modal-list-type-wrapper">
        <div class="ba-settings-item ba-settings-input-type">
            <div class="picker-search-wrapper">
                <input type="text" placeholder="<?php echo Text::_('SEARCH'); ?>" class="picker-search">
                <i class="zmdi zmdi-search"></i>
            </div>
            <span class="add-badge-item prevent-event">
                <i class="zmdi zmdi-label"></i>
                <span class="ba-tooltip ba-top"><?php echo Text::_('ADD_NEW_ITEM'); ?></span>
            </span>
        </div>
        <div class="ba-settings-item ba-settings-list-type">
            <ul>
                
            </ul>
            <template class="product-badge-li">
                <li>
                    <span class="product-badge-color-wrapper">
                        <span class="product-badge-color"></span>
                        <span class="edit-product-badge-color"></span>
                        <i class="zmdi zmdi-eyedropper"></i>
                    </span>
                    <input type="text">
                    <span class="product-badge-title"></span>
                    <span class="edit-badge-item prevent-event">
                        <i class="zmdi zmdi-edit"></i>
                        <span class="ba-tooltip ba-top"><?php echo Text::_('EDIT'); ?></span>
                    </span>
                    <span class="save-badge-item prevent-event">
                        <i class="zmdi zmdi-check"></i>
                        <span class="ba-tooltip ba-top"><?php echo Text::_('SAVE'); ?></span>
                    </span>
                    <span class="delete-badge-item prevent-event">
                        <i class="zmdi zmdi-delete"></i>
                        <span class="ba-tooltip ba-top"><?php echo Text::_('DELETE'); ?></span>
                    </span>
                    <span class="close-badge-edit prevent-event">
                        <i class="zmdi zmdi-close"></i>
                        <span class="ba-tooltip ba-top"><?php echo Text::_('CLOSE'); ?></span>
                    </span>
                </li>
            </template>
        </div>
    </div>
</div>
<?php
}
?>
<div id="font-family-dialog" class="modal hide ba-modal-picker" style="display: none;">
    <div class="modal-header">
        <span class="open-font-library">
            <i class="zmdi zmdi-brightness-auto"></i>
            <span class="ba-tooltip"><?php echo Text::_('FONT_LIBRARY'); ?></span>
        </span>
    </div>
    <div class="modal-body">
        <div class="font-family-wrapper">
            
        </div>
    </div>
</div>
<div id="font-weight-dialog" class="modal hide ba-modal-picker" style="display: none;">
    <div class="modal-header">
        <span class="open-font-library">
            <i class="zmdi zmdi-brightness-auto"></i>
            <span class="ba-tooltip"><?php echo Text::_('FONT_LIBRARY'); ?></span>
        </span>
    </div>
    <div class="modal-body">
        <div class="font-weight-wrapper">
            
        </div>
    </div>
</div>
<div id="spinners-dialog" class="modal hide ba-modal-picker" style="display: none;">
    <div class="modal-header">
        <span>
            <i class="zmdi zmdi-spinner"></i>
            <span class="ba-tooltip"><?php echo Text::_('SPINNERS'); ?></span>
        </span>
    </div>
    <div class="modal-body">
        <div class="spinners-wrapper">
            <div class="preloader-wrapper ba-spinner-1" data-value="ba-spinner-1">
                <div class="preloader-point-wrapper">
                    <div class="preloader-point-1"></div>
                    <div class="preloader-point-2"></div>
                    <div class="preloader-point-3"></div>
                    <div class="preloader-point-4"></div>
                </div>
            </div>
            <div class="preloader-wrapper ba-spinner-2" data-value="ba-spinner-2">
                <div class="preloader-point-wrapper">
                    <div>
                        <div class="preloader-point-1"></div>
                        <div class="preloader-point-2"></div>
                    </div>
                    <div>
                        <div class="preloader-point-1"></div>
                        <div class="preloader-point-2"></div>
                    </div>
                </div>
            </div>
            <div class="preloader-wrapper ba-spinner-3" data-value="ba-spinner-3">
                <div class="preloader-point-wrapper">
                    <div class="preloader-point-1"></div>
                </div>
            </div>
            <div class="preloader-wrapper ba-spinner-4" data-value="ba-spinner-4">
                <div class="preloader-point-wrapper">
                    <div class="preloader-point-1"></div>
                    <div class="preloader-point-2"></div>
                </div>
            </div>
            <div class="preloader-wrapper ba-spinner-5" data-value="ba-spinner-5">
                <div class="preloader-point-wrapper">
                    <div class="preloader-point-1"></div>
                    <div class="preloader-point-2"></div>
                    <div class="preloader-point-3"></div>
                    <div class="preloader-point-4"></div>
                    <div class="preloader-point-5"></div>
                </div>
            </div>
            <div class="preloader-wrapper ba-spinner-6" data-value="ba-spinner-6">
                <div class="preloader-point-wrapper">
                    <div class="preloader-point-1"></div>
                    <div class="preloader-point-2"></div>
                </div>
            </div>
            <div class="preloader-wrapper ba-spinner-7" data-value="ba-spinner-7">
                <div class="preloader-point-wrapper">
                    <div class="preloader-point-1"></div>
                </div>
            </div>
            <div class="preloader-wrapper ba-spinner-8" data-value="ba-spinner-8">
                <div class="preloader-point-wrapper">
                    <div class="preloader-point-1"></div>
                    <div class="preloader-point-2"></div>
                </div>
            </div>
            <div class="preloader-wrapper ba-spinner-9" data-value="ba-spinner-9">
                <div class="preloader-point-wrapper">
                    <div class="preloader-point-1"></div>
                    <div class="preloader-point-2"></div>
                    <div class="preloader-point-3"></div>
                </div>
            </div>
            <div class="preloader-wrapper ba-spinner-10" data-value="ba-spinner-10">
                <div class="preloader-point-wrapper">
                    <div class="preloader-point-1"></div>
                    <div class="preloader-point-2"></div>
                    <div class="preloader-point-3"></div>
                    <div class="preloader-point-4"></div>
                    <div class="preloader-point-5"></div>
                    <div class="preloader-point-6"></div>
                    <div class="preloader-point-7"></div>
                    <div class="preloader-point-8"></div>
                    <div class="preloader-point-9"></div>
                    <div class="preloader-point-10"></div>
                </div>
            </div>
        </div>
    </div>
</div>
<div id="custom-html-dialog" class="ba-modal-lg modal hide" style="display: none;">
    <div class="modal-header">
        <span class="ba-dialog-title"><?php echo Text::_('CUSTOM_HTML'); ?></span>
        <div class="modal-header-icon">
            <i class="zmdi zmdi-close" data-dismiss="modal"></i>
        </div>
    </div>
    <div class="modal-body">
        <div class="general-tabs">
            <ul class="nav nav-tabs code-nav">
                <li class="active">
                    <a href="#custom-edit-html" data-toggle="tab" class="hide-text-editor-general">
                        <i class="zmdi zmdi-language-html5"></i>
                        html
                    </a>
                </li>
                <li>
                    <a href="#custom-edit-css" data-toggle="tab" class="hide-text-editor-general">
                        <i class="zmdi zmdi-language-css3"></i>
                        css
                    </a>
                </li>
                <li>
                    <a href="#" class="show-text-editor-general">
                        <i class="zmdi zmdi-settings"></i>
                        <?php echo Text::_('GENERAL'); ?>
                    </a>
                </li>
            </ul>
            <div class="tabs-underline"></div>
            <div class="tab-content hide-general-cell">
                <div id="custom-edit-html" class="row-fluid tab-pane active">
                    <textarea id="custom-html-edit-html"></textarea>
                    <span></span>
                </div>
                <div id="custom-edit-css" class="row-fluid tab-pane">
                    <textarea id="custom-html-edit-css"></textarea>
                    <span></span>
                </div>
                <div class="text-editor-general-cell">
<?php
                    echo $this->html->loadPassive('positioning');
                    echo $this->html->load('margin');
                    echo $this->html->loadPassive('disable');
                    echo $this->html->loadPassive('item-animation');
                    echo $this->html->loadPassive('advanced', $this->access);
?>
                </div>
            </div>
        </div>
    </div>
</div>
<div id="add-plugin-dialog" class="ba-modal-lg modal hide" style="display: none;">
    <div class="modal-header">
        <h3 class="ba-modal-title"><?php echo Text::_('PLUGINS'); ?></h3>
        <div class="modal-header-icon">
            <i class="zmdi zmdi-close" data-dismiss="modal"></i>
        </div>
    </div>
    <div class="modal-body">
        <div class="plugin-search-bar">
            <input class="plugin-search">
            <i class="zmdi zmdi-search"></i>
        </div>
        <div class="ba-plugin-list-wrapper">
<?php
foreach ($this->plugins as $key => $value) {
    $name = str_replace('-', '_', $key);
    if ($name == 'blog') {
        $name = 'app';
    }
    $name = strtoupper($name);
?>
        <div class="ba-plugin-group" data-type="<?php echo $key; ?>">
            <p><?php echo Text::_($name); ?></p>
<?php
    foreach ($value as $plugin) {
?>
            <div class="ba-plugin" data-plugin="<?php echo $plugin->title; ?>">
                <i class="<?php echo $plugin->image; ?>"></i>
                <span class="ba-title"><?php echo Text::_($plugin->joomla_constant); ?></span>
            </div>
<?php
    }
?>
        </div>
<?php
}
?>
        </div>
    </div>
</div>
<div id="login-modal" class="ba-modal-sm modal hide gridbox-activate-licanse-modal">
    <div class="modal-body">
        <div class="ba-login-dialog">
            <div class="ba-header-content">
                <h3 class='ba-modal-title'>
                    <?php echo Text::_('ACTIVATE_LICENSE'); ?>
                </h3>
                <label class="ba-help-icon">
                    <i class="zmdi zmdi-help"></i>
                    <span class="ba-tooltip ba-help ba-hide-element">
                        <?php echo Text::_('LOGIN_BALBOOA_TOOLTIP'); ?>
                    </span>
                </label>
            </div>
            <div class="ba-body-content">
                <div class="ba-input-lg">
                    <input class='ba-username reset-input-margin' type='text' name="login"
                        placeholder="<?php echo Text::_('USERNAME'); ?>">
                    <span class="focus-underline"></span>
                </div>
                <div class="ba-input-lg">
                    <input class='ba-password' type='password' name="password"
                        placeholder="<?php echo Text::_('PASSWORD'); ?>">
                    <span class="focus-underline"></span>
                </div>
                <input type="hidden" name="plugin_id" id="plugin-id">
            </div>
            <div class="ba-footer-content">
                <a href="#" class="ba-btn-primary login-button active-button">
                    <?php echo Text::_('ACTIVATE'); ?>
                </a>
            </div>
        </div>
    </div>
</div>
<div id="fonts-editor-dialog" class="ba-modal-lg modal hide" style="display: none;">
    <div class="modal-header">
        <span class="ba-dialog-title"><?php echo Text::_('FONT_LIBRARY'); ?></span>
        <div class="modal-header-icon">
            <i class="zmdi zmdi-close" data-dismiss="modal"></i>
        </div>
    </div>
    <div class="modal-body">
        <iframe src="javascript:''"></iframe>
    </div>
</div>
<div id="icon-upload-dialog" class="ba-modal-lg modal hide" style="display: none;">
    <div class="modal-header">
        <span class="ba-dialog-title"><?php echo Text::_('LIBRARY_ICONS'); ?></span>
        <div class="modal-header-icon">
            <i class="zmdi zmdi-fullscreen media-fullscrean"></i>
            <i class="zmdi zmdi-close" data-dismiss="modal"></i>
        </div>
    </div>
    <div class="modal-body">
        <iframe src="javascript:''"></iframe>
    </div>
</div>
<div id="uploader-modal" class="ba-modal-lg modal ba-modal-dialog hide" style="display:none" data-check="single">
    <div class="modal-body">
        <iframe src="javascript:''" name="uploader-iframe"></iframe>
        <input type="hidden" data-dismiss="modal">
    </div>
</div>
<div id="link-select-modal" class="ba-modal-md modal ba-modal-dialog hide" style="display:none">
    <div class="modal-body">
        <div class="ba-modal-header">
            <h3 class="ba-modal-title"><?php echo Text::_('LINK_PICKER'); ?></h3>
            <i data-dismiss="modal" class="zmdi zmdi-close"></i>
        </div>
        <div class="availible-folders">

        </div>
        <input type="hidden" data-dismiss="modal">
    </div>
    <div class="modal-footer">
        <a href="#" class="ba-btn" data-dismiss="modal"><?php echo Text::_('CANCEL'); ?></a>
        <a href="#" class="ba-btn-primary apply-link disable-button"><?php echo Text::_('SAVE'); ?></a>
    </div>
</div>
<div id="category-list-fields-modal" class="modal hide ba-modal-picker" style="display:none">
    <div class="ba-modal-header">
        <i class="zmdi zmdi-playlist-plus"></i>
    </div>
    <div class="modal-body">
        <div class="category-list-fields-view-wrapper">
            
        </div>
    </div>
</div>
<div id="advanced-shadow-modal" class="modal hide ba-modal-picker" style="display:none">
    <div class="ba-modal-header">
        <i class="zmdi zmdi-tune"></i>
    </div>
    <div class="modal-body">
        <div class="advanced-shadow-settings-wrapper">
            <div class="ba-settings-item">
                <span>
                    <?php echo Text::_('HORIZONTAL_OFFSET'); ?>
                </span>
                <input type="number" data-option="horizontal"
                    data-group="shadow" data-callback="shadowCallback">
                <div class="ba-range-wrapper">
                    <span class="ba-range-liner letter-spacing"></span>
                    <input type="range" class="ba-range" min="-50" max="50">
                </div>
            </div>
            <div class="ba-settings-item">
                <span>
                    <?php echo Text::_('VERTICAL_OFFSET'); ?>
                </span>
                <input type="number" data-option="vertical"
                    data-group="shadow" data-callback="shadowCallback">
                <div class="ba-range-wrapper">
                    <span class="ba-range-liner letter-spacing"></span>
                    <input type="range" class="ba-range" min="-50" max="50">
                </div>
            </div>
            <div class="ba-settings-item">
                <span>
                    <?php echo Text::_('BLUR'); ?>
                </span>
                <input type="number" data-option="blur"
                    data-group="shadow" data-callback="shadowCallback">
                <div class="ba-range-wrapper">
                    <span class="ba-range-liner"></span>
                    <input type="range" class="ba-range" min="0" max="50">
                </div>
            </div>
            <div class="ba-settings-item">
                <span>
                    <?php echo Text::_('SPREAD'); ?>
                </span>
                <input type="number" data-option="spread"
                    data-group="shadow" data-callback="shadowCallback">
                <div class="ba-range-wrapper">
                    <span class="ba-range-liner letter-spacing"></span>
                    <input type="range" class="ba-range" min="-50" max="50">
                </div>
            </div>
        </div>
    </div>
</div>
<div id="menu-select-modal" class="ba-modal-lg modal ba-modal-dialog hide" style="display:none" data-check="single">
    <div class="modal-body">
        <iframe src="javascript:''"></iframe>
        <input type="hidden" data-dismiss="modal">
    </div>
</div>
<div id="pages-list-modal" class="ba-modal-lg modal ba-modal-dialog hide" style="display:none">
    <div class="modal-body">
        <iframe src="javascript:''"></iframe>
        <input type="hidden" data-dismiss="modal">
    </div>
</div>
<div id="association-pages-list-modal" class="ba-modal-lg modal ba-modal-dialog hide" style="display: none;">
    <div class="modal-body">
        <iframe src="javascript:''"></iframe>
    </div>
</div>
<div id="gallery-list-modal" class="ba-modal-lg modal ba-modal-dialog hide" style="display:none">
    <div class="modal-body">
        <iframe src="javascript:''"></iframe>
        <input type="hidden" data-dismiss="modal">
    </div>
</div>
<div id="forms-list-modal" class="ba-modal-lg modal ba-modal-dialog hide" style="display:none">
    <div class="modal-body">
        <iframe src="javascript:''"></iframe>
        <input type="hidden" data-dismiss="modal">
    </div>
</div>
<div id="modules-list-modal" class="ba-modal-lg modal ba-modal-dialog hide" style="display:none">
    <div class="modal-body">
        <iframe src="javascript:''"></iframe>
        <input type="hidden" data-dismiss="modal">
    </div>
</div>
<div id="rename-modal" class="ba-modal-sm modal hide">
    <div class="modal-body">
        <h3 class="ba-modal-title"><?php echo Text::_('RENAME'); ?></h3>
        <input type="text" maxlength="260" class="new-name">
        <span class="focus-underline"></span>
    </div>
    <div class="modal-footer">
        <a href="#" class="ba-btn" data-dismiss="modal">
            <?php echo Text::_('CANCEL') ?>
        </a>
        <a href="#" class="ba-btn-primary disable-button" id="apply-rename">
            <?php echo Text::_('SAVE') ?>
        </a>
    </div>
</div>
<?php
$panel = GridboxHelper::getModalSettings('page-structure-panel');
$structure = json_decode($panel);
$position = '';
$visible = false;
$style = '';
foreach ($structure as $key => $value) {
    if ($key == 'visible') {
        $visible = $value;
    }
    if ($key == 'position') {
        $position = $value;
    }
    if ($key == 'visible' || $key == 'position') {
        continue;
    }
    $style .= $key.': '.$value.'px; ';
}
if (!empty($style)) {
    $style .= 'margin-left: 0;';
}
if ($this->fieldsCount > 0) {
    $visible = false;
}
?>
<div id="page-structure-dialog"
    class="ba-modal-cp draggable-modal-cp modal hide <?php echo $visible ? ' in' : ''; ?>"
    data-position="<?php echo $position; ?>" style="<?php echo $style; ?>">
    <div class="modal-header draggable-handle">
        <span class="ba-dialog-title"><?php echo Text::_('PAGE_STRUCTURE') ?></span>
        <div class="modal-header-icon">
            <div class="ba-custom-select select-page-structure-position">
                <i class="zmdi zmdi-more-vert"></i>
                <input type="hidden">
                <ul>
                    <li data-value=""><?php echo Text::_('SEPARATE_WINDOW') ?></li>
                    <li data-value="left"><?php echo Text::_('PANEL_TO_LEFT') ?></li>
                </ul>
            </div>
            <i class="zmdi zmdi-close" data-dismiss="modal"></i>
        </div>
    </div>
    <div class="modal-body">
        <ul class="ba-page-structure-list">
            <li class="ba-page-structure-root-item" data-structure="header">
                <span>
                    <i class="zmdi zmdi-folder"></i>
                    <span>Header</span>
                </span>
                <i class="zmdi zmdi-caret-right ba-branch-action"></i>
            </li>
            <li class="ba-page-structure-root-item" data-structure="page">
                <span>
                    <i class="zmdi zmdi-folder"></i>
                    <span>Page</span>
                </span>
                <i class="zmdi zmdi-caret-right ba-branch-action"></i>
            </li>
            <li class="ba-page-structure-root-item" data-structure="footer">
                <span>
                    <i class="zmdi zmdi-folder"></i>
                    <span>Footer</span>
                </span>
                <i class="zmdi zmdi-caret-right ba-branch-action"></i>
            </li>
            <li class="ba-page-structure-root-item" data-structure="canvas">
                <span>
                    <i class="zmdi zmdi-folder"></i>
                    <span>Off-Canvas Content</span>
                </span>
                <i class="zmdi zmdi-caret-right ba-branch-action"></i>
            </li>
        </ul>
        <div class="ba-modal-resizer" data-position="left" data-direction="left"></div>
        <div class="ba-modal-resizer" data-position="right" data-direction="right"></div>
    </div>
    <div class="modal-footer">
        <i class="zmdi zmdi-more resize-handle-bottom" data-direction="bottom"></i>
    </div>
</div>
<div class="ba-context-menu section-library-list left-context-menu" style="display: none;">
    <div class="">
        <ul class="nav nav-tabs">
            <li class="active">
                <a href="#section-library-cell" data-toggle="tab">
                    <i class="zmdi zmdi-puzzle-piece"></i>
                    <?php echo Text::_('SECTIONS'); ?>
                </a>
            </li>
            <li>
                <a href="#plugins-library-cell" data-toggle="tab">
                    <i class="zmdi zmdi-label"></i>
                    <?php echo Text::_('PLUGINS'); ?>
                </a>
            </li>
        </ul>
        <div class="tab-content">
            <div id="section-library-cell" class="row-fluid tab-pane active">
                <div class="empty-list">
                    <i class="zmdi zmdi-alert-polygon"></i>
                    <p><?php echo Text::_('NO_ITEMS_HERE'); ?></p>
                </div>
            </div>
            <div id="plugins-library-cell" class="row-fluid tab-pane">
                <div class="empty-list">
                    <i class="zmdi zmdi-alert-polygon"></i>
                    <p><?php echo Text::_('NO_ITEMS_HERE'); ?></p>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="ba-context-menu section-page-blocks-list left-context-menu" style="display: none;">
    <div class="">
        <ul class="nav nav-tabs">
<?php
        $active = 'active';
        foreach ($this->blocks as $key => $block) {
            $name = str_replace('-', '_', $key);
            $name = strtoupper($name);
?>
            <li class="<?php echo $active; ?>">
                <a href="#<?php echo $key; ?>-page-blocks" data-toggle="tab">
                    <i class="<?php echo $this->blocksIcon[$key]; ?>"></i>
                    <?php echo Text::_($name); ?>
                </a>
            </li>
<?php
            $active = '';
        }
?>
        </ul>
        <div class="tab-content">
<?php
        $active = ' active';
        foreach ($this->blocks as $key => $value) {
?>
            <div id="<?php echo $key; ?>-page-blocks" class="row-fluid tab-pane<?php echo $active; ?>">
<?php
            $active = '';
            foreach ($value as $block) {
?>
                <span class="ba-page-block-item <?php echo $block->id == 0 ? 'disabled' : ''; ?>" data-id="<?php echo $block->title; ?>">
                    <img src="<?php echo Uri::root().'components/com_gridbox/assets/images/page-blocks/'.$block->image; ?>">
                </span>
<?php
            }
?>
            </div>
<?php
        }
?>
        </div>
    </div>
</div>
<div class="ba-context-menu page-context-menu" style="display: none;">
<?php
if ($this->edit_type == '' || $this->edit_type == 'system') {
?>
    <span class="ba-page-settings">
        <i class="zmdi zmdi-wrench"></i>
        <span><?php echo Text::_('SETTINGS'); ?></span>
    </span>
<?php
}
if ($this->edit_type == '' && (empty($this->item->app_type) || $this->item->app_type == 'single' || $this->item->app_type == 'blog')) {
?>
    <span class="ba-page-versions">
        <i class="zmdi zmdi-time-restore-setting"></i>
        <span><?php echo Text::_('VERSION_HISTORY'); ?></span>
    </span>
<?php
}
if ($user->authorise('core.manage', 'com_gridbox') && ($this->edit_type != 'system' && $this->edit_type != 'post-layout')) {
?>
    <span class="add-to-menu">
        <i class="zmdi zmdi-star"></i>
        <span><?php echo Text::_('ADD_TO_MENU'); ?></span>
    </span>
<?php
}
if ($user->authorise('core.create', 'com_gridbox') &&
    ($this->edit_type == '' || $this->edit_type == 'post-layout' || $this->edit_type == 'system')) {
?>
    <span>
        <a target="_blank" href="<?php echo $newPage; ?>" class="default-action create-new-page">
            <i class="zmdi zmdi-plus-circle"></i>
            <span><?php echo Text::_('NEW_PAGE'); ?></span>
        </a>
    </span>
<?php
}
if ($user->authorise('core.manage', 'com_gridbox')) {
?>
    <span class="pages-list">
        <i class="zmdi zmdi-file"></i>
        <span><?php echo Text::_('PAGES'); ?></span>
    </span>
<?php
}
?>
</div>
<?php
if (!empty($this->associations) && $this->item->language != '*') {
?>
<div class="ba-context-menu associations-context-menu" style="display: none;">
<?php
    foreach ($this->associations as $key => $association) {
?>
    <span data-link="<?php echo $association->link; ?>">
        <img src="<?php echo $flags.$association->language; ?>.png">
        <span><?php echo $association->title; ?></span>
    </span>
<?php
    }
?>
</div>
<?php
}
?>
<div class="ba-context-menu responsive-context-menu" style="display: none;">
    <span data-width="100%" data-view="desktop">
        <i class="zmdi zmdi-desktop-windows"></i>
        <span><?php echo Text::_('DESKTOP'); ?></span>
    </span>
    <span data-width="<?php echo GridboxHelper::$breakpoints->laptop; ?>px" data-view="laptop">
        <i class="zmdi zmdi-laptop-mac"></i>
        <span><?php echo Text::_('LAPTOP'); ?></span>
    </span>
    <span data-width="<?php echo GridboxHelper::$breakpoints->tablet; ?>px" data-view="tablet">
        <i class="zmdi zmdi-tablet"></i>
        <span><?php echo Text::_('TABLET_LANDSCAPE'); ?></span>
    </span>
    <span data-width="<?php echo GridboxHelper::$breakpoints->{'tablet-portrait'}; ?>px" data-view="tablet-portrait">
        <i class="zmdi zmdi-tablet-mac"></i>
        <span><?php echo Text::_('TABLET_PORTRAIT'); ?></span>
    </span>
    <span data-width="<?php echo GridboxHelper::$breakpoints->phone; ?>px" data-view="phone">
        <i class="zmdi zmdi-smartphone-landscape"></i>
        <span><?php echo Text::_('PHONE_LANDSCAPE'); ?></span>
    </span>
    <span data-width="<?php echo GridboxHelper::$breakpoints->{'phone-portrait'}; ?>px" data-view="phone-portrait">
        <i class="zmdi zmdi-smartphone-android"></i>
        <span><?php echo Text::_('PHONE_PORTRAIT'); ?></span>
    </span>
</div>
<?php
$closeURL = Uri::root().'administrator/index.php?option=com_gridbox&view=';
if ($this->edit_type == 'system') {
    $closeURL .= 'system';
} else if (!empty($this->edit_type)) {
    $closeURL .= 'apps&id='.$this->item->id;
} else {
    $closeURL .= ($this->item->app_type == 'single' ? 'single' : (empty($this->item->app_type) ? 'pages' : 'apps'));
    $closeURL .= !empty($this->item->app_type) ? '&id='.$this->item->app_id : '';
}
?>
<div class="ba-context-menu save-as-context-menu" style="display: none">
    <span data-action="preview">
        <i class="zmdi zmdi-eye"></i>
        <?php echo Text::_('SAVE_AND_PREVIEW'); ?>
    </span>
    <span data-action="close" data-link="<?php echo $closeURL; ?>">
        <i class="zmdi zmdi-close"></i>
        <?php echo Text::_('SAVE_AND_CLOSE'); ?>
    </span>
    <span data-action="new">
        <i class="zmdi zmdi-plus"></i>
        <?php echo Text::_('SAVE_AND_NEW'); ?>
    </span>
<?php
if ($this->edit_type == '') {
?>
    <span data-action="copy">
        <i class="zmdi zmdi-copy"></i>
        <?php echo Text::_('SAVE_AS_COPY'); ?>
    </span>
<?php
}
?>
    
<?php
if ($this->edit_type == '' && (empty($this->item->app_type) || $this->item->app_type == 'single' || $this->item->app_type == 'blog')) {
?>
    <span data-action="version">
        <i class="zmdi zmdi-time-restore-setting"></i>
        <?php echo Text::_('SAVE_VERSION_HISTORY'); ?>
    </span>
<?php    
}
?>
</div>
<div class="ba-context-menu page-structure-context-menu" data-type="section" style="display: none">
    <span data-action="edit">
        <i class="zmdi zmdi-edit"></i>
        <?php echo Text::_('EDIT'); ?>
    </span>
    <span data-action="rename">
        <i class="zmdi zmdi-text-format"></i>
        <?php echo Text::_('RENAME'); ?>
    </span>
    <span data-action="section" class="ba-group-element">
        <i class="zmdi zmdi-plus"></i>
        <?php echo Text::_('ADD_NEW_SECTION'); ?>
    </span>
    <span data-action="row">
        <i class="zmdi zmdi-plus"></i>
        <?php echo Text::_('ADD_NEW_ROW'); ?>
    </span>
    <span data-action="library">
    <i class="zmdi zmdi-globe"></i>
        <?php echo Text::_('ADD_TO_LIBRARY'); ?>
    </span>
    <span data-action="cut" class="ba-group-element">
        <i class="zmdi zmdi-scissors"></i>
        <?php echo Text::_('CUT_ITEM'); ?>
        <span class="context-shortcut-text">CTRL + X</span>
    </span>
    <span data-action="copy">
        <i class="zmdi zmdi-copy"></i>
        <?php echo Text::_('COPY_ITEM'); ?>
        <span class="context-shortcut-text">CTRL + C</span>
    </span>
    <span data-action="content">
        <i class="zmdi zmdi-collection-item"></i>
        <?php echo Text::_('COPY_CONTENT'); ?>
    </span>
    <span data-action="style">
        <i class="zmdi zmdi-roller"></i>
        <?php echo Text::_('COPY_STYLE'); ?>
        <span class="context-shortcut-text">CTRL + SHIFT + C</span>
    </span>
    <span data-action="paste" class="ba-group-element">
        <i class="zmdi zmdi-assignment-o"></i>
        <?php echo Text::_('PASTE'); ?>
        <span class="context-shortcut-text">CTRL + V</span>
    </span>
    <span data-action="reset" class="ba-group-element">
        <i class="zmdi zmdi-replay"></i>
        <?php echo Text::_('RESET_STYLE'); ?>
    </span>
    <span data-action="empty">
        <i class="zmdi zmdi-close"></i>
        <?php echo Text::_('DELETE_CONTENT'); ?>
    </span>
    <span data-action="delete">
        <i class="zmdi zmdi-delete"></i>
        <?php echo Text::_('DELETE_ITEM'); ?>
        <span class="context-shortcut-text">DEL</span>
    </span>
</div>
<div class="ba-context-menu page-structure-context-menu" data-type="row" style="display: none">
    <span data-action="edit">
        <i class="zmdi zmdi-edit"></i>
        <?php echo Text::_('EDIT'); ?>
    </span>
    <span data-action="rename">
        <i class="zmdi zmdi-text-format"></i>
        <?php echo Text::_('RENAME'); ?>
    </span>
    <span data-action="row" class="ba-group-element">
        <i class="zmdi zmdi-plus"></i>
        <?php echo Text::_('ADD_NEW_ROW'); ?>
    </span>
    <span data-action="columns">
        <i class="zmdi zmdi-graphic-eq"></i>
        <?php echo Text::_('MODIFY_COLUMNS'); ?>
    </span>
    <span data-action="cut" class="ba-group-element">
        <i class="zmdi zmdi-scissors"></i>
        <?php echo Text::_('CUT_ITEM'); ?>
        <span class="context-shortcut-text">CTRL + X</span>
    </span>
    <span data-action="copy">
        <i class="zmdi zmdi-copy"></i>
        <?php echo Text::_('COPY_ITEM'); ?>
        <span class="context-shortcut-text">CTRL + C</span>
    </span>
    <span data-action="style">
        <i class="zmdi zmdi-roller"></i>
        <?php echo Text::_('COPY_STYLE'); ?>
        <span class="context-shortcut-text">CTRL + SHIFT + C</span>
    </span>
    <span data-action="paste" class="ba-group-element">
        <i class="zmdi zmdi-assignment-o"></i>
        <?php echo Text::_('PASTE'); ?>
        <span class="context-shortcut-text">CTRL + V</span>
    </span>
    <span data-action="reset" class="ba-group-element">
        <i class="zmdi zmdi-replay"></i>
        <?php echo Text::_('RESET_STYLE'); ?>
    </span>
    <span data-action="delete">
        <i class="zmdi zmdi-delete"></i>
        <?php echo Text::_('DELETE_ITEM'); ?>
        <span class="context-shortcut-text">DEL</span>
    </span>
</div>
<div class="ba-context-menu page-structure-context-menu" data-type="column" style="display: none">
    <span data-action="edit">
        <i class="zmdi zmdi-edit"></i>
        <?php echo Text::_('EDIT'); ?>
    </span>
    <span data-action="rename">
        <i class="zmdi zmdi-text-format"></i>
        <?php echo Text::_('RENAME'); ?>
    </span>
    <span data-action="plugin" class="ba-group-element">
        <i class="zmdi zmdi-plus"></i>
        <?php echo Text::_('ADD_NEW_PLUGIN'); ?>
    </span>
    <span data-action="row">
        <i class="zmdi zmdi-sort-amount-desc"></i>
        <?php echo Text::_('ADD_NESTED_ROW'); ?>
    </span>
    <span data-action="cutContent" class="ba-group-element">
        <i class="zmdi zmdi-scissors"></i>
        <?php echo Text::_('CUT_CONTENT'); ?>
        <span class="context-shortcut-text">CTRL + X</span>
    </span>
    <span data-action="content">
        <i class="zmdi zmdi-collection-item"></i>
        <?php echo Text::_('COPY_CONTENT'); ?>
        <span class="context-shortcut-text">CTRL + C</span>
    </span>
    <span data-action="style">
        <i class="zmdi zmdi-roller"></i>
        <?php echo Text::_('COPY_STYLE'); ?>
        <span class="context-shortcut-text">CTRL + SHIFT + C</span>
    </span>
    <span data-action="paste" class="ba-group-element">
        <i class="zmdi zmdi-assignment-o"></i>
        <?php echo Text::_('PASTE'); ?>
        <span class="context-shortcut-text">CTRL + V</span>
    </span>
    <span data-action="reset" class="ba-group-element">
        <i class="zmdi zmdi-replay"></i>
        <?php echo Text::_('RESET_STYLE'); ?>
    </span>
    <span data-action="empty">
        <i class="zmdi zmdi-close"></i>
        <?php echo Text::_('DELETE_CONTENT'); ?>
        <span class="context-shortcut-text">DEL</span>
    </span>
</div>
<div class="ba-context-menu page-structure-context-menu" data-type="plugin" style="display: none">
    <span data-action="edit">
        <i class="zmdi zmdi-edit"></i>
        <?php echo Text::_('EDIT'); ?>
    </span>
    <span data-action="rename">
        <i class="zmdi zmdi-text-format"></i>
        <?php echo Text::_('RENAME'); ?>
    </span>
    <span data-action="plugin" class="ba-group-element">
        <i class="zmdi zmdi-plus"></i>
        <?php echo Text::_('ADD_NEW_PLUGIN'); ?>
    </span>
    <span data-action="library">
    <i class="zmdi zmdi-globe"></i>
        <?php echo Text::_('ADD_TO_LIBRARY'); ?>
    </span>
    <span data-action="cut" class="ba-group-element">
        <i class="zmdi zmdi-scissors"></i>
        <?php echo Text::_('CUT_ITEM'); ?>
        <span class="context-shortcut-text">CTRL + X</span>
    </span>
    <span data-action="copy">
        <i class="zmdi zmdi-copy"></i>
        <?php echo Text::_('COPY_ITEM'); ?>
        <span class="context-shortcut-text">CTRL + C</span>
    </span>
    <span data-action="style">
        <i class="zmdi zmdi-roller"></i>
        <?php echo Text::_('COPY_STYLE'); ?>
        <span class="context-shortcut-text">CTRL + SHIFT + C</span>
    </span>
    <span data-action="paste" class="ba-group-element">
        <i class="zmdi zmdi-assignment-o"></i>
        <?php echo Text::_('PASTE'); ?>
        <span class="context-shortcut-text">CTRL + V</span>
    </span>
    <span data-action="reset" class="ba-group-element">
        <i class="zmdi zmdi-replay"></i>
        <?php echo Text::_('RESET_STYLE'); ?>
    </span>
    <span data-action="delete">
        <i class="zmdi zmdi-delete"></i>
        <?php echo Text::_('DELETE_ITEM'); ?>
        <span class="context-shortcut-text">DEL</span>
    </span>
</div>
<div class="ba-context-menu section-context-menu" style="display: none">
    <span class="context-edit-item">
        <i class="zmdi zmdi-edit"></i>
        <?php echo Text::_('EDIT'); ?>
    </span>
    <span class="context-in-page-structure">
        <i class="zmdi zmdi-window-restore"></i>
        <?php echo Text::_('IN_PAGE_STRUCTURE'); ?>
    </span>
    <span class="ba-group-element context-add-new-section-after">
        <i class="zmdi zmdi-plus"></i>
        <?php echo Text::_('ADD_NEW_SECTION'); ?>
    </span>
    <span class="context-add-new-row">
        <i class="zmdi zmdi-plus"></i>
        <?php echo Text::_('ADD_NEW_ROW'); ?>
    </span>
    <span class="context-add-to-library">
    <i class="zmdi zmdi-globe"></i>
        <?php echo Text::_('ADD_TO_LIBRARY'); ?>
    </span>
    <span class="ba-group-element context-cut-item">
        <i class="zmdi zmdi-scissors"></i>
        <?php echo Text::_('CUT_ITEM'); ?>
        <span class="context-shortcut-text">CTRL + X</span>
    </span>
    <span class="context-copy-item">
        <i class="zmdi zmdi-copy"></i>
        <?php echo Text::_('COPY_ITEM'); ?>
        <span class="context-shortcut-text">CTRL + C</span>
    </span>
    <span class="context-copy-content">
        <i class="zmdi zmdi-collection-item"></i>
        <?php echo Text::_('COPY_CONTENT'); ?>
    </span>
    <span class="context-copy-style">
        <i class="zmdi zmdi-roller"></i>
        <?php echo Text::_('COPY_STYLE'); ?>
        <span class="context-shortcut-text">CTRL + SHIFT + C</span>
    </span>
    <span class="ba-group-element disable-button context-paste-buffer">
        <i class="zmdi zmdi-assignment-o"></i>
        <?php echo Text::_('PASTE'); ?>
        <span class="context-shortcut-text">CTRL + V</span>
    </span>
    <span class="ba-group-element context-reset-style">
        <i class="zmdi zmdi-replay"></i>
        <?php echo Text::_('RESET_STYLE'); ?>
    </span>
    <span class="context-delete-content">
        <i class="zmdi zmdi-close"></i>
        <?php echo Text::_('DELETE_CONTENT'); ?>
    </span>
    <span class="context-delete-item">
        <i class="zmdi zmdi-delete"></i>
        <?php echo Text::_('DELETE_ITEM'); ?>
        <span class="context-shortcut-text">DEL</span>
    </span>
</div>
<div class="ba-context-menu row-context-menu" style="display: none">
    <span class="context-edit-item">
        <i class="zmdi zmdi-edit"></i>
        <?php echo Text::_('EDIT'); ?>
    </span>
    <span class="context-in-page-structure">
        <i class="zmdi zmdi-window-restore"></i>
        <?php echo Text::_('IN_PAGE_STRUCTURE'); ?>
    </span>
    <span class="ba-group-element context-add-new-row-after">
        <i class="zmdi zmdi-plus"></i>
        <?php echo Text::_('ADD_NEW_ROW'); ?>
    </span>
    <span class="context-modify-columns">
        <i class="zmdi zmdi-graphic-eq"></i>
        <?php echo Text::_('MODIFY_COLUMNS'); ?>
    </span>
    <span class="ba-group-element context-cut-item">
        <i class="zmdi zmdi-scissors"></i>
        <?php echo Text::_('CUT_ITEM'); ?>
        <span class="context-shortcut-text">CTRL + X</span>
    </span>
    <span class="context-copy-item">
        <i class="zmdi zmdi-copy"></i>
        <?php echo Text::_('COPY_ITEM'); ?>
        <span class="context-shortcut-text">CTRL + C</span>
    </span>
    <span class="context-copy-style">
        <i class="zmdi zmdi-roller"></i>
        <?php echo Text::_('COPY_STYLE'); ?>
        <span class="context-shortcut-text">CTRL + SHIFT + C</span>
    </span>
    <span class="ba-group-element disable-button context-paste-buffer">
        <i class="zmdi zmdi-assignment-o"></i>
        <?php echo Text::_('PASTE'); ?>
        <span class="context-shortcut-text">CTRL + V</span>
    </span>
    <span class="ba-group-element context-reset-style">
        <i class="zmdi zmdi-replay"></i>
        <?php echo Text::_('RESET_STYLE'); ?>
    </span>
    <span class="context-delete-item">
        <i class="zmdi zmdi-delete"></i>
        <?php echo Text::_('DELETE_ITEM'); ?>
        <span class="context-shortcut-text">DEL</span>
    </span>
</div>
<div class="ba-context-menu column-context-menu" style="display: none">
    <span class="context-edit-item">
        <i class="zmdi zmdi-edit"></i>
        <?php echo Text::_('EDIT'); ?>
    </span>
    <span class="context-in-page-structure">
        <i class="zmdi zmdi-window-restore"></i>
        <?php echo Text::_('IN_PAGE_STRUCTURE'); ?>
    </span>
    <span class="ba-group-element context-add-new-element">
        <i class="zmdi zmdi-plus"></i>
        <?php echo Text::_('ADD_NEW_PLUGIN'); ?>
    </span>
    <span class="context-add-nested-row">
        <i class="zmdi zmdi-sort-amount-desc"></i>
        <?php echo Text::_('ADD_NESTED_ROW'); ?>
    </span>
    <span class="ba-group-element context-cut-content">
        <i class="zmdi zmdi-scissors"></i>
        <?php echo Text::_('CUT_CONTENT'); ?>
        <span class="context-shortcut-text">CTRL + X</span>
    </span>
    <span class="context-copy-content">
        <i class="zmdi zmdi-collection-item"></i>
        <?php echo Text::_('COPY_CONTENT'); ?>
        <span class="context-shortcut-text">CTRL + C</span>
    </span>
    <span class="context-copy-style">
        <i class="zmdi zmdi-roller"></i>
        <?php echo Text::_('COPY_STYLE'); ?>
        <span class="context-shortcut-text">CTRL + SHIFT + C</span>
    </span>
    <span class="ba-group-element disable-button context-paste-buffer">
        <i class="zmdi zmdi-assignment-o"></i>
        <?php echo Text::_('PASTE'); ?>
        <span class="context-shortcut-text">CTRL + V</span>
    </span>
    <span class="ba-group-element context-reset-style">
        <i class="zmdi zmdi-replay"></i>
        <?php echo Text::_('RESET_STYLE'); ?>
    </span>
    <span class="context-delete-content">
        <i class="zmdi zmdi-close"></i>
        <?php echo Text::_('DELETE_CONTENT'); ?>
        <span class="context-shortcut-text">DEL</span>
    </span>
</div>
<div class="ba-context-menu plugin-context-menu" style="display: none">
    <span class="context-edit-item">
        <i class="zmdi zmdi-edit"></i>
        <?php echo Text::_('EDIT'); ?>
    </span>
    <span class="context-in-page-structure">
        <i class="zmdi zmdi-window-restore"></i>
        <?php echo Text::_('IN_PAGE_STRUCTURE'); ?>
    </span>
    <span class="ba-group-element context-add-new-element-after">
        <i class="zmdi zmdi-plus"></i>
        <?php echo Text::_('ADD_NEW_PLUGIN'); ?>
    </span>
    <span class="context-add-to-library">
    <i class="zmdi zmdi-globe"></i>
        <?php echo Text::_('ADD_TO_LIBRARY'); ?>
    </span>
    <span class="ba-group-element context-cut-item">
        <i class="zmdi zmdi-scissors"></i>
        <?php echo Text::_('CUT_ITEM'); ?>
        <span class="context-shortcut-text">CTRL + X</span>
    </span>
    <span class="context-copy-item">
        <i class="zmdi zmdi-copy"></i>
        <?php echo Text::_('COPY_ITEM'); ?>
        <span class="context-shortcut-text">CTRL + C</span>
    </span>
    <span class="context-copy-style">
        <i class="zmdi zmdi-roller"></i>
        <?php echo Text::_('COPY_STYLE'); ?>
        <span class="context-shortcut-text">CTRL + SHIFT + C</span>
    </span>
    <span class="ba-group-element disable-button context-paste-buffer">
        <i class="zmdi zmdi-assignment-o"></i>
        <?php echo Text::_('PASTE'); ?>
        <span class="context-shortcut-text">CTRL + V</span>
    </span>
    <span class="ba-group-element context-reset-style">
        <i class="zmdi zmdi-replay"></i>
        <?php echo Text::_('RESET_STYLE'); ?>
    </span>
    <span class="context-delete-item">
        <i class="zmdi zmdi-delete"></i>
        <?php echo Text::_('DELETE_ITEM'); ?>
        <span class="context-shortcut-text">DEL</span>
    </span>
</div>
<div class="draggable-backdrop"></div>
<?php
if ($this->edit_type == '' && $this->item->app_type != 'single' && $this->item->app_type != 'blog' && $this->item->app_type != '') {
    $jceIndex = 1;
?>
<div id="product-options-dialog" class="modal hide ba-modal-product-picker picker-modal-arrow ba-modal-list-picker"
    style="display: none;" data-position="right">
    <div class="modal-body modal-list-type-wrapper">
        <div class="ba-settings-item ba-settings-input-type">
            <input type="text" placeholder="<?php echo Text::_('SEARCH'); ?>" class="picker-search">
            <i class="zmdi zmdi-search"></i>
        </div>
        <div class="ba-settings-item ba-settings-list-type">
            <ul></ul>
        </div>
    </div>
</div>
<div id="related-product-dialog" class="modal hide ba-modal-product-picker picker-modal-arrow ba-modal-list-picker"
    style="display: none;" data-position="right">
    <div class="modal-body modal-list-type-wrapper">
        <div class="ba-settings-item ba-settings-input-type">
            <input type="text" placeholder="<?php echo Text::_('SEARCH'); ?>" class="picker-search">
            <i class="zmdi zmdi-search"></i>
        </div>
        <div class="ba-settings-item ba-settings-list-type">
            <ul></ul>
        </div>
    </div>
</div>
<div id="subscription-product-dialog" class="modal hide ba-modal-product-picker picker-modal-arrow ba-modal-list-picker"
    style="display: none;" data-position="right">
    <div class="modal-body modal-list-type-wrapper">
        <div class="ba-settings-item ba-settings-input-type">
            <input type="text" placeholder="<?php echo Text::_('SEARCH'); ?>" class="picker-search">
            <i class="zmdi zmdi-search"></i>
        </div>
        <div class="ba-settings-item ba-settings-list-type">
            <ul></ul>
        </div>
    </div>
</div>
<div id="subscription-upgrade-plans-dialog"
    class="modal hide ba-modal-product-picker picker-modal-arrow ba-modal-list-picker"
    style="display: none;" data-position="right">
    <div class="modal-body modal-list-type-wrapper">
        <div class="ba-settings-item ba-settings-input-type">
            <input type="text" placeholder="<?php echo Text::_('SEARCH'); ?>" class="picker-search">
            <i class="zmdi zmdi-search"></i>
        </div>
        <div class="ba-settings-item ba-settings-list-type">
            <ul></ul>
        </div>
    </div>
</div>
<div id="subscription-usergroups-dialog" class="modal hide ba-modal-product-picker picker-modal-arrow ba-modal-list-picker"
    style="display: none;" data-position="right">
    <div class="modal-body modal-list-type-wrapper">
        <div class="ba-settings-item ba-settings-input-type">
            <input type="text" placeholder="<?php echo Text::_('SEARCH'); ?>" class="picker-search">
            <i class="zmdi zmdi-search"></i>
        </div>
        <div class="ba-settings-item ba-settings-list-type">
            <ul></ul>
        </div>
    </div>
</div>
<div id="product-options-values-dialog" class="modal hide ba-modal-product-picker picker-modal-arrow ba-modal-list-picker"
    style="display: none;">
    <div class="modal-body modal-list-type-wrapper">
        <div class="ba-settings-item ba-settings-input-type">
            <input type="text" placeholder="<?php echo Text::_('SEARCH'); ?>" class="picker-search">
            <i class="zmdi zmdi-search"></i>
        </div>
        <div class="ba-settings-item ba-settings-list-type">
            <ul></ul>
        </div>
    </div>
</div>
<div id="product-variations-photos-dialog" class="modal hide ba-modal-product-picker picker-modal-arrow ba-modal-list-picker"
    style="display: none;" data-position="right">
    <div class="modal-body modal-list-type-wrapper">
        <div class="ba-options-group-toolbar">
            <div>
                <label data-action="add">
                    <i class="zmdi zmdi-plus"></i>
                    <span class="ba-tooltip ba-top ba-hide-element"><?php echo Text::_('ADD_NEW_ITEM'); ?></span>
                </label>
                <label data-action="delete" class="disabled">
                    <i class="zmdi zmdi-delete"></i>
                    <span class="ba-tooltip ba-top ba-hide-element"><?php echo Text::_('DELETE'); ?></span>
                </label>
            </div>
        </div>
        <div class="sorting-container"></div>
    </div>
</div>
<div class="gridbox-apps-editor-wrapper">
    <script>
        document.body.classList.add('advanced-apps-editor');
    </script>
<?php
if ($this->fieldsCount > 0 || !$this->postContent) {
?>
    <script>
        document.body.classList.add('enabled-fields-tab');
        document.addEventListener('DOMContentLoaded', function(){
            $g('.gridbox-apps-editor-wrapper').on('shown', function(){
                if ($g(this).find('> .tab-content > .active').attr('id') == 'gridbox-editor-tab') {
                    document.body.classList.remove('enabled-fields-tab');
                } else {
                    document.body.classList.add('enabled-fields-tab');
                }
                if (app.pageStructure && app.pageStructure.visible) {
                    app.pageStructure.modal.modal('hide');
                }
            })
        });
    </script>
<?php
}
if ($this->postContent && $this->fieldsCount > 0) {
?>
    <script>
        document.addEventListener('DOMContentLoaded', function(){
            $g('.gridbox-apps-editor-wrapper > ul a').off('show').on('show', function(event){
                var parent = $g(this).closest('.gridbox-apps-editor-wrapper'),
                    prev = event.relatedTarget.getBoundingClientRect(),
                    next = event.target.getBoundingClientRect();
                parent.find('.tabs-underline').stop().css({
                    'left' : prev.left,
                    'right' : document.documentElement.clientWidth - prev.right,
                }).show().animate({
                    'left' : next.left,
                    'right' : document.documentElement.clientWidth - next.right,
                }, 500, function(){
                    parent.find('.tabs-underline').hide();
                });
            });
        });
    </script>
    <ul class="nav nav-tabs uploader-nav">
        <li class="active">
            <a href="#blog-post-editor-fields-options" data-toggle="tab">
                <i class="zmdi zmdi-keyboard-hide"></i>
                <span class="ba-tooltip ba-bottom"><?php echo Text::_('ITEM_SUBMISSION'); ?></span>
            </a>
        </li>
        <li>
            <a href="#gridbox-editor-tab" data-toggle="tab">
                <i class="zmdi zmdi-file-plus"></i>
                <span class="ba-tooltip ba-bottom"><?php echo Text::_('ADVANCED_EDITOR'); ?></span>
            </a>
        </li>
    </ul>
    <div class="tabs-underline"></div>
<?php
} else {
?>
    <script>
        document.body.classList.add('disabled-fields-tabs-header');
    </script>
<?php
}
?>
    <div class="tab-content">
        <div class="tab-pane<?php echo $this->fieldsCount > 0 ? ' active' : ''; ?>" id="blog-post-editor-fields-options">
            <div>
<?php
            if ($user->authorise('core.tools', 'com_gridbox')) {
?>
                <label class="gridbox-toggle-element">
                    <input type="checkbox" class="apps-fields-editor-toggle">
                    <span></span>
                    <span class="ba-tooltip ba-bottom"><?php echo Text::_('GROUP_FIELDS'); ?></span>
                </label>
<?php
            }
?>
            </div>
<?php
        if ($user->authorise('core.tools', 'com_gridbox')) {
?>
            <script>
                if (localStorage.getItem('enable-field-editor') == 'true') {
                    document.body.classList.add('enable-field-editor');
                    document.querySelector('input.apps-fields-editor-toggle').checked = true;
                }
            </script>
<?php
        }
            $fieldsHelper = new FieldsHelper($this->jce, $this->form, $this->pageTags, $this->tags, $this->item->app_type);
            $fieldsGroups = $fieldsHelper->getGroupsHTML($this->fields, $this->fieldsGroups, $this->fields_data, $this->productData);

?>
            <div class="ba-app-fields-groups-wrapper">
<?php
                echo $fieldsGroups;
?>
            </div>
            <div class="add-fields-group-wrapper">
                <span>
                    <i class="zmdi zmdi-plus-circle add-fields-group"></i>
                    <span class="ba-tooltip"><?php echo Text::_('NEW_GROUP'); ?></span>
                </span>
            </div>
        </div>
        <div class="tab-pane<?php echo ($this->fieldsCount == 0 && $this->postContent) ? ' active' : ''; ?>" id="gridbox-editor-tab">
<?php
}
?>
<iframe class="editor-iframe" style="width: 100%;" src="<?php echo $url; ?>" name="editor-iframe"></iframe>
<?php
if ($this->edit_type == '' && $this->item->app_type != 'single' && $this->item->app_type != 'blog' && $this->item->app_type != '') {
?>
        </div>
    </div>
</div>
<div id="apps-fields-group-dialog" class="ba-modal-sm modal hide">
    <div class="modal-body">
        <h3 class="ba-modal-title">
            <?php echo Text::_('NEW_GROUP') ?>
        </h3>
        <div class="ba-input-lg">
            <input type="text" class="apps-fields-group-title" placeholder="<?php echo Text::_('GROUP_TITLE'); ?>">
            <span class="focus-underline"></span>
        </div>
    </div>
    <div class="modal-footer">
        <a href="#" class="ba-btn" data-dismiss="modal">
            <?php echo Text::_('CANCEL'); ?>
        </a>
        <a href="#" class="ba-btn-primary disable-button" id="apply-apps-fields-group">
            <?php echo Text::_('SAVE'); ?>
        </a>
    </div>
</div>
<?php
}
?>
<div class="ba-context-menu save-image-context-menu" style="display: none;">
    <span class="photo-editor-save-copy">
        <span><?php echo Text::_('SAVE_COPY'); ?></span>
    </span>
    <span class="save-photo-editor-image">
        <span><?php echo Text::_('SAVE'); ?></span>
    </span>
</div>
<div class="ba-context-menu tools-context-menu" style="display: none;">
    <span class="show-media-manager">
        <i class="zmdi zmdi-wallpaper"></i>
        <span><?php echo Text::_('MEDIA_MANAGER'); ?></span>
    </span>
<?php
if (isset(GridboxHelper::$systemApps->{'photo-editor'})) {
?>
    <span class="open-photo-editor">
        <i class="zmdi zmdi-camera-alt"></i>
        <span><?php echo Text::_('PHOTO_EDITOR'); ?></span>
    </span>
<?php
}
?>
    <span class="show-font-library">
        <i class="zmdi zmdi-brightness-auto"></i>
        <span><?php echo Text::_('FONT_LIBRARY'); ?></span>
    </span>
<?php
if (isset(GridboxHelper::$systemApps->{'code-editor'})) {
?>
    <span class="ba-code-editor">
        <i class="zmdi zmdi-code-setting"></i>
        <span><?php echo Text::_('CODE_EDITOR'); ?></span>
    </span>
<?php
}
?>
</div>
<div class="preloader ba-preloader-slide">
    <div class="preloader-left-section"></div>
</div>
<div id="version-history-dialog" class="ba-modal-cp draggable-modal-cp modal hide">
    <div class="modal-header">
        <span class="ba-dialog-title"><?php echo Text::_('VERSION_HISTORY'); ?></span>
        <div class="modal-header-icon">
            <div class="ba-custom-select select-modal-cp-position">
                <i class="zmdi zmdi-more-vert"></i>
                <input type="hidden">
                <ul>
                    <li data-value=""><?php echo Text::_('SEPARATE_WINDOW') ?></li>
                    <li data-value="right"><?php echo Text::_('PANEL_TO_RIGHT') ?></li>
                </ul>
            </div>
            <i class="zmdi zmdi-close close-cp-modal"></i>
        </div>
    </div>
    <div class="modal-body">
        <div class="general-tabs">
            <ul class="nav nav-tabs">
                <li class="active">
                    <a href="#versions-history-tab" data-toggle="tab">
                        <i class="zmdi zmdi-time-restore-setting"></i>
                        <span><?php echo Text::_('VERSIONS'); ?></span>
                    </a>
                </li>
                <li class="">
                    <a href="#versions-global-settings-tab" data-toggle="tab">
                        <i class="zmdi zmdi-settings"></i>
                        <span><?php echo Text::_('GLOBAL_SETTINGS'); ?></span>
                    </a>
                </li>
            </ul>
            <div class="tabs-underline"></div>
            <div class="tab-content">
                <div id="versions-history-tab" class="row-fluid tab-pane active">
                    <div class="versions-history-wrapper">
                        
                    </div>
                    <template class="version-history-item">
                        <div class="version-history-item">
                            <span class="version-history-item-title">
                                <i class="zmdi zmdi-time-interval"></i>
                                <span>title</span>
                            </span>
                            <span class="version-history-item-icons">
                                <span class="edit-version-history">
                                    <i class="zmdi zmdi-edit"></i>
                                    <span class="ba-tooltip ba-bottom"><?php echo Text::_('EDIT'); ?></span>
                                </span>
                                <span class="delete-version-history">
                                    <i class="zmdi zmdi-delete"></i>
                                    <span class="ba-tooltip ba-bottom"><?php echo Text::_('DELETE'); ?></span>
                                </span>
                            </span>
                        </div>
                    </template>
                </div>
                <div id="versions-global-settings-tab" class="row-fluid tab-pane">
                    <div class="ba-settings-group">
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('AUTO_SAVE'); ?></span>
                            <label class="ba-checkbox">
                                <input type="checkbox" class="versions-auto-save set-group-display"
                                    <?php echo $this->website->versions_auto_save == 1 ? 'checked' : ''; ?>>
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-subgroup-element">
                            <div class="ba-settings-item">
                                <span><?php echo Text::_('MAX_VERSIONS'); ?></span>
                                <input type="number" class="max-versions" value="<?php echo $this->website->max_versions; ?>">
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('CLEANUP'); ?></span>
                            <span class="cleanup-versions-history"><?php echo Text::_('DELETE'); ?></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="alert-backdrop"></div>
<div id="section-settings-dialog" class="ba-modal-cp draggable-modal-cp modal hide">
    <div class="modal-header">
        <span class="ba-dialog-title"></span>
        <div class="modal-header-icon">
            <div class="ba-custom-select select-modal-cp-position">
                <i class="zmdi zmdi-more-vert"></i>
                <input type="hidden">
                <ul>
                    <li data-value=""><?php echo Text::_('SEPARATE_WINDOW') ?></li>
                    <li data-value="right"><?php echo Text::_('PANEL_TO_RIGHT') ?></li>
                </ul>
            </div>
            <i class="zmdi zmdi-close close-cp-modal"></i>
        </div>
    </div>
    <div class="modal-body">
        <div class="general-tabs">
            <ul class="nav nav-tabs">
                <li class="active">
                    <a href="#section-general-options" data-toggle="tab">
                        <i class="zmdi zmdi-settings"></i>
                        <span><?php echo Text::_('GENERAL'); ?></span>
                    </a>
                </li>
                <li>
                    <a href="#section-background-options" data-toggle="tab">
                        <i class="zmdi zmdi-wallpaper"></i>
                        <span><?php echo Text::_('BACKGROUND'); ?></span>
                    </a>
                </li>
                <li>
                    <a href="#section-layout-options" data-toggle="tab">
                        <i class="zmdi zmdi-fullscreen"></i>
                        <span><?php echo Text::_('LAYOUT'); ?></span>
                    </a>
                </li>
            </ul>
            <div class="tabs-underline"></div>
            <div class="tab-content">
                <div id="section-general-options" class="row-fluid tab-pane active">
                    <div class="ba-settings-group sticky-header-options">
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('OFFSET') ?></span>
                            <input type="number" class="set-value-css" data-option="offset">
                        </div>
                        <div class="ba-settings-item desktop-only">
                            <span>
                                <?php echo Text::_('SHOW_ON_SCROLL_UP'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" class="set-value-css" data-option="scrollup">
                                <span></span>
                            </label>
                        </div>
                    </div>
                    <div class="ba-settings-group cookies-options">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('LAYOUT'); ?>
                            </span>
                            <div class="ba-custom-select cookies-layout-select">
                                <input readonly onfocus="this.blur()" value="" type="text">
                                <input type="hidden" value="">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="notification-bar"><?php echo Text::_('NOTIFICATION_BAR'); ?></li>
                                    <li data-value="lightbox"><?php echo Text::_('LIGHTBOX'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('POSITION'); ?>
                            </span>
                            <div class="ba-custom-select cookies-position-select">
                                <input readonly onfocus="this.blur()" value="" type="text">
                                <input type="hidden" value="">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="notification-bar-top"><?php echo Text::_('TOP'); ?></li>
                                    <li data-value="notification-bar-bottom"><?php echo Text::_('BOTTOM'); ?></li>
                                    <li data-value="lightbox-top-left"><?php echo Text::_('TOP_LEFT'); ?></li>
                                    <li data-value="lightbox-top-right"><?php echo Text::_('TOP_RIGHT'); ?></li>
                                    <li data-value="lightbox-bottom-left"><?php echo Text::_('BOTTOM_LEFT'); ?></li>
                                    <li data-value="lightbox-bottom-right"><?php echo Text::_('BOTTOM_RIGHT'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item width-options">
                            <span><?php echo Text::_('WIDTH'); ?></span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="1170">
                                <input type="text" data-option="width" data-group="view" data-callback="sectionRules">
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group header-options">
                        <div class="ba-settings-item desktop-only">
                            <span>
                                <?php echo Text::_('LAYOUT'); ?>
                            </span>
                            <div class="ba-custom-select header-layout-select">
                                <input readonly onfocus="this.blur()" value="" type="text">
                                <input type="hidden" value="">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value=""><?php echo Text::_('CLASSIC'); ?></li>
                                    <li data-value="sidebar-menu"><?php echo Text::_('SIDE_NAVIGATION'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item header-position">
                            <span>
                                <?php echo Text::_('POSITION'); ?>
                            </span>
                            <div class="ba-custom-select header-position-select">
                                <input readonly onfocus="this.blur()" value="" type="text">
                                <input type="hidden" value="">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="relative"><?php echo Text::_('DEFAULT'); ?></li>
                                    <li data-value="absolute"><?php echo Text::_('ABSOLUTE'); ?></li>
                                    <li data-value="fixed"><?php echo Text::_('FIXED'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item header-sidebar-width">
                            <span>
                                <?php echo Text::_('WIDTH'); ?>
                            </span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="2500">
                                <input type="text" data-option="width" data-callback="sectionRules">
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group full-group">
                        <div class="ba-settings-item desktop-only">
                            <span>
                                <?php echo Text::_('POSITION'); ?>
                            </span>
                            <div class="ba-custom-select megamenu-position-select">
                                <input readonly onfocus="this.blur()" value="" type="text">
                                <input type="hidden" value="">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value=""><?php echo Text::_('DEFAULT'); ?></li>
                                    <li data-value="megamenu-center"><?php echo Text::_('CENTER'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item full-width">
                            <span>
                                <?php echo Text::_('FULL_WIDTH'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-option="max-width">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('FULLSCREEN'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-option="fullscreen">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item desktop-only megamenu-width">
                            <span>
                                <?php echo Text::_('WIDTH'); ?>
                            </span>
                            <div class="ba-range-wrapper image-width">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="1170">
                                <input type="text" data-option="width" data-group="view" data-callback="sectionRules">
                            </div>
                        </div>
                        <div class="ba-settings-item sticky-column-option enable-sticky">
                            <span>
                                <?php echo Text::_('STICKY'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item sticky-column-option sticky-offset">
                            <span>
                                <?php echo Text::_('OFFSET'); ?>
                            </span>
                            <div class="ba-range-wrapper image-width">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="500">
                                <input type="text" data-option="offset" data-group="sticky" data-callback="sectionRules">
                            </div>
                        </div>
                        <div class="ba-settings-item column-content-direction">
                            <span>
                                <?php echo Text::_('DIRECTION'); ?>
                            </span>
                            <div class="ba-custom-select column-direction-select">
                                <input readonly onfocus="this.blur()" type="text">
                                <input type="hidden">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value=""><?php echo Text::_('VERTICAL'); ?></li>
                                    <li data-value="column-horizontal-direction"><?php echo Text::_('HORIZONTAL'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item column-content-align">
                            <span>
                                <?php echo Text::_('CONTENT_ALIGN'); ?>
                            </span>
                            <div class="ba-settings-toolbar">
                                <label data-option="horizontal_align" data-value="column-horizontal-align-left">
                                    <i class="zmdi zmdi-border-left"></i>
                                    <span class="ba-tooltip"><?php echo Text::_('LEFT'); ?></span>
                                </label>
                                <label data-option="horizontal_align" data-value="column-horizontal-align-center">
                                    <i class="zmdi zmdi-border-vertical"></i>
                                    <span class="ba-tooltip"><?php echo Text::_('CENTER'); ?></span>
                                </label>
                                <label data-option="horizontal_align" data-value="column-horizontal-align-right">
                                    <i class="zmdi zmdi-border-right"></i>
                                    <span class="ba-tooltip"><?php echo Text::_('RIGHT'); ?></span>
                                </label>
                                <label data-option="content_align" data-value="column-content-align-top">
                                    <i class="zmdi zmdi-border-top"></i>
                                    <span class="ba-tooltip"><?php echo Text::_('TOP'); ?></span>
                                </label>
                                <label data-option="content_align" data-value="column-content-align-middle">
                                    <i class="zmdi zmdi-border-horizontal"></i>
                                    <span class="ba-tooltip"><?php echo Text::_('MIDDLE'); ?></span>
                                </label>
                                <label data-option="content_align" data-value="column-content-align-bottom">
                                    <i class="zmdi zmdi-border-bottom"></i>
                                    <span class="ba-tooltip"><?php echo Text::_('BOTTOM'); ?></span>
                                </label>
                            </div>
                        </div>
                        <div class="ba-settings-item flipbox-options">
                            <span><?php echo Text::_('HEIGHT'); ?></span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="1500">
                                <input type="text" data-option="height" data-group="view" data-callback="sectionRules">
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group typography-group">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-format-size"></i>
                            <span><?php echo Text::_('TYPOGRAPHY'); ?></span>
                        </div>
                        <div class="ba-settings-item ba-typography-select-wrapper">
                            <span>
                                <?php echo Text::_('TYPOGRAPHY'); ?>
                            </span>
                            <div class="ba-custom-select typography-select">
                                <input readonly onfocus="this.blur()" value="<?php echo Text::_('BASE_FONT'); ?>" type="text">
                                <input type="hidden" value="body">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="body"><?php echo Text::_('BASE_FONT'); ?></li>
                                    <li data-value="h1">H1</li>
                                    <li data-value="h2">H2</li>
                                    <li data-value="h3">H3</li>
                                    <li data-value="h4">H4</li>
                                    <li data-value="h5">H5</li>
                                    <li data-value="h6">H6</li>
                                    <li data-value="p">Paragraph</li>
                                    <li data-value="links"><?php echo Text::_('LINKS') ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="theme-typography-options">
                            <div class="typography-options">
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('FONT_FAMILY'); ?>
                                    </span>
                                    <input type="text" readonly onfocus="this.blur()" data-option="font-family"
                                        data-group="h1" data-callback="sectionRules">
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('FONT_WEIGHT'); ?>
                                    </span>
                                    <input readonly onfocus="this.blur()" type="text" data-option="font-weight"
                                        data-group="h1" data-callback="sectionRules">
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('COLOR'); ?>
                                    </span>
                                    <input type="text" data-type="color" data-option="color" data-group="h1">
                                    <span class="minicolors-opacity-wrapper">
                                        <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                        min="0" max="1" step="0.01">
                                        <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                                    </span>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('SIZE'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner"></span>
                                        <input type="range" class="ba-range" min="0" max="320">
                                        <input type="text" data-option="font-size" data-group="h1" data-callback="sectionRules">
                                    </div>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('LETTER_SPACING'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner letter-spacing"></span>
                                        <input type="range" class="ba-range" min="-10" max="10">
                                        <input type="text" data-option="letter-spacing" data-group="h1" data-callback="sectionRules">
                                    </div>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('LINE_HEIGHT'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner"></span>
                                        <input type="range" class="ba-range" min="0" max="640">
                                        <input type="text" data-option="line-height" data-group="h1" data-callback="sectionRules">
                                    </div>
                                </div>
                                <div class="ba-settings-toolbar">
                                    <label data-option="text-decoration" data-value="underline" data-group="h1"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-underlined"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('UNDERLINE'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-transform" data-value="uppercase" data-group="h1" data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-size"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('UPPERCASE'); ?>
                                        </span>
                                    </label>
                                    <label data-option="font-style" data-value="italic" data-group="h1" data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-italic"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('ITALIC'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-align" data-value="left" data-group="h1" data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-align-left"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('LEFT'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-align" data-value="center" data-group="h1" data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-align-center"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('CENTER'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-align" data-value="right" data-group="h1" data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-align-right"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('RIGHT'); ?>
                                        </span>
                                    </label>
                                </div>
                                <div class="ba-settings-item links" style="display: none;">
                                    <span>
                                        <?php echo Text::_('COLOR'); ?>
                                    </span>
                                    <input type="text" data-type="color" data-option="color" data-group="links">
                                    <span class="minicolors-opacity-wrapper">
                                        <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                        min="0" max="1" step="0.01">
                                        <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                                    </span>
                                </div>
                                <div class="ba-settings-item links" style="display: none;">
                                    <span>
                                        <?php echo Text::_('HOVER'); ?>
                                    </span>
                                    <input type="text" data-type="color" data-option="hover-color" data-group="links">
                                    <span class="minicolors-opacity-wrapper">
                                        <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                        min="0" max="1" step="0.01">
                                        <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group ba-column-options">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-link"></i>
                            <span><?php echo Text::_('LINK'); ?></span>
                        </div>
                        <div class="ba-settings-item link-picker-container">
                            <span>
                                <?php echo Text::_('LINK'); ?>
                            </span>
                            <input type="text" data-option="link" data-group="link" placeholder="<?php echo Text::_('LINK'); ?>">
                            <div class="select-link">
                                <i class="zmdi zmdi-attachment-alt"></i>
                                <span class="ba-tooltip"><?php echo Text::_('LINK_PICKER') ?></span>
                            </div>
                            <div class="select-file">
                                <i class="zmdi zmdi-file"></i>
                                <span class="ba-tooltip"><?php echo Text::_('FILE_PICKER') ?></span>
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('ARIA_LABEL') ?></span>
                            <input type="text" class="aria-label"
                                   placeholder="<?php echo Text::_('ARIA_LABEL') ?>">
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('TARGET'); ?>
                            </span>
                            <div class="ba-custom-select link-target-select">
                                <input readonly onfocus="this.blur()" value="" type="text">
                                <input type="hidden" value="" data-option="target" data-group="link">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="_blank"><?php echo Text::_('NEW_WINDOW'); ?></li>
                                    <li data-value="_self"><?php echo Text::_('SAME_WINDOW'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('TYPE'); ?>
                            </span>
                            <div class="ba-custom-select link-type-select">
                                <input readonly onfocus="this.blur()" value="" type="text">
                                <input type="hidden" value="" data-option="type" data-group="link">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value=""><?php echo Text::_('DEFAULT'); ?></li>
                                    <li data-value="download"><?php echo Text::_('DOWNLOAD'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('EMBED_CODE'); ?>
                            </span>
                            <input type="text" class="button-embed-code" placeholder="<?php echo Text::_('EMBED_CODE'); ?>">
                        </div>
                    </div>
                    <div class="ba-settings-group">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-skip-next"></i>
                            <span><?php echo Text::_('ANIMATION'); ?></span>
                        </div>
                        <div class="ba-settings-item flipbox-options">
                            <span>
                                <?php echo Text::_('EFFECT'); ?>
                            </span>
                            <div class="ba-custom-select flipbox-effect-select">
                                <input readonly onfocus="this.blur()" type="text">
                                <input type="hidden">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="vertical-flip-top"><?php echo Text::_('FLIP_TOP'); ?></li>
                                    <li data-value="horizontal-flip-right"><?php echo Text::_('FLIP_RIGHT'); ?></li>
                                    <li data-value="vertical-flip-bottom"><?php echo Text::_('FLIP_BOTTOM'); ?></li>
                                    <li data-value="horizontal-flip-left"><?php echo Text::_('FLIP_LEFT'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('APPEARANCE'); ?>
                            </span>
                            <div class="animation-appearance-action-wrapper">
                                <input class="animation-appearance-action" readonly onfocus="this.blur()" type="text">
                                <i class="zmdi zmdi-caret-down"></i>
                            </div>
                        </div>
                        <div class="ba-settings-item on-scroll-animations-wrapper">
                            <span>
                                <?php echo Text::_('ON_SCROLL'); ?>
                            </span>
                            <div class="ba-settings-toolbar">
                                <label data-value="translateY">
                                    <i class="zmdi zmdi-swap-vertical"></i>
                                    <span class="ba-tooltip"><?php echo Text::_('VERTICAL_SCROLLING'); ?></span>
                                </label>
                                <label data-value="translateX">
                                    <i class="zmdi zmdi-swap"></i>
                                    <span class="ba-tooltip"><?php echo Text::_('HORIZONTAL_SCROLLING'); ?></span>
                                </label>
                                <label data-value="scale">
                                    <i class="zmdi zmdi-fullscreen"></i>
                                    <span class="ba-tooltip"><?php echo Text::_('SCALE'); ?></span>
                                </label>
                                <label data-value="rotate">
                                    <i class="zmdi zmdi-rotate-right"></i>
                                    <span class="ba-tooltip"><?php echo Text::_('ROTATE'); ?></span>
                                </label>
                                <label data-value="opacity">
                                    <i class="zmdi zmdi-texture"></i>
                                    <span class="ba-tooltip"><?php echo Text::_('TRANSPARENCY'); ?></span>
                                </label>
                                <label data-value="blur">
                                    <i class="zmdi zmdi-center-focus-strong"></i>
                                    <span class="ba-tooltip"><?php echo Text::_('BLUR'); ?></span>
                                </label>
                            </div>
                        </div>
                        <div class="ba-settings-item flipbox-options">
                            <span>
                                <?php echo Text::_('DURATION'); ?>
                            </span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="2" step="0.1">
                                <input type="number" data-option="duration" data-group="animation" step="0.1" data-callback="sectionRules">
                            </div>
                        </div>
                        <div class="ba-settings-item flipbox-options">
                            <span>
                                <?php echo Text::_('3D_EFFECT'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-option="effect3D">
                                <span></span>
                            </label>
                        </div>
                    </div>
<?php
                    echo $this->html->loadPassive('disable');
?>
                    <div class="ba-settings-group presets-options">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-roller"></i>
                            <span><?php echo Text::_('PRESETS'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SELECT'); ?>
                            </span>
                            <div class="ba-lg-custom-select select-preset">
                                <input type="text" readonly onfocus="this.blur()">
                                <input type="hidden">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <div class="ba-lg-custom-select-header">
                                        <span class="create-new-preset">
                                            <i class="zmdi zmdi-plus-circle"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('SAVE_PRESET'); ?></span>
                                        </span>
                                        <span class="edit-preset-item">
                                            <i class="zmdi zmdi-edit"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('EDIT'); ?></span>
                                        </span>
                                        <span class="delete-preset-item">
                                            <i class="zmdi zmdi-delete"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('DELETE'); ?></span>
                                        </span>
                                    </div>
                                    <div class="ba-lg-custom-select-body">
                                        <li data-value="">
                                            <label>
                                                <input type="radio" name="preset-checkbox" value="">
                                                <i class="zmdi zmdi-circle-o"></i>
                                                <i class="zmdi zmdi-check"></i>
                                            </label>
                                            <span><?php echo Text::_('NO_NE'); ?></span>
                                        </li>
                                    </div>
                                </ul>
                            </div>
                        </div>
                    </div>
<?php
                    echo $this->html->loadPassive('advanced', $this->access);
?>
                </div>
                <div id="section-background-options" class="row-fluid tab-pane">
                    <div class="ba-settings-group flipbox-options">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SIDE'); ?>
                            </span>
                            <div class="ba-custom-select flipbox-select-side">
                                <input readonly onfocus="this.blur()"type="text">
                                <input type="hidden">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="frontside"><?php echo Text::_('FRONTSIDE'); ?></li>
                                    <li data-value="backside"><?php echo Text::_('BACKSIDE'); ?></li>
                                </ul>
                            </div>
                        </div>
                    </div>
<?php
                    echo $this->html->load('background');
                    $options = ['class' => 'hide-megamenu-options-border'];
                    echo $this->html->load('overlay', $options);
?>
                    <div class="ba-settings-group shape-divider-options">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-texture"></i>
                            <span><?php echo Text::_('SHAPE_DIVIDER'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('TOP'); ?>
                            </span>
                            <div class="shape-divider-action-wrapper">
                                <input class="shape-divider-action" readonly onfocus="this.blur()" type="text" data-position="top">
                                <i class="zmdi zmdi-caret-down"></i>
                            </div>
                        </div>                        
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('BOTTOM'); ?>
                            </span>
                            <div class="shape-divider-action-wrapper">
                                <input class="shape-divider-action" readonly onfocus="this.blur()" type="text" data-position="bottom">
                                <i class="zmdi zmdi-caret-down"></i>
                            </div>
                        </div>
                    </div>
                </div>
                <div id="section-layout-options" class="row-fluid tab-pane">
                    <div class="ba-settings-group column-gutter desktop-only">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('COLUMNS_GUTTER'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-option="gutter" data-group="view" class="set-value-css">
                                <span></span>
                            </label>
                        </div>
                    </div>
                    <div class="ba-settings-group only-not-desktop mobile-column-width">
                        <div class="settings-group-title">
                            <span><?php echo Text::_('MOBILE'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('COLUMN_WIDTH'); ?>
                            </span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="1" max="12" step="1">
                                <input type="number" data-option="width" data-group="span" step="1" data-callback="sectionRules">
                            </div>
                            <label class="ba-help-icon">
                                <i class="zmdi zmdi-help"></i>
                                <span class="ba-tooltip ba-help">
                                    <?php echo Text::_('STACK_THE_COLUMNS'); ?>
                                </span>
                            </label>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('COLUMN_ORDER'); ?>
                            </span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="1" max="12" step="1">
                                <input type="number" data-option="order" data-group="span" step="1"
                                    data-callback="sectionRules">
                            </div>
                        </div>
                    </div>
<?php
                    echo $this->html->load('margin');
                    echo $this->html->load('padding');
                    echo $this->html->load('border');
                    echo $this->html->load('shadow');
?>
                </div>
                <i class="zmdi zmdi-more resize-handle-bottom"></i>
            </div>
        </div>
    </div>
</div>
<div id="item-settings-dialog" class="ba-modal-cp draggable-modal-cp modal hide">
    <div class="modal-header">
        <span class="ba-dialog-title"></span>
        <div class="modal-header-icon">
            <div class="ba-custom-select select-modal-cp-position">
                <i class="zmdi zmdi-more-vert"></i>
                <input type="hidden">
                <ul>
                    <li data-value=""><?php echo Text::_('SEPARATE_WINDOW') ?></li>
                    <li data-value="right"><?php echo Text::_('PANEL_TO_RIGHT') ?></li>
                </ul>
            </div>
            <i class="zmdi zmdi-close close-cp-modal"></i>
        </div>
    </div>
    <div class="modal-body">
        <div class="general-tabs">
            <ul class="nav nav-tabs">
                <li class="active">
                    <a href="#item-general-options" data-toggle="tab">
                        <i class="zmdi zmdi-settings"></i>
                        <span><?php echo Text::_('GENERAL'); ?></span>
                    </a>
                </li>
                <li>
                    <a href="#item-design-options" data-toggle="tab">
                        <i class="zmdi zmdi-format-color-fill"></i>
                        <span><?php echo Text::_('DESIGN'); ?></span>
                    </a>
                </li>
                <li class="">
                    <a href="#item-layout-options" data-toggle="tab">
                        <i class="zmdi zmdi-fullscreen"></i>
                        <span><?php echo Text::_('layout'); ?></span>
                    </a>
                </li>
            </ul>
            <div class="tabs-underline"></div>
            <div class="tab-content">
                <div id="item-general-options" class="row-fluid tab-pane active">
                    <div class="ba-settings-group modules-options">
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('SELECT'); ?></span>
                            <input type="text" class="select-input reselect-module" readonly="" onfocus="this.blur()"
                                placeholder="<?php echo Text::_('SELECT'); ?>">
                            <i class="zmdi zmdi-attachment-alt"></i>
                        </div>
                    </div>
                    <div class="simple-gallery-options">
<?php
                    include $htmlPath.'ba-settings-group-items-list.php';
?>
                    </div>
                    <div class="ba-settings-group field-simple-gallery-options">
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('ADMIN_LABEL'); ?></span>
                            <input type="text" data-option="label" placeholder="<?php echo Text::_('ADMIN_LABEL'); ?>"
                                class="set-value-css">
                        </div>
                        <div class="ba-settings-item input-resize">
                            <span><?php echo Text::_('ADMIN_DESCRIPTION'); ?></span>
                            <input type="text" data-option="description" data-group="options" class="field-admin-description" 
                                placeholder="<?php echo Text::_('ADMIN_DESCRIPTION'); ?>"
                                class="set-value-css">
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SOURCE'); ?>
                            </span>
                            <div class="ba-custom-select select-field-upload-source">
                                <input readonly onfocus="this.blur()" type="text" value="">
                                <input type="hidden" value="">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value=""><?php echo Text::_('MEDIA_MANAGER'); ?></li>
                                    <li data-value="desktop"><?php echo Text::_('DESKTOP'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item desktop-source-filesize">
                            <span><?php echo Text::_('MAX_UPLOAD_FILE_SIZE'); ?></span>
                            <input type="text" data-option="size" data-group="options" class="set-value-css"
                                placeholder="<?php echo Text::_('MAX_UPLOAD_FILE_SIZE'); ?>">
                        </div>
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('REQUIRED'); ?></span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-option="required" class="set-value-css">
                                <span></span>
                            </label>
                        </div>
                    </div>
                    <div class="ba-settings-group simple-gallery-options field-simple-gallery-options">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-desktop-windows"></i>
                            <span><?php echo Text::_('VIEW'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('NUMBER_OF_COLUMNS'); ?>
                            </span>
                            <input type="number" data-option="count" class="lightbox-settings-input set-value-css">
                        </div>
                        <div class="ba-settings-item simple-gallery-options field-simple-gallery-options">
                            <span>
                                <?php echo Text::_('LAYOUT'); ?>
                            </span>
                            <div class="ba-custom-select simple-gallery-layout-select">
                                <input readonly onfocus="this.blur()" type="text">
                                <input type="hidden">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value=""><?php echo Text::_('GRID'); ?></li>
                                    <li data-value="simple-gallery-masonry-layout"><?php echo Text::_('MASONRY'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('HEIGHT'); ?>
                            </span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="10" max="1500">
                                <input type="text" data-option="height" data-group="view" data-callback="sectionRules">
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('COLUMNS_GUTTER'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-option="gutter" class="set-value-css">
                                <span></span>
                            </label>
                        </div>
                    </div>
                    <div class="ba-settings-group simple-gallery-options">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-tune"></i>
                            <span><?php echo Text::_('CAPTION'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('TYPE'); ?>
                            </span>
                            <div class="ba-custom-select background-overlay-select">
                                <input readonly onfocus="this.blur()" type="text">
                                <input type="hidden" data-property="overlay">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="color"><?php echo Text::_('COLOR'); ?></li>
                                    <li data-value="gradient"><?php echo Text::_('GRADIENT'); ?></li>
                                    <li data-value="none"><?php echo Text::_('NO_NE'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="overlay-color-options">
                            <div class="ba-settings-item">
                                <span>
                                    <?php echo Text::_('COLOR'); ?>
                                </span>
                                <input type="text" data-type="color" data-option="color" data-group="overlay">
                                <span class="minicolors-opacity-wrapper">
                                    <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                    min="0" max="1" step="0.01">
                                    <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                                </span>
                            </div>
                        </div>
                        <div class="overlay-gradient-options">
                            <div class="ba-settings-item">
                                <span>
                                    <?php echo Text::_('EFFECT'); ?>
                                </span>
                                <div class="ba-custom-select gradient-effect-select">
                                    <input readonly onfocus="this.blur()" value="" type="text">
                                    <input type="hidden" value="" data-property="overlay">
                                    <i class="zmdi zmdi-caret-down"></i>
                                    <ul>
                                        <li data-value="linear">Linear</li>
                                        <li data-value="radial">Radial</li>
                                    </ul>
                                </div>
                            </div>
                            <div class="ba-settings-item overlay-linear-gradient">
                                <span>
                                    <?php echo Text::_('ANGLE'); ?>
                                </span>
                                <div class="ba-range-wrapper">
                                    <span class="ba-range-liner"></span>
                                    <input type="range" class="ba-range" min="0" max="360" step="1">
                                    <input type="number" data-option="angle" data-group="overlay" data-subgroup="gradient"
                                        step="1" data-callback="sectionRules">
                                </div>
                            </div>
                            <div class="ba-settings-item">
                                <span>
                                    <?php echo Text::_('START_COLOR'); ?>
                                </span>
                                <input type="text" data-type="color" data-option="color1" data-group="overlay"
                                    data-subgroup="gradient">
                                <span class="minicolors-opacity-wrapper">
                                    <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                    min="0" max="1" step="0.01">
                                    <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                                </span>
                            </div>
                            <div class="ba-settings-item">
                                <span>
                                    <?php echo Text::_('POSITION'); ?>
                                </span>
                                <div class="ba-range-wrapper">
                                    <span class="ba-range-liner"></span>
                                    <input type="range" class="ba-range" min="0" max="100" step="1">
                                    <input type="number" data-option="position1" data-group="overlay" data-subgroup="gradient"
                                        step="1" data-callback="sectionRules">
                                </div>
                            </div>
                            <div class="ba-settings-item">
                                <span>
                                    <?php echo Text::_('END_COLOR'); ?>
                                </span>
                                <input type="text" data-type="color" data-option="color2" data-group="overlay"
                                    data-subgroup="gradient">
                                <span class="minicolors-opacity-wrapper">
                                    <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                    min="0" max="1" step="0.01">
                                    <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                                </span>
                            </div>
                            <div class="ba-settings-item">
                                <span>
                                    <?php echo Text::_('POSITION'); ?>
                                </span>
                                <div class="ba-range-wrapper">
                                    <span class="ba-range-liner"></span>
                                    <input type="range" class="ba-range" min="0" max="100" step="1">
                                    <input type="number" data-option="position2" data-group="overlay" data-subgroup="gradient"
                                        step="1" data-callback="sectionRules">
                                </div>
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('EFFECT'); ?>
                            </span>
                            <div class="ba-custom-select simple-gallery-caption-effect-select">
                                <input readonly onfocus="this.blur()" type="text">
                                <input type="hidden" data-option="effect" data-group="animation">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="ba-circle-bottom-right">Circle Bottom Right</li>
                                    <li data-value="ba-circle-top-left">Circle Top Left</li>
                                    <li data-value="ba-fade">Fade</li>
                                    <li data-value="ba-image-rotate-right">Image Rotate Right</li>
                                    <li data-value="ba-image-zoom-center">Image Zoom Center</li>
                                    <li data-value="ba-shutter-out-diagonal">Shutter Out Diagonal</li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('DURATION'); ?>
                            </span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="2" step="0.1">
                                <input type="number" data-option="duration" data-group="animation" step="0.1" data-callback="sectionRules">
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group hypercomments-options">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('APP_ID'); ?>
                            </span>
<?php
                            echo $this->html->load('integrations', $this->integrations->hypercomments);
?>
                        </div>
                    </div>
                    <div class="ba-settings-group facebook-comments-options">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('APP_ID'); ?>
                            </span>
<?php
                            echo $this->html->load('integrations', $this->integrations->facebook_comments);
?>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('LIMIT'); ?>
                            </span>
                            <div class="ba-range-wrapper image-width">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="5" max="100">
                                <input type="number" class="facebook-comments-limit" data-callback="sectionRules">
                            </div>
                            <label class="ba-help-icon">
                                <i class="zmdi zmdi-help"></i>
                                <span class="ba-tooltip ba-help"><?php echo Text::_('COMMENTS_LIMIT_TOOLTIP'); ?></span>
                            </label>
                        </div>
                    </div>
                    <div class="ba-settings-group vk-comments-options">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('APP_ID'); ?>
                            </span>
<?php
                            echo $this->html->load('integrations', $this->integrations->vk_comments);
?>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('LIMIT'); ?>
                            </span>
                            <div class="ba-range-wrapper image-width">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="5" max="100">
                                <input type="number" class="vk-comments-limit" data-callback="sectionRules">
                            </div>
                            <label class="ba-help-icon">
                                <i class="zmdi zmdi-help"></i>
                                <span class="ba-tooltip ba-help"><?php echo Text::_('COMMENTS_LIMIT_TOOLTIP'); ?></span>
                            </label>
                        </div>
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('AUTOPUBLISH'); ?></span>
                            <label class="ba-checkbox">
                                <input type="checkbox" class="vk-comments-autopublish">
                                <span></span>
                            </label>
                            <label class="ba-help-icon">
                                <i class="zmdi zmdi-help"></i>
                                <span class="ba-tooltip ba-help"><?php echo Text::_('VK_AUTOPUBLISH_TOOLTIP'); ?></span>
                            </label>
                        </div>
                    </div>
                    <div class="ba-settings-group vk-comments-options">
                        <div class="settings-group-title">
                            <span><?php echo Text::_('ATTACHMENT'); ?></span>
                            <label class="ba-help-icon">
                                <i class="zmdi zmdi-help"></i>
                                <span class="ba-tooltip ba-help"><?php echo Text::_('VK_ATTACHMENT_TOOLTIP'); ?></span>
                            </label>
                        </div>
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('GRAFFITI'); ?></span>
                            <label class="ba-checkbox">
                                <input type="checkbox" class="vk-comments-attach" data-option="graffiti">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('PHOTO'); ?></span>
                            <label class="ba-checkbox">
                                <input type="checkbox" class="vk-comments-attach" data-option="photo">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('AUDIO'); ?></span>
                            <label class="ba-checkbox">
                                <input type="checkbox" class="vk-comments-attach" data-option="audio">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('VIDEO'); ?></span>
                            <label class="ba-checkbox">
                                <input type="checkbox" class="vk-comments-attach" data-option="video">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('LINK'); ?></span>
                            <label class="ba-checkbox">
                                <input type="checkbox" class="vk-comments-attach" data-option="link">
                                <span></span>
                            </label>
                        </div>
                    </div>
                    <div class="ba-settings-group disqus-options">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('DISQUS_SUBDOMAIN'); ?>
                            </span>
<?php
                            echo $this->html->load('integrations', $this->integrations->disqus);
?>
                        </div>
                    </div>
                    <div class="ba-settings-group logo-options">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SELECT'); ?>
                            </span>
                            <input type="text" readonly onfocus="this.blur()" data-option="image"
                                class="reselect-image select-input" data-action="sectionRules"
                                placeholder="<?php echo Text::_('SELECT'); ?>">
                            <i class="zmdi zmdi-attachment-alt"></i>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('IMAGE_ALT'); ?>
                            </span>
                            <input type="text" data-option="alt" placeholder="<?php echo Text::_('IMAGE_ALT'); ?>">
                        </div>
                    </div>
                    <div class="ba-settings-group logo-options">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-link"></i>
                            <span><?php echo Text::_('LINK'); ?></span>
                        </div>
                        <div class="ba-settings-item link-picker-container">
                            <span>
                                <?php echo Text::_('LINK'); ?>
                            </span>
                            <input type="text" data-option="link" data-group="link" placeholder="<?php echo Text::_('LINK'); ?>">
                            <div class="select-link">
                                <i class="zmdi zmdi-attachment-alt"></i>
                                <span class="ba-tooltip"><?php echo Text::_('LINK_PICKER') ?></span>
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('ARIA_LABEL') ?></span>
                            <input type="text" class="aria-label"
                                   placeholder="<?php echo Text::_('ARIA_LABEL') ?>">
                        </div>
                    </div>
<?php
                    echo $this->html->loadPassive('disable');
?>
                    <div class="ba-settings-group simple-gallery-options field-simple-gallery-options">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-roller"></i>
                            <span><?php echo Text::_('PRESETS'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SELECT'); ?>
                            </span>
                            <div class="ba-lg-custom-select select-preset">
                                <input type="text" readonly onfocus="this.blur()">
                                <input type="hidden">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <div class="ba-lg-custom-select-header">
                                        <span class="create-new-preset">
                                            <i class="zmdi zmdi-plus-circle"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('SAVE_PRESET'); ?></span>
                                        </span>
                                        <span class="edit-preset-item">
                                            <i class="zmdi zmdi-edit"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('EDIT'); ?></span>
                                        </span>
                                        <span class="delete-preset-item">
                                            <i class="zmdi zmdi-delete"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('DELETE'); ?></span>
                                        </span>
                                    </div>
                                    <div class="ba-lg-custom-select-body">
                                        <li data-value="">
                                            <label>
                                                <input type="radio" name="preset-checkbox" value="">
                                                <i class="zmdi zmdi-circle-o"></i>
                                                <i class="zmdi zmdi-check"></i>
                                            </label>
                                            <span><?php echo Text::_('NO_NE'); ?></span>
                                        </li>
                                    </div>
                                </ul>
                            </div>
                        </div>
                    </div>
<?php
                    echo $this->html->loadPassive('item-animation');
                    echo $this->html->loadPassive('advanced', $this->access);
?>
                </div>
                <div id="item-design-options" class="row-fluid tab-pane">
                    <div class="ba-settings-group logo-options">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('WIDTH'); ?>
                            </span>
                            <div class="ba-range-wrapper image-width">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="1000">
                                <input type="text" data-option="width" data-callback="sectionRules">
                            </div>
                        </div>
                        <div class="ba-settings-toolbar">
                            <label data-value="left" data-option="text-align" data-callback="sectionRules">
                                <i class="zmdi zmdi-format-align-left"></i>
                                <span class="ba-tooltip">
                                    <?php echo Text::_('LEFT'); ?>
                                </span>
                            </label>
                            <label data-value="center" data-option="text-align" data-callback="sectionRules">
                                <i class="zmdi zmdi-format-align-center"></i>
                                <span class="ba-tooltip">
                                    <?php echo Text::_('CENTER'); ?>
                                </span>
                            </label>
                            <label data-value="right" data-option="text-align" data-callback="sectionRules">
                                <i class="zmdi zmdi-format-align-right"></i>
                                <span class="ba-tooltip">
                                    <?php echo Text::_('RIGHT'); ?>
                                </span>
                            </label>
                        </div>
                    </div>
                    <div class="ba-settings-group slideshow-design-group simple-gallery-options">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SELECT'); ?>
                            </span>
                            <div class="ba-custom-select slideshow-style-custom-select">
                                <input readonly onfocus="this.blur()" type="text" value="">
                                <input type="hidden" value="">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="title"><?php echo Text::_('TITLE'); ?></li>
                                    <li data-value="description"><?php echo Text::_('DESCRIPTION'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item title-html-tag">
                            <span>
                                <?php echo Text::_('HTML_TAG'); ?>
                            </span>
                            <div class="ba-custom-select select-title-html-tag">
                                <input readonly onfocus="this.blur()" type="text" value="">
                                <input type="hidden" value="">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="h1">H1</li>
                                    <li data-value="h2">H2</li>
                                    <li data-value="h3">H3</li>
                                    <li data-value="h4">H4</li>
                                    <li data-value="h5">H5</li>
                                    <li data-value="h6">H6</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group slideshow-typography-options simple-gallery-options">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-format-size"></i>
                            <span><?php echo Text::_('TYPOGRAPHY'); ?></span>
                        </div>
                        <div class="theme-typography-options">
                            <div class="typography-options">
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('FONT_FAMILY'); ?>
                                    </span>
                                    <input readonly onfocus="this.blur()" type="text" data-option="font-family" data-group=""
                                        data-subgroup="typography" data-callback="sectionRules">
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('FONT_WEIGHT'); ?>
                                    </span>
                                    <input readonly onfocus="this.blur()" type="text" data-option="font-weight"
                                        data-group="" data-subgroup="typography" data-callback="sectionRules">
                                </div>
                                <div class="ba-settings-item slideshow-typography-color">
                                    <span>
                                        <?php echo Text::_('COLOR'); ?>
                                    </span>
                                    <input type="text" data-type="color" data-option="color" data-group="" data-subgroup="typography">
                                    <span class="minicolors-opacity-wrapper">
                                        <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                        min="0" max="1" step="0.01">
                                        <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                                    </span>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('SIZE'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner"></span>
                                        <input type="range" class="ba-range" min="0" max="320">
                                        <input type="text" data-option="font-size" data-group="" data-subgroup="typography"
                                            data-callback="sectionRules">
                                    </div>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('LETTER_SPACING'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner letter-spacing"></span>
                                        <input type="range" class="ba-range" min="-10" max="10">
                                        <input type="text" data-option="letter-spacing" data-group="" data-subgroup="typography"
                                            data-callback="sectionRules">
                                    </div>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('LINE_HEIGHT'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner"></span>
                                        <input type="range" class="ba-range" min="0" max="640">
                                        <input type="text" data-option="line-height" data-group="" data-subgroup="typography"
                                            data-callback="sectionRules">
                                    </div>
                                </div>
                                <div class="ba-settings-toolbar">
                                    <label data-option="text-decoration" data-value="underline" data-group="" data-subgroup="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-underlined"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('UNDERLINE'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-transform" data-value="uppercase" data-group="" data-subgroup="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-size"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('UPPERCASE'); ?>
                                        </span>
                                    </label>
                                    <label data-option="font-style" data-value="italic" data-group="" data-subgroup="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-italic"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('ITALIC'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-align" data-value="left" data-group="" data-subgroup="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-align-left"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('LEFT'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-align" data-value="center" data-group="" data-subgroup="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-align-center"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('CENTER'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-align" data-value="right" data-group="" data-subgroup="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-align-right"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('RIGHT'); ?>
                                        </span>
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
<?php
                    $options = ['class' => 'slideshow-margin-options simple-gallery-options',
                        'group' => 'title', 'subgroup' => 'margin'];
                    echo $this->html->load('margin', $options);
?>
                    <div class="ba-settings-group simple-gallery-options slideshow-design-group
                        field-simple-gallery-options">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-select-all"></i>
                            <span><?php echo Text::_('LIGHTBOX'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('BACKGROUND'); ?>
                            </span>
                            <input type="text" data-type="color" data-option="color" data-group="lightbox" class="minicolors-top">
                            <span class="minicolors-opacity-wrapper">
                                <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                min="0" max="1" step="0.01">
                                <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                            </span>
                        </div>
                    </div>
                </div>
                <div id="item-layout-options" class="row-fluid tab-pane">
<?php
                    echo $this->html->loadPassive('positioning');
                    echo $this->html->load('margin');
                    $options = ['class' => 'simple-gallery-options field-simple-gallery-options'];
                    echo $this->html->load('border', $options);
?>
                </div>
                <i class="zmdi zmdi-more resize-handle-bottom"></i>
            </div>
        </div>
    </div>
</div>
<div id="image-settings-dialog" class="ba-modal-cp draggable-modal-cp modal hide">
    <div class="modal-header">
        <span class="ba-dialog-title"></span>
        <div class="modal-header-icon">
            <div class="ba-custom-select select-modal-cp-position">
                <i class="zmdi zmdi-more-vert"></i>
                <input type="hidden">
                <ul>
                    <li data-value=""><?php echo Text::_('SEPARATE_WINDOW') ?></li>
                    <li data-value="right"><?php echo Text::_('PANEL_TO_RIGHT') ?></li>
                </ul>
            </div>
            <i class="zmdi zmdi-close close-cp-modal"></i>
        </div>
    </div>
    <div class="modal-body">
        <div class="general-tabs">
            <ul class="nav nav-tabs">
                <li class="active">
                    <a href="#image-general-options" data-toggle="tab">
                        <i class="zmdi zmdi-settings"></i>
                        <span><?php echo Text::_('GENERAL'); ?></span>
                    </a>
                </li>
                <li class="ba-image-options">
                    <a href="#image-design-options" data-toggle="tab">
                        <i class="zmdi zmdi-format-color-fill"></i>
                        <span><?php echo Text::_('DESIGN'); ?></span>
                    </a>
                </li>
                <li class="">
                    <a href="#image-layout-options" data-toggle="tab">
                        <i class="zmdi zmdi-fullscreen"></i>
                        <span><?php echo Text::_('LAYOUT'); ?></span>
                    </a>
                </li>
            </ul>
            <div class="tabs-underline"></div>
            <div class="tab-content">
                <div id="image-general-options" class="row-fluid tab-pane active">
                    <div class="ba-settings-group image-fields-item-options">
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('ADMIN_LABEL'); ?></span>
                            <input type="text" data-option="label" placeholder="<?php echo Text::_('ADMIN_LABEL'); ?>"
                                class="set-value-css">
                        </div>
                        <div class="ba-settings-item input-resize">
                            <span><?php echo Text::_('ADMIN_DESCRIPTION'); ?></span>
                            <input type="text" data-option="description" data-group="options" class="field-admin-description" 
                                placeholder="<?php echo Text::_('ADMIN_DESCRIPTION'); ?>"
                                class="set-value-css">
                        </div>
                        <div class="ba-settings-item image-field-only">
                            <span>
                                <?php echo Text::_('SOURCE'); ?>
                            </span>
                            <div class="ba-custom-select select-field-upload-source">
                                <input readonly onfocus="this.blur()" type="text" value="">
                                <input type="hidden" value="">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value=""><?php echo Text::_('MEDIA_MANAGER'); ?></li>
                                    <li data-value="desktop"><?php echo Text::_('DESKTOP'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item desktop-source-filesize image-field-only">
                            <span><?php echo Text::_('MAX_UPLOAD_FILE_SIZE'); ?></span>
                            <input type="text" data-option="size" data-group="options" class="set-value-css"
                                placeholder="<?php echo Text::_('MAX_UPLOAD_FILE_SIZE'); ?>">
                        </div>
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('REQUIRED'); ?></span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-option="required" class="set-value-css">
                                <span></span>
                            </label>
                        </div>
                    </div>
                    <div class="ba-settings-group video-field-item-options">
                        <div class="ba-settings-item">
                            <span>
                                Youtube
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-group="options" data-option="youtube" class="set-value-css">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                Vimeo
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-group="options" data-option="vimeo" class="set-value-css">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SOURCE_FILE'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-group="options" data-option="file" class="set-value-css">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item video-field-upload-from">
                            <span>
                                <?php echo Text::_('UPLOAD_FROM'); ?>
                            </span>
                            <div class="ba-custom-select select-field-upload-source">
                                <input readonly onfocus="this.blur()" type="text" value="">
                                <input type="hidden" value="">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value=""><?php echo Text::_('MEDIA_MANAGER'); ?></li>
                                    <li data-value="desktop"><?php echo Text::_('DESKTOP'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item desktop-source-filesize">
                            <span><?php echo Text::_('MAX_UPLOAD_FILE_SIZE'); ?></span>
                            <input type="text" data-option="size" data-group="options" class="set-value-css"
                                placeholder="<?php echo Text::_('MAX_UPLOAD_FILE_SIZE'); ?>">
                        </div>
                    </div>
                    <div class="ba-settings-group video-item-options">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('VIDEO_SOURCE'); ?>
                            </span>
                            <div class="ba-custom-select select-video-source">
                                <input readonly onfocus="this.blur()" type="text" value="">
                                <input type="hidden" value="">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="youtube">Youtube</li>
                                    <li data-value="vimeo">Vimeo</li>
                                    <li data-value="source"><?php echo Text::_('SOURCE_FILE'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item video-id">
                            <span>
                                <?php echo Text::_('VIDEO_ID'); ?>
                            </span>
                            <input type="text" data-option="id" data-group="video"
                                placeholder="<?php echo Text::_('VIDEO_ID'); ?>">
                        </div>
                        <div class="video-youtube-options">
                            <div class="ba-settings-item">
                                <span>
                                    <?php echo Text::_('START'); ?>
                                </span>
                                <input type="text" data-option="start" data-group="video" data-subgroup="youtube"
                                    placeholder="<?php echo Text::_('START'); ?>">
                            </div>
                            <div class="ba-settings-item">
                                <span>
                                    <?php echo Text::_('PRIVACY_ENHANCED_MODE'); ?>
                                </span>
                                <label class="ba-checkbox">
                                    <input type="checkbox" data-option="nocookie">
                                    <span></span>
                                </label>
                            </div>
                            <div class="ba-settings-item">
                                <span>
                                    <?php echo Text::_('CONTROLS'); ?>
                                </span>
                                <label class="ba-checkbox">
                                    <input type="checkbox" data-option="controls" data-group="video" data-subgroup="youtube">
                                    <span></span>
                                </label>
                            </div>
                            <div class="ba-settings-item">
                                <span>
                                    <?php echo Text::_('LAZY_LOAD'); ?>
                                </span>
                                <label class="ba-checkbox">
                                    <input type="checkbox" data-option="lazyLoad" class="set-value-css">
                                    <span></span>
                                </label>
                            </div>
                        </div>
                        <div class="video-vimeo-options">
                            <div class="ba-settings-item">
                                <span>
                                    <?php echo Text::_('LOOP'); ?>
                                </span>
                                <label class="ba-checkbox">
                                    <input type="checkbox" data-option="loop" data-group="video" data-subgroup="vimeo">
                                    <span></span>
                                </label>
                            </div>
                        </div>
                        <div class="video-source-options">
                            <div class="ba-settings-item">
                                <span>
                                    <?php echo Text::_('SOURCE_FILE'); ?>
                                </span>
                                <input type="text" class="select-input" readonly onfocus="this.blur()"
                                    data-option="file" data-group="video" data-subgroup="source"
                                    placeholder="<?php echo Text::_('SELECT'); ?>">
                                <i class="zmdi zmdi-attachment-alt"></i>
                                <label class="ba-help-icon">
                                    <i class="zmdi zmdi-help"></i>
                                    <span class="ba-tooltip ba-help">
                                        <?php echo Text::_('SOURCE_FILE_TOOLTIP'); ?>
                                    </span>
                                </label>
                            </div>
                            <div class="ba-settings-item">
                                <span>
                                    <?php echo Text::_('AUTOPLAY'); ?>
                                </span>
                                <label class="ba-checkbox">
                                    <input type="checkbox" data-option="autoplay" data-group="video" data-subgroup="source">
                                    <span></span>
                                </label>
                            </div>
                            <div class="ba-settings-item">
                                <span>
                                    <?php echo Text::_('CONTROLS'); ?>
                                </span>
                                <label class="ba-checkbox">
                                    <input type="checkbox" data-option="controls" data-group="video" data-subgroup="source">
                                    <span></span>
                                </label>
                            </div>
                            <div class="ba-settings-item">
                                <span>
                                    <?php echo Text::_('LOOP'); ?>
                                </span>
                                <label class="ba-checkbox">
                                    <input type="checkbox" data-option="loop" data-group="video" data-subgroup="source">
                                    <span></span>
                                </label>
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group items-list ba-image-options">
                        <div class="sorting-container">
                        
                        </div>
                    </div>
                    <div class="ba-settings-group ba-image-options">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-desktop-windows"></i>
                            <span><?php echo Text::_('VIEW'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('WIDTH'); ?>
                            </span>
                            <div class="ba-range-wrapper image-width">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="2500">
                                <input type="text" data-option="width" data-group="style" data-callback="sectionRules">
                            </div>
                        </div>
                        <div class="ba-settings-toolbar">
                            <label data-value="left" data-option="align" data-group="style" data-callback="sectionRules">
                                <i class="zmdi zmdi-format-align-left"></i>
                                <span class="ba-tooltip">
                                    <?php echo Text::_('LEFT'); ?>
                                </span>
                            </label>
                            <label data-value="center" data-option="align" data-group="style" data-callback="sectionRules">
                                <i class="zmdi zmdi-format-align-center"></i>
                                <span class="ba-tooltip">
                                    <?php echo Text::_('CENTER'); ?>
                                </span>
                            </label>
                            <label data-value="right" data-option="align" data-group="style" data-callback="sectionRules">
                                <i class="zmdi zmdi-format-align-right"></i>
                                <span class="ba-tooltip">
                                    <?php echo Text::_('RIGHT'); ?>
                                </span>
                            </label>
                        </div>
                    </div>
                    <div class="ba-settings-group ba-image-options">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-link"></i>
                            <span><?php echo Text::_('LINK'); ?></span>
                        </div>
                        <div class="ba-settings-item link-picker-container">
                            <span>
                                <?php echo Text::_('LINK'); ?>
                            </span>
                            <input type="text" data-option="link" data-group="link" placeholder="<?php echo Text::_('LINK'); ?>">
                            <div class="select-link">
                                <i class="zmdi zmdi-attachment-alt"></i>
                                <span class="ba-tooltip"><?php echo Text::_('LINK_PICKER') ?></span>
                            </div>
                            <div class="select-file">
                                <i class="zmdi zmdi-file"></i>
                                <span class="ba-tooltip"><?php echo Text::_('FILE_PICKER') ?></span>
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('ARIA_LABEL') ?></span>
                            <input type="text" class="aria-label"
                                   placeholder="<?php echo Text::_('ARIA_LABEL') ?>">
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('TARGET'); ?>
                            </span>
                            <div class="ba-custom-select link-target-select">
                                <input readonly onfocus="this.blur()" value="" type="text">
                                <input type="hidden" value="" data-option="target" data-group="link">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="_blank"><?php echo Text::_('NEW_WINDOW'); ?></li>
                                    <li data-value="_self"><?php echo Text::_('SAME_WINDOW'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('TYPE'); ?>
                            </span>
                            <div class="ba-custom-select link-type-select">
                                <input readonly onfocus="this.blur()" value="" type="text">
                                <input type="hidden" value="" data-option="type" data-group="link">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value=""><?php echo Text::_('DEFAULT'); ?></li>
                                    <li data-value="download"><?php echo Text::_('DOWNLOAD'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('EMBED_CODE'); ?>
                            </span>
                            <input type="text" class="button-embed-code" placeholder="<?php echo Text::_('EMBED_CODE'); ?>">
                        </div>
                    </div>
                    <div class="ba-settings-group ba-image-options">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-tune"></i>
                            <span><?php echo Text::_('CAPTION'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('ON_MOUSEOVER'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" class="mouseover-image-caption">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('TYPE'); ?>
                            </span>
                            <div class="ba-custom-select background-overlay-select">
                                <input readonly onfocus="this.blur()" type="text">
                                <input type="hidden" data-property="overlay">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="color"><?php echo Text::_('COLOR'); ?></li>
                                    <li data-value="gradient"><?php echo Text::_('GRADIENT'); ?></li>
                                    <li data-value="none"><?php echo Text::_('NO_NE'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="overlay-color-options">
                            <div class="ba-settings-item">
                                <span>
                                    <?php echo Text::_('COLOR'); ?>
                                </span>
                                <input type="text" data-type="color" data-option="color" data-group="overlay">
                                <span class="minicolors-opacity-wrapper">
                                    <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                    min="0" max="1" step="0.01">
                                    <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                                </span>
                            </div>
                        </div>
                        <div class="overlay-gradient-options">
                            <div class="ba-settings-item">
                                <span>
                                    <?php echo Text::_('EFFECT'); ?>
                                </span>
                                <div class="ba-custom-select gradient-effect-select">
                                    <input readonly onfocus="this.blur()" value="" type="text">
                                    <input type="hidden" value="" data-property="overlay">
                                    <i class="zmdi zmdi-caret-down"></i>
                                    <ul>
                                        <li data-value="linear">Linear</li>
                                        <li data-value="radial">Radial</li>
                                    </ul>
                                </div>
                            </div>
                            <div class="ba-settings-item overlay-linear-gradient">
                                <span>
                                    <?php echo Text::_('ANGLE'); ?>
                                </span>
                                <div class="ba-range-wrapper">
                                    <span class="ba-range-liner"></span>
                                    <input type="range" class="ba-range" min="0" max="360" step="1">
                                    <input type="number" data-option="angle" data-group="overlay" data-subgroup="gradient"
                                        step="1" data-callback="sectionRules">
                                </div>
                            </div>
                            <div class="ba-settings-item">
                                <span>
                                    <?php echo Text::_('START_COLOR'); ?>
                                </span>
                                <input type="text" data-type="color" data-option="color1" data-group="overlay"
                                    data-subgroup="gradient">
                                <span class="minicolors-opacity-wrapper">
                                    <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                    min="0" max="1" step="0.01">
                                    <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                                </span>
                            </div>
                            <div class="ba-settings-item">
                                <span>
                                    <?php echo Text::_('POSITION'); ?>
                                </span>
                                <div class="ba-range-wrapper">
                                    <span class="ba-range-liner"></span>
                                    <input type="range" class="ba-range" min="0" max="100" step="1">
                                    <input type="number" data-option="position1" data-group="overlay" data-subgroup="gradient"
                                        step="1" data-callback="sectionRules">
                                </div>
                            </div>
                            <div class="ba-settings-item">
                                <span>
                                    <?php echo Text::_('END_COLOR'); ?>
                                </span>
                                <input type="text" data-type="color" data-option="color2" data-group="overlay"
                                    data-subgroup="gradient">
                                <span class="minicolors-opacity-wrapper">
                                    <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                    min="0" max="1" step="0.01">
                                    <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                                </span>
                            </div>
                            <div class="ba-settings-item">
                                <span>
                                    <?php echo Text::_('POSITION'); ?>
                                </span>
                                <div class="ba-range-wrapper">
                                    <span class="ba-range-liner"></span>
                                    <input type="range" class="ba-range" min="0" max="100" step="1">
                                    <input type="number" data-option="position2" data-group="overlay" data-subgroup="gradient"
                                        step="1" data-callback="sectionRules">
                                </div>
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('EFFECT'); ?>
                            </span>
                            <div class="ba-custom-select image-item-caption-effect-select">
                                <input readonly onfocus="this.blur()" type="text">
                                <input type="hidden" data-option="effect" data-group="animation">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="ba-circle-bottom-right">Circle Bottom Right</li>
                                    <li data-value="ba-circle-top-left">Circle Top Left</li>
                                    <li data-value="ba-fade">Fade</li>
                                    <li data-value="ba-image-rotate-right">Image Rotate Right</li>
                                    <li data-value="ba-image-zoom-center">Image Zoom Center</li>
                                    <li data-value="ba-shutter-out-diagonal">Shutter Out Diagonal</li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('DURATION'); ?>
                            </span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="2" step="0.1">
                                <input type="number" data-option="duration" data-group="animation" step="0.1" data-callback="sectionRules">
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group ba-image-options">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-select-all"></i>
                            <span><?php echo Text::_('LIGHTBOX'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('ENABLE'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-option="popup" class="set-value-css">
                                <span></span>
                            </label>
                        </div>
                    </div>
<?php
                    echo $this->html->loadPassive('disable');
?>
                    <div class="ba-settings-group">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-roller"></i>
                            <span><?php echo Text::_('PRESETS'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SELECT'); ?>
                            </span>
                            <div class="ba-lg-custom-select select-preset">
                                <input type="text" readonly onfocus="this.blur()">
                                <input type="hidden">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <div class="ba-lg-custom-select-header">
                                        <span class="create-new-preset">
                                            <i class="zmdi zmdi-plus-circle"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('SAVE_PRESET'); ?></span>
                                        </span>
                                        <span class="edit-preset-item">
                                            <i class="zmdi zmdi-edit"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('EDIT'); ?></span>
                                        </span>
                                        <span class="delete-preset-item">
                                            <i class="zmdi zmdi-delete"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('DELETE'); ?></span>
                                        </span>
                                    </div>
                                    <div class="ba-lg-custom-select-body">
                                        <li data-value="">
                                            <label>
                                                <input type="radio" name="preset-checkbox" value="">
                                                <i class="zmdi zmdi-circle-o"></i>
                                                <i class="zmdi zmdi-check"></i>
                                            </label>
                                            <span><?php echo Text::_('NO_NE'); ?></span>
                                        </li>
                                    </div>
                                </ul>
                            </div>
                        </div>
                    </div>
<?php
                    echo $this->html->loadPassive('item-animation');
                    echo $this->html->loadPassive('advanced', $this->access);
?>
                </div>
                <div id="image-design-options" class="row-fluid tab-pane">
                    <div class="ba-settings-group slideshow-design-group ba-image-options">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SELECT'); ?>
                            </span>
                            <div class="ba-custom-select slideshow-style-custom-select">
                                <input readonly onfocus="this.blur()" type="text" value="">
                                <input type="hidden" value="">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="title"><?php echo Text::_('TITLE'); ?></li>
                                    <li data-value="description"><?php echo Text::_('DESCRIPTION'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item title-html-tag">
                            <span>
                                <?php echo Text::_('HTML_TAG'); ?>
                            </span>
                            <div class="ba-custom-select select-title-html-tag">
                                <input readonly onfocus="this.blur()" type="text" value="">
                                <input type="hidden" value="">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="h1">H1</li>
                                    <li data-value="h2">H2</li>
                                    <li data-value="h3">H3</li>
                                    <li data-value="h4">H4</li>
                                    <li data-value="h5">H5</li>
                                    <li data-value="h6">H6</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group slideshow-typography-options ba-image-options">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-format-size"></i>
                            <span><?php echo Text::_('TYPOGRAPHY'); ?></span>
                        </div>
                        <div class="theme-typography-options">
                            <div class="typography-options">
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('FONT_FAMILY'); ?>
                                    </span>
                                    <input readonly onfocus="this.blur()" type="text" data-option="font-family" data-group=""
                                        data-subgroup="typography" data-callback="sectionRules">
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('FONT_WEIGHT'); ?>
                                    </span>
                                    <input readonly onfocus="this.blur()" type="text" data-option="font-weight"
                                        data-group="" data-subgroup="typography" data-callback="sectionRules">
                                </div>
                                <div class="ba-settings-item slideshow-typography-color">
                                    <span>
                                        <?php echo Text::_('COLOR'); ?>
                                    </span>
                                    <input type="text" data-type="color" data-option="color" data-group="" data-subgroup="typography">
                                    <span class="minicolors-opacity-wrapper">
                                        <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                        min="0" max="1" step="0.01">
                                        <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                                    </span>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('SIZE'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner"></span>
                                        <input type="range" class="ba-range" min="0" max="320">
                                        <input type="text" data-option="font-size" data-group="" data-subgroup="typography"
                                            data-callback="sectionRules">
                                    </div>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('LETTER_SPACING'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner letter-spacing"></span>
                                        <input type="range" class="ba-range" min="-10" max="10">
                                        <input type="text" data-option="letter-spacing" data-group="" data-subgroup="typography"
                                            data-callback="sectionRules">
                                    </div>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('LINE_HEIGHT'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner"></span>
                                        <input type="range" class="ba-range" min="0" max="640">
                                        <input type="text" data-option="line-height" data-group="" data-subgroup="typography"
                                            data-callback="sectionRules">
                                    </div>
                                </div>
                                <div class="ba-settings-toolbar">
                                    <label data-option="text-decoration" data-value="underline" data-group="" data-subgroup="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-underlined"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('UNDERLINE'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-transform" data-value="uppercase" data-group="" data-subgroup="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-size"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('UPPERCASE'); ?>
                                        </span>
                                    </label>
                                    <label data-option="font-style" data-value="italic" data-group="" data-subgroup="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-italic"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('ITALIC'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-align" data-value="left" data-group="" data-subgroup="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-align-left"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('LEFT'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-align" data-value="center" data-group="" data-subgroup="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-align-center"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('CENTER'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-align" data-value="right" data-group="" data-subgroup="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-align-right"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('RIGHT'); ?>
                                        </span>
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
<?php
                    $options = ['class' => 'slideshow-margin-options ba-image-options',
                        'group' => 'title', 'subgroup' => 'margin'];
                    echo $this->html->load('margin', $options);
?>
                    <div class="ba-settings-group slideshow-design-group">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-select-all"></i>
                            <span><?php echo Text::_('LIGHTBOX'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('BACKGROUND'); ?>
                            </span>
                            <input type="text" data-type="color" data-option="color" data-group="lightbox" class="minicolors-top">
                            <span class="minicolors-opacity-wrapper">
                                <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                min="0" max="1" step="0.01">
                                <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                            </span>
                        </div>
                    </div>
                </div>
                <div id="image-layout-options" class="row-fluid tab-pane">
<?php
                    echo $this->html->loadPassive('positioning');
                    echo $this->html->load('margin');
                    echo $this->html->load('border');
                    echo $this->html->load('shadow');
?>
                </div>
                <i class="zmdi zmdi-more resize-handle-bottom"></i>
            </div>
        </div>
    </div>
</div>
<div id="headline-settings-dialog" class="ba-modal-cp draggable-modal-cp modal hide">
    <div class="modal-header">
        <span class="ba-dialog-title"></span>
        <div class="modal-header-icon">
            <div class="ba-custom-select select-modal-cp-position">
                <i class="zmdi zmdi-more-vert"></i>
                <input type="hidden">
                <ul>
                    <li data-value=""><?php echo Text::_('SEPARATE_WINDOW') ?></li>
                    <li data-value="right"><?php echo Text::_('PANEL_TO_RIGHT') ?></li>
                </ul>
            </div>
            <i class="zmdi zmdi-close close-cp-modal"></i>
        </div>
    </div>
    <div class="modal-body">
        <div class="general-tabs">
            <ul class="nav nav-tabs">
                <li class="active">
                    <a href="#headline-general-options" data-toggle="tab">
                        <i class="zmdi zmdi-settings"></i>
                        <span><?php echo Text::_('GENERAL'); ?></span>
                    </a>
                </li>
                <li>
                    <a href="#headline-design-options" data-toggle="tab">
                        <i class="zmdi zmdi-format-color-fill"></i>
                        <span><?php echo Text::_('DESIGN'); ?></span>
                    </a>
                </li>
                <li>
                    <a href="#headline-layout-options" data-toggle="tab">
                        <i class="zmdi zmdi-fullscreen"></i>
                        <span><?php echo Text::_('LAYOUT'); ?></span>
                    </a>
                </li>
            </ul>
            <div class="tabs-underline"></div>
            <div class="tab-content">
                <div id="headline-general-options" class="row-fluid tab-pane active">
                    <div class="ba-settings-group">
                        <div class="ba-settings-item input-resize">
                            <span>
                                <?php echo Text::_('LABEL'); ?>
                            </span>
                            <input type="text" placeholder="<?php echo Text::_('LABEL'); ?>" class="headline-label">
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('HTML_TAG'); ?>
                            </span>
                            <div class="ba-custom-select select-headline-html-tag">
                                <input readonly onfocus="this.blur()" type="text">
                                <input type="hidden">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="h1">H1</li>
                                    <li data-value="h2">H2</li>
                                    <li data-value="h3">H3</li>
                                    <li data-value="h4">H4</li>
                                    <li data-value="h5">H5</li>
                                    <li data-value="h6">H6</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group headline-option">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-skip-next"></i>
                            <span><?php echo Text::_('ANIMATION'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('EFFECT'); ?>
                            </span>
                            <div class="ba-custom-select headline-effect-select">
                                <input readonly onfocus="this.blur()" type="text">
                                <input type="hidden">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value=""><?php echo Text::_('NO_NE'); ?></li>
                                    <li data-value="flip">Flip</li>
                                    <li data-value="type">Type</li>
                                    <li data-value="rotate">Rotate</li>
                                    <li data-value="slide">Slide</li>
                                    <li data-value="zoom">Zoom</li>
                                    <li data-value="scale">Scale</li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('DURATION'); ?>
                            </span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="2" step="0.1">
                                <input type="number" data-option="duration" data-group="animation" step="0.1" data-callback="sectionRules">
                            </div>
                        </div>
                    </div>
<?php
                    echo $this->html->loadPassive('disable');
?>
                    <div class="ba-settings-group headline-option">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-roller"></i>
                            <span><?php echo Text::_('PRESETS'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SELECT'); ?>
                            </span>
                            <div class="ba-lg-custom-select select-preset">
                                <input type="text" readonly onfocus="this.blur()">
                                <input type="hidden">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <div class="ba-lg-custom-select-header">
                                        <span class="create-new-preset">
                                            <i class="zmdi zmdi-plus-circle"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('SAVE_PRESET'); ?></span>
                                        </span>
                                        <span class="edit-preset-item">
                                            <i class="zmdi zmdi-edit"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('EDIT'); ?></span>
                                        </span>
                                        <span class="delete-preset-item">
                                            <i class="zmdi zmdi-delete"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('DELETE'); ?></span>
                                        </span>
                                    </div>
                                    <div class="ba-lg-custom-select-body">
                                        <li data-value="">
                                            <label>
                                                <input type="radio" name="preset-checkbox" value="">
                                                <i class="zmdi zmdi-circle-o"></i>
                                                <i class="zmdi zmdi-check"></i>
                                            </label>
                                            <span><?php echo Text::_('NO_NE'); ?></span>
                                        </li>
                                    </div>
                                </ul>
                            </div>
                        </div>
                    </div>
<?php
                    echo $this->html->loadPassive('item-animation');
                    echo $this->html->loadPassive('advanced', $this->access);
?>
                </div>
                <div id="headline-design-options" class="row-fluid tab-pane">
                    <div class="ba-settings-group">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-format-size"></i>
                            <span><?php echo Text::_('TYPOGRAPHY'); ?></span>
                        </div>
                        <div class="theme-typography-options">
                            <div class="typography-options">
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('FONT_FAMILY'); ?>
                                    </span>
                                    <input readonly onfocus="this.blur()" type="text" data-option="font-family" data-group=""
                                        data-callback="sectionRules">
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('FONT_WEIGHT'); ?>
                                    </span>
                                    <input readonly onfocus="this.blur()" type="text" data-option="font-weight"
                                        data-group="" data-callback="sectionRules">
                                </div>
                                <div class="ba-settings-item select-text-type">
                                    <span>
                                        <?php echo Text::_('TYPE'); ?>
                                    </span>
                                    <div class="ba-custom-select text-type-select">
                                        <input readonly onfocus="this.blur()" type="text">
                                        <input type="hidden" data-property="text" data-group="" data-option="type">
                                        <i class="zmdi zmdi-caret-down"></i>
                                        <ul>
                                            <li data-value=""><?php echo Text::_('COLOR') ?></li>
                                            <li data-value="gradient"><?php echo Text::_('GRADIENT') ?></li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="ba-settings-item text-color-options">
                                    <span>
                                        <?php echo Text::_('COLOR'); ?>
                                    </span>
                                    <input type="text" data-type="color" data-option="color" data-group="h1">
                                    <span class="minicolors-opacity-wrapper">
                                        <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                        min="0" max="1" step="0.01">
                                        <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                                    </span>
                                </div>
                                <div class="text-gradient-options">
                                    <div class="ba-settings-item ba-disable-states">
                                        <span>
                                            <?php echo Text::_('EFFECT'); ?>
                                        </span>
                                        <div class="ba-custom-select gradient-effect-select">
                                            <input readonly onfocus="this.blur()" type="text">
                                            <input type="hidden" data-property="text" data-group="" data-subgroup="gradient" data-option="effect">
                                            <i class="zmdi zmdi-caret-down"></i>
                                            <ul>
                                                <li data-value="linear">Linear</li>
                                                <li data-value="radial">Radial</li>
                                            </ul>
                                        </div>
                                    </div>
                                    <div class="ba-settings-item text-linear-gradient ba-disable-states">
                                        <span>
                                            <?php echo Text::_('ANGLE'); ?>
                                        </span>
                                        <div class="ba-range-wrapper">
                                            <span class="ba-range-liner"></span>
                                            <input type="range" class="ba-range" min="0" max="360" step="1">
                                            <input type="number" data-option="angle" data-group="" data-subgroup="gradient"
                                                step="1" data-callback="sectionRules">
                                        </div>
                                    </div>
                                    <div class="ba-settings-item ba-disable-states">
                                        <span>
                                            <?php echo Text::_('START_COLOR'); ?>
                                        </span>
                                        <input type="text" data-type="color" data-option="color1" data-group=""
                                            data-subgroup="gradient">
                                        <span class="minicolors-opacity-wrapper">
                                            <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                            min="0" max="1" step="0.01">
                                            <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                                        </span>
                                    </div>
                                    <div class="ba-settings-item ba-disable-states">
                                        <span>
                                            <?php echo Text::_('POSITION'); ?>
                                        </span>
                                        <div class="ba-range-wrapper">
                                            <span class="ba-range-liner"></span>
                                            <input type="range" class="ba-range" min="0" max="100" step="1">
                                            <input type="number" data-option="position1" data-group="" data-subgroup="gradient"
                                                step="1" data-callback="sectionRules">
                                        </div>
                                    </div>
                                    <div class="ba-settings-item ba-disable-states">
                                        <span>
                                            <?php echo Text::_('END_COLOR'); ?>
                                        </span>
                                        <input type="text" data-type="color" data-option="color2" data-group=""
                                            data-subgroup="gradient">
                                        <span class="minicolors-opacity-wrapper">
                                            <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                            min="0" max="1" step="0.01">
                                            <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                                        </span>
                                    </div>
                                    <div class="ba-settings-item ba-disable-states">
                                        <span>
                                            <?php echo Text::_('POSITION'); ?>
                                        </span>
                                        <div class="ba-range-wrapper">
                                            <span class="ba-range-liner"></span>
                                            <input type="range" class="ba-range" min="0" max="100" step="1">
                                            <input type="number" data-option="position2" data-group="" data-subgroup="gradient"
                                                step="1" data-callback="sectionRules">
                                        </div>
                                    </div>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('SIZE'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner"></span>
                                        <input type="range" class="ba-range" min="0" max="320">
                                        <input type="text" data-option="font-size" data-group="" data-callback="sectionRules">
                                    </div>
                                    <div class="reset-text-typography-wrapper" style="display: none;">
                                        <i class="zmdi zmdi-replay reset-text-typography" data-type="reset"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('RESET'); ?>
                                        </span>
                                    </div>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('LETTER_SPACING'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner letter-spacing"></span>
                                        <input type="range" class="ba-range" min="-10" max="10">
                                        <input type="text" data-option="letter-spacing" data-group="" data-callback="sectionRules">
                                    </div>
                                    <div class="reset-text-typography-wrapper" style="display: none;">
                                        <i class="zmdi zmdi-replay reset-text-typography" data-type="reset"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('RESET'); ?>
                                        </span>
                                    </div>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('LINE_HEIGHT'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner"></span>
                                        <input type="range" class="ba-range" min="0" max="640">
                                        <input type="text" data-option="line-height" data-group="" data-callback="sectionRules">
                                    </div>
                                    <div class="reset-text-typography-wrapper" style="display: none;">
                                        <i class="zmdi zmdi-replay reset-text-typography" data-type="reset"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('RESET'); ?>
                                        </span>
                                    </div>
                                </div>
                                <div class="ba-settings-toolbar">
                                    <label data-option="text-decoration" data-value="underline" data-group="" data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-underlined"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('UNDERLINE'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-transform" data-value="uppercase" data-group="" data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-size"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('UPPERCASE'); ?>
                                        </span>
                                    </label>
                                    <label data-option="font-style" data-value="italic" data-group="" data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-italic"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('ITALIC'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-align" data-value="left" data-group="" data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-align-left"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('LEFT'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-align" data-value="center" data-group="" data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-align-center"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('CENTER'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-align" data-value="right" data-group="" data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-align-right"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('RIGHT'); ?>
                                        </span>
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div id="headline-layout-options" class="row-fluid tab-pane">
<?php
                    echo $this->html->loadPassive('positioning');
                    echo $this->html->load('margin');
?>
                </div>
                <i class="zmdi zmdi-more resize-handle-bottom"></i>
            </div>
        </div>
    </div>
</div>
<div id="countdown-settings-dialog" class="ba-modal-cp draggable-modal-cp modal hide">
    <div class="modal-header">
        <span class="ba-dialog-title"></span>
        <div class="modal-header-icon">
            <div class="ba-custom-select select-modal-cp-position">
                <i class="zmdi zmdi-more-vert"></i>
                <input type="hidden">
                <ul>
                    <li data-value=""><?php echo Text::_('SEPARATE_WINDOW') ?></li>
                    <li data-value="right"><?php echo Text::_('PANEL_TO_RIGHT') ?></li>
                </ul>
            </div>
            <i class="zmdi zmdi-close close-cp-modal"></i>
        </div>
    </div>
    <div class="modal-body">
        <div class="general-tabs">
            <ul class="nav nav-tabs">
                <li class="active">
                    <a href="#countdown-general-options" data-toggle="tab">
                        <i class="zmdi zmdi-settings"></i>
                        <span><?php echo Text::_('GENERAL'); ?></span>
                    </a>
                </li>
                <li>
                    <a href="#countdown-design-options" data-toggle="tab">
                        <i class="zmdi zmdi-format-color-fill"></i>
                        <span><?php echo Text::_('DESIGN'); ?></span>
                    </a>
                </li>
                <li>
                    <a href="#countdown-layout-options" data-toggle="tab">
                        <i class="zmdi zmdi-fullscreen"></i>
                        <span><?php echo Text::_('LAYOUT'); ?></span>
                    </a>
                </li>
            </ul>
            <div class="tabs-underline"></div>
            <div class="tab-content">
                <div id="countdown-general-options" class="row-fluid tab-pane active">
                    <div class="ba-settings-group field-button-options">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('ICON'); ?>
                            </span>
                            <input class="select-input select-field-icon" type="text" readonly onfocus="this.blur()"
                                placeholder="<?php echo Text::_('ICON'); ?>">
                            <i class="zmdi zmdi-attachment-alt"></i>
                            <div class="reset disabled-reset reset-field-icon">
                                <i class="zmdi zmdi-close"></i>
                                <span class="ba-tooltip ba-left">
                                    <?php echo Text::_('RESET'); ?>
                                </span>
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('LABEL_TYPE'); ?></span>
                            <div class="ba-custom-select">
                                <input readonly="" onfocus="this.blur()" value="" type="text">
                                <input type="hidden" data-option="label_type">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value=""><?php echo Text::_('DEFAULT'); ?></li>
                                    <li data-value="constant"><?php echo Text::_('СONSTANT'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item field-constant-label-option">
                            <span><?php echo Text::_('LABEL'); ?></span>
                            <input type="text" placeholder="<?php echo Text::_('LABEL'); ?>" class="field-constant-label">
                        </div>
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('ADMIN_LABEL'); ?></span>
                            <input type="text" placeholder="<?php echo Text::_('ADMIN_LABEL'); ?>" class="field-admin-label">
                        </div>
                        <div class="ba-settings-item input-resize">
                            <span><?php echo Text::_('ADMIN_DESCRIPTION'); ?></span>
                            <input type="text" placeholder="<?php echo Text::_('ADMIN_DESCRIPTION'); ?>" class="field-admin-description">
                        </div>
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('REQUIRED'); ?></span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-option="required" class="set-value-css">
                                <span></span>
                            </label>
                        </div>
                    </div>
                    <div class="ba-settings-group field-button-options">
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('TARGET'); ?></span>
                            <div class="ba-custom-select">
                                <input readonly="" onfocus="this.blur()" value="" type="text">
                                <input type="hidden" data-option="target">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="_blank"><?php echo Text::_('NEW_WINDOW'); ?></li>
                                    <li data-value="_self"><?php echo Text::_('SAME_WINDOW'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('TYPE'); ?></span>
                            <div class="ba-custom-select">
                                <input readonly="" onfocus="this.blur()" value="" type="text">
                                <input type="hidden" data-option="download">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value=""><?php echo Text::_('DEFAULT'); ?></li>
                                    <li data-value="download"><?php echo Text::_('DOWNLOAD'); ?></li>
                                    <li data-value="mailto"><?php echo Text::_('EMAIL'); ?></li>
                                    <li data-value="tel"><?php echo Text::_('PHONE'); ?></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group overlay-button-options">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('TRIGGER'); ?>
                            </span>
                            <div class="ba-custom-select overlay-button-trigger-select">
                                <input readonly onfocus="this.blur()" type="text">
                                <input type="hidden">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="button"><?php echo Text::_('BUTTON'); ?></li>
                                    <li data-value="image"><?php echo Text::_('IMAGE'); ?></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group items-list overlay-button-options overlay-image-options">
                        <div class="sorting-container"></div>
                    </div>
                    <div class="ba-settings-group overlay-button-options overlay-image-options">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-desktop-windows"></i>
                            <span><?php echo Text::_('VIEW'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('WIDTH'); ?></span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="2500">
                                <input type="text" data-option="width" data-group="style" data-callback="sectionRules">
                            </div>
                        </div>
                        <div class="ba-settings-toolbar">
                            <label data-value="left" data-option="align" data-group="style" data-callback="sectionRules">
                                <i class="zmdi zmdi-format-align-left"></i>
                                <span class="ba-tooltip"><?php echo Text::_('LEFT'); ?></span>
                            </label>
                            <label data-value="center" data-option="align" data-group="style" data-callback="sectionRules">
                                <i class="zmdi zmdi-format-align-center"></i>
                                <span class="ba-tooltip"><?php echo Text::_('CENTER'); ?></span>
                            </label>
                            <label data-value="right" data-option="align" data-group="style" data-callback="sectionRules">
                                <i class="zmdi zmdi-format-align-right"></i>
                                <span class="ba-tooltip"><?php echo Text::_('RIGHT'); ?></span>
                            </label>
                        </div>
                    </div>
                    <div class="ba-settings-group overlay-button-options overlay-image-options">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-tune"></i>
                            <span><?php echo Text::_('CAPTION'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('TYPE'); ?>
                            </span>
                            <div class="ba-custom-select background-overlay-select">
                                <input readonly onfocus="this.blur()" type="text">
                                <input type="hidden" data-property="overlay">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="color"><?php echo Text::_('COLOR'); ?></li>
                                    <li data-value="gradient"><?php echo Text::_('GRADIENT'); ?></li>
                                    <li data-value="none"><?php echo Text::_('NO_NE'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="overlay-color-options">
                            <div class="ba-settings-item">
                                <span>
                                    <?php echo Text::_('COLOR'); ?>
                                </span>
                                <input type="text" data-type="color" data-option="color" data-group="overlay">
                                <span class="minicolors-opacity-wrapper">
                                    <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                    min="0" max="1" step="0.01">
                                    <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                                </span>
                            </div>
                        </div>
                        <div class="overlay-gradient-options">
                            <div class="ba-settings-item">
                                <span>
                                    <?php echo Text::_('EFFECT'); ?>
                                </span>
                                <div class="ba-custom-select gradient-effect-select">
                                    <input readonly onfocus="this.blur()" value="" type="text">
                                    <input type="hidden" value="" data-property="overlay">
                                    <i class="zmdi zmdi-caret-down"></i>
                                    <ul>
                                        <li data-value="linear">Linear</li>
                                        <li data-value="radial">Radial</li>
                                    </ul>
                                </div>
                            </div>
                            <div class="ba-settings-item overlay-linear-gradient">
                                <span>
                                    <?php echo Text::_('ANGLE'); ?>
                                </span>
                                <div class="ba-range-wrapper">
                                    <span class="ba-range-liner"></span>
                                    <input type="range" class="ba-range" min="0" max="360" step="1">
                                    <input type="number" data-option="angle" data-group="overlay" data-subgroup="gradient"
                                        step="1" data-callback="sectionRules">
                                </div>
                            </div>
                            <div class="ba-settings-item">
                                <span>
                                    <?php echo Text::_('START_COLOR'); ?>
                                </span>
                                <input type="text" data-type="color" data-option="color1" data-group="overlay"
                                    data-subgroup="gradient">
                                <span class="minicolors-opacity-wrapper">
                                    <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                    min="0" max="1" step="0.01">
                                    <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                                </span>
                            </div>
                            <div class="ba-settings-item">
                                <span>
                                    <?php echo Text::_('POSITION'); ?>
                                </span>
                                <div class="ba-range-wrapper">
                                    <span class="ba-range-liner"></span>
                                    <input type="range" class="ba-range" min="0" max="100" step="1">
                                    <input type="number" data-option="position1" data-group="overlay" data-subgroup="gradient"
                                        step="1" data-callback="sectionRules">
                                </div>
                            </div>
                            <div class="ba-settings-item">
                                <span>
                                    <?php echo Text::_('END_COLOR'); ?>
                                </span>
                                <input type="text" data-type="color" data-option="color2" data-group="overlay"
                                    data-subgroup="gradient">
                                <span class="minicolors-opacity-wrapper">
                                    <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                    min="0" max="1" step="0.01">
                                    <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                                </span>
                            </div>
                            <div class="ba-settings-item">
                                <span>
                                    <?php echo Text::_('POSITION'); ?>
                                </span>
                                <div class="ba-range-wrapper">
                                    <span class="ba-range-liner"></span>
                                    <input type="range" class="ba-range" min="0" max="100" step="1">
                                    <input type="number" data-option="position2" data-group="overlay" data-subgroup="gradient"
                                        step="1" data-callback="sectionRules">
                                </div>
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('EFFECT'); ?>
                            </span>
                            <div class="ba-custom-select image-item-caption-effect-select">
                                <input readonly onfocus="this.blur()" type="text">
                                <input type="hidden" data-option="effect" data-group="animation">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="ba-circle-bottom-right">Circle Bottom Right</li>
                                    <li data-value="ba-circle-top-left">Circle Top Left</li>
                                    <li data-value="ba-fade">Fade</li>
                                    <li data-value="ba-image-rotate-right">Image Rotate Right</li>
                                    <li data-value="ba-image-zoom-center">Image Zoom Center</li>
                                    <li data-value="ba-shutter-out-diagonal">Shutter Out Diagonal</li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('DURATION'); ?>
                            </span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="2" step="0.1">
                                <input type="number" data-option="duration" data-group="animation" step="0.1" data-callback="sectionRules">
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group tags-options">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('APP'); ?>
                            </span>
                            <div class="ba-custom-select tags-app-select">
                                <input readonly onfocus="this.blur()" value="" type="text">
                                <input type="hidden" value="" data-option="app">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
<?php
                                foreach ($this->apps as $value) {
                                    echo '<li data-value="'.$value->id.'">'.$value->title.'</li>';
                                }
?>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item tags-categories-list">
                            <span>
                                <?php echo Text::_('CATEGORY'); ?>
                            </span>
                            <div class="tags-categories">
                                <ul class="selected-categories">
                                    <li class="search-category">
                                        <input type="text" placeholder="<?php echo Text::_('CATEGORY'); ?>" readonly>
                                    </li>
                                </ul>
                                <ul class="all-categories-list">
<?php
                                foreach ($this->categories as $category) {
                                    $content = '';
                                    for ($i = 0; $i < $category->level; $i++) {
                                        $content .= '- ';
                                    }
                                    if ($category->level != 0) {
                                        $content .= '-';
                                    }
?>
                                    <li data-id="<?php echo $category->id; ?>" data-app="<?php echo $category->app_id; ?>"
                                        style="--content: '<?php echo $content; ?>';">
                                        <?php echo $category->title; ?>
                                    </li>
<?php
                                }
?>
                                </ul>
                            </div>
                            <label class="ba-help-icon">
                                <i class="zmdi zmdi-help"></i>
                                <span class="ba-tooltip ba-help">
                                    <?php echo Text::_('TAGS_CATEGORY_TOOLTIP'); ?>
                                </span>
                            </label>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SORT_BY'); ?>
                            </span>
                            <div class="ba-custom-select tags-display-select">
                                <input readonly="" onfocus="this.blur()" value="" type="text">
                                <input type="hidden" value="1" data-option="sorting">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="id"><?php echo Text::_('RECENT'); ?></li>
                                    <li data-value="hits"><?php echo Text::_('POPULAR'); ?></li>
                                    <li data-value="title"><?php echo Text::_('TITLE_A_Z'); ?></li>
                                    <li data-value="title DESC"><?php echo Text::_('TITLE_Z_A'); ?></li>
                                    <li data-value="random"><?php echo Text::_('RANDOM'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('MAX_ITEMS'); ?>
                            </span>
                            <input type="number" data-option="count" class="lightbox-settings-input" placeholder="5">
                        </div>
                    </div>
                    <div class="ba-settings-group counter-options counter-general">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('TARGET_NUMBER'); ?>
                            </span>
                            <input type="text" data-option="number" placeholder="<?php echo Text::_('TARGET_NUMBER'); ?>">
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('ANIMATION_SPEED'); ?>
                            </span>
                            <input type="text" data-option="speed" placeholder="<?php echo Text::_('ANIMATION_SPEED'); ?>">
                        </div>
                    </div>
                    <div class="ba-settings-group scroll-to-options">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('END_POINT'); ?>
                            </span>
                            <input type="text" readonly onfocus="this.blur()" class="select-end-point select-input"
                                placeholder="<?php echo Text::_('SELECT'); ?>">
                            <i class="zmdi zmdi-attachment-alt"></i>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('LABEL'); ?>
                            </span>
                            <input type="text" placeholder="<?php echo Text::_('LABEL'); ?>" class="button-label">
                        </div>
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('ARIA_LABEL') ?></span>
                            <input type="text" class="aria-label"
                                   placeholder="<?php echo Text::_('ARIA_LABEL') ?>">
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('ICON'); ?>
                            </span>
                            <input type="text" readonly onfocus="this.blur()" class="scroll-to-icon select-input"
                                placeholder="<?php echo Text::_('ICON'); ?>" data-group="icon" data-option="">
                            <i class="zmdi zmdi-attachment-alt"></i>
                            <div class="reset">
                                <i class="zmdi zmdi-close" data-group="icon" data-option="" data-action="sectionRules"
                                    data-callback="removeIcon"></i>
                                <span class="ba-tooltip"><?php echo Text::_('RESET'); ?></span>
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group scrolltop-options">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('ICON'); ?>
                            </span>
                            <input type="text" readonly onfocus="this.blur()" class="scrolltop-icon select-input"
                                placeholder="<?php echo Text::_('SELECT'); ?>">
                            <i class="zmdi zmdi-attachment-alt"></i>
                        </div>
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('ARIA_LABEL') ?></span>
                            <input type="text" class="aria-label"
                                   placeholder="<?php echo Text::_('ARIA_LABEL') ?>">
                        </div>
                    </div>
                    <div class="ba-settings-group scrolltop-options scroll-to-options desktop-only scrolltop-general">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-tune"></i>
                            <span><?php echo Text::_('SETTINGS'); ?></span>
                        </div>
                        <div class="ba-settings-item scrolltop-options">
                            <span>
                                <?php echo Text::_('OFFSET'); ?>
                            </span>
                            <input type="text" data-option="offset" placeholder="<?php echo Text::_('OFFSET'); ?>">
                            <label class="ba-help-icon">
                                <i class="zmdi zmdi-help"></i>
                                <span class="ba-tooltip ba-help">
                                    <?php echo Text::_('OFFSET_TOOLTIP'); ?>
                                </span>
                            </label>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SCROLLING_SPEED'); ?>
                            </span>
                            <input type="text" data-option="speed" placeholder="<?php echo Text::_('SCROLLING_SPEED'); ?>">
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('ANIMATION'); ?>
                            </span>
                            <div class="ba-custom-select scrolltop-animation-select">
                                <input readonly onfocus="this.blur()" value="" type="text" data-option="animation">
                                <input type="hidden" value="" data-option="animation">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="easeInSine">easeInSine</li>
                                    <li data-value="easeOutSine">easeOutSine</li>
                                    <li data-value="easeOutQuad">easeOutQuad</li>
                                    <li data-value="easeOutCubic">easeOutCubic</li>
                                    <li data-value="easeInQuart">easeInQuart</li>
                                    <li data-value="easeOutQuart">easeOutQuart</li>
                                    <li data-value="easeInExpo">easeInExpo</li>
                                    <li data-value="easeOutExpo">easeOutExpo</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group icon-options">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('ICON'); ?>
                            </span>
                            <input type="text" readonly onfocus="this.blur()"
                                class="reselect-icon select-input" data-action="sectionRules"
                                placeholder="<?php echo Text::_('SELECT'); ?>">
                            <i class="zmdi zmdi-attachment-alt"></i>
                        </div>
                    </div>
                    <div class="ba-settings-group button-options">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('LABEL'); ?>
                            </span>
                            <input type="text" placeholder="<?php echo Text::_('LABEL'); ?>" class="button-label">
                        </div>
                        <div class="ba-settings-item overlay-button-options">
                            <span><?php echo Text::_('ARIA_LABEL') ?></span>
                            <input type="text" class="aria-label"
                                   placeholder="<?php echo Text::_('ARIA_LABEL') ?>">
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('ICON'); ?>
                            </span>
                            <input class="select-input" type="text" readonly onfocus="this.blur()"
                                data-option="icon" data-group="icon"
                                placeholder="<?php echo Text::_('ICON'); ?>">
                            <i class="zmdi zmdi-attachment-alt"></i>
                            <div class="reset">
                                <i class="zmdi zmdi-close" data-group="icon" data-option="icon"
                                    data-action="sectionRules" data-callback="removeIcon"></i>
                                <span class="ba-tooltip">
                                    <?php echo Text::_('RESET'); ?>
                                </span>
                            </div>
                        </div>
                        <div class="ba-settings-item overlay-button-options">
                            <span>
                                <?php echo Text::_('EMBED_CODE'); ?>
                            </span>
                            <input type="text" class="button-embed-code" placeholder="<?php echo Text::_('EMBED_CODE'); ?>">
                        </div>
                    </div>
                    <div  class="ba-settings-group submit-button-options">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('ON_SUBMIT'); ?>
                            </span>
                            <div class="ba-custom-select submit-button-onsubmit-select">
                                <input readonly onfocus="this.blur()" type="text">
                                <input type="hidden" data-group="onsubmit" data-option="action">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="thank-you"><?php echo Text::_('THANK_YOU_MESSAGE'); ?></li>
                                    <li data-value="redirect"><?php echo Text::_('REDIRECT'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item thank-you-onsubmit-options">
                            <span>
                                <?php echo Text::_('MESSAGE'); ?>
                            </span>
                            <input type="text" placeholder="<?php echo Text::_('MESSAGE'); ?>" data-group="onsubmit" data-option="message">
                        </div>
                        <div class="ba-settings-item link-picker-container input-resize redirect-onsubmit-options">
                            <span>
                                <?php echo Text::_('LINK'); ?>
                            </span>
                            <input type="text" data-group="onsubmit" data-option="redirect" placeholder="<?php echo Text::_('LINK'); ?>">
                            <div class="select-link">
                                <i class="zmdi zmdi-attachment-alt"></i>
                                <span class="ba-tooltip"><?php echo Text::_('LINK_PICKER') ?></span>
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group icon-options button-options button-link-options">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-link"></i>
                            <span><?php echo Text::_('LINK'); ?></span>
                        </div>
                        <div class="ba-settings-item link-picker-container input-resize">
                            <span>
                                <?php echo Text::_('LINK'); ?>
                            </span>
                            <input type="text" data-option="link" data-group="link"
                                placeholder="<?php echo Text::_('LINK'); ?>">
                            <div class="select-link">
                                <i class="zmdi zmdi-attachment-alt"></i>
                                <span class="ba-tooltip"><?php echo Text::_('LINK_PICKER') ?></span>
                            </div>
                            <div class="select-file">
                                <i class="zmdi zmdi-file"></i>
                                <span class="ba-tooltip"><?php echo Text::_('FILE_PICKER') ?></span>
                            </div>
                            <div class="select-product-link">
                                <i class="zmdi zmdi-shopping-cart"></i>
                                <span class="ba-tooltip"><?php echo Text::_('ADD_TO_CART') ?></span>
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('ARIA_LABEL') ?></span>
                            <input type="text" class="aria-label"
                                   placeholder="<?php echo Text::_('ARIA_LABEL') ?>">
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('TARGET'); ?>
                            </span>
                            <div class="ba-custom-select link-target-select">
                                <input readonly onfocus="this.blur()" value="" type="text">
                                <input type="hidden" value="" data-option="target" data-group="link">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="_blank"><?php echo Text::_('NEW_WINDOW'); ?></li>
                                    <li data-value="_self"><?php echo Text::_('SAME_WINDOW'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('TYPE'); ?>
                            </span>
                            <div class="ba-custom-select link-type-select">
                                <input readonly onfocus="this.blur()" value="" type="text">
                                <input type="hidden" value="" data-option="type" data-group="link">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value=""><?php echo Text::_('DEFAULT'); ?></li>
                                    <li data-value="download"><?php echo Text::_('DOWNLOAD'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('EMBED_CODE'); ?>
                            </span>
                            <input type="text" class="button-embed-code" placeholder="<?php echo Text::_('EMBED_CODE'); ?>">
                        </div>
                    </div>
                    <div class="ba-settings-group countdown-options">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('TARGET_TIME'); ?>
                            </span>
                            <div class="container-icon">
                                <input type="text" id="countdown-input" class="open-calendar-dialog">
                                <div class="icons-cell" id="countdown-calendar">
                                    <i class="zmdi zmdi-calendar-alt"></i>
                                </div>
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('DISPLAY'); ?>
                            </span>
                            <div class="ba-custom-select countdown-display-select">
                                <input readonly onfocus="this.blur()" type="text" value="">
                                <input type="hidden" value="">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="full">D, H, M, S</li>
                                    <li data-value="hours">H, M, S</li>
                                    <li data-value="minutes">M, S</li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('HIDE_AFTER_COUNT'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-option="hide-after">
                                <span></span>
                            </label>
                        </div>
                    </div>
                    <div class="ba-settings-group countdown-options constants">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-label"></i>
                            <span><?php echo Text::_('LABEL'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('DAYS'); ?>
                            </span>
                            <input type="text" data-option="days" placeholder="<?php echo Text::_('DAYS'); ?>">
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('HOURS'); ?>
                            </span>
                            <input type="text" data-option="hours" placeholder="<?php echo Text::_('HOURS'); ?>">
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('MINUTES'); ?>
                            </span>
                            <input type="text" data-option="minutes" placeholder="<?php echo Text::_('MINUTES'); ?>">
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SECONDS'); ?>
                            </span>
                            <input type="text" data-option="seconds" placeholder="<?php echo Text::_('SECONDS'); ?>">
                        </div>
                    </div>
<?php
                    echo $this->html->loadPassive('disable');
?>
                    <div class="ba-settings-group">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-roller"></i>
                            <span><?php echo Text::_('PRESETS'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SELECT'); ?>
                            </span>
                            <div class="ba-lg-custom-select select-preset">
                                <input type="text" readonly onfocus="this.blur()">
                                <input type="hidden">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <div class="ba-lg-custom-select-header">
                                        <span class="create-new-preset">
                                            <i class="zmdi zmdi-plus-circle"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('SAVE_PRESET'); ?></span>
                                        </span>
                                        <span class="edit-preset-item">
                                            <i class="zmdi zmdi-edit"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('EDIT'); ?></span>
                                        </span>
                                        <span class="delete-preset-item">
                                            <i class="zmdi zmdi-delete"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('DELETE'); ?></span>
                                        </span>
                                    </div>
                                    <div class="ba-lg-custom-select-body">
                                        <li data-value="">
                                            <label>
                                                <input type="radio" name="preset-checkbox" value="">
                                                <i class="zmdi zmdi-circle-o"></i>
                                                <i class="zmdi zmdi-check"></i>
                                            </label>
                                            <span><?php echo Text::_('NO_NE'); ?></span>
                                        </li>
                                    </div>
                                </ul>
                            </div>
                        </div>
                    </div>
<?php
                    echo $this->html->loadPassive('item-animation');
                    echo $this->html->loadPassive('advanced', $this->access);
?>
                </div>
                <div id="countdown-design-options" class="row-fluid tab-pane">
                    <div class="ba-settings-group slideshow-design-group overlay-button-options overlay-image-options">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SELECT'); ?>
                            </span>
                            <div class="ba-custom-select slideshow-style-custom-select">
                                <input readonly onfocus="this.blur()" type="text" value="">
                                <input type="hidden" value="">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="title"><?php echo Text::_('TITLE'); ?></li>
                                    <li data-value="description"><?php echo Text::_('DESCRIPTION'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item title-html-tag">
                            <span>
                                <?php echo Text::_('HTML_TAG'); ?>
                            </span>
                            <div class="ba-custom-select select-title-html-tag">
                                <input readonly onfocus="this.blur()" type="text" value="">
                                <input type="hidden" value="">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="h1">H1</li>
                                    <li data-value="h2">H2</li>
                                    <li data-value="h3">H3</li>
                                    <li data-value="h4">H4</li>
                                    <li data-value="h5">H5</li>
                                    <li data-value="h6">H6</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group slideshow-typography-options overlay-button-options overlay-image-options">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-format-size"></i>
                            <span><?php echo Text::_('TYPOGRAPHY'); ?></span>
                        </div>
                        <div class="theme-typography-options">
                            <div class="typography-options">
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('FONT_FAMILY'); ?>
                                    </span>
                                    <input readonly onfocus="this.blur()" type="text" data-option="font-family" data-group=""
                                        data-subgroup="typography" data-callback="sectionRules">
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('FONT_WEIGHT'); ?>
                                    </span>
                                    <input readonly onfocus="this.blur()" type="text" data-option="font-weight" data-group=""
                                        data-subgroup="typography" data-callback="sectionRules">
                                </div>
                                <div class="ba-settings-item slideshow-typography-color">
                                    <span>
                                        <?php echo Text::_('COLOR'); ?>
                                    </span>
                                    <input type="text" data-type="color" data-option="color" data-group="" data-subgroup="typography">
                                    <span class="minicolors-opacity-wrapper">
                                        <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                        min="0" max="1" step="0.01">
                                        <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                                    </span>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('SIZE'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner"></span>
                                        <input type="range" class="ba-range" min="0" max="320">
                                        <input type="text" data-option="font-size" data-group="" data-subgroup="typography"
                                            data-callback="sectionRules">
                                    </div>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('LETTER_SPACING'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner letter-spacing"></span>
                                        <input type="range" class="ba-range" min="-10" max="10">
                                        <input type="text" data-option="letter-spacing" data-group="" data-subgroup="typography"
                                            data-callback="sectionRules">
                                    </div>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('LINE_HEIGHT'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner"></span>
                                        <input type="range" class="ba-range" min="0" max="640">
                                        <input type="text" data-option="line-height" data-group="" data-subgroup="typography"
                                            data-callback="sectionRules">
                                    </div>
                                </div>
                                <div class="ba-settings-toolbar">
                                    <label data-option="text-decoration" data-value="underline" data-group="" data-subgroup="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-underlined"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('UNDERLINE'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-transform" data-value="uppercase" data-group="" data-subgroup="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-size"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('UPPERCASE'); ?>
                                        </span>
                                    </label>
                                    <label data-option="font-style" data-value="italic" data-group="" data-subgroup="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-italic"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('ITALIC'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-align" data-value="left" data-group="" data-subgroup="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-align-left"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('LEFT'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-align" data-value="center" data-group="" data-subgroup="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-align-center"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('CENTER'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-align" data-value="right" data-group="" data-subgroup="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-align-right"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('RIGHT'); ?>
                                        </span>
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
<?php
                    $options = ['class' => 'slideshow-margin-options overlay-button-options overlay-image-options',
                        'group' => 'title', 'subgroup' => 'margin'];
                    echo $this->html->load('margin', $options);
?>
                    <div class="ba-settings-group icon-options">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SIZE'); ?>
                            </span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="320">
                                <input type="text" data-option="size" data-group="icon" data-callback="sectionRules">
                            </div>
                        </div>
                        <div class="ba-settings-toolbar">
                            <label data-option="text-align" data-value="left" data-group="icon" data-callback="sectionRules">
                                <i class="zmdi zmdi-format-align-left"></i>
                                <span class="ba-tooltip">
                                    <?php echo Text::_('LEFT'); ?>
                                </span>
                            </label>
                            <label data-option="text-align" data-value="center" data-group="icon" data-callback="sectionRules">
                                <i class="zmdi zmdi-format-align-center"></i>
                                <span class="ba-tooltip">
                                    <?php echo Text::_('CENTER'); ?>
                                </span>
                            </label>
                            <label data-option="text-align" data-value="right" data-group="icon" data-callback="sectionRules">
                                <i class="zmdi zmdi-format-align-right"></i>
                                <span class="ba-tooltip">
                                    <?php echo Text::_('RIGHT'); ?>
                                </span>
                            </label>
                        </div>
                    </div>
                    <div class="ba-settings-group scrolltop-options">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SIZE'); ?>
                            </span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="320">
                                <input type="text" data-option="size" data-group="icons" data-callback="sectionRules">
                            </div>
                        </div>
                        <div class="ba-settings-toolbar desktop-only scrolltop-options">
                            <label data-option="align" data-group="text" data-value="left" data-callback="sectionRules">
                                <i class="zmdi zmdi-format-align-left"></i>
                                <span class="ba-tooltip">
                                    <?php echo Text::_('LEFT'); ?>
                                </span>
                            </label>
                            <label data-option="align" data-group="text" data-value="right" data-callback="sectionRules">
                                <i class="zmdi zmdi-format-align-right"></i>
                                <span class="ba-tooltip">
                                    <?php echo Text::_('RIGHT'); ?>
                                </span>
                            </label>
                        </div>
                    </div>
                    <div class="ba-settings-group button-options counter-options post-tags-options tags-options scroll-to-options field-button-options">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-format-size"></i>
                            <span><?php echo Text::_('TYPOGRAPHY'); ?></span>
                        </div>
                        <div class="theme-typography-options">
                            <div class="typography-options">
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('FONT_FAMILY'); ?>
                                    </span>
                                    <input readonly onfocus="this.blur()" type="text" data-option="font-family"
                                        data-group="" data-callback="sectionRules">
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('FONT_WEIGHT'); ?>
                                    </span>
                                    <input readonly onfocus="this.blur()" type="text" data-option="font-weight"
                                        data-group="" data-callback="sectionRules">
                                </div>
                                <div class="ba-settings-item counter-options">
                                    <span>
                                        <?php echo Text::_('COLOR'); ?>
                                    </span>
                                    <input type="text" data-type="color" data-option="color" data-group="counter">
                                    <span class="minicolors-opacity-wrapper">
                                        <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                        min="0" max="1" step="0.01">
                                        <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                                    </span>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('SIZE'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner"></span>
                                        <input type="range" class="ba-range" min="0" max="320">
                                        <input type="text" data-option="font-size" data-group="" data-callback="sectionRules">
                                    </div>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('LETTER_SPACING'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner letter-spacing"></span>
                                        <input type="range" class="ba-range" min="-10" max="10">
                                        <input type="text" data-option="letter-spacing" data-group="" data-callback="sectionRules">
                                    </div>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('LINE_HEIGHT'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner"></span>
                                        <input type="range" class="ba-range" min="0" max="640">
                                        <input type="text" data-option="line-height" data-group="" data-callback="sectionRules">
                                    </div>
                                </div>
                                <div class="ba-settings-toolbar">
                                    <label data-option="text-decoration" data-value="underline" data-group="" data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-underlined"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('UNDERLINE'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-transform" data-value="uppercase" data-group="" data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-size"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('UPPERCASE'); ?>
                                        </span>
                                    </label>
                                    <label data-option="font-style" data-value="italic" data-group="" data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-italic"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('ITALIC'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-align" data-value="left" data-group="" data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-align-left"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('LEFT'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-align" data-value="center" data-group="" data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-align-center"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('CENTER'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-align" data-value="right" data-group="" data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-align-right"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('RIGHT'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-align" data-value="1" data-group="" data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-align-justify"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('FULL_WIDTH'); ?>
                                        </span>
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
<?php
                    $options = ['class' => 'icon-options button-options scrolltop-options scroll-to-options
                        post-tags-options tags-options field-button-options'];
                    echo $this->html->load('colors', $options);
?>
                    <div class="ba-settings-group button-options scroll-to-options field-button-options">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-local-florist"></i>
                            <span><?php echo Text::_('ICON'); ?></span>
                        </div>
                        <div class="ba-settings-item button-options field-button-options">
                            <span>
                                <?php echo Text::_('POSITION'); ?>
                            </span>
                            <div class="ba-custom-select button-icon-position visible-select-top">
                                <input readonly onfocus="this.blur()" value="" type="text">
                                <input type="hidden" value="" data-option="position" data-group="icon" class="set-value-css">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value=""><?php echo Text::_('BEFORE'); ?></li>
                                    <li data-value="after"><?php echo Text::_('AFTER'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item scroll-to-options">
                            <span>
                                <?php echo Text::_('POSITION'); ?>
                            </span>
                            <div class="ba-custom-select scroll-to-icon-position">
                                <input readonly onfocus="this.blur()" value="" type="text">
                                <input type="hidden" value="" data-option="position" data-group="icons" class="set-value-css">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value=""><?php echo Text::_('BEFORE'); ?></li>
                                    <li data-value="after"><?php echo Text::_('AFTER'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SIZE'); ?>
                            </span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="320">
                                <input type="text" data-option="size" data-group="icons" data-callback="sectionRules">
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group countdown-options">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-format-size"></i>
                            <span><?php echo Text::_('TYPOGRAPHY'); ?></span>
                        </div>
                        <div class="ba-settings-item ba-typography-select-wrapper">
                            <span>
                                <?php echo Text::_('TYPOGRAPHY'); ?>
                            </span>
                            <div class="ba-custom-select typography-select">
                                <input readonly onfocus="this.blur()" type="text">
                                <input type="hidden">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="counter"><?php echo Text::_('COUNTER') ?></li>
                                    <li data-value="label"><?php echo Text::_('LABEL') ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="theme-typography-options">
                            <div class="typography-options">
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('FONT_FAMILY'); ?>
                                    </span>
                                    <input readonly onfocus="this.blur()" type="text" data-option="font-family"
                                        data-group="" data-callback="sectionRules">
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('FONT_WEIGHT'); ?>
                                    </span>
                                    <input readonly onfocus="this.blur()" type="text" data-option="font-weight"
                                        data-group="" data-callback="sectionRules">
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('COLOR'); ?>
                                    </span>
                                    <input type="text" data-type="color" data-option="color" data-group="">
                                    <span class="minicolors-opacity-wrapper">
                                        <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                        min="0" max="1" step="0.01">
                                        <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                                    </span>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('SIZE'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner"></span>
                                        <input type="range" class="ba-range" min="0" max="320">
                                        <input type="text" data-option="font-size" data-group="" data-callback="sectionRules">
                                    </div>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('LETTER_SPACING'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner letter-spacing"></span>
                                        <input type="range" class="ba-range" min="-10" max="10">
                                        <input type="text" data-option="letter-spacing" data-group="" data-callback="sectionRules">
                                    </div>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('LINE_HEIGHT'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner"></span>
                                        <input type="range" class="ba-range" min="0" max="640">
                                        <input type="text" data-option="line-height" data-group="" data-callback="sectionRules">
                                    </div>
                                </div>
                                <div class="ba-settings-toolbar">
                                    <label data-option="text-decoration" data-value="underline" data-group="" data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-underlined"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('UNDERLINE'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-transform" data-value="uppercase" data-group="" data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-size"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('UPPERCASE'); ?>
                                        </span>
                                    </label>
                                    <label data-option="font-style" data-value="italic" data-group="" data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-italic"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('ITALIC'); ?>
                                        </span>
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group countdown-options counter-options">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-format-color-fill"></i>
                            <span><?php echo Text::_('BACKGROUND'); ?></span>
                        </div>
                        <div class="ba-settings-item background">
                            <span>
                                <?php echo Text::_('COLOR'); ?>
                            </span>
                            <input type="text" data-type="color" data-option="color" data-group="background" class="minicolors-top">
                            <span class="minicolors-opacity-wrapper">
                                <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                min="0" max="1" step="0.01">
                                <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                            </span>
                        </div>
                    </div>
                </div>
                <div id="countdown-layout-options" class="row-fluid tab-pane">
<?php
                    echo $this->html->loadPassive('positioning');
                    $options = ['class' => 'icon-options button-options counter-options countdown-options
                        scroll-to-options post-tags-options tags-options field-button-options'];
                    echo $this->html->load('margin', $options);
                    $options = ['class' => 'icon-options button-options scrolltop-options scroll-to-options
                        post-tags-options tags-options padding-options field-button-options'];
                    echo $this->html->load('padding', $options);
                    echo $this->html->load('border');
                    $options = ['class' => 'icon-options button-options counter-options scrolltop-options
                        scroll-to-options post-tags-options tags-options field-button-options'];
                    echo $this->html->load('shadow', $options);
?>
                </div>
                <i class="zmdi zmdi-more resize-handle-bottom"></i>
            </div>
        </div>
    </div>
</div>
<div id="hotspot-settings-dialog" class="ba-modal-cp draggable-modal-cp modal hide">
    <div class="modal-header">
        <span class="ba-dialog-title"></span>
        <div class="modal-header-icon">
            <div class="ba-custom-select select-modal-cp-position">
                <i class="zmdi zmdi-more-vert"></i>
                <input type="hidden">
                <ul>
                    <li data-value=""><?php echo Text::_('SEPARATE_WINDOW') ?></li>
                    <li data-value="right"><?php echo Text::_('PANEL_TO_RIGHT') ?></li>
                </ul>
            </div>
            <i class="zmdi zmdi-close close-cp-modal"></i>
        </div>
    </div>
    <div class="modal-body">
        <div class="general-tabs">
            <ul class="nav nav-tabs">
                <li class="active">
                    <a href="#hotspot-general-options" data-toggle="tab">
                        <i class="zmdi zmdi-settings"></i>
                        <span><?php echo Text::_('GENERAL'); ?></span>
                    </a>
                </li>
                <li>
                    <a href="#hotspot-design-options" data-toggle="tab">
                        <i class="zmdi zmdi-format-color-fill"></i>
                        <span><?php echo Text::_('DESIGN'); ?></span>
                    </a>
                </li>
                <li>
                    <a href="#hotspot-layout-options" data-toggle="tab">
                        <i class="zmdi zmdi-fullscreen"></i>
                        <span><?php echo Text::_('LAYOUT'); ?></span>
                    </a>
                </li>
            </ul>
            <div class="tabs-underline"></div>
            <div class="tab-content">
                <div id="hotspot-general-options" class="row-fluid tab-pane active">
                    <div class="ba-settings-group">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('ICON'); ?>
                            </span>
                            <input class="select-input" type="text" readonly onfocus="this.blur()"
                                data-option="icon" placeholder="<?php echo Text::_('ICON'); ?>">
                            <i class="zmdi zmdi-attachment-alt"></i>
                        </div>
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('ARIA_LABEL') ?></span>
                            <input type="text" class="aria-label"
                                   placeholder="<?php echo Text::_('ARIA_LABEL') ?>">
                        </div>
                        <div class="ba-settings-item overlay-button-options">
                            <span>
                                <?php echo Text::_('EMBED_CODE'); ?>
                            </span>
                            <input type="text" class="button-embed-code" placeholder="<?php echo Text::_('EMBED_CODE'); ?>">
                        </div>
                    </div>
                    <div class="ba-settings-group">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-skip-next"></i>
                            <span><?php echo Text::_('ANIMATION'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('EFFECT'); ?></span>
                            <div class="ba-custom-select hotspot-animation-select">
                                <input readonly onfocus="this.blur()" type="text" value="None">
                                <input type="hidden">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="">None</li>
                                    <li data-value="ba-hotspot-pulse">Pulse</li>
                                    <li data-value="ba-hotspot-rings">Rings</li>
                                    <li data-value="ba-hotspot-bouncing-pulse">Bouncing Pulse</li>
                                    <li data-value="ba-hotspot-easy-pulse">Easy Pulse</li>
                                    <li data-value="ba-hotspot-bouncing-out-pulse">Bouncing Out Pulse</li>
                                </ul>
                            </div>
                        </div>
                    </div>
<?php
                    echo $this->html->loadPassive('disable');
?>
                    <div class="ba-settings-group">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-roller"></i>
                            <span><?php echo Text::_('PRESETS'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SELECT'); ?>
                            </span>
                            <div class="ba-lg-custom-select select-preset">
                                <input type="text" readonly onfocus="this.blur()">
                                <input type="hidden">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <div class="ba-lg-custom-select-header">
                                        <span class="create-new-preset">
                                            <i class="zmdi zmdi-plus-circle"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('SAVE_PRESET'); ?></span>
                                        </span>
                                        <span class="edit-preset-item">
                                            <i class="zmdi zmdi-edit"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('EDIT'); ?></span>
                                        </span>
                                        <span class="delete-preset-item">
                                            <i class="zmdi zmdi-delete"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('DELETE'); ?></span>
                                        </span>
                                    </div>
                                    <div class="ba-lg-custom-select-body">
                                        <li data-value="">
                                            <label>
                                                <input type="radio" name="preset-checkbox" value="">
                                                <i class="zmdi zmdi-circle-o"></i>
                                                <i class="zmdi zmdi-check"></i>
                                            </label>
                                            <span><?php echo Text::_('NO_NE'); ?></span>
                                        </li>
                                    </div>
                                </ul>
                            </div>
                        </div>
                    </div>
<?php
                    echo $this->html->loadPassive('item-animation');
                    echo $this->html->loadPassive('advanced', $this->access);
?>
                </div>
                <div id="hotspot-design-options" class="row-fluid tab-pane">
                    <div class="ba-settings-group">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SELECT'); ?>
                            </span>
                            <div class="ba-custom-select hotspot-options-select">
                                <input readonly onfocus="this.blur()" type="text">
                                <input type="hidden">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="icon"><?php echo Text::_('ICON'); ?></li>
                                    <li data-value="popover"><?php echo Text::_('POPOVER'); ?></li>
                                </ul>
                            </div>
                        </div>
                    </div>
<?php
                    $options = ['class' => 'hotspot-icon-options'];
                    echo $this->html->load('colors', $options);
?>
                    <div class="ba-settings-group hotspot-icon-options">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-local-florist"></i>
                            <span><?php echo Text::_('ICON'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SIZE'); ?>
                            </span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="320">
                                <input type="text" data-option="size" data-group="style" data-callback="sectionRules">
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group hotspot-popover-options">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('DISPLAY'); ?>
                            </span>
                            <div class="ba-custom-select hotspot-display-select">
                                <input readonly onfocus="this.blur()" type="text">
                                <input type="hidden">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="hover"><?php echo Text::_('ON_HOVER'); ?></li>
                                    <li data-value=""><?php echo Text::_('ON_CLICK'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('POSITION'); ?>
                            </span>
                            <div class="ba-custom-select hotspot-position-select">
                                <input readonly onfocus="this.blur()" type="text">
                                <input type="hidden">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="top"><?php echo Text::_('TOP'); ?></li>
                                    <li data-value="right"><?php echo Text::_('RIGHT'); ?></li>
                                    <li data-value="bottom"><?php echo Text::_('BOTTOM'); ?></li>
                                    <li data-value="left"><?php echo Text::_('LEFT'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('BACKGROUND'); ?>
                            </span>
                            <input type="text" data-type="color" data-option="color"
                                data-subgroup="background" data-group="popover">
                            <span class="minicolors-opacity-wrapper">
                                <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                min="0" max="1" step="0.01">
                                <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                            </span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('WIDTH'); ?>
                            </span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="1000">
                                <input type="text" data-option="width" data-subgroup="style"
                                    data-group="popover" data-callback="sectionRules">
                            </div>
                        </div>
                    </div>
<?php
                    $options = ['class' => 'hotspot-popover-options', 'group' => 'popover', 'subgroup' => 'padding'];
                    echo $this->html->load('padding', $options);
                    $options = ['class' => 'hotspot-popover-options', 'group' => 'popover', 'subgroup' => 'border'];
                    echo $this->html->load('border', $options);
                    $options = ['class' => 'hotspot-popover-options', 'group' => 'popover', 'subgroup' => 'shadow'];
                    echo $this->html->load('shadow', $options);
?>
                </div>
                <div id="hotspot-layout-options" class="row-fluid tab-pane">
<?php
                    echo $this->html->loadPassive('positioning');
                    echo $this->html->load('margin');
                    echo $this->html->load('padding');
                    echo $this->html->load('border');
                    echo $this->html->load('shadow');
?>
                </div>
                <i class="zmdi zmdi-more resize-handle-bottom"></i>
            </div>
        </div>
    </div>
</div>
<div id="social-icons-settings-dialog" class="ba-modal-cp draggable-modal-cp modal hide">
    <div class="modal-header">
        <span class="ba-dialog-title"></span>
        <div class="modal-header-icon">
            <div class="ba-custom-select select-modal-cp-position">
                <i class="zmdi zmdi-more-vert"></i>
                <input type="hidden">
                <ul>
                    <li data-value=""><?php echo Text::_('SEPARATE_WINDOW') ?></li>
                    <li data-value="right"><?php echo Text::_('PANEL_TO_RIGHT') ?></li>
                </ul>
            </div>
            <i class="zmdi zmdi-close close-cp-modal"></i>
        </div>
    </div>
    <div class="modal-body">
        <div class="general-tabs">
            <ul class="nav nav-tabs">
                <li class="active">
                    <a href="#social-icons-general-options" data-toggle="tab">
                        <i class="zmdi zmdi-settings"></i>
                        <span><?php echo Text::_('GENERAL'); ?></span>
                    </a>
                </li>
                <li>
                    <a href="#social-icons-design-options" data-toggle="tab">
                        <i class="zmdi zmdi-format-color-fill"></i>
                        <span><?php echo Text::_('DESIGN'); ?></span>
                    </a>
                </li>
                <li>
                    <a href="#social-icons-layout-options" data-toggle="tab">
                        <i class="zmdi zmdi-fullscreen"></i>
                        <span><?php echo Text::_('LAYOUT'); ?></span>
                    </a>
                </li>
            </ul>
            <div class="tabs-underline"></div>
            <div class="tab-content">
                <div id="social-icons-general-options" class="row-fluid tab-pane active">
<?php
                    include $htmlPath.'ba-settings-group-items-list.php';
                    echo $this->html->loadPassive('disable');
?>
                    <div class="ba-settings-group">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-roller"></i>
                            <span><?php echo Text::_('PRESETS'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SELECT'); ?>
                            </span>
                            <div class="ba-lg-custom-select select-preset">
                                <input type="text" readonly onfocus="this.blur()">
                                <input type="hidden">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <div class="ba-lg-custom-select-header">
                                        <span class="create-new-preset">
                                            <i class="zmdi zmdi-plus-circle"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('SAVE_PRESET'); ?></span>
                                        </span>
                                        <span class="edit-preset-item">
                                            <i class="zmdi zmdi-edit"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('EDIT'); ?></span>
                                        </span>
                                        <span class="delete-preset-item">
                                            <i class="zmdi zmdi-delete"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('DELETE'); ?></span>
                                        </span>
                                    </div>
                                    <div class="ba-lg-custom-select-body">
                                        <li data-value="">
                                            <label>
                                                <input type="radio" name="preset-checkbox" value="">
                                                <i class="zmdi zmdi-circle-o"></i>
                                                <i class="zmdi zmdi-check"></i>
                                            </label>
                                            <span><?php echo Text::_('NO_NE'); ?></span>
                                        </li>
                                    </div>
                                </ul>
                            </div>
                        </div>
                    </div>
<?php
                    echo $this->html->loadPassive('item-animation');
                    echo $this->html->loadPassive('advanced', $this->access);
?>
                </div>
                <div id="social-icons-design-options" class="row-fluid tab-pane">
                    <div class="ba-settings-group">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SIZE'); ?>
                            </span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="320">
                                <input type="text" data-option="size" data-group="icon" data-callback="sectionRules">
                            </div>
                        </div>
                        <div class="ba-settings-toolbar">
                            <label data-option="text-align" data-value="left" data-group="icon" data-callback="sectionRules">
                                <i class="zmdi zmdi-format-align-left"></i>
                                <span class="ba-tooltip">
                                    <?php echo Text::_('LEFT'); ?>
                                </span>
                            </label>
                            <label data-option="text-align" data-value="center" data-group="icon" data-callback="sectionRules">
                                <i class="zmdi zmdi-format-align-center"></i>
                                <span class="ba-tooltip">
                                    <?php echo Text::_('CENTER'); ?>
                                </span>
                            </label>
                            <label data-option="text-align" data-value="right" data-group="icon" data-callback="sectionRules">
                                <i class="zmdi zmdi-format-align-right"></i>
                                <span class="ba-tooltip">
                                    <?php echo Text::_('RIGHT'); ?>
                                </span>
                            </label>
                        </div>
                    </div>
<?php
                    echo $this->html->load('colors');
?>
                </div>
                <div id="social-icons-layout-options" class="row-fluid tab-pane">
<?php
                    echo $this->html->loadPassive('positioning');
                    echo $this->html->load('margin');
                    echo $this->html->load('padding');
                    echo $this->html->load('border');
?>
                </div>
                <i class="zmdi zmdi-more resize-handle-bottom"></i>
            </div>
        </div>
    </div>
</div>
<div id="weather-settings-dialog" class="ba-modal-cp draggable-modal-cp modal hide">
    <div class="modal-header">
        <span class="ba-dialog-title"></span>
        <div class="modal-header-icon">
            <div class="ba-custom-select select-modal-cp-position">
                <i class="zmdi zmdi-more-vert"></i>
                <input type="hidden">
                <ul>
                    <li data-value=""><?php echo Text::_('SEPARATE_WINDOW') ?></li>
                    <li data-value="right"><?php echo Text::_('PANEL_TO_RIGHT') ?></li>
                </ul>
            </div>
            <i class="zmdi zmdi-close close-cp-modal"></i>
        </div>
    </div>
    <div class="modal-body">
        <div class="general-tabs">
            <ul class="nav nav-tabs">
                <li class="active">
                    <a href="#weather-general-options" data-toggle="tab">
                        <i class="zmdi zmdi-settings"></i>
                        <span><?php echo Text::_('GENERAL'); ?></span>
                    </a>
                </li>
                <li>
                    <a href="#weather-design-options" data-toggle="tab">
                        <i class="zmdi zmdi-format-color-fill"></i>
                        <span><?php echo Text::_('DESIGN'); ?></span>
                    </a>
                </li>
                <li>
                    <a href="#weather-layout-options" data-toggle="tab">
                        <i class="zmdi zmdi-fullscreen"></i>
                        <span><?php echo Text::_('LAYOUT'); ?></span>
                    </a>
                </li>
            </ul>
            <div class="tabs-underline"></div>
            <div class="tab-content">
                <div id="weather-general-options" class="row-fluid tab-pane active">
                    <div class="ba-settings-group weather-options">
                        <div class="ba-settings-item">
                            <span>
                                OpenWeatherMap API Key
                            </span>
<?php
                            echo $this->html->load('integrations', $this->integrations->openweathermap);
?>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('ENTER_LOCATION'); ?>
                            </span>
                            <input type="text" placeholder="<?php echo Text::_('ENTER_LOCATION'); ?>" class="weather-location">
                            <label class="ba-help-icon">
                                <i class="zmdi zmdi-help"></i>
                                <span class="ba-tooltip ba-help">
                                    <?php echo Text::_('WEATHER_LOCATION_TOOLTIP'); ?>
                                </span>
                            </label>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('LOCATION_NAME'); ?>
                            </span>
                            <input type="text" placeholder="<?php echo Text::_('LOCATION_NAME'); ?>" class="weather-location-name">
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('UNIT'); ?>
                            </span>
                            <div class="ba-custom-select weather-unit-select">
                                <input readonly onfocus="this.blur()" type="text" value="">
                                <input type="hidden" value="">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="c"><?php echo Text::_('CELSIUS'); ?></li>
                                    <li data-value="f"><?php echo Text::_('FAHRENHEIT'); ?></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group error-message-options">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-desktop-windows"></i>
                            <span><?php echo Text::_('VIEW'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('ERROR_CODE'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-option="code" data-group="view"
                                    class="set-desktop-view-value">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('ERROR_MESSAGE'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-option="message" data-group="view"
                                    class="set-desktop-view-value">
                                <span></span>
                            </label>
                        </div>
                    </div>
                    <div class="ba-settings-group weather-options">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-desktop-windows"></i>
                            <span><?php echo Text::_('VIEW'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('FORECAST'); ?>
                            </span>
                            <div class="ba-custom-select weather-forecast-select">
                                <input readonly onfocus="this.blur()" type="text" value="">
                                <input type="hidden">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="0"><?php echo Text::_('NO_NE'); ?></li>
                                    <li data-value="1">1 <?php echo Text::_('DAY'); ?></li>
                                    <li data-value="2">2 <?php echo Text::_('DAYS'); ?></li>
                                    <li data-value="3">3 <?php echo Text::_('DAYS'); ?></li>
                                    <li data-value="4">4 <?php echo Text::_('DAYS'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('LAYOUT'); ?>
                            </span>
                            <div class="ba-custom-select weather-layout-select">
                                <input readonly onfocus="this.blur()" type="text" value="">
                                <input type="hidden">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="forecast-block"><?php echo Text::_('BLOCK'); ?></li>
                                    <li data-value="forecast-list"><?php echo Text::_('LIST'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('WIND'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-option="wind" data-group="view"
                                    class="weather-view set-desktop-view-value">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('HUMIDITY'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-option="humidity" data-group="view"
                                    class="weather-view set-desktop-view-value">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('PRESSURE'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-option="pressure" data-group="view"
                                    class="weather-view set-desktop-view-value">
                                <span></span>
                            </label>
                        </div>
                    </div>
<?php
                    echo $this->html->loadPassive('disable');
?>
                    <div class="ba-settings-group weather-options">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-roller"></i>
                            <span><?php echo Text::_('PRESETS'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SELECT'); ?>
                            </span>
                            <div class="ba-lg-custom-select select-preset">
                                <input type="text" readonly onfocus="this.blur()">
                                <input type="hidden">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <div class="ba-lg-custom-select-header">
                                        <span class="create-new-preset">
                                            <i class="zmdi zmdi-plus-circle"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('SAVE_PRESET'); ?></span>
                                        </span>
                                        <span class="edit-preset-item">
                                            <i class="zmdi zmdi-edit"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('EDIT'); ?></span>
                                        </span>
                                        <span class="delete-preset-item">
                                            <i class="zmdi zmdi-delete"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('DELETE'); ?></span>
                                        </span>
                                    </div>
                                    <div class="ba-lg-custom-select-body">
                                        <li data-value="">
                                            <label>
                                                <input type="radio" name="preset-checkbox" value="">
                                                <i class="zmdi zmdi-circle-o"></i>
                                                <i class="zmdi zmdi-check"></i>
                                            </label>
                                            <span><?php echo Text::_('NO_NE'); ?></span>
                                        </li>
                                    </div>
                                </ul>
                            </div>
                        </div>
                    </div>
<?php
                    echo $this->html->loadPassive('item-animation');
                    echo $this->html->loadPassive('advanced', $this->access);
?>
                </div>
                <div id="weather-design-options" class="row-fluid tab-pane">
                    <div class="ba-settings-group error-message-options">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-format-size"></i>
                            <span><?php echo Text::_('TYPOGRAPHY'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('TYPOGRAPHY'); ?>
                            </span>
                            <div class="ba-custom-select 404-typography-select">
                                <input readonly onfocus="this.blur()" type="text">
                                <input type="hidden">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="code"><?php echo Text::_('ERROR_CODE') ?></li>
                                    <li data-value="message"><?php echo Text::_('ERROR_MESSAGE') ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="theme-typography-options">
                            <div class="typography-options">
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('FONT_FAMILY'); ?>
                                    </span>
                                    <input readonly onfocus="this.blur()" type="text" data-option="font-family" data-group=""
                                        data-subgroup="typography" data-callback="sectionRules">
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('FONT_WEIGHT'); ?>
                                    </span>
                                    <input readonly onfocus="this.blur()" type="text" data-option="font-weight" data-group=""
                                        data-subgroup="typography" data-callback="sectionRules">
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('COLOR'); ?>
                                    </span>
                                    <input type="text" data-type="color" data-option="color" data-group="" data-subgroup="typography">
                                    <span class="minicolors-opacity-wrapper">
                                        <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                        min="0" max="1" step="0.01">
                                        <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                                    </span>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('SIZE'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner"></span>
                                        <input type="range" class="ba-range" min="0" max="320">
                                        <input type="text" data-option="font-size" data-group="" data-subgroup="typography"
                                            data-callback="sectionRules">
                                    </div>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('LETTER_SPACING'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner letter-spacing"></span>
                                        <input type="range" class="ba-range" min="-10" max="10">
                                        <input type="text" data-option="letter-spacing" data-group="" data-subgroup="typography"
                                            data-callback="sectionRules">
                                    </div>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('LINE_HEIGHT'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner"></span>
                                        <input type="range" class="ba-range" min="0" max="640">
                                        <input type="text" data-option="line-height" data-group="" data-subgroup="typography"
                                            data-callback="sectionRules">
                                    </div>
                                </div>
                                <div class="ba-settings-toolbar">
                                    <label data-option="text-decoration" data-value="underline" data-group="" data-subgroup="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-underlined"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('UNDERLINE'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-transform" data-value="uppercase" data-group="" data-subgroup="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-size"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('UPPERCASE'); ?>
                                        </span>
                                    </label>
                                    <label data-option="font-style" data-value="italic" data-group="" data-subgroup="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-italic"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('ITALIC'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-align" data-value="left" data-group="" data-subgroup="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-align-left"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('LEFT'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-align" data-value="center" data-group="" data-subgroup="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-align-center"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('CENTER'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-align" data-value="right" data-group="" data-subgroup="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-align-right"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('RIGHT'); ?>
                                        </span>
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
<?php
                    $options = ['class' => 'error-message-options', 'group' => '', 'subgroup' => 'margin'];
                    echo $this->html->load('margin', $options);
?>
                    <div class="ba-settings-group weather-options">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-format-size"></i>
                            <span><?php echo Text::_('TYPOGRAPHY'); ?></span>
                        </div>
                        <div class="ba-settings-item ba-typography-select-wrapper">
                            <span>
                                <?php echo Text::_('TYPOGRAPHY'); ?>
                            </span>
                            <div class="ba-custom-select typography-select">
                                <input readonly onfocus="this.blur()" type="text">
                                <input type="hidden">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="city"><?php echo Text::_('CITY') ?></li>
                                    <li data-value="condition"><?php echo Text::_('CONDITION') ?></li>
                                    <li data-value="info"><?php echo Text::_('INFO') ?></li>
                                    <li data-value="forecasts"><?php echo Text::_('FORECAST') ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="theme-typography-options">
                            <div class="typography-options">
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('FONT_FAMILY'); ?>
                                    </span>
                                    <input readonly onfocus="this.blur()" type="text" data-option="font-family"
                                        data-group="" data-callback="sectionRules">
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('FONT_WEIGHT'); ?>
                                    </span>
                                    <input readonly onfocus="this.blur()" type="text" data-option="font-weight"
                                        data-group="" data-callback="sectionRules">
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('COLOR'); ?>
                                    </span>
                                    <input type="text" data-type="color" data-option="color" data-group="">
                                    <span class="minicolors-opacity-wrapper">
                                        <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                        min="0" max="1" step="0.01">
                                        <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                                    </span>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('SIZE'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner"></span>
                                        <input type="range" class="ba-range" min="0" max="320">
                                        <input type="text" data-option="font-size" data-group="" data-callback="sectionRules">
                                    </div>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('LETTER_SPACING'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner letter-spacing"></span>
                                        <input type="range" class="ba-range" min="-10" max="10">
                                        <input type="text" data-option="letter-spacing" data-group="" data-callback="sectionRules">
                                    </div>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('LINE_HEIGHT'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner"></span>
                                        <input type="range" class="ba-range" min="0" max="640">
                                        <input type="text" data-option="line-height" data-group="" data-callback="sectionRules">
                                    </div>
                                </div>
                                <div class="ba-settings-toolbar">
                                    <label data-option="text-decoration" data-value="underline" data-group="" data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-underlined"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('UNDERLINE'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-transform" data-value="uppercase" data-group="" data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-size"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('UPPERCASE'); ?>
                                        </span>
                                    </label>
                                    <label data-option="font-style" data-value="italic" data-group="" data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-italic"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('ITALIC'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-align" data-value="left" data-group="" data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-align-left"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('LEFT'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-align" data-value="center" data-group="" data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-align-center"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('CENTER'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-align" data-value="right" data-group="" data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-align-right"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('RIGHT'); ?>
                                        </span>
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div id="weather-layout-options" class="row-fluid tab-pane">
<?php
                    echo $this->html->loadPassive('positioning');
                    echo $this->html->load('margin');
?>
                </div>
                <i class="zmdi zmdi-more resize-handle-bottom"></i>
            </div>
        </div>
    </div>
</div>
<div id="menu-settings-dialog" class="ba-modal-cp draggable-modal-cp modal hide">
    <div class="modal-header">
        <span class="ba-dialog-title"></span>
        <div class="modal-header-icon">
            <div class="ba-custom-select select-modal-cp-position">
                <i class="zmdi zmdi-more-vert"></i>
                <input type="hidden">
                <ul>
                    <li data-value=""><?php echo Text::_('SEPARATE_WINDOW') ?></li>
                    <li data-value="right"><?php echo Text::_('PANEL_TO_RIGHT') ?></li>
                </ul>
            </div>
            <i class="zmdi zmdi-close close-cp-modal"></i>
        </div>
    </div>
    <div class="modal-body">
        <div class="general-tabs">
            <ul class="nav nav-tabs">
                <li class="active">
                    <a href="#menu-general-options" data-toggle="tab">
                        <i class="zmdi zmdi-settings"></i>
                        <span><?php echo Text::_('GENERAL'); ?></span>
                    </a>
                </li>
                <li>
                    <a href="#menu-design-options" data-toggle="tab">
                        <i class="zmdi zmdi-format-color-fill"></i>
                        <span><?php echo Text::_('DESIGN'); ?></span>
                    </a>
                </li>
                <li>
                    <a href="#menu-layout-options" data-toggle="tab">
                        <i class="zmdi zmdi-fullscreen"></i>
                        <span><?php echo Text::_('LAYOUT'); ?></span>
                    </a>
                </li>
                <li>
                    <a href="#menu-mobile-options" data-toggle="tab">
                        <i class="zmdi zmdi-devices"></i>
                        <span><?php echo Text::_('MOBILE'); ?></span>
                    </a>
                </li>
            </ul>
            <div class="tabs-underline"></div>
            <div class="tab-content">
                <div id="menu-general-options" class="row-fluid tab-pane active">
                    <div class="one-page-options">
<?php
                    include $htmlPath.'ba-settings-group-items-list.php';
?>
                    </div>
                    <div class="menu-options">
<?php
                    include $htmlPath.'ba-settings-group-menu-items-list.php';
?>
                    </div>
                    <div class="ba-settings-group">
                        <div class="settings-group-title one-page-options">
                            <i class="zmdi zmdi-tune"></i>
                            <span><?php echo Text::_('SETTINGS'); ?></span>
                        </div>
                        <div class="ba-settings-item menu-options">
                            <span>
                                <?php echo Text::_('SELECT'); ?>
                            </span>
                            <input type="text" class="select-input select-mainmenu" readonly onfocus="this.blur()"
                                placeholder="<?php echo Text::_('SELECT'); ?>">
                            <i class="zmdi zmdi-attachment-alt"></i>
                        </div>
                        <div class="ba-settings-item one-page-options">
                            <span>
                                <?php echo Text::_('TYPE'); ?>
                            </span>
                            <div class="ba-custom-select select-one-page-type">
                                <input readonly onfocus="this.blur()" type="text">
                                <input type="hidden">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value=""><?php echo Text::_('CLASSIC'); ?></li>
                                    <li data-value="side-navigation-menu"><?php echo Text::_('SIDE_NAVIGATION'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item menu-layout-option">
                            <span>
                                <?php echo Text::_('LAYOUT'); ?>
                            </span>
                            <div class="ba-custom-select menu-layout-custom-select">
                                <input readonly onfocus="this.blur()" type="text" value="">
                                <input type="hidden" data-option="layout" data-group="layout">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value=""><?php echo Text::_('HORIZONTAL'); ?></li>
                                    <li data-value="vertical-menu"><?php echo Text::_('VERTICAL'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item submenu-layout-option">
                            <span>
                                <?php echo Text::_('SUBMENU'); ?>
                            </span>
                            <div class="ba-custom-select submenu-layout-custom-select">
                                <input readonly onfocus="this.blur()" type="text">
                                <input type="hidden">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value=""><?php echo Text::_('DROPDOWN'); ?></li>
                                    <li data-value="collapsible"><?php echo Text::_('COLLAPSIBLE'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item one-page-options">
                            <span>
                                <?php echo Text::_('AUTOSCROLL'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-group="autoscroll" data-option="enable">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item one-page-options">
                            <span>
                                <?php echo Text::_('SCROLLING_SPEED'); ?>
                            </span>
                            <input type="text" data-group="autoscroll" data-option="speed" class="set-value-css"
                                placeholder="<?php echo Text::_('SCROLLING_SPEED'); ?>">
                        </div>
                        <div class="ba-settings-item one-page-options">
                            <span>
                                <?php echo Text::_('ANIMATION'); ?>
                            </span>
                            <div class="ba-custom-select one-page-animation-select">
                                <input readonly onfocus="this.blur()" value="" type="text" data-option="animation">
                                <input type="hidden" class="set-value-css" data-group="autoscroll" data-option="animation">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="easeInSine">easeInSine</li>
                                    <li data-value="easeOutSine">easeOutSine</li>
                                    <li data-value="easeOutQuad">easeOutQuad</li>
                                    <li data-value="easeOutCubic">easeOutCubic</li>
                                    <li data-value="easeInQuart">easeInQuart</li>
                                    <li data-value="easeOutQuart">easeOutQuart</li>
                                    <li data-value="easeInExpo">easeInExpo</li>
                                    <li data-value="easeOutExpo">easeOutExpo</li>
                                </ul>
                            </div>
                        </div>
                    </div>
<?php
                    echo $this->html->loadPassive('disable');
?>
                    <div class="ba-settings-group">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-roller"></i>
                            <span><?php echo Text::_('PRESETS'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SELECT'); ?>
                            </span>
                            <div class="ba-lg-custom-select select-preset">
                                <input type="text" readonly onfocus="this.blur()">
                                <input type="hidden">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <div class="ba-lg-custom-select-header">
                                        <span class="create-new-preset">
                                            <i class="zmdi zmdi-plus-circle"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('SAVE_PRESET'); ?></span>
                                        </span>
                                        <span class="edit-preset-item">
                                            <i class="zmdi zmdi-edit"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('EDIT'); ?></span>
                                        </span>
                                        <span class="delete-preset-item">
                                            <i class="zmdi zmdi-delete"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('DELETE'); ?></span>
                                        </span>
                                    </div>
                                    <div class="ba-lg-custom-select-body">
                                        <li data-value="">
                                            <label>
                                                <input type="radio" name="preset-checkbox" value="">
                                                <i class="zmdi zmdi-circle-o"></i>
                                                <i class="zmdi zmdi-check"></i>
                                            </label>
                                            <span><?php echo Text::_('NO_NE'); ?></span>
                                        </li>
                                    </div>
                                </ul>
                            </div>
                        </div>
                    </div>
<?php
                    echo $this->html->loadPassive('item-animation');
                    echo $this->html->loadPassive('advanced', $this->access);
?>
                </div>
                <div id="menu-design-options" class="row-fluid tab-pane">
                    <div class="ba-settings-group menu-options">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SELECT'); ?>
                            </span>
                            <div class="ba-custom-select menu-style-custom-select">
                                <input readonly onfocus="this.blur()" type="text" value="">
                                <input type="hidden" value="">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="nav-menu"><?php echo Text::_('NAVIGATION'); ?></li>
                                    <li data-value="dropdown" class="desktop-only"><?php echo Text::_('DROPDOWN'); ?></li>
                                    <li data-value="sub-menu"><?php echo Text::_('SUBMENU'); ?></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group nav-menu-options sub-menu-options">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-format-size"></i>
                            <span><?php echo Text::_('TYPOGRAPHY'); ?></span>
                        </div>
                        <div class="theme-typography-options">
                            <div class="typography-options">
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('FONT_FAMILY'); ?>
                                    </span>
                                    <input readonly onfocus="this.blur()" type="text" data-option="font-family"
                                        data-group="" data-callback="sectionRules">
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('FONT_WEIGHT'); ?>
                                    </span>
                                    <input readonly onfocus="this.blur()" type="text" data-option="font-weight"
                                        data-group="" data-callback="sectionRules">
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('SIZE'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner"></span>
                                        <input type="range" class="ba-range" min="0" max="320">
                                        <input type="text" data-option="font-size" data-group="" data-callback="sectionRules">
                                    </div>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('LETTER_SPACING'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner letter-spacing"></span>
                                        <input type="range" class="ba-range" min="-10" max="10">
                                        <input type="text" data-option="letter-spacing" data-group="" data-callback="sectionRules">
                                    </div>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('LINE_HEIGHT'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner"></span>
                                        <input type="range" class="ba-range" min="0" max="640">
                                        <input type="text" data-option="line-height" data-group="" data-callback="sectionRules">
                                    </div>
                                </div>
                                <div class="ba-settings-toolbar">
                                    <label data-option="text-decoration" data-value="underline" data-group="" data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-underlined"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('UNDERLINE'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-transform" data-value="uppercase" data-group="" data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-size"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('UPPERCASE'); ?>
                                        </span>
                                    </label>
                                    <label data-option="font-style" data-value="italic" data-group="" data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-italic"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('ITALIC'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-align" data-value="left" data-group="" data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-align-left"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('LEFT'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-align" data-value="center" data-group="" data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-align-center"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('CENTER'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-align" data-value="right" data-group="" data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-align-right"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('RIGHT'); ?>
                                        </span>
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group nav-menu-options sub-menu-options">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-local-florist"></i>
                            <span><?php echo Text::_('ICON'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SIZE'); ?>
                            </span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="320">
                                <input type="text" data-option="size" data-group="nav" data-subgroup="icon" data-callback="sectionRules">
                            </div>
                        </div>
                    </div>
<?php
                    $options = ['class' => 'nav-menu-options sub-menu-options', 'group' => 'nav',
                        'subgroup' => 'colors', 'states' => ['active']];
                    echo $this->html->load('colors', $options);
                    $options = ['class' => 'nav-menu-options', 'group' => 'nav', 'subgroup' => 'margin',
                        'keys' => ['right', 'left'], 'states' => ['active']];
                    echo $this->html->load('margin', $options);
?>
                    <div class="ba-settings-group dropdown-options">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-format-color-fill"></i>
                            <span><?php echo Text::_('BACKGROUND'); ?></span>
                        </div>
                        <div class="ba-settings-item background">
                            <span>
                                <?php echo Text::_('COLOR'); ?>
                            </span>
                            <input type="text" data-type="color" data-group="background" data-option="color">
                            <span class="minicolors-opacity-wrapper">
                                <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                min="0" max="1" step="0.01">
                                <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                            </span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('WIDTH'); ?>
                            </span>
                            <div class="ba-range-wrapper image-width">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="1000">
                                <input type="text" data-option="width" data-group="dropdown" data-callback="sectionRules">
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group dropdown-options">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-skip-next"></i>
                            <span><?php echo Text::_('ANIMATION'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('EFFECT'); ?></span>
                            <div class="ba-custom-select dropdown-menu-animation">
                                <input readonly onfocus="this.blur()" type="text" value="None">
                                <input type="hidden" value="" data-option="effect" data-group="dropdown" data-subgroup="animation">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="bounceIn">Bounce In</li>
                                    <li data-value="bounceInLeft">Bounce In Left</li>
                                    <li data-value="bounceInRight">Bounce In Right</li>
                                    <li data-value="bounceInUp">Bounce In Up</li>
                                    <li data-value="fadeIn">Fade In</li>
                                    <li data-value="fadeInLeft">Fade In Left</li>
                                    <li data-value="fadeInRight">Fade In Right</li>
                                    <li data-value="fadeInUp">Fade In Up</li>
                                    <li data-value="zoomIn">Zoom In</li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('DURATION'); ?></span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="2" step="0.1">
                                <input type="number" data-option="duration" data-group="dropdown" data-subgroup="animation"
                                    step="0.1" data-callback="sectionRules">
                            </div>
                        </div>
                    </div>
<?php
                    $options = ['group' => 'nav', 'subgroup' => 'padding', 'states' => ['active']];
                    echo $this->html->load('padding', $options);
                    $options = ['group' => 'nav', 'subgroup' => 'border', 'states' => ['active']];
                    echo $this->html->load('border', $options);
                    $options = ['class' => 'dropdown-options'];
                    echo $this->html->load('shadow', $options);
?>
                </div>
                <div id="menu-layout-options" class="row-fluid tab-pane">
<?php
                    echo $this->html->loadPassive('positioning');
                    echo $this->html->load('margin');
?>
                </div>
                <div id="menu-mobile-options" class="row-fluid tab-pane">
                    <div class="ba-settings-group">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('ENABLE'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-group="hamburger" data-option="enable">
                                <span></span>
                            </label>
                            <label class="ba-help-icon">
                                <i class="zmdi zmdi-help"></i>
                                <span class="ba-tooltip ba-help">
                                    <?php echo Text::_('HAMBURGER_MENU_TOOLTIP'); ?>
                                </span>
                            </label>
                        </div>
                        <div class="ba-settings-item menu-options">
                            <span>
                                <?php echo Text::_('COLLAPSE_SUBMENU'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-group="hamburger" data-option="collapse">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('POSITION'); ?>
                            </span>
                            <div class="ba-custom-select menu-position-select">
                                <input readonly onfocus="this.blur()" value="" type="text">
                                <input type="hidden" value="">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="ba-menu-position-left"><?php echo Text::_('LEFT'); ?></li>
                                    <li data-value="ba-menu-position-center"><?php echo Text::_('CENTER'); ?></li>
                                    <li data-value=""><?php echo Text::_('RIGHT'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item hamburger-width-options">
                            <span>
                                <?php echo Text::_('WIDTH'); ?>
                            </span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="1000">
                                <input type="text" data-option="width" data-group="hamburger" data-callback="sectionRules">
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group">
                        <div class="settings-group-title">
                            <span><?php echo Text::_('ICON_OPEN'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('ICON'); ?>
                            </span>
                            <input class="select-input" type="text" readonly onfocus="this.blur()"
                                data-group="hamburger" data-subgroup="icons" data-state="open"
                                data-option="icon" placeholder="<?php echo Text::_('ICON'); ?>">
                            <i class="zmdi zmdi-attachment-alt"></i>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SIZE'); ?>
                            </span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="1000">
                                <input type="text" data-group="hamburger" data-subgroup="icons" data-state="open"
                                    data-option="size" data-group="hamburger" data-callback="sectionRules">
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('COLOR'); ?>
                            </span>
                            <input type="text" data-type="color" data-option="open" data-group="hamburger">
                            <span class="minicolors-opacity-wrapper">
                                <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                min="0" max="1" step="0.01">
                                <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                            </span>
                        </div>
                        <div class="ba-settings-toolbar">
                            <label data-option="open-align" data-value="left" data-group="hamburger" data-callback="sectionRules">
                                <i class="zmdi zmdi-format-align-left"></i>
                                <span class="ba-tooltip">
                                    <?php echo Text::_('LEFT'); ?>
                                </span>
                            </label>
                            <label data-option="open-align" data-value="center" data-group="hamburger" data-callback="sectionRules">
                                <i class="zmdi zmdi-format-align-center"></i>
                                <span class="ba-tooltip">
                                    <?php echo Text::_('CENTER'); ?>
                                </span>
                            </label>
                            <label data-option="open-align" data-value="right" data-group="hamburger" data-callback="sectionRules">
                                <i class="zmdi zmdi-format-align-right"></i>
                                <span class="ba-tooltip">
                                    <?php echo Text::_('RIGHT'); ?>
                                </span>
                            </label>
                        </div>
                    </div>
                    <div class="ba-settings-group">
                        <div class="settings-group-title">
                            <span><?php echo Text::_('ICON_CLOSE'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('ICON'); ?>
                            </span>
                            <input class="select-input" type="text" readonly onfocus="this.blur()"
                                data-group="hamburger" data-subgroup="icons" data-state="close"
                                data-option="icon" placeholder="<?php echo Text::_('ICON'); ?>">
                            <i class="zmdi zmdi-attachment-alt"></i>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SIZE'); ?>
                            </span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="1000">
                                <input type="text" data-group="hamburger" data-subgroup="icons" data-state="close"
                                    data-option="size" data-group="hamburger" data-callback="sectionRules">
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('COLOR'); ?>
                            </span>
                            <input type="text" data-type="color" data-option="close" data-group="hamburger">
                            <span class="minicolors-opacity-wrapper">
                                <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                min="0" max="1" step="0.01">
                                <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                            </span>
                        </div>
                        <div class="ba-settings-toolbar">
                            <label data-option="close-align" data-value="left" data-group="hamburger" data-callback="sectionRules">
                                <i class="zmdi zmdi-format-align-left"></i>
                                <span class="ba-tooltip">
                                    <?php echo Text::_('LEFT'); ?>
                                </span>
                            </label>
                            <label data-option="close-align" data-value="center" data-group="hamburger" data-callback="sectionRules">
                                <i class="zmdi zmdi-format-align-center"></i>
                                <span class="ba-tooltip">
                                    <?php echo Text::_('CENTER'); ?>
                                </span>
                            </label>
                            <label data-option="close-align" data-value="right" data-group="hamburger" data-callback="sectionRules">
                                <i class="zmdi zmdi-format-align-right"></i>
                                <span class="ba-tooltip">
                                    <?php echo Text::_('RIGHT'); ?>
                                </span>
                            </label>
                        </div>
                    </div>
                    <div class="ba-settings-group">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-format-color-fill"></i>
                            <span><?php echo Text::_('BACKGROUND'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('COLOR'); ?>
                            </span>
                            <input type="text" data-type="color" data-option="background" data-group="hamburger" class="minicolors-top">
                            <span class="minicolors-opacity-wrapper">
                                <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                min="0" max="1" step="0.01">
                                <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                            </span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('OVERLAY'); ?>
                            </span>
                            <input type="text" data-type="color" data-option="overlay" data-group="hamburger" class="minicolors-top">
                            <span class="minicolors-opacity-wrapper">
                                <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                min="0" max="1" step="0.01">
                                <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                            </span>
                        </div>
                    </div>
<?php
                    $options = ['group' => 'hamburger', 'subgroup' => 'padding'];
                    echo $this->html->load('padding', $options);
                    $options = ['group' => 'hamburger', 'subgroup' => 'shadow'];
                    echo $this->html->load('shadow', $options);
?>
                </div>
                <i class="zmdi zmdi-more resize-handle-bottom"></i>
            </div>
        </div>
    </div>
</div>
<div id="tabs-settings-dialog" class="ba-modal-cp draggable-modal-cp modal hide">
    <div class="modal-header">
        <span class="ba-dialog-title"></span>
        <div class="modal-header-icon">
            <div class="ba-custom-select select-modal-cp-position">
                <i class="zmdi zmdi-more-vert"></i>
                <input type="hidden">
                <ul>
                    <li data-value=""><?php echo Text::_('SEPARATE_WINDOW') ?></li>
                    <li data-value="right"><?php echo Text::_('PANEL_TO_RIGHT') ?></li>
                </ul>
            </div>
            <i class="zmdi zmdi-close close-cp-modal"></i>
        </div>
    </div>
    <div class="modal-body">
        <div class="general-tabs">
            <ul class="nav nav-tabs">
                <li class="active">
                    <a href="#tabs-general-options" data-toggle="tab">
                        <i class="zmdi zmdi-settings"></i>
                        <span><?php echo Text::_('GENERAL'); ?></span>
                    </a>
                </li>
                <li>
                    <a href="#tabs-design-options" data-toggle="tab">
                        <i class="zmdi zmdi-format-color-fill"></i>
                        <span><?php echo Text::_('DESIGN'); ?></span>
                    </a>
                </li>
                <li>
                    <a href="#tabs-layout-options" data-toggle="tab">
                        <i class="zmdi zmdi-fullscreen"></i>
                        <span><?php echo Text::_('LAYOUT'); ?></span>
                    </a>
                </li>
            </ul>
            <div class="tabs-underline"></div>
            <div class="tab-content">
                <div id="tabs-general-options" class="row-fluid tab-pane active">
<?php
                    include $htmlPath.'ba-settings-group-items-list.php';
?>
                    <div class="ba-settings-group accordion-options">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-tune"></i>
                            <span><?php echo Text::_('SETTINGS'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('AUTOSCROLL'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-group="autoscroll" data-option="enable">
                                <span></span>
                            </label>
                            <label class="ba-help-icon">
                                <i class="zmdi zmdi-help"></i>
                                <span class="ba-tooltip ba-help">
                                    <?php echo Text::_('ACCORDION_AUTO_SCROLL_TOOLTIP'); ?>
                                </span>
                            </label>
                        </div>
                    </div>
                    <div class="ba-settings-group tabs-options">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-desktop-windows"></i>
                            <span><?php echo Text::_('VIEW'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('LAYOUT'); ?>
                            </span>
                            <div class="ba-custom-select tabs-position-select">
                                <input readonly onfocus="this.blur()" type="text" value="">
                                <input type="hidden">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="tabs-top"><?php echo Text::_('TOP'); ?></li>
                                    <li data-value="tabs-left"><?php echo Text::_('LEFT'); ?></li>
                                    <li data-value="tabs-right"><?php echo Text::_('RIGHT'); ?></li>
                                </ul>
                            </div>
                        </div>
                    </div>
<?php
                    echo $this->html->loadPassive('disable');
?>
                    <div class="ba-settings-group">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-roller"></i>
                            <span><?php echo Text::_('PRESETS'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SELECT'); ?>
                            </span>
                            <div class="ba-lg-custom-select select-preset">
                                <input type="text" readonly onfocus="this.blur()">
                                <input type="hidden">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <div class="ba-lg-custom-select-header">
                                        <span class="create-new-preset">
                                            <i class="zmdi zmdi-plus-circle"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('SAVE_PRESET'); ?></span>
                                        </span>
                                        <span class="edit-preset-item">
                                            <i class="zmdi zmdi-edit"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('EDIT'); ?></span>
                                        </span>
                                        <span class="delete-preset-item">
                                            <i class="zmdi zmdi-delete"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('DELETE'); ?></span>
                                        </span>
                                    </div>
                                    <div class="ba-lg-custom-select-body">
                                        <li data-value="">
                                            <label>
                                                <input type="radio" name="preset-checkbox" value="">
                                                <i class="zmdi zmdi-circle-o"></i>
                                                <i class="zmdi zmdi-check"></i>
                                            </label>
                                            <span><?php echo Text::_('NO_NE'); ?></span>
                                        </li>
                                    </div>
                                </ul>
                            </div>
                        </div>
                    </div>
<?php
                    echo $this->html->loadPassive('item-animation');
                    echo $this->html->loadPassive('advanced', $this->access);
?>
                </div>
                <div id="tabs-design-options" class="row-fluid tab-pane">
                    <div class="ba-settings-group">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-format-size"></i>
                            <span><?php echo Text::_('TYPOGRAPHY'); ?></span>
                        </div>
                        <div class="theme-typography-options">
                            <div class="typography-options">
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('FONT_FAMILY'); ?>
                                    </span>
                                    <input readonly onfocus="this.blur()" type="text" data-option="font-family"
                                        data-group="" data-callback="sectionRules">
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('FONT_WEIGHT'); ?>
                                    </span>
                                    <input readonly onfocus="this.blur()" type="text" data-option="font-weight"
                                        data-group="" data-callback="sectionRules">
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('COLOR'); ?>
                                    </span>
                                    <input type="text" data-type="color" data-option="color" data-group="">
                                    <span class="minicolors-opacity-wrapper">
                                        <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                        min="0" max="1" step="0.01">
                                        <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                                    </span>
                                </div>
                                <div class="ba-settings-item tabs-options hover-group">
                                    <span>
                                        <?php echo Text::_('HOVER_ACTIVE'); ?>
                                    </span>
                                    <input type="text" data-type="color" data-option="color" data-group="hover">
                                    <span class="minicolors-opacity-wrapper">
                                        <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                        min="0" max="1" step="0.01">
                                        <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                                    </span>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('SIZE'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner"></span>
                                        <input type="range" class="ba-range" min="0" max="320">
                                        <input type="text" data-option="font-size" data-group="" data-callback="sectionRules">
                                    </div>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('LETTER_SPACING'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner letter-spacing"></span>
                                        <input type="range" class="ba-range" min="-10" max="10">
                                        <input type="text" data-option="letter-spacing" data-group="" data-callback="sectionRules">
                                    </div>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('LINE_HEIGHT'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner"></span>
                                        <input type="range" class="ba-range" min="0" max="640">
                                        <input type="text" data-option="line-height" data-group="" data-callback="sectionRules">
                                    </div>
                                </div>
                                <div class="ba-settings-toolbar">
                                    <label data-option="text-decoration" data-value="underline" data-group="" data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-underlined"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('UNDERLINE'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-transform" data-value="uppercase" data-group="" data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-size"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('UPPERCASE'); ?>
                                        </span>
                                    </label>
                                    <label data-option="font-style" data-value="italic" data-group="" data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-italic"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('ITALIC'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-align" data-value="left" data-group="" data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-align-left"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('LEFT'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-align" data-value="center" data-group="" data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-align-center"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('CENTER'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-align" data-value="right" data-group="" data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-align-right"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('RIGHT'); ?>
                                        </span>
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group tabs-options">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-border-top"></i>
                            <span><?php echo Text::_('HEADER'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('BORDER'); ?>
                            </span>
                            <input type="text" data-type="color" data-option="border" data-group="header">
                            <span class="minicolors-opacity-wrapper">
                                <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                min="0" max="1" step="0.01">
                                <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                            </span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('BACKGROUND'); ?>
                            </span>
                            <input type="text" data-type="color" data-option="color" data-group="header">
                            <span class="minicolors-opacity-wrapper">
                                <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                min="0" max="1" step="0.01">
                                <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                            </span>
                        </div>
                    </div>
                    <div class="ba-settings-group">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-local-florist"></i>
                            <span><?php echo Text::_('ICON'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('POSITION'); ?>
                            </span>
                            <div class="ba-custom-select tabs-icon-position">
                                <input readonly onfocus="this.blur()" value="" type="text">
                                <input type="hidden">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="icon-position-left"><?php echo Text::_('LEFT'); ?></li>
                                    <li class="tabs-options" data-value="icon-position-top"><?php echo Text::_('TOP'); ?></li>
                                    <li data-value=""><?php echo Text::_('RIGHT'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SIZE'); ?>
                            </span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="320">
                                <input type="text" data-option="size" data-group="icon" data-callback="sectionRules">
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group tabs-options">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-format-color-fill"></i>
                            <span><?php echo Text::_('BACKGROUND'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('BACKGROUND'); ?>
                            </span>
                            <input type="text" data-type="color" data-group="background" data-option="color">
                            <span class="minicolors-opacity-wrapper">
                                <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                min="0" max="1" step="0.01">
                                <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                            </span>
                        </div>
                    </div>
                    <div class="ba-settings-group accordion-options">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-format-color-fill"></i>
                            <span><?php echo Text::_('BACKGROUND'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('HEADER'); ?>
                            </span>
                            <input type="text" data-type="color" data-option="color" data-group="header">
                            <span class="minicolors-opacity-wrapper">
                                <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                min="0" max="1" step="0.01">
                                <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                            </span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('BODY'); ?>
                            </span>
                            <input type="text" data-type="color" data-group="background" data-option="color">
                            <span class="minicolors-opacity-wrapper">
                                <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                min="0" max="1" step="0.01">
                                <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                            </span>
                        </div>
                    </div>
                    <div class="ba-settings-group accordion-options">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-border-top"></i>
                            <span><?php echo Text::_('BORDER'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('COLOR'); ?>
                            </span>
                            <input class="minicolors-top" type="text" data-type="color" data-option="color" data-group="border">
                            <span class="minicolors-opacity-wrapper">
                                <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                min="0" max="1" step="0.01">
                                <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                            </span>
                        </div>
                    </div>
                </div>
                <div id="tabs-layout-options" class="row-fluid tab-pane">
<?php
                    echo $this->html->loadPassive('positioning');
                    echo $this->html->load('margin');
                    echo $this->html->load('padding');
?>
                </div>
                <i class="zmdi zmdi-more resize-handle-bottom"></i>
            </div>
        </div>
    </div>
</div>
<div id="social-settings-dialog" class="ba-modal-cp draggable-modal-cp modal hide">
    <div class="modal-header">
        <span class="ba-dialog-title"></span>
        <div class="modal-header-icon">
            <div class="ba-custom-select select-modal-cp-position">
                <i class="zmdi zmdi-more-vert"></i>
                <input type="hidden">
                <ul>
                    <li data-value=""><?php echo Text::_('SEPARATE_WINDOW') ?></li>
                    <li data-value="right"><?php echo Text::_('PANEL_TO_RIGHT') ?></li>
                </ul>
            </div>
            <i class="zmdi zmdi-close close-cp-modal"></i>
        </div>
    </div>
    <div class="modal-body">
        <div class="general-tabs">
            <ul class="nav nav-tabs">
                <li class="active">
                    <a href="#social-general-options" data-toggle="tab">
                        <i class="zmdi zmdi-settings"></i>
                        <span><?php echo Text::_('GENERAL'); ?></span>
                    </a>
                </li>
            </ul>
            <div class="tabs-underline"></div>
            <div class="tab-content">
                <div id="social-general-options" class="row-fluid tab-pane active">
                    <div class="ba-settings-group">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('LAYOUT'); ?>
                            </span>
                            <div class="ba-custom-select social-layout-select">
                                <input readonly onfocus="this.blur()" type="text" value="">
                                <input type="hidden" data-option="layout" data-group="view" class="set-value-css">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value=""><?php echo Text::_('DEFAULT'); ?></li>
                                    <li data-value="ba-social-sidebar"><?php echo Text::_('SIDEBAR'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SIZE'); ?>
                            </span>
                            <div class="ba-custom-select social-size-select">
                                <input readonly onfocus="this.blur()" type="text" value="">
                                <input type="hidden" data-option="size" data-group="view" class="set-value-css">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="ba-social-sm"><?php echo Text::_('SMALL'); ?></li>
                                    <li data-value="ba-social-md"><?php echo Text::_('MEDIUM'); ?></li>
                                    <li data-value="ba-social-lg"><?php echo Text::_('LARGE'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('STYLE'); ?>
                            </span>
                            <div class="ba-custom-select social-style-select">
                                <input readonly onfocus="this.blur()" type="text" value="">
                                <input type="hidden" data-option="style" data-group="view" class="set-value-css">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="ba-social-minimal"><?php echo Text::_('MINIMAL'); ?></li>
                                    <li data-value="ba-social-classic"><?php echo Text::_('CLASSIC'); ?></li>
                                    <li data-value="ba-social-flat"><?php echo Text::_('FLAT'); ?></li>
                                    <li data-value="ba-social-circle"><?php echo Text::_('CIRCLE'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('COUNTERS'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-option="counters" data-group="view" class="set-value-css">
                                <span></span>
                            </label>
                        </div>
                    </div>
                    <div class="ba-settings-group">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-share"></i>
                            <span><?php echo Text::_('SOCIAL_NETWORKS'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                Facebook
                            </span>
                            <label class="ba-checkbox">
                                <input class="show-social" type="checkbox" data-option="facebook">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                X
                            </span>
                            <label class="ba-checkbox">
                                <input class="show-social" type="checkbox" data-option="twitter">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                Vkontakte
                            </span>
                            <label class="ba-checkbox">
                                <input class="show-social" type="checkbox" data-option="vk">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                LinkedIn
                            </span>
                            <label class="ba-checkbox">
                                <input class="show-social" type="checkbox" data-option="linkedin">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                Pinterest
                            </span>
                            <label class="ba-checkbox">
                                <input class="show-social" type="checkbox" data-option="pinterest">
                                <span></span>
                            </label>
                            <label class="ba-help-icon">
                                <i class="zmdi zmdi-help"></i>
                                <span class="ba-tooltip ba-help">
                                    <?php echo Text::_('PINTEREST_TOOLTIP'); ?>
                                </span>
                            </label>
                        </div>
                    </div>
<?php
                    echo $this->html->load('margin');
                    echo $this->html->loadPassive('disable');
                    echo $this->html->loadPassive('item-animation');
                    echo $this->html->loadPassive('advanced', $this->access);
?>
                </div>
                <i class="zmdi zmdi-more resize-handle-bottom"></i>
            </div>
        </div>
    </div>
</div>
<div id="lightbox-settings-dialog" class="ba-modal-cp draggable-modal-cp modal hide">
    <div class="modal-header">
        <span class="ba-dialog-title"></span>
        <div class="modal-header-icon">
            <div class="ba-custom-select select-modal-cp-position">
                <i class="zmdi zmdi-more-vert"></i>
                <input type="hidden">
                <ul>
                    <li data-value=""><?php echo Text::_('SEPARATE_WINDOW') ?></li>
                    <li data-value="right"><?php echo Text::_('PANEL_TO_RIGHT') ?></li>
                </ul>
            </div>
            <i class="zmdi zmdi-close close-cp-modal"></i>
        </div>
    </div>
    <div class="modal-body">
        <div class="general-tabs">
            <ul class="nav nav-tabs">
                <li class="active">
                    <a href="#lightbox-general-options" data-toggle="tab">
                        <i class="zmdi zmdi-settings"></i>
                        <span><?php echo Text::_('GENERAL'); ?></span>
                    </a>
                </li>
            </ul>
            <div class="tabs-underline"></div>
            <div class="tab-content">
                <div id="lightbox-general-options" class="row-fluid tab-pane active">
                    <div class="ba-settings-group">
                        <div class="ba-settings-item lightbox-options">
                            <span>
                                <?php echo Text::_('POSITION'); ?>
                            </span>
                            <div class="ba-custom-select lightbox-position-select">
                                <input readonly onfocus="this.blur()" type="text" value="">
                                <input type="hidden" value="">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="lightbox-top-left"><?php echo Text::_('TOP_LEFT'); ?></li>
                                    <li data-value="lightbox-top-right"><?php echo Text::_('TOP_RIGHT'); ?></li>
                                    <li data-value="lightbox-center"><?php echo Text::_('CENTER'); ?></li>
                                    <li data-value="lightbox-bottom-left"><?php echo Text::_('BOTTOM_LEFT'); ?></li>
                                    <li data-value="lightbox-bottom-right"><?php echo Text::_('BOTTOM_RIGHT'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item overlay-section-options">
                            <span>
                                <?php echo Text::_('LAYOUT'); ?>
                            </span>
                            <div class="ba-custom-select overlay-section-layout-select">
                                <input readonly onfocus="this.blur()" type="text" value="">
                                <input type="hidden" value="">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="vertical"><?php echo Text::_('VERTICAL'); ?></li>
                                    <li data-value="horizontal"><?php echo Text::_('HORIZONTAL'); ?></li>
                                    <li data-value="lightbox"><?php echo Text::_('LIGHTBOX'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item overlay-section-options">
                            <span>
                                <?php echo Text::_('SLIDE'); ?>
                            </span>
                            <div class="ba-custom-select overlay-section-slide-select">
                                <input readonly onfocus="this.blur()" type="text" value="">
                                <input type="hidden" value="">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="vertical-right"><?php echo Text::_('RIGHT'); ?></li>
                                    <li data-value="vertical-left"><?php echo Text::_('LEFT'); ?></li>
                                    <li data-value="horizontal-top"><?php echo Text::_('TOP'); ?></li>
                                    <li data-value="horizontal-bottom"><?php echo Text::_('BOTTOM'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item lightbox-overlay-backdrop-color">
                            <span>
                                <?php echo Text::_('OVERLAY'); ?>
                            </span>
                            <input type="text" data-type="color" data-option="background" data-group="lightbox">
                            <span class="minicolors-opacity-wrapper">
                                <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                min="0" max="1" step="0.01">
                                <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                            </span>
                        </div>
                        <div class="ba-settings-item width-options">
                            <span>
                                <?php echo Text::_('WIDTH'); ?>
                            </span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="1170">
                                <input type="text" data-option="width" data-group="view" data-callback="sectionRules">
                            </div>
                        </div>
                        <div class="ba-settings-item height-options overlay-section-options">
                            <span>
                                <?php echo Text::_('HEIGHT'); ?>
                            </span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="2500">
                                <input type="text" data-option="height" data-group="view" data-callback="sectionRules">
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group">
                        <div class="settings-group-title">
                            <span><?php echo Text::_('ICON_CLOSE'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('COLOR'); ?>
                            </span>
                            <input type="text" data-type="color" data-option="color" data-group="close">
                            <span class="minicolors-opacity-wrapper">
                                <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                min="0" max="1" step="0.01">
                                <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                            </span>
                        </div>
                        <div class="ba-settings-toolbar">
                            <label data-option="text-align" data-value="left" data-group="close" data-callback="sectionRules">
                                <i class="zmdi zmdi-format-align-left"></i>
                                <span class="ba-tooltip">
                                    <?php echo Text::_('LEFT'); ?>
                                </span>
                            </label>
                            <label data-option="text-align" data-value="center" data-group="close" data-callback="sectionRules">
                                <i class="zmdi zmdi-format-align-center"></i>
                                <span class="ba-tooltip">
                                    <?php echo Text::_('CENTER'); ?>
                                </span>
                            </label>
                            <label data-option="text-align" data-value="right" data-group="close" data-callback="sectionRules">
                                <i class="zmdi zmdi-format-align-right"></i>
                                <span class="ba-tooltip">
                                    <?php echo Text::_('RIGHT'); ?>
                                </span>
                            </label>
                        </div>
                    </div>
                    <div class="ba-settings-group desktop-only lightbox-options lightbox-trigger-options">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-tune"></i>
                            <span><?php echo Text::_('SETTINGS'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('TRIGGER'); ?>
                            </span>
                            <div class="ba-custom-select lightbox-trigger-select">
                                <input readonly onfocus="this.blur()" type="text" value="">
                                <input type="hidden" value="">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="time-delay"><?php echo Text::_('TIME_DELAY'); ?></li>
                                    <li data-value="scrolling"><?php echo Text::_('SCROLLING'); ?></li>
                                    <li data-value="bottom-of-page"><?php echo Text::_('BOTTOM_OF_PAGE'); ?></li>
                                    <li data-value="exit-intent"><?php echo Text::_('EXIT_INTENT'); ?></li>
                                </ul>
                            </div>
                            <label class="ba-help-icon">
                                <i class="zmdi zmdi-help"></i>
                                <span class="ba-tooltip ba-help">
                                    <?php echo Text::_('TRIGGER_TOOLTIP'); ?>
                                </span>
                            </label>
                        </div>
                        <div class="ba-settings-item time-delay-trigger">
                            <span>
                                <?php echo Text::_('TIME_DELAY'); ?>, ms
                            </span>
                            <input type="number" data-option="time" data-group="trigger" class="lightbox-settings-input"
                                placeholder="<?php echo Text::_('TIME_DELAY'); ?>">
                            <label class="ba-help-icon">
                                <i class="zmdi zmdi-help"></i>
                                <span class="ba-tooltip ba-help">
                                    <?php echo Text::_('TIME_DELAY_TOOLTIP'); ?>
                                </span>
                            </label>
                        </div>
                        <div class="ba-settings-item scrolling-trigger">
                            <span>
                                <?php echo Text::_('PERCENTAGE'); ?>, %
                            </span>
                            <input type="number" data-option="scroll" data-group="trigger" max="100" class="lightbox-settings-input"
                                placeholder="50">
                            <label class="ba-help-icon">
                                <i class="zmdi zmdi-help"></i>
                                <span class="ba-tooltip ba-help">
                                    <?php echo Text::_('PERCENTAGE_TOOLTIP'); ?>
                                </span>
                            </label>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SHOW_ONCE_PER_SESSION'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-option="enable" data-group="session">
                                <span></span>
                            </label>
                            <label class="ba-help-icon">
                                <i class="zmdi zmdi-help"></i>
                                <span class="ba-tooltip ba-help">
                                    <?php echo Text::_('DISPLAY_ONCE_PER_SESSION_TOOLTIP'); ?>
                                </span>
                            </label>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SESSION_DURATION'); ?>
                            </span>
                            <input type="number" data-option="duration" data-group="session" class="lightbox-settings-input"
                                placeholder="1">
                            <label class="ba-help-icon">
                                <i class="zmdi zmdi-help"></i>
                                <span class="ba-tooltip ba-help">
                                    <?php echo Text::_('SESSION_DURATION_TOOLTIP'); ?>
                                </span>
                            </label>
                        </div>
                    </div>
<?php
                    echo $this->html->load('margin');
                    echo $this->html->loadPassive('disable');
                    echo $this->html->loadPassive('advanced', $this->access);
?>
                </div>
                <i class="zmdi zmdi-more resize-handle-bottom"></i>
            </div>
        </div>
    </div>
</div>
<div id="star-ratings-settings-dialog" class="ba-modal-cp draggable-modal-cp modal hide">
    <div class="modal-header">
        <span class="ba-dialog-title"></span>
        <div class="modal-header-icon">
            <div class="ba-custom-select select-modal-cp-position">
                <i class="zmdi zmdi-more-vert"></i>
                <input type="hidden">
                <ul>
                    <li data-value=""><?php echo Text::_('SEPARATE_WINDOW') ?></li>
                    <li data-value="right"><?php echo Text::_('PANEL_TO_RIGHT') ?></li>
                </ul>
            </div>
            <i class="zmdi zmdi-close close-cp-modal"></i>
        </div>
    </div>
    <div class="modal-body">
        <div class="general-tabs">
            <ul class="nav nav-tabs">
                <li class="active">
                    <a href="#star-ratings-general-options" data-toggle="tab">
                        <i class="zmdi zmdi-settings"></i>
                        <span><?php echo Text::_('GENERAL'); ?></span>
                    </a>
                </li>
                <li>
                    <a href="#star-ratings-design-options" data-toggle="tab">
                        <i class="zmdi zmdi-format-color-fill"></i>
                        <span><?php echo Text::_('DESIGN'); ?></span>
                    </a>
                </li>
                <li>
                    <a href="#star-ratings-layout-options" data-toggle="tab">
                        <i class="zmdi zmdi-fullscreen"></i>
                        <span><?php echo Text::_('LAYOUT'); ?></span>
                    </a>
                </li>
            </ul>
            <div class="tabs-underline"></div>
            <div class="tab-content">
                <div id="star-ratings-general-options" class="row-fluid tab-pane active">
                    <div class="ba-settings-group">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('RATING'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-option="rating" data-group="view" class="set-desktop-view-value">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('VOTES'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-option="votes" data-group="view" class="set-desktop-view-value">
                                <span></span>
                            </label>
                        </div>
                    </div>
<?php
                    echo $this->html->loadPassive('disable');
?>
                    <div class="ba-settings-group">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-roller"></i>
                            <span><?php echo Text::_('PRESETS'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SELECT'); ?>
                            </span>
                            <div class="ba-lg-custom-select select-preset">
                                <input type="text" readonly onfocus="this.blur()">
                                <input type="hidden">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <div class="ba-lg-custom-select-header">
                                        <span class="create-new-preset">
                                            <i class="zmdi zmdi-plus-circle"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('SAVE_PRESET'); ?></span>
                                        </span>
                                        <span class="edit-preset-item">
                                            <i class="zmdi zmdi-edit"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('EDIT'); ?></span>
                                        </span>
                                        <span class="delete-preset-item">
                                            <i class="zmdi zmdi-delete"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('DELETE'); ?></span>
                                        </span>
                                    </div>
                                    <div class="ba-lg-custom-select-body">
                                        <li data-value="">
                                            <label>
                                                <input type="radio" name="preset-checkbox" value="">
                                                <i class="zmdi zmdi-circle-o"></i>
                                                <i class="zmdi zmdi-check"></i>
                                            </label>
                                            <span><?php echo Text::_('NO_NE'); ?></span>
                                        </li>
                                    </div>
                                </ul>
                            </div>
                        </div>
                    </div>
<?php
                    echo $this->html->loadPassive('item-animation');
                    echo $this->html->loadPassive('advanced', $this->access);
?>
                </div>
                <div id="star-ratings-design-options" class="row-fluid tab-pane ">
                    <div class="ba-settings-group star-ratings-design-group">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SELECT'); ?>
                            </span>
                            <div class="ba-custom-select star-ratings-style-custom-select">
                                <input readonly onfocus="this.blur()" type="text" value="">
                                <input type="hidden" value="">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="icon"><?php echo Text::_('ICON'); ?></li>
                                    <li data-value="info"><?php echo Text::_('INFO'); ?></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group star-ratings-icon-options">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SIZE'); ?>
                            </span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="320">
                                <input type="text" data-option="size" data-group="icon" data-callback="sectionRules">
                            </div>
                        </div>
                        <div class="ba-settings-toolbar">
                            <label data-option="text-align" data-value="left" data-group="icon" data-callback="sectionRules">
                                <i class="zmdi zmdi-format-align-left"></i>
                                <span class="ba-tooltip">
                                    <?php echo Text::_('LEFT'); ?>
                                </span>
                            </label>
                            <label data-option="text-align" data-value="center" data-group="icon" data-callback="sectionRules">
                                <i class="zmdi zmdi-format-align-center"></i>
                                <span class="ba-tooltip">
                                    <?php echo Text::_('CENTER'); ?>
                                </span>
                            </label>
                            <label data-option="text-align" data-value="right" data-group="icon" data-callback="sectionRules">
                                <i class="zmdi zmdi-format-align-right"></i>
                                <span class="ba-tooltip">
                                    <?php echo Text::_('RIGHT'); ?>
                                </span>
                            </label>
                        </div>
                    </div>
                    <div class="ba-settings-group star-ratings-icon-options">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('COLOR'); ?>
                            </span>
                            <input type="text" data-type="color" data-option="color" data-group="icon">
                            <span class="minicolors-opacity-wrapper">
                                <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                min="0" max="1" step="0.01">
                                <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                            </span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('HOVER_ACTIVE'); ?>
                            </span>
                            <input type="text" data-type="color" data-option="hover" data-group="icon">
                            <span class="minicolors-opacity-wrapper">
                                <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                min="0" max="1" step="0.01">
                                <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                            </span>
                        </div>
                    </div>
                    <div class="ba-settings-group star-ratings-typography-options">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-format-size"></i>
                            <span><?php echo Text::_('TYPOGRAPHY'); ?></span>
                        </div>
                        <div class="theme-typography-options">
                            <div class="typography-options">
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('FONT_FAMILY'); ?>
                                    </span>
                                    <input readonly onfocus="this.blur()" type="text" data-option="font-family"
                                        data-group="" data-callback="sectionRules">
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('FONT_WEIGHT'); ?>
                                    </span>
                                    <input readonly onfocus="this.blur()" type="text" data-option="font-weight" data-group=""
                                        data-callback="sectionRules">
                                </div>
                                <div class="ba-settings-item star-ratings-typography-color">
                                    <span>
                                        <?php echo Text::_('COLOR'); ?>
                                    </span>
                                    <input type="text" data-type="color" data-option="color" data-group="">
                                    <span class="minicolors-opacity-wrapper">
                                        <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                        min="0" max="1" step="0.01">
                                        <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                                    </span>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('SIZE'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner"></span>
                                        <input type="range" class="ba-range" min="0" max="320">
                                        <input type="text" data-option="font-size" data-group="" data-callback="sectionRules">
                                    </div>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('LETTER_SPACING'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner letter-spacing"></span>
                                        <input type="range" class="ba-range" min="-10" max="10">
                                        <input type="text" data-option="letter-spacing" data-group="" data-callback="sectionRules">
                                    </div>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('LINE_HEIGHT'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner"></span>
                                        <input type="range" class="ba-range" min="0" max="640">
                                        <input type="text" data-option="line-height" data-group="" data-callback="sectionRules">
                                    </div>
                                </div>
                                <div class="ba-settings-toolbar">
                                    <label data-option="text-decoration" data-value="underline" data-group="" data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-underlined"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('UNDERLINE'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-transform" data-value="uppercase" data-group="" data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-size"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('UPPERCASE'); ?>
                                        </span>
                                    </label>
                                    <label data-option="font-style" data-value="italic" data-group="" data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-italic"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('ITALIC'); ?>
                                        </span>
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div id="star-ratings-layout-options" class="row-fluid tab-pane ">
<?php
                    echo $this->html->loadPassive('positioning');
                    echo $this->html->load('margin');
?>
                </div>
                <i class="zmdi zmdi-more resize-handle-bottom"></i>
            </div>
        </div>
    </div>
</div>
<div id="intro-post-settings-dialog" class="ba-modal-cp draggable-modal-cp modal hide">
    <div class="modal-header">
        <span class="ba-dialog-title"></span>
        <div class="modal-header-icon">
            <div class="ba-custom-select select-modal-cp-position">
                <i class="zmdi zmdi-more-vert"></i>
                <input type="hidden">
                <ul>
                    <li data-value=""><?php echo Text::_('SEPARATE_WINDOW') ?></li>
                    <li data-value="right"><?php echo Text::_('PANEL_TO_RIGHT') ?></li>
                </ul>
            </div>
            <i class="zmdi zmdi-close close-cp-modal"></i>
        </div>
    </div>
    <div class="modal-body">
        <div class="general-tabs">
            <ul class="nav nav-tabs">
                <li class="active">
                    <a href="#intro-post-general-options" data-toggle="tab">
                        <i class="zmdi zmdi-settings"></i>
                        <span><?php echo Text::_('GENERAL'); ?></span>
                    </a>
                </li>
                <li>
                    <a href="#intro-post-design-options" data-toggle="tab">
                        <i class="zmdi zmdi-format-color-fill"></i>
                        <span><?php echo Text::_('DESIGN'); ?></span>
                    </a>
                </li>
                <li>
                    <a href="#intro-post-layout-options" data-toggle="tab">
                        <i class="zmdi zmdi-fullscreen"></i>
                        <span><?php echo Text::_('LAYOUT'); ?></span>
                    </a>
                </li>
            </ul>
            <div class="tabs-underline"></div>
            <div class="tab-content">
                <div id="intro-post-general-options" class="row-fluid tab-pane active">
                    <div class="ba-settings-group items-list">
                        <div class="sorting-container">
                            
                        </div>
                    </div>
                    <div class="ba-settings-group">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('LAYOUT'); ?>
                            </span>
                            <div class="ba-custom-select intro-post-layout-select">
                                <input readonly onfocus="this.blur()" value="" type="text">
                                <input type="hidden" value="">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value=""><?php echo Text::_('CLASSIC'); ?></li>
                                    <li data-value="fullscreen-post"><?php echo Text::_('COVER'); ?></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group intro-post-view-options">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-desktop-windows"></i>
                            <span><?php echo Text::_('VIEW'); ?></span>
                        </div>
                        <div class="ba-settings-item intro-show-image">
                            <span>
                                <?php echo Text::_('IMAGE'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-option="show" data-group="image" class="set-desktop-view-value">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('TITLE'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-option="show" data-group="title" class="set-desktop-view-value">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item category-intro-view">
                            <span>
                                <?php echo Text::_('INFO'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-option="show" data-group="info" class="set-desktop-view-value">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item post-intro-view">
                            <span>
                                <?php echo Text::_('INFO'); ?>
                            </span>
                            <span class="category-list-fields-wrapper">
                                <i class="zmdi zmdi-playlist-plus open-category-list-fields" data-target="info"></i>
                            </span>
                        </div>
                    </div>
<?php
                    echo $this->html->loadPassive('disable');
                    echo $this->html->loadPassive('item-animation');
                    echo $this->html->loadPassive('advanced', $this->access);
?>
                </div>
                <div id="intro-post-design-options" class="row-fluid tab-pane">
                    <div class="ba-settings-group intro-post-design-group">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SELECT'); ?>
                            </span>
                            <div class="ba-custom-select intro-post-style-custom-select">
                                <input readonly onfocus="this.blur()" type="text" value="">
                                <input type="hidden" value="">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="title"><?php echo Text::_('TITLE'); ?></li>
                                    <li data-value="info"><?php echo Text::_('INFO'); ?></li>
                                    <li data-value="image"><?php echo Text::_('IMAGE'); ?></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group intro-post-typography-options">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-format-size"></i>
                            <span><?php echo Text::_('TYPOGRAPHY'); ?></span>
                        </div>
                        <div class="theme-typography-options">
                            <div class="typography-options">
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('FONT_FAMILY'); ?>
                                    </span>
                                    <input readonly onfocus="this.blur()" type="text" data-option="font-family" data-group=""
                                        data-subgroup="typography" data-callback="sectionRules">
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('FONT_WEIGHT'); ?>
                                    </span>
                                    <input readonly onfocus="this.blur()" type="text" data-option="font-weight"
                                        data-group="" data-subgroup="typography" data-callback="sectionRules">
                                </div>
                                <div class="ba-settings-item intro-post-typography-color">
                                    <span>
                                        <?php echo Text::_('COLOR'); ?>
                                    </span>
                                    <input type="text" data-type="color" data-option="color" data-group="" data-subgroup="typography">
                                    <span class="minicolors-opacity-wrapper">
                                        <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                        min="0" max="1" step="0.01">
                                        <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                                    </span>
                                </div>
                                <div class="ba-settings-item info-post-typography-color info-hover-color">
                                    <span>
                                        <?php echo Text::_('HOVER'); ?>
                                    </span>
                                    <input type="text" data-type="color" data-option="color" data-group="info" data-subgroup="hover">
                                    <span class="minicolors-opacity-wrapper">
                                        <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                        min="0" max="1" step="0.01">
                                        <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                                    </span>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('SIZE'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner"></span>
                                        <input type="range" class="ba-range" min="0" max="320">
                                        <input type="text" data-option="font-size" data-group="" data-subgroup="typography"
                                            data-callback="sectionRules">
                                    </div>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('LETTER_SPACING'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner letter-spacing"></span>
                                        <input type="range" class="ba-range" min="-10" max="10">
                                        <input type="text" data-option="letter-spacing" data-group="" data-subgroup="typography"
                                            data-callback="sectionRules">
                                    </div>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('LINE_HEIGHT'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner"></span>
                                        <input type="range" class="ba-range" min="0" max="640">
                                        <input type="text" data-option="line-height" data-group="" data-subgroup="typography"
                                            data-callback="sectionRules">
                                    </div>
                                </div>
                                <div class="ba-settings-toolbar">
                                    <label data-option="text-decoration" data-value="underline" data-group="" data-subgroup="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-underlined"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('UNDERLINE'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-transform" data-value="uppercase" data-group="" data-subgroup="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-size"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('UPPERCASE'); ?>
                                        </span>
                                    </label>
                                    <label data-option="font-style" data-value="italic" data-group="" data-subgroup="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-italic"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('ITALIC'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-align" data-value="left" data-group="" data-subgroup="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-align-left"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('LEFT'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-align" data-value="center" data-group="" data-subgroup="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-align-center"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('CENTER'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-align" data-value="right" data-group="" data-subgroup="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-align-right"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('RIGHT'); ?>
                                        </span>
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group intro-post-image-options">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('FULLSCREEN'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-option="fullscreen" data-group="image" class="set-value-css">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('HEIGHT'); ?>
                            </span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="100" max="1500">
                                <input type="text" data-option="height" data-group="image" data-callback="sectionRules">
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('ATTACHMENT'); ?>
                            </span>
                            <div class="ba-custom-select attachment">
                                <input readonly onfocus="this.blur()" value="fixed" type="text">
                                <input type="hidden" value="fixed" data-option="attachment" data-group="image"
                                    data-action="sectionRules">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="fixed">Fixed</li>
                                    <li data-value="scroll">Scroll</li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SIZE'); ?>
                            </span>
                            <div class="ba-custom-select backround-size">
                                <input readonly onfocus="this.blur()" value="cover" type="text">
                                <input type="hidden" value="cover" data-option="size" data-group="image"
                                    data-action="sectionRules">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="cover">Cover</li>
                                    <li data-value="contain">Contain</li>
                                    <li data-value="initial">Auto</li>
                                </ul>
                            </div>
                        </div>
                        <div class="contain-size-options" style="display: none;">
                            <div class="ba-settings-item">
                                <span>
                                    <?php echo Text::_('POSITION'); ?>
                                </span>
                                <div class="ba-custom-select backround-position">
                                    <input readonly onfocus="this.blur()" value="center center" type="text">
                                    <input type="hidden" value="center center" data-option="position" data-group="image"
                                        data-action="sectionRules">
                                    <i class="zmdi zmdi-caret-down"></i>
                                    <ul>
                                        <li data-value="left top">Left Top</li>
                                        <li data-value="left center">Left Center</li>
                                        <li data-value="left bottom">Left Bottom</li>
                                        <li data-value="right top">Right Top</li>
                                        <li data-value="right center">Right Center</li>
                                        <li data-value="right bottom">Right Bottom</li>
                                        <li data-value="center top">Center Top</li>
                                        <li data-value="center center">Center Center</li>
                                        <li data-value="center bottom">Center Bottom</li>
                                    </ul>
                                </div>
                            </div>
                            <div class="ba-settings-item">
                                <span>
                                    <?php echo Text::_('REPEAT'); ?>
                                </span>
                                <div class="ba-custom-select backround-repeat">
                                    <input readonly onfocus="this.blur()" value="no-repeat" type="text">
                                    <input type="hidden" value="no-repeat" data-option="repeat" data-group="image"
                                        data-action="sectionRules">
                                    <i class="zmdi zmdi-caret-down"></i>
                                    <ul>
                                        <li data-value="repeat">Repeat</li>
                                        <li data-value="repeat-x">Repeat-x</li>
                                        <li data-value="repeat-y">Repeat-y</li>
                                        <li data-value="no-repeat">No-repeat</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
<?php
                    $options = ['class' => 'intro-post-image-options', 'group' => 'image', 'subgroup' => 'overlay-states'];
                    echo $this->html->load('overlay', $options);
                    $options = ['class' => 'intro-post-margin-options', 'group' => 'description', 'subgroup' => 'margin'];
                    echo $this->html->load('margin', $options);
?>
                </div>
                <div id="intro-post-layout-options" class="row-fluid tab-pane">
<?php
                    echo $this->html->loadPassive('positioning');
                    echo $this->html->load('margin');
?>
                </div>
                <i class="zmdi zmdi-more resize-handle-bottom"></i>
            </div>
        </div>
    </div>
</div>
<div id="progress-bar-settings-dialog" class="ba-modal-cp draggable-modal-cp modal hide">
    <div class="modal-header">
        <span class="ba-dialog-title"></span>
        <div class="modal-header-icon">
            <div class="ba-custom-select select-modal-cp-position">
                <i class="zmdi zmdi-more-vert"></i>
                <input type="hidden">
                <ul>
                    <li data-value=""><?php echo Text::_('SEPARATE_WINDOW') ?></li>
                    <li data-value="right"><?php echo Text::_('PANEL_TO_RIGHT') ?></li>
                </ul>
            </div>
            <i class="zmdi zmdi-close close-cp-modal"></i>
        </div>
    </div>
    <div class="modal-body">
        <div class="general-tabs">
            <ul class="nav nav-tabs">
                <li class="active">
                    <a href="#progress-bar-general-options" data-toggle="tab">
                        <i class="zmdi zmdi-settings"></i>
                        <span><?php echo Text::_('GENERAL'); ?></span>
                    </a>
                </li>
                <li>
                    <a href="#progress-bar-design-options" data-toggle="tab">
                        <i class="zmdi zmdi-format-color-fill"></i>
                        <span><?php echo Text::_('DESIGN'); ?></span>
                    </a>
                </li>
                <li>
                    <a href="#progress-bar-layout-options" data-toggle="tab">
                        <i class="zmdi zmdi-fullscreen"></i>
                        <span><?php echo Text::_('LAYOUT'); ?></span>
                    </a>
                </li>
            </ul>
            <div class="tabs-underline"></div>
            <div class="tab-content">
                <div id="progress-bar-general-options" class="row-fluid tab-pane active">
                    <div class="ba-settings-group">
                        <div class="ba-settings-item progress-bar-options">
                            <span>
                                <?php echo Text::_('LABEL'); ?>
                            </span>
                            <input type="text" placeholder="<?php echo Text::_('LABEL'); ?>" class="progress-bar-label">
                        </div>
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('TARGET_NUMBER') ?></span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="1" max="100">
                                <input type="number" class="progress-bar-target" data-callback="sectionRules">
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-desktop-windows"></i>
                            <span><?php echo Text::_('VIEW'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('TARGET_NUMBER'); ?></span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-option="target" data-group="display"
                                    class="set-desktop-view-value">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item progress-bar-options">
                            <span><?php echo Text::_('LABEL'); ?></span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-option="label" data-group="display"
                                    class="set-desktop-view-value">
                                <span></span>
                            </label>
                        </div>
                    </div>
                    <div class="ba-settings-group">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-skip-next"></i>
                            <span><?php echo Text::_('ANIMATION'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('EFFECT'); ?>
                            </span>
                            <div class="ba-custom-select progress-bar-effect-select">
                                <input readonly onfocus="this.blur()" type="text">
                                <input type="hidden">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="easeInSine">easeInSine</li>
                                    <li data-value="easeOutSine">easeOutSine</li>
                                    <li data-value="easeOutQuad">easeOutQuad</li>
                                    <li data-value="easeOutCubic">easeOutCubic</li>
                                    <li data-value="easeInQuart">easeInQuart</li>
                                    <li data-value="easeOutQuart">easeOutQuart</li>
                                    <li data-value="easeInExpo">easeInExpo</li>
                                    <li data-value="easeOutExpo">easeOutExpo</li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('DURATION'); ?></span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="4" step="0.1">
                                <input type="number" step="0.1" data-callback="sectionRules" class="progress-bar-duration">
                            </div>
                        </div>
                    </div>
<?php
                    echo $this->html->loadPassive('disable');
?>
                    <div class="ba-settings-group">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-roller"></i>
                            <span><?php echo Text::_('PRESETS'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SELECT'); ?>
                            </span>
                            <div class="ba-lg-custom-select select-preset">
                                <input type="text" readonly onfocus="this.blur()">
                                <input type="hidden">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <div class="ba-lg-custom-select-header">
                                        <span class="create-new-preset">
                                            <i class="zmdi zmdi-plus-circle"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('SAVE_PRESET'); ?></span>
                                        </span>
                                        <span class="edit-preset-item">
                                            <i class="zmdi zmdi-edit"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('EDIT'); ?></span>
                                        </span>
                                        <span class="delete-preset-item">
                                            <i class="zmdi zmdi-delete"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('DELETE'); ?></span>
                                        </span>
                                    </div>
                                    <div class="ba-lg-custom-select-body">
                                        <li data-value="">
                                            <label>
                                                <input type="radio" name="preset-checkbox" value="">
                                                <i class="zmdi zmdi-circle-o"></i>
                                                <i class="zmdi zmdi-check"></i>
                                            </label>
                                            <span><?php echo Text::_('NO_NE'); ?></span>
                                        </li>
                                    </div>
                                </ul>
                            </div>
                        </div>
                    </div>
<?php
                    echo $this->html->loadPassive('item-animation');
                    echo $this->html->loadPassive('advanced', $this->access);
?>
                </div>
                <div id="progress-bar-design-options" class="row-fluid tab-pane">
                    <div class="ba-settings-group">
                        <div class="ba-settings-item progress-bar-options">
                            <span><?php echo Text::_('HEIGHT'); ?></span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="1" max="100">
                                <input type="text" data-option="height" data-group="view" data-callback="sectionRules">
                            </div>
                        </div>
                        <div class="ba-settings-item progress-pie-options">
                            <span><?php echo Text::_('WIDTH'); ?></span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="1" max="1000">
                                <input type="text" data-option="width" data-group="view" data-callback="sectionRules">
                            </div>
                        </div>
                        <div class="ba-settings-item progress-pie-options">
                            <span><?php echo Text::_('BAR_WIDTH'); ?></span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="1" max="100">
                                <input type="text" data-option="line" data-group="view" data-callback="sectionRules">
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-format-size"></i>
                            <span><?php echo Text::_('TYPOGRAPHY'); ?></span>
                        </div>
                        <div class="theme-typography-options">
                            <div class="typography-options">
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('FONT_FAMILY'); ?>
                                    </span>
                                    <input readonly onfocus="this.blur()" type="text" data-option="font-family"
                                        data-group="typography" data-callback="sectionRules">
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('FONT_WEIGHT'); ?>
                                    </span>
                                    <input readonly onfocus="this.blur()" type="text" data-option="font-weight"
                                        data-group="typography" data-callback="sectionRules">
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('COLOR'); ?>
                                    </span>
                                    <input type="text" data-type="color" data-option="color" data-group="typography">
                                    <span class="minicolors-opacity-wrapper">
                                        <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                        min="0" max="1" step="0.01">
                                        <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                                    </span>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('SIZE'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner"></span>
                                        <input type="range" class="ba-range" min="0" max="320">
                                        <input type="text" data-option="font-size" data-group="typography" data-callback="sectionRules">
                                    </div>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('LETTER_SPACING'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner letter-spacing"></span>
                                        <input type="range" class="ba-range" min="-10" max="10">
                                        <input type="text" data-option="letter-spacing" data-group="typography"
                                            data-callback="sectionRules">
                                    </div>
                                </div>
                                <div class="ba-settings-toolbar">
                                    <label data-option="text-decoration" data-value="underline" data-group="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-underlined"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('UNDERLINE'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-transform" data-value="uppercase" data-group="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-size"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('UPPERCASE'); ?>
                                        </span>
                                    </label>
                                    <label data-option="font-style" data-value="italic" data-group="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-italic"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('ITALIC'); ?>
                                        </span>
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('BAR'); ?>
                            </span>
                            <input type="text" data-type="color" data-option="bar" data-group="view" class="minicolors-top">
                            <span class="minicolors-opacity-wrapper">
                                <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                min="0" max="1" step="0.01">
                                <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                            </span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('BACKGROUND'); ?>
                            </span>
                            <input type="text" data-type="color" data-option="background" data-group="view" class="minicolors-top">
                            <span class="minicolors-opacity-wrapper">
                                <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                min="0" max="1" step="0.01">
                                <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                            </span>
                        </div>
                    </div>
                </div>
                <div id="progress-bar-layout-options" class="row-fluid tab-pane">
<?php
                    echo $this->html->loadPassive('positioning');
                    echo $this->html->load('margin');
                    echo $this->html->load('padding');
                    $options = ['class' => 'progress-bar-options'];
                    echo $this->html->load('border', $options);
                    $options = ['class' => 'progress-bar-options'];
                    echo $this->html->load('shadow', $options);
?>
                </div>
                <i class="zmdi zmdi-more resize-handle-bottom"></i>
            </div>
        </div>
    </div>
</div>
<div id="reading-progress-bar-settings-dialog" class="ba-modal-cp draggable-modal-cp modal hide">
    <div class="modal-header">
        <span class="ba-dialog-title"></span>
        <div class="modal-header-icon">
            <div class="ba-custom-select select-modal-cp-position">
                <i class="zmdi zmdi-more-vert"></i>
                <input type="hidden">
                <ul>
                    <li data-value=""><?php echo Text::_('SEPARATE_WINDOW') ?></li>
                    <li data-value="right"><?php echo Text::_('PANEL_TO_RIGHT') ?></li>
                </ul>
            </div>
            <i class="zmdi zmdi-close close-cp-modal"></i>
        </div>
    </div>
    <div class="modal-body">
        <div class="general-tabs">
            <ul class="nav nav-tabs">
                <li class="active">
                    <a href="#reading-progress-bar-general-options" data-toggle="tab">
                        <i class="zmdi zmdi-settings"></i>
                        <span><?php echo Text::_('GENERAL'); ?></span>
                    </a>
                </li>
                <li>
                    <a href="#reading-progress-bar-design-options" data-toggle="tab">
                        <i class="zmdi zmdi-format-color-fill"></i>
                        <span><?php echo Text::_('DESIGN'); ?></span>
                    </a>
                </li>
            </ul>
            <div class="tabs-underline"></div>
            <div class="tab-content">
                <div id="reading-progress-bar-general-options" class="row-fluid tab-pane active">
                    <div class="ba-settings-group">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('DISPLAY'); ?>
                            </span>
                            <div class="ba-custom-select reading-progress-bar-display-select">
                                <input readonly onfocus="this.blur()" type="text" value="">
                                <input type="hidden" value="">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="page"><?php echo Text::_('PAGE'); ?></li>
                                    <li data-value="content"><?php echo Text::_('CONTENT'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('POSITION'); ?>
                            </span>
                            <div class="ba-custom-select reading-progress-bar-position-select">
                                <input readonly onfocus="this.blur()" type="text" value="">
                                <input type="hidden" value="">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="top"><?php echo Text::_('TOP'); ?></li>
                                    <li data-value="bottom"><?php echo Text::_('BOTTOM'); ?></li>
                                </ul>
                            </div>
                        </div>
                    </div>
<?php
                    echo $this->html->loadPassive('disable');
?>
                    <div class="ba-settings-group">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-roller"></i>
                            <span><?php echo Text::_('PRESETS'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SELECT'); ?>
                            </span>
                            <div class="ba-lg-custom-select select-preset">
                                <input type="text" readonly onfocus="this.blur()">
                                <input type="hidden">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <div class="ba-lg-custom-select-header">
                                        <span class="create-new-preset">
                                            <i class="zmdi zmdi-plus-circle"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('SAVE_PRESET'); ?></span>
                                        </span>
                                        <span class="edit-preset-item">
                                            <i class="zmdi zmdi-edit"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('EDIT'); ?></span>
                                        </span>
                                        <span class="delete-preset-item">
                                            <i class="zmdi zmdi-delete"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('DELETE'); ?></span>
                                        </span>
                                    </div>
                                    <div class="ba-lg-custom-select-body">
                                        <li data-value="">
                                            <label>
                                                <input type="radio" name="preset-checkbox" value="">
                                                <i class="zmdi zmdi-circle-o"></i>
                                                <i class="zmdi zmdi-check"></i>
                                            </label>
                                            <span><?php echo Text::_('NO_NE'); ?></span>
                                        </li>
                                    </div>
                                </ul>
                            </div>
                        </div>
                    </div>
<?php
                    echo $this->html->loadPassive('item-animation');
                    echo $this->html->loadPassive('advanced', $this->access);
?>
                </div>
                <div id="reading-progress-bar-design-options" class="row-fluid tab-pane">
                    <div class="ba-settings-group">
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('HEIGHT'); ?></span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="1" max="100">
                                <input type="text" data-option="height" data-group="view" data-callback="sectionRules">
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('BAR'); ?>
                            </span>
                            <input type="text" data-type="color" data-option="bar" data-group="view" class="minicolors-top">
                            <span class="minicolors-opacity-wrapper">
                                <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                min="0" max="1" step="0.01">
                                <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                            </span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('BACKGROUND'); ?>
                            </span>
                            <input type="text" data-type="color" data-option="background" data-group="view" class="minicolors-top">
                            <span class="minicolors-opacity-wrapper">
                                <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                min="0" max="1" step="0.01">
                                <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                            </span>
                        </div>
                    </div>
                </div>
                <i class="zmdi zmdi-more resize-handle-bottom"></i>
            </div>
        </div>
    </div>
</div>
<div id="text-editor-dialog" class="ba-modal-cp draggable-modal-cp modal hide">
    <div class="modal-header">
        <span class="ba-dialog-title"></span>
        <div class="modal-header-icon">
            <div class="ba-custom-select select-modal-cp-position">
                <i class="zmdi zmdi-more-vert"></i>
                <input type="hidden">
                <ul>
                    <li data-value=""><?php echo Text::_('SEPARATE_WINDOW') ?></li>
                    <li data-value="right"><?php echo Text::_('PANEL_TO_RIGHT') ?></li>
                </ul>
            </div>
            <i class="zmdi zmdi-fullscreen resize-text-editor"></i>
            <i class="zmdi zmdi-close close-cp-modal"></i>
        </div>
    </div>
    <div class="modal-body">
        <div class="general-tabs">
            <ul class="nav nav-tabs">
                <li class="active">
                    <a href="#text-editor-general-options" data-toggle="tab">
                        <i class="zmdi zmdi-settings"></i>
                        <span><?php echo Text::_('GENERAL'); ?></span>
                    </a>
                </li>
                <li>
                    <a href="#text-editor-design-options" data-toggle="tab">
                        <i class="zmdi zmdi-format-color-fill"></i>
                        <span><?php echo Text::_('DESIGN'); ?></span>
                    </a>
                </li>
                <li>
                    <a href="#text-editor-layout-options" data-toggle="tab">
                        <i class="zmdi zmdi-fullscreen"></i>
                        <span><?php echo Text::_('LAYOUT'); ?></span>
                    </a>
                </li>
            </ul>
            <div class="tabs-underline"></div>
            <div class="tab-content">
                <div id="text-editor-general-options" class="row-fluid tab-pane active">
                    <div class="ba-settings-group">
                        <div class="ba-settings-item">
                            <div class="ba-editor-wrapper">
<?php
                            if (!empty($this->jce) && $this->jce * 1 === 1) {
                                echo $this->form->getInput('editor');
                            } else {
?>
                                <textarea id="editor"></textarea>
<script>
    var CKE = CKEDITOR.replace('editor');
</script>
<?php
                            }
?>
                            </div>
                        </div>
                    </div>
<?php
                    echo $this->html->loadPassive('disable');
                    echo $this->html->loadPassive('item-animation');
                    echo $this->html->loadPassive('advanced', $this->access);
?>
                </div>
                <div id="text-editor-design-options" class="row-fluid tab-pane">
                    <div class="ba-settings-group text-typography-options">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-format-size"></i>
                            <span><?php echo Text::_('TYPOGRAPHY'); ?></span>
                        </div>
                        <div class="ba-settings-item ba-typography-select-wrapper">
                            <span>
                                <?php echo Text::_('TYPOGRAPHY'); ?>
                            </span>
                            <div class="ba-custom-select typography-select">
                                <input readonly onfocus="this.blur()" value="H1" type="text">
                                <input type="hidden" value="h1">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="h1">H1</li>
                                    <li data-value="h2">H2</li>
                                    <li data-value="h3">H3</li>
                                    <li data-value="h4">H4</li>
                                    <li data-value="h5">H5</li>
                                    <li data-value="h6">H6</li>
                                    <li data-value="p">Paragraph</li>
                                    <li data-value="links"><?php echo Text::_('LINKS') ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="theme-typography-options">
                            <div class="typography-options">
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('FONT_FAMILY'); ?>
                                    </span>
                                    <input readonly onfocus="this.blur()" type="text" data-option="font-family"
                                        data-group="h1" data-callback="sectionRules">
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('FONT_WEIGHT'); ?>
                                    </span>
                                    <input readonly onfocus="this.blur()" type="text" data-option="font-weight"
                                        data-group="h1" data-callback="sectionRules">
                                </div>
                                <div class="ba-settings-item select-text-type">
                                    <span>
                                        <?php echo Text::_('TYPE'); ?>
                                    </span>
                                    <div class="ba-custom-select text-type-select">
                                        <input readonly onfocus="this.blur()" type="text">
                                        <input type="hidden" data-property="text" data-group="" data-option="type">
                                        <i class="zmdi zmdi-caret-down"></i>
                                        <ul>
                                            <li data-value=""><?php echo Text::_('COLOR') ?></li>
                                            <li data-value="gradient"><?php echo Text::_('GRADIENT') ?></li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="ba-settings-item text-color-options">
                                    <span>
                                        <?php echo Text::_('COLOR'); ?>
                                    </span>
                                    <input type="text" data-type="color" data-option="color" data-group="h1">
                                    <span class="minicolors-opacity-wrapper">
                                        <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                        min="0" max="1" step="0.01">
                                        <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                                    </span>
                                </div>
                                <div class="text-gradient-options">
                                    <div class="ba-settings-item ba-disable-states">
                                        <span>
                                            <?php echo Text::_('EFFECT'); ?>
                                        </span>
                                        <div class="ba-custom-select gradient-effect-select">
                                            <input readonly onfocus="this.blur()" type="text">
                                            <input type="hidden" data-property="text" data-group="" data-subgroup="gradient" data-option="effect">
                                            <i class="zmdi zmdi-caret-down"></i>
                                            <ul>
                                                <li data-value="linear">Linear</li>
                                                <li data-value="radial">Radial</li>
                                            </ul>
                                        </div>
                                    </div>
                                    <div class="ba-settings-item text-linear-gradient ba-disable-states">
                                        <span>
                                            <?php echo Text::_('ANGLE'); ?>
                                        </span>
                                        <div class="ba-range-wrapper">
                                            <span class="ba-range-liner"></span>
                                            <input type="range" class="ba-range" min="0" max="360" step="1">
                                            <input type="number" data-option="angle" data-group="" data-subgroup="gradient"
                                                step="1" data-callback="sectionRules">
                                        </div>
                                    </div>
                                    <div class="ba-settings-item ba-disable-states">
                                        <span>
                                            <?php echo Text::_('START_COLOR'); ?>
                                        </span>
                                        <input type="text" data-type="color" data-option="color1" data-group=""
                                            data-subgroup="gradient">
                                        <span class="minicolors-opacity-wrapper">
                                            <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                            min="0" max="1" step="0.01">
                                            <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                                        </span>
                                    </div>
                                    <div class="ba-settings-item ba-disable-states">
                                        <span>
                                            <?php echo Text::_('POSITION'); ?>
                                        </span>
                                        <div class="ba-range-wrapper">
                                            <span class="ba-range-liner"></span>
                                            <input type="range" class="ba-range" min="0" max="100" step="1">
                                            <input type="number" data-option="position1" data-group="" data-subgroup="gradient"
                                                step="1" data-callback="sectionRules">
                                        </div>
                                    </div>
                                    <div class="ba-settings-item ba-disable-states">
                                        <span>
                                            <?php echo Text::_('END_COLOR'); ?>
                                        </span>
                                        <input type="text" data-type="color" data-option="color2" data-group=""
                                            data-subgroup="gradient">
                                        <span class="minicolors-opacity-wrapper">
                                            <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                            min="0" max="1" step="0.01">
                                            <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                                        </span>
                                    </div>
                                    <div class="ba-settings-item ba-disable-states">
                                        <span>
                                            <?php echo Text::_('POSITION'); ?>
                                        </span>
                                        <div class="ba-range-wrapper">
                                            <span class="ba-range-liner"></span>
                                            <input type="range" class="ba-range" min="0" max="100" step="1">
                                            <input type="number" data-option="position2" data-group="" data-subgroup="gradient"
                                                step="1" data-callback="sectionRules">
                                        </div>
                                    </div>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('SIZE'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner"></span>
                                        <input type="range" class="ba-range" min="0" max="320">
                                        <input type="text" data-option="font-size" data-group="h1" data-callback="sectionRules">
                                    </div>
                                    <div class="reset-text-typography-wrapper">
                                        <i class="zmdi zmdi-replay reset-text-typography" data-type="reset"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('RESET'); ?>
                                        </span>
                                    </div>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('LETTER_SPACING'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner letter-spacing"></span>
                                        <input type="range" class="ba-range" min="-10" max="10" ba-range-wrapper>
                                        <input type="text" data-option="letter-spacing" data-group="h1" data-callback="sectionRules">
                                    </div>
                                    <div class="reset-text-typography-wrapper">
                                        <i class="zmdi zmdi-replay reset-text-typography" data-type="reset"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('RESET'); ?>
                                        </span>
                                    </div>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('LINE_HEIGHT'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner"></span>
                                        <input type="range" class="ba-range" min="0" max="640" ba-range-wrapper>
                                        <input type="text" data-option="line-height" data-group="h1" data-callback="sectionRules">
                                    </div>
                                    <div class="reset-text-typography-wrapper">
                                        <i class="zmdi zmdi-replay reset-text-typography" data-type="reset"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('RESET'); ?>
                                        </span>
                                    </div>
                                </div>
                                <div class="ba-settings-toolbar">
                                    <label data-option="text-decoration" data-value="underline" data-group="h1"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-underlined"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('UNDERLINE'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-transform" data-value="uppercase" data-group="h1" data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-size"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('UPPERCASE'); ?>
                                        </span>
                                    </label>
                                    <label data-option="font-style" data-value="italic" data-group="h1" data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-italic"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('ITALIC'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-align" data-value="left" data-group="h1" data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-align-left"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('LEFT'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-align" data-value="center" data-group="h1" data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-align-center"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('CENTER'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-align" data-value="right" data-group="h1" data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-align-right"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('RIGHT'); ?>
                                        </span>
                                    </label>
                                </div>
                                <div class="ba-settings-item links" style="display: none;">
                                    <span>
                                        <?php echo Text::_('COLOR'); ?>
                                    </span>
                                    <input type="text" data-type="color" data-option="color" data-group="links">
                                    <span class="minicolors-opacity-wrapper">
                                        <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                        min="0" max="1" step="0.01">
                                        <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                                    </span>
                                </div>
                                <div class="ba-settings-item links" style="display: none;">
                                    <span>
                                        <?php echo Text::_('HOVER'); ?>
                                    </span>
                                    <input type="text" data-type="color" data-option="hover-color" data-group="links">
                                    <span class="minicolors-opacity-wrapper">
                                        <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                        min="0" max="1" step="0.01">
                                        <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div id="text-editor-layout-options" class="row-fluid tab-pane">
<?php
                    echo $this->html->loadPassive('positioning');
                    echo $this->html->load('margin');
?>
                </div>
                <i class="zmdi zmdi-more resize-handle-bottom"></i>
            </div>
        </div>
    </div>
</div>
<div id="content-slider-settings-dialog" class="ba-modal-cp draggable-modal-cp modal hide">
    <div class="modal-header">
        <span class="ba-dialog-title"></span>
        <div class="modal-header-icon">
            <div class="ba-custom-select select-modal-cp-position">
                <i class="zmdi zmdi-more-vert"></i>
                <input type="hidden">
                <ul>
                    <li data-value=""><?php echo Text::_('SEPARATE_WINDOW') ?></li>
                    <li data-value="right"><?php echo Text::_('PANEL_TO_RIGHT') ?></li>
                </ul>
            </div>
            <i class="zmdi zmdi-close close-cp-modal"></i>
        </div>
    </div>
    <div class="modal-body">
        <div class="general-tabs">
            <ul class="nav nav-tabs">
                <li class="active">
                    <a href="#content-slider-general-options" data-toggle="tab">
                        <i class="zmdi zmdi-settings"></i>
                        <span><?php echo Text::_('GENERAL'); ?></span>
                    </a>
                </li>
                <li>
                    <a href="#content-slider-design-options" data-toggle="tab">
                        <i class="zmdi zmdi-format-color-fill"></i>
                        <span><?php echo Text::_('DESIGN'); ?></span>
                    </a>
                </li>
                <li>
                    <a href="#content-slider-layout-options" data-toggle="tab">
                        <i class="zmdi zmdi-fullscreen"></i>
                        <span><?php echo Text::_('LAYOUT'); ?></span>
                    </a>
                </li>
            </ul>
            <div class="tabs-underline"></div>
            <div class="tab-content">
                <div id="content-slider-general-options" class="row-fluid tab-pane active">
<?php
                    include $htmlPath.'ba-settings-group-items-list.php';
?>
                    <div class="ba-settings-group">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-desktop-windows"></i>
                            <span><?php echo Text::_('VIEW'); ?></span>
                        </div>
                        <div class="ba-settings-item slideshow-options">
                            <span><?php echo Text::_('FULLSCREEN'); ?></span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-option="fullscreen" data-group="view" class="set-value-css">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('HEIGHT'); ?></span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="1500">
                                <input type="text" data-option="height" data-group="view" data-callback="sectionRules">
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('ARROWS'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-group="view" data-option="arrows" class="set-desktop-view-value">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('DOTS'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-group="view" data-option="dots" class="set-desktop-view-value">
                                <span></span>
                            </label>
                        </div>
                    </div>
                    <div class="ba-settings-group">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-tune"></i>
                            <span><?php echo Text::_('SETTINGS'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('AUTOPLAY'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-option="autoplay" data-group="slideshow">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('PAUSE_ON_MOUSEOVER'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-option="pause" data-group="slideshow">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SLIDE_DELAY'); ?>, ms
                            </span>
                            <input type="number" data-option="delay" data-group="slideshow" class="lightbox-settings-input"
                                placeholder="<?php echo Text::_('SLIDE_DELAY'); ?>">
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('ANIMATION'); ?>
                            </span>
                            <div class="ba-custom-select slideshow-animation-select">
                                <input readonly="" onfocus="this.blur()" type="text" value="">
                                <input type="hidden" value="ba-fade-in">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="ba-fade-in" selected="selected">Fade</li>
                                    <li data-value="ba-offset-horizontal">Offset Horizontal</li>
                                    <li data-value="ba-offset-horizontal-fast">Offset Horizontal Fast</li>
                                    <li data-value="ba-offset-vertical">Offset Vertical</li>
                                    <li data-value="ba-offset-vertical-fast">Offset Vertical Fast</li>
                                    <li data-value="ba-ken-burns">Ken Burns</li>
                                </ul>
                            </div>
                        </div>
                    </div>
<?php
                    echo $this->html->loadPassive('disable');
?>
                    <div class="ba-settings-group">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-roller"></i>
                            <span><?php echo Text::_('PRESETS'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SELECT'); ?>
                            </span>
                            <div class="ba-lg-custom-select select-preset">
                                <input type="text" readonly onfocus="this.blur()">
                                <input type="hidden">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <div class="ba-lg-custom-select-header">
                                        <span class="create-new-preset">
                                            <i class="zmdi zmdi-plus-circle"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('SAVE_PRESET'); ?></span>
                                        </span>
                                        <span class="edit-preset-item">
                                            <i class="zmdi zmdi-edit"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('EDIT'); ?></span>
                                        </span>
                                        <span class="delete-preset-item">
                                            <i class="zmdi zmdi-delete"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('DELETE'); ?></span>
                                        </span>
                                    </div>
                                    <div class="ba-lg-custom-select-body">
                                        <li data-value="">
                                            <label>
                                                <input type="radio" name="preset-checkbox" value="">
                                                <i class="zmdi zmdi-circle-o"></i>
                                                <i class="zmdi zmdi-check"></i>
                                            </label>
                                            <span><?php echo Text::_('NO_NE'); ?></span>
                                        </li>
                                    </div>
                                </ul>
                            </div>
                        </div>
                    </div>
<?php
                    echo $this->html->loadPassive('item-animation');
                    echo $this->html->loadPassive('advanced', $this->access);
?>
                </div>
                <div id="content-slider-design-options" class="row-fluid tab-pane">
                    <div class="ba-settings-group slideshow-design-group">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SELECT'); ?>
                            </span>
                            <div class="ba-custom-select slideshow-style-custom-select">
                                <input readonly onfocus="this.blur()" type="text" value="">
                                <input type="hidden" value="">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="arrows"><?php echo Text::_('ARROWS'); ?></li>
                                    <li data-value="dots"><?php echo Text::_('DOTS'); ?></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group slideshow-dots-options">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('COLOR'); ?>
                            </span>
                            <input type="text" data-type="color" data-option="color" data-group="" data-subgroup="normal"
                                class="icon-color">
                            <span class="minicolors-opacity-wrapper">
                                <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                min="0" max="1" step="0.01">
                                <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                            </span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('HOVER_ACTIVE'); ?>
                            </span>
                            <input type="text" data-type="color" data-option="color" data-group="" data-subgroup="hover"
                                class="icon-color">
                            <span class="minicolors-opacity-wrapper">
                                <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                min="0" max="1" step="0.01">
                                <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                            </span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SIZE'); ?>
                            </span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="1000">
                                <input type="text" data-option="size" data-group="" data-subgroup="" data-callback="sectionRules">
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group slideshow-arrows-options">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SIZE'); ?>
                            </span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="1000">
                                <input type="text" data-option="size" data-group="" data-subgroup=""
                                    data-callback="sectionRules">
                            </div>
                        </div>
                    </div>
<?php
                    $options = ['group' => '', 'subgroup' => 'colors'];
                    echo $this->html->load('colors', $options);
?>
                    <div class="ba-settings-group slideshow-arrows-options">
                        <div class="settings-group-title">
                            <span><?php echo Text::_('PADDING'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('VALUE'); ?>
                            </span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="1000">
                                <input type="text" data-option="padding" data-group="" data-subgroup="" data-callback="sectionRules">
                            </div>
                        </div>
                    </div>
<?php
                    $options = ['class' => 'slideshow-border-options', 'group' => '', 'subgroup' => 'border'];
                    echo $this->html->load('border', $options);
                    $options = ['class' => 'slideshow-shadow-options', 'subgroup' => 'shadow', 'group' => ''];
                    echo $this->html->load('shadow', $options);
?>
                </div>
                <div id="content-slider-layout-options" class="row-fluid tab-pane">
<?php
                    echo $this->html->loadPassive('positioning');
                    echo $this->html->load('margin');
                    echo $this->html->load('padding');
                    echo $this->html->load('border');
                    echo $this->html->load('shadow');
?>
                </div>
                <i class="zmdi zmdi-more resize-handle-bottom"></i>
            </div>
        </div>
    </div>
</div>
<div id="testimonials-settings-dialog" class="ba-modal-cp draggable-modal-cp modal hide">
    <div class="modal-header">
        <span class="ba-dialog-title"></span>
        <div class="modal-header-icon">
            <div class="ba-custom-select select-modal-cp-position">
                <i class="zmdi zmdi-more-vert"></i>
                <input type="hidden">
                <ul>
                    <li data-value=""><?php echo Text::_('SEPARATE_WINDOW') ?></li>
                    <li data-value="right"><?php echo Text::_('PANEL_TO_RIGHT') ?></li>
                </ul>
            </div>
            <i class="zmdi zmdi-close close-cp-modal"></i>
        </div>
    </div>
    <div class="modal-body">
        <div class="general-tabs">
            <ul class="nav nav-tabs">
                <li class="active">
                    <a href="#testimonials-general-options" data-toggle="tab">
                        <i class="zmdi zmdi-settings"></i>
                        <span><?php echo Text::_('GENERAL'); ?></span>
                    </a>
                </li>
                <li>
                    <a href="#testimonials-design-options" data-toggle="tab">
                        <i class="zmdi zmdi-format-color-fill"></i>
                        <span><?php echo Text::_('DESIGN'); ?></span>
                    </a>
                </li>
                <li>
                    <a href="#testimonials-layout-options" data-toggle="tab">
                        <i class="zmdi zmdi-fullscreen"></i>
                        <span><?php echo Text::_('LAYOUT'); ?></span>
                    </a>
                </li>
            </ul>
            <div class="tabs-underline"></div>
            <div class="tab-content">
                <div id="testimonials-general-options" class="row-fluid tab-pane active">
<?php
                    include $htmlPath.'ba-settings-group-items-list.php';
?>
                    <div class="ba-settings-group">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-desktop-windows"></i>
                            <span><?php echo Text::_('VIEW'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('ITEMS_PER_SLIDE'); ?>
                            </span>
                            <input type="number" data-option="count" data-group="slideset" class="lightbox-settings-input"
                                placeholder="3">
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('LAYOUT'); ?>
                            </span>
                            <div class="ba-custom-select select-testimonial-layout">
                                <input readonly onfocus="this.blur()" type="text" value="">
                                <input type="hidden" value="">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="style-1"><?php echo Text::_("STYLE"); ?> 1</li>
                                    <li data-value="style-2"><?php echo Text::_("STYLE"); ?> 2</li>
                                    <li data-value="style-3"><?php echo Text::_("STYLE"); ?> 3</li>
                                    <li data-value="style-4"><?php echo Text::_("STYLE"); ?> 4</li>
                                    <li data-value="style-5"><?php echo Text::_("STYLE"); ?> 5</li>
                                    <li data-value="style-6"><?php echo Text::_("STYLE"); ?> 6</li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('ARROWS'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-group="view" data-option="arrows" class="set-desktop-view-value">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item slideset-options">
                            <span>
                                <?php echo Text::_('DOTS'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-group="view" data-option="dots" class="set-desktop-view-value">
                                <span></span>
                            </label>
                        </div>
                    </div>
                    <div class="ba-settings-group">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-tune"></i>
                            <span><?php echo Text::_('SETTINGS'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('AUTOPLAY'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-option="autoplay" data-group="slideset">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('PAUSE_ON_MOUSEOVER'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-option="pause" data-group="slideset">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SLIDE_DELAY'); ?>, ms
                            </span>
                            <input type="number" data-option="delay" data-group="slideset" class="lightbox-settings-input"
                                placeholder="<?php echo Text::_('SLIDE_DELAY'); ?>">
                        </div>
                    </div>
<?php
                    echo $this->html->loadPassive('disable');
?>
                    <div class="ba-settings-group">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-roller"></i>
                            <span><?php echo Text::_('PRESETS'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SELECT'); ?>
                            </span>
                            <div class="ba-lg-custom-select select-preset">
                                <input type="text" readonly onfocus="this.blur()">
                                <input type="hidden">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <div class="ba-lg-custom-select-header">
                                        <span class="create-new-preset">
                                            <i class="zmdi zmdi-plus-circle"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('SAVE_PRESET'); ?></span>
                                        </span>
                                        <span class="edit-preset-item">
                                            <i class="zmdi zmdi-edit"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('EDIT'); ?></span>
                                        </span>
                                        <span class="delete-preset-item">
                                            <i class="zmdi zmdi-delete"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('DELETE'); ?></span>
                                        </span>
                                    </div>
                                    <div class="ba-lg-custom-select-body">
                                        <li data-value="">
                                            <label>
                                                <input type="radio" name="preset-checkbox" value="">
                                                <i class="zmdi zmdi-circle-o"></i>
                                                <i class="zmdi zmdi-check"></i>
                                            </label>
                                            <span><?php echo Text::_('NO_NE'); ?></span>
                                        </li>
                                    </div>
                                </ul>
                            </div>
                        </div>
                    </div>
<?php
                    echo $this->html->loadPassive('item-animation');
                    echo $this->html->loadPassive('advanced', $this->access);
?>
                </div>
                <div id="testimonials-design-options" class="row-fluid tab-pane">
                    <div class="ba-settings-group slideshow-design-group">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SELECT'); ?>
                            </span>
                            <div class="ba-custom-select select-testimonials-options">
                                <input readonly onfocus="this.blur()" type="text" value="">
                                <input type="hidden" value="">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="testimonial"><?php echo Text::_('TESTIMONIAL'); ?></li>
                                    <li data-value="image"><?php echo Text::_('IMAGE'); ?></li>
                                    <li data-value="name"><?php echo Text::_('NAME'); ?></li>
                                    <li data-value="caption"><?php echo Text::_('CAPTION'); ?></li>
                                    <li data-value="icon"><?php echo Text::_('ICON'); ?></li>
                                    <li data-value="arrows"><?php echo Text::_('ARROWS'); ?></li>
                                    <li data-value="dots"><?php echo Text::_('DOTS'); ?></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group testimonials-image-options">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SIZE'); ?>
                            </span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="10" max="1500">
                                <input type="text" data-option="width" data-group="image" data-callback="testimonialsCallback">
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group testimonials-icon-options">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SIZE'); ?>
                            </span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="10" max="1500">
                                <input type="text" data-option="size" data-group="icon" data-callback="testimonialsCallback">
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('COLOR'); ?>
                            </span>
                            <input type="text" data-type="color" data-option="color" data-group="icon" class="icon-color">
                            <span class="minicolors-opacity-wrapper">
                                <input type="number" class="minicolors-opacity" data-callback="testimonialsCallback"
                                min="0" max="1" step="0.01">
                                <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                            </span>
                        </div>
                    </div>
                    <div class="ba-settings-group slideshow-typography-options">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-format-size"></i>
                            <span><?php echo Text::_('TYPOGRAPHY'); ?></span>
                        </div>
                        <div class="theme-typography-options">
                            <div class="typography-options">
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('FONT_FAMILY'); ?>
                                    </span>
                                    <input readonly onfocus="this.blur()" type="text" data-option="font-family"
                                        data-group="" data-subgroup="typography" data-callback="testimonialsCallback">
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('FONT_WEIGHT'); ?>
                                    </span>
                                    <input readonly onfocus="this.blur()" type="text" data-option="font-weight" data-group=""
                                        data-subgroup="typography" data-callback="testimonialsCallback">
                                </div>
                                <div class="ba-settings-item slideshow-typography-color">
                                    <span>
                                        <?php echo Text::_('COLOR'); ?>
                                    </span>
                                    <input type="text" data-type="color" data-option="color" data-group="" data-subgroup="typography">
                                    <span class="minicolors-opacity-wrapper">
                                        <input type="number" class="minicolors-opacity" data-callback="testimonialsCallback"
                                        min="0" max="1" step="0.01">
                                        <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                                    </span>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('SIZE'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner"></span>
                                        <input type="range" class="ba-range" min="0" max="320">
                                        <input type="text" data-option="font-size" data-group="" data-subgroup="typography"
                                            data-callback="testimonialsCallback">
                                    </div>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('LETTER_SPACING'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner letter-spacing"></span>
                                        <input type="range" class="ba-range" min="-10" max="10">
                                        <input type="text" data-option="letter-spacing" data-group="" data-subgroup="typography"
                                            data-callback="testimonialsCallback">
                                    </div>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('LINE_HEIGHT'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner"></span>
                                        <input type="range" class="ba-range" min="0" max="640">
                                        <input type="text" data-option="line-height" data-group="" data-subgroup="typography"
                                            data-callback="testimonialsCallback">
                                    </div>
                                </div>
                                <div class="ba-settings-toolbar">
                                    <label data-option="text-decoration" data-value="underline" data-group="" data-subgroup="typography"
                                        data-callback="testimonialsCallback">
                                        <i class="zmdi zmdi-format-underlined"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('UNDERLINE'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-transform" data-value="uppercase" data-group="" data-subgroup="typography"
                                        data-callback="testimonialsCallback">
                                        <i class="zmdi zmdi-format-size"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('UPPERCASE'); ?>
                                        </span>
                                    </label>
                                    <label data-option="font-style" data-value="italic" data-group="" data-subgroup="typography"
                                        data-callback="testimonialsCallback">
                                        <i class="zmdi zmdi-format-italic"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('ITALIC'); ?>
                                        </span>
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group testimonials-dots-options">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('COLOR'); ?>
                            </span>
                            <input type="text" data-type="color" data-option="color" data-group="" data-subgroup="normal"
                                class="icon-color">
                            <span class="minicolors-opacity-wrapper">
                                <input type="number" class="minicolors-opacity" data-callback="testimonialsCallback"
                                min="0" max="1" step="0.01">
                                <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                            </span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('HOVER_ACTIVE'); ?>
                            </span>
                            <input type="text" data-type="color" data-option="color" data-group="" data-subgroup="hover"
                                class="icon-color">
                            <span class="minicolors-opacity-wrapper">
                                <input type="number" class="minicolors-opacity" data-callback="testimonialsCallback"
                                min="0" max="1" step="0.01">
                                <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                            </span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SIZE'); ?>
                            </span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="1000">
                                <input type="text" data-option="size" data-group="" data-subgroup="" data-callback="testimonialsCallback">
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group testimonials-arrows-options">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SIZE'); ?>
                            </span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="1000">
                                <input type="text" data-option="size" data-group="" data-subgroup="" data-callback="testimonialsCallback">
                            </div>
                        </div>
                    </div>
<?php
                    $options = ['group' => '', 'subgroup' => 'colors'];
                    echo $this->html->load('colors', $options);
?>
                    <div class="ba-settings-group testimonials-arrows-options">
                        <div class="settings-group-title">
                            <span><?php echo Text::_('PADDING'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('VALUE'); ?>
                            </span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="1000">
                                <input type="text" data-option="padding" data-group="" data-subgroup=""
                                    data-callback="testimonialsCallback">
                            </div>
                        </div>
                    </div>
<?php
                    $options = ['class' => 'testimonials-border-options', 'group' => '', 'subgroup' => 'border'];
                    echo $this->html->load('border', $options);
                    $options = ['class' => 'testimonials-shadow-options', 'subgroup' => 'shadow', 'group' => ''];
                    echo $this->html->load('shadow', $options);
?>
                    <div class="ba-settings-group testimonials-background-options">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-format-color-fill"></i>
                            <span><?php echo Text::_('BACKGROUND'); ?></span>
                        </div>
                        <div class="ba-settings-item background">
                            <span>
                                <?php echo Text::_('COLOR'); ?>
                            </span>
                            <input type="text" data-type="color" data-option="color" data-group="background" class="minicolors-top">
                            <span class="minicolors-opacity-wrapper">
                                <input type="number" class="minicolors-opacity" data-callback="testimonialsCallback"
                                min="0" max="1" step="0.01">
                                <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                            </span>
                        </div>
                    </div>
                </div>
                <div id="testimonials-layout-options" class="row-fluid tab-pane">
<?php
                    echo $this->html->loadPassive('positioning');
                    echo $this->html->load('margin');
                    echo $this->html->load('padding');
                    echo $this->html->load('border');
                    echo $this->html->load('shadow');
?>
                </div>
                <i class="zmdi zmdi-more resize-handle-bottom"></i>
            </div>
        </div>
    </div>
</div>
<div id="preloader-settings-dialog" class="ba-modal-cp draggable-modal-cp modal hide">
    <div class="modal-header">
        <span class="ba-dialog-title"></span>
        <div class="modal-header-icon">
            <div class="ba-custom-select select-modal-cp-position">
                <i class="zmdi zmdi-more-vert"></i>
                <input type="hidden">
                <ul>
                    <li data-value=""><?php echo Text::_('SEPARATE_WINDOW') ?></li>
                    <li data-value="right"><?php echo Text::_('PANEL_TO_RIGHT') ?></li>
                </ul>
            </div>
            <i class="zmdi zmdi-close close-cp-modal"></i>
        </div>
    </div>
    <div class="modal-body">
        <div class="general-tabs">
            <ul class="nav nav-tabs">
                <li class="active">
                    <a href="#preloader-general-options" data-toggle="tab">
                        <i class="zmdi zmdi-settings"></i>
                        <span><?php echo Text::_('GENERAL'); ?></span>
                    </a>
                </li>
                <li>
                    <a href="#preloader-design-options" data-toggle="tab">
                        <i class="zmdi zmdi-format-color-fill"></i>
                        <span><?php echo Text::_('DESIGN'); ?></span>
                    </a>
                </li>
            </ul>
            <div class="tabs-underline"></div>
            <div class="tab-content">
                <div id="preloader-general-options" class="row-fluid tab-pane active">
                    <div class="ba-settings-group">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('TYPE'); ?>
                            </span>
                            <div class="ba-custom-select preloader-type-select">
                                <input readonly="" onfocus="this.blur()" type="text">
                                <input type="hidden">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="spinner"><?php echo Text::_('SPINNER'); ?></li>
                                    <li data-value="image"><?php echo Text::_('IMAGE'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="spinner-options">
                            <div class="ba-settings-item">
                                <span><?php echo Text::_('SPINNER'); ?></span>
                                <input type="text" class="select-spinner" readonly="" onfocus="this.blur()">
                            </div>
                        </div>
                        <div class="image-options">
                            <div class="ba-settings-item">
                                <span>
                                    <?php echo Text::_('SELECT'); ?>
                                </span>
                                <input type="text" class="select-input select-preloader-image" readonly onfocus="this.blur()" 
                                    placeholder="<?php echo Text::_('SELECT'); ?>">
                                <i class="zmdi zmdi-attachment-alt"></i>
                            </div>
                            <div class="ba-settings-item">
                                <span>
                                    <?php echo Text::_('WIDTH'); ?>
                                </span>
                                <div class="ba-range-wrapper">
                                    <span class="ba-range-liner"></span>
                                    <input type="range" class="ba-range" min="0" max="2500">
                                    <input type="text" data-option="width" data-callback="sectionRules">
                                </div>
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SHOW_ONCE_PER_SESSION'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-option="enable" data-group="session" class="set-value-css">
                                <span></span>
                            </label>
                            <label class="ba-help-icon">
                                <i class="zmdi zmdi-help"></i>
                                <span class="ba-tooltip ba-help">
                                    <?php echo Text::_('DISPLAY_ONCE_PER_SESSION_TOOLTIP'); ?>
                                </span>
                            </label>
                        </div>
                    </div>
                    <div class="ba-settings-group">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-skip-next"></i>
                            <span><?php echo Text::_('ANIMATION'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('EFFECT'); ?>
                            </span>
                            <div class="ba-custom-select preloader-animation-select">
                                <input readonly onfocus="this.blur()" type="text">
                                <input type="hidden" >
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="ba-pt-circle">Circle</li>
                                    <li data-value="ba-pt-frame">Frame It</li>
                                    <li data-value="ba-pt-fade">Fade</li>
                                    <li data-value="ba-pt-slide-up">Slide Up</li>
                                    <li data-value="ba-pt-slide-right">Slide Right</li>
                                    <li data-value="ba-pt-slide-left">Slide Left</li>
                                    <li data-value="ba-pt-slide-bottom">Slide Bottom</li>
                                    <li data-value="ba-pt-split-diagonal">Split Diagonal</li>
                                    <li data-value="ba-pt-split-diamond">Split Diamond</li>
                                    <li data-value="ba-pt-split-vertical">Split Vertical</li>
                                    <li data-value="ba-pt-split-horizontal">Split Horizontal</li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('DELAY'); ?></span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="5" step="0.1">
                                <input type="number" data-option="delay" step="0.1" data-callback="sectionRules">
                            </div>
                        </div>
                    </div>
<?php
                    echo $this->html->loadPassive('disable');
                    echo $this->html->loadPassive('advanced', $this->access);
?>
                </div>
                <div id="preloader-design-options" class="row-fluid tab-pane">
                    <div class="ba-settings-group">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SIZE'); ?>
                            </span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="320">
                                <input type="text" data-option="size" data-callback="sectionRules">
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('COLOR'); ?>
                            </span>
                            <input type="text" data-type="color" data-option="color">
                            <span class="minicolors-opacity-wrapper">
                                <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                min="0" max="1" step="0.01">
                                <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                            </span>
                        </div>
                    </div>
                    <div class="ba-settings-group">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('BACKGROUND'); ?>
                            </span>
                            <input type="text" data-type="color" data-option="background">
                            <span class="minicolors-opacity-wrapper">
                                <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                min="0" max="1" step="0.01">
                                <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                            </span>
                        </div>
                    </div>
                </div>
                <i class="zmdi zmdi-more resize-handle-bottom"></i>
            </div>
        </div>
    </div>
</div>
<div id="icon-list-settings-dialog" class="ba-modal-cp draggable-modal-cp modal hide">
    <div class="modal-header">
        <span class="ba-dialog-title"></span>
        <div class="modal-header-icon">
            <div class="ba-custom-select select-modal-cp-position">
                <i class="zmdi zmdi-more-vert"></i>
                <input type="hidden">
                <ul>
                    <li data-value=""><?php echo Text::_('SEPARATE_WINDOW') ?></li>
                    <li data-value="right"><?php echo Text::_('PANEL_TO_RIGHT') ?></li>
                </ul>
            </div>
            <i class="zmdi zmdi-close close-cp-modal"></i>
        </div>
    </div>
    <div class="modal-body">
        <div class="general-tabs">
            <ul class="nav nav-tabs">
                <li class="active">
                    <a href="#icon-list-general-options" data-toggle="tab">
                        <i class="zmdi zmdi-settings"></i>
                        <span><?php echo Text::_('GENERAL'); ?></span>
                    </a>
                </li>
                <li>
                    <a href="#icon-list-design-options" data-toggle="tab">
                        <i class="zmdi zmdi-format-color-fill"></i>
                        <span><?php echo Text::_('DESIGN'); ?></span>
                    </a>
                </li>
                <li>
                    <a href="#icon-list-layout-options" data-toggle="tab">
                        <i class="zmdi zmdi-fullscreen"></i>
                        <span><?php echo Text::_('LAYOUT'); ?></span>
                    </a>
                </li>
            </ul>
            <div class="tabs-underline"></div>
            <div class="tab-content">
                <div id="icon-list-general-options" class="row-fluid tab-pane active">
<?php
                    include $htmlPath.'ba-settings-group-items-list.php';
?>
                    <div class="ba-settings-group">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-desktop-windows"></i>
                            <span><?php echo Text::_('VIEW'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('LAYOUT'); ?>
                            </span>
                            <div class="ba-custom-select icons-list-layout-select">
                                <input readonly onfocus="this.blur()" type="text">
                                <input type="hidden">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value=""><?php echo Text::_('HORIZONTAL'); ?></li>
                                    <li data-value="vertical-layout"><?php echo Text::_('VERTICAL'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('TYPE'); ?>
                            </span>
                            <div class="ba-custom-select icons-list-type-select">
                                <input readonly onfocus="this.blur()" type="text">
                                <input type="hidden">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="bullets-type"><?php echo Text::_('BULLETS'); ?></li>
                                    <li data-value=""><?php echo Text::_('ICONS'); ?></li>
                                    <li data-value="numbers-type"><?php echo Text::_('NUMBERS'); ?></li>
                                </ul>
                            </div>
                        </div>
                    </div>
<?php
                    echo $this->html->loadPassive('disable');
?>
                    <div class="ba-settings-group">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-roller"></i>
                            <span><?php echo Text::_('PRESETS'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SELECT'); ?>
                            </span>
                            <div class="ba-lg-custom-select select-preset">
                                <input type="text" readonly onfocus="this.blur()">
                                <input type="hidden">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <div class="ba-lg-custom-select-header">
                                        <span class="create-new-preset">
                                            <i class="zmdi zmdi-plus-circle"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('SAVE_PRESET'); ?></span>
                                        </span>
                                        <span class="edit-preset-item">
                                            <i class="zmdi zmdi-edit"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('EDIT'); ?></span>
                                        </span>
                                        <span class="delete-preset-item">
                                            <i class="zmdi zmdi-delete"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('DELETE'); ?></span>
                                        </span>
                                    </div>
                                    <div class="ba-lg-custom-select-body">
                                        <li data-value="">
                                            <label>
                                                <input type="radio" name="preset-checkbox" value="">
                                                <i class="zmdi zmdi-circle-o"></i>
                                                <i class="zmdi zmdi-check"></i>
                                            </label>
                                            <span><?php echo Text::_('NO_NE'); ?></span>
                                        </li>
                                    </div>
                                </ul>
                            </div>
                        </div>
                    </div>
<?php
                    echo $this->html->loadPassive('item-animation');
                    echo $this->html->loadPassive('advanced', $this->access);
?>
                </div>
                <div id="icon-list-design-options" class="row-fluid tab-pane">
                    <div class="ba-settings-group">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-format-size"></i>
                            <span><?php echo Text::_('TYPOGRAPHY'); ?></span>
                        </div>
                        <div class="theme-typography-options">
                            <div class="typography-options">
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('FONT_FAMILY'); ?>
                                    </span>
                                    <input readonly onfocus="this.blur()" type="text" data-option="font-family"
                                        data-group="body" data-callback="sectionRules">
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('FONT_WEIGHT'); ?>
                                    </span>
                                    <input readonly onfocus="this.blur()" type="text" data-option="font-weight"
                                        data-group="body" data-callback="sectionRules">
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('COLOR'); ?>
                                    </span>
                                    <input type="text" data-type="color" data-option="color" data-group="body">
                                    <span class="minicolors-opacity-wrapper">
                                        <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                        min="0" max="1" step="0.01">
                                        <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                                    </span>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('SIZE'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner"></span>
                                        <input type="range" class="ba-range" min="0" max="320">
                                        <input type="text" data-option="font-size" data-group="body" data-callback="sectionRules">
                                    </div>
                                    <div class="reset-text-typography-wrapper" style="display: none;">
                                        <i class="zmdi zmdi-replay reset-text-typography" data-type="reset"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('RESET'); ?>
                                        </span>
                                    </div>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('LETTER_SPACING'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner letter-spacing"></span>
                                        <input type="range" class="ba-range" min="-10" max="10">
                                        <input type="text" data-option="letter-spacing" data-group="body"
                                            data-callback="sectionRules">
                                    </div>
                                    <div class="reset-text-typography-wrapper" style="display: none;">
                                        <i class="zmdi zmdi-replay reset-text-typography" data-type="reset"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('RESET'); ?>
                                        </span>
                                    </div>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('LINE_HEIGHT'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner"></span>
                                        <input type="range" class="ba-range" min="0" max="640">
                                        <input type="text" data-option="line-height" data-group="body" data-callback="sectionRules">
                                    </div>
                                    <div class="reset-text-typography-wrapper" style="display: none;">
                                        <i class="zmdi zmdi-replay reset-text-typography" data-type="reset"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('RESET'); ?>
                                        </span>
                                    </div>
                                </div>
                                <div class="ba-settings-toolbar">
                                    <label data-option="text-decoration" data-value="underline" data-group="body"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-underlined"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('UNDERLINE'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-transform" data-value="uppercase" data-group="body"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-size"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('UPPERCASE'); ?>
                                        </span>
                                    </label>
                                    <label data-option="font-style" data-value="italic" data-group="body"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-italic"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('ITALIC'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-align" data-value="left" data-group="body"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-align-left"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('LEFT'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-align" data-value="center" data-group="body"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-align-center"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('CENTER'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-align" data-value="right" data-group="body"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-align-right"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('RIGHT'); ?>
                                        </span>
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-local-florist"></i>
                            <span><?php echo Text::_('ICON'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('POSITION'); ?>
                            </span>
                            <div class="ba-custom-select icons-list-select-position">
                                <input readonly onfocus="this.blur()" type="text">
                                <input type="hidden">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value=""><?php echo Text::_('BEFORE'); ?></li>
                                    <li data-value="icons-position-after"><?php echo Text::_('AFTER'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('COLOR'); ?>
                            </span>
                            <input type="text" data-type="color" data-option="color" data-group="icons">
                            <span class="minicolors-opacity-wrapper">
                                <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                min="0" max="1" step="0.01">
                                <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                            </span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('BACKGROUND'); ?>
                            </span>
                            <input type="text" data-type="color" data-option="background" data-group="icons">
                            <span class="minicolors-opacity-wrapper">
                                <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                min="0" max="1" step="0.01">
                                <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                            </span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SIZE'); ?>
                            </span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="320">
                                <input type="text" data-option="size" data-group="icons" data-callback="sectionRules">
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('PADDING'); ?>
                            </span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="320">
                                <input type="text" data-option="padding" data-group="icons" data-callback="sectionRules">
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('BORDER_RADIUS'); ?>
                            </span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="320">
                                <input type="text" data-option="radius" data-group="icons" data-callback="sectionRules">
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-format-color-fill"></i>
                            <span><?php echo Text::_('BACKGROUND'); ?></span>
                        </div>
                        <div class="ba-settings-item background">
                            <span>
                                <?php echo Text::_('COLOR'); ?>
                            </span>
                            <input type="text" data-type="color" data-option="color" data-group="background" class="minicolors-top">
                            <span class="minicolors-opacity-wrapper">
                                <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                min="0" max="1" step="0.01">
                                <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                            </span>
                        </div>
                    </div>
                </div>
                <div id="icon-list-layout-options" class="row-fluid tab-pane">
<?php
                    echo $this->html->loadPassive('positioning');
                    echo $this->html->load('margin');
                    echo $this->html->load('padding');
                    echo $this->html->load('border');
                    echo $this->html->load('shadow');
?>
                </div>
                <i class="zmdi zmdi-more resize-handle-bottom"></i>
            </div>
        </div>
    </div>
</div>
<div id="feature-box-settings-dialog" class="ba-modal-cp draggable-modal-cp modal hide">
    <div class="modal-header">
        <span class="ba-dialog-title"></span>
        <div class="modal-header-icon">
            <div class="ba-custom-select select-modal-cp-position">
                <i class="zmdi zmdi-more-vert"></i>
                <input type="hidden">
                <ul>
                    <li data-value=""><?php echo Text::_('SEPARATE_WINDOW') ?></li>
                    <li data-value="right"><?php echo Text::_('PANEL_TO_RIGHT') ?></li>
                </ul>
            </div>
            <i class="zmdi zmdi-close close-cp-modal"></i>
        </div>
    </div>
    <div class="modal-body">
        <div class="general-tabs">
            <ul class="nav nav-tabs">
                <li class="active">
                    <a href="#feature-box-general-options" data-toggle="tab">
                        <i class="zmdi zmdi-settings"></i>
                        <span><?php echo Text::_('GENERAL'); ?></span>
                    </a>
                </li>
                <li>
                    <a href="#feature-box-design-options" data-toggle="tab">
                        <i class="zmdi zmdi-format-color-fill"></i>
                        <span><?php echo Text::_('DESIGN'); ?></span>
                    </a>
                </li>
                <li>
                    <a href="#feature-box-layout-options" data-toggle="tab">
                        <i class="zmdi zmdi-fullscreen"></i>
                        <span><?php echo Text::_('LAYOUT'); ?></span>
                    </a>
                </li>
            </ul>
            <div class="tabs-underline"></div>
            <div class="tab-content">
                <div id="feature-box-general-options" class="row-fluid tab-pane active">
<?php
                    include $htmlPath.'ba-settings-group-items-list.php';
?>
                    <div class="ba-settings-group">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-desktop-windows"></i>
                            <span><?php echo Text::_('VIEW'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('LAYOUT'); ?>
                            </span>
                            <div class="ba-custom-select feature-box-layout-select">
                                <input readonly onfocus="this.blur()" type="text">
                                <input type="hidden">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="ba-feature-grid-layout"><?php echo Text::_('CARD'); ?></li>
                                    <li data-value="ba-feature-list-layout"><?php echo Text::_('LIST'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item ba-feature-grid-layout-options">
                            <span>
                                <?php echo Text::_('NUMBER_OF_COLUMNS'); ?>
                            </span>
                            <input type="number" data-option="count" data-group="view" class="lightbox-settings-input set-value-css">
                        </div>
                    </div>
<?php
                    echo $this->html->loadPassive('disable');
?>
                    <div class="ba-settings-group">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-roller"></i>
                            <span><?php echo Text::_('PRESETS'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SELECT'); ?>
                            </span>
                            <div class="ba-lg-custom-select select-preset">
                                <input type="text" readonly onfocus="this.blur()">
                                <input type="hidden">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <div class="ba-lg-custom-select-header">
                                        <span class="create-new-preset">
                                            <i class="zmdi zmdi-plus-circle"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('SAVE_PRESET'); ?></span>
                                        </span>
                                        <span class="edit-preset-item">
                                            <i class="zmdi zmdi-edit"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('EDIT'); ?></span>
                                        </span>
                                        <span class="delete-preset-item">
                                            <i class="zmdi zmdi-delete"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('DELETE'); ?></span>
                                        </span>
                                    </div>
                                    <div class="ba-lg-custom-select-body">
                                        <li data-value="">
                                            <label>
                                                <input type="radio" name="preset-checkbox" value="">
                                                <i class="zmdi zmdi-circle-o"></i>
                                                <i class="zmdi zmdi-check"></i>
                                            </label>
                                            <span><?php echo Text::_('NO_NE'); ?></span>
                                        </li>
                                    </div>
                                </ul>
                            </div>
                        </div>
                    </div>
<?php
                    echo $this->html->loadPassive('item-animation');
                    echo $this->html->loadPassive('advanced', $this->access);
?>
                </div>
                <div id="feature-box-design-options" class="row-fluid tab-pane">
                    <div class="ba-settings-group slideshow-design-group">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SELECT'); ?>
                            </span>
                            <div class="ba-custom-select ba-style-custom-select">
                                <input readonly onfocus="this.blur()" type="text" value="">
                                <input type="hidden" value="">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="icon"><?php echo Text::_('ICON'); ?></li>
                                    <li data-value="image"><?php echo Text::_('IMAGE'); ?></li>
                                    <li data-value="title"><?php echo Text::_('TITLE'); ?></li>
                                    <li data-value="description"><?php echo Text::_('DESCRIPTION'); ?></li>
                                    <li data-value="button"><?php echo Text::_('BUTTON'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item title-html-tag">
                            <span>
                                <?php echo Text::_('HTML_TAG'); ?>
                            </span>
                            <div class="ba-custom-select select-title-html-tag">
                                <input readonly onfocus="this.blur()" type="text" value="">
                                <input type="hidden" value="">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="h1">H1</li>
                                    <li data-value="h2">H2</li>
                                    <li data-value="h3">H3</li>
                                    <li data-value="h4">H4</li>
                                    <li data-value="h5">H5</li>
                                    <li data-value="h6">H6</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group ba-style-typography-options">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-format-size"></i>
                            <span><?php echo Text::_('TYPOGRAPHY'); ?></span>
                        </div>
                        <div class="theme-typography-options">
                            <div class="typography-options">
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('FONT_FAMILY'); ?>
                                    </span>
                                    <input readonly onfocus="this.blur()" type="text" data-option="font-family" data-group=""
                                        data-subgroup="typography" data-callback="sectionRules">
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('FONT_WEIGHT'); ?>
                                    </span>
                                    <input readonly onfocus="this.blur()" type="text" data-option="font-weight"
                                        data-group="" data-subgroup="typography" data-callback="sectionRules">
                                </div>
                                <div class="ba-settings-item ba-style-typography-color">
                                    <span>
                                        <?php echo Text::_('COLOR'); ?>
                                    </span>
                                    <input type="text" data-type="color" data-option="color" data-group="" data-subgroup="typography">
                                    <span class="minicolors-opacity-wrapper">
                                        <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                        min="0" max="1" step="0.01">
                                        <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                                    </span>
                                </div>
                                <div class="ba-settings-item ba-style-typography-hover-color desktop-only" style="display: none;">
                                    <span>
                                        <?php echo Text::_('HOVER'); ?>
                                    </span>
                                    <input type="text" data-type="color" data-option="color" data-group="" data-subgroup="hover">
                                    <span class="minicolors-opacity-wrapper">
                                        <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                        min="0" max="1" step="0.01">
                                        <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                                    </span>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('SIZE'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner"></span>
                                        <input type="range" class="ba-range" min="0" max="320">
                                        <input type="text" data-option="font-size" data-group="" data-subgroup="typography"
                                            data-callback="sectionRules">
                                    </div>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('LETTER_SPACING'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner letter-spacing"></span>
                                        <input type="range" class="ba-range" min="-10" max="10">
                                        <input type="text" data-option="letter-spacing" data-group="" data-subgroup="typography"
                                            data-callback="sectionRules">
                                    </div>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('LINE_HEIGHT'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner"></span>
                                        <input type="range" class="ba-range" min="0" max="640">
                                        <input type="text" data-option="line-height" data-group="" data-subgroup="typography"
                                            data-callback="sectionRules">
                                    </div>
                                </div>
                                <div class="ba-settings-toolbar">
                                    <label data-option="text-decoration" data-value="underline" data-group="" data-subgroup="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-underlined"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('UNDERLINE'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-transform" data-value="uppercase" data-group="" data-subgroup="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-size"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('UPPERCASE'); ?>
                                        </span>
                                    </label>
                                    <label data-option="font-style" data-value="italic" data-group="" data-subgroup="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-italic"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('ITALIC'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-align" data-value="left" data-group="" data-subgroup="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-align-left"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('LEFT'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-align" data-value="center" data-group="" data-subgroup="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-align-center"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('CENTER'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-align" data-value="right" data-group="" data-subgroup="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-align-right"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('RIGHT'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-align" data-value="1" data-group="" data-subgroup="typography"
                                           data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-align-justify"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('FULL_WIDTH'); ?>
                                        </span>
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group ba-style-icon-options">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SIZE'); ?>
                            </span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="10" max="1500">
                                <input type="text" data-option="size" data-group="icon" data-callback="sectionRules">
                            </div>
                        </div>
                        <div class="ba-settings-toolbar">
                            <label data-option="text-align" data-value="left" data-group="icon" data-callback="sectionRules">
                                <i class="zmdi zmdi-format-align-left"></i>
                                <span class="ba-tooltip">
                                    <?php echo Text::_('LEFT'); ?>
                                </span>
                            </label>
                            <label data-option="text-align" data-value="center" data-group="icon" data-callback="sectionRules">
                                <i class="zmdi zmdi-format-align-center"></i>
                                <span class="ba-tooltip">
                                    <?php echo Text::_('CENTER'); ?>
                                </span>
                            </label>
                            <label data-option="text-align" data-value="right" data-group="icon" data-callback="sectionRules">
                                <i class="zmdi zmdi-format-align-right"></i>
                                <span class="ba-tooltip">
                                    <?php echo Text::_('RIGHT'); ?>
                                </span>
                            </label>
                        </div>
                    </div>
                    <div class="ba-settings-group ba-style-image-options">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('WIDTH'); ?>
                            </span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="10" max="1500">
                                <input type="text" data-option="width" data-group="image" data-callback="sectionRules">
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('HEIGHT'); ?>
                            </span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="10" max="1500">
                                <input type="text" data-option="height" data-group="image" data-callback="sectionRules">
                            </div>
                        </div>
                        <div class="ba-settings-toolbar">
                            <label data-option="text-align" data-value="left" data-group="image" data-callback="sectionRules">
                                <i class="zmdi zmdi-format-align-left"></i>
                                <span class="ba-tooltip">
                                    <?php echo Text::_('LEFT'); ?>
                                </span>
                            </label>
                            <label data-option="text-align" data-value="center" data-group="image" data-callback="sectionRules">
                                <i class="zmdi zmdi-format-align-center"></i>
                                <span class="ba-tooltip">
                                    <?php echo Text::_('CENTER'); ?>
                                </span>
                            </label>
                            <label data-option="text-align" data-value="right" data-group="image" data-callback="sectionRules">
                                <i class="zmdi zmdi-format-align-right"></i>
                                <span class="ba-tooltip">
                                    <?php echo Text::_('RIGHT'); ?>
                                </span>
                            </label>
                        </div>
                    </div>
<?php
                    $options = ['class' => 'ba-style-button-options ba-style-icon-options', 'group' => '',
                        'subgroup' => 'colors'];
                    echo $this->html->load('colors', $options);
?>
                    <div class="ba-settings-group ba-style-icon-options">
                        <div class="settings-group-title">
                            <span><?php echo Text::_('PADDING'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('VALUE'); ?></span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="1000">
                                <input type="text" data-option="padding" data-group="icon" data-callback="sectionRules">
                            </div>
                        </div>
                    </div>
<?php
                    $options = ['class' => 'ba-style-margin-options', 'group' => 'description', 'subgroup' => 'margin'];
                    echo $this->html->load('margin', $options);
                    $options = ['class' => 'ba-style-button-options', 'group' => 'button', 'subgroup' => 'padding'];
                    echo $this->html->load('padding', $options);
                    $options = ['class' => 'ba-style-border-options ba-style-icon-options', 'group' => 'button',
                        'subgroup' => 'border'];
                    echo $this->html->load('border', $options);
                    $options = ['class' => 'ba-style-button-options', 'subgroup' => 'shadow', 'group' => ''];
                    echo $this->html->load('shadow', $options);
                    $options = ['class' => 'blog-posts-background-options'];
                    echo $this->html->load('feature-background', $options);
?>
                </div>
                <div id="feature-box-layout-options" class="row-fluid tab-pane">
<?php
                    echo $this->html->loadPassive('positioning');
                    echo $this->html->load('margin');
                    echo $this->html->load('padding');
                    echo $this->html->load('border');
                    echo $this->html->load('shadow');
?>
                </div>
                <i class="zmdi zmdi-more resize-handle-bottom"></i>
            </div>
        </div>
    </div>
</div>
<div id="field-settings-dialog" class="ba-modal-cp draggable-modal-cp modal hide">
    <div class="modal-header">
        <span class="ba-dialog-title"></span>
        <div class="modal-header-icon">
            <div class="ba-custom-select select-modal-cp-position">
                <i class="zmdi zmdi-more-vert"></i>
                <input type="hidden">
                <ul>
                    <li data-value=""><?php echo Text::_('SEPARATE_WINDOW') ?></li>
                    <li data-value="right"><?php echo Text::_('PANEL_TO_RIGHT') ?></li>
                </ul>
            </div>
            <i class="zmdi zmdi-close close-cp-modal"></i>
        </div>
    </div>
    <div class="modal-body">
        <div class="general-tabs">
            <ul class="nav nav-tabs">
                <li class="active">
                    <a href="#field-general-options" data-toggle="tab">
                        <i class="zmdi zmdi-settings"></i>
                        <span><?php echo Text::_('GENERAL'); ?></span>
                    </a>
                </li>
                <li>
                    <a href="#field-design-options" data-toggle="tab">
                        <i class="zmdi zmdi-format-color-fill"></i>
                        <span><?php echo Text::_('DESIGN'); ?></span>
                    </a>
                </li>
                <li>
                    <a href="#field-layout-options" data-toggle="tab">
                        <i class="zmdi zmdi-fullscreen"></i>
                        <span><?php echo Text::_('LAYOUT'); ?></span>
                    </a>
                </li>
            </ul>
            <div class="tabs-underline"></div>
            <div class="tab-content">
                <div id="field-general-options" class="row-fluid tab-pane active">
                    <div class="ba-settings-group items-list fields-group-plugin-options">
                        <div class="sorting-container"></div>
                        <div class="add-new-item">
                            <span>
                                <i class="zmdi zmdi-plus-circle"></i>
                                <span class="ba-tooltip ba-right"><?php echo Text::_('ADD_NEW_ITEM'); ?></span>
                            </span>
                        </div>
                    </div>
                    <div class="ba-settings-group fields-plugin-options">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('TYPE'); ?>
                            </span>
                            <div class="ba-custom-select field-type-select">
                                <input readonly onfocus="this.blur()" type="text" value="">
                                <input type="hidden" value="">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="text"><?php echo Text::_('TEXT'); ?></li>
                                    <li data-value="textarea"><?php echo Text::_('TEXTAREA'); ?></li>
                                    <li data-value="select"><?php echo Text::_('DROPDOWN'); ?></li>
                                    <li data-value="checkbox"><?php echo Text::_('CHECKBOX'); ?></li>
                                    <li data-value="radio"><?php echo Text::_('RADIO'); ?></li>
                                    <li data-value="url"><?php echo Text::_('URL'); ?></li>
                                    <li data-value="price"><?php echo Text::_('PRICE'); ?></li>
                                    <li data-value="number"><?php echo Text::_('NUMBER'); ?></li>
                                    <li data-value="date"><?php echo Text::_('DATE'); ?></li>
                                    <li data-value="event-date"><?php echo Text::_('EVENT_DATE'); ?></li>
                                    <li data-value="time"><?php echo Text::_('TIME'); ?></li>
                                    <li data-value="range"><?php echo Text::_('SLIDER'); ?></li>
                                    <li data-value="file"><?php echo Text::_('ATTACHMENT_FILE'); ?></li>
                                    <li data-value="tag"><?php echo Text::_('TAG'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="field-price-type-options">
                            <div class="ba-settings-item">
                                <span>
                                    <?php echo Text::_('SYMBOL'); ?>
                                </span>
                                <input type="text" data-group="options" data-option="symbol" placeholder="$">
                            </div>
                            <div class="ba-settings-item">
                                <span>
                                    <?php echo Text::_('CURRENCY_POSITION'); ?>
                                </span>
                                <div class="ba-custom-select">
                                    <input readonly onfocus="this.blur()" type="text" value="">
                                    <input type="hidden" value="" data-group="options" data-option="position">
                                    <i class="zmdi zmdi-caret-down"></i>
                                    <ul>
                                        <li data-value=""><?php echo Text::_('LEFT'); ?></li>
                                        <li data-value="right-currency-position"><?php echo Text::_('RIGHT'); ?></li>
                                    </ul>
                                </div>
                            </div>
                            <div class="ba-settings-item">
                                <span>
                                    <?php echo Text::_('THOUSAND_SEPARATOR'); ?>
                                </span>
                                <div class="ba-custom-select">
                                    <input readonly onfocus="this.blur()" type="text" value="">
                                    <input type="hidden" value="" data-group="options" data-option="thousand">
                                    <i class="zmdi zmdi-caret-down"></i>
                                    <ul>
                                        <li data-value=","><?php echo Text::_('COMMA'); ?></li>
                                        <li data-value="."><?php echo Text::_('DOT'); ?></li>
                                        <li data-value=" "><?php echo Text::_('SPACE'); ?></li>
                                        <li data-value=""><?php echo Text::_('NO_NE'); ?></li>
                                    </ul>
                                </div>
                            </div>
                            <div class="ba-settings-item">
                                <span>
                                    <?php echo Text::_('DECIMAL_SEPARATOR'); ?>
                                </span>
                                <div class="ba-custom-select">
                                    <input readonly onfocus="this.blur()" type="text" value="">
                                    <input type="hidden" value="" data-group="options" data-option="separator">
                                    <i class="zmdi zmdi-caret-down"></i>
                                    <ul>
                                        <li data-value=","><?php echo Text::_('COMMA'); ?></li>
                                        <li data-value="."><?php echo Text::_('DOT'); ?></li>
                                    </ul>
                                </div>
                            </div>
                            <div class="ba-settings-item">
                                <span>
                                    <?php echo Text::_('NUMBER_OF_DECIMALS'); ?>
                                </span>
                                <div class="ba-range-wrapper">
                                    <span class="ba-range-liner"></span>
                                    <input type="range" class="ba-range" min="0" max="10">
                                    <input type="number" data-group="options" data-option="decimals" data-callback="emptyCallback">
                                </div>
                            </div>
                        </div>
                        <div class="field-textarea-type-options">
                            <div class="ba-settings-item">
                                <span>
                                    <?php echo Text::_('ENABLE_TEXT_EDITOR'); ?>
                                </span>
                                <label class="ba-checkbox">
                                    <input type="checkbox" data-option="texteditor" data-group="options" class="set-value-css">
                                    <span></span>
                                </label>
                            </div>
                        </div>
                        <div  class="items-list field-radio-type-options field-select-type-options field-checkbox-type-options">
                            <div class="sorting-container"></div>
                            <div class="add-new-item">
                                <span>
                                    <i class="zmdi zmdi-plus-circle"></i>
                                    <span class="ba-tooltip ba-right"><?php echo Text::_('ADD_NEW_ITEM'); ?></span>
                                </span>
                            </div>
                        </div>
                        <div class="field-file-type-options fields-plugin-options">
                            <div class="ba-settings-item">
                                <span><?php echo Text::_('TITLE'); ?></span>
                                <input type="text" data-group="options" data-option="title" placeholder="<?php echo Text::_('TITLE'); ?>">
                            </div>
                            <div class="ba-settings-item">
                                <span>
                                    <?php echo Text::_('SOURCE'); ?>
                                </span>
                                <div class="ba-custom-select select-field-upload-source">
                                    <input readonly onfocus="this.blur()" type="text" value="">
                                    <input type="hidden" value="">
                                    <i class="zmdi zmdi-caret-down"></i>
                                    <ul>
                                        <li data-value=""><?php echo Text::_('MEDIA_MANAGER'); ?></li>
                                        <li data-value="desktop"><?php echo Text::_('DESKTOP'); ?></li>
                                    </ul>
                                </div>
                            </div>
                            <div class="ba-settings-item">
                                <span><?php echo Text::_('MAX_UPLOAD_FILE_SIZE'); ?></span>
                                <input type="text" data-group="options" data-option="size"
                                    placeholder="<?php echo Text::_('MAX_UPLOAD_FILE_SIZE'); ?>">
                            </div>
                            <div class="ba-settings-item">
                                <span><?php echo Text::_('ALLOWED_FILE_TYPES'); ?></span>
                                <input type="text" data-group="options" data-option="types"
                                    placeholder="<?php echo Text::_('ALLOWED_FILE_TYPES'); ?>">
                            </div>
                        </div>
                        <div class="field-range-type-options fields-plugin-options">
                            <div class="ba-settings-toolbar">
                                <div>
                                    <span><?php echo Text::_('MIN'); ?></span>
                                    <input type="number" data-group="options" data-option="min" data-callback="sectionRules">
                                </div>
                                <div>
                                    <span><?php echo Text::_('MAX'); ?></span>
                                    <input type="number" data-group="options" data-option="max" data-callback="sectionRules">
                                </div>
                            </div>
                        </div>
                        <div class="field-url-type-options fields-plugin-options">
                            <div class="ba-settings-item">
                                <span><?php echo Text::_('TARGET'); ?></span>
                                <div class="ba-custom-select field-url-target-select">
                                    <input readonly="" onfocus="this.blur()" value="" type="text">
                                    <input type="hidden" data-option="target">
                                    <i class="zmdi zmdi-caret-down"></i>
                                    <ul>
                                        <li data-value="_blank"><?php echo Text::_('NEW_WINDOW'); ?></li>
                                        <li data-value="_self"><?php echo Text::_('SAME_WINDOW'); ?></li>
                                    </ul>
                                </div>
                            </div>
                            <div class="ba-settings-item">
                                <span><?php echo Text::_('TYPE'); ?></span>
                                <div class="ba-custom-select">
                                    <input readonly="" onfocus="this.blur()" value="" type="text">
                                    <input type="hidden" data-option="download">
                                    <i class="zmdi zmdi-caret-down"></i>
                                    <ul>
                                        <li data-value=""><?php echo Text::_('DEFAULT'); ?></li>
                                        <li data-value="download"><?php echo Text::_('DOWNLOAD'); ?></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group fields-plugin-options">
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('LABEL'); ?></span>
                            <input type="text" placeholder="<?php echo Text::_('LABEL'); ?>" class="field-label">
                        </div>
                        <div class="ba-settings-item input-resize">
                            <span><?php echo Text::_('DESCRIPTION'); ?></span>
                            <input type="text" placeholder="<?php echo Text::_('DESCRIPTION'); ?>" class="field-description">
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('ICON'); ?>
                            </span>
                            <input class="select-input select-field-icon" type="text" readonly onfocus="this.blur()"
                                placeholder="<?php echo Text::_('ICON'); ?>">
                            <i class="zmdi zmdi-attachment-alt"></i>
                            <div class="reset disabled-reset reset-field-icon">
                                <i class="zmdi zmdi-close"></i>
                                <span class="ba-tooltip">
                                    <?php echo Text::_('RESET'); ?>
                                </span>
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('ADMIN_LABEL'); ?></span>
                            <input type="text" placeholder="<?php echo Text::_('ADMIN_LABEL'); ?>" class="field-admin-label">
                        </div>
                        <div class="ba-settings-item input-resize">
                            <span><?php echo Text::_('ADMIN_DESCRIPTION'); ?></span>
                            <input type="text" placeholder="<?php echo Text::_('ADMIN_DESCRIPTION'); ?>" class="field-admin-description">
                        </div>
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('REQUIRED'); ?></span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-option="required" class="set-value-css">
                                <span></span>
                            </label>
                        </div>
                    </div>
<?php
                    echo $this->html->loadPassive('disable');
?>
                    <div class="ba-settings-group">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-roller"></i>
                            <span><?php echo Text::_('PRESETS'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SELECT'); ?>
                            </span>
                            <div class="ba-lg-custom-select select-preset">
                                <input type="text" readonly onfocus="this.blur()">
                                <input type="hidden">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <div class="ba-lg-custom-select-header">
                                        <span class="create-new-preset">
                                            <i class="zmdi zmdi-plus-circle"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('SAVE_PRESET'); ?></span>
                                        </span>
                                        <span class="edit-preset-item">
                                            <i class="zmdi zmdi-edit"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('EDIT'); ?></span>
                                        </span>
                                        <span class="delete-preset-item">
                                            <i class="zmdi zmdi-delete"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('DELETE'); ?></span>
                                        </span>
                                    </div>
                                    <div class="ba-lg-custom-select-body">
                                        <li data-value="">
                                            <label>
                                                <input type="radio" name="preset-checkbox" value="">
                                                <i class="zmdi zmdi-circle-o"></i>
                                                <i class="zmdi zmdi-check"></i>
                                            </label>
                                            <span><?php echo Text::_('NO_NE'); ?></span>
                                        </li>
                                    </div>
                                </ul>
                            </div>
                        </div>
                    </div>
<?php
                    echo $this->html->loadPassive('item-animation');
                    echo $this->html->loadPassive('advanced', $this->access);
?>
                </div>
                <div id="field-design-options" class="row-fluid tab-pane">
                    <div class="ba-settings-group slideshow-design-group">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SELECT'); ?>
                            </span>
                            <div class="ba-custom-select ba-style-custom-select">
                                <input readonly onfocus="this.blur()" type="text" value="">
                                <input type="hidden" value="">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="title"><?php echo Text::_('LABEL'); ?></li>
                                    <li data-value="value"><?php echo Text::_('VALUE'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item title-html-tag">
                            <span>
                                <?php echo Text::_('POSITION'); ?>
                            </span>
                            <div class="ba-custom-select field-label-position-select">
                                <input readonly onfocus="this.blur()" type="text" value="">
                                <input type="hidden" value="">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value=""><?php echo Text::_('TOP'); ?></li>
                                    <li data-value="ba-label-position-right"><?php echo Text::_('RIGHT'); ?></li>
                                    <li data-value="ba-label-position-left"><?php echo Text::_('LEFT'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item title-html-tag">
                            <span>
                                <?php echo Text::_('HTML_TAG'); ?>
                            </span>
                            <div class="ba-custom-select select-field-text-type-html-tag">
                                <input readonly onfocus="this.blur()" type="text" value="">
                                <input type="hidden" value="">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="h1">H1</li>
                                    <li data-value="h2">H2</li>
                                    <li data-value="h3">H3</li>
                                    <li data-value="h4">H4</li>
                                    <li data-value="h5">H5</li>
                                    <li data-value="h6">H6</li>
                                    <li data-value="p">Paragraph</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group ba-style-typography-options">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-format-size"></i>
                            <span><?php echo Text::_('TYPOGRAPHY'); ?></span>
                        </div>
                        <div class="theme-typography-options">
                            <div class="typography-options">
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('FONT_FAMILY'); ?>
                                    </span>
                                    <input readonly onfocus="this.blur()" type="text" data-option="font-family" data-group=""
                                        data-subgroup="typography" data-callback="sectionRules">
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('FONT_WEIGHT'); ?>
                                    </span>
                                    <input readonly onfocus="this.blur()" type="text" data-option="font-weight"
                                        data-group="" data-subgroup="typography" data-callback="sectionRules">
                                </div>
                                <div class="ba-settings-item ba-style-typography-color">
                                    <span>
                                        <?php echo Text::_('COLOR'); ?>
                                    </span>
                                    <input type="text" data-type="color" data-option="color" data-group="" data-subgroup="typography">
                                    <span class="minicolors-opacity-wrapper">
                                        <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                        min="0" max="1" step="0.01">
                                        <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                                    </span>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('SIZE'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner"></span>
                                        <input type="range" class="ba-range" min="0" max="320">
                                        <input type="text" data-option="font-size" data-group="" data-subgroup="typography"
                                            data-callback="sectionRules">
                                    </div>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('LETTER_SPACING'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner letter-spacing"></span>
                                        <input type="range" class="ba-range" min="-10" max="10">
                                        <input type="text" data-option="letter-spacing" data-group="" data-subgroup="typography"
                                            data-callback="sectionRules">
                                    </div>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('LINE_HEIGHT'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner"></span>
                                        <input type="range" class="ba-range" min="0" max="640">
                                        <input type="text" data-option="line-height" data-group="" data-subgroup="typography"
                                            data-callback="sectionRules">
                                    </div>
                                </div>
                                <div class="ba-settings-toolbar">
                                    <label data-option="text-decoration" data-value="underline" data-group="" data-subgroup="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-underlined"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('UNDERLINE'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-transform" data-value="uppercase" data-group="" data-subgroup="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-size"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('UPPERCASE'); ?>
                                        </span>
                                    </label>
                                    <label data-option="font-style" data-value="italic" data-group="" data-subgroup="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-italic"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('ITALIC'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-align" data-value="left" data-group="" data-subgroup="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-align-left"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('LEFT'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-align" data-value="center" data-group="" data-subgroup="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-align-center"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('CENTER'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-align" data-value="right" data-group="" data-subgroup="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-align-right"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('RIGHT'); ?>
                                        </span>
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group blog-posts-background-options">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-local-florist"></i>
                            <span><?php echo Text::_('ICON'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('COLOR'); ?>
                            </span>
                            <input type="text" data-type="color" data-option="color" data-group="icons">
                            <span class="minicolors-opacity-wrapper">
                                <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                min="0" max="1" step="0.01">
                                <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                            </span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SIZE'); ?>
                            </span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="320">
                                <input type="text" data-option="size" data-group="icons" data-callback="sectionRules">
                            </div>
                        </div>
                    </div>
                </div>
                <div id="field-layout-options" class="row-fluid tab-pane">
<?php
                    echo $this->html->loadPassive('positioning');
                    echo $this->html->load('margin');
                    echo $this->html->load('padding');
                    echo $this->html->load('border');
?>
                </div>
                <i class="zmdi zmdi-more resize-handle-bottom"></i>
            </div>
        </div>
    </div>
</div>
<div id="event-calendar-settings-dialog" class="ba-modal-cp draggable-modal-cp modal hide">
    <div class="modal-header">
        <span class="ba-dialog-title"></span>
        <div class="modal-header-icon">
            <div class="ba-custom-select select-modal-cp-position">
                <i class="zmdi zmdi-more-vert"></i>
                <input type="hidden">
                <ul>
                    <li data-value=""><?php echo Text::_('SEPARATE_WINDOW') ?></li>
                    <li data-value="right"><?php echo Text::_('PANEL_TO_RIGHT') ?></li>
                </ul>
            </div>
            <i class="zmdi zmdi-close close-cp-modal"></i>
        </div>
    </div>
    <div class="modal-body">
        <div class="general-tabs">
            <ul class="nav nav-tabs">
                <li class="active">
                    <a href="#event-calendar-general-options" data-toggle="tab">
                        <i class="zmdi zmdi-settings"></i>
                        <span><?php echo Text::_('GENERAL'); ?></span>
                    </a>
                </li>
                <li>
                    <a href="#event-calendar-design-options" data-toggle="tab">
                        <i class="zmdi zmdi-format-color-fill"></i>
                        <span><?php echo Text::_('DESIGN'); ?></span>
                    </a>
                </li>
                <li>
                    <a href="#event-calendar-layout-options" data-toggle="tab">
                        <i class="zmdi zmdi-fullscreen"></i>
                        <span><?php echo Text::_('LAYOUT'); ?></span>
                    </a>
                </li>
            </ul>
            <div class="tabs-underline"></div>
            <div class="tab-content">
                <div id="event-calendar-general-options" class="row-fluid tab-pane active">
                    <div class="ba-settings-group">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('APP'); ?>
                            </span>
                            <div class="ba-custom-select event-calendar-app-select">
                                <input readonly="" onfocus="this.blur()" value="" type="text">
                                <input type="hidden" value="1" data-option="app">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
<?php
                                foreach ($this->apps as $value) {
                                    if ($value->type != 'blog') {
                                        echo '<li data-value="'.$value->id.'">'.$value->title.'</li>';
                                    }
                                }
?>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('TYPE'); ?>
                            </span>
                            <div class="ba-custom-select recent-posts-type-select">
                                <input type="text" readonly="" onfocus="this.blur()">
                                <input type="hidden" value="1" data-option="app">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value=""><?php echo Text::_('CATEGORY'); ?></li>
                                    <li data-value="tags"><?php echo Text::_('TAGS'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item post-tags-list tags-type-options">
                            <span>
                                <?php echo Text::_('TAGS'); ?>
                            </span>
                            <div>
                                <ul class="post-tags-list">
                                    <li class="trigger-post-tags-modal">
                                        <input type="text" placeholder="<?php echo Text::_('TAGS'); ?>" readonly>
                                    </li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item tags-categories-list categories-type-options">
                            <span>
                                <?php echo Text::_('CATEGORY'); ?>
                            </span>
                            <div class="tags-categories">
                                <ul class="selected-categories">
                                    <li class="search-category">
                                        <input type="text" placeholder="<?php echo Text::_('CATEGORY'); ?>" readonly>
                                    </li>
                                </ul>
                                <ul class="all-categories-list">
<?php
                                foreach ($this->categories as $category) {
                                    $content = '';
                                    for ($i = 0; $i < $category->level; $i++) {
                                        $content .= '- ';
                                    }
                                    if ($category->level != 0) {
                                        $content .= '-';
                                    }
?>
                                    <li data-id="<?php echo $category->id; ?>" data-app="<?php echo $category->app_id; ?>"
                                        style="--content: '<?php echo $content; ?>';">
                                        <?php echo $category->title; ?>
                                    </li>
<?php
                                }
?>
                                </ul>
                            </div>
                            <label class="ba-help-icon">
                                <i class="zmdi zmdi-help"></i>
                                <span class="ba-tooltip ba-help">
                                    <?php echo Text::_('POSTS_CATEGORY_TOOLTIP'); ?>
                                </span>
                            </label>
                        </div>




                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('FIRST_DAY_OF_WEEK'); ?>
                            </span>
                            <div class="ba-custom-select event-calendar-first-day-select">
                                <input readonly="" onfocus="this.blur()" type="text">
                                <input type="hidden">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="0"><?php echo Text::_('SUNDAY'); ?></li>
                                    <li data-value="1"><?php echo Text::_('MONDAY'); ?></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group">
                        <div class="settings-group-title">
                            <span><?php echo Text::_('VIEW'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('IMAGE'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-group="view" data-option="image" class="set-value-css">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('TITLE'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-group="view" data-option="title" class="set-value-css">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item not-author-options">
                            <span>
                                <?php echo Text::_('INFO'); ?>
                            </span>
                            <span class="category-list-fields-wrapper">
                                <i class="zmdi zmdi-playlist-plus open-category-list-fields" data-target="info"></i>
                            </span>
                        </div>
                        <div class="ba-settings-item not-author-options">
                            <span>
                                <?php echo Text::_('REVIEWS'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-option="reviews" data-group="view" class="set-value-css">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item category-list-fields-view-options">
                            <span>
                                <?php echo Text::_('FIELDS'); ?>
                            </span>
                            <span class="category-list-fields-wrapper">
                                <i class="zmdi zmdi-playlist-plus open-category-list-fields" data-target="fields"></i>
                            </span>
                        </div>
                        <div class="ba-settings-item not-author-options">
                            <span>
                                <?php echo Text::_('BUTTON'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-group="view" data-option="button" class="set-value-css">
                                <span></span>
                            </label>
                        </div>
                    </div>
<?php
                    echo $this->html->loadPassive('disable');
?>
                    <div class="ba-settings-group">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-roller"></i>
                            <span><?php echo Text::_('PRESETS'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SELECT'); ?>
                            </span>
                            <div class="ba-lg-custom-select select-preset">
                                <input type="text" readonly onfocus="this.blur()">
                                <input type="hidden">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <div class="ba-lg-custom-select-header">
                                        <span class="create-new-preset">
                                            <i class="zmdi zmdi-plus-circle"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('SAVE_PRESET'); ?></span>
                                        </span>
                                        <span class="edit-preset-item">
                                            <i class="zmdi zmdi-edit"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('EDIT'); ?></span>
                                        </span>
                                        <span class="delete-preset-item">
                                            <i class="zmdi zmdi-delete"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('DELETE'); ?></span>
                                        </span>
                                    </div>
                                    <div class="ba-lg-custom-select-body">
                                        <li data-value="">
                                            <label>
                                                <input type="radio" name="preset-checkbox" value="">
                                                <i class="zmdi zmdi-circle-o"></i>
                                                <i class="zmdi zmdi-check"></i>
                                            </label>
                                            <span><?php echo Text::_('NO_NE'); ?></span>
                                        </li>
                                    </div>
                                </ul>
                            </div>
                        </div>
                    </div>
<?php
                    echo $this->html->loadPassive('item-animation');
                    echo $this->html->loadPassive('advanced', $this->access);
?>
                </div>
                <div id="event-calendar-design-options" class="row-fluid tab-pane">
                    <div class="ba-settings-group slideshow-design-group">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SELECT'); ?>
                            </span>
                            <div class="ba-custom-select ba-style-custom-select">
                                <input readonly onfocus="this.blur()" type="text" value="">
                                <input type="hidden" value="">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="months"><?php echo Text::_('MONTHS'); ?></li>
                                    <li data-value="weeks"><?php echo Text::_('WEEKS'); ?></li>
                                    <li data-value="days"><?php echo Text::_('DAYS'); ?></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group ba-style-typography-options">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-format-size"></i>
                            <span><?php echo Text::_('TYPOGRAPHY'); ?></span>
                        </div>
                        <div class="theme-typography-options">
                            <div class="typography-options">
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('FONT_FAMILY'); ?>
                                    </span>
                                    <input readonly onfocus="this.blur()" type="text" data-option="font-family" data-group=""
                                        data-subgroup="typography" data-callback="sectionRules">
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('FONT_WEIGHT'); ?>
                                    </span>
                                    <input readonly onfocus="this.blur()" type="text" data-option="font-weight"
                                        data-group="" data-subgroup="typography" data-callback="sectionRules">
                                </div>
                                <div class="ba-settings-item ba-style-typography-color">
                                    <span>
                                        <?php echo Text::_('COLOR'); ?>
                                    </span>
                                    <input type="text" data-type="color" data-option="color" data-group="" data-subgroup="typography">
                                    <span class="minicolors-opacity-wrapper">
                                        <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                        min="0" max="1" step="0.01">
                                        <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                                    </span>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('SIZE'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner"></span>
                                        <input type="range" class="ba-range" min="0" max="320">
                                        <input type="text" data-option="font-size" data-group="" data-subgroup="typography"
                                            data-callback="sectionRules">
                                    </div>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('LETTER_SPACING'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner letter-spacing"></span>
                                        <input type="range" class="ba-range" min="-10" max="10">
                                        <input type="text" data-option="letter-spacing" data-group="" data-subgroup="typography"
                                            data-callback="sectionRules">
                                    </div>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('LINE_HEIGHT'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner"></span>
                                        <input type="range" class="ba-range" min="0" max="640">
                                        <input type="text" data-option="line-height" data-group="" data-subgroup="typography"
                                            data-callback="sectionRules">
                                    </div>
                                </div>
                                <div class="ba-settings-toolbar">
                                    <label data-option="text-decoration" data-value="underline" data-group="" data-subgroup="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-underlined"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('UNDERLINE'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-transform" data-value="uppercase" data-group="" data-subgroup="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-size"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('UPPERCASE'); ?>
                                        </span>
                                    </label>
                                    <label data-option="font-style" data-value="italic" data-group="" data-subgroup="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-italic"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('ITALIC'); ?>
                                        </span>
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div id="event-calendar-layout-options" class="row-fluid tab-pane">
<?php
                    echo $this->html->loadPassive('positioning');
                    echo $this->html->load('margin');
?>
                </div>
                <i class="zmdi zmdi-more resize-handle-bottom"></i>
            </div>
        </div>
    </div>
</div>
<div id="comments-box-settings-dialog" class="ba-modal-cp draggable-modal-cp modal hide">
    <div class="modal-header">
        <span class="ba-dialog-title"></span>
        <div class="modal-header-icon">
            <div class="ba-custom-select select-modal-cp-position">
                <i class="zmdi zmdi-more-vert"></i>
                <input type="hidden">
                <ul>
                    <li data-value=""><?php echo Text::_('SEPARATE_WINDOW') ?></li>
                    <li data-value="right"><?php echo Text::_('PANEL_TO_RIGHT') ?></li>
                </ul>
            </div>
            <i class="zmdi zmdi-close close-cp-modal"></i>
        </div>
    </div>
    <div class="modal-body">
        <div class="general-tabs">
            <ul class="nav nav-tabs">
                <li class="active">
                    <a href="#comments-box-general-options" data-toggle="tab">
                        <i class="zmdi zmdi-settings"></i>
                        <span><?php echo Text::_('GENERAL'); ?></span>
                    </a>
                </li>
                <li>
                    <a href="#comments-box-design-options" data-toggle="tab">
                        <i class="zmdi zmdi-format-color-fill"></i>
                        <span><?php echo Text::_('DESIGN'); ?></span>
                    </a>
                </li>
                <li>
                    <a href="#comments-box-layout-options" data-toggle="tab">
                        <i class="zmdi zmdi-fullscreen"></i>
                        <span><?php echo Text::_('LAYOUT'); ?></span>
                    </a>
                </li>
            </ul>
            <div class="tabs-underline"></div>
            <div class="tab-content">
                <div id="comments-box-general-options" class="row-fluid tab-pane active">
                    <div class="ba-settings-group">
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('USER_LOGIN'); ?></span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-group="view" data-option="user" class="set-value-css">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('SOCIAL_LOGIN'); ?></span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-group="view" data-option="social" class="set-value-css">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('GUEST_LOGIN'); ?></span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-group="view" data-option="guest" class="set-value-css">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item reviews-options">
                            <span><?php echo Text::_('REPLY'); ?></span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-group="view" data-option="reply" class="set-value-css">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('SOCIAL_SHARE'); ?></span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-group="view" data-option="share" class="set-value-css">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item">
                            <span class="comments-box-options"><?php echo Text::_('COMMENT_RATING'); ?></span>
                            <span class="reviews-options"><?php echo Text::_('REVIEW_RATING'); ?></span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-group="view" data-option="rating" class="set-value-css">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item">
                            <span class="comments-box-options"><?php echo Text::_('REPORT_COMMENT'); ?></span>
                            <span class="reviews-options"><?php echo Text::_('REPORT_REVIEW'); ?></span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-group="view" data-option="report" class="set-value-css">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item reviews-options">
                            <span><?php echo Text::_('UPLOAD_PHOTOS'); ?></span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-group="view" data-option="images" class="set-value-css">
                                <span></span>
                            </label>
                        </div>
                    </div>
                    <div class="ba-settings-group comments-box-options">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-file"></i>
                            <span><?php echo Text::_('ATTACHMENTS'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('IMAGES'); ?></span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-group="view" data-option="images" class="set-value-css">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('FILES'); ?></span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-group="view" data-option="files" class="set-value-css">
                                <span></span>
                            </label>
                        </div>
                    </div>
<?php
                    echo $this->html->loadPassive('disable');
?>
                    <div class="ba-settings-group">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-roller"></i>
                            <span><?php echo Text::_('PRESETS'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SELECT'); ?>
                            </span>
                            <div class="ba-lg-custom-select select-preset">
                                <input type="text" readonly onfocus="this.blur()">
                                <input type="hidden">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <div class="ba-lg-custom-select-header">
                                        <span class="create-new-preset">
                                            <i class="zmdi zmdi-plus-circle"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('SAVE_PRESET'); ?></span>
                                        </span>
                                        <span class="edit-preset-item">
                                            <i class="zmdi zmdi-edit"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('EDIT'); ?></span>
                                        </span>
                                        <span class="delete-preset-item">
                                            <i class="zmdi zmdi-delete"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('DELETE'); ?></span>
                                        </span>
                                    </div>
                                    <div class="ba-lg-custom-select-body">
                                        <li data-value="">
                                            <label>
                                                <input type="radio" name="preset-checkbox" value="">
                                                <i class="zmdi zmdi-circle-o"></i>
                                                <i class="zmdi zmdi-check"></i>
                                            </label>
                                            <span><?php echo Text::_('NO_NE'); ?></span>
                                        </li>
                                    </div>
                                </ul>
                            </div>
                        </div>
                    </div>
<?php
                    echo $this->html->loadPassive('item-animation');
                    echo $this->html->loadPassive('advanced', $this->access);
?>
                </div>
                <div id="comments-box-design-options" class="row-fluid tab-pane">
                    <div class="ba-settings-group">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-format-size"></i>
                            <span><?php echo Text::_('TYPOGRAPHY'); ?></span>
                        </div>
                        <div class="theme-typography-options">
                            <div class="typography-options">
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('FONT_FAMILY'); ?>
                                    </span>
                                    <input readonly onfocus="this.blur()" type="text" data-option="font-family"
                                        data-group="typography" data-callback="sectionRules">
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('FONT_WEIGHT'); ?>
                                    </span>
                                    <input readonly onfocus="this.blur()" type="text" data-option="font-weight"
                                        data-group="typography" data-callback="sectionRules">
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('COLOR'); ?>
                                    </span>
                                    <input type="text" data-type="color" data-option="color" data-group="typography">
                                    <span class="minicolors-opacity-wrapper">
                                        <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                        min="0" max="1" step="0.01">
                                        <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                                    </span>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('SIZE'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner"></span>
                                        <input type="range" class="ba-range" min="0" max="320">
                                        <input type="text" data-option="font-size" data-group="typography" data-callback="sectionRules">
                                    </div>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('LETTER_SPACING'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner letter-spacing"></span>
                                        <input type="range" class="ba-range" min="-10" max="10">
                                        <input type="text" data-option="letter-spacing" data-group="typography"
                                            data-callback="sectionRules">
                                    </div>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('LINE_HEIGHT'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner"></span>
                                        <input type="range" class="ba-range" min="0" max="640">
                                        <input type="text" data-option="line-height" data-group="typography" data-callback="sectionRules">
                                    </div>
                                </div>
                                <div class="ba-settings-toolbar">
                                    <label data-option="text-decoration" data-value="underline" data-group="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-underlined"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('UNDERLINE'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-transform" data-value="uppercase" data-group="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-size"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('UPPERCASE'); ?>
                                        </span>
                                    </label>
                                    <label data-option="font-style" data-value="italic" data-group="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-italic"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('ITALIC'); ?>
                                        </span>
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group blog-posts-background-options">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-format-color-fill"></i>
                            <span><?php echo Text::_('BACKGROUND'); ?></span>
                        </div>
                        <div class="ba-settings-item background">
                            <span>
                                <?php echo Text::_('COLOR'); ?>
                            </span>
                            <input type="text" data-type="color" data-option="color" data-group="background" class="minicolors-top">
                            <span class="minicolors-opacity-wrapper">
                                <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                min="0" max="1" step="0.01">
                                <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                            </span>
                        </div>
                    </div>
                </div>
                <div id="comments-box-layout-options" class="row-fluid tab-pane">
<?php
                    echo $this->html->loadPassive('positioning');
                    echo $this->html->load('margin');
                    echo $this->html->load('padding');
                    echo $this->html->load('border');
                    echo $this->html->load('shadow');
?>
                </div>
                <i class="zmdi zmdi-more resize-handle-bottom"></i>
            </div>
        </div>
    </div>
</div>
<div id="recent-comments-settings-dialog" class="ba-modal-cp draggable-modal-cp modal hide">
    <div class="modal-header">
        <span class="ba-dialog-title"></span>
        <div class="modal-header-icon">
            <div class="ba-custom-select select-modal-cp-position">
                <i class="zmdi zmdi-more-vert"></i>
                <input type="hidden">
                <ul>
                    <li data-value=""><?php echo Text::_('SEPARATE_WINDOW') ?></li>
                    <li data-value="right"><?php echo Text::_('PANEL_TO_RIGHT') ?></li>
                </ul>
            </div>
            <i class="zmdi zmdi-close close-cp-modal"></i>
        </div>
    </div>
    <div class="modal-body">
        <div class="general-tabs">
            <ul class="nav nav-tabs">
                <li class="active">
                    <a href="#recent-comments-general-options" data-toggle="tab">
                        <i class="zmdi zmdi-settings"></i>
                        <span><?php echo Text::_('GENERAL'); ?></span>
                    </a>
                </li>
                <li>
                    <a href="#recent-comments-design-options" data-toggle="tab">
                        <i class="zmdi zmdi-format-color-fill"></i>
                        <span><?php echo Text::_('DESIGN'); ?></span>
                    </a>
                </li>
                <li>
                    <a href="#recent-comments-layout-options" data-toggle="tab">
                        <i class="zmdi zmdi-fullscreen"></i>
                        <span><?php echo Text::_('LAYOUT'); ?></span>
                    </a>
                </li>
            </ul>
            <div class="tabs-underline"></div>
            <div class="tab-content">
                <div id="recent-comments-general-options" class="row-fluid tab-pane active">
                    <div class="ba-settings-group">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('APP'); ?>
                            </span>
                            <div class="ba-custom-select recent-posts-app-select">
                                <input readonly="" onfocus="this.blur()" value="" type="text">
                                <input type="hidden" value="1" data-option="app">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
<?php
                                foreach ($this->allApps as $value) {
                                    echo '<li data-value="'.$value->id.'">'.$value->title.'</li>';
                                }
?>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item tags-categories-list">
                            <span>
                                <?php echo Text::_('CATEGORY'); ?>
                            </span>
                            <div class="tags-categories">
                                <ul class="selected-categories">
                                    <li class="search-category">
                                        <input type="text" placeholder="<?php echo Text::_('CATEGORY'); ?>" readonly>
                                    </li>
                                </ul>
                                <ul class="all-categories-list">
<?php
                                foreach ($this->categories as $category) {
                                    $content = '';
                                    for ($i = 0; $i < $category->level; $i++) {
                                        $content .= '- ';
                                    }
                                    if ($category->level != 0) {
                                        $content .= '-';
                                    }
?>
                                    <li data-id="<?php echo $category->id; ?>" data-app="<?php echo $category->app_id; ?>"
                                        style="--content: '<?php echo $content; ?>';">
                                        <?php echo $category->title; ?>
                                    </li>
<?php
                                }
?>
                                </ul>
                            </div>
                            <label class="ba-help-icon">
                                <i class="zmdi zmdi-help"></i>
                                <span class="ba-tooltip ba-help">
                                    <?php echo Text::_('POSTS_CATEGORY_TOOLTIP'); ?>
                                </span>
                            </label>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SORT_BY'); ?>
                            </span>
                            <div class="ba-custom-select recent-posts-display-select">
                                <input readonly="" onfocus="this.blur()" value="" type="text">
                                <input type="hidden" value="1" data-option="sorting">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="recent"><?php echo Text::_('RECENT'); ?></li>
                                    <li data-value="popular"><?php echo Text::_('POPULAR'); ?></li>
                                    <li data-value="random"><?php echo Text::_('RANDOM'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('MAX_ITEMS'); ?>
                            </span>
                            <input type="number" data-option="limit" class="lightbox-settings-input recent-limit"
                                placeholder="5">
                        </div>
                    </div>
                    <div class="ba-settings-group recent-reviews-options">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('LAYOUT'); ?>
                            </span>
                            <div class="ba-custom-select blog-posts-layout-select">
                                <input readonly onfocus="this.blur()" type="text" value="">
                                <input type="hidden" value="">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="ba-grid-layout"><?php echo Text::_('CARD'); ?></li>
                                    <li data-value="ba-classic-layout"><?php echo Text::_('LIST'); ?></li>
                                    <li data-value="ba-masonry-layout"><?php echo Text::_('MASONRY'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item blog-posts-grid-options">
                            <span>
                                <?php echo Text::_('NUMBER_OF_COLUMNS'); ?>
                            </span>
                            <input type="number" data-option="count" data-group="view"
                                class="lightbox-settings-input set-value-css">
                        </div>
                    </div>
                    <div class="ba-settings-group">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-desktop-windows"></i>
                            <span><?php echo Text::_('VIEW'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('IMAGE'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-group="view" data-option="image" class="set-desktop-view-value">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item">
                            <span class="recent-comments-options">
                                <?php echo Text::_('TITLE'); ?>
                            </span>
                            <span class="recent-reviews-options">
                                <?php echo Text::_('NAME'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-group="view" data-option="title" class="set-desktop-view-value">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item recent-reviews-options">
                            <span>
                                <?php echo Text::_('SOURCE'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-group="view" data-option="source" class="set-desktop-view-value">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('DATE'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-option="date" data-group="view" class="set-desktop-view-value">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('MESSAGE'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" data-group="view" data-option="intro" class="set-desktop-view-value">
                                <span></span>
                            </label>
                        </div>
                    </div>
<?php
                    echo $this->html->loadPassive('disable');
?>
                    <div class="ba-settings-group preset-options">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-roller"></i>
                            <span><?php echo Text::_('PRESETS'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SELECT'); ?>
                            </span>
                            <div class="ba-lg-custom-select select-preset">
                                <input type="text" readonly onfocus="this.blur()">
                                <input type="hidden">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <div class="ba-lg-custom-select-header">
                                        <span class="create-new-preset">
                                            <i class="zmdi zmdi-plus-circle"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('SAVE_PRESET'); ?></span>
                                        </span>
                                        <span class="edit-preset-item">
                                            <i class="zmdi zmdi-edit"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('EDIT'); ?></span>
                                        </span>
                                        <span class="delete-preset-item">
                                            <i class="zmdi zmdi-delete"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('DELETE'); ?></span>
                                        </span>
                                    </div>
                                    <div class="ba-lg-custom-select-body">
                                        <li data-value="">
                                            <label>
                                                <input type="radio" name="preset-checkbox" value="">
                                                <i class="zmdi zmdi-circle-o"></i>
                                                <i class="zmdi zmdi-check"></i>
                                            </label>
                                            <span><?php echo Text::_('NO_NE'); ?></span>
                                        </li>
                                    </div>
                                </ul>
                            </div>
                        </div>
                    </div>
<?php
                    echo $this->html->loadPassive('item-animation');
                    echo $this->html->loadPassive('advanced', $this->access);
?>
                </div>
                <div id="recent-comments-design-options" class="row-fluid tab-pane">
                    <div class="ba-settings-group slideshow-design-group">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SELECT'); ?>
                            </span>
                            <div class="ba-custom-select ba-style-custom-select">
                                <input readonly onfocus="this.blur()" type="text" value="">
                                <input type="hidden" value="">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="image"><?php echo Text::_('IMAGE'); ?></li>
                                    <li data-value="title"><?php echo Text::_('TITLE'); ?></li>
                                    <li data-value="info"><?php echo Text::_('INFO'); ?></li>
                                    <li data-value="stars" class="recent-reviews-options"><?php echo Text::_('STARS'); ?></li>
                                    <li data-value="intro"><?php echo Text::_('MESSAGE'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item title-html-tag">
                            <span>
                                <?php echo Text::_('HTML_TAG'); ?>
                            </span>
                            <div class="ba-custom-select select-title-html-tag">
                                <input readonly onfocus="this.blur()" type="text" value="">
                                <input type="hidden" value="">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="h1">H1</li>
                                    <li data-value="h2">H2</li>
                                    <li data-value="h3">H3</li>
                                    <li data-value="h4">H4</li>
                                    <li data-value="h5">H5</li>
                                    <li data-value="h6">H6</li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item ba-style-intro-options">
                            <span>
                                <?php echo Text::_('MAXIMUM_LENGTH'); ?>
                            </span>
                            <input type="number" data-option="maximum" class="lightbox-settings-input" placeholder="50">
                            <label class="ba-help-icon">
                                <i class="zmdi zmdi-help"></i>
                                <span class="ba-tooltip ba-help">
                                <?php echo Text::_('MAXIMUM_LENGTH_TOOLTIP'); ?>
                                </span>
                            </label>
                        </div>
                    </div>
                    <div class="ba-settings-group ba-style-typography-options">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-format-size"></i>
                            <span><?php echo Text::_('TYPOGRAPHY'); ?></span>
                        </div>
                        <div class="theme-typography-options">
                            <div class="typography-options">
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('FONT_FAMILY'); ?>
                                    </span>
                                    <input readonly onfocus="this.blur()" type="text" data-option="font-family" data-group=""
                                        data-subgroup="typography" data-callback="sectionRules">
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('FONT_WEIGHT'); ?>
                                    </span>
                                    <input readonly onfocus="this.blur()" type="text" data-option="font-weight"
                                        data-group="" data-subgroup="typography" data-callback="sectionRules">
                                </div>
                                <div class="ba-settings-item ba-style-typography-color">
                                    <span>
                                        <?php echo Text::_('COLOR'); ?>
                                    </span>
                                    <input type="text" data-type="color" data-option="color" data-group="" data-subgroup="typography">
                                    <span class="minicolors-opacity-wrapper">
                                        <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                        min="0" max="1" step="0.01">
                                        <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                                    </span>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('SIZE'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner"></span>
                                        <input type="range" class="ba-range" min="0" max="320">
                                        <input type="text" data-option="font-size" data-group="" data-subgroup="typography"
                                            data-callback="sectionRules">
                                    </div>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('LETTER_SPACING'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner letter-spacing"></span>
                                        <input type="range" class="ba-range" min="-10" max="10">
                                        <input type="text" data-option="letter-spacing" data-group="" data-subgroup="typography"
                                            data-callback="sectionRules">
                                    </div>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('LINE_HEIGHT'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner"></span>
                                        <input type="range" class="ba-range" min="0" max="640">
                                        <input type="text" data-option="line-height" data-group="" data-subgroup="typography"
                                            data-callback="sectionRules">
                                    </div>
                                </div>
                                <div class="ba-settings-toolbar">
                                    <label data-option="text-decoration" data-value="underline" data-group="" data-subgroup="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-underlined"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('UNDERLINE'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-transform" data-value="uppercase" data-group="" data-subgroup="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-size"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('UPPERCASE'); ?>
                                        </span>
                                    </label>
                                    <label data-option="font-style" data-value="italic" data-group="" data-subgroup="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-italic"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('ITALIC'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-align" data-value="left" data-group="" data-subgroup="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-align-left"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('LEFT'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-align" data-value="center" data-group="" data-subgroup="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-align-center"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('CENTER'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-align" data-value="right" data-group="" data-subgroup="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-align-right"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('RIGHT'); ?>
                                        </span>
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group ba-style-stars-options">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SIZE'); ?>
                            </span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="320">
                                <input type="text" data-option="size" data-group="stars" data-subgroup="icon"
                                    data-callback="sectionRules">
                            </div>
                        </div>
                        <div class="ba-settings-toolbar">
                            <label data-option="text-align" data-value="left" data-group="stars" data-subgroup="icon"
                                    data-callback="sectionRules">
                                <i class="zmdi zmdi-format-align-left"></i>
                                <span class="ba-tooltip">
                                    <?php echo Text::_('LEFT'); ?>
                                </span>
                            </label>
                            <label data-option="text-align" data-value="center" data-group="stars" data-subgroup="icon"
                                    data-callback="sectionRules">
                                <i class="zmdi zmdi-format-align-center"></i>
                                <span class="ba-tooltip">
                                    <?php echo Text::_('CENTER'); ?>
                                </span>
                            </label>
                            <label data-option="text-align" data-value="right" data-group="stars" data-subgroup="icon"
                                    data-callback="sectionRules">
                                <i class="zmdi zmdi-format-align-right"></i>
                                <span class="ba-tooltip">
                                    <?php echo Text::_('RIGHT'); ?>
                                </span>
                            </label>
                        </div>
                    </div>
                    <div class="ba-settings-group ba-style-image-options">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('WIDTH'); ?>
                            </span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="10" max="1500">
                                <input type="text" data-option="width" data-group="image" data-callback="sectionRules">
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('HEIGHT'); ?>
                            </span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="10" max="1500">
                                <input type="text" data-option="height" data-group="image" data-callback="sectionRules">
                            </div>
                        </div>
                    </div>
<?php
                    $options = ['class' => 'ba-style-margin-options', 'group' => '', 'subgroup' => 'margin'];
                    echo $this->html->load('margin', $options);
                    $options = ['class' => 'ba-style-border-options', 'group' => '', 'subgroup' => 'border'];
                    echo $this->html->load('border', $options);
?>
                    <div class="ba-settings-group blog-posts-background-options">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-format-color-fill"></i>
                            <span><?php echo Text::_('BACKGROUND'); ?></span>
                        </div>
                        <div class="ba-settings-item background">
                            <span>
                                <?php echo Text::_('COLOR'); ?>
                            </span>
                            <input type="text" data-type="color" data-option="color" data-group="background" class="minicolors-top">
                            <span class="minicolors-opacity-wrapper">
                                <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                min="0" max="1" step="0.01">
                                <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                            </span>
                        </div>
                    </div>
                </div>
                <div id="recent-comments-layout-options" class="row-fluid tab-pane">
<?php
                    echo $this->html->loadPassive('positioning');
                    echo $this->html->load('margin');
                    echo $this->html->load('padding');
                    echo $this->html->load('border');
                    $options = ['class' => 'blog-posts-shadow-options'];
                    echo $this->html->load('shadow', $options);
?>
                </div>
                <i class="zmdi zmdi-more resize-handle-bottom"></i>
            </div>
        </div>
    </div>
</div>
<div id="before-after-slider-settings-dialog" class="ba-modal-cp draggable-modal-cp modal hide">
    <div class="modal-header">
        <span class="ba-dialog-title"></span>
        <div class="modal-header-icon">
            <div class="ba-custom-select select-modal-cp-position">
                <i class="zmdi zmdi-more-vert"></i>
                <input type="hidden">
                <ul>
                    <li data-value=""><?php echo Text::_('SEPARATE_WINDOW') ?></li>
                    <li data-value="right"><?php echo Text::_('PANEL_TO_RIGHT') ?></li>
                </ul>
            </div>
            <i class="zmdi zmdi-close close-cp-modal"></i>
        </div>
    </div>
    <div class="modal-body">
        <div class="general-tabs">
            <ul class="nav nav-tabs">
                <li class="active">
                    <a href="#before-after-slider-general-options" data-toggle="tab">
                        <i class="zmdi zmdi-settings"></i>
                        <span><?php echo Text::_('GENERAL'); ?></span>
                    </a>
                </li>
                <li>
                    <a href="#before-after-slider-design-options" data-toggle="tab">
                        <i class="zmdi zmdi-format-color-fill"></i>
                        <span><?php echo Text::_('DESIGN'); ?></span>
                    </a>
                </li>
                <li>
                    <a href="#before-after-slider-layout-options" data-toggle="tab">
                        <i class="zmdi zmdi-fullscreen"></i>
                        <span><?php echo Text::_('LAYOUT'); ?></span>
                    </a>
                </li>
            </ul>
            <div class="tabs-underline"></div>
            <div class="tab-content">
                <div id="before-after-slider-general-options" class="row-fluid tab-pane active">
                    <div class="ba-settings-group items-list">
                        <div class="sorting-container">
                        
                        </div>
                    </div>
                    <div class="ba-settings-group ba-image-options">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-desktop-windows"></i>
                            <span><?php echo Text::_('VIEW'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SLIDER_DIRECTION'); ?>
                            </span>
                            <div class="ba-custom-select select-before-after-slider-direction">
                                <input readonly onfocus="this.blur()" type="text" value="">
                                <input type="hidden" value="">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="horizontal"><?php echo Text::_('HORIZONTAL'); ?></li>
                                    <li data-value="vertical"><?php echo Text::_('VERTICAL'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SLIDER_STARTING_POINT'); ?>
                            </span>
                            <div class="ba-range-wrapper image-width">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="100">
                                <input type="number" data-option="start" data-callback="beforeAfterCallback">
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('LABEL_ON_MOUSEOVER'); ?>
                            </span>
                            <label class="ba-checkbox">
                                <input type="checkbox" class="before-after-label-mouseover">
                                <span></span>
                            </label>
                        </div>
                    </div>
<?php
                    echo $this->html->loadPassive('disable');
?>
                    <div class="ba-settings-group">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-roller"></i>
                            <span><?php echo Text::_('PRESETS'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SELECT'); ?>
                            </span>
                            <div class="ba-lg-custom-select select-preset">
                                <input type="text" readonly onfocus="this.blur()">
                                <input type="hidden">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <div class="ba-lg-custom-select-header">
                                        <span class="create-new-preset">
                                            <i class="zmdi zmdi-plus-circle"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('SAVE_PRESET'); ?></span>
                                        </span>
                                        <span class="edit-preset-item">
                                            <i class="zmdi zmdi-edit"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('EDIT'); ?></span>
                                        </span>
                                        <span class="delete-preset-item">
                                            <i class="zmdi zmdi-delete"></i>
                                            <span class="ba-tooltip ba-bottom"><?php echo Text::_('DELETE'); ?></span>
                                        </span>
                                    </div>
                                    <div class="ba-lg-custom-select-body">
                                        <li data-value="">
                                            <label>
                                                <input type="radio" name="preset-checkbox" value="">
                                                <i class="zmdi zmdi-circle-o"></i>
                                                <i class="zmdi zmdi-check"></i>
                                            </label>
                                            <span><?php echo Text::_('NO_NE'); ?></span>
                                        </li>
                                    </div>
                                </ul>
                            </div>
                        </div>
                    </div>
<?php
                    echo $this->html->loadPassive('item-animation');
                    echo $this->html->loadPassive('advanced', $this->access);
?>
                </div>
                <div id="before-after-slider-design-options" class="row-fluid tab-pane">
                    <div class="ba-settings-group slideshow-design-group">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SELECT'); ?>
                            </span>
                            <div class="ba-custom-select slideshow-style-custom-select">
                                <input readonly onfocus="this.blur()" type="text" value="">
                                <input type="hidden" value="">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="title"><?php echo Text::_('LABEL'); ?></li>
                                    <li data-value="divider"><?php echo Text::_('DIVIDER'); ?></li>
                                    <li data-value="slider"><?php echo Text::_('SLIDER'); ?></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group slideshow-typography-options">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-format-size"></i>
                            <span><?php echo Text::_('TYPOGRAPHY'); ?></span>
                        </div>
                        <div class="theme-typography-options">
                            <div class="typography-options">
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('FONT_FAMILY'); ?>
                                    </span>
                                    <input readonly onfocus="this.blur()" type="text" data-option="font-family"
                                        data-group="" data-subgroup="typography" data-callback="sectionRules">
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('FONT_WEIGHT'); ?>
                                    </span>
                                    <input readonly onfocus="this.blur()" type="text" data-option="font-weight" data-group=""
                                        data-subgroup="typography" data-callback="sectionRules">
                                </div>
                                <div class="ba-settings-item slideshow-typography-color">
                                    <span>
                                        <?php echo Text::_('COLOR'); ?>
                                    </span>
                                    <input type="text" data-type="color" data-option="color" data-group="" data-subgroup="typography">
                                    <span class="minicolors-opacity-wrapper">
                                        <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                        min="0" max="1" step="0.01">
                                        <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                                    </span>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('BACKGROUND'); ?>
                                    </span>
                                    <input type="text" data-type="color" data-option="color" data-group="title"
                                        data-subgroup="background">
                                    <span class="minicolors-opacity-wrapper">
                                        <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                        min="0" max="1" step="0.01">
                                        <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                                    </span>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('SIZE'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner"></span>
                                        <input type="range" class="ba-range" min="0" max="320">
                                        <input type="text" data-option="font-size" data-group="" data-subgroup="typography"
                                            data-callback="sectionRules">
                                    </div>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('LETTER_SPACING'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner letter-spacing"></span>
                                        <input type="range" class="ba-range" min="-10" max="10">
                                        <input type="text" data-option="letter-spacing" data-group="" data-subgroup="typography"
                                            data-callback="sectionRules">
                                    </div>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('LINE_HEIGHT'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner"></span>
                                        <input type="range" class="ba-range" min="0" max="640">
                                        <input type="text" data-option="line-height" data-group="" data-subgroup="typography"
                                            data-callback="sectionRules">
                                    </div>
                                </div>
                                <div class="ba-settings-toolbar">
                                    <label data-option="text-decoration" data-value="underline" data-group="" data-subgroup="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-underlined"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('UNDERLINE'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-transform" data-value="uppercase" data-group="" data-subgroup="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-size"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('UPPERCASE'); ?>
                                        </span>
                                    </label>
                                    <label data-option="font-style" data-value="italic" data-group="" data-subgroup="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-italic"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('ITALIC'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-align" data-value="left" data-group="" data-subgroup="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-align-left"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('LEFT'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-align" data-value="center" data-group="" data-subgroup="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-align-center"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('CENTER'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-align" data-value="right" data-group="" data-subgroup="typography"
                                        data-callback="sectionRules">
                                        <i class="zmdi zmdi-format-align-right"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('RIGHT'); ?>
                                        </span>
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group divider-options">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('COLOR'); ?>
                            </span>
                            <input type="text" data-type="color" data-option="color" data-group="" data-subgroup=""
                                class="icon-color">
                            <span class="minicolors-opacity-wrapper">
                                <input type="number" class="minicolors-opacity" data-callback="sectionRules"
                                min="0" max="1" step="0.01">
                                <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                            </span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('WIDTH'); ?>
                            </span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="20">
                                <input type="text" data-option="width" data-group="" data-subgroup="" data-callback="sectionRules">
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group slider-options">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('SIZE'); ?>
                            </span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="1000">
                                <input type="text" data-option="size" data-group="" data-subgroup="" data-callback="sectionRules">
                            </div>
                        </div>
                    </div>
<?php
                    $options = ['class' => 'slider-options', 'group' => '', 'subgroup' => 'colors'];
                    echo $this->html->load('colors', $options);
?>
                    <div class="ba-settings-group slider-options">
                        <div class="settings-group-title">
                            <span><?php echo Text::_('PADDING'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('VALUE'); ?>
                            </span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="1000">
                                <input type="text" data-option="padding" data-group="" data-subgroup="" data-callback="sectionRules">
                            </div>
                        </div>
                    </div>
<?php
                    $options = ['class' => 'slider-options', 'group' => '', 'subgroup' => 'border'];
                    echo $this->html->load('border', $options);
                    $options = ['class' => 'slider-options', 'group' => '', 'subgroup' => 'shadow'];
                    echo $this->html->load('shadow', $options);
?>
                </div>
                <div id="before-after-slider-layout-options" class="row-fluid tab-pane">
<?php
                    echo $this->html->loadPassive('positioning');
                    echo $this->html->load('margin');
                    echo $this->html->load('border');
                    echo $this->html->load('shadow');
?>
                </div>
                <i class="zmdi zmdi-more resize-handle-bottom"></i>
            </div>
        </div>
    </div>
</div>

<?php
$files = [
    'theme-settings-dialog.php',
    'blog-posts-settings-modal-cp.php', 'fields-filter-settings-modal-cp.php',
    'recent-posts-settings-modal-cp.php', 'search-settings-modal-cp.php',
    'add-to-cart-settings-modal-cp.php', 'cart-settings-modal-cp.php',
    'customer-info-settings-modal-cp.php', 'slideshow-settings-modal-cp.php',
    'breadcrumbs-settings-modal-cp.php', 'categories-settings-modal-cp.php',
    'language-switcher-settings-modal-cp.php', 'currency-switcher-settings-modal-cp.php',
    'login-settings-modal-cp.php', 'lottie-animations-settings-modal-cp.php',
    'templates.php', 'modals.php'
];
foreach ($files as $file) {
    include $htmlPath.$file;
}