<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

use Balbooa\Component\Gridbox\Site\Helper\GridboxHelper;
use Joomla\CMS\Language\Associations;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;

defined('_JEXEC') or die;

?>
<div id="site-dialog" class="ba-modal-lg modal hide" style="display:none">
    <div class="modal-header">
        <span class="ba-dialog-title"><?php echo Text::_('SITE_SETTINGS'); ?></span>
        <div class="modal-header-icon">
            <i class="zmdi zmdi-close" data-dismiss="modal"></i>
        </div>
    </div>
    <div class="modal-body">
        <div class="general-tabs">
            <ul class="nav nav-tabs uploader-nav">
                <li class="active">
                    <a href="#site-options" data-toggle="tab">
                        <i class="zmdi zmdi-settings"></i>
                        <?php echo Text::_('GENERAL'); ?>
                    </a>
                </li>
                <li>
                    <a href="#mobile-options" data-toggle="tab">
                        <i class="zmdi zmdi-desktop-windows"></i>
                        <?php echo Text::_('LAYOUT'); ?>
                    </a>
                </li>
<?php
            if (isset(GridboxHelper::$systemApps->performance)) {
?>
                <li>
                    <a href="#performance-options" data-toggle="tab">
                        <i class="zmdi zmdi-time-restore-setting"></i>
                        <?php echo Text::_('PERFORMANCE'); ?>
                    </a>
                </li>
<?php
            }
?>
            </ul>
            <div class="tabs-underline"></div>
            <div class="tab-content">
                <div id="site-options" class="row-fluid left-tabs-wrapper tab-pane active">
                    <div class="left-tabs">
                        <ul class="nav nav-tabs">
                            <li class="active">
                                <a href="#site-basic-options" data-toggle="tab">
                                    <i class="zmdi zmdi-settings"></i>
                                    <?php echo Text::_('BASIC'); ?>
                                </a>
                            </li>
                        <!--
                            <li>
                                <a href="#site-analytics-options" data-toggle="tab">
                                    <i class="zmdi zmdi-trending-up"></i>
                                    <?php echo Text::_('ANALYTICS'); ?>
                                </a>
                            </li>
                        -->
<?php
                        if (isset(GridboxHelper::$systemApps->canonical) || isset(GridboxHelper::$systemApps->sitemap)) {
?>
                            <li>
                                <a href="#site-seo-options" data-toggle="tab">
                                    <i class="zmdi zmdi-globe"></i>
                                    SEO
                                </a>
                            </li>
<?php
                        }
?>
                            <li>
                                <a href="#site-scripts-options" data-toggle="tab">
                                    <i class="zmdi zmdi-code-setting"></i>
                                    <?php echo Text::_('SCRIPTS'); ?>
                                </a>
                            </li>
                            <li>
                                <a href="#site-media-manager-options" data-toggle="tab">
                                    <i class="zmdi zmdi-collection-video"></i>
                                    <?php echo Text::_('MEDIA_MANAGER'); ?>
                                </a>
                            </li>
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane active" id="site-basic-options">
                                <div class="ba-options-group">
                                    <div class="ba-group-element">
                                        <label>
                                            <?php echo Text::_('FAVICON'); ?>
                                        </label>
                                        <input type="text" readonly onfocus="this.blur()" class="favicon select-favicon"
                                            value="<?php echo $this->website->favicon; ?>"
                                            placeholder="<?php echo Text::_('SELECT'); ?>">
                                        <i class="zmdi zmdi-attachment-alt"></i>
                                        <label class="ba-help-icon">
                                            <i class="zmdi zmdi-help"></i>
                                            <span class="ba-tooltip ba-help">
                                                <?php echo Text::_('FAVICON_TOOLTIP_PNG'); ?>
                                            </span>
                                        </label>
                                    </div>
                                </div>
                                <div class="ba-options-group"
                                <?php echo isset(GridboxHelper::$systemApps->preloader) ? '' : ' style="display: none !important;"' ?>>
                                    <div class="ba-group-element">
                                        <label>
                                            <?php echo Text::_('SITE_PRELOADER'); ?>
                                        </label>
                                        <label class="ba-checkbox">
                                            <input type="checkbox" class="site-preloader"
                                                <?php echo $this->website->preloader == 1 ? 'checked' : ''; ?>>
                                            <span></span>
                                        </label>
                                        <label class="ba-help-icon">
                                            <i class="zmdi zmdi-help"></i>
                                            <span class="ba-tooltip ba-help">
                                                <?php echo Text::_('SITE_PRELOADER_TOOLTIP'); ?>
                                            </span>
                                        </label>
                                    </div>
                                </div>
                                <div class="ba-options-group">
                                    <div class="ba-group-element">
                                        <label>
                                            <?php echo Text::_('EMAIL_ADDRESS_ENCRYPTION'); ?>
                                        </label>
                                        <label class="ba-checkbox">
                                            <input type="checkbox" class="website-email-encryption"
                                                <?php echo $this->website->email_encryption == 1 ? 'checked' : ''; ?>>
                                            <span></span>
                                        </label>
                                        <label class="ba-help-icon">
                                            <i class="zmdi zmdi-help"></i>
                                            <span class="ba-tooltip ba-help">
                                                <?php echo Text::_('EMAIL_ADDRESS_ENCRYPTION_DESC'); ?>
                                            </span>
                                        </label>
                                    </div>
                                </div>
                                <div class="ba-options-group">
                                    <div class="ba-group-element">
                                        <label><?php echo Text::_('ACCESSIBLE_DESIGN'); ?></label>
                                        <label class="ba-checkbox">
                                            <input type="checkbox" class="joomla-accessibility-toolbar"
                                                <?php echo $this->website->accessibility == 1 ? 'checked' : ''; ?>>
                                            <span></span>
                                        </label>
                                        <label class="ba-help-icon">
                                            <i class="zmdi zmdi-help"></i>
                                            <span class="ba-tooltip ba-help"><?php echo Text::_('ACCESSIBLE_DESIGN_TOOLTIP'); ?></span>
                                        </label>
                                    </div>
                                </div>
                                <div class="ba-options-group">
                                    <div class="ba-group-element">
                                        <label>
                                            <?php echo Text::_('DATE_FROMAT'); ?>
                                        </label>
                                        <div class="ba-custom-select date-format-select visible-select-top">
                                            <input readonly="" onfocus="this.blur()" type="text">
                                            <input type="hidden" value="<?php echo $dateFormatValue; ?>">
                                            <i class="zmdi zmdi-caret-down"></i>
                                            <ul>
                                                <li data-value="j F Y">11 April 2016</li>
                                                <li data-value="F jS, Y">April 11th, 2016</li>
                                                <li data-value="F j, Y g:i a">April 11, 2016 11:36 am</li>
                                                <li data-value="M d, Y">Apr 11, 2016</li>
                                                <li data-value="d M, Y">11 Apr, 2016</li>
                                                <li data-value=""><?php echo Text::_('CUSTOM'); ?></li>
                                            </ul>
                                        </div>
                                    </div>
                                    <div class="ba-subgroup-element">
                                        <div class="ba-group-element ba-custom-date-format">
                                            <label>
                                                <?php echo Text::_('CUSTOM'); ?>
                                            </label>
                                            <input type="text" placeholder="F j, Y"
                                                value="<?php echo GridboxHelper::$dateFormat; ?>">
                                            <label class="ba-help-icon">
                                                <i class="zmdi zmdi-help"></i>
                                                <span class="ba-tooltip ba-help">
                                                    <?php echo Text::_('CUSTOM_DATE_FORMAT_TOOLTIP'); ?>
                                                </span>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane" id="site-scripts-options">
                                <div class="ba-options-group">
                                    <div class="ba-group-element input-resize site-custom-code-wrapper">
                                        <label>
                                            <?php echo Text::_('HEADER_SCRIPTS'); ?>
                                        </label>
                                        <textarea class="header-code"
                                            placeholder="<?php echo Text::_('HEADER_SCRIPTS'); ?>"
                                            ><?php echo $this->website->header_code; ?></textarea>
                                    </div>
                                </div>
                                <div class="ba-options-group">
                                    <div class="ba-group-element input-resize site-custom-code-wrapper">
                                        <label>
                                            <?php echo Text::_('BODY_SCRIPTS'); ?>
                                        </label>
                                        <textarea class="body-code"
                                            placeholder="<?php echo Text::_('BODY_SCRIPTS'); ?>"
                                            ><?php echo $this->website->body_code; ?></textarea>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane" id="site-analytics-options">
                                <div class="ba-options-group">
                                    <div class="ba-group-element">
                                        <label>Google</label>
                                        <label class="ba-checkbox">
                                            <input type="checkbox" class="google-analytics set-group-display"
                                                <?php echo $this->website->google_analytics == 1 ? 'checked' : ''; ?>>
                                            <span></span>
                                        </label>
                                    </div>
                                    <div class="ba-subgroup-element">
                                        <div class="ba-group-element">
                                            <label><?php echo Text::_('ANALYTICS_TRACKING_ID'); ?></label>
                                            <input type="text" class="google-analytics-id" placeholder="UA-XXXXXXXX-X" 
                                                value="<?php echo $this->website->google_analytics_id; ?>">
                                        </div>
                                        <div class="ba-group-element">
                                            <label><?php echo Text::_('TAG_MANAGER_TRACKING_ID'); ?></label>
                                            <input type="text" class="google-gtm-id" placeholder="GTM-XXXX" 
                                                value="<?php echo $this->website->google_gtm_id; ?>">
                                        </div>
                                        <div class="ba-group-element">
                                            <label><?php echo Text::_('ECOMMERCE_TRACKING'); ?></label>
                                            <label class="ba-checkbox">
                                                <input type="checkbox" class="ecommerce-tracking"
                                                    <?php echo $this->website->ecommerce_tracking == 1 ? 'checked' : ''; ?>>
                                                <span></span>
                                            </label>
                                            <label class="ba-help-icon">
                                                <i class="zmdi zmdi-help"></i>
                                                <span class="ba-tooltip ba-help">
                                                    <?php echo Text::_('ECOMMERCE_TRACKING_HELP'); ?>
                                                </span>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <div class="ba-options-group">
                                    <div class="ba-group-element">
                                        <label>Yandex Metrica</label>
                                        <label class="ba-checkbox">
                                            <input type="checkbox" class="yandex-metrica set-group-display"
                                                <?php echo $this->website->yandex_metrica == 1 ? 'checked' : ''; ?>>
                                            <span></span>
                                        </label>
                                    </div>
                                    <div class="ba-subgroup-element">
                                        <div class="ba-group-element">
                                            <label><?php echo Text::_('TAG_NUMBER'); ?></label>
                                            <input type="text" class="yandex-tag-number" placeholder="123456789" 
                                                value="<?php echo $this->website->yandex_tag_number; ?>">
                                        </div>
                                    </div>
                                </div>
                                <div class="ba-options-group">
                                    <div class="ba-group-element">
                                        <label>Facebook Pixel</label>
                                        <label class="ba-checkbox">
                                            <input type="checkbox" class="facebook-pixel set-group-display"
                                                <?php echo $this->website->facebook_pixel == 1 ? 'checked' : ''; ?>>
                                            <span></span>
                                        </label>
                                    </div>
                                    <div class="ba-subgroup-element">
                                        <div class="ba-group-element">
                                            <label>Pixel ID</label>
                                            <input type="text" class="facebook-pixel-id" placeholder="123456789012345" 
                                                value="<?php echo $this->website->facebook_pixel_id; ?>">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane" id="site-seo-options">
                                <div class="ba-options-group"
                                <?php echo isset(GridboxHelper::$systemApps->canonical) ? '' : ' style="display: none !important;"'; ?>>
                                    <div class="ba-group-element">
                                        <label>
                                            <?php echo Text::_('CANONICAL_URLS'); ?>
                                        </label>
                                        <label class="ba-checkbox">
                                            <input type="checkbox" class="enable-canonical set-group-display"
                                                <?php echo $this->website->enable_canonical == 1 ? 'checked' : ''; ?>>
                                            <span></span>
                                        </label>
                                    </div>
                                    <div class="ba-subgroup-element">
                                        <div class="ba-group-element">
                                            <label><?php echo Text::_('SITE_DOMAIN'); ?></label>
                                            <input type="text" class="canonical-domain"
                                                placeholder="https://www.example.com"
                                                value="<?php echo $this->website->canonical_domain; ?>">
                                        </div>
                                        <div class="ba-group-element">
                                            <label><?php echo Text::_('TRAILING_SLASH'); ?></label>
                                            <label class="ba-checkbox">
                                                <input type="checkbox" class="canonical-trailing-slash"
                                                    <?php echo $this->website->canonical_slash == 1 ? 'checked' : ''; ?>>
                                                <span></span>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <div class="ba-options-group"
                                <?php echo isset(GridboxHelper::$systemApps->sitemap) ? '' : ' style="display: none !important;"'; ?>>
                                    <div class="ba-group-element">
                                        <label>
                                            <?php echo Text::_('SITEMAP'); ?>
                                        </label>
                                        <label class="ba-checkbox">
                                            <input type="checkbox" class="enable-sitemap set-group-display"
                                                <?php echo $this->website->enable_sitemap == 1 ? 'checked' : ''; ?>>
                                            <span></span>
                                        </label>
                                    </div>
                                    <div class="ba-subgroup-element">
                                        <div class="ba-group-element">
                                            <label><?php echo Text::_('TRAILING_SLASH'); ?></label>
                                            <label class="ba-checkbox">
                                                <input type="checkbox" class="sitemap-trailing-slash"
                                                    <?php echo $this->website->sitemap_slash == 1 ? 'checked' : ''; ?>>
                                                <span></span>
                                            </label>
                                        </div>
                                        <div class="ba-group-element">
                                            <label><?php echo Text::_('SITE_DOMAIN'); ?></label>
                                            <input type="text" class="sitemap-domain"
                                                placeholder="https://www.example.com"
                                                value="<?php echo $this->website->sitemap_domain; ?>">
                                        </div>
                                        <div class="ba-group-element">
	                                        <label>
	                                            <?php echo Text::_('UPDATE_SITEMAP'); ?>
	                                        </label>
	                                        <label class="ba-checkbox">
	                                            <input type="checkbox" class="update-sitemap">
	                                            <span></span>
	                                        </label>
	                                    </div>
                                        <div class="ba-group-element">
                                            <label><?php echo Text::_('VIEW_SITEMAP'); ?></label>
                                            <a href="<?php echo Uri::root().'sitemap.xml'; ?>" target="_blank"
                                                class="view-sitemap default-action">Sitemap.xml</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane" id="site-media-manager-options">
                                <div class="ba-options-group">
                                    <div class="ba-group-element">
                                        <label>
                                            <?php echo Text::_('PATH_IMAGE_FOLDER'); ?>
                                        </label>
                                        <input type="text" placeholder="<?php echo Text::_('PATH_IMAGE_FOLDER'); ?>"
                                            class="website-image-path" value="<?php echo $this->website->image_path; ?>">
                                        <label class="ba-help-icon">
                                            <i class="zmdi zmdi-help"></i>
                                            <span class="ba-tooltip ba-help">
                                                <?php echo Text::_('PATH_IMAGE_FOLDER_DESC'); ?>
                                            </span>
                                        </label>
                                    </div>
                                </div>
                                <div class="ba-options-group">
                                    <div class="ba-group-element">
                                        <label>
                                            <?php echo Text::_('ALLOWED_FILE_TYPES'); ?>
                                        </label>
                                        <input type="text" placeholder="<?php echo Text::_('ALLOWED_FILE_TYPES'); ?>"
                                            class="website-file-types" value="<?php echo $this->website->file_types; ?>">
                                        <label class="ba-help-icon">
                                            <i class="zmdi zmdi-help"></i>
                                            <span class="ba-tooltip ba-help">
                                                <?php echo Text::_('ALLOWED_FILE_TYPES_DESC'); ?>
                                            </span>
                                        </label>
                                    </div>
                                </div>
                                <div class="ba-options-group">
                                    <div class="ba-group-element">
                                        <label><?php echo Text::_('COMPRESS_IMAGES_ON_UPLOAD'); ?></label>
                                        <label class="ba-checkbox">
                                            <input type="checkbox" class="upload-images-compression set-group-display"
                                                <?php echo $this->website->upload_compress_images == 1 ? 'checked' : ''; ?>>
                                            <span></span>
                                        </label>
                                    </div>
                                    <div class="ba-subgroup-element">
                                        <div class="ba-group-element">
                                            <label><?php echo Text::_('MAX_SIZE'); ?></label>
                                            <input type="number" class="upload-images-size"
                                                value="<?php echo $this->website->upload_images_size; ?>">
                                        </div>
                                        <div class="ba-group-element">
                                            <label><?php echo Text::_('IMAGE_QUALITY'); ?></label>
                                            <div class="ba-range-wrapper">
                                                <span class="ba-range-liner"></span>
                                                <input type="range" class="ba-range" min="0" max="100" step="1"
                                                    value="<?php echo $this->website->images_quality; ?>">
                                                <input type="number" step="1" data-callback="emptyCallback"
                                                    class="upload-images-quality"
                                                    value="<?php echo $this->website->upload_images_quality; ?>">
                                            </div>
                                        </div>
                                        <div class="ba-group-element">
                                            <label><?php echo Text::_('CONVERT_TO_WEBP'); ?></label>
                                            <label class="ba-checkbox">
                                                <input type="checkbox" class="upload-images-webp"
                                                    <?php echo $this->website->upload_images_webp == 1 ? 'checked' : ''; ?>>
                                                <span></span>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div id="mobile-options" class="row-fluid left-tabs-wrapper tab-pane">
                    <div class="left-tabs">
                        <ul class="nav nav-tabs">
                            <li class="active">
                                <a href="#mobile-basic-options" data-toggle="tab">
                                    <i class="zmdi zmdi-settings"></i>
                                    <?php echo Text::_('BASIC'); ?>
                                </a>
                            </li>
                            <li>
                                <a href="#mobile-breakpoints-options" data-toggle="tab">
                                    <i class="zmdi zmdi-devices"></i>
                                    <?php echo Text::_('BREAKPOINTS'); ?>
                                </a>
                            </li>
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane active" id="mobile-basic-options">
                                <div class="ba-options-group">
                                    <div class="ba-group-element">
                                        <label>
                                            <?php echo Text::_('CONTAINER'); ?>, px
                                        </label>
                                        <input type="number" class="website-container" value="<?php echo $this->website->container; ?>">
                                    </div>
                                </div>
                                <div class="ba-options-group">
                                    <div class="ba-group-element">
                                        <label><?php echo Text::_('DISABLE_RESPONSIVE'); ?></label>
                                        <label class="ba-checkbox">
                                            <input type="checkbox" class="disable-responsive"
                                                <?php echo $this->website->disable_responsive == 1 ? 'checked' : ''; ?>>
                                            <span></span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane" id="mobile-breakpoints-options">
                                <div class="ba-options-group">
                                    <div class="ba-group-element breakpoints-container">
                                        <label>
                                            <?php echo Text::_('LAPTOP'); ?>, px
                                        </label>
                                        <input type="number" value="<?php echo GridboxHelper::$breakpoints->laptop; ?>"
                                            data-breakpoint="laptop">
                                    </div>
                                </div>
                                <div class="ba-options-group">
                                    <div class="ba-group-element breakpoints-container">
                                        <label>
                                            <?php echo Text::_('TABLET_LANDSCAPE'); ?>, px
                                        </label>
                                        <input type="number" value="<?php echo GridboxHelper::$breakpoints->tablet; ?>"
                                            data-breakpoint="tablet">
                                    </div>
                                    <div class="ba-group-element breakpoints-container">
                                        <label>
                                            <?php echo Text::_('TABLET_PORTRAIT'); ?>, px
                                        </label>
                                        <input type="number" value="<?php echo GridboxHelper::$breakpoints->{'tablet-portrait'}; ?>"
                                            data-breakpoint="tablet-portrait">
                                    </div>
                                </div>
                                <div class="ba-options-group">
                                    <div class="ba-group-element breakpoints-container">
                                        <label>
                                            <?php echo Text::_('PHONE_LANDSCAPE'); ?>, px
                                        </label>
                                        <input type="number" value="<?php echo GridboxHelper::$breakpoints->phone; ?>"
                                            data-breakpoint="phone">
                                    </div>
                                    <div class="ba-group-element breakpoints-container">
                                        <label>
                                            <?php echo Text::_('PHONE_PORTRAIT'); ?>, px
                                        </label>
                                        <input type="number" value="<?php echo GridboxHelper::$breakpoints->{'phone-portrait'}; ?>"
                                            data-breakpoint="phone-portrait">
                                    </div>
                                </div>
                                <div class="ba-options-group">
                                    <div class="ba-group-element">
                                        <label>
                                            <?php echo Text::_('MOBILE_MENU'); ?>, px
                                        </label>
                                        <input type="number" value="<?php echo GridboxHelper::$menuBreakpoint; ?>" class="menu-breakpoint">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div id="performance-options" class="row-fluid left-tabs-wrapper tab-pane">
                    <div class="left-tabs">
                        <ul class="nav nav-tabs">
                            <li class="active">
                                <a href="#performance-minify-options" data-toggle="tab">
                                    <i class="zmdi zmdi-scissors"></i>
                                    <?php echo Text::_('MINIFY'); ?>
                                </a>
                            </li>
                            <li>
                                <a href="#performance-images-options" data-toggle="tab">
                                    <i class="zmdi zmdi-camera-alt"></i>
                                    <?php echo Text::_('IMAGES'); ?>
                                </a>
                            </li>
                            <li>
                                <a href="#performance-caching-options" data-toggle="tab">
                                    <i class="zmdi zmdi-card-sd"></i>
                                    <?php echo Text::_('CACHING'); ?>
                                </a>
                            </li>
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane active" id="performance-minify-options">
                                <div class="ba-options-group">
                                    <div class="ba-group-element">
                                        <label>HTML</label>
                                        <label class="ba-checkbox">
                                            <input type="checkbox" class="compress-html"
                                                <?php echo $this->website->compress_html == 1 ? 'checked' : ''; ?>>
                                            <span></span>
                                        </label>
                                    </div>
                                    <div class="ba-group-element">
                                        <label>CSS</label>
                                        <label class="ba-checkbox">
                                            <input type="checkbox" class="compress-css"
                                                <?php echo $this->website->compress_css == 1 ? 'checked' : ''; ?>>
                                            <span></span>
                                        </label>
                                    </div>
                                    <div class="ba-group-element">
                                        <label>Javascript</label>
                                        <label class="ba-checkbox">
                                            <input type="checkbox" class="compress-js"
                                                <?php echo $this->website->compress_js == 1 ? 'checked' : ''; ?>>
                                            <span></span>
                                        </label>
                                    </div>
                                </div>
                                <div class="ba-options-group">
                                    <div class="ba-group-element">
                                        <label><?php echo Text::_('DEFERRED_LOADING') ?></label>
                                        <label class="ba-checkbox">
                                            <input type="checkbox" class="deferred-loading"
                                                <?php echo $this->website->defer_loading == 1 ? 'checked' : ''; ?>>
                                            <span></span>
                                        </label>
                                        <label class="ba-help-icon">
                                            <i class="zmdi zmdi-help"></i>
                                            <span class="ba-tooltip ba-help">
                                                <?php echo Text::_('DEFERRED_LOADING_TOOLTIP'); ?>
                                            </span>
                                        </label>
                                    </div>
                                    <div class="ba-group-element">
                                        <label><?php echo Text::_('DISABLE_GOOGLE_FONTS') ?></label>
                                        <label class="ba-checkbox">
                                            <input type="checkbox" class="google-fonts"
                                                <?php echo $this->website->google_fonts == 0 ? 'checked' : ''; ?>>
                                            <span></span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane" id="performance-images-options">
                                <div class="ba-options-group">
                                    <div class="ba-group-element">
                                        <label><?php echo Text::_('COMPRESS_IMAGES'); ?></label>
                                        <label class="ba-checkbox">
                                            <input type="checkbox" class="images-compression set-group-display"
                                                <?php echo $this->website->compress_images == 1 ? 'checked' : ''; ?>>
                                            <span></span>
                                        </label>
                                    </div>
                                    <div class="ba-subgroup-element">
                                        <div class="ba-group-element">
                                            <label><?php echo Text::_('MAX_SIZE'); ?></label>
                                            <input type="number" class="images-max-size"
                                                value="<?php echo $this->website->images_max_size; ?>">
                                        </div>
                                        <div class="ba-group-element">
                                            <label><?php echo Text::_('IMAGE_QUALITY'); ?></label>
                                            <div class="ba-range-wrapper">
                                                <span class="ba-range-liner"></span>
                                                <input type="range" class="ba-range" min="0" max="100" step="1"
                                                    value="<?php echo $this->website->images_quality; ?>">
                                                <input type="number" step="1" data-callback="emptyCallback"
                                                    class="images-quality"
                                                    value="<?php echo $this->website->images_quality; ?>">
                                            </div>
                                        </div>
                                        <div class="ba-group-element">
                                            <label><?php echo Text::_('CONVERT_TO_WEBP'); ?></label>
                                            <label class="ba-checkbox">
                                                <input type="checkbox" class="images-compression-webp"
                                                <?php echo $this->website->compress_images_webp == 1 ? 'checked' : ''; ?>>
                                                <span></span>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <div class="ba-options-group">
                                    <div class="ba-group-element">
                                        <label><?php echo Text::_('ADAPTIVE_IMAGES'); ?></label>
                                        <label class="ba-checkbox">
                                            <input type="checkbox" class="adaptive-images set-group-display"
                                                <?php echo $this->website->adaptive_images == 1 ? 'checked' : ''; ?>>
                                            <span></span>
                                        </label>
                                        <label class="ba-help-icon">
                                            <i class="zmdi zmdi-help"></i>
                                            <span class="ba-tooltip ba-help">
                                                <?php echo Text::_('ADAPTIVE_IMAGES_TOOLTIP'); ?>
                                            </span>
                                        </label>
                                    </div>
                                    <div class="ba-subgroup-element">
                                        <div class="ba-group-element">
                                            <label><?php echo Text::_('IMAGE_QUALITY'); ?></label>
                                            <div class="ba-range-wrapper">
                                                <span class="ba-range-liner"></span>
                                                <input type="range" class="ba-range" min="0" max="100" step="1"
                                                    value="<?php echo $this->website->adaptive_quality; ?>">
                                                <input type="number" step="1" data-callback="emptyCallback"
                                                    class="adaptive-quality"
                                                    value="<?php echo $this->website->adaptive_quality; ?>">
                                            </div>
                                        </div>
                                        <div class="ba-group-element">
                                            <label><?php echo Text::_('CONVERT_TO_WEBP'); ?></label>
                                            <label class="ba-checkbox">
                                                <input type="checkbox" class="images-adaptive-webp"
                                                <?php echo $this->website->adaptive_images_webp == 1 ? 'checked' : ''; ?>>
                                                <span></span>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <div class="ba-options-group">
                                    <div class="ba-group-element">
                                        <label><?php echo Text::_('LAZY_LOAD_IMAGES'); ?></label>
                                        <label class="ba-checkbox">
                                            <input type="checkbox" class="images-lazy-load"
                                                <?php echo $this->website->images_lazy_load == 1 ? 'checked' : ''; ?>>
                                            <span></span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane" id="performance-caching-options">
                                <div class="ba-options-group">
                                    <div class="ba-group-element">
                                        <label><?php echo Text::_('PAGE_CACHE'); ?></label>
                                        <label class="ba-checkbox">
                                            <input type="checkbox" class="page-cache set-group-display"
                                                <?php echo $this->website->page_cache == 1 ? 'checked' : ''; ?>>
                                            <span></span>
                                        </label>
                                    </div>
                                    <div class="ba-subgroup-element">
                                        <div class="ba-group-element">
                                            <label><?php echo Text::_('BROWSER_CACHING'); ?></label>
                                            <label class="ba-checkbox">
                                                <input type="checkbox" class="browser-cache"
                                                    <?php echo $this->website->browser_cache == 1 ? 'checked' : ''; ?>>
                                                <span></span>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div id="photo-editor-dialog" class="ba-modal-lg modal hide" style="display:none">
    <div class="modal-header">
        <span class="ba-dialog-title"><?php echo Text::_('PHOTO_EDITOR'); ?></span>
        <div class="modal-header-icon">
            <i class="zmdi zmdi-close" data-dismiss="modal"></i>
        </div>
    </div>
    <div class="modal-body">
        <div class="general-tabs">
            <ul class="nav nav-tabs uploader-nav">
                <li class="active">
                    <a href="#resize-image-options" data-toggle="tab">
                        <i class="zmdi zmdi-wallpaper"></i>
                        <span class="ba-tooltip ba-bottom"><?php echo Text::_('RESIZE'); ?></span>
                    </a>
                </li>
                <li>
                    <a href="#crop-image-options" data-toggle="tab">
                        <i class="zmdi zmdi-crop"></i>
                        <span class="ba-tooltip ba-bottom"><?php echo Text::_('CROP'); ?></span>
                    </a>
                </li>
                <li>
                    <a href="#filter-effects-image-options" data-toggle="tab">
                        <i class="zmdi zmdi-invert-colors"></i>
                        <span class="ba-tooltip ba-bottom"><?php echo Text::_('FILTER_AND_EFFECTS'); ?></span>
                    </a>
                </li>
                <li>
                    <a href="#adjust-image-options" data-toggle="tab">
                        <i class="zmdi zmdi-tune"></i>
                        <span class="ba-tooltip ba-bottom"><?php echo Text::_('ADJUST'); ?></span>
                    </a>
                </li>
                <li>
                    <a href="#flip-rotate-image-options" data-toggle="tab">
                        <i class="zmdi zmdi-flip"></i>
                        <span class="ba-tooltip ba-bottom"><?php echo Text::_('FLIP_ROTATE'); ?></span>
                    </a>
                </li>
                <span class="photo-editor-save-image" data-context="save-image-context-menu">
                    <span><?php echo Text::_('SAVE'); ?></span>
                    <i class="zmdi zmdi-caret-down"></i>
                </span>
            </ul>
            <div class="tabs-underline"></div>
            <div class="resize-image-wrapper">
                <div>
                    <canvas id="photo-editor"></canvas>
                </div>
                <div class="ba-crop-overlay" style="opacity: 0;">
                    <canvas id="ba-overlay-canvas"></canvas>
                    <span class="ba-crop-overlay-resize-handle" data-resize="top-left"></span>
                    <span class="ba-crop-overlay-resize-handle" data-resize="top-right"></span>
                    <span class="ba-crop-overlay-resize-handle" data-resize="bottom-left"></span>
                    <span class="ba-crop-overlay-resize-handle" data-resize="bottom-right"></span>
                </div>
            </div>
            <span class="show-photo-media-editor">
                <span><i class="zmdi zmdi-camera"></i></span>
                <span class="ba-tooltip"><?php echo Text::_('SELECT_PICTURE_TO_START_EDIT'); ?></span>
            </span>
            <div class="tab-content">
                <div id="resize-image-options" class="row-fluid tab-pane active">
                    <div class="ba-settings-group">
                        <div class="ba-settings-toolbar">
                            <div>
                                <span><?php echo Text::_('WIDTH'); ?></span>
                                <input type="number" class="resize-width" data-callback="emptyCallback">
                            </div>
                            <div>
                                <span><?php echo Text::_('HEIGHT'); ?></span>
                                <input type="number" class="resize-height" data-callback="emptyCallback">
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('IMAGE_QUALITY'); ?></span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="100">
                                <input type="number" class="photo-editor-quality" data-callback="photoEditorQuality">
                            </div>
                        </div>
                    </div>
                    <div class="photo-editor-footer">
                        <a href="#" class="reset-image"><?php echo Text::_('RESET'); ?></a>
                        <a href="#" class="resize-action"><?php echo Text::_('APPLY'); ?></a>
                    </div>
                </div>
                <div id="crop-image-options" class="row-fluid tab-pane">
                    <div class="ba-settings-group">
                        <div class="ba-settings-toolbar">
                            <div>
                                <span><?php echo Text::_('WIDTH'); ?></span>
                                <input type="number" class="crop-width" data-callback="emptyCallback">
                            </div>
                            <div>
                                <span><?php echo Text::_('HEIGHT'); ?></span>
                                <input type="number" class="crop-height" data-callback="emptyCallback">
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('KEEP_PROPORTIONS'); ?></span>
                            <label class="ba-checkbox">
                                <input type="checkbox" class="keep-proportions">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('ASPECT_RATIO'); ?></span>
                            <div class="ba-custom-select aspect-ratio-select">
                                <input readonly="" onfocus="this.blur()" type="text" value="">
                                <input type="hidden" value="3">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="original"><?php echo Text::_('ORIGINAL'); ?></li>
                                    <li data-value="1:1">1:1</li>
                                    <li data-value="3:2">3:2</li>
                                    <li data-value="3:4">3:4</li>
                                    <li data-value="16:9">16:9</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="photo-editor-footer">
                        <a href="#" class="reset-image"><?php echo Text::_('RESET'); ?></a>
                        <a href="#" class="crop-action"><?php echo Text::_('APPLY'); ?></a>
                    </div>
                </div>
                <div id="filter-effects-image-options" class="row-fluid tab-pane">
                    <div class="ba-settings-group">
                        <div class="filter-effects-thumbnail">
                            <canvas class="filter-effect-canvas" data-key="original"></canvas>
                            <span>original</span>
                        </div>
                        <div class="filter-effects-thumbnail">
                            <canvas class="filter-effect-canvas" data-key="1977"></canvas>
                            <span>1977</span>
                        </div>
                        <div class="filter-effects-thumbnail">
                            <canvas class="filter-effect-canvas" data-key="aden"></canvas>
                            <span>Aden</span>
                        </div>
                        <div class="filter-effects-thumbnail">
                            <canvas class="filter-effect-canvas" data-key="amaro"></canvas>
                            <span>Amaro</span>
                        </div>
                        <div class="filter-effects-thumbnail">
                            <canvas class="filter-effect-canvas" data-key="brannan"></canvas>
                            <span>Brannan</span>
                        </div>
                        <div class="filter-effects-thumbnail">
                            <canvas class="filter-effect-canvas" data-key="brooklyn"></canvas>
                            <span>Brooklyn</span>
                        </div>
                        <div class="filter-effects-thumbnail">
                            <canvas class="filter-effect-canvas" data-key="clarendon"></canvas>
                            <span>Clarendon</span>
                        </div>
                        <div class="filter-effects-thumbnail">
                            <canvas class="filter-effect-canvas" data-key="earlybird"></canvas>
                            <span>Earlybird</span>
                        </div>
                        <div class="filter-effects-thumbnail">
                            <canvas class="filter-effect-canvas" data-key="gingham"></canvas>
                            <span>Gingham</span>
                        </div>
                        <div class="filter-effects-thumbnail">
                            <canvas class="filter-effect-canvas" data-key="hudson"></canvas>
                            <span>Hudson</span>
                        </div>
                        <div class="filter-effects-thumbnail">
                            <canvas class="filter-effect-canvas" data-key="inkwell"></canvas>
                            <span>Inkwell</span>
                        </div>
                        <div class="filter-effects-thumbnail">
                            <canvas class="filter-effect-canvas" data-key="lofi"></canvas>
                            <span>Lofi</span>
                        </div>
                        <div class="filter-effects-thumbnail">
                            <canvas class="filter-effect-canvas" data-key="maven"></canvas>
                            <span>Maven</span>
                        </div>
                        <div class="filter-effects-thumbnail">
                            <canvas class="filter-effect-canvas" data-key="perpetua"></canvas>
                            <span>Perpetua</span>
                        </div>
                        <div class="filter-effects-thumbnail">
                            <canvas class="filter-effect-canvas" data-key="reyes"></canvas>
                            <span>Reyes</span>
                        </div>
                        <div class="filter-effects-thumbnail">
                            <canvas class="filter-effect-canvas" data-key="stinson"></canvas>
                            <span>Stinson</span>
                        </div>
                        <div class="filter-effects-thumbnail">
                            <canvas class="filter-effect-canvas" data-key="toaster"></canvas>
                            <span>Toaster</span>
                        </div>
                        <div class="filter-effects-thumbnail">
                            <canvas class="filter-effect-canvas" data-key="walden"></canvas>
                            <span>Walden</span>
                        </div>
                        <div class="filter-effects-thumbnail">
                            <canvas class="filter-effect-canvas" data-key="valencia"></canvas>
                            <span>Valencia</span>
                        </div>
                        <div class="filter-effects-thumbnail">
                            <canvas class="filter-effect-canvas" data-key="xpro2"></canvas>
                            <span>Xpro2</span>
                        </div>
                    </div>
                    <div class="photo-editor-footer">
                        <a href="#" class="reset-image"><?php echo Text::_('RESET'); ?></a>
                        <a href="#" class="filter-effects-action"><?php echo Text::_('APPLY'); ?></a>
                    </div>
                </div>
                <div id="adjust-image-options" class="row-fluid tab-pane">
                    <div class="ba-settings-group">
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('CONTRAST'); ?></span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="200" step="1">
                                <input type="number" data-filter="contrast" data-callback="photoEditorFilters">
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('BRIGHTNESS'); ?></span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="200" step="1">
                                <input type="number" data-filter="brightness" data-callback="photoEditorFilters">
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('SATURATE'); ?></span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="200" step="1">
                                <input type="number" data-filter="saturate" data-callback="photoEditorFilters">
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('SEPIA'); ?></span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="100" step="1">
                                <input type="number" data-filter="sepia" data-callback="photoEditorFilters">
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('GRAYSCALE'); ?></span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="100" step="1">
                                <input type="number" data-filter="grayscale" data-callback="photoEditorFilters">
                            </div>
                        </div>
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('BLUR'); ?></span>
                            <div class="ba-range-wrapper">
                                <span class="ba-range-liner"></span>
                                <input type="range" class="ba-range" min="0" max="10" step="1">
                                <input type="number" data-filter="blur" data-callback="photoEditorFilters">
                            </div>
                        </div>
                    </div>
                    <div class="photo-editor-footer">
                        <a href="#" class="reset-image"><?php echo Text::_('RESET'); ?></a>
                        <a href="#" class="adjust-action"><?php echo Text::_('APPLY'); ?></a>
                    </div>
                </div>
                <div id="flip-rotate-image-options" class="row-fluid tab-pane">
                    <span>
                        <i class="zmdi zmdi-rotate-left rotate-action" data-rotate="-90"></i>
                        <span class="ba-tooltip ba-bottom"><?php echo Text::_('ROTATE_LEFT'); ?></span>
                    </span>
                    <span>
                        <i class="zmdi zmdi-rotate-right rotate-action" data-rotate="90"></i>
                        <span class="ba-tooltip ba-bottom"><?php echo Text::_('ROTATE_RIGHT'); ?></span>
                    </span>
                    <span>
                        <i class="zmdi zmdi-flip flip-action" data-flip="horizontal"></i>
                        <span class="ba-tooltip ba-bottom"><?php echo Text::_('FLIP_HORIZONTAL'); ?></span>
                    </span>
                    <span>
                        <i class="zmdi zmdi-flip flip-action" data-flip="vertical"></i>
                        <span class="ba-tooltip ba-bottom"><?php echo Text::_('FLIP_VERTICAL'); ?></span>
                    </span>
                    <div class="photo-editor-footer">
                        <a href="#" class="reset-image"><?php echo Text::_('RESET'); ?></a>
                        <a href="#" class="flip-rotate-action"><?php echo Text::_('APPLY'); ?></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php
if ($this->edit_type == '') {
?>
<div id="settings-dialog" class="ba-modal-lg modal hide" style="display:none">
    <div class="modal-header">
        <span class="ba-dialog-title"><?php echo Text::_('SETTINGS'); ?></span>
        <div class="modal-header-icon">
            <i class="zmdi zmdi-close"></i>
        </div>
    </div>
    <div class="modal-body">
        <div class="general-tabs">
            <ul class="nav nav-tabs uploader-nav">
                <li class="active">
                    <a href="#general-options" data-toggle="tab">
                        <i class="zmdi zmdi-settings"></i>
                        <?php echo Text::_('GENERAL'); ?>
                    </a>
                </li>
                <li>
                    <a href="#publishing-options" data-toggle="tab">
                        <i class="zmdi zmdi-calendar-note"></i>
                        <?php echo Text::_('PUBLISHING'); ?>
                    </a>
                </li>
                <li>
                    <a href="#seo-options" data-toggle="tab">
                        <i class="zmdi zmdi-globe"></i>
                        SEO
                    </a>
                </li>
            </ul>
            <div class="tabs-underline"></div>
            <div class="tab-content">
                <div id="general-options" class="row-fluid tab-pane active">
                    <div class="ba-options-group">
                        <div class="ba-group-element ba-original-title">
                            <label>
                                <?php echo Text::_('JGLOBAL_TITLE'); ?><span class="required-fields-star">*</span>
                            </label>
                            <input type="hidden" name="ba_id" class="page-id" value="<?php echo $this->item->id; ?>">
                            <input type="text" class="page-title page-settings-input-trigger"
                                value="<?php echo htmlentities($this->item->title, ENT_COMPAT, 'utf-8'); ?>"
                                placeholder="<?php echo Text::_('JGLOBAL_TITLE'); ?>" name="page_title">
                            <div class="ba-alert-container" style="display: none;">
                                <i class="zmdi zmdi-alert-circle"></i>
                                <span></span>
                                <span class="ba-tooltip title-alert-tooltip">
                                    <?php echo Text::_('THIS_FIELD_REQUIRED'); ?>
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="ba-options-group">
                        <div class="ba-group-element ba-original-alias">
                            <label>
                                <?php echo Text::_('JFIELD_ALIAS_LABEL'); ?>
                            </label>
                            <input type="text" class="page-alias page-settings-input-trigger"
                                value="<?php echo $this->item->page_alias; ?>"
                                placeholder="<?php echo Text::_('JFIELD_ALIAS_LABEL'); ?>" name="page_alias">
                        </div>
                    </div>
                    <div class="ba-options-group">
                        <div class="ba-group-element">
                            <label>
                                <?php echo Text::_('IMAGE'); ?>
                            </label>
                            <div class="share-image-wrapper">
<?php
                                $intro_image = GridboxHelper::prepareIntroImage($this->item->intro_image);
                                if (!GridboxHelper::isExternal($intro_image)) {
                                    $tooltipImage = Uri::root().$intro_image;
                                } else {
                                    $tooltipImage = $intro_image;
                                }
                                $imageTooltip = !empty($intro_image) ? $tooltipImage : '';
?>
                                <div class="image-field-tooltip"
                                    <?php echo !empty($imageTooltip) ? 'style="background-image: url('.$imageTooltip.')"' : ''; ?>>
                                </div>
                                <input type="text" class="intro-image" name="intro_image"
                                	data-value="<?php echo $this->item->intro_image; ?>" value="<?php echo $intro_image; ?>"
                                    placeholder="<?php echo Text::_('IMAGE'); ?>" readonly="" onfocus="this.blur()">
                                <i class="zmdi zmdi-camera"></i>
                                <div class="reset disabled-reset reset-intro-image">
                                    <i class="zmdi zmdi-close"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="ba-options-group"<?php echo $blogStyle; ?>>
                        <div class="ba-group-element ba-original-intro-text">
                            <label>
                                <?php echo Text::_('INTRO_TEXT'); ?>
                            </label>
                            <textarea placeholder="<?php echo Text::_('INTRO_TEXT'); ?>"
                                name="intro_text" class="intro-text page-settings-input-trigger"
                                ><?php echo $this->item->intro_text; ?></textarea>
                        </div>
                    </div>
                    <div class="ba-options-group"<?php echo $blogStyle; ?>>
                        <div class="ba-group-element">
                            <label>
                                <?php echo Text::_('CATEGORY'); ?>
                            </label>
                            <div class="page-multicategory-select">
                                <input readonly onfocus="this.blur()" type="text" value="<?php echo implode(', ', $multicategory->title); ?>">
                                <input type="hidden" name="page_category" class="page-category" value="<?php echo $this->item->page_category; ?>">
                                <input type="hidden" name="page_categories" value="<?php echo implode(', ', $multicategory->categories); ?>">
                                <i class="zmdi zmdi-caret-down"></i>
                            </div>
                        </div>
                    </div>
                    <div class="ba-options-group"<?php echo $blogStyle; ?>>
                        <div class="ba-group-element ba-original-tags">
                            <div class="ba-tags">
                                <label>
                                    <?php echo Text::_('TAGS'); ?>
                                </label>
                                <div class="meta-tags">
                                    <select style="display: none;" name="meta_tags[]" class="meta_tags" multiple>
<?php
                                    foreach ($this->pageTags as $tag) {
                                        $str = '<option value="'.$tag->id.'" selected>'.$tag->title.'</option>';
                                        echo $str;
                                    }
?>
                                    </select>
                                    <ul class="picked-tags">
<?php
                                    foreach ($this->pageTags as $tag) {
                                        $str = '<li class="tags-chosen"><span>';
                                        $str .= $tag->title.'</span><i class="zmdi zmdi-close" data-remove="'.$tag->id.'"></i></li>';
                                        echo $str;
                                    }
?>
                                        <li class="search-tag">
                                            <input type="text" placeholder="<?php echo Text::_('TAGS'); ?>">
                                        </li>
                                    </ul>
                                    <div class="select-post-tags input-action-icon">
                                        <i class="zmdi zmdi-playlist-plus"></i>
                                        <span class="ba-tooltip ba-top ba-hide-element"><?php echo Text::_('TAGS'); ?></span>
                                    </div>
                                </div>
                            </div>
                            <label class="ba-help-icon">
                                <i class="zmdi zmdi-help"></i>
                                <span class="ba-tooltip ba-help ba-hide-element">
                                    <?php echo Text::_('TAGS_DESC'); ?>
                                </span>
                            </label>
                        </div>
                    </div>
                    <div class="ba-options-group">
                        <div class="ba-group-element">
                            <label>
                                <?php echo Text::_('CLASS_SUFFIX'); ?>
                            </label>
                            <input type="text" class="page-class-suffix"
                                value="<?php echo htmlentities($this->item->class_suffix, ENT_COMPAT, 'utf-8'); ?>"
                                data-value="<?php echo htmlentities($this->item->class_suffix, ENT_COMPAT, 'utf-8'); ?>"
                                placeholder="<?php echo Text::_('CLASS_SUFFIX'); ?>" name="class_suffix">
                            <label class="ba-help-icon">
                                <i class="zmdi zmdi-help"></i>
                                <span class="ba-tooltip ba-help">
                                    <?php echo Text::_('CLASS_SUFFIX_TOOLTIP'); ?>
                                </span>
                            </label>
                        </div>
                    </div>
                </div>
                <div id="publishing-options" class="row-fluid tab-pane">
                    <div class="ba-options-group">
                        <div class="ba-group-element">
                            <label>
                                <?php echo Text::_('PUBLISH'); ?>
                            </label>
                            <label class="ba-checkbox ba-hide-checkbox">
                                <input type="checkbox" name="published" class="page-settings-input-trigger" value="1"
                                    <?php echo $this->item->published == 1 ? ' checked' : '' ?>>
                                <span></span>
                            </label>
                        </div>
                    </div>
                	<div class="ba-options-group">
                    	<div class="ba-group-element ba-original-access page-settings-custom-select-trigger">
                            <label>
                                <?php echo Text::_('JFIELD_ACCESS_LABEL'); ?>
                            </label>
                            <div class="ba-custom-select access-select">
                                <input readonly onfocus="this.blur()" type="text"
                                    value="<?php echo $this->access[$this->item->page_access]; ?>">
                                <input type="hidden" name="access" value="<?php echo $this->item->page_access; ?>">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <?php
                                    foreach ($this->access as $key => $access) {
                                        $str = '<li data-value="'.$key.'">';
                                        $str .= $access.'</li>';
                                        echo $str;
                                    }
                                    ?>
                                </ul>
                            </div>
                            <label class="ba-help-icon">
                                <i class="zmdi zmdi-help"></i>
                                <span class="ba-tooltip ba-help">
                                    <?php echo Text::_('ACCESS_TOOLTIP'); ?>
                                </span>
                            </label>
                        </div>
                    </div>
                    <div class="ba-options-group">
                        <div class="ba-group-element ba-original-publishing">
                            <label>
                                <?php echo Text::_('START_PUBLISHING'); ?>
                            </label>
                            <div class="container-icon">
                                <input type="text" name="published_on"
                                    class="published_on page-settings-input-trigger open-calendar-dialog"
                                    value="<?php echo $this->item->created; ?>">
                                <div class="icons-cell">
                                    <i class="zmdi zmdi-calendar-alt"></i>
                                </div>
                            </div>
                            <label class="ba-help-icon">
                                <i class="zmdi zmdi-help"></i>
                                <span class="ba-tooltip ba-help">
                                    <?php echo Text::_('START_DESC'); ?>
                                </span>
                            </label>
                        </div>
                        <div class="ba-group-element"<?php echo $blogStyle; ?>>
                            <label>
                                <?php echo Text::_('END_PUBLISHING'); ?>
                            </label>
                            <div class="container-icon">
<?php
                                $end = $this->item->end_publishing == '0000-00-00 00:00:00' ? '' : $this->item->end_publishing;
?>
                                <input type="text" name="published_down"
                                    class="published_down page-settings-input-trigger open-calendar-dialog"
                                    value="<?php echo $end; ?>">
                                <div class="icons-cell">
                                    <i class="zmdi zmdi-calendar-alt"></i>
                                </div>
                            </div>
                            <label class="ba-help-icon">
                                <i class="zmdi zmdi-help"></i>
                                <span class="ba-tooltip ba-help">
                                    <?php echo Text::_('END_DESC'); ?>
                                </span>
                            </label>
                        </div>
                    </div>
                    <div class="ba-options-group"<?php echo $blogStyle; ?>>
                    	<div class="ba-group-element ba-author-element-wrapper">
                            <label>
                                <?php echo Text::_('AUTHOR'); ?>
                            </label>
                            <div class="ba-custom-author-select-wrapper">
<?php
                                $authors = [];
                                foreach ($this->item->authors as $author) {
                                    if (empty($author->avatar)) {
                                        $author->avatar = 'components/com_gridbox/assets/images/thumb-square.png';
                                    }
                                    $str = '<span class="selected-author" data-id="'.$author->id;
                                    $str .= '"><span class="ba-author-avatar" style="background-image: url(';
                                    $str .= Uri::root().$author->avatar.')"></span><span class="ba-author-name">'.$author->title.'</span>';
                                    $str .= '<i class="zmdi zmdi-close remove-selected-author"></i></span>';
                                    echo $str;
                                    $authors[] = $author->id;
                                }
                                $authorId = implode(',', $authors);
?>
                                <div class="ba-custom-author-select select-post-author"
                                    <?php echo count($authors) == count($this->authors) ? ' style="display: none;"' : ''; ?>>
                                    <input readonly type="text" placeholder="<?php echo Text::_('AUTHOR'); ?>">
                                    <input type="hidden" name="author" value="<?php echo $authorId; ?>">
                                    <ul>
                                        <?php
                                        foreach ($this->authors as $author) {
                                            if (empty($author->avatar)) {
                                                $author->avatar = 'components/com_gridbox/assets/images/thumb-square.png';
                                            }
                                            $str = '<li data-value="'.$author->id.'" data-image="'.Uri::root().$author->avatar;
                                            $str .= '"'.(in_array($author->id, $authors) ? ' style="display: none;"' : '');
                                            $str .= '><span class="ba-author-avatar" ';
                                            $str .= 'style="background-image: url('.Uri::root().$author->avatar.')"></span>';
                                            $str .= $author->title.'</li>';
                                            echo $str;
                                        }
                                        ?>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>                    
                    <div class="ba-options-group">
                        <div class="ba-group-element ba-original-language">
                            <label>
                                <?php echo Text::_('JFIELD_LANGUAGE_LABEL'); ?>
                            </label>
<?php
                            $languageTop = empty($blogStyle) ? ' ' : '';
            $style = $this->item->language == '*' ? '' : ' style="--flag-img: url('.$flags.$this->item->language.'.png)"';
?>
                            <div
                                    class="ba-custom-select language-select page-settings-custom-select-trigger
                                visible-select-top" <?php echo $style; ?>>
                                <input readonly onfocus="this.blur()" type="text"
                                    value="<?php echo $this->languages[$this->item->language]; ?>">
                                <input type="hidden" name="language" value="<?php echo $this->item->language; ?>">
                                <ul>
<?php
                                foreach ($this->languages as $key => $language) {
                                    $style = $key == '*' ? '' : ' style="--flag-img: url('.$flags.$key.'.png)"';
?>
                                    <li data-value="<?php echo $key; ?>"<?php echo $style; ?>>
                                        <?php echo $language; ?>
                                    </li>
<?php
                                }
?>
                                </ul>
                                <i class="zmdi zmdi-caret-down"></i>
                            </div>
                            <label class="ba-help-icon">
                                <i class="zmdi zmdi-help"></i>
                                <span class="ba-tooltip ba-help">
                                    <?php echo Text::_('LANGUAGE_DESC'); ?>
                                </span>
                            </label>
                        </div>
                    </div>
<?php
                if (Associations::isEnabled()) {
?>
                    <div class="ba-options-group language-associations-group">
<?php
                    foreach ($this->languages as $key => $language) {
                        if ($key == '*') {
                            continue;
                        }
?>
                        <div class="ba-group-element" data-lang="<?php echo $key; ?>">
                            <label>
                                <?php echo Text::_('ASSOCIATIONS'); ?>
                            </label>
                            <div class="association-wrapper">
                                <span class="ba-language-flag"
                                    style="background-image: url(<?php echo $flags.$key; ?>.png);">
                                    <span class="ba-tooltip ba-top ba-hide-element">
                                        <?php echo $language; ?>
                                    </span>
                                </span>
                                <input type="text" class="association-page" data-lang="<?php echo $key; ?>"
                                    placeholder="<?php echo Text::_('SELECT'); ?>" readonly="" onfocus="this.blur()">
                                <div class="reset disabled-reset reset-association">
                                    <i class="zmdi zmdi-close"></i>
                                </div>
                            </div>
                        </div>
<?php
                    }
?>
                    </div>
<?php
                }
?>
                </div>
                <div id="seo-options" class="row-fluid tab-pane left-tabs-wrapper">
                    <div class="left-tabs">
                        <ul class="nav nav-tabs">
                            <li class="active">
                                <a href="#seo-general-options" data-toggle="tab">
                                    <i class="zmdi zmdi-settings"></i>
                                    <?php echo Text::_('BASIC'); ?>
                                </a>
                            </li>
                            <li>
                                <a href="#sharing-options" data-toggle="tab">
                                    <i class="zmdi zmdi-share"></i>
                                    <?php echo Text::_('SHARING'); ?>
                                </a>
                            </li>
<?php  
                        if (isset(GridboxHelper::$systemApps->sitemap)) {
?>
                            <li>
                                <a href="#sitemap-options" data-toggle="tab">
                                    <i class="zmdi zmdi-device-hub"></i>
                                    <?php echo Text::_('SITEMAP'); ?>
                                </a>
                            </li>
<?php
                        }
?>
                            <li>
                                <a href="#schema-markup" data-toggle="tab">
                                    <i class="zmdi zmdi-code"></i>
                                    <?php echo Text::_('SCHEMA_MARKUP'); ?>
                                </a>
                            </li>
                        </ul>
                        <span class="seo-default-settings" data-id="<?php echo $this->app; ?>"
                            data-type="<?php echo empty($this->item->app_type) || $this->item->app_type == 'single' ? 'page' : 'post'; ?>">
                            <i class="zmdi zmdi-globe"></i>
                            <?php echo Text::_('DEFAULT_SETTINGS'); ?>
                            <span class="ba-tooltip ba-top ba-hide-element"><?php echo Text::_('DEFAULT_SETTINGS_TOOLTIP'); ?></span>
                        </span>
                        <div class="tab-content">
                            <div id="seo-general-options" class="row-fluid tab-pane active">
                                <div class="ba-options-group">
                                    <div class="ba-group-element ba-original-browser-title">
                                        <label>
                                            <?php echo Text::_('BROWSER_PAGE_TITLE'); ?>
                                        </label>
                                        <input type="text" name="page_meta_title" class="page-meta-title page-settings-input-trigger"
                                            value="<?php echo htmlentities($this->item->meta_title, ENT_COMPAT, 'utf-8'); ?>"
                                            placeholder="<?php echo Text::_('BROWSER_PAGE_TITLE'); ?>">
                                        <div class="select-data-tags input-action-icon" data-template="<?php echo $pageDataTags; ?>">
                                            <i class="zmdi zmdi-playlist-plus"></i>
                                            <span class="ba-tooltip ba-help"><?php echo Text::_('DATA_TAGS'); ?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="ba-options-group">
                                    <div class="ba-group-element ba-original-meta-description">
                                        <label>
                                            <?php echo Text::_('JFIELD_META_DESCRIPTION_LABEL'); ?>
                                        </label>
                                        <textarea name="page_meta_description" class="page-meta-description page-settings-input-trigger"
                                            placeholder="<?php echo Text::_('JFIELD_META_DESCRIPTION_LABEL'); ?>"
                                            ><?php echo $this->item->meta_description; ?></textarea>
                                        <div class="select-data-tags input-action-icon" data-template="<?php echo $pageDataTags; ?>">
                                            <i class="zmdi zmdi-playlist-plus"></i>
                                            <span class="ba-tooltip ba-help"><?php echo Text::_('DATA_TAGS'); ?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="ba-options-group">
                                    <div class="ba-group-element ba-original-meta-keywords">
                                        <label>
                                            <?php echo Text::_('META_KEYWORDS'); ?>
                                        </label>
                                        <textarea name="page_meta_keywords" class="page-meta-keywords page-settings-input-trigger"
                                            placeholder="<?php echo Text::_('META_KEYWORDS'); ?>"
                                            ><?php echo $this->item->meta_keywords; ?></textarea>
                                    </div>
                                </div>
                                <div class="ba-options-group">
                                    <div class="ba-group-element">
                                        <label>
                                            <?php echo Text::_('ROBOTS'); ?>
                                        </label>
                                        <div class="ba-custom-select robots-select visible-select-top page-settings-custom-select-trigger">
                                            <input readonly onfocus="this.blur()" value="<?php echo $robots; ?>" type="text">
                                            <input type="hidden" name="robots" value="<?php echo $this->item->robots; ?>">
                                            <ul>
                                                <li data-value=""><?php echo Text::_('JGLOBAL_USE_GLOBAL'); ?></li>
                                                <li data-value="index, follow">index, follow</li>
                                                <li data-value="noindex, follow">noindex, follow</li>
                                                <li data-value="index, nofollow">index, nofollow</li>
                                                <li data-value="noindex, nofollow">noindex, nofollow</li>
                                            </ul>
                                            <i class="zmdi zmdi-caret-down"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div id="sharing-options" class="row-fluid tab-pane">
                                <div class="ba-options-group">
                                    <div class="ba-group-element">
                                        <label>
                                            <?php echo Text::_('IMAGE'); ?>
                                        </label>
                                        <div class="share-image-wrapper">
<?php
                                            if ($this->item->share_image == 'share_image') {
                                                $this->item->share_image = $this->item->intro_image;
                                            }
                                            if (!GridboxHelper::isExternal($this->item->share_image)) {
                                                $tooltipImage = Uri::root().$this->item->share_image;
                                            } else {
                                                $tooltipImage = $this->item->share_image;
                                            }
                                            $imageTooltip = !empty($this->item->share_image) ? $tooltipImage : '';
?>
                                            <div class="image-field-tooltip"
                                                <?php echo !empty($imageTooltip) ? 'style="background-image: url('.$imageTooltip.')"' : ''; ?>>
                                            </div>
                                            <input type="text" class="share-image page-settings-input-trigger" name="share_image"
                                                value="<?php echo $this->item->share_image; ?>"
                                                placeholder="<?php echo Text::_('IMAGE'); ?>" readonly="" onfocus="this.blur()">
                                            <i class="zmdi zmdi-camera"></i>
                                            <div class="reset disabled-reset reset-share-image">
                                                <i class="zmdi zmdi-close"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="ba-options-group">
                                    <div class="ba-group-element">
                                        <label>
                                            <?php echo Text::_('JGLOBAL_TITLE'); ?>
                                        </label>
                                        <input type="text" name="share_title" class="share-title page-settings-input-trigger"
                                            value="<?php echo $this->item->share_title; ?>"
                                            placeholder="<?php echo Text::_('JGLOBAL_TITLE'); ?>">
                                        <div class="select-data-tags input-action-icon" data-template="<?php echo $pageDataTags; ?>">
                                            <i class="zmdi zmdi-playlist-plus"></i>
                                            <span class="ba-tooltip ba-help"><?php echo Text::_('DATA_TAGS'); ?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="ba-options-group">
                                    <div class="ba-group-element">
                                        <label>
                                            <?php echo Text::_('DESCRIPTION'); ?>
                                        </label>
                                        <textarea name="share_description" class="share-description page-settings-input-trigger"
                                            placeholder="<?php echo Text::_('DESCRIPTION'); ?>"
                                            ><?php echo $this->item->share_description; ?></textarea>
                                        <div class="select-data-tags input-action-icon" data-template="<?php echo $pageDataTags; ?>">
                                            <i class="zmdi zmdi-playlist-plus"></i>
                                            <span class="ba-tooltip ba-help"><?php echo Text::_('DATA_TAGS'); ?></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div id="sitemap-options" class="row-fluid tab-pane">
                                <div class="ba-options-group">
                                    <div class="ba-group-element">
                                        <label>
                                            <?php echo Text::_('OVERRIDE_DEFAULT_SETTINGS'); ?>
                                        </label>
                                        <label class="ba-checkbox">
                                            <input type="checkbox" name="sitemap_override" value="1"
                                                <?php echo $this->item->sitemap_override ? 'checked' : ''; ?>
                                                class="sitemap-override set-group-display">
                                            <span></span>
                                        </label>
                                    </div>
                                    <div class="ba-subgroup-element " style="--subgroup-childs:3;">
                                        <div class="ba-group-element">
                                            <label>
                                                <?php echo Text::_('INCLUDE_ITEM'); ?>
                                            </label>
                                            <label class="ba-checkbox">
                                                <input type="checkbox" name="sitemap_include" value="1"
                                                    <?php echo $this->item->sitemap_include ? 'checked' : ''; ?>
                                                    class="sitemap-include set-group-display">
                                                <span></span>
                                            </label>
                                            <label class="ba-help-icon">
                                                <i class="zmdi zmdi-help"></i>
                                                <span class="ba-tooltip ba-help">
                                                    <?php echo Text::_('INCLUDE_ITEM_TOOLTIP'); ?>
                                                </span>
                                            </label>
                                        </div>
                                        <div class="ba-group-element">
                                            <label>Changefreq</label>
                                            <div class="ba-custom-select">
                                                <input readonly="" onfocus="this.blur()" type="text">
                                                <input type="hidden" name="changefreq" class="changefreq"
                                                    value="<?php echo $this->item->changefreq; ?>">
                                                <i class="zmdi zmdi-caret-down"></i>
                                                <ul>
                                                    <li data-value="always"><?php echo Text::_('ALWAYS'); ?></li>
                                                    <li data-value="hourly"><?php echo Text::_('HOURLY'); ?></li>
                                                    <li data-value="daily"><?php echo Text::_('DAILY'); ?></li>
                                                    <li data-value="weekly"><?php echo Text::_('WEEKLY'); ?></li>
                                                    <li data-value="monthly"><?php echo Text::_('MONTHLY'); ?></li>
                                                    <li data-value="yearly"><?php echo Text::_('YEARLY'); ?></li>
                                                    <li data-value="never"><?php echo Text::_('NEVER'); ?></li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="ba-group-element">
                                            <label>Priority</label>
                                            <div class="ba-range-wrapper">
                                                <span class="ba-range-liner"></span>
                                                <input type="range" class="ba-range" min="0" max="1" step="0.1">
                                                <input type="number" value="<?php echo $this->item->priority; ?>"
                                                    data-callback="emptyCallback" name="priority" class="priority">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div id="schema-markup" class="row-fluid tab-pane">
                                <div class="ba-options-group schema-markup-wrapper">
                                    <div class="ba-group-element">
                                        <div class="schema-markup-label">
                                            <label>
                                                <?php echo Text::_('JSON_LD_SCHEMA_MARKUP'); ?>
                                            </label>
                                            <div class="select-data-tags input-action-icon" data-template="<?php echo $pageDataTags; ?>">
                                                <i class="zmdi zmdi-playlist-plus"></i>
                                                <span class="ba-tooltip ba-help"><?php echo Text::_('DATA_TAGS'); ?></span>
                                            </div>
                                        </div>
                                        <textarea name="schema_markup" class="schema-markup"
                                            ><?php echo $this->item->schema_markup; ?></textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php
} else if ($this->edit_type == 'system') {
    $this->item->settings = json_decode($this->item->page_options);
    $suffix = isset($this->item->settings->suffix) ? $this->item->settings->suffix : '';
?>
<div id="settings-dialog" class="ba-modal-lg modal hide" style="display:none">
    <div class="modal-header">
        <span class="ba-dialog-title"><?php echo Text::_('SETTINGS'); ?></span>
        <div class="modal-header-icon">
            <i class="zmdi zmdi-close"></i>
        </div>
    </div>
    <div class="modal-body">
        <div class="general-tabs">
            <ul class="nav nav-tabs uploader-nav">
                <li class="active">
                    <a href="#general-options" data-toggle="tab">
                        <i class="zmdi zmdi-settings"></i>
                        <?php echo Text::_('GENERAL'); ?>
                    </a>
                </li>
<?php
            if ($this->item->type != 'submission-form') {
?>
                <li>
                    <a href="#languages-options" data-toggle="tab">
                        <i class="zmdi zmdi-globe"></i>
                        <?php echo Text::_('LANGUAGES'); ?>
                    </a>
                </li>
<?php
            } else {
?>
                <li>
                    <a href="#publishing-options" data-toggle="tab">
                        <i class="zmdi zmdi-calendar-note"></i>
                        <?php echo Text::_('PUBLISHING'); ?>
                    </a>
                </li>
<?php
            }
?>
            </ul>
            <div class="tabs-underline"></div>
            <div class="tab-content">
                <div id="general-options" class="row-fluid tab-pane active">
                    <div class="ba-options-group">
                        <div class="ba-group-element ba-original-title">
                            <label>
                                <?php echo Text::_('JGLOBAL_TITLE'); ?><span class="required-fields-star">*</span>
                            </label>
                            <input type="hidden" name="ba_id" class="page-id" value="<?php echo $this->item->id; ?>">
                            <input type="text" class="page-title page-settings-input-trigger"
                                value="<?php echo htmlentities($this->item->title, ENT_COMPAT, 'utf-8'); ?>"
                                placeholder="<?php echo Text::_('JGLOBAL_TITLE'); ?>" name="page_title">
                            <div class="ba-alert-container" style="display: none;">
                                <i class="zmdi zmdi-alert-circle"></i>
                                <span></span>
                                <span class="ba-tooltip title-alert-tooltip">
                                    <?php echo Text::_('THIS_FIELD_REQUIRED'); ?>
                                </span>
                            </div>
                        </div>
                    </div>
<?php
                if ($this->item->type != '404' && $this->item->type != 'offline' && $this->item->type != 'preloader') {
?>
                    <div class="ba-options-group">
                        <div class="ba-group-element ba-original-alias">
                            <label>
                                <?php echo Text::_('JFIELD_ALIAS_LABEL'); ?>
                            </label>
                            <input type="text" class="page-alias page-settings-input-trigger"
                                value="<?php echo $this->item->alias; ?>"
                                placeholder="<?php echo Text::_('JFIELD_ALIAS_LABEL'); ?>" name="page_alias">
                        </div>
                    </div>
<?php
                }
                if ($this->item->type == '404') {
?>
                    <div class="ba-options-group error-page-settings">
                        <div class="ba-group-element">
                            <label>
                                <?php echo Text::_('ENABLE_HEADER_FOOTER'); ?>
                            </label>
                            <label class="ba-checkbox">
                                <input type="checkbox" class="page-enable-header"
                                    <?php echo $this->item->settings->enable_header ? 'checked' : ''; ?>>
                                <span></span>
                            </label>
                        </div>
                    </div>
<?php
                }
?>
                    <div class="ba-options-group">
                        <div class="ba-group-element">
                            <label>
                                <?php echo Text::_('CLASS_SUFFIX'); ?>
                            </label>
                            <input type="text" class="page-class-suffix"
                                value="<?php echo htmlentities($suffix, ENT_COMPAT, 'utf-8'); ?>"
                                data-value="<?php echo htmlentities($suffix, ENT_COMPAT, 'utf-8'); ?>"
                                placeholder="<?php echo Text::_('CLASS_SUFFIX'); ?>" name="class_suffix">
                            <label class="ba-help-icon">
                                <i class="zmdi zmdi-help"></i>
                                <span class="ba-tooltip ba-help">
                                    <?php echo Text::_('CLASS_SUFFIX_TOOLTIP'); ?>
                                </span>
                            </label>
                        </div>
                    </div>
                </div>
<?php
            if ($this->item->type != 'submission-form') {
?>
                <div id="languages-options" class="row-fluid tab-pane">
                    <div class="ba-options-group">
                        <div class="ba-group-element ba-original-language">
                            <label>
                                <?php echo Text::_('JFIELD_LANGUAGE_LABEL'); ?>
                            </label>
<?php
                            $style = $this->item->language == '*' ? '' : ' style="--flag-img: url('.$flags.$this->item->language.'.png)"';
?>
                            <div class="ba-custom-select language-select page-settings-custom-select-trigger"
                                <?php echo $style; ?>>
                                <input readonly onfocus="this.blur()" type="text"
                                    value="<?php echo $this->languages[$this->item->language]; ?>">
                                <input type="hidden" name="language" value="<?php echo $this->item->language; ?>">
                                <ul>
<?php
                                foreach ($this->languages as $key => $language) {
                                    $style = $key == '*' ? '' : ' style="--flag-img: url('.$flags.$key.'.png)"';
?>
                                    <li data-value="<?php echo $key; ?>"<?php echo $style; ?>>
                                        <?php echo $language; ?>
                                    </li>
<?php
                                }
?>
                                </ul>
                                <i class="zmdi zmdi-caret-down"></i>
                            </div>
                            <label class="ba-help-icon">
                                <i class="zmdi zmdi-help"></i>
                                <span class="ba-tooltip ba-help">
                                    <?php echo Text::_('LANGUAGE_DESC'); ?>
                                </span>
                            </label>
                        </div>
                    </div>
<?php
                if (Associations::isEnabled()) {
?>
                    <div class="ba-options-group language-associations-group">
<?php
                    foreach ($this->languages as $key => $language) {
                        if ($key == '*') {
                            continue;
                        }
?>
                        <div class="ba-group-element" data-lang="<?php echo $key; ?>">
                            <label>
                                <?php echo Text::_('ASSOCIATIONS'); ?>
                            </label>
                            <div class="association-wrapper">
                                <span class="ba-language-flag"
                                    style="background-image: url(<?php echo $flags.$key; ?>.png);">
                                    <span class="ba-tooltip ba-top ba-hide-element">
                                        <?php echo $language; ?>
                                    </span>
                                </span>
                                <input type="text" class="association-page" data-lang="<?php echo $key; ?>"
                                    placeholder="<?php echo Text::_('SELECT'); ?>" readonly="" onfocus="this.blur()">
                                <div class="reset disabled-reset reset-association">
                                    <i class="zmdi zmdi-close"></i>
                                </div>
                            </div>
                        </div>
<?php
                    }
?>
                    </div>
<?php
                }
?>
                </div>
<?php
            } else {
?>
                <div id="publishing-options" class="row-fluid tab-pane left-tabs-wrapper">
                    <div class="left-tabs">
                        <ul class="nav nav-tabs">
                            <li class="active">
                                <a href="#publishing-basic-options" data-toggle="tab">
                                    <i class="zmdi zmdi-settings"></i>
                                    <?php echo Text::_('BASIC'); ?>
                                </a>
                            </li>
                            <li>
                                <a href="#publishing-notifications-options" data-toggle="tab">
                                    <i class="zmdi zmdi-notifications"></i>
                                    <?php echo Text::_('NOTIFICATIONS'); ?>
                                </a>
                            </li>
                        </ul>
                        <div class="tab-content">
                            <div id="publishing-basic-options" class="row-fluid tab-pane active">
                                <div class="ba-options-group">
                                    <div class="ba-group-element">
                                        <label>
                                            <?php echo Text::_('SUBMISSINS_PREMODERATION'); ?>
                                        </label>
                                        <label class="ba-checkbox">
                                            <input type="checkbox" value="1" class="submission-form-moderation set-group-display"
                                                <?php echo $this->item->settings->premoderation ? 'checked' : ''; ?>>
                                            <span></span>
                                        </label>
                                        <label class="ba-help-icon">
                                            <i class="zmdi zmdi-help"></i>
                                            <span class="ba-tooltip ba-help ba-hide-element"><?php echo Text::_('SUBMISSINS_PREMODERATION_HELP'); ?></span>
                                        </label>
                                    </div>
                                </div>
                                <div class="ba-options-group">
                                    <div class="ba-group-element">
                                        <label>
                                            <?php echo Text::_('ASSIGN_USER_AS_AUTHOR'); ?>
                                        </label>
                                        <label class="ba-checkbox">
                                            <input type="checkbox" value="1" class="submission-form-author set-group-display"
                                                <?php echo $this->item->settings->author ? 'checked' : ''; ?>>
                                            <span></span>
                                        </label>
                                        <label class="ba-help-icon">
                                            <i class="zmdi zmdi-help"></i>
                                            <span class="ba-tooltip ba-help ba-hide-element"><?php echo Text::_('ASSIGN_USER_AS_AUTHOR_TOOLTIP'); ?></span>
                                        </label>
                                    </div>
                                </div>
                                <div class="ba-options-group">
                                    <div class="ba-group-element">
                                        <label>
                                            <?php echo Text::_('JFIELD_ACCESS_LABEL'); ?>
                                        </label>
                                        <div class="ba-custom-select submission-form-access">
                                            <input readonly type="text" value="<?php echo $this->access[$this->item->settings->access]; ?>">
                                            <input type="hidden" value="<?php echo $this->item->settings->access; ?>">
                                            <i class="zmdi zmdi-caret-down"></i>
                                            <ul>
<?php
                                                foreach ($this->access as $key => $access) {
                                                    echo '<li data-value="'.$key.'">'.$access.'</li>';
                                                }
?>
                                            </ul>
                                        </div>
                                        <label class="ba-help-icon">
                                            <i class="zmdi zmdi-help"></i>
                                            <span class="ba-tooltip ba-help ba-hide-element">
                                                <?php echo Text::_('JFIELD_ACCESS_DESC'); ?>
                                            </span>
                                        </label>
                                    </div>
                                </div>
                                <div class="ba-options-group">
                                <div class="ba-group-element ba-original-language">
                                    <label>
                                        <?php echo Text::_('JFIELD_LANGUAGE_LABEL'); ?>
                                    </label>
<?php
                                    $style = $this->item->language == '*' ? '' : ' style="--flag-img: url('.$flags.$this->item->language.'.png)"';
?>
                                    <div class="ba-custom-select language-select page-settings-custom-select-trigger"
                                        <?php echo $style; ?>>
                                        <input readonly onfocus="this.blur()" type="text"
                                            value="<?php echo $this->languages[$this->item->language]; ?>">
                                        <input type="hidden" name="language" value="<?php echo $this->item->language; ?>">
                                        <ul>
<?php
                                        foreach ($this->languages as $key => $language) {
                                            $style = $key == '*' ? '' : ' style="--flag-img: url('.$flags.$key.'.png)"';
?>
                                            <li data-value="<?php echo $key; ?>"<?php echo $style; ?>>
                                                <?php echo $language; ?>
                                            </li>
<?php
                                        }
?>
                                        </ul>
                                        <i class="zmdi zmdi-caret-down"></i>
                                    </div>
                                    <label class="ba-help-icon">
                                        <i class="zmdi zmdi-help"></i>
                                        <span class="ba-tooltip ba-help">
                                            <?php echo Text::_('LANGUAGE_DESC'); ?>
                                        </span>
                                    </label>
                                </div>
                            </div>
<?php
                        if (Associations::isEnabled()) {
?>
                            <div class="ba-options-group language-associations-group">
<?php
                            foreach ($this->languages as $key => $language) {
                                if ($key == '*') {
                                    continue;
                                }
?>
                                <div class="ba-group-element" data-lang="<?php echo $key; ?>">
                                    <label>
                                        <?php echo Text::_('ASSOCIATIONS'); ?>
                                    </label>
                                    <div class="association-wrapper">
                                        <span class="ba-language-flag"
                                            style="background-image: url(<?php echo $flags.$key; ?>.png);">
                                            <span class="ba-tooltip ba-top ba-hide-element">
                                                <?php echo $language; ?>
                                            </span>
                                        </span>
                                        <input type="text" class="association-page" data-lang="<?php echo $key; ?>"
                                            placeholder="<?php echo Text::_('SELECT'); ?>" readonly="" onfocus="this.blur()">
                                        <div class="reset disabled-reset reset-association">
                                            <i class="zmdi zmdi-close"></i>
                                        </div>
                                    </div>
                                </div>
<?php
                            }
?>
                            </div>
<?php
                        }
?>
                            </div>
                            <div id="publishing-notifications-options" class="row-fluid tab-pane">
                                <div class="ba-options-group">
                                    <div class="ba-group-element">
                                        <label>
                                            <?php echo Text::_('EMAIL_NOTIFICATIONS'); ?>
                                        </label>
                                        <label class="ba-checkbox">
                                            <input type="checkbox" value="1" class="submission-form-notifications set-group-display"
                                                <?php echo $this->item->settings->emails ? 'checked' : ''; ?>>
                                            <span></span>
                                        </label>
                                    </div>
                                    <div class="ba-subgroup-element " style="--subgroup-childs:2;">
                                        <div class="ba-group-element">
                                            <label>
                                                <?php echo Text::_('NEW_SUBMISSION'); ?>
                                            </label>
                                            <label class="ba-checkbox">
                                                <input type="checkbox" value="1" class="submission-form-submited set-group-display"
                                                    <?php echo $this->item->settings->submited_email ? 'checked' : ''; ?>>
                                                <span></span>
                                            </label>
                                            <label class="ba-help-icon">
                                                <i class="zmdi zmdi-help"></i>
                                                <span class="ba-tooltip ba-help ba-hide-element"><?php echo Text::_('NEW_SUBMISSION_HELP'); ?></span>
                                            </label>
                                        </div>
                                        <div class="ba-group-element">
                                            <label>
                                                <?php echo Text::_('SUBMISSION_PUBLISHING'); ?>
                                            </label>
                                            <label class="ba-checkbox">
                                                <input type="checkbox" value="1" class="submission-form-publishing set-group-display"
                                                    <?php echo $this->item->settings->published_email ? 'checked' : ''; ?>>
                                                <span></span>
                                            </label>
                                            <label class="ba-help-icon">
                                                <i class="zmdi zmdi-help"></i>
                                                <span class="ba-tooltip ba-help ba-hide-element"><?php echo Text::_('SUBMISSION_PUBLISHING_HELP'); ?></span>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
<?php
            }
?>
            </div>
        </div>
    </div>
</div>
<?php
}
?>
<div id="add-to-cart-products-dialog"
    class="modal hide ba-modal-product-picker picker-modal-arrow ba-modal-list-picker"
    style="display: none;">
    <div class="modal-body modal-list-type-wrapper">
        <div class="ba-settings-item ba-settings-input-type">
            <input type="text" placeholder="<?php echo Text::_('SEARCH'); ?>" class="picker-search">
            <i class="zmdi zmdi-search"></i>
        </div>
        <div class="ba-settings-item ba-settings-list-type">
            <ul></ul>
        </div>
    </div>
</div>
<div id="data-tags-dialog" class="modal hide ba-modal-picker picker-modal-arrow ba-modal-list-picker">
    <div class="modal-body">
        
    </div>
</div>
<div id="post-tags-dialog" class="modal hide ba-modal-picker picker-modal-arrow ba-modal-list-picker">
    <div class="modal-body">
        <div class="data-tags-searchbar">
            <div class="ba-settings-group">
                <div class="ba-settings-item ba-settings-select-type">
                    <select class="select-data-tags-type">
<?php
                    foreach ($this->tagsFolders->folders as $folder) {
?>
                        <option value="<?php echo $folder->id; ?>"><?php echo $folder->title; ?></option>
<?php
                    }
?>
                    </select>
                </div>
                <div class="ba-settings-item ba-settings-input-type search-tags-wrapper">
                    <input type="text" class="search-post-tags" placeholder="<?php echo Text::_('SEARCH'); ?>">
                    <i class="zmdi zmdi-search"></i>
                </div>
            </div>
        </div>
        <div class="post-tags-wrapper">
<?php
        foreach ($this->tagsFolders->tags as $tag) {
?>
            <div class="ba-settings-item ba-settings-input-type" data-folder="<?php echo $tag->folder_id; ?>"
                data-id="<?php echo $tag->id; ?>">
                <i class="zmdi zmdi-label"></i>
                <span class="ba-settings-item-title"><?php echo $tag->title; ?></span>
            </div>
<?php
        }
?>
        </div>
    </div>
</div>
<div id="seo-default-settings-modal" class="ba-modal-md modal hide" style="display:none">
    <div class="modal-body">
        <div class="order-status-tabs-wrapper">
            <ul class="nav nav-tabs uploader-nav">
                <li class="active">
                    <a href="#seo-default-settings-general" data-toggle="tab">
                        <i class="zmdi zmdi-settings"></i>
                        <span class="ba-tooltip ba-top ba-hide-element"><?php echo Text::_('GENERAL'); ?></span>
                    </a>
                </li>
                <li>
                    <a href="#seo-default-settings-sharing" data-toggle="tab">
                        <i class="zmdi zmdi-share"></i>
                        <span class="ba-tooltip ba-top ba-hide-element"><?php echo Text::_('SHARING'); ?></span>
                    </a>
                </li>
<?php
            if (isset(GridboxHelper::$systemApps->sitemap)) {
?>
                <li>
                    <a href="#seo-default-settings-sitemap" data-toggle="tab">
                        <i class="zmdi zmdi-device-hub"></i>
                        <span class="ba-tooltip ba-top ba-hide-element"><?php echo Text::_('SITEMAP'); ?></span>
                    </a>
                </li>
<?php
            }
?>
                <li>
                    <a href="#seo-default-settings-schema-markup" data-toggle="tab">
                        <i class="zmdi zmdi-code"></i>
                        <span class="ba-tooltip ba-top ba-hide-element"><?php echo Text::_('SCHEMA_MARKUP'); ?></span>
                    </a>
                </li>
            </ul>
            <div class="tab-content">
                <div class="tab-pane active" id="seo-default-settings-general">
                    <div class="ba-options-group">
                        <div class="ba-group-element">
                            <div class="schema-markup-label">
                                <label>
                                    <?php echo Text::_('BROWSER_PAGE_TITLE'); ?>
                                </label>
                                <div class="select-data-tags input-action-icon" data-template="<?php echo $pageDataTags; ?>">
                                    <i class="zmdi zmdi-playlist-plus"></i>
                                    <span class="ba-tooltip ba-top ba-hide-element"><?php echo Text::_('DATA_TAGS'); ?></span>
                                </div>
                            </div>
                            <input type="hidden" data-key="id">
                            <input type="hidden" data-key="item_id">
                            <input type="hidden" data-key="item_type">
                            <input type="text" data-key="meta_title" placeholder="<?php echo Text::_('BROWSER_PAGE_TITLE'); ?>">
                        </div>
                    </div>
                    <div class="ba-options-group">
                        <div class="ba-group-element">
                            <div class="schema-markup-label">
                                <label>
                                    <?php echo Text::_('JFIELD_META_DESCRIPTION_LABEL'); ?>
                                </label>
                                <div class="select-data-tags input-action-icon" data-template="<?php echo $pageDataTags; ?>">
                                    <i class="zmdi zmdi-playlist-plus"></i>
                                    <span class="ba-tooltip ba-top ba-hide-element"><?php echo Text::_('DATA_TAGS'); ?></span>
                                </div>
                            </div>
                            <textarea data-key="meta_description" placeholder="<?php echo Text::_('JFIELD_META_DESCRIPTION_LABEL'); ?>"></textarea>
                        </div>
                    </div>
                </div>
                <div class="tab-pane" id="seo-default-settings-sharing">
                    <div class="ba-options-group">
                        <div class="ba-group-element">
                            <div class="schema-markup-label">
                                <label>
                                    <?php echo Text::_('IMAGE'); ?>
                                </label>
                                <div class="select-data-tags input-action-icon" data-template="<?php echo $pageDataTags; ?>">
                                    <i class="zmdi zmdi-playlist-plus"></i>
                                    <span class="ba-tooltip ba-top ba-hide-element"><?php echo Text::_('DATA_TAGS'); ?></span>
                                </div>
                            </div>
                            <input type="text" data-key="share_image" placeholder="<?php echo Text::_('IMAGE'); ?>">
                        </div>
                    </div>
                    <div class="ba-options-group">
                        <div class="ba-group-element">
                            <div class="schema-markup-label">
                                <label>
                                    <?php echo Text::_('JGLOBAL_TITLE'); ?>
                                </label>
                                <div class="select-data-tags input-action-icon" data-template="<?php echo $pageDataTags; ?>">
                                    <i class="zmdi zmdi-playlist-plus"></i>
                                    <span class="ba-tooltip ba-top ba-hide-element"><?php echo Text::_('DATA_TAGS'); ?></span>
                                </div>
                            </div>
                            <input type="text" data-key="share_title" placeholder="<?php echo Text::_('JGLOBAL_TITLE'); ?>">
                        </div>
                    </div>
                    <div class="ba-options-group">
                        <div class="ba-group-element">
                            <div class="schema-markup-label">
                                <label>
                                    <?php echo Text::_('DESCRIPTION'); ?>
                                </label>
                                <div class="select-data-tags input-action-icon" data-template="<?php echo $pageDataTags; ?>">
                                    <i class="zmdi zmdi-playlist-plus"></i>
                                    <span class="ba-tooltip ba-top ba-hide-element"><?php echo Text::_('DATA_TAGS'); ?></span>
                                </div>
                            </div>
                            <textarea data-key="share_description" placeholder="<?php echo Text::_('DESCRIPTION'); ?>"></textarea>
                        </div>
                    </div>
                </div>
                <div class="tab-pane" id="seo-default-settings-sitemap">
                    <div class="ba-options-group">
                        <div class="ba-group-element">
                            <div class="schema-markup-label">
                                <label>
                                    <?php echo Text::_('INCLUDE_ITEM'); ?>
                                </label>
                            </div>
                            <div class="ba-custom-select">
                                <input readonly="" onfocus="this.blur()" type="text">
                                <input type="hidden" data-key="sitemap_include">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="1"><?php echo Text::_('INCLUDE'); ?></li>
                                    <li data-value="0"><?php echo Text::_('EXCLUDE'); ?></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="ba-options-group">
                        <div class="ba-group-element">
                            <div class="schema-markup-label">
                                <label>
                                    Changefreq
                                </label>
                            </div>
                            <div class="ba-custom-select ba-fixed-custom-select">
                                <input readonly="" onfocus="this.blur()" type="text">
                                <input type="hidden" data-key="changefreq">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="always"><?php echo Text::_('ALWAYS'); ?></li>
                                    <li data-value="hourly"><?php echo Text::_('HOURLY'); ?></li>
                                    <li data-value="daily"><?php echo Text::_('DAILY'); ?></li>
                                    <li data-value="weekly"><?php echo Text::_('WEEKLY'); ?></li>
                                    <li data-value="monthly"><?php echo Text::_('MONTHLY'); ?></li>
                                    <li data-value="yearly"><?php echo Text::_('YEARLY'); ?></li>
                                    <li data-value="never"><?php echo Text::_('NEVER'); ?></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="ba-options-group">
                        <div class="ba-group-element">
                            <div class="schema-markup-label">
                                <label>
                                    Priority
                                </label>
                            </div>
                            <div class="ba-custom-select ba-fixed-custom-select">
                                <input readonly="" onfocus="this.blur()" type="text">
                                <input type="hidden" data-key="priority">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="0">0</li>
                                    <li data-value="0.1">0.1</li>
                                    <li data-value="0.2">0.2</li>
                                    <li data-value="0.3">0.3</li>
                                    <li data-value="0.4">0.4</li>
                                    <li data-value="0.5">0.5</li>
                                    <li data-value="0.6">0.6</li>
                                    <li data-value="0.7">0.7</li>
                                    <li data-value="0.8">0.8</li>
                                    <li data-value="0.9">0.9</li>
                                    <li data-value="1">1</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="tab-pane" id="seo-default-settings-schema-markup">
                    <div class="ba-options-group schema-markup-wrapper">
                        <div class="ba-group-element">
                            <div class="schema-markup-label">
                                <label>
                                    <?php echo Text::_('JSON_LD_SCHEMA_MARKUP'); ?>
                                </label>
                                <div class="select-data-tags input-action-icon" data-template="<?php echo $pageDataTags; ?>">
                                    <i class="zmdi zmdi-playlist-plus"></i>
                                    <span class="ba-tooltip ba-top ba-hide-element"><?php echo Text::_('DATA_TAGS'); ?></span>
                                </div>
                            </div>
                            <textarea data-key="schema_markup"></textarea>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="modal-footer">
        <a href="#" class="ba-btn" data-dismiss="modal">
            <?php echo Text::_('CANCEL') ?>
        </a>
<?php
    if ($user->authorise('core.edit', 'com_gridbox')) {
?>
        <a href="#" class="ba-btn-primary apply-seo-default-settings active-button">
            <?php echo Text::_('APPLY') ?>
        </a>
<?php
    }
?>
    </div>
</div>