<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

use Joomla\CMS\Language\Text;

defined('_JEXEC') or die;

if (empty($this->edit_type)) {
?>
<template class="post-data-tags-template">
    <div class="data-tags-searchbar">
        <div class="ba-settings-group">
            <div class="ba-settings-item ba-settings-select-type">
                <select class="select-data-tags-type">
                    <option value=""><?php echo Text::_('All'); ?></option>
                    <option value="general"><?php echo Text::_('GENERAL'); ?></option>
                    <option value="page"><?php echo Text::_('PAGE'); ?></option>
<?php
                if ($this->item->app_type == 'products') {
?>
                    <option value="product"><?php echo Text::_('PRODUCT'); ?></option>
                    <option value="store"><?php echo Text::_('STORE'); ?></option>
<?php
                }
                if ($this->item->app_type != 'blog') {
?>
                    <option value="fields"><?php echo Text::_('FIELDS'); ?></option>
<?php
                }
?>
                </select>
            </div>
        </div>
    </div>
    <div class="">
        <div class="ba-settings-group general-data-tags">
            <div class="ba-settings-item ba-settings-input-type">
                <span class="ba-settings-item-title"><?php echo Text::_('SITE_NAME'); ?></span>
                <input type="text" readonly onfocus="this.blur()" class="select-input" value="[Site Name]">
            </div>
        </div>
        <div class="ba-settings-group page-data-tags">
            <div class="ba-settings-item ba-settings-input-type">
                <span class="ba-settings-item-title"><?php echo Text::_('PAGE_TITLE'); ?></span>
                <input type="text" readonly onfocus="this.blur()" class="select-input" value="[Page Title]">
            </div>
            <div class="ba-settings-item ba-settings-input-type">
                <span class="ba-settings-item-title"><?php echo Text::_('PAGE_IMAGE'); ?></span>
                <input type="text" readonly onfocus="this.blur()" class="select-input" value="[Page Image]">
            </div>
            <div class="ba-settings-item ba-settings-input-type">
                <span class="ba-settings-item-title"><?php echo Text::_('PAGE_URL'); ?></span>
                <input type="text" readonly onfocus="this.blur()" class="select-input" value="[Page URL]">
            </div>
            <div class="ba-settings-item ba-settings-input-type">
                <span class="ba-settings-item-title"><?php echo Text::_('CATEGORY_TITLE'); ?></span>
                <input type="text" readonly onfocus="this.blur()" class="select-input" value="[Category Title]">
            </div>
            <div class="ba-settings-item ba-settings-input-type">
                <span class="ba-settings-item-title"><?php echo Text::_('PAGE_TAGS'); ?></span>
                <input type="text" readonly onfocus="this.blur()" class="select-input" value="[Page Tags]">
            </div>
            <div class="ba-settings-item ba-settings-input-type">
                <span class="ba-settings-item-title"><?php echo Text::_('AUTHOR'); ?></span>
                <input type="text" readonly onfocus="this.blur()" class="select-input" value="[Author]">
            </div>
            <div class="ba-settings-item ba-settings-input-type">
                <span class="ba-settings-item-title"><?php echo Text::_('START_PUBLISHING'); ?></span>
                <input type="text" readonly onfocus="this.blur()" class="select-input" value="[Start Publishing]">
            </div>
            <div class="ba-settings-item ba-settings-input-type">
                <span class="ba-settings-item-title"><?php echo Text::_('DATE_MODIFIED'); ?></span>
                <input type="text" readonly onfocus="this.blur()" class="select-input" value="[Date Modified]">
            </div>
            <div class="ba-settings-item ba-settings-input-type">
                <span class="ba-settings-item-title"><?php echo Text::_('INTRO_TEXT'); ?></span>
                <input type="text" readonly onfocus="this.blur()" class="select-input" value="[Intro Text]">
            </div>
        </div>
<?php
    if (empty($this->edit_type) && $this->item->app_type == 'products') {
?>
        <div class="ba-settings-group product-data-tags">
            <div class="ba-settings-item ba-settings-input-type">
                <span class="ba-settings-item-title"><?php echo Text::_('PRODUCT_SKU'); ?></span>
                <input type="text" readonly onfocus="this.blur()" class="select-input" value="[Product SKU]">
            </div>
            <div class="ba-settings-item ba-settings-input-type">
                <span class="ba-settings-item-title"><?php echo Text::_('PRODUCT_PRICE'); ?></span>
                <input type="text" readonly onfocus="this.blur()" class="select-input" value="[Product Price]">
            </div>
            <div class="ba-settings-item ba-settings-input-type">
                <span class="ba-settings-item-title"><?php echo Text::_('PRODUCT_SALE_PRICE'); ?></span>
                <input type="text" readonly onfocus="this.blur()" class="select-input" value="[Product Sale Price]">
            </div>
            <div class="ba-settings-item ba-settings-input-type">
                <span class="ba-settings-item-title"><?php echo Text::_('PRODUCT_CURRENCY'); ?></span>
                <input type="text" readonly onfocus="this.blur()" class="select-input" value="[Product Currency]">
            </div>
            <div class="ba-settings-item ba-settings-input-type">
                <span class="ba-settings-item-title"><?php echo Text::_('PRODUCT_IN_STOCK'); ?></span>
                <input type="text" readonly onfocus="this.blur()" class="select-input" value="[Product In Stock]">
            </div>
        </div>
        <div class="ba-settings-group store-data-tags">
            <div class="ba-settings-item ba-settings-input-type">
                <span class="ba-settings-item-title"><?php echo Text::_('STORE_NAME'); ?></span>
                <input type="text" readonly onfocus="this.blur()" class="select-input" value="[Store Name]">
            </div>
            <div class="ba-settings-item ba-settings-input-type">
                <span class="ba-settings-item-title"><?php echo Text::_('STORE_LEGAL_NAME'); ?></span>
                <input type="text" readonly onfocus="this.blur()" class="select-input" value="[Store Legal Business Name]">
            </div>
            <div class="ba-settings-item ba-settings-input-type">
                <span class="ba-settings-item-title"><?php echo Text::_('STORE_PHONE'); ?></span>
                <input type="text" readonly onfocus="this.blur()" class="select-input" value="[Store Phone]">
            </div>
            <div class="ba-settings-item ba-settings-input-type">
                <span class="ba-settings-item-title"><?php echo Text::_('STORE_EMAIL'); ?></span>
                <input type="text" readonly onfocus="this.blur()" class="select-input" value="[Store Email]">
            </div>
            <div class="ba-settings-item ba-settings-input-type">
                <span class="ba-settings-item-title"><?php echo Text::_('STORE_ADDRESS'); ?></span>
                <input type="text" readonly onfocus="this.blur()" class="select-input" value="[Store Address]">
            </div>
        </div>
<?php
    }
    if (empty($this->edit_type) && $this->item->app_type != 'blog') {
?>
        <div class="ba-settings-group fields-data-tags">
<?php
        foreach ($this->pageFields as $field) {
?>
            <div class="ba-settings-item ba-settings-input-type">
                <span class="ba-settings-item-title"><?php echo Text::_('FIELD').' '.$field->title; ?></span>
                <input type="text" readonly onfocus="this.blur()" class="select-input" value="[Field <?php echo $field->id; ?>]">
            </div>
<?php
        }
?>
        </div>
<?php
    }
?>
    </div>
</template>
<template class="page-data-tags-template">
    <div class="data-tags-searchbar">
        <div class="ba-settings-group">
            <div class="ba-settings-item ba-settings-select-type">
                <select class="select-data-tags-type">
                    <option value=""><?php echo Text::_('All'); ?></option>
                    <option value="general"><?php echo Text::_('GENERAL'); ?></option>
                    <option value="page"><?php echo Text::_('PAGE'); ?></option>
                </select>
            </div>
        </div>
    </div>
    <div class="">
        <div class="ba-settings-group general-data-tags">
            <div class="ba-settings-item ba-settings-input-type">
                <span class="ba-settings-item-title"><?php echo Text::_('SITE_NAME'); ?></span>
                <input type="text" readonly onfocus="this.blur()" class="select-input" value="[Site Name]">
            </div>
        </div>
        <div class="ba-settings-group page-data-tags">
            <div class="ba-settings-item ba-settings-input-type">
                <span class="ba-settings-item-title"><?php echo Text::_('PAGE_TITLE'); ?></span>
                <input type="text" readonly onfocus="this.blur()" class="select-input" value="[Page Title]">
            </div>
            <div class="ba-settings-item ba-settings-input-type">
                <span class="ba-settings-item-title"><?php echo Text::_('PAGE_IMAGE'); ?></span>
                <input type="text" readonly onfocus="this.blur()" class="select-input" value="[Page Image]">
            </div>
            <div class="ba-settings-item ba-settings-input-type">
                <span class="ba-settings-item-title"><?php echo Text::_('PAGE_URL'); ?></span>
                <input type="text" readonly onfocus="this.blur()" class="select-input" value="[Page URL]">
            </div>
            <div class="ba-settings-item ba-settings-input-type">
                <span class="ba-settings-item-title"><?php echo Text::_('START_PUBLISHING'); ?></span>
                <input type="text" readonly onfocus="this.blur()" class="select-input" value="[Start Publishing]">
            </div>
            <div class="ba-settings-item ba-settings-input-type">
                <span class="ba-settings-item-title"><?php echo Text::_('DATE_MODIFIED'); ?></span>
                <input type="text" readonly onfocus="this.blur()" class="select-input" value="[Date Modified]">
            </div>
        </div>
    </div>
</template>
<?php
}
?>
<template class="positioning-width-template">
    <div class="ba-settings-item">
        <span>
            <?php echo Text::_('WIDTH'); ?>
        </span>
        <div class="ba-range-wrapper">
            <span class="ba-range-liner"></span>
            <input type="range" class="ba-range" min="0" max="2000">
            <input type="text" data-option="width" data-group="positioning" data-callback="sectionRules">
        </div>
    </div>
</template>
<template class="input-size-wrapper-template">
    <div class="input-size-wrapper">
        <div class="input-size-triggers">
            <i class="zmdi zmdi-caret-up" data-action="+"></i>
            <i class="zmdi zmdi-caret-down" data-action="-"></i>
        </div>
    </div>
</template>
<template class="page-multicategory-list">
    <ul class="page-multicategory-list">
<?php
    foreach ($this->categoryList as $key => $category) {
        $content = '';
        for ($i = 0; $i < $category->level; $i++) {
            $content .= '- ';
        }
        if ($category->level != 0) {
            $content .= '-';
        }
?>
        <li data-value="<?php echo $category->id; ?>" style="--content: '<?php echo $content; ?>';">
            <label class="ba-hide-checkbox">
                <input type="checkbox" value="<?php $category->id; ?>">
                <i class="zmdi zmdi-circle-o ba-icon-md"></i>
                <i class="zmdi zmdi-check ba-icon-md"></i>
            </label>
            <span class="multicategory-title"><?php echo $category->title; ?></span>
            <span class="set-default-page-category">
                <span class="ba-tooltip ba-left ba-hide-element"><?php echo Text::_('DEFAULT'); ?></span>
                <i class="zmdi zmdi-star"></i>
            </span>
        </li>
<?php
    }
?>
    </ul>
</template>