<?php
/**
 * @package   Gridbox
 * @author    Balbooa http://www.balbooa.com/
 * @copyright Copyright @ Balbooa
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

use Joomla\CMS\Language\Text;
?>
<div id="theme-settings-dialog" class="ba-modal-cp draggable-modal-cp modal hide">
    <div class="modal-header">
        <span class="ba-dialog-title"><?php echo Text::_('THEME'); ?></span>
        <div class="modal-header-icon">
            <div class="ba-custom-select select-modal-cp-position">
                <i class="zmdi zmdi-more-vert"></i>
                <input type="hidden">
                <ul>
                    <li data-value=""><?php echo Text::_('SEPARATE_WINDOW') ?></li>
                    <li data-value="right"><?php echo Text::_('PANEL_TO_RIGHT') ?></li>
                </ul>
            </div>
            <i class="zmdi zmdi-close close-cp-modal"></i>
        </div>
    </div>
    <div class="modal-body">
        <div class="general-tabs">
            <ul class="nav nav-tabs">
                <li class="active">
                    <a href="#theme-general-options" data-toggle="tab">
                        <i class="zmdi zmdi-settings"></i>
                        <span><?php echo Text::_('GENERAL'); ?></span>
                    </a>
                </li>
                <li class="">
                    <a href="#theme-colors-options" data-toggle="tab">
                        <i class="zmdi zmdi-palette"></i>
                        <span><?php echo Text::_('COLORS'); ?></span>
                    </a>
                </li>
                <li class="">
                    <a href="#theme-background-options" data-toggle="tab">
                        <i class="zmdi zmdi-wallpaper"></i>
                        <span><?php echo Text::_('BACKGROUND'); ?></span>
                    </a>
                </li>
            </ul>
            <div class="tabs-underline"></div>
            <div class="tab-content">
                <div id="theme-general-options" class="row-fluid tab-pane active">
                    <div class="ba-settings-group">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-format-size"></i>
                            <span><?php echo Text::_('TYPOGRAPHY'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span><?php echo Text::_('FONT_SMOOTHING'); ?></span>
                            <label class="ba-checkbox">
                                <input type="checkbox" class="set-value-css" data-option="font-smoothing">
                                <span></span>
                            </label>
                        </div>
                        <div class="ba-settings-item ba-typography-select-wrapper">
                            <span>
                                <?php echo Text::_('TYPOGRAPHY'); ?>
                            </span>
                            <div class="ba-custom-select typography-select">
                                <input readonly onfocus="this.blur()" value="<?php echo Text::_('BASE_FONT'); ?>" type="text">
                                <input type="hidden" value="body">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="body"><?php echo Text::_('BASE_FONT'); ?></li>
                                    <li data-value="h1">H1</li>
                                    <li data-value="h2">H2</li>
                                    <li data-value="h3">H3</li>
                                    <li data-value="h4">H4</li>
                                    <li data-value="h5">H5</li>
                                    <li data-value="h6">H6</li>
                                    <li data-value="p">Paragraph</li>
                                    <li data-value="links"><?php echo Text::_('LINKS') ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="theme-typography-options">
                            <div class="typography-options">
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('FONT_FAMILY'); ?>
                                    </span>
                                    <input type="text" readonly onfocus="this.blur()" data-option="font-family"
                                           data-group="h1" data-callback="themeRules">
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('FONT_WEIGHT'); ?>
                                    </span>
                                    <input readonly onfocus="this.blur()" type="text" data-option="font-weight"
                                           data-group="h1" data-callback="themeRules">
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('COLOR'); ?>
                                    </span>
                                    <input type="text" data-type="color" class="minicolors-input"
                                           data-option="color" data-group="h1">
                                    <span class="minicolors-opacity-wrapper">
                                        <input type="number" class="minicolors-opacity" data-callback="themeRules"
                                               min="0" max="1" step="0.01">
                                        <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                                    </span>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('SIZE'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner"></span>
                                        <input type="range" class="ba-range" min="0" max="320">
                                        <input type="text" data-option="font-size" data-group="h1" data-callback="themeRules">
                                    </div>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('LETTER_SPACING'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner letter-spacing"></span>
                                        <input type="range" class="ba-range" min="-10" max="10">
                                        <input type="text" data-option="letter-spacing" data-group="h1" data-callback="themeRules">
                                    </div>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('LINE_HEIGHT'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner"></span>
                                        <input type="range" class="ba-range" min="0" max="640">
                                        <input type="text" data-option="line-height" data-group="h1" data-callback="themeRules">
                                    </div>
                                </div>
                                <div class="ba-settings-toolbar">
                                    <label data-option="text-decoration" data-value="underline" data-group="h1" data-callback="themeRules">
                                        <i class="zmdi zmdi-format-underlined"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('UNDERLINE'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-transform" data-value="uppercase" data-group="h1" data-callback="themeRules">
                                        <i class="zmdi zmdi-format-size"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('UPPERCASE'); ?>
                                        </span>
                                    </label>
                                    <label data-option="font-style" data-value="italic" data-group="h1" data-callback="themeRules">
                                        <i class="zmdi zmdi-format-italic"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('ITALIC'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-align" data-value="left" data-group="h1" data-callback="themeRules">
                                        <i class="zmdi zmdi-format-align-left"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('LEFT'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-align" data-value="center" data-group="h1" data-callback="themeRules">
                                        <i class="zmdi zmdi-format-align-center"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('CENTER'); ?>
                                        </span>
                                    </label>
                                    <label data-option="text-align" data-value="right" data-group="h1" data-callback="themeRules">
                                        <i class="zmdi zmdi-format-align-right"></i>
                                        <span class="ba-tooltip">
                                            <?php echo Text::_('RIGHT'); ?>
                                        </span>
                                    </label>
                                </div>
                                <div class="ba-settings-item links" style="display: none;">
                                    <span>
                                        <?php echo Text::_('COLOR'); ?>
                                    </span>
                                    <input type="text" data-type="color" class="minicolors-input"
                                           data-option="color" data-group="links">
                                    <span class="minicolors-opacity-wrapper">
                                        <input type="number" class="minicolors-opacity" data-callback="themeRules"
                                               min="0" max="1" step="0.01">
                                        <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                                    </span>
                                </div>
                                <div class="ba-settings-item links" style="display: none;">
                                    <span>
                                        <?php echo Text::_('HOVER'); ?>
                                    </span>
                                    <input type="text" data-type="color" class="minicolors-input"
                                           data-option="hover-color" data-group="links">
                                    <span class="minicolors-opacity-wrapper">
                                        <input type="number" class="minicolors-opacity" data-callback="themeRules"
                                               min="0" max="1" step="0.01">
                                        <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group">
                        <div class="settings-group-title">
                            <span><?php echo Text::_('PADDING'); ?></span>
                        </div>
                        <div class="ba-settings-toolbar">
                            <div>
                                <span>
                                    <?php echo Text::_('TOP'); ?>
                                </span>
                                <input type="text" data-group="padding" data-option="top" data-callback="themeRules">
                            </div>
                            <div>
                                <span>
                                    <?php echo Text::_('RIGHT'); ?>
                                </span>
                                <input type="text" data-group="padding" data-option="right" data-callback="themeRules">
                            </div>
                            <div>
                                <span>
                                    <?php echo Text::_('BOTTOM'); ?>
                                </span>
                                <input type="text" data-group="padding" data-option="bottom" data-callback="themeRules">
                            </div>
                            <div>
                                <span>
                                    <?php echo Text::_('LEFT'); ?>
                                </span>
                                <input type="text" data-group="padding" data-option="left" data-callback="themeRules">
                            </div>
                            <div>
                                <i class="zmdi zmdi-close" data-type="reset" data-option="padding" data-action="themeRules"></i>
                                <span class="ba-tooltip">
                                    <?php echo Text::_('RESET'); ?>
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group item-animation-settings">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-settings"></i>
                            <span><?php echo Text::_('ADVANCED'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('EDIT'); ?>
                            </span>
                            <div class="ba-custom-select section-access-select visible-select-top">
                                <input readonly onfocus="this.blur()" type="text" value="">
                                <input type="hidden" value="">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <?php
                                    foreach ($this->access as $key => $access) {
                                        echo '<li data-value="'.$key.'">'.$access.'</li>';
                                    }
                                    ?>
                                </ul>
                            </div>
                            <label class="ba-help-icon">
                                <i class="zmdi zmdi-help"></i>
                                <span class="ba-tooltip ba-help">
                                    <?php echo Text::_('ACCESS_EDIT_TOOLTIP'); ?>
                                </span>
                            </label>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('CLASS_SUFFIX'); ?>
                            </span>
                            <input type="text" class="class-suffix" placeholder="<?php echo Text::_('CLASS_SUFFIX'); ?>">
                            <label class="ba-help-icon">
                                <i class="zmdi zmdi-help"></i>
                                <span class="ba-tooltip ba-help">
                                    <?php echo Text::_('CLASS_SUFFIX_TOOLTIP'); ?>
                                </span>
                            </label>
                        </div>
                    </div>
                </div>
                <div id="theme-colors-options" class="row-fluid tab-pane">
                    <div class="ba-settings-group colors-wrapper">
                        <div class="settings-group-title">
                            <span><?php echo Text::_('BRAND'); ?></span>
                        </div>
                        <div class="ba-settings-item colors-item" data-variable="@primary">
                            <span class="color-varibles-color-swatch"></span>
                            <span><?php echo Text::_('PRIMARY'); ?></span>
                        </div>
                        <div class="ba-settings-item colors-item" data-variable="@secondary">
                            <span class="color-varibles-color-swatch"></span>
                            <span><?php echo Text::_('SECONDARY'); ?></span>
                        </div>
                        <div class="ba-settings-item colors-item" data-variable="@accent">
                            <span class="color-varibles-color-swatch"></span>
                            <span><?php echo Text::_('ACCENT'); ?></span>
                        </div>
                    </div>
                    <div class="ba-settings-group colors-wrapper">
                        <div class="settings-group-title">
                            <span><?php echo Text::_('TYPOGRAPHY'); ?></span>
                        </div>
                        <div class="ba-settings-item colors-item" data-variable="@title">
                            <span class="color-varibles-color-swatch"></span>
                            <span><?php echo Text::_('TITLE'); ?></span>
                        </div>
                        <div class="ba-settings-item colors-item" data-variable="@subtitle">
                            <span class="color-varibles-color-swatch"></span>
                            <span><?php echo Text::_('SUBTITLE'); ?></span>
                        </div>
                        <div class="ba-settings-item colors-item" data-variable="@text">
                            <span class="color-varibles-color-swatch"></span>
                            <span><?php echo Text::_('TEXT'); ?></span>
                        </div>
                        <div class="ba-settings-item colors-item" data-variable="@icon">
                            <span class="color-varibles-color-swatch"></span>
                            <span><?php echo Text::_('ICON'); ?></span>
                        </div>
                        <div class="ba-settings-item colors-item" data-variable="@title-inverse">
                            <span class="color-varibles-color-swatch"></span>
                            <span><?php echo Text::_('TITLE_INVERSE'); ?></span>
                        </div>
                        <div class="ba-settings-item colors-item" data-variable="@text-inverse">
                            <span class="color-varibles-color-swatch"></span>
                            <span><?php echo Text::_('TEXT_INVERSE'); ?></span>
                        </div>
                    </div>
                    <div class="ba-settings-group colors-wrapper">
                        <div class="settings-group-title">
                            <span><?php echo Text::_('BACKGROUND'); ?></span>
                        </div>
                        <div class="ba-settings-item colors-item" data-variable="@bg-primary">
                            <span class="color-varibles-color-swatch"></span>
                            <span><?php echo Text::_('PRIMARY'); ?></span>
                        </div>
                        <div class="ba-settings-item colors-item" data-variable="@bg-secondary">
                            <span class="color-varibles-color-swatch"></span>
                            <span><?php echo Text::_('SECONDARY'); ?></span>
                        </div>
                        <div class="ba-settings-item colors-item" data-variable="@bg-dark">
                            <span class="color-varibles-color-swatch"></span>
                            <span><?php echo Text::_('DARK'); ?></span>
                        </div>
                        <div class="ba-settings-item colors-item" data-variable="@bg-dark-accent">
                            <span class="color-varibles-color-swatch"></span>
                            <span><?php echo Text::_('DARK_ACCENT'); ?></span>
                        </div>
                    </div>
                    <div class="ba-settings-group colors-wrapper">
                        <div class="settings-group-title">
                            <span><?php echo Text::_('OTHER'); ?></span>
                        </div>
                        <div class="ba-settings-item colors-item" data-variable="@border">
                            <span class="color-varibles-color-swatch"></span>
                            <span><?php echo Text::_('BORDER'); ?></span>
                        </div>
                        <div class="ba-settings-item colors-item" data-variable="@shadow">
                            <span class="color-varibles-color-swatch"></span>
                            <span><?php echo Text::_('SHADOW'); ?></span>
                        </div>
                        <div class="ba-settings-item colors-item" data-variable="@overlay">
                            <span class="color-varibles-color-swatch"></span>
                            <span><?php echo Text::_('OVERLAY'); ?></span>
                        </div>
                        <div class="ba-settings-item colors-item" data-variable="@hover">
                            <span class="color-varibles-color-swatch"></span>
                            <span><?php echo Text::_('HOVER'); ?></span>
                        </div>
                    </div>
                    <div class="ba-settings-group colors-wrapper">
                        <div class="settings-group-title">
                            <span><?php echo Text::_('CUSTOM_COLORS'); ?></span>
                        </div>
                        <div class="ba-settings-item colors-item" data-variable="@color-1">
                            <span class="color-varibles-color-swatch"></span>
                            <span><?php echo Text::_('COLOR'); ?> 1</span>
                        </div>
                        <div class="ba-settings-item colors-item" data-variable="@color-2">
                            <span class="color-varibles-color-swatch"></span>
                            <span><?php echo Text::_('COLOR'); ?> 2</span>
                        </div>
                        <div class="ba-settings-item colors-item" data-variable="@color-3">
                            <span class="color-varibles-color-swatch"></span>
                            <span><?php echo Text::_('COLOR'); ?> 3</span>
                        </div>
                        <div class="ba-settings-item colors-item" data-variable="@color-4">
                            <span class="color-varibles-color-swatch"></span>
                            <span><?php echo Text::_('COLOR'); ?> 4</span>
                        </div>
                        <div class="ba-settings-item colors-item" data-variable="@color-5">
                            <span class="color-varibles-color-swatch"></span>
                            <span><?php echo Text::_('COLOR'); ?> 5</span>
                        </div>
                        <div class="ba-settings-item colors-item" data-variable="@color-6">
                            <span class="color-varibles-color-swatch"></span>
                            <span><?php echo Text::_('COLOR'); ?> 6</span>
                        </div>
                        <div class="ba-settings-item colors-item" data-variable="@color-7">
                            <span class="color-varibles-color-swatch"></span>
                            <span><?php echo Text::_('COLOR'); ?> 7</span>
                        </div>
                        <div class="ba-settings-item colors-item" data-variable="@color-8">
                            <span class="color-varibles-color-swatch"></span>
                            <span><?php echo Text::_('COLOR'); ?> 8</span>
                        </div>
                    </div>
                </div>
                <div id="theme-background-options" class="row-fluid tab-pane">
                    <div class="ba-settings-group">
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('TYPE'); ?>
                            </span>
                            <div class="ba-custom-select background-select" data-callback="themeRules">
                                <input readonly onfocus="this.blur()" value="<?php echo Text::_('COLOR'); ?>" type="text">
                                <input type="hidden" value="color">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="color"><?php echo Text::_('COLOR'); ?></li>
                                    <li data-value="gradient"><?php echo Text::_('GRADIENT'); ?></li>
                                    <li data-value="image"><?php echo Text::_('IMAGE'); ?></li>
                                    <li data-value="video"><?php echo Text::_('VIDEO'); ?></li>
                                    <li data-value="none"><?php echo Text::_('NO_NE'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="background-options">
                            <div class="color-options">
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('COLOR'); ?>
                                    </span>
                                    <input type="text" data-type="color" class="minicolors-input"
                                           data-option="color" data-group="background">
                                    <span class="minicolors-opacity-wrapper">
                                        <input type="number" class="minicolors-opacity" data-callback="themeRules"
                                               min="0" max="1" step="0.01">
                                        <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                                    </span>
                                </div>
                            </div>
                            <div class="image-options" style="display: none;">
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('UPLOAD_BG_IMAGE'); ?>
                                    </span>
                                    <input type="text" class="select-input" readonly onfocus="this.blur()"
                                           data-type="upload-image" data-option="image" data-subgroup="image"
                                           data-group="background" placeholder="<?php echo Text::_('SELECT'); ?>"
                                           data-action="themeRules">
                                    <i class="zmdi zmdi-attachment-alt"></i>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('ATTACHMENT'); ?>
                                    </span>
                                    <div class="ba-custom-select attachment">
                                        <input readonly onfocus="this.blur()" value="fixed" type="text">
                                        <input type="hidden" value="fixed" data-option="attachment" data-group="image"
                                               data-action="themeRules">
                                        <i class="zmdi zmdi-caret-down"></i>
                                        <ul>
                                            <li data-value="fixed">Fixed</li>
                                            <li data-value="scroll">Scroll</li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('SIZE'); ?>
                                    </span>
                                    <div class="ba-custom-select backround-size">
                                        <input readonly onfocus="this.blur()" value="cover" type="text">
                                        <input type="hidden" value="cover" data-option="size" data-group="image"
                                               data-action="themeRules">
                                        <i class="zmdi zmdi-caret-down"></i>
                                        <ul>
                                            <li data-value="cover">Cover</li>
                                            <li data-value="contain">Contain</li>
                                            <li data-value="initial">Auto</li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="contain-size-options" style="display: none;">
                                    <div class="ba-settings-item">
                                        <span>
                                            <?php echo Text::_('POSITION'); ?>
                                        </span>
                                        <div class="ba-custom-select backround-position">
                                            <input readonly onfocus="this.blur()" value="center center" type="text">
                                            <input type="hidden" value="center center" data-option="position" data-group="image"
                                                   data-action="themeRules">
                                            <i class="zmdi zmdi-caret-down"></i>
                                            <ul>
                                                <li data-value="left top">Left Top</li>
                                                <li data-value="left center">Left Center</li>
                                                <li data-value="left bottom">Left Bottom</li>
                                                <li data-value="right top">Right Top</li>
                                                <li data-value="right center">Right Center</li>
                                                <li data-value="right bottom">Right Bottom</li>
                                                <li data-value="center top">Center Top</li>
                                                <li data-value="center center">Center Center</li>
                                                <li data-value="center bottom">Center Bottom</li>
                                            </ul>
                                        </div>
                                    </div>
                                    <div class="ba-settings-item">
                                        <span>
                                            <?php echo Text::_('REPEAT'); ?>
                                        </span>
                                        <div class="ba-custom-select backround-repeat">
                                            <input readonly onfocus="this.blur()" value="no-repeat" type="text">
                                            <input type="hidden" value="no-repeat" data-option="repeat" data-group="image"
                                                   data-action="themeRules">
                                            <i class="zmdi zmdi-caret-down"></i>
                                            <ul>
                                                <li data-value="repeat">Repeat</li>
                                                <li data-value="repeat-x">Repeat-x</li>
                                                <li data-value="repeat-y">Repeat-y</li>
                                                <li data-value="no-repeat">No-repeat</li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="gradient-options" style="display: none;">
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('EFFECT'); ?>
                                    </span>
                                    <div class="ba-custom-select gradient-effect-select">
                                        <input readonly onfocus="this.blur()" value="" type="text">
                                        <input type="hidden" value="" data-property="background" data-callback="themeRules">
                                        <i class="zmdi zmdi-caret-down"></i>
                                        <ul>
                                            <li data-value="linear">Linear</li>
                                            <li data-value="radial">Radial</li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="ba-settings-item background-linear-gradient">
                                    <span>
                                        <?php echo Text::_('ANGLE'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner"></span>
                                        <input type="range" class="ba-range" min="0" max="360" step="1">
                                        <input type="number" data-option="angle" data-group="background" data-subgroup="gradient"
                                               step="1" data-callback="themeRules">
                                    </div>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('START_COLOR'); ?>
                                    </span>
                                    <input type="text" data-type="color" class="minicolors-input"
                                           data-option="color1" data-group="background" data-subgroup="gradient">
                                    <span class="minicolors-opacity-wrapper">
                                        <input type="number" class="minicolors-opacity" data-callback="themeRules"
                                               min="0" max="1" step="0.01">
                                        <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                                    </span>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('POSITION'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner"></span>
                                        <input type="range" class="ba-range" min="0" max="100" step="1">
                                        <input type="number" data-option="position1" data-group="background" data-subgroup="gradient"
                                               step="1" data-callback="themeRules">
                                    </div>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('END_COLOR'); ?>
                                    </span>
                                    <input type="text" data-type="color" class="minicolors-input" data-option="color2"
                                           data-group="background" data-subgroup="gradient">
                                    <span class="minicolors-opacity-wrapper">
                                        <input type="number" class="minicolors-opacity" data-callback="themeRules"
                                               min="0" max="1" step="0.01">
                                        <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                                    </span>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('POSITION'); ?>
                                    </span>
                                    <div class="ba-range-wrapper">
                                        <span class="ba-range-liner"></span>
                                        <input type="range" class="ba-range" min="0" max="100" step="1">
                                        <input type="number" data-option="position2" data-group="background" data-subgroup="gradient"
                                               step="1" data-callback="themeRules">
                                    </div>
                                </div>
                            </div>
                            <div class="video-options desktop-only" style="display: none;">
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('VIDEO_SOURCE'); ?>
                                    </span>
                                    <div class="ba-custom-select video-select">
                                        <input readonly onfocus="this.blur()" value="Youtube" type="text">
                                        <input type="hidden" value="youtube" data-option="video-type" data-group="background">
                                        <i class="zmdi zmdi-caret-down"></i>
                                        <ul>
                                            <li data-value="youtube">Youtube</li>
                                            <li data-value="vimeo">Vimeo</li>
                                            <li data-value="source"><?php echo Text::_('SOURCE_FILE'); ?></li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="ba-settings-item video-id">
                                    <span>
                                        <?php echo Text::_('VIDEO_ID'); ?>
                                    </span>
                                    <input type="text" data-option="id" data-group="background"
                                           placeholder="<?php echo Text::_('VIDEO_ID'); ?>">
                                </div>
                                <div class="ba-settings-item video-source-select">
                                    <span>
                                        <?php echo Text::_('SOURCE_FILE'); ?>
                                    </span>
                                    <input type="text" class="select-input" readonly onfocus="this.blur()" data-option="source"
                                           placeholder="<?php echo Text::_('SELECT'); ?>">
                                    <i class="zmdi zmdi-attachment-alt"></i>
                                    <label class="ba-help-icon">
                                        <i class="zmdi zmdi-help"></i>
                                        <span class="ba-tooltip ba-help">
                                            <?php echo Text::_('SOURCE_FILE_TOOLTIP'); ?>
                                        </span>
                                    </label>
                                </div>
                                <div class="ba-settings-item">
                                    <span>
                                        <?php echo Text::_('START'); ?>
                                    </span>
                                    <input type="text" data-option="start" data-group="background"
                                           placeholder="<?php echo Text::_('START'); ?>">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="ba-settings-group hide-megamenu-options-border">
                        <div class="settings-group-title">
                            <i class="zmdi zmdi-format-color-fill"></i>
                            <span><?php echo Text::_('OVERLAY'); ?></span>
                        </div>
                        <div class="ba-settings-item">
                            <span>
                                <?php echo Text::_('TYPE'); ?>
                            </span>
                            <div class="ba-custom-select background-overlay-select">
                                <input readonly onfocus="this.blur()" type="text">
                                <input type="hidden" data-property="overlay" data-callback="themeRules">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="color"><?php echo Text::_('COLOR'); ?></li>
                                    <li data-value="gradient"><?php echo Text::_('GRADIENT'); ?></li>
                                    <li data-value="none"><?php echo Text::_('NO_NE'); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="overlay-color-options">
                            <div class="ba-settings-item">
                                <span>
                                    <?php echo Text::_('COLOR'); ?>
                                </span>
                                <input type="text" data-type="color" class="minicolors-input"
                                       data-option="color" data-group="overlay">
                                <span class="minicolors-opacity-wrapper">
                                    <input type="number" class="minicolors-opacity" data-callback="themeRules"
                                           min="0" max="1" step="0.01">
                                    <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                                </span>
                            </div>
                        </div>
                        <div class="overlay-gradient-options">
                            <div class="ba-settings-item">
                                <span>
                                    <?php echo Text::_('EFFECT'); ?>
                                </span>
                                <div class="ba-custom-select gradient-effect-select">
                                    <input readonly onfocus="this.blur()" value="" type="text">
                                    <input type="hidden" value="" data-property="overlay" data-callback="themeRules">
                                    <i class="zmdi zmdi-caret-down"></i>
                                    <ul>
                                        <li data-value="linear">Linear</li>
                                        <li data-value="radial">Radial</li>
                                    </ul>
                                </div>
                            </div>
                            <div class="ba-settings-item overlay-linear-gradient">
                                <span>
                                    <?php echo Text::_('ANGLE'); ?>
                                </span>
                                <div class="ba-range-wrapper">
                                    <span class="ba-range-liner"></span>
                                    <input type="range" class="ba-range" min="0" max="360" step="1">
                                    <input type="number" data-option="angle" data-group="overlay" data-subgroup="gradient"
                                           step="1" data-callback="themeRules">
                                </div>
                            </div>
                            <div class="ba-settings-item">
                                <span>
                                    <?php echo Text::_('START_COLOR'); ?>
                                </span>
                                <input type="text" data-type="color" class="minicolors-input"
                                       data-option="color1" data-group="overlay" data-subgroup="gradient">
                                <span class="minicolors-opacity-wrapper">
                                    <input type="number" class="minicolors-opacity" data-callback="themeRules"
                                           min="0" max="1" step="0.01">
                                    <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                                </span>
                            </div>
                            <div class="ba-settings-item">
                                <span>
                                    <?php echo Text::_('POSITION'); ?>
                                </span>
                                <div class="ba-range-wrapper">
                                    <span class="ba-range-liner"></span>
                                    <input type="range" class="ba-range" min="0" max="100" step="1">
                                    <input type="number" data-option="position1" data-group="overlay" data-subgroup="gradient"
                                           step="1" data-callback="themeRules">
                                </div>
                            </div>
                            <div class="ba-settings-item">
                                <span>
                                    <?php echo Text::_('END_COLOR'); ?>
                                </span>
                                <input type="text" data-type="color" class="minicolors-input" data-option="color2"
                                       data-group="overlay" data-subgroup="gradient">
                                <span class="minicolors-opacity-wrapper">
                                    <input type="number" class="minicolors-opacity" data-callback="themeRules"
                                           min="0" max="1" step="0.01">
                                    <span class="ba-tooltip"><?php echo Text::_('OPACITY') ?></span>
                                </span>
                            </div>
                            <div class="ba-settings-item">
                                <span>
                                    <?php echo Text::_('POSITION'); ?>
                                </span>
                                <div class="ba-range-wrapper">
                                    <span class="ba-range-liner"></span>
                                    <input type="range" class="ba-range" min="0" max="100" step="1">
                                    <input type="number" data-option="position2" data-group="overlay" data-subgroup="gradient"
                                           step="1" data-callback="themeRules">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <i class="zmdi zmdi-more resize-handle-bottom"></i>
            </div>
        </div>
    </div>
</div>