<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

use Balbooa\Component\Gridbox\Site\Helper\GridboxHelper;
use Joomla\CMS\Language\Text;

defined('_JEXEC') or die;

ob_start();
$obj->items->{'item-'.$now} = GridboxHelper::getOptions($layout);
$eventTime = time();
$eventData = GridboxHelper::renderEventCalendarData($eventTime);
?>
<div class="ba-item-event-calendar ba-item" id="<?php echo 'item-'.$now; ?>">
	<div class="event-calendar-wrapper" data-year="<?php echo $eventData->year; ?>" data-month="<?php echo $eventData->month; ?>">
        <div class="ba-event-calendar-title-wrapper">
            <i class="ba-icons ba-icon-chevron-left" tabindex="0" data-action="prev"></i>
            <span class="ba-event-calendar-title"><?php echo $eventData->title; ?></span>
            <i class="ba-icons ba-icon-chevron-right" tabindex="0" data-action="next"></i>
        </div>
        <div class="ba-event-calendar-header">
            <?php echo $eventData->header; ?>
        </div>
        <div class="ba-event-calendar-body">
            <?php echo $eventData->body; ?>
        </div>
    </div>
	<div class="ba-edit-item">
        <span class="ba-edit-wrapper edit-settings">
            <i class="zmdi zmdi-settings"></i>
            <span class="ba-tooltip tooltip-delay">
                <?php echo Text::_("ITEM"); ?>
            </span>
        </span>
        <div class="ba-buttons-wrapper">
            <span class="ba-edit-wrapper">
                <i class="zmdi zmdi-edit edit-item"></i>
                <span class="ba-tooltip tooltip-delay settings-tooltip">
                    <?php echo Text::_("EDIT"); ?>
                </span>
            </span>
            <span class="ba-edit-wrapper">
                <i class="zmdi zmdi-copy copy-item"></i>
                <span class="ba-tooltip tooltip-delay settings-tooltip">
                    <?php echo Text::_("COPY_ITEM"); ?>
                </span>
            </span>
            <span class="ba-edit-wrapper">
                <i class="zmdi zmdi-globe add-library"></i>
                <span class="ba-tooltip tooltip-delay settings-tooltip">
                    <?php echo Text::_("ADD_TO_LIBRARY"); ?>
                </span>
            </span>
            <span class="ba-edit-wrapper">
                <i class="zmdi zmdi-delete delete-item"></i>
                <span class="ba-tooltip tooltip-delay settings-tooltip">
                    <?php echo Text::_("DELETE_ITEM"); ?>
                </span>
            </span>
            <span class="ba-edit-text">
                <?php echo Text::_("ITEM"); ?>
            </span>
        </div>
    </div>
    <div class="ba-box-model">
        <div class="ba-bm-top"></div>
        <div class="ba-bm-left"></div>
        <div class="ba-bm-bottom"></div>
        <div class="ba-bm-right"></div>
    </div>
</div>
<?php
$out = ob_get_contents();
ob_end_clean();