<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

use Balbooa\Component\Gridbox\Site\Helper\GridboxHelper;
use Joomla\CMS\Language\Text;

defined('_JEXEC') or die;

ob_start();
if (!GridboxHelper::$commentUser) {
    $tabindex = -1;
    $placeholder = 'PLEASE_LOGIN_TO_COMMENT';
} else {
    $tabindex = 0;
    $placeholder = 'WRITE_COMMENT_HERE';
}
?>
<textarea aria-label="<?php echo Text::_('ENTER_COMMENT'); ?>" placeholder="<?php echo Text::_($placeholder); ?>" class="ba-comment-message"></textarea>
<div class="ba-comment-xhr-attachment-wrapper"></div>
<div class="ba-comments-icons-wrapper">
    <i class="ba-icons ba-icon-smile ba-comment-smiles-picker" tabindex="<?php echo $tabindex; ?>"></i>
<?php
    if (GridboxHelper::$website->enable_attachment == 1) {
?>
    <span class="ba-comments-attachments-wrapper">
        <span class="ba-comments-attachment-file-wrapper" data-type="file">
            <i class="ba-icons ba-icon-attachment ba-comment-attachment-trigger" tabindex="<?php echo $tabindex; ?>"></i>
            <input aria-label="<?php echo Text::_('ATTACH_FILES'); ?>" class="ba-comment-attachment" type="file" style="display: none !important;" multiple
                data-size="<?php echo GridboxHelper::$website->attachment_size; ?>"
                data-types="<?php echo GridboxHelper::$website->attachment_types; ?>" data-attach="file">
        </span>
        <span class="ba-comments-attachment-file-wrapper" data-type="image">
            <i class="ba-icons ba-icon-camera ba-comment-attachment-trigger" tabindex="<?php echo $tabindex; ?>"></i>
            <input aria-label="<?php echo Text::_('ATTACH_IMAGES'); ?>" class="ba-comment-attachment" type="file" style="display: none !important;" multiple
                data-size="<?php echo GridboxHelper::$website->attachment_size; ?>"
                data-types="gif, jpg, jpeg, png, svg, webp" data-attach="image">
        </span>
    </span>
<?php
    }
?>
</div>
<div class="ba-comments-captcha-wrapper">
    
</div>
<span class="ba-submit-comment-wrapper">
    <span class="ba-submit-comment" tabindex="<?php echo $tabindex; ?>" data-type="submit"><?php echo Text::_('COMMENT'); ?></span>
</span>
<?php
$string = ob_get_contents();
ob_end_clean();