<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

use Joomla\CMS\Language\Text;

defined('_JEXEC') or die;

ob_start();
?>
<div class="ba-forgot-password-wrapper" data-wrapper="forgot-password" style="display: none;">
    <span class="ba-login-headline"><?php echo Text::_('FORGOT_PASSWORD'); ?></span>
    <span class="ba-login-description"><?php echo Text::_('FORGOT_PASSWORD_DESCRIPTION'); ?></span>
    <div class="ba-login-fields-wrapper">
        <div class="ba-login-field-wrapper">
            <span class="ba-login-field-label"><?php echo Text::_('EMAIL'); ?></span>
            <input aria-label="<?php echo Text::_('ENTER_EMAIL'); ?>" class="ba-login-field" type="email">
        </div>
    </div>
<?php
if ($view != 'gridbox' && !empty(self::$editItem->options->recaptcha)) {
?>
    <div class="ba-login-captcha-wrapper" data-type="<?php echo self::$editItem->options->recaptcha; ?>">
        
    </div>
<?php
}
?>
    <div class="ba-login-btn-wrapper">
        <span class="ba-login-btn" tabindex="0" data-action="remindPassword"><?php echo Text::_('SUBMIT'); ?></span>
    </div>
    <div class="ba-login-footer-wrapper">
        <span class="ba-login-field-label" tabindex="0" data-step="login"><?php echo Text::_('BACK_TO_LOGIN'); ?></span>
    </div>
</div>
<div class="ba-password-request-wrapper" data-wrapper="password-request" style="display: none;">
    <span class="ba-login-headline"><?php echo Text::_('PASSWORD_RESET'); ?></span>
    <span class="ba-login-description"><?php echo Text::_('EMAIL_HAS_SENT_TO_YOUR_EMAIL_ADDRESS'); ?></span>
    <div class="ba-login-fields-wrapper">
        <div class="ba-login-field-wrapper">
            <span class="ba-login-field-label"><?php echo Text::_('USERNAME'); ?></span>
            <input aria-label="<?php echo Text::_('ENTER_USERNAME'); ?>"
                   class="ba-login-field" type="text" name="username">
        </div>
        <div class="ba-login-field-wrapper">
            <span class="ba-login-field-label"><?php echo Text::_('VERIFICATION_CODE'); ?></span>
            <input aria-label="<?php echo Text::_('VERIFICATION_CODE'); ?>"
                   class="ba-login-field" type="text" name="code">
        </div>
    </div>
    <div class="ba-login-btn-wrapper">
        <span class="ba-login-btn" tabindex="0" data-action="requestPassword"><?php echo Text::_('SUBMIT'); ?></span>
    </div>
    <div class="ba-login-footer-wrapper">
        <span class="ba-login-field-label" tabindex="0" data-step="login"><?php echo Text::_('BACK_TO_LOGIN'); ?></span>
    </div>
</div>
<div class="ba-password-reset-wrapper" data-wrapper="password-reset" style="display: none;">
    <span class="ba-login-headline"><?php echo Text::_('PASSWORD_RESET'); ?></span>
    <span class="ba-login-description"><?php echo Text::_('ENTER_NEW_PASSWORD'); ?></span>
    <div class="ba-login-fields-wrapper">
        <div class="ba-login-field-wrapper">
            <span class="ba-login-field-label"><?php echo Text::_('PASSWORD'); ?></span>
            <input type="hidden" name="id">
            <input aria-label="<?php echo Text::_('ENTER_PASSWORD'); ?>"
                   class="ba-login-field" type="password" name="password1">
        </div>
        <div class="ba-login-field-wrapper">
            <span class="ba-login-field-label"><?php echo Text::_('CONFIRM_PASSWORD'); ?></span>
            <input aria-label="<?php echo Text::_('CONFIRM_PASSWORD'); ?>"
                   class="ba-login-field" type="password" name="password2">
        </div>
    </div>
    <div class="ba-login-btn-wrapper">
        <span class="ba-login-btn" tabindex="0" data-action="resetPassword"><?php echo Text::_('SUBMIT'); ?></span>
    </div>
    <div class="ba-login-footer-wrapper">
        <span class="ba-login-field-label" tabindex="0" data-step="login"><?php echo Text::_('BACK_TO_LOGIN'); ?></span>
    </div>
</div>
<div class="ba-password-successful-reset-wrapper" data-wrapper="password-successful-reset" style="display: none;">
    <span class="ba-login-headline"><?php echo Text::_('PASSWORD_RESET'); ?></span>
    <span class="ba-login-description"><?php echo Text::_('RESET_PASSWORD_SUCCESSFUL'); ?></span>
    <div class="ba-login-footer-wrapper">
        <span class="ba-login-field-label" tabindex="0" data-step="login"><?php echo Text::_('BACK_TO_LOGIN'); ?></span>
    </div>
</div>
<?php
$out = ob_get_contents();
ob_end_clean();