<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

use Balbooa\Component\Gridbox\Site\Helper\GridboxHelper;
use Joomla\CMS\Language\Text;

defined('_JEXEC') or die;

ob_start();
if (!GridboxHelper::$commentUser) {
    $tabindex = -1;
    $placeholder = 'PLEASE_LOGIN_TO_REVIEW';
} else {
    $tabindex = 0;
    $placeholder = 'WRITE_REVIEW_HERE';
}
?>
<textarea aria-label="<?php echo Text::_('ENTER_REVIEW'); ?>" placeholder="<?php echo Text::_($placeholder); ?>" class="ba-comment-message"></textarea>
<div class="ba-comment-xhr-attachment-wrapper"></div>
<div class="ba-comments-icons-wrapper">
<?php
    if (GridboxHelper::$website->reviews_enable_attachment == 1) {
?>
    <span class="ba-comments-attachments-wrapper">
        <span class="ba-comments-attachment-file-wrapper" data-type="image">
            <i class="ba-icons ba-icon-camera ba-comment-attachment-trigger" tabindex="<?php echo $tabindex; ?>"></i>
            <input aria-label="<?php echo Text::_('ATTACH_IMAGES'); ?>" class="ba-comment-attachment" type="file" style="display: none !important;" multiple
                data-size="<?php echo GridboxHelper::$website->reviews_attachment_size; ?>"
                data-types="gif, jpg, jpeg, png, svg, webp" data-attach="image">
            <span class="ba-comment-attachment-trigger"><?php echo Text::_('UPLOAD_PHOTOS'); ?></span>
        </span>
    </span>
<?php
    }
?>
</div>
<div class="ba-comments-captcha-wrapper">
    
</div>
<span class="ba-submit-comment-wrapper">
    <span class="ba-submit-cancel" tabindex="0"><?php echo Text::_('CANCEL'); ?></span>
    <span class="ba-submit-comment" tabindex="<?php echo $tabindex; ?>" data-type="submit"><?php echo Text::_('SUBMIT_REVIEW'); ?></span>
</span>
<?php
$string = ob_get_contents();
ob_end_clean();