<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

use Joomla\CMS\Language\Text;

defined('_JEXEC') or die;

$thousand = $currency->thousand;
$separator = $currency->separator;
$decimals = $currency->decimals;
$position = $currency->position;
$symbol = $currency->symbol;

ob_start();
?>
<div class="ba-store-wishlist-backdrop">
    <div class="ba-store-wishlist-close"></div>
    <div class="ba-store-wishlist ba-container">
        <div class="row-fluid">
            <div class="ba-wishlist-headline-wrapper">
                <span class="ba-wishlist-headline"><?php echo Text::_('WISHLIST'); ?></span>
            </div>
            <div class="ba-store-wishlist-close-wrapper">
                <i class="ba-icons ba-icon-close ba-store-wishlist-close" tabindex="0"
                   aria-label="<?php echo Text::_('CLOSE_WISHLIST'); ?>"></i>
            </div>
        <?php include JPATH_ROOT.'/components/com_gridbox/tmpl/layout/patterns/store/wishlist-products-list.php'; ?>
        <?php if (!$wishlist->empty) : ?>
            <div class="ba-wishlist-checkout">
                <div class="ba-wishlist-checkout-row">
                    <span class="ba-wishlist-checkout-title ba-clear-wishlist" tabindex="0"
                          aria-label="<?php echo Text::_('CLEAR_MY_WISHLIST'); ?>">
                        <?php echo Text::_('CLEAR_MY_WISHLIST'); ?>
                    </span>
                </div>
                <div class="ba-wishlist-checkout-row ba-wishlist-btn-wrapper" data-exists="<?php echo $existsProducts; ?>">
                    <span class="ba-wishlist-add-all-btn" tabindex="0"
                          aria-label="<?php echo Text::_('ADD_ALL_TO_CART'); ?>">
                        <?php echo Text::_('ADD_ALL_TO_CART'); ?>
                    </span>
                </div>
            </div>
        <?php endif; ?>
        </div>
    </div>
</div>
<?php
$out = ob_get_contents();
ob_end_clean();