<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

use Balbooa\Component\Gridbox\Site\Helper\GridboxHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Uri\Uri;

defined('_JEXEC') or die;

$user = Factory::getUser();
if ($this->item->type == 'submission-form' && strpos($this->item->html, 'data-texteditor="texteditor"')) {
?>
<link rel="stylesheet" type="text/css" href="<?php echo Uri::root(); ?>components/com_gridbox/libraries/ckeditor/css/ckeditor.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/ckeditor/4.5.0/ckeditor.js"></script>
<script src="<?php echo Uri::root(); ?>components/com_gridbox/libraries/ckeditor/js/justifyLeft.js"></script>
<script>
    if ($g('html').attr('dir') == 'rtl') {
        CKEDITOR.config.contentsLangDirection = 'rtl';
    }
    CKEDITOR.config.forcePasteAsPlainText = true;
    CKEDITOR.dtd.$removeEmpty.span = 0;
    CKEDITOR.dtd.$removeEmpty.i = 0;
    CKEDITOR.config.uiColor = '#fafafa';
    CKEDITOR.config.allowedContent = true;
    CKEDITOR.config.removePlugins = 'elementspath';
    CKEDITOR.config.toolbar_Basic = [
        {name: 'styles', items: ['Format']},
        {name: 'clipboard', items: ['Undo','Redo']},
        {name: 'basicstyles', items: ['Bold','Italic','Underline']},
        {name: 'paragraph', items: ['NumberedList', 'BulletedList', 'Blockquote', 'myJustifyLeft', 'JustifyCenter','JustifyRight', 'JustifyBlock']},
        {name: 'links', items: ['Link', 'Unlink']},
        {name: 'insert', items: ['Image',]},
    ];
    CKEDITOR.config.toolbar = 'Basic';
</script>
<?php
} else if ($this->item->type == 'checkout' && GridboxHelper::$store->checkout->login && empty($user->id)) {
?>
<div class="ba-checkout-authentication-backdrop">
    <i class="ba-icons ba-icon-close ba-leave-checkout" tabindex="0"></i>
    <div class="ba-checkout-authentication-wrapper">
        <div class="ba-checkout-login-wrapper" data-wrapper="login">
            <div class="ba-checkout-authentication-title">
                <span><?php echo Text::_('LOGIN'); ?></span>
            </div>
<?php
        if (GridboxHelper::$store->checkout->facebook || GridboxHelper::$store->checkout->google) {
            $hidden = !GridboxHelper::$store->checkout->facebook || !GridboxHelper::$store->checkout->google ? ' ba-login-integrations-hidden-element' : '';
?>
            <div class="ba-login-integrations-wrapper<?php echo $hidden; ?>">
<?php
            if (GridboxHelper::$store->checkout->facebook) {
?>
                <div class="ba-login-integration-btn" tabindex="0" data-integration="facebook">
                    <img src="<?php echo Uri::root(); ?>components/com_gridbox/assets/images/social-login/facebook-logo.svg"
                         alt="<?php echo Text::_('LOGIN_WITH_FACEBOOK'); ?>">
                    <span>Facebook</span>
                </div>
<?php
            }
            if (GridboxHelper::$store->checkout->google) {
?>
                <div class="ba-login-integration-btn" tabindex="0" data-integration="google">
                    <img src="<?php echo Uri::root(); ?>components/com_gridbox/assets/images/social-login/google-logo.svg"
                         alt="<?php echo Text::_('LOGIN_WITH_GOOGLE'); ?>">
                    <span>Google</span>
                    <div class="ba-google-login-button"></div>
                </div>
<?php
            }
?>
            </div>
            <div class="ba-login-or-wrapper">
                <span class="ba-login-field-label"><?php echo Text::_('OR'); ?></span>
            </div>
<?php
        }
?>
            <div class="ba-checkout-authentication-label">
                <span><?php echo Text::_('USERNAME'); ?></span>
            </div>
            <div class="ba-checkout-authentication-input">
                <input aria-label="ENTER_USERNAME" type="text" name="username">
            </div>
            <div class="ba-checkout-authentication-label">
                <span><?php echo Text::_('PASSWORD'); ?></span>
            </div>
            <div class="ba-checkout-authentication-input">
                <input aria-label="ENTER_PASSWORD" type="password" name="password" autocomplete="new-password">
            </div>
<?php
        if (PluginHelper::isEnabled('system', 'remember')) {
?>
            <div class="ba-checkout-authentication-checkbox">
                <div class="ba-checkbox-wrapper">
                    <span><?php echo Text::_('REMEMBER_ME'); ?></span>
                    <label class="ba-checkbox" aria-label="<?php echo Text::_('REMEMBER_ME'); ?>">
                        <input type="checkbox" name="remember">
                        <span></span>
                    </label>
                </div>
            </div>
<?php
        }
        if (!empty(GridboxHelper::$store->checkout->recaptcha)) {
?>
            <div class="ba-login-captcha-wrapper" data-type="<?php echo GridboxHelper::$store->checkout->recaptcha; ?>">
                
            </div>
<?php
        }
?>
            <div class="ba-checkout-authentication-btn-wrapper">
                <span class="ba-checkout-authentication-btn ba-user-authentication" tabindex="0"><?php echo Text::_('LOGIN'); ?></span>
            </div>
            <div class="ba-checkout-authentication-links">
                <div class="ba-checkout-authentication-forgot-wrapper">
<?php
                if (GridboxHelper::$store->checkout->password) {
?>
                    <a href="#" data-step="forgot-password">
                        <?php echo Text::_('FORGOT_PASSWORD'); ?>
                    </a>
<?php
                }
                if (GridboxHelper::$store->checkout->username) {
?>
                    <a href="#" data-step="forgot-username">
                        <?php echo Text::_('FORGOT_USERNAME'); ?>
                    </a>
<?php
                }
?>                    
                </div>
<?php
            if (GridboxHelper::$store->checkout->registration) {
?>
                <span class="ba-show-registration-dialog" tabindex="0" data-step="create-account"><?php echo Text::_('CREATE_AN_ACCOUNT'); ?></span>
<?php
        }
?>
            </div>
        </div>
<?php
    if (GridboxHelper::$store->checkout->password) {
?>
        <div class="ba-forgot-password-wrapper" data-wrapper="forgot-password" style="display: none;">
            <div class="ba-checkout-authentication-title">
                <span><?php echo Text::_('FORGOT_PASSWORD'); ?></span>
            </div>
            <span class="ba-login-description"><?php echo Text::_('FORGOT_PASSWORD_DESCRIPTION'); ?></span>
            <div class="ba-checkout-authentication-label">
                <span><?php echo Text::_('EMAIL'); ?></span>
            </div>
            <div class="ba-checkout-authentication-input">
                <input aria-label="<?php echo Text::_('ENTER_EMAIL'); ?>" type="text" name="email">
            </div>
<?php
        if (!empty(GridboxHelper::$store->checkout->recaptcha)) {
?>
            <div class="ba-login-captcha-wrapper" data-type="<?php echo GridboxHelper::$store->checkout->recaptcha; ?>">
                
            </div>
<?php
        }
?>
            <div class="ba-checkout-authentication-btn-wrapper">
                <span class="ba-checkout-authentication-btn ba-remind-password-authentication" tabindex="0"><?php echo Text::_('SUBMIT'); ?></span>
            </div>
            <div class="ba-login-footer-wrapper">
                <span class="ba-login-field-label" tabindex="0" data-step="login"><?php echo Text::_('BACK_TO_LOGIN'); ?></span>
            </div>
        </div>
        <div class="ba-password-request-wrapper" data-wrapper="password-request" style="display: none;">
            <div class="ba-checkout-authentication-title">
                <span><?php echo Text::_('PASSWORD_RESET'); ?></span>
            </div>
            <span class="ba-login-description"><?php echo Text::_('EMAIL_HAS_SENT_TO_YOUR_EMAIL_ADDRESS'); ?></span>
            <div class="ba-checkout-authentication-label">
                <span><?php echo Text::_('USERNAME'); ?></span>
            </div>
            <div class="ba-checkout-authentication-input">
                <input aria-label="<?php echo Text::_('ENTER_USERNAME'); ?>" type="text" name="username">
            </div>
            <div class="ba-checkout-authentication-label">
                <span><?php echo Text::_('VERIFICATION_CODE'); ?></span>
            </div>
            <div class="ba-checkout-authentication-input">
                <input aria-label="<?php echo Text::_('VERIFICATION_CODE'); ?>" type="text" name="code">
            </div>
            <div class="ba-checkout-authentication-btn-wrapper">
                <span class="ba-checkout-authentication-btn ba-request-password-authentication" tabindex="0"><?php echo Text::_('SUBMIT'); ?></span>
            </div>
            <div class="ba-login-footer-wrapper">
                <span class="ba-login-field-label" tabindex="0" data-step="login"><?php echo Text::_('BACK_TO_LOGIN'); ?></span>
            </div>
        </div>
        <div class="ba-password-reset-wrapper" data-wrapper="password-reset" style="display: none;">
            <div class="ba-checkout-authentication-title">
                <span><?php echo Text::_('PASSWORD_RESET'); ?></span>
            </div>
            <span class="ba-login-description"><?php echo Text::_('ENTER_NEW_PASSWORD'); ?></span>
            <div class="ba-checkout-authentication-label">
                <span><?php echo Text::_('PASSWORD'); ?> *</span>
            </div>
            <div class="ba-checkout-authentication-input">
                <input type="hidden" name="id">
                <input aria-label="<?php echo Text::_('ENTER_PASSWORD'); ?>" type="password" name="password1">
            </div>
            <div class="ba-checkout-authentication-label">
                <span><?php echo Text::_('CONFIRM_PASSWORD'); ?> *</span>
            </div>
            <div class="ba-checkout-authentication-input">
                <input aria-label="<?php echo Text::_('CONFIRM_PASSWORD'); ?>" type="password" name="password2">
            </div>
            <div class="ba-checkout-authentication-btn-wrapper">
                <span class="ba-checkout-authentication-btn ba-reset-password-authentication" tabindex="0"><?php echo Text::_('SUBMIT'); ?></span>
            </div>
            <div class="ba-login-footer-wrapper">
                <span class="ba-login-field-label" tabindex="0" data-step="login"><?php echo Text::_('BACK_TO_LOGIN'); ?></span>
            </div>
        </div>
        <div class="ba-password-successful-reset-wrapper" data-wrapper="password-successful-reset" style="display: none;">
            <div class="ba-checkout-authentication-title">
                <span><?php echo Text::_('PASSWORD_RESET'); ?></span>
            </div>
            <span class="ba-login-description"><?php echo Text::_('RESET_PASSWORD_SUCCESSFUL'); ?></span>
            <div class="ba-login-footer-wrapper">
                <span class="ba-login-field-label" tabindex="0" data-step="login"><?php echo Text::_('BACK_TO_LOGIN'); ?></span>
            </div>
        </div>
<?php
    }
    if (GridboxHelper::$store->checkout->username) {
?>
        <div class="ba-forgot-username-wrapper" data-wrapper="forgot-username" style="display: none;">
            <div class="ba-checkout-authentication-title">
                <span><?php echo Text::_('FORGOT_USERNAME'); ?></span>
            </div>
            <span class="ba-login-description"><?php echo Text::_('FORGOT_USERNAME_DESCRIPTION'); ?></span>
            <div class="ba-checkout-authentication-label">
                <span><?php echo Text::_('EMAIL'); ?></span>
            </div>
            <div class="ba-checkout-authentication-input">
                <input aria-label="<?php echo Text::_('ENTER_EMAIL'); ?>" type="text" name="email">
            </div>
<?php
        if (!empty(GridboxHelper::$store->checkout->recaptcha)) {
?>
            <div class="ba-login-captcha-wrapper" data-type="<?php echo GridboxHelper::$store->checkout->recaptcha; ?>">
                
            </div>
<?php
        }
?>
            <div class="ba-checkout-authentication-btn-wrapper">
                <span class="ba-checkout-authentication-btn ba-username-authentication" tabindex="0"><?php echo Text::_('SUBMIT'); ?></span>
            </div>
            <div class="ba-login-footer-wrapper">
                <span class="ba-login-field-label" tabindex="0" data-step="login"><?php echo Text::_('BACK_TO_LOGIN'); ?></span>
            </div>
        </div>
        <div class="ba-forgot-username-sended-wrapper" data-wrapper="forgot-username-sended" style="display: none;">
            <div class="ba-checkout-authentication-title">
                <span><?php echo Text::_('FORGOT_USERNAME'); ?></span>
            </div>
            <span class="ba-login-description"><?php echo Text::_('EMAIL_WITH_USERNAME_SENT'); ?></span>
            <div class="ba-login-footer-wrapper">
                <span class="ba-login-field-label" tabindex="0" data-step="login"><?php echo Text::_('BACK_TO_LOGIN'); ?></span>
            </div>
        </div>
<?php
    }
    if (GridboxHelper::$store->checkout->registration) {
?>
        <div class="ba-checkout-registration-wrapper" style="display: none;" data-wrapper="create-account">
            <div class="ba-checkout-authentication-title">
                <span><?php echo Text::_('CREATE_AN_ACCOUNT'); ?></span>
            </div>
<?php
        if (GridboxHelper::$store->checkout->facebook || GridboxHelper::$store->checkout->google) {
            $hidden = !GridboxHelper::$store->checkout->facebook || !GridboxHelper::$store->checkout->google ? ' ba-login-integrations-hidden-element' : '';
?>
            <div class="ba-login-integrations-wrapper<?php echo $hidden; ?>">
<?php
            if (GridboxHelper::$store->checkout->facebook) {
?>
                <div class="ba-login-integration-btn" tabindex="0" data-integration="facebook">
                    <img src="<?php echo Uri::root(); ?>components/com_gridbox/assets/images/social-login/facebook-logo.svg"
                         alt="<?php echo Text::_('LOGIN_WITH_FACEBOOK'); ?>">
                    <span>Facebook</span>
                </div>
<?php
            }
            if (GridboxHelper::$store->checkout->google) {
?>
                <div class="ba-login-integration-btn" tabindex="0" data-integration="google">
                    <img src="<?php echo Uri::root(); ?>components/com_gridbox/assets/images/social-login/google-logo.svg"
                         alt="<?php echo Text::_('LOGIN_WITH_GOOGLE'); ?>">
                    <span>Google</span>
                    <div class="ba-google-login-button"></div>
                </div>
<?php
            }
?>
            </div>
            <div class="ba-login-or-wrapper">
                <span class="ba-login-field-label"><?php echo Text::_('OR'); ?></span>
            </div>
<?php
        }
?>
            <div class="ba-checkout-authentication-label">
                <span><?php echo Text::_('NAME'); ?> *</span>
            </div>
            <div class="ba-checkout-authentication-input">
                <input aria-label="<?php echo Text::_('ENTER_NAME'); ?>" type="text" name="name">
            </div>
            <div class="ba-checkout-authentication-label">
                <span><?php echo Text::_('USERNAME'); ?> *</span>
            </div>
            <div class="ba-checkout-authentication-input">
                <input aria-label="<?php echo Text::_('ENTER_USERNAME'); ?>" type="text" name="username">
            </div>
            <div class="ba-checkout-authentication-label">
                <span><?php echo Text::_('PASSWORD'); ?> *</span>
            </div>
            <div class="ba-checkout-authentication-input">
                <input aria-label="<?php echo Text::_('ENTER_PASSWORD'); ?>" type="password" name="password1">
            </div>
            <div class="ba-checkout-authentication-label">
                <span><?php echo Text::_('CONFIRM_PASSWORD'); ?> *</span>
            </div>
            <div class="ba-checkout-authentication-input">
                <input aria-label="<?php echo Text::_('CONFIRM_PASSWORD'); ?>" type="password" name="password2">
            </div>
            <div class="ba-checkout-authentication-label">
                <span><?php echo Text::_('EMAIL'); ?> *</span>
            </div>
            <div class="ba-checkout-authentication-input">
                <input aria-label="<?php echo Text::_('ENTER_EMAIL'); ?>" type="email" name="email1">
            </div>
<?php
        if (GridboxHelper::$store->checkout->terms) {
?>
            <div class="ba-checkout-authentication-checkbox">
                <div class="ba-checkbox-wrapper">
                    <div><?php echo GridboxHelper::$store->checkout->terms_text; ?></div>
                    <label class="ba-checkbox" aria-label="<?php echo Text::_('ACCEPTANCE_FIELD'); ?>">
                        <input type="checkbox" name="acceptance">
                        <span></span>
                    </label>
                </div>
            </div>
<?php
        }
        if (!empty(GridboxHelper::$store->checkout->recaptcha)) {
?>
            <div class="ba-login-captcha-wrapper" data-type="<?php echo GridboxHelper::$store->checkout->recaptcha; ?>">
                
            </div>
<?php
        }
?>
            <div class="ba-checkout-authentication-btn-wrapper">
                <span class="ba-checkout-authentication-btn ba-user-registration" tabindex="0"><?php echo Text::_('CREATE_AN_ACCOUNT'); ?></span>
            </div>
            <div class="ba-login-footer-wrapper">
                <span class="ba-login-field-label" tabindex="0" data-step="login"><?php echo Text::_('BACK_TO_LOGIN'); ?></span>
            </div>
        </div>
<?php
    }
    if (GridboxHelper::$store->checkout->guest) {
?>
        <div class="ba-checkout-guest-wrapper">
            <div class="ba-checkout-authentication-title">
                <span><?php echo Text::_('GUEST_CHECKOUT'); ?></span>
            </div>
            <div class="ba-checkout-authentication-text">
                <span><?php echo Text::_('PURCHASE_AS_GUEST'); ?></span>
            </div>
            <div class="ba-checkout-authentication-btn-wrapper">
                <span class="ba-checkout-authentication-btn ba-guest-authentication" tabindex="0"><?php echo Text::_('CONTINUE_AS_GUEST'); ?></span>
            </div>
        </div>
<?php
    }
?>
    </div>
</div>
<?php
}
?>
<div class="row-fluid">
<?php
if ($user->authorise('core.edit', 'com_gridbox')) {
?>
    <a class="edit-page-btn" target="_blank"
        href="<?php echo Uri::root().'index.php?option=com_gridbox&view=editor&edit_type=system&tmpl=component&id='.$this->item->id; ?>">
        <i class="ba-icons ba-icon-settings"></i>
        <span class="ba-tooltip ba-top"><?php echo Text::_('EDIT_PAGE'); ?></span>
    </a>
<?php
}
?>
    <div class="ba-gridbox-page row-fluid">
<?php
    if (!empty($this->item)) echo $this->item->html;
?>
    </div>
</div>